<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:template match="/">
<html>
	<head>
	<!-- added by Dadaso pawar on 5 MAR 2013 -->
	<SCRIPT language="Javascript" type="text/javascript" src="/ibase/webitm/js/sundryInfo.js"></SCRIPT>
		<link type="text/css" rel="stylesheet" href="/ibase/css/workflowsign.css"/>
	</head>
	<body>
	
		<div> 
		<table width="100%" class="tTableHeader">	
		<xsl:for-each select="//Detail1">
		<!-- added by Dadaso pawar on 5 MAR 2013 -->
		 <xsl:variable name="sundryCode"><xsl:value-of select="sundry_code"/></xsl:variable>
		 <xsl:variable name="sundryType"><xsl:value-of select="sundry_type"/></xsl:variable>
			<tr>
				<td colspan="4" align="center" class="tTitle">Payable Voucher</td>
			</tr>
			<tr>				
				<td colspan="3">
					<span class="tLabel">Transaction ID : </span>
					<span class="tLabelData"><xsl:value-of select="tran_id"/></span>
				</td>
				<td>
					<span class="tLabel">Transaction Date : </span>
					<span class="tLabelData"><xsl:value-of select="tran_date"/></span>
				</td>
			</tr>
			<tr>
				<td colspan="3">
					<span class="tLabel">Site Code :</span>
					<span class="tLabelData"><xsl:value-of select="site_code" /> [<xsl:value-of select="site_descr" />]</span>
				</td>
								<td>
					<span class="tLabel">Voucher Type :</span>
					<span class="tLabelData"> 
					<xsl:variable name="vouchType"><xsl:value-of select="vouch_type"/></xsl:variable>
						<xsl:choose>
							<xsl:when test="$vouchType = 'N'">
								Training
							</xsl:when>
							<xsl:when test="$vouchType = 'R'">
								Recruitment
							</xsl:when>
							<xsl:when test="$vouchType = 'G'">
								Freight
							</xsl:when>
							<xsl:when test="$vouchType = 'F'">
								Field Staff
							</xsl:when>
							<xsl:when test="$vouchType = 'O'">
								Other Employee
							</xsl:when>
							<xsl:when test="$vouchType = 'E'">
								Expense
							</xsl:when>
							<xsl:when test="$vouchType = 'P'">
								Purchase
							</xsl:when>
							<xsl:when test="$vouchType = 'A'">
								Loan and Advance
							</xsl:when>
							<xsl:when test="$vouchType = 'D'">
								Debit Note
							</xsl:when>
							<xsl:when test="$vouchType = 'C'">
								Credit Note
							</xsl:when>
							<xsl:when test="$vouchType = 'B'">
								SPR Employee
							</xsl:when>
							<xsl:when test="$vouchType = 'H'">
								SPR Others
							</xsl:when>
						</xsl:choose>
					</span>
				</td>				
			</tr>			
			<tr>
				<td colspan="4">
					<span class="tLabel">Cheque Name : </span>
					<span class="tLabelData"><xsl:value-of select="chq_name"/></span>
				</td>				
			</tr>
			<tr>
				<td colspan="2">
					<span class="tLabel">Bill No : </span>
					<span class="tLabelData"><xsl:value-of select="bill_no"/></span>
				</td>
				<td>
					<span class="tLabel">Bill Date : </span>
					<span class="tLabelData"><xsl:value-of select="bill_date"/></span>
				</td>
				<td>
					<span class="tLabel">Order Reference : </span>
					<span class="tLabelData"><xsl:value-of select="order_ref"/></span>
				</td>				
			</tr>
			<tr>
				<td colspan="4">
					<span class="tLabel">Payable To : </span>
					<span class="tLabelData">
					<xsl:if test="sundry_type='S'">Supplier</xsl:if>
					<xsl:if test="sundry_type='C'">Customer</xsl:if>
					<xsl:if test="sundry_type='P'">Sales Person</xsl:if>
					<xsl:if test="sundry_type='B'">Bank</xsl:if>
					<xsl:if test="sundry_type='E'">Employee</xsl:if>
					<xsl:if test="sundry_type='O'">Others</xsl:if>
					<xsl:if test="sundry_type='R'">Strategic Customer</xsl:if>
					<!-- added by Dadaso pawar on 5 MAR 2013 -->
					<xsl:if test="sundry_type='L'">Loan Party</xsl:if>
					<xsl:if test="sundry_type='T'">Transporter</xsl:if>
					<xsl:if test="sundry_type='X'">Tax Authority</xsl:if> 
					
					<xsl:text>&#160;</xsl:text><xsl:value-of select="sundry_code" /> [<xsl:value-of select="sundry_name" />] [<xsl:value-of select="advance" />] 					
					<!-- added by Dadaso pawar on 5 MAR 2013 -->
					<IMG name="sundryinfo" src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" style="width=15;height=15;" onClick="showReference();" />
					<input id="stype" type="hidden" value="{$sundryType}" size ="5"/>
					<input id="scode" type="hidden" value="{$sundryCode}" size ="5"/>
					</span>					
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<span class="tLabel">Remarks : </span>
					<span class="tLabelData"><xsl:value-of select="remarks" /></span>
				</td>
			</tr>
		</xsl:for-each>
		</table>
		</div>
		
		<BR></BR>
				
		<xsl:if test="//Detail3/line_no!=''">
		<div>		
		<table width="100%" class ="tTableDetail"> 	
			<tr>
				<td colspan="13" align="center" class="tTitleD">Detail</td>
			</tr>		
			<tr>
				<td class="tLabelD" rowspan="2">#</td>
				<td class="tLabelD" colspan="3">Ref. Sundry Information</td>
				<td class="tLabelD" rowspan="2">Account</td>
				<td class="tLabelD" rowspan="2">Cost Center</td>
				<td class="tLabelD" rowspan="2">Analysis</td>
				<td class="tLabelD" rowspan="2">Bill No</td>
				<td class="tLabelD" rowspan="2">Bill Date</td>
				<td class="tLabelD" rowspan="2">Bill Amount(Rs.)</td>
				<td class="tLabelD" rowspan="2">Tax Amount</td>
				<td class="tLabelD" rowspan="2">Amount</td>				
			</tr>
			<tr>
				<td class="tLabelD" width="2%">Type </td>
				<td class="tLabelD" width="2%">Code </td>
				<td class="tLabelD" width="10%">Name </td>
			</tr>					
			
			<xsl:for-each select="//Detail3">
			<tr>
				<td class="tLabelDataD"><xsl:value-of select="line_no"/></td>
				<td class="tLabelDataD"><xsl:value-of select="sundry_type__for"/></td>
				<td class="tLabelDataD"><xsl:value-of select="sundry_code__for"/></td>
				<td class="tLabelDataD"><xsl:value-of select="sundry_name"/></td>
				<td class="tLabelDataD"><xsl:value-of select="acct_code"/> [<xsl:value-of select="accounts_descr"/>]</td>
				<td class="tLabelDataD"><xsl:value-of select="cctr_code"/> [<xsl:value-of select="costctr_descr"/>]</td>
				<td class="tLabelDataD"><xsl:value-of select="anal_code"/> [<xsl:value-of select="anal_code"/>]</td>
				<td class="tLabelDataD"><xsl:value-of select="bill_no"/></td>
				<td class="tLabelDataD"><xsl:value-of select="bill_date"/></td>
				<td class="tLabelDataD"><xsl:value-of select="bill_amt"/></td>
				<td class="tLabelDataD"><xsl:value-of select="tax_amt"/></td>
				<td class="tLabelDataD"><xsl:value-of select="amount"/></td>				
			</tr>					
			</xsl:for-each>
		</table>
		</div>
		</xsl:if>			
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
