

package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
//import javax.ejb.SessionBean;
// added for ejb3

@Stateless // added for ejb3

public class TransporterBankDeactivate extends ActionHandlerEJB implements TransporterBankDeactivateLocal, TransporterBankDeactivateRemote //implements SessionBean
{
	
	GenericUtility genericUtility = GenericUtility.getInstance();

	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException
	{
		String returnString=null;

		System.out.println("tranId----"+tranId);

		System.out.println("xtraParams----"+xtraParams);
		System.out.println("forcedFlag----"+forcedFlag);
		if(tranId!=null && tranId.trim().length()>0)
		{
			returnString=deactivate(tranId,xtraParams,forcedFlag);
		}
		return returnString;
	}
   
    public String deactivate(String tranId,String xtraParams, String forcedFlag) throws RemoteException,ITMException
    {
    	System.out.println("<-------Confirmed Called------------->");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        ConnDriver connDriver = null;
		String loginEmpCode = null;
        ibase.webitm.utility.GenericUtility genericUtility = null;
		Document dom = null;
		int count=0;
		ITMDBAccessEJB itmDBAccessEJB = null;
		String errString = null;
		int upd = 0;
		String tranCode="", bankCodeBen="", confTrans="", activeYN="";
        try
		{
        	System.out.println("tran Code"+tranId);
            itmDBAccessEJB = new ITMDBAccessEJB();
			genericUtility = ibase.webitm.utility.GenericUtility.getInstance();
            connDriver = new ConnDriver();
            conn = connDriver.getConnectDB("DriverITM");
            conn.setAutoCommit(false);
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			
			String split[]=tranId.split(":");
			tranCode=split[0];
			bankCodeBen=split[1];
			
			if( errString == null || errString.trim().length() == 0 )
			{
				
				sql = "select confirmed, active_yn from transporter_bank where tran_code =? and bank_code__ben = ?";
					
				pstmt = conn.prepareStatement( sql );
				pstmt.setString(1, tranCode.trim() );
				pstmt.setString(2, bankCodeBen.trim());
				rs = pstmt.executeQuery();
				
				if( rs.next() )
				{
					confTrans=rs.getString(1).trim();
					activeYN=rs.getString(2).trim();
					
				}
				pstmt.close();
				pstmt = null;				
				rs.close();
				rs = null;
				
				if("N".equalsIgnoreCase(activeYN))
				{
					errString = itmDBAccessEJB.getErrorString("","VTALDEACT","","",conn);
				}
//				if("Y".equalsIgnoreCase(confTrans)){
//					
//					errString = itmDBAccessEJB.getErrorString("","VTTNVDEACT","","",conn);
//				}
//			}
//			if( errString == null || errString.trim().length() == 0 )
//			{
//				
				sql = "update transporter_bank set active_yn = 'N' where tran_code = ? and bank_code__ben = ?";
				pstmt = conn.prepareStatement( sql );
				pstmt.setString( 1, tranCode.trim());
				pstmt.setString(2, bankCodeBen.trim());
				pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
			}
            if( errString != null && errString.trim().length() > 0 )
			{
                
                conn.rollback();
                return errString;
            }
			else
			{
				conn.commit();
				errString = itmDBAccessEJB.getErrorString("","VTDEACT","");
			}
            System.out.println("errString : "+errString);
        }catch(ITMException ie)
		{
            try{
				conn.rollback();
			}catch(Exception t){}
            ie.printStackTrace();
            errString = itmDBAccessEJB.getErrorString("","VTUNDEACT","","",conn);
			throw new ITMException( ie );
        	}catch(Exception e){
            try{
				conn.rollback();
			}catch(Exception t){}
            e.printStackTrace();
            errString = itmDBAccessEJB.getErrorString("","VTUNDEACT","","",conn);
			throw new ITMException( e );
        }
		finally
		{
            try{
				if( pstmt != null )
				{
					pstmt.close();
				}
				pstmt = null;
				if(conn != null)
				{
					conn.close();
				}
				conn = null;
            }catch(Exception e){
				e.printStackTrace();
			}
        }
        return errString;
	}
}

