package ibase.dashboard.mfg.servlet;
import ibase.dashboard.mfg.ejb.HalolMFGReleaseRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class HalolMFGReleaseServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		HalolMFGReleaseRemote halolMFGReleaseRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String month = "",geoLoc="";
		
		try
		{
			response.setContentType("application/xml");
			dataSourceName    = request.getParameter("dataSourceName"); 
			month           = (request.getParameter("month"));
			geoLoc           = (request.getParameter("geolocation"));		
			context = new InitialContext(appConnectParm.getProperty());
			halolMFGReleaseRemote       = (HalolMFGReleaseRemote) context.lookup("ibase/HalolMFGRelease/remote");
			JSONObject jsonObjData      = (JSONObject)halolMFGReleaseRemote.getHalolMFGReleaseBatches(dataSourceName,month,geoLoc);			
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set inside HalolMFGReleaseServlet build the Graph is===" + jsonObjData);	
			
		} catch (Exception e)
		{
			System.out.println("Exception : HalolMFGReleaseServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}