<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>

			<body>

				<link type="text/css" rel="stylesheet"
					href="/ibase/webitm/css/PerkClaimProcess.css" />
				<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/fonts.css"></link>
				
				<script type="text/javascript" src="/ibase/webitm/js/jquery-1.11.1.min.js"></script>
				<!-- <script type="text/javascript" src="/ibase/webitm/js/SavexWizard.js"></script> -->
				<script type="text/javascript" src="/ibase/webitm/js/SavexWizardCalendar.js"></script>

				<script type="text/javascript" src="/ibase/webitm/js/GlobalVar.js"></script>
				<script type="text/javascript" src="/ibase/webitm/js/GlobalFunc.js"></script>
				<script type="text/javascript" src="/ibase/webitm/js/StatelessItemChange.js"></script>
				<!--<script type="text/javascript" src="/ibase/webitm/js/PerkProcessWizard.js"></script>-->
				<!-- <script type="text/javascript" src="/ibase/webitm/js/jquery.min.js"></script>-->
				<script type="text/javascript" src="/ibase/webitm/js/PerkProcessWizard.js"></script>

				<script language="Javascript" type="text/javascript">
					<!-- window.onload=function()-->
					$(document).ready(function()
					{
					global_obj_name = document.getElementById("OBJ_NAME").value;

					openDet3 = document.getElementById("loanWin").value ;

					});

				</script>
				<form name="Wizard_activity" METHOD="post"
					ACTION="/ibase/ITMWizardHandlerServlet" onSubmit="javascript:disableButtons(1);">
					<table id="errorActivityTable" class="tableClass1" border="0"
						cellSpacing="3" cellPadding="2">
						<xsl:for-each select="//error">
							<xsl:if test="position() = 1">
								<tr>
									<td class="td_leftAlign" nowrap="true" valign="bottom">
										Description :
									</td>
								</tr>
							</xsl:if>
							<xsl:variable name="message">
								<xsl:value-of select="message" />
							</xsl:variable>
							<xsl:variable name="description">
								<xsl:value-of select="description" />
							</xsl:variable>
							<xsl:variable name="type">
								<xsl:value-of select="type" />
							</xsl:variable>
							<xsl:variable name="dbID">
								<xsl:value-of select="@domId" />
							</xsl:variable>
							<xsl:variable name="column_name">
								<xsl:value-of select="@column_name" />
							</xsl:variable>
							<tr>
								<td class="td_leftAlign" nowrap="true">
									<xsl:value-of select="description" />
								</td>
							</tr>
						</xsl:for-each>
						<xsl:for-each select="//error">
							<xsl:variable name="type">
								<xsl:value-of select="type" />
							</xsl:variable>
							<xsl:if test="position() = 1">
								<xsl:if test="$type = 'W'">
									<tr>
										<!-- Changed by Pawan on 30-06-11 [WS1BSUN001] to hide message.start -->
										<!-- <td class="td_leftAlign" nowrap="true" valign="bottom"> Override 
											Warnings : </td> -->
										<!-- Changed by Pawan on 30-06-11 [WS1BSUN001] to hide message.end -->
										<td class="td_leftAlign" nowrap="true" valign="bottom">
											<!--Changed by Rohan on 5/20/2011 [WS1BSUN001] to change Formatting. -->
											<!-- <input type="checkbox" name="forceSave" value="false" onClick="setChecked(this)"/> -->
											<input type="checkbox" name="forceSave" value="true"
												checked="checked" onClick="setChecked(this)" />
										</td>
									</tr>
								</xsl:if>
							</xsl:if>
						</xsl:for-each>

					</table>

					<div class="headerTitle">Perk Claim Process</div>

					<table id="HeaderTable" class="tableClassHeader" border="0"
						cellSpacing="3" cellPadding="2" bgcolor="#F7F8E7">

						<tr>
							<td class="td_rightAlignHeader1" align="middle" valign="middle">
								<strong>Employee Code</strong>
							</td>
							<td class="td_rightAlignHeader1" align="middle" valign="middle">
								<strong>First Name</strong>
							</td>
							<td class="td_rightAlignHeader1" align="middle" valign="middle">
								<strong>Last Name</strong>
							</td>
							<td class="td_rightAlignHeader1" align="middle" valign="middle">
								<strong>Ad Code</strong>
							</td>
							<td class="td_rightAlignHeader1" align="middle" valign="middle">
								<strong>Effective Date</strong>
							</td>
							<td class="td_rightAlignHeader1" align="middle" valign="middle">
								<strong>Balance Amount</strong>
							</td>
							<td class="td_rightAlignHeader1" align="middle" valign="middle">
								<strong>Claim Amount</strong>
							</td>
							<td class="td_rightAlignHeader1" align="middle" valign="middle">
								<strong>Loan Adjust Amount</strong>
							</td>
						</tr>

						<xsl:for-each select="//Detail2">
							<xsl:variable name="emp_code">
								<xsl:value-of select="emp_code" />
							</xsl:variable>
							<xsl:variable name="fname">
								<xsl:value-of select="fname" />
							</xsl:variable>
							<xsl:variable name="lname">
								<xsl:value-of select="lname" />
							</xsl:variable>
							<xsl:variable name="ad_code">
								<xsl:value-of select="ad_code" />
							</xsl:variable>
							<xsl:variable name="eff_date">
								<xsl:value-of select="eff_date" />
							</xsl:variable>
							<xsl:variable name="bal_amt">
								<xsl:value-of select="bal_amt" />
							</xsl:variable>
							<xsl:variable name="claim_amt">
								<xsl:value-of select="claim_amt" />
							</xsl:variable>
							<xsl:variable name="loan_adjamt">
								<xsl:value-of select="loan_adjamt" />
							</xsl:variable>
							<xsl:variable name="contcode">
								<xsl:value-of select="contcode" />
							</xsl:variable>
							<xsl:variable name="payroll_voucher">
								<xsl:value-of select="payroll_voucher" />
							</xsl:variable>
							<xsl:variable name="chg_date">
								<xsl:value-of select="chg_date" />
							</xsl:variable>
							<xsl:variable name="chg_user">
								<xsl:value-of select="chg_user" />
							</xsl:variable>
							<xsl:variable name="chg_term">
								<xsl:value-of select="chg_term" />
							</xsl:variable>
							<xsl:variable name="tran_id">
								<xsl:value-of select="tran_id" />
							</xsl:variable>
							<xsl:variable name="ref_no">
								<xsl:value-of select="ref_no" />
							</xsl:variable>
							<xsl:variable name="end_date">
								<xsl:value-of select="end_date" />
							</xsl:variable>
							<xsl:variable name="tran_date">
								<xsl:value-of select="tran_date" />
							</xsl:variable>
							<xsl:variable name="full_amt">
								<xsl:value-of select="full_amt" />
							</xsl:variable>
							<xsl:variable name="line_no">
								<xsl:value-of select="line_no" />
							</xsl:variable>
							<xsl:variable name="adjust_loan">
								<xsl:value-of select="adjust_loan" />
							</xsl:variable>
							<xsl:variable name="minDbId">
								<xsl:value-of select="minDbId" />
							</xsl:variable>
							<xsl:variable name="maxDbId">
								<xsl:value-of select="maxDbId" />
							</xsl:variable>
							<xsl:variable name="dbID">
								<xsl:value-of select="@domID" />
							</xsl:variable>


							<tr>

								<input type="hidden" name="Detail2.{normalize-space($dbID)}.selectbox"
									id="Detail2.{normalize-space($dbID)}.selectbox" value="true" />

								<input type="hidden" name="Detail2.{normalize-space($dbID)}.action"
									id="Detail2.{normalize-space($dbID)}.action" value=""
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$contcode}"
									name="Detail2.{normalize-space($dbID)}.contcode" id="Detail2.{normalize-space($dbID)}.contcode"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$payroll_voucher}"
									name="Detail2.{normalize-space($dbID)}.payroll_voucher" id="Detail2.{normalize-space($dbID)}.payroll_voucher"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$chg_date}"
									name="Detail2.{normalize-space($dbID)}.chg_date" id="Detail2.{normalize-space($dbID)}.chg_date"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$chg_user}"
									name="Detail2.{normalize-space($dbID)}.chg_user" id="Detail2.{normalize-space($dbID)}.chg_user"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$chg_term}"
									name="Detail2.{normalize-space($dbID)}.chg_term" id="Detail2.{normalize-space($dbID)}.chg_term"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$tran_id}"
									name="Detail2.{normalize-space($dbID)}.tran_id" id="Detail2.{normalize-space($dbID)}.tran_id"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$ref_no}"
									name="Detail2.{normalize-space($dbID)}.ref_no" id="Detail2.{normalize-space($dbID)}.ref_no"
									ISCHANGED="false" readOnly='true' />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$end_date}"
									name="Detail2.{normalize-space($dbID)}.end_date" id="Detail2.{normalize-space($dbID)}.end_date"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$tran_date}"
									name="Detail2.{normalize-space($dbID)}.tran_date" id="Detail2.{normalize-space($dbID)}.tran_date"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$full_amt}"
									name="Detail2.{normalize-space($dbID)}.full_amt" id="Detail2.{normalize-space($dbID)}.full_amt"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$line_no}"
									name="Detail2.{normalize-space($dbID)}.line_no" id="Detail2.{normalize-space($dbID)}.line_no"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$adjust_loan}"
									name="Detail2.{normalize-space($dbID)}.adjust_loan" id="Detail2.{normalize-space($dbID)}.adjust_loan"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$minDbId}"
									name="Detail2.{normalize-space($dbID)}.minDbId" id="Detail2.{normalize-space($dbID)}.minDbId"
									ISCHANGED="false" />
								<input type="hidden" class="input_editable" size="20"
									style='width: 100%;' value="{$maxDbId}"
									name="Detail2.{normalize-space($dbID)}.maxDbId" id="Detail2.{normalize-space($dbID)}.maxDbId"
									ISCHANGED="false" />
								<input type="hidden" name="loanWin" id="loanWin" value="N" />

								<td class="td_leftAlign">
									<input type="text" size="20" style='width: 100%;' value="{$emp_code}"
										name="Detail2.{normalize-space($dbID)}.emp_code" id="Detail2.{normalize-space($dbID)}.emp_code"
										ISCHANGED="false" readOnly='true' />
								</td>

								<td class="td_leftAlign">
									<input type="text" size="20" style='width: 100%;' value="{$fname}"
										name="Detail2.{normalize-space($dbID)}.fname" id="Detail2.{normalize-space($dbID)}.fname"
										ISCHANGED="false" readOnly='true' />
								</td>

								<td class="td_leftAlign">
									<input type="text" size="20" style='width: 100%;' value="{$lname}"
										name="Detail2.{normalize-space($dbID)}.lname" id="Detail2.{normalize-space($dbID)}.lname"
										ISCHANGED="false" readOnly='true' />
								</td>

								<td class="td_leftAlign">
									<input type="text" size="20" style='width: 100%;' value="{$ad_code}"
										name="Detail2.{normalize-space($dbID)}.ad_code" id="Detail2.{normalize-space($dbID)}.ad_code"
										ISCHANGED="false" readOnly='true' />
								</td>

								<td class="td_leftAlign">
									<input type="text" size="20" style='width: 100%;' value="{$eff_date}"
										name="Detail2.{normalize-space($dbID)}.eff_date" id="Detail2.{normalize-space($dbID)}.eff_date"
										ISCHANGED="false" readOnly='true' />
								</td>

								<td class="td_leftAlign">
									<input type="text" size="20" style='width: 100%;text-align:right'
										value="{$bal_amt}" name="Detail2.{normalize-space($dbID)}.bal_amt"
										id="Detail2.{normalize-space($dbID)}.bal_amt" ISCHANGED="false"
										readOnly='true' />
								</td>

								<td class="td_leftAlign">
									<xsl:choose>
										<xsl:when test="$full_amt = 'Y'">

											<input type="text" size="20" style='width: 100%;text-align:right'
												value="{$claim_amt}" name="Detail2.{normalize-space($dbID)}.claim_amt"
												id="Detail2.{normalize-space($dbID)}.claim_amt" ISCHANGED="false"
												protect="{claim_amt/@protect}" protectExpr="" readOnly='true' />

										</xsl:when>
										<xsl:otherwise>

											<input type="text" size="20" style='width: 100%;text-align:right'
												value="{$claim_amt}" name="Detail2.{normalize-space($dbID)}.claim_amt"
												id="Detail2.{normalize-space($dbID)}.claim_amt" ISCHANGED="false"
												protect="{claim_amt/@protect}" protectExpr=""
												onKeyPress='onlyNumbersAllowed(this);' onmouseover='onlyNumbersAllowed(this);'
												onkeyup='validateClaimAmount({normalize-space($dbID)});'
												onblur='formatNum({normalize-space($dbID)});' />

										</xsl:otherwise>

									</xsl:choose>
								</td>

								<td class="td_leftAlign">
									<input type="text" size="20" style='width: 100%;text-align:right'
										value="{$loan_adjamt}" name="Detail2.{normalize-space($dbID)}.loan_adjamt"
										id="Detail2.{normalize-space($dbID)}.loan_adjamt" ISCHANGED="false"
										readOnly='true' />
								</td>

								<td class="td_leftAlign">
									<xsl:choose>
										<xsl:when test="$adjust_loan = 'N'">

											<input type="button" id="addButton" disabled="disabled"
												value="Loan" title=''
												onclick='assignValue(viewLoanDetail({normalize-space($dbID)}))' />
										</xsl:when>
										<xsl:otherwise>

											<!-- 13/10/2015 [START] -->
											<xsl:choose>
												<xsl:when test="$loan_adjamt = ''">
													<input type="button" id="addButton" disabled="disabled"
														value="Loan" title=''
														onclick='assignValue(viewLoanDetail({normalize-space($dbID)}))' />
												</xsl:when>
												<xsl:otherwise>
													<!-- 13/10/2015 [END] -->
													<input type="button" id="addButton" value="Loan"
														title=''
														onclick='assignValue(viewLoanDetail({normalize-space($dbID)}))' />
												</xsl:otherwise>
											</xsl:choose>

										</xsl:otherwise>

									</xsl:choose>

									<!-- <input type ="button" id="addButton" value="Loan" title='' 
										onclick = 'assignValue(viewLoanDetail({normalize-space($dbID)}))'/> -->
								</td>

							</tr>
							<!-- DETAIL3 START -->

							<div id="perkDetail_{normalize-space($emp_code)}" name="perkDetail_{normalize-space($emp_code)}"
								style="display:none">
								<span id="perkDetailSpan_{normalize-space($emp_code)}">
									<font size="2pt" face="Verdana">
										<xsl:for-each select="//Detail3">
											<xsl:variable name="ref_no">
												<xsl:value-of select="ref_no" />
											</xsl:variable>
											<xsl:variable name="scheme_no">
												<xsl:value-of select="scheme_no" />
											</xsl:variable>
											<xsl:variable name="ad_code">
												<xsl:value-of select="ad_code" />
											</xsl:variable>
											<xsl:variable name="eff_date">
												<xsl:value-of select="eff_date" />
											</xsl:variable>
											<xsl:variable name="bal_amt">
												<xsl:value-of select="bal_amt" />
											</xsl:variable>
											<xsl:variable name="adj_amt">
												<xsl:value-of select="adj_amt" />
											</xsl:variable>
											<xsl:variable name="tran_id">
												<xsl:value-of select="tran_id" />
											</xsl:variable>
											<xsl:variable name="interest">
												<xsl:value-of select="interest" />
											</xsl:variable>
											<xsl:variable name="loan_amt">
												<xsl:value-of select="loan_amt" />
											</xsl:variable>
											<xsl:variable name="mon_inst">
												<xsl:value-of select="mon_inst" />
											</xsl:variable>
											<xsl:variable name="adj_perc">
												<xsl:value-of select="adj_perc" />
											</xsl:variable>
											<xsl:variable name="ref_type">
												<xsl:value-of select="ref_type" />
											</xsl:variable>
											<xsl:variable name="end_date">
												<xsl:value-of select="end_date" />
											</xsl:variable>
											<xsl:variable name="line_no">
												<xsl:value-of select="line_no" />
											</xsl:variable>
											<xsl:variable name="start_date">
												<xsl:value-of select="start_date" />
											</xsl:variable>
											<xsl:variable name="claim_amt">
												<xsl:value-of select="claim_amt" />
											</xsl:variable>
											<xsl:variable name="loan_adjamt">
												<xsl:value-of select="loan_adjamt" />
											</xsl:variable>
											<xsl:variable name="ad_descr">
												<xsl:value-of select="ad_descr" />
											</xsl:variable>
											<xsl:variable name="dbID">
												<xsl:value-of select="@domID" />
											</xsl:variable>

											<xsl:choose>

												<xsl:when test="$emp_code = $tran_id">

													<!--<xsl:when test="$ad_code = $ad_code"> -->

													<input type="hidden"
														name="Detail3.{normalize-space($dbID)}.selectbox" id="Detail3.{normalize-space($dbID)}.selectbox"
														value="true" />
													<!-- <input type="hidden" class="input_editable" size="20" style='width: 
														100%;' value="{$emp_code}" name="Detail3.{normalize-space($dbID)}.emp_code" 
														id="Detail3.{normalize-space($dbID)}.emp_code" ISCHANGED="false"/> -->
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$start_date}"
														name="Detail3.{normalize-space($dbID)}.start_date" id="Detail3.{normalize-space($dbID)}.start_date"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$end_date}"
														name="Detail3.{normalize-space($dbID)}.end_date" id="Detail3.{normalize-space($dbID)}.end_date"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$scheme_no}"
														name="Detail3.{normalize-space($dbID)}.scheme_no" id="Detail3.{normalize-space($dbID)}.scheme_no"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$interest}"
														name="Detail3.{normalize-space($dbID)}.interest" id="Detail3.{normalize-space($dbID)}.interest"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$loan_amt}"
														name="Detail3.{normalize-space($dbID)}.loan_amt" id="Detail3.{normalize-space($dbID)}.loan_amt"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$mon_inst}"
														name="Detail3.{normalize-space($dbID)}.mon_inst" id="Detail3.{normalize-space($dbID)}.mon_inst"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$tran_id}"
														name="Detail3.{normalize-space($dbID)}.tran_id" id="Detail3.{normalize-space($dbID)}.tran_id"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$adj_perc}"
														name="Detail3.{normalize-space($dbID)}.adj_perc" id="Detail3.{normalize-space($dbID)}.adj_perc"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$ref_type}"
														name="Detail3.{normalize-space($dbID)}.ref_type" id="Detail3.{normalize-space($dbID)}.ref_type"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$line_no}"
														name="Detail3.{normalize-space($dbID)}.line_no" id="Detail3.{normalize-space($dbID)}.line_no"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$ref_no}"
														name="Detail3.{normalize-space($dbID)}.ref_no" id="Detail3.{normalize-space($dbID)}.ref_no"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$ad_code}"
														name="Detail3.{normalize-space($dbID)}.ad_code" id="Detail3.{normalize-space($dbID)}.ad_code"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$eff_date}"
														name="Detail3.{normalize-space($dbID)}.eff_date" id="Detail3.{normalize-space($dbID)}.eff_date"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$bal_amt}"
														name="Detail3.{normalize-space($dbID)}.bal_amt" id="Detail3.{normalize-space($dbID)}.bal_amt"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$adj_amt}"
														name="Detail3.{normalize-space($dbID)}.adj_amt" id="Detail3.{normalize-space($dbID)}.adj_amt"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$claim_amt}"
														name="Detail3.{normalize-space($dbID)}.claim_amt" id="Detail3.{normalize-space($dbID)}.claim_amt"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$loan_adjamt}"
														name="Detail3.{normalize-space($dbID)}.loan_adjamt" id="Detail3.{normalize-space($dbID)}.loan_adjamt"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$ad_descr}"
														name="Detail3.{normalize-space($dbID)}.ad_descr" id="Detail3.{normalize-space($dbID)}.ad_descr"
														ISCHANGED="false" />
														<!-- Modified by Ahmed on 08-Mar-2017 [start]-->
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$minDbId}"
														name="Detail3.{normalize-space($dbID)}.minDbId" id="Detail3.{normalize-space($dbID)}.minDbId"
														ISCHANGED="false" />
													<input type="hidden" class="input_editable" size="20"
														style='width: 100%;' value="{$maxDbId}"
														name="Detail3.{normalize-space($dbID)}.maxDbId" id="Detail3.{normalize-space($dbID)}.maxDbId"
														ISCHANGED="false" />
														<!-- Modified by Ahmed on 08-Mar-2017 [end]-->

												</xsl:when>
												<xsl:otherwise>
												</xsl:otherwise>
											</xsl:choose>

										</xsl:for-each>
									</font>
								</span>
							</div>

							<!-- DETAIL3 END -->

						</xsl:for-each>
						<tr>
							<td class="td_leftAlign" colspan="2">
								<input type="submit" style="cursor:hand" name="finish" value="Finish" title='' onclick="return setActionVal('finish')" />
								<!-- <input type="button" style="cursor:hand" name="back" value="Back" title='' onclick="history.go(-1);" />-->
								<input type="button" style="cursor:hand" name="back" value="Back" title='' onclick="javascript:setActionVal('previous');" />
							</td>
						</tr>
					</table>

					<table colspan="1" border="0">
						<tr>
							<td>
								<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
								<input type="hidden" value="perk_claim_process" name="OBJ_NAME" id="OBJ_NAME" />
								<input type="hidden" value="" name="action" id="action" />
								<input type="hidden" name="loanWin" id="loanWin" value="N" />
							</td>
						</tr>
					</table>

					<!--Changed by Dhiraj 30/09/10 [WS01SUN007] .start -->
					<!--<table id="errorActivityTable" class="tableClass" border="0" cellSpacing="2" 
						cellPadding="1"> -->
					<!--Changed by Dhiraj 30/09/10 [WS01SUN007] .start -->

				</form>
			</body>

		</html>
	</xsl:template>

</xsl:stylesheet>