package ibase.webitm.ejb.wms;


import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;

import javax.ejb.Stateless;

import org.w3c.dom.*;

@Stateless
public class LpnNoGenIC extends ValidatorEJB implements LpnNoGenICLocal, LpnNoGenICRemote 
{

	/*
	 The method defined with no paramter and returns nothing
	*/
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}//end of wfVAlData

	
	public String wfValData(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr);
			}
			if(hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr);
			}
			if(allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr);
			}
			errString = wfValData( currDom, hdrDom, allDom, objContext, editFlag, xtraParams );
			System.out.println ( "ErrString: " + errString);
		}//end of try
		catch(Exception e)
		{
			System.out.println ( "Exception: LpnNoGenIC: wfValData(): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}//end of catch
		
		System.out.println ( "Returning from EJB wfValData" );
		return ( errString );
	}//end of wfvalData() of xml string

	

	public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		ResultSet rSet = null;
		Connection connObject = null;
		PreparedStatement pstmt = null;

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			String columnValue = "";
			int currentFormNo = 0;
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connObject = connDriver.getConnectDB("DriverValidator");

			NodeList parentList = null;
			NodeList childList = null;
			int noOfChilds = 0;
			String childNodeName = "";
			Node childNode =null;

			boolean isNumber = true;

			String userID = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "LoginCode" );
	
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			parentList = currDom.getElementsByTagName( "Detail" + currentFormNo );
			childList = parentList.item( 0 ).getChildNodes();
			noOfChilds = childList.getLength();
			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item( ctr );
				childNodeName = childNode.getNodeName();
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				
				if ( "no_of_lpn".equalsIgnoreCase( childNodeName ) )
				{
						isNumber = checkNumeric( columnValue );
						System.out.println("isNumber =["+isNumber+"]");
						if ( !isNumber )
						{
							errString = getErrorString("print_flag","NOTANUMBR1",userID);
							break;
						}
				}
			}
		}

		catch(Exception e)
		{
			System.out.println("Exception in LpnNoGenIC  == >");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( connObject != null && ! connObject.isClosed() )
				{
					connObject.close();
					connObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : LpnNoGenIC : wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}//end of catch
		} //end of finally
		return (errString);
	}

	private boolean checkNumeric( String noOfLabel ) throws Exception
	{
		char[] cArray = noOfLabel.toCharArray();
		boolean isNumber = true;
		for(int i = 0; i < cArray.length;i++) 
		{
			if( !Character.isDigit(cArray[i]) ) 
			{
				isNumber = false;
			}
		}
		return isNumber;
	}
	
}



