/**
 * PURPOSE :ConsolidatePalletIC component
 * AUTHOR : Jagruti Shinde
 * DATE : 14-01-2016
 * Normal Pallet         :Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::not in QC
 * Pallet with suffix 'Q':Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::pending in QC
 * Pallet with suffix 'X':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::not in QC
 * Pallet with suffix 'M':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::pending in QC
 * Pallet with suffix 'B':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::not in QC
 * Pallet with suffix 'S':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::pending in QC
 * Pallet with suffix 'P':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::not in QC
 * Pallet with suffix 'U':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::pending in QC 
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class ConsolidatePalletIC extends ValidatorEJB implements ConsolidatePalletICLocal, ConsolidatePalletICRemote 
{
	DistCommon discommon = new DistCommon();
	@Override

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( dom, dom1, dom2, objContext, xtraParams,editFlag);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String xtraParams,String editFlag) throws RemoteException, ITMException
	{   				
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "",sqlQ="",sql="";
		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String>errFields = new ArrayList <String> ();
		E12GenericUtility genericUtility;
		String remarks="",addUser="",addTerm="",addDate="",chgUser="",chgTerm="",chgDate="",descr="",stkSql="",
		itemSql="",StatusSql="",status ="",itemRgSql="",locGroupDisp="",locSql="",locGroup="",itemSer="",itemSerRgDisparm="",itemCode="",lotNo="",
		locSuffixDisp="",lastCharS="";
		ResultSet rs= null ;
		Document currFormDataDom = dom;
		String loginSite = "",objName="";
		ArrayList<String> palletList = new ArrayList();
		ArrayList ArrList = new ArrayList();
		ArrayList<String> currPalletList = new ArrayList();
		PreparedStatement pstmt = null,pstmtQ = null;
		Connection conn = null;
		String siteCode = "",userId = "",childNodeName = "",errString = "",tranId="";
		int ctr = 0, currentFormNo = 0, childNodeListLength = 0, palcnt=0,cntLoc = 0,cnt=0,
		count=0,palTcnt=0,locCount = 0;
		char lastChar ;
		objName = getObjNameFromDom(dom, "objName", "2");
		System.out.println("objName----->>["+objName+"]");	
		System.out.println("editFlag----->>["+editFlag+"]");	
		genericUtility = new E12GenericUtility();	
		siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
		HashMap hm2 = new HashMap();
		HashMap hm = new HashMap();
		HashMap hm1 = new HashMap();

		try
		{	
			CommonWmsUtil commonWmsUtility = CommonWmsUtil.getInstance();
			System.out.println("xtraParam----->>["+xtraParams+"]");
			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
			//Commented by Santosh on 14-06-2016
			//ConnDriver connDriver = new ConnDriver();
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			conn.setAutoCommit(false);
			//Commented by Santosh on 14-06-2016
			//connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}	

			switch ( currentFormNo )  // Switch Case for form number
			{
			case 1:
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");
				System.out.println("editFlag----->>["+editFlag+"]");	

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName11------->>["+childNodeName+"]");
				}
				break;

			case 2:
				System.out.println("------in case 2---------------");
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	
				System.out.println("editFlag----->>["+editFlag+"]");	


				String palletNoC = "";
				parentNodeList = dom2.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength----->>["+childNodeListLength+"]");
				//Change by Jagruti Shinde Request Id:[W15JSUN008] for requirement change for Exempted/BSR location inv_stat[start]
				locSuffixDisp = checkNullAndTrim(discommon.getDisparams("999999", "AWMS_LOCATION_SUFFIX", conn));
				System.out.println("AWMS_LOCATION_SUFFIX["+locSuffixDisp+"]");
				String[] locS = locSuffixDisp.split(",");
				System.out.println("Disparm Lenght for locSuffixDisp="+locS.length);
				//Change by Jagruti Shinde Request Id:[W15JSUN008] for requirement change for Exempted/BSR location inv_stat[End]
				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					palletNoC = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",dom));	
					tranId = checkNullAndTrim(genericUtility.getColumnValue("tran_id",dom));
					System.out.println("tran id---" +tranId);

					System.out.println("PALLET NO---" +palletNoC);
					if("pallet_no".equalsIgnoreCase(childNodeName))
					{
						if(palletNoC.length() == 0 || palletNoC.equalsIgnoreCase(""))
						{
							errCode = "VMPALLENUL";//pallet no  cannot be blank
							errList.add( errCode );

							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();

							errFields.add( childNodeName.toLowerCase() );
							break;
						}
						else 
						{
							//Change by Jagruti Shinde Request Id:[W15JSUN008] for requirement change for Exempted/BSR location inv_stat[start]
							// Change by Jagruti Shinde as site_code is not consider for location master[start]
							//sql = "SELECT  COUNT(1) FROM LOCATION WHERE INV_STAT = ?  AND LOC_CODE =? AND SITE_CODE=?";							
							/*sql = "SELECT  COUNT(1) FROM LOCATION WHERE INV_STAT = ?  AND LOC_CODE =? ";	
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, palletNoC);
							//pstmt.setString(3, loginSite);
							rs = pstmt.executeQuery();
							if(rs.next())
							{	
								cntLoc = rs.getInt(1);
							}
							if(pstmt != null){pstmt.close();pstmt = null;}
							if(rs != null){rs.close();rs = null;}
							if(cntLoc == 0)
							{
								System.out.println("awms pallet count" +cntLoc);
								errCode = "VMPALLEEXT";//pallet 
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}*/
							// Change by Jagruti Shinde as site_code is not consider for location master[End]
							sql = "SELECT COUNT(1) FROM LOCATION WHERE INV_STAT = ?  AND LOC_CODE =? ";							
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, palletNoC);
							//pstmt.setString(3, loginSite);
							rs = pstmt.executeQuery();
							if(rs.next())
							{	
								cntLoc = rs.getInt(1);
								System.out.println( "cntLoc:::"+cntLoc);
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}

							if(cntLoc > 0)
							{
								lastChar = palletNoC.charAt(palletNoC.trim().length()-1);
								System.out.println("locSuffix disparm=["+locSuffixDisp+"] and lastChar["+lastChar+"]");

								if(locSuffixDisp.contains(String.valueOf(lastChar)))
								{
									System.out.println("****Match found in disparm for:"+lastChar);
									errCode = "VTPALREEXT";
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
								else
								{
									stkSql = "SELECT COUNT(1) FROM STOCK WHERE INV_STAT IN(?,?)  AND LOC_CODE IN (?,?,?,?,?,?,?,?)  AND SITE_CODE=? AND QUANTITY>0";

									pstmt = conn.prepareStatement(stkSql);
									pstmt.setString(1, "AWMS");
									pstmt.setString(2, "AWMSQ");
									pstmt.setString(3, palletNoC);
									pstmt.setString(4, palletNoC+"Q");
									pstmt.setString(5, palletNoC+"B");
									pstmt.setString(6, palletNoC+"X");
									pstmt.setString(7, palletNoC+"M");
									pstmt.setString(8, palletNoC+"U");
									pstmt.setString(9, palletNoC+"P");
									pstmt.setString(10,palletNoC+"S");
									pstmt.setString(11, loginSite);
									rs = pstmt.executeQuery();
									if(rs.next())
									{	
										palcnt = rs.getInt(1);
									}
									if (pstmt != null) 
									{ 
										pstmt.close(); 
										pstmt = null;
									}
									if (rs != null) 
									{   
										rs.close(); 
										rs = null; 
									}
									if(palcnt == 0)
									{
										System.out.println("awms pallet count" +palcnt);
										errCode = "VMPALLETQN";//pallet quantity should be more than zero
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
										break;
									}
								}
							}
							else
							{
								System.out.println("pallet not in AWMS" +cntLoc);
								errCode = "VTPALREEXT";//pallet 
								errList.add( errCode );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}
							//Change by Jagruti Shinde Request Id:[W15JSUN008] for requirement change for Exempted/BSR location inv_stat[End]

							System.out.println("Before fn_chk_rpz=["+palletNoC+"]");
							//Changed by Jagruti Shinde Request Id:[W16ASUN004] for considering one pallet either for pallet out or pallet consolidation
							//sql = "SELECT FN_CHK_RPZ(TRIM(?),?) FROM DUAL ";
							sql = "SELECT FN_CHK_PR(TRIM(?),?) FROM DUAL ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, palletNoC);
							pstmt.setString(2, tranId);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								palTcnt = rs.getInt(1);
							}

							if (pstmt != null) 
							{ 
								pstmt.close(); 
								pstmt = null; 
							}

							if (rs != null) 
							{
								rs.close(); 
								rs = null; 
							}

							if (palTcnt > 0)
							{
								System.out.println("PRESENT IN SWMS" + palTcnt);
								errCode = "VMPALDCOEX";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
								break;
							}

							//System.out.println("IN PALLET REQUEST EDIT FLAG");	
							palletList = checkDuplicaterecord(dom2,siteCode,conn);
							Set s = new HashSet(palletList);
							System.out.println("Size of arrayList ["+palletList+"]");
							System.out.println("Size of Set ["+s.size()+"]");	
							System.out.println("palletNoC ["+palletNoC+"]");	
							int count1 = Collections.frequency(palletList, palletNoC);
							System.out.println("count1 ["+count1+"]");	

							if(count1 > 1)
							{
								System.out.println("pallet  exist");
								errList.add( "VMPALLETSM" );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}	

							currPalletList= getAllDetailPallet( palletNoC,  siteCode, conn);
							System.out.println("currPalletList ["+currPalletList.get(0)+"]");
							System.out.println("Privious palletList ["+palletList.get(1)+"]");  

							if(! currPalletList.get(0).equalsIgnoreCase(palletList.get(1)))  
							{
								System.out.println("pallet  exist");
								errList.add( "VMPALTTEXS" );
								errFields.add( childNodeName.toLowerCase() );
								break;
							}	
							s.clear();
						}
					}
				}
				break;
			} //switch end
			System.out.println("after switch"+errList);
			int errListSize = errList.size();
			System.out.println("errListSize .........." + errListSize);
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);

					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );

					errorType =  errorType( conn, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}	
			errString = errStringXml.toString();
		}//try end
		catch ( Exception e )
		{
			System.out.println ( "Exception: ConsolidatePalletIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			throw new ITMException(e);		
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : ConsolidatePalletIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::"+errString );
		return errString;
	}//wf end

	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	/**
	 * The public method is defined without any parameters and returns blank string
	 */
	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(dom)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :ConsolidatePalletIC :itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from ConsolidatePalletIC itemChanged \n[" + errString + "]" );

		return errString;
	}
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 */
	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		Connection conn = null;

		StringBuffer valueXmlString;		
		String loginSite = "",loginEmpCode = "",chgUser = "" , chgTerm = "",siteDescr = "", siteCodeSupp = "" ,tranDate = "";
		String siteCode = "",lotNo="",lotSl="",itemCode="",palletNo="",noArtStr="",quantityStr="",sql="",locCode="",locDescr="";
		int currentFormNo = 0;
		ResultSet rs=null;
		double quantity=0,noArt=0,qtyPerArt=0,noArtQuot=0,noArtRem =0 , notArt = 0, totalQuantity = 0, noArtD=0;

		System.out.println("xtraParams=["+xtraParams+"]");
		E12GenericUtility genericUtility = new E12GenericUtility();		

		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
		try
		{			
			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));	
			siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));	
			loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));	
			chgUser = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));

			System.out.println("loginEmpCode---->>["+loginEmpCode+"] chgUser---->>["+chgUser+"]");	
			System.out.println("currFormDataDom---->>["+genericUtility.serializeDom(currFormDataDom)+"] ");
			System.out.println("hdrDataDom---->>["+genericUtility.serializeDom(hdrDataDom)+"] ");
			System.out.println("allFormDataDom---->>["+genericUtility.serializeDom(allFormDataDom)+"] ");
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormatObj.format(currentDate.getTime());
			//ConnDriver connDriver = new ConnDriver();
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			System.out.println("current form no["+currentFormNo+"]");
			System.out.println("editFlag  IN ITEM CHANGE["+editFlag+"]");
			System.out.println("objContext  IN ITEM CHANGE["+objContext+"]");

			valueXmlString.append("</editFlag>\r\n</Header>\r\n");
			switch ( currentFormNo )  
			{
			case 1:
			{
				valueXmlString.append( "<Detail1>\r\n" );
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("editFlag  CASE 1["+editFlag+"]");
					System.out.println("objContext  CASE 1["+objContext+"]");
					System.out.println("loginSite : ["+loginSite+"]");
					siteDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "site", "site_code", loginSite));
					valueXmlString.append( "<site_code><![CDATA[" ).append( loginSite ).append( "]]></site_code>\r\n" );
					valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );
				}
				valueXmlString.append( "<add_user><![CDATA[" ).append( chgUser ).append( "]]></add_user>\r\n" );
				valueXmlString.append( "<confirmed><![CDATA[" ).append( "N" ).append( "]]></confirmed>\r\n" );
				valueXmlString.append( "<tran_type><![CDATA[" ).append( "R" ).append( "]]></tran_type>\r\n" );
				valueXmlString.append( "<tran_date><![CDATA[" ).append( tranDate ).append( "]]></tran_date>\r\n" );
				valueXmlString.append( "<add_date><![CDATA[" ).append( tranDate ).append( "]]></add_date>\r\n" );
				valueXmlString.append( "<add_user><![CDATA[" ).append( chgUser ).append( "]]></add_user>\r\n" );
				valueXmlString.append( "<add_term><![CDATA[" ).append( chgTerm ).append( "]]></add_term>\r\n" );

				valueXmlString.append("</Detail1>\r\n");
			} //Case 1. End
			break;
			case 2:
			{
				System.out.println("header dom2 "+genericUtility.serializeDom(hdrDataDom));
				System.out.println("header dom2 "+genericUtility.serializeDom(allFormDataDom));

				valueXmlString.append( "<Detail2>\r\n" );
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("editFlag  CASE 2["+editFlag+"]");
					System.out.println("objContext  CASE 2["+objContext+"]");
					valueXmlString.append( "<status><![CDATA[" ).append( "P" ).append( "]]></status>\r\n" );

				}

				valueXmlString.append( "</Detail2>\r\n" );
			}
			break;
			}//switch
			valueXmlString.append( "</Root>\r\n" );	 
		}//End of try block
		catch (Exception e)
		{				
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{	
			try
			{				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string.  
	 * @param input
	 */
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string otherwise trim the input string and return.  
	 * @param input
	 */

	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	private int getDBRowCount(Connection conn, String table_name, String whrCondCol, String whrCondVal)
	{
		int count=0;				
		ResultSet rs=null;
		PreparedStatement pstmt = null;
		String sql="";

		sql="select count(*) from "+table_name+" where "+whrCondCol+" = ?";
		System.out.println("SQL in getDBRowCount method : "+sql);
		try
		{
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,whrCondVal);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
		}
		catch(Exception ex){
			System.out.println("Exception In getDBRowCount method of ConsolidatePalletIC Class : "+ex.getMessage());
			ex.printStackTrace();
		}
		System.out.println("Return count from getDBRowCount ----->>["+count+"]");					
		return count;
	}
	private String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in getColumnDescr ");
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("returning String from getColumnDescr " + findValue);
		return findValue;
	}

	public boolean isRecordPresentInMiscDrCrRcp(Connection conn,
			String invoiceID) {
		// TODO Auto-generated method stub
		return false;
	}

	private ArrayList checkDuplicaterecord(Document dom,String siteCode,Connection conn) throws ITMException
	{
		ArrayList arryList = new ArrayList();
		NodeList parentNodeList = null, childNodeList  = null;
		Node parentNode = null, childNode = null;
		int parentNodeListLength = 0;
		String childNodeName = "",palletNo="";
		Map detailMapP=new HashMap();

		String updateFlag = getAttribValue(parentNode,"attribute", "updateFlag"); //(parentNode, "attribute", "status"));
		try 
		{
			parentNodeList = dom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			for (int row = 0; row < parentNodeList.getLength(); row++) 
			{
				parentNode = parentNodeList.item(row);				

				System.out.println(" sumit updateFlag ["+updateFlag+"]");
				childNodeList = parentNode.getChildNodes();
				//System.out.println("************* first For loop *************["+ parentNode.getNodeName() + "]");
				for (int col = 0; col < childNodeList.getLength(); col++) {
					childNode = childNodeList.item(col);

					if (childNode.getNodeType() == childNode.ELEMENT_NODE) {
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeNamechildNodeName ** ["+childNodeName+"]");
						if( !"D".equalsIgnoreCase(updateFlag))
						{
							if ("pallet_no".equalsIgnoreCase(childNodeName)) 
							{
								palletNo=childNode.getFirstChild().getNodeValue().trim();
								arryList.add(palletNo);
								System.out.println("===palletno-->[" + arryList+ "]");
								arryList.addAll(getAllDetailPallet(palletNo,siteCode,conn));
							}
						}
					}
				}
				System.out.println("ELSE FOR CHECK");

			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return arryList;
	}	

	private String getAttribValue(Node detailNode, String nodeName, String attribStr)
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		String attribValue = "",domStr="";
		try
		{
				domStr = genericUtility.serializeDom(detailNode);
			Document dom = genericUtility.parseString(domStr);
			if( dom != null /*&& dom.getAttributes() != null*/)
			{
				Node attributeNode = dom.getElementsByTagName( nodeName ).item(0);
				attribValue = getAttribValue(attributeNode, attribStr);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	private String getAttribValue(Node detailNode, String attribStr)
	{
		String attribValue = "";
		try
		{
			if( detailNode != null && detailNode.getAttributes() != null)
			{
				Node attribNode = detailNode.getAttributes().getNamedItem( attribStr );
				if( attribNode != null )
				{
					attribValue = checkNull( attribNode.getNodeValue() );
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	public boolean isRecordExist(Document dom,String palletNoC,String siteCode,Map detailMapC,Connection conn) throws Exception
	{

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength = 0;		
		String childNodeName = null,palletNoP = "",itemCode = "",lotNo = "",lotSl ="",quantity="",PalletKey="",updateFlag="";
		ArrayList<String> palletDetailList=new ArrayList<String>();
		Map detailMapP = new HashMap();		
		if(dom != null)
		{
			E12GenericUtility genericUtility = new E12GenericUtility();    
			parentNodeList = dom.getElementsByTagName("Detail2");
			childNodeListLength = parentNodeList.getLength();
			System.out.println("serializeDom----->>"+genericUtility.serializeDom(dom));
			System.out.println("childNodeListLength----->>"+childNodeListLength);
			System.out.println("palletNoC --->> "+palletNoC);
			for (int ctr = 0; ctr < childNodeListLength; ctr++)
			{				
				childNode = parentNodeList.item(ctr);			
				childNodeName = childNode.getNodeName();
				updateFlag = getAttribValue(childNode,"attribute", "updateFlag"); //(parentNode, "attribute", "status"));
				System.out.println("Child name --->> "+childNodeName);	

				if (childNode.getNodeType() == Node.ELEMENT_NODE)
				{
					Element eElement = (Element) childNode;					
					palletNoP =  checkNull(eElement.getElementsByTagName("pallet_no").item(0).getTextContent());	
					System.out.println("palletNoP---->"+palletNoP+ " PalletNoC--->["+palletNoC+"]");					
					if( !"D".equalsIgnoreCase(updateFlag) && !palletNoC.equalsIgnoreCase(palletNoP)) 
					{
						System.out.println("updateFlag --->> "+updateFlag);	
					}
				}
			}
			System.out.println("detailMapP --->> "+detailMapP);	
			System.out.println("detailMapC --->> "+detailMapC);	

			if(detailMapP.size() > 0 && detailMapC.size() > 0)
			{
				if(detailMapP.containsKey(detailMapC.get("PALLET_NO"))&& !detailMapP.containsKey("::::")) 
				{
					return true;
				}
			}
			System.out.println("palletDetail --->> "+palletDetailList);	
		}
		else
		{
			System.out.println("dom is null please check.........");
		}

		return false ;
	}
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null,reqDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				if( objName != null && objName.trim().length() > 0)
				{				
					return objName;
				}
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}
	private ArrayList getAllDetailPallet(String palletNo, String siteCode, Connection conn) throws Exception
	{	
		System.out.println("in getAllDetailPallet ----------->>"+palletNo); 
		HashMap hm = new HashMap();
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		ArrayList keyList =new ArrayList();
		String sql = "", itemCodeDB = "", lotNoDB = "", lotSlDB = "", qcSampleTypeDB = "",keyStr = "";	 	
		try
		{	
			//Change by Jagruti Shinde for Exempted /BSR Location
			/*sql ="SELECT DISTINCT(S.ITEM_CODE) ,S.LOT_NO,T.QC_SAMPLE_TYPE FROM STOCK S,SITEITEM T " +
			" WHERE  S.SITE_CODE = ?  AND S.LOC_CODE = ?  AND S.ITEM_CODE=T.ITEM_CODE AND " +
			"S.SITE_CODE=T.SITE_CODE   "*/
			sql ="SELECT DISTINCT(S.ITEM_CODE) ,S.LOT_NO,T.QC_SAMPLE_TYPE FROM STOCK S,SITEITEM T " +
			" WHERE  S.SITE_CODE = ?  AND S.LOC_CODE IN(?,?,?,?,?,?,?,?) AND S.INV_STAT IN(?,?) AND S.ITEM_CODE=T.ITEM_CODE AND " +
			"S.SITE_CODE=T.SITE_CODE  AND S.QUANTITY>0 " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, palletNo);
			pstmt.setString(3, palletNo+"Q");
			pstmt.setString(4, palletNo+"B");
			pstmt.setString(5, palletNo+"X");
			pstmt.setString(6, palletNo+"M");
			pstmt.setString(7, palletNo+"U");
			pstmt.setString(8, palletNo+"P");
			pstmt.setString(9, palletNo+"S");
			pstmt.setString(10, "AWMS");
			pstmt.setString(11, "AWMSQ");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemCodeDB = checkNullAndTrim(rs.getString("item_code"));		
				lotNoDB = checkNullAndTrim(rs.getString("lot_no"));	
				qcSampleTypeDB = checkNullAndTrim(rs.getString("qc_sample_type"));		
			}
			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }


			hm.put("ITEM_CODE", itemCodeDB);
			hm.put("LOT_NO", lotNoDB);
			hm.put("QC_SAMPLE_TYPE", qcSampleTypeDB);
			System.out.println("itemCodeDB::::::: " + itemCodeDB);
			hm.putAll(CommonWmsUtil.getInstance().getPalletizedAttributes(itemCodeDB,siteCode,conn));
			hm.put("STATUS",getItemQcStatus(itemCodeDB, lotNoDB,  siteCode,conn));
			//Change by Jagruti Shinde Request Id:[W15JSUN008]  PRO_MTH validation remove
			keyStr = hm.get("LOC_ZONE__PREF")+":" +hm.get("ANALYSIS_CLASS")+":" +hm.get("ITEM_SER__RG1")+":" +hm.get("STATUS")+":" +hm.get("QC_SAMPLE_TYPE");
			keyList.add(keyStr);
			hm.put("PALLET_NO", keyStr);
		}
		catch(Exception e)
		{
			System.out.println("Exception in getScanItem ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getScanItem :::::::::: " + keyList);
		return keyList;
	}

	private String getItemQcStatus(String itemCode, String lotNo, String siteCode, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "", status = "";		
		try
		{	
			sql ="SELECT STATUS FROM QC_ORDER WHERE ITEM_CODE = ? AND LOT_NO = ? AND SITE_CODE = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, lotNo);
			pstmt.setString(3, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				status = checkNullAndTrim(rs.getString("STATUS"));		
			}
			if(pstmt != null){ pstmt.close(); pstmt = null; }
			if(rs != null){ rs.close(); rs = null; }

			System.out.println("Status["+status+"]"); 

			if(status == null || status.length() == 0)
			{
				status = "C";
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getItemQcStatus ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getItemQcStatus :::::::::: " + status);
		return status;
	}
}


