<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>
<xsl:template match="/">

<html>

<body onload="getTitlenImg('gstsalesdata_file');setSummaryTotal();">
<script type="text/javascript" src="/ibase/webitm/js/GSTDataSubmitWiz.js"></script>
<script type="text/javascript" src="/ibase/SignDocument/js/SignService.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>
<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<script language="Javascript" src="/ibase/webitm/js/date.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.core.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.widget.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.position.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.menu.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.autocomplete.js"></script>

<link href="/ibase/webitm/css/Galaxy/galaxy-theme.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/GSTDataSubmitWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>

<script>
<![CDATA[
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion1");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		  	}
		}
	});
	
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion2");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		    	this.classList.toggle("activeAccor");
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		        if(this.nextElementSibling.classList == "panel2")
		        {
		        	this.classList.remove("activeAccor");
		        }
		  	}
		}
	});
	
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion3");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		  	}
		}
	});

	$(function() 
	{
		var panel = document.getElementsByClassName("panel2");

		for (var j = 0; j < panel.length; j++)
		{
			panel[j].onclick = function()
		    {
			    var acc = document.getElementsByClassName("accordion2");
	       		for(var i=0; i<acc.length; i++)
	       		{
	       			acc[i].classList.remove("activeAccor");
	       		}
	       		this.previousElementSibling.classList.add("activeAccor");
		  	}
		}
	});

	$(document).on("keydown", function (e) {
    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
        e.preventDefault();
    }
    else if(e.which ===13){
    	 e.preventDefault();
    }
});
]]>
</script>

<form name="gstdataSubmitForm2" id="gstdataSubmitForm2" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:100%;padding:12px; background-color:white;top:0px;">
		&#160;&#160;<img onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px; height: 20px; width: 20px;" id="titleImg" />
		&#160;<div id="titleText"></div>
		
	</div><br></br><br></br>
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:98%;position:absolute;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" >
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" >
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" >
                    </td>
                </tr>
                <script><![CDATA[]]>formatDetailWithErr();</script>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
	
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div class="detailPage-input-Container">
			<xsl:for-each select="//Detail2">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:if test="$dbID = '1'">
					<xsl:variable name="auth_token"><xsl:value-of select="auth_token"/></xsl:variable>
					<xsl:variable name="auth_sek"><xsl:value-of select="auth_sek"/></xsl:variable>
					<xsl:variable name="summary_data"><xsl:value-of select="summary_data"/></xsl:variable>
					<xsl:variable name="signed_data"><xsl:value-of select="signed_data"/></xsl:variable>
					
					<div class="inputFormDiv" style="display:none;">
						<div class="eachLineFields">
							<div class="eachField">
								<div class="inputDiv"><input type="checkbox" value="true" checked="checked" name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" tabIndex="-1"/></div>
							</div>
							<div class="eachField">
								<div class="labelDiv">Auth token : </div>
								<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$auth_token}" name="Detail2.{normalize-space($dbID)}.auth_token" id="Detail2.{normalize-space($dbID)}.auth_token" readOnly="true" tabIndex="-1"/></div>
							</div>
							<div class="eachField">
								<div class="labelDiv">Auth sek : </div>
								<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$auth_sek}" name="Detail2.{normalize-space($dbID)}.auth_sek" id="Detail2.{normalize-space($dbID)}.auth_sek" tabIndex="-1" readOnly="true" style="width:224px;"/></div>
							</div>
						</div>
						<div class="eachLineFields">
							<div class="eachField">
								<div class="labelDiv">Summary Data : </div>
								<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$summary_data}" name="Detail2.{normalize-space($dbID)}.summary_data" id="Detail2.{normalize-space($dbID)}.summary_data" readOnly="true" tabIndex="-1"/></div>
							</div>
							<div class="eachField">
								<div class="labelDiv">Signed Data : </div>
								<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$signed_data}" name="Detail2.{normalize-space($dbID)}.signed_data" id="Detail2.{normalize-space($dbID)}.signed_data" tabIndex="-1" readOnly="true" style="width:224px;"/></div>
							</div>
						</div>
					</div>
				</xsl:if>
				<xsl:if test ="$dbID != '1'">
					<xsl:variable name="period_code"><xsl:value-of select="period_code"/></xsl:variable>
					<xsl:for-each select="summary_data">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">S</div>
							<div style="margin-left:40px;">
								<input type="hidden" id="summaryRetPeriod" value="{$period_code}"/>
								<div class="invTypDiv">Summary of documents till date saved on GSTN server for <span id="returnMonthLbl"></span></div>
							</div>
						</button>
						<div class="panel1" style="overflow-x:auto;">
							<table class="tableClass" id="dataSummaryTable">
								<thead class="table-head">
									<tr class="titleRow">
										<th nowrap="true" style="border-left:0px solid black !important;" align="left">Section</th>
										<th nowrap="true" align="right">No. Invoices</th>
										<th nowrap="true" align="right">Amount</th>
										<th nowrap="true" align="right">Taxable amount</th>
										<th nowrap="true" align="right">IGST</th>
										<th nowrap="true" align="right">CGST</th>
										<th nowrap="true" align="right">SGST</th>
										<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
									</tr>
								</thead>
								<tbody class="table-body">
									<xsl:for-each select="sec_sum">
									<xsl:variable name="sectionName"><xsl:value-of select="sec_nm"/></xsl:variable>
									<xsl:if test="not($sectionName='HSN') and not($sectionName='DOC_ISSUE') and not($sectionName='NIL')">
										<tr>
											<td style="border-left:0px solid black !important;" class="titleColumn">
												<xsl:if test="$sectionName='B2B'">
													Invoices for outward supply (B2B)
												</xsl:if>
												<xsl:if test="$sectionName='B2BA'">
													Revised invoices (B2B)
												</xsl:if>
												<xsl:if test="$sectionName='B2CL'">
													Invoices for outward supply (B2CL)
												</xsl:if>
												<xsl:if test="$sectionName='B2CLA'">
													Revised invoices (B2CL)
												</xsl:if>
												<xsl:if test="$sectionName='B2CS'">
													Invoices for outward supply (B2CS)
												</xsl:if>
												<xsl:if test="$sectionName='B2CSA'">
													Revised invoices (B2CS)
												</xsl:if>
												<xsl:if test="$sectionName='CDNR'">
													Credit/Debit note
												</xsl:if>
												<xsl:if test="$sectionName='CDNRA'">
													Revised Credit/Debit note
												</xsl:if>
												<xsl:if test="$sectionName='CDNUR'">
													Credit/Debit note unregistered
												</xsl:if>
												<xsl:if test="$sectionName='CDNURA'">
													Revised Credit/Debit note
												</xsl:if>
												<xsl:if test="$sectionName='AT'">
													Advance received
												</xsl:if>
												<xsl:if test="$sectionName='ATA'">
													Advance received amendment
												</xsl:if>
												<xsl:if test="$sectionName='TXPD'">
													Tax paid on advance received
												</xsl:if>
												<xsl:if test="$sectionName='NIL'">
													Nil supplies
												</xsl:if>
												<xsl:if test="$sectionName='EXP'">
													Export supplies
												</xsl:if>
												<xsl:if test="$sectionName='EXPA'">
													Revised Export supplies
												</xsl:if>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_rec">
														<xsl:value-of select="ttl_rec"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_val">
														<xsl:value-of select="ttl_val"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_tax">
														<xsl:value-of select="ttl_tax"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_igst">
														<xsl:value-of select="ttl_igst"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_cgst">
														<xsl:value-of select="ttl_cgst"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_sgst">
														<xsl:value-of select="ttl_sgst"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td style="border-right:0px solid black !important;" align="right">
												<xsl:choose>
													<xsl:when test="ttl_cess">
														<xsl:value-of select="ttl_cess"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
										</tr>
									</xsl:if>
									</xsl:for-each>
										<tr class="totalRow">
											<td style="border-left:0px solid black !important;"><b>Total</b></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td style="border-right:0px solid black !important;" align="right" class="totalCol"></td>
										</tr>
								</tbody>
							</table>
						</div>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
			<xsl:for-each select="//Detail2">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:if test="$dbID = '1'">
					<xsl:variable name="pan_no"><xsl:value-of select="pan_no"/></xsl:variable>
					<xsl:variable name="aadhar_no"><xsl:value-of select="aadhar_no"/></xsl:variable>
					<div class="inputFormDiv">
						<div class="eachLineFields">
							<div class="eachField">
								<div class="labelDiv">Sign method<span style="color:red;">*</span> : </div>
								<div class="inputDiv">
									<select class="input_editable" name="Detail2.{normalize-space($dbID)}.sign_method" id="Detail2.{normalize-space($dbID)}.sign_method" onchange="showDocTextbox(this)">
										<option Value=""></option>
										<xsl:for-each select="sign_data/data">
											<xsl:variable name="sign_method"><xsl:value-of select="sign_method"/></xsl:variable>
											<xsl:if test="$sign_method='D'">
												<option value="D">Digital Sign</option>
											</xsl:if>
											<xsl:if test="$sign_method='E'">
												<option value="E">E-Sign</option>
											</xsl:if>
										</xsl:for-each>
									</select>
								</div>
							</div>
						</div>
						<div class="eachLineFields">
							<div class="eachField" id ="panTextbox" style="display:none;">
								<div class="labelDiv">PAN<span style="color:red;">*</span> : </div>
								<div class="inputDiv"><input type="text" class="input_editable" value="{$pan_no}" name="Detail2.{normalize-space($dbID)}.pan_no" id="Detail2.{normalize-space($dbID)}.pan_no"/></div>
							</div>
							<div class="eachField" id="aadhaarTextbox" style="display:none;">
								<div class="labelDiv">Aadhaar<span style="color:red;">*</span> : </div>
								<div class="inputDiv"><input type="number" class="input_editable" value="{$aadhar_no}" name="Detail2.{normalize-space($dbID)}.aadhar_no" id="Detail2.{normalize-space($dbID)}.aadhar_no"/></div>
							</div>
						</div>
					</div>
				</xsl:if>
			</xsl:for-each>
		</div>
		<div id="btnDiv">
			<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden" value="gstsalesdata_file" name="OBJ_NAME" />
			<input type="hidden" value="finish" name="action" id="action" />
			<input type="button" style="cursor:hand;margin-left:20px;" value="Finish" onclick="getSignedData('GSTR1');" class="button" title='Finish' id="finish"/>
		</div>
	</div>
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
