package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.LiveEventMgrWiseDetailsRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

@SuppressWarnings("serial")
public class ParticipentProductMgrWiseDetailServlet extends HttpServlet
{
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		LiveEventMgrWiseDetailsRemote liveEventDetailsRemote = null;
		InitialContext context        = null;
		AppConnectParm appConnectParm = null;
		String dataSourceName         = "";
		String eventCode              = "";
		String participentCode        = "";
		String rowsValue              = "";
		String loginId                = "";
		HttpSession session           = null;
		UserInfoBean userInfo         = null;
		
		try
		{
			response.setContentType("application/xml");
			appConnectParm            = new AppConnectParm();
			session 				  = request.getSession(true);
			userInfo 				  = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId 				  = userInfo.getLoginCode();
			dataSourceName            = request.getParameter("dataSourceName");
			eventCode                 = request.getParameter("survey_templ");
			participentCode           = request.getParameter("participants_code");
			rowsValue                 = request.getParameter("P1").trim();
			System.out.println(" ParticipentProductMgrWiseDetailServlet eventCode :"+eventCode+"----participentCode :  "+participentCode+"loginId:"+loginId) ;		
			context                   = new InitialContext(appConnectParm.getProperty());
			liveEventDetailsRemote    = (LiveEventMgrWiseDetailsRemote) context.lookup("ibase/LiveEventMgrWiseDetails/remote");
			JSONObject jsonObjData    = (JSONObject) liveEventDetailsRemote.getParticipentProductDetail(dataSourceName,eventCode,participentCode,loginId);
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
		    outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for ParticipentProductMgrWiseDetailServlet===" + jsonObjData);					

		} catch (Exception e)
		{
			System.out.println("Exception : ParticipentProductMgrWiseDetailServlet :doPost() :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}
}