/**
 *  Purpose: Dashboard for Consignment Details, Reuest ID: W15CSUN006  
 *  Author: Sneha Mestry
 *  Date: 16-06-2015
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class ConsignmentDetails extends ValidatorEJB implements ConsignmentDetailsRemote, ConsignmentDetailsLocal
{
		
	public ConsignmentDetails()
	{}
	E12GenericUtility genericUtility = new E12GenericUtility();
	//1.This is the main method to show the parent graph 
	@SuppressWarnings("unchecked")	
	
	//public JSONObject getConsignmentDetails(String dataSourceName, String siteCode) throws RemoteException, ITMException
	
	//Changed by Sneha on 21-07-2015, for date parameter Request ID: D15DKAT009 
	public JSONObject getConsignmentDetails(String dataSourceName, String siteCode, String fromDate, String toDate) throws RemoteException, ITMException
	//End by Sneha on 21-07-2015, for date parameter Request ID: D15DKAT009 
	{
		JSONObject rawDataJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();	
		String shipment = "", cases = "", weight = "", tasks = "", order = "", week = "", distWeight = "", distCases = "",
			   consumeWeight = "", consumeCases = "", totalWeight = "", totalCases = "", inputDate = "", date = "";
		
		

		//Changed by Sneha on 21-07-2015, Request ID: W15ESUN005 
		Timestamp shipDate = null;
		Date fromDateCurMonth = null, toDateCurMonth = null, firstDate = null, lastDate = null;		
		//End by Sneha on 21-07-2015, Request ID: W15ESUN005 
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB(dataSourceName);
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			//Commented by Santosh on 14-06-2016
			//connDriver = null;
			int count = 0;
			int noOfDays = 0, dtCount = 0;
			Calendar cal = Calendar.getInstance();
			Calendar cal1 = Calendar.getInstance();
			
			//Changed by Sneha on 21-07-2015, Request ID: W15ESUN005 		
			SimpleDateFormat dbDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat()); 
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Format formatter = new SimpleDateFormat("dd-MMM-yy");
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
			
			if(fromDate.equals(null) ||  toDate.equals(null) || fromDate.equals("") ||  toDate.equals(""))
			{
				fromDateCurMonth = cal.getTime();
				cal.set(Calendar.DAY_OF_MONTH, 1);
				fromDateCurMonth = cal.getTime(); 
				System.out.println("1st date of current month :::::::::: " + fromDateCurMonth); 
				
				toDateCurMonth = cal1.getTime(); 
				cal1.add(Calendar.DATE, + 1);
				toDateCurMonth = cal1.getTime(); 
				System.out.println("Added 1day in current date :::::::::: " + toDateCurMonth); 
				
				while(fromDateCurMonth.before(toDateCurMonth))
			    { 
				 	inputDate = dbDateFormat.format(cal.getTime());
					shipDate = Timestamp.valueOf(inputDate + " 00:00:00.0");
					System.out.println("TimeStamp Date :::::: " + shipDate);

			 	    // no of shipment 
					sql = "select count(shipment_id) from shipment where site_code = ?  and confirmed = 'Y' and " 
						+ "shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						shipment = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// no of cases 
					sql = "select  sum(despatchdet.no_art) from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
						+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id " 
						+ "and despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id " 
						+ "and ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						cases = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// no of weight  
					sql = "select  sum(despatchdet.gross_weight)  from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
						+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id and " 
						+ "despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id and " 
						+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = ? "; 
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						weight = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// sum of weight and no of cases for  D-ISS  
					sql = "select sum(case when distord_issdet.gross_weight is null then 0 else distord_issdet.gross_weight end), " 
						+ "sum(case when distord_issdet.no_art is null then 0 else distord_issdet.no_art end) from distord_iss distord_iss, " 
						+ "distord_issdet distord_issdet, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='D-ISS' and " 
						+ "shipment.confirmed = 'Y' and ship_docs.ref_id = distord_iss.tran_id and distord_issdet.tran_id = distord_iss.tran_id and " 
						+ "distord_issdet.tran_id = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? and " 
						+ "shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						distWeight = checkNull(rs.getString(1));
						distCases = checkNull(rs.getString(2));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// sum of weight and no of cases for  C-ISS  
					sql = "select sum(case when consume_iss.gross_weight is null then 0 else consume_iss.gross_weight end), " 
						+ "sum(case when consume_iss_det.no_art is null then 0 else consume_iss_det.no_art end) from consume_iss consume_iss, " 
						+ "consume_iss_det consume_iss_det, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='C-ISS' and " 
						+ "shipment.confirmed = 'Y' and consume_iss_det.cons_issue = consume_iss.cons_issue and ship_docs.ref_id = consume_iss.cons_issue " 
						+ "and consume_iss_det.cons_issue = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? " 
						+ "and shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						consumeWeight = checkNull(rs.getString(1)); 
						consumeCases  = checkNull(rs.getString(2));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					//no of tasks performed 
					sql = "select COUNT(*) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det where " 
						+ "shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
						+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						tasks = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}

					// no of order process 
					sql = "select COUNT(distinct wave_task_det.ptcn) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det " 
						+ "where shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
						+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						order = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					// Sum of weight and Total count of Cases
					totalWeight = weight + distWeight + consumeWeight;
					totalCases = cases + distCases + consumeCases;
					date = formatter.format(fromDateCurMonth);

					rowData = new JSONObject();
					rowData.put("date", date);
					rowData.put("shipment", shipment);
					rowData.put("cases", totalCases);
					rowData.put("weight", totalWeight);
					rowData.put("tasks", tasks);
					rowData.put("order", order);
					rawDataJson.put(count, rowData);
					count++;

				 	cal.add(Calendar.DATE, + 1);
				 	fromDateCurMonth = cal.getTime();   
					System.out.println("Added 1day in current date :::::: " + fromDateCurMonth);
			    }
			} 
			else 
			{
				//Changed by Sneha on 23-09-2015 for date format, Request ID: W15ESUN005 
				sql = "SELECT to_date(?,'dd/mm/yy') - to_date(?,'dd/mm/yy') AS NO_OF_DAYS from dual ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, toDate); 
				pstmt.setString(2, fromDate); 
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					noOfDays = rs.getInt("NO_OF_DAYS");
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;	
				}
				System.out.println("noOfDays :::::::::::: " + noOfDays);
				
				while(noOfDays >= dtCount)
				{
					sql = "select count(shipment_id) from shipment where site_code = ?  and confirmed = 'Y' and " 
						+ "shipment_date = to_date(?,'dd/mm/yy') ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setString(2, fromDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						shipment = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// no of cases for parameter date
					sql = "select  sum(despatchdet.no_art) from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
						+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id " 
						+ "and despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id " 
						+ "and ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = to_date(?,'dd/mm/yy') ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setString(2, fromDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						cases = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// no of weight 
					sql = "select  sum(despatchdet.gross_weight)  from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
						+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id and " 
						+ "despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id and " 
						+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = to_date(?,'dd/mm/yy') "; 
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setString(2, fromDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						weight = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// sum of weight and no of cases for  D-ISS  
					sql = "select sum(case when distord_issdet.gross_weight is null then 0 else distord_issdet.gross_weight end), " 
						+ "sum(case when distord_issdet.no_art is null then 0 else distord_issdet.no_art end) from distord_iss distord_iss, " 
						+ "distord_issdet distord_issdet, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='D-ISS' and " 
						+ "shipment.confirmed = 'Y' and ship_docs.ref_id = distord_iss.tran_id and distord_issdet.tran_id = distord_iss.tran_id and " 
						+ "distord_issdet.tran_id = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? and " 
						+ "shipment.shipment_date = to_date(?,'dd/mm/yy') ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setString(2, fromDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						distWeight = checkNull(rs.getString(1));
						distCases = checkNull(rs.getString(2));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// sum of weight and no of cases for  C-ISS  
					sql = "select sum(case when consume_iss.gross_weight is null then 0 else consume_iss.gross_weight end), " 
						+ "sum(case when consume_iss_det.no_art is null then 0 else consume_iss_det.no_art end) from consume_iss consume_iss, " 
						+ "consume_iss_det consume_iss_det, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='C-ISS' and " 
						+ "shipment.confirmed = 'Y' and consume_iss_det.cons_issue = consume_iss.cons_issue and ship_docs.ref_id = consume_iss.cons_issue " 
						+ "and consume_iss_det.cons_issue = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? " 
						+ "and shipment.shipment_date = to_date(?,'dd/mm/yy') ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setString(2, fromDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						consumeWeight = checkNull(rs.getString(1)); 
						consumeCases  = checkNull(rs.getString(2));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					//no of tasks performed 
					sql = "select COUNT(*) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det where " 
						+ "shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
						+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = to_date(?,'dd/mm/yy') ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setString(2, fromDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						tasks = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}

					// no of order process 
					sql = "select COUNT(distinct wave_task_det.ptcn) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det " 
						+ "where shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
						+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = to_date(?,'dd/mm/yy') ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setString(2, fromDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						order = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					// Sum of weight and Total count of Cases
					totalWeight = weight + distWeight + consumeWeight;
					totalCases = cases + distCases + consumeCases;

					
					firstDate = sdf.parse(fromDate);
					cal1.setTime(firstDate);
					firstDate = cal1.getTime(); 
					date = formatter.format(firstDate);

					rowData = new JSONObject();
					rowData.put("date", date);
					rowData.put("shipment", shipment);
					rowData.put("cases", totalCases);
					rowData.put("weight", totalWeight);
					rowData.put("tasks", tasks);
					rowData.put("order", order);
					rawDataJson.put(count, rowData);
					count++;
					
					cal1.add(Calendar.DATE, + 1);
					firstDate = cal1.getTime(); 
					fromDate = sdf.format(firstDate);	
					System.out.println("Added 1day to fromDate :::::::::: " + firstDate);
					dtCount++;
				}	
				//End by Sneha on 23-09-2015 for date format, Request ID: W15ESUN005 
				
				/*
				firstDate = simpleDateFormat.parse(fromDate);
				lastDate = simpleDateFormat.parse(toDate);
			   
				cal1.setTime(lastDate);
				cal1.add(Calendar.DATE, + 1);
				lastDate = cal1.getTime(); 
				System.out.println("Added 1day to To_Date :::::::::: " + lastDate);
				
				
			    while(firstDate.before(lastDate))
			    { 
				    cal.setTime(firstDate);
					inputDate = dbDateFormat.format(cal.getTime());
					shipDate = Timestamp.valueOf(inputDate + " 00:00:00.0");
					System.out.println("Shipment Date :::::: " + shipDate);*/
					
			 	    // no of shipment for parameter date
					/*sql = "select count(shipment_id) from shipment where site_code = ?  and confirmed = 'Y' and " 
						+ "shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						shipment = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// no of cases for parameter date
					sql = "select  sum(despatchdet.no_art) from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
						+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id " 
						+ "and despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id " 
						+ "and ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						cases = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// no of weight 
					sql = "select  sum(despatchdet.gross_weight)  from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
						+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id and " 
						+ "despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id and " 
						+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = ? "; 
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						weight = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// sum of weight and no of cases for  D-ISS  
					sql = "select sum(case when distord_issdet.gross_weight is null then 0 else distord_issdet.gross_weight end), " 
						+ "sum(case when distord_issdet.no_art is null then 0 else distord_issdet.no_art end) from distord_iss distord_iss, " 
						+ "distord_issdet distord_issdet, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='D-ISS' and " 
						+ "shipment.confirmed = 'Y' and ship_docs.ref_id = distord_iss.tran_id and distord_issdet.tran_id = distord_iss.tran_id and " 
						+ "distord_issdet.tran_id = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? and " 
						+ "shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						distWeight = checkNull(rs.getString(1));
						distCases = checkNull(rs.getString(2));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					// sum of weight and no of cases for  C-ISS  
					sql = "select sum(case when consume_iss.gross_weight is null then 0 else consume_iss.gross_weight end), " 
						+ "sum(case when consume_iss_det.no_art is null then 0 else consume_iss_det.no_art end) from consume_iss consume_iss, " 
						+ "consume_iss_det consume_iss_det, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='C-ISS' and " 
						+ "shipment.confirmed = 'Y' and consume_iss_det.cons_issue = consume_iss.cons_issue and ship_docs.ref_id = consume_iss.cons_issue " 
						+ "and consume_iss_det.cons_issue = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? " 
						+ "and shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						consumeWeight = checkNull(rs.getString(1)); 
						consumeCases  = checkNull(rs.getString(2));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					
					//no of tasks performed 
					sql = "select COUNT(*) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det where " 
						+ "shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
						+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						tasks = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}

					// no of order process 
					sql = "select COUNT(distinct wave_task_det.ptcn) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det " 
						+ "where shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
						+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode); 
					pstmt.setTimestamp(2, shipDate); 
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						order = checkNull(rs.getString(1));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
					// Sum of weight and Total count of Cases
					totalWeight = weight + distWeight + consumeWeight;
					totalCases = cases + distCases + consumeCases;
					date = formatter.format(firstDate);
					
					rowData = new JSONObject();
					rowData.put("date", date);
					rowData.put("shipment", shipment);
					rowData.put("cases", totalCases);
					rowData.put("weight", totalWeight);
					rowData.put("tasks", tasks);
					rowData.put("order", order);
					rawDataJson.put(count, rowData);
					count++;

					cal.add(Calendar.DATE, + 1);
				 	firstDate = cal.getTime();   
					System.out.println("Added 1day in current date :::::: " + firstDate);   
			    }	*/				
			}			
			//End by Sneha on 21-07-2015, Request ID: W15ESUN005 
			
		    /*
			Date dt1 = null, dt2 = null, dt3 = null, dt4 = null;
			String week1Date = "", week2Date = "", week3Date = "", week4Date = "", ;

			Format formatter = new SimpleDateFormat("dd-MMM-yy");
			
			// 1st week date 
			cal.add(Calendar.DATE, -1);cal.add(Calendar.DATE, -1);
		    //cal.add(Calendar.DATE, + 7);
		    //cal.add(Calendar.MONTH, - 2);
		    dt1 = cal.getTime();  
		    week1Date = formatter.format(dt1);
		    System.out.println("1st week date ::::::: " + week1Date);
		    
		    // 2nd week date 
		    cal.add(Calendar.DATE, - 7);
		    dt2 = cal.getTime();  
		    week2Date = formatter.format(dt2);
		    System.out.println("2nd week date ::::::: " + week2Date);
		    
		    // 3rd week date 
		    cal.add(Calendar.DATE, - 7);
		    dt3 = cal.getTime();  
		    week3Date = formatter.format(dt3);
		    System.out.println("3rd week date ::::::: " + week3Date);
		    
		    // 4th week date 
		    cal.add(Calendar.DATE, - 7);
		    dt4 = cal.getTime();  
		    week4Date = formatter.format(dt4);
		    System.out.println("4th week date ::::::: " + week4Date);
		   
		    System.out.println(" ************** 1st week ****************** ");
			// no of shipment for 1st week
			sql = "select count(shipment_id) from shipment where site_code = ?  and confirmed = 'Y' and " 
				+ "shipment_date > ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week1Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				shipment = checkNull(rs.getString(1));
				System.out.println("No of Shipment for 1st Week  :::::::::: " + shipment);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// no of cases for 1st week
			sql = "select  sum(despatchdet.no_art) from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
				+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id " 
				+ "and despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id " 
				+ "and ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date > ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week1Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cases = checkNull(rs.getString(1));
				System.out.println("No of cases  for 1st Week :::::::::: " + cases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// no of weight for 1st week
			sql = "select  sum(despatchdet.gross_weight)  from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
				+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id and " 
				+ "despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date > ? "; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week1Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				weight = checkNull(rs.getString(1));
				System.out.println("Sum of weight for 1st Week  :::::::::: " + weight);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// sum of weight and no of cases for  D-ISS  1st week
			sql = "select sum(case when distord_issdet.gross_weight is null then 0 else distord_issdet.gross_weight end), " 
				+ "sum(case when distord_issdet.no_art is null then 0 else distord_issdet.no_art end) from distord_iss distord_iss, " 
				+ "distord_issdet distord_issdet, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='D-ISS' and " 
				+ "shipment.confirmed = 'Y' and ship_docs.ref_id = distord_iss.tran_id and distord_issdet.tran_id = distord_iss.tran_id and " 
				+ "distord_issdet.tran_id = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? and " 
				+ "shipment.shipment_date > ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week1Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				distWeight = checkNull(rs.getString(1));
				distCases = checkNull(rs.getString(2));
				System.out.println("Sum of weight from D-ISS for 1st Week  :::::::::: " + distWeight);
				System.out.println("No of cases from D-ISS for 1st Week  :::::::::: " + distCases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// sum of weight and no of cases for  C-ISS  1st week
			sql = "select sum(case when consume_iss.gross_weight is null then 0 else consume_iss.gross_weight end), " 
				+ "sum(case when consume_iss_det.no_art is null then 0 else consume_iss_det.no_art end) from consume_iss consume_iss, " 
				+ "consume_iss_det consume_iss_det, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='C-ISS' and " 
				+ "shipment.confirmed = 'Y' and consume_iss_det.cons_issue = consume_iss.cons_issue and ship_docs.ref_id = consume_iss.cons_issue " 
				+ "and consume_iss_det.cons_issue = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? " 
				+ "and shipment.shipment_date > ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week1Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				consumeWeight = checkNull(rs.getString(1)); 
				consumeCases  = checkNull(rs.getString(2));
				System.out.println("Sum of weight from C-ISS for 1st Week  :::::::::: " + consumeWeight);
				System.out.println("No of cases from C-ISS for 1st Week  :::::::::: " + consumeCases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			//no of tasks performed for 1st week
			sql = "select COUNT(*) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det where " 
				+ "shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date > ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week1Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				tasks = checkNull(rs.getString(1));
				System.out.println("No of task performed  for 1st Week :::::::::: " + tasks);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}

			// no of order process for 1st week
			sql = "select COUNT(distinct wave_task_det.ptcn) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det " 
				+ "where shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date > ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week1Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				order = checkNull(rs.getString(1));
				System.out.println("no of order process for 1st Week :::::::::: " + order);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			// Sum of weight and Total cont of Cases
			totalWeight = weight + distWeight + consumeWeight;
			totalCases = cases + distCases + consumeCases;
			
			rowData = new JSONObject();
			week = "Week 1";
			rowData.put("week", week);
			rowData.put("shipment", shipment);
			rowData.put("cases", totalCases);
			rowData.put("weight", totalWeight);
			rowData.put("tasks", tasks);
			rowData.put("order", order);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("1st Week data in rowData :::::::::: " + rowData);
			System.out.println("1st Week data in rawDataJson :::::::::: " + rawDataJson);
			
			System.out.println(" ************** 2nd week ****************** ");
			// no of shipment for 2nd week
			sql = "select count(shipment_id) from shipment where site_code = ?  and confirmed = 'Y' and " 
				+ "shipment_date between ? and ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week2Date); 
			pstmt.setString(3, week1Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				shipment = checkNull(rs.getString(1));
				System.out.println("No of Shipment  for 2nd week :::::::::: " + shipment);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// no of cases for 2nd week
			sql = "select  sum(despatchdet.no_art) from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
				+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id " 
				+ "and despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id " 
				+ "and ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date between ? and ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week2Date); 
			pstmt.setString(3, week1Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cases = checkNull(rs.getString(1));
				System.out.println("No of cases for 2nd week :::::::::: " + cases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// no of weight for 2nd week
			sql = "select  sum(despatchdet.gross_weight)  from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
				+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id and " 
				+ "despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date between ? and ? "; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week2Date); 
			pstmt.setString(3, week1Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				weight = checkNull(rs.getString(1));
				System.out.println("Sum of weight for 2nd week :::::::::: " + weight);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// sum of weight and no of cases for  D-ISS  1st week
			sql = "select sum(case when distord_issdet.gross_weight is null then 0 else distord_issdet.gross_weight end), " 
				+ "sum(case when distord_issdet.no_art is null then 0 else distord_issdet.no_art end) from distord_iss distord_iss, " 
				+ "distord_issdet distord_issdet, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='D-ISS' and " 
				+ "shipment.confirmed = 'Y' and ship_docs.ref_id = distord_iss.tran_id and distord_issdet.tran_id = distord_iss.tran_id and " 
				+ "distord_issdet.tran_id = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? and " 
				+ "shipment.shipment_date  between ? and ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week2Date); 
			pstmt.setString(3, week1Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				distWeight = checkNull(rs.getString(1));
				distCases = checkNull(rs.getString(2));
				System.out.println("Sum of weight from D-ISS for 2nd Week  :::::::::: " + distWeight);
				System.out.println("No of cases from D-ISS for 2nd Week  :::::::::: " + distCases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// sum of weight and no of cases for  C-ISS  1st week
			sql = "select sum(case when consume_iss.gross_weight is null then 0 else consume_iss.gross_weight end), " 
				+ "sum(case when consume_iss_det.no_art is null then 0 else consume_iss_det.no_art end) from consume_iss consume_iss, " 
				+ "consume_iss_det consume_iss_det, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='C-ISS' and " 
				+ "shipment.confirmed = 'Y' and consume_iss_det.cons_issue = consume_iss.cons_issue and ship_docs.ref_id = consume_iss.cons_issue " 
				+ "and consume_iss_det.cons_issue = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? " 
				+ "and shipment.shipment_date  between ? and ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week2Date); 
			pstmt.setString(3, week1Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				consumeWeight = checkNull(rs.getString(1)); 
				consumeCases  = checkNull(rs.getString(2));
				System.out.println("Sum of weight from C-ISS for 2nd Week  :::::::::: " + consumeWeight);
				System.out.println("No of cases from C-ISS for 2nd Week  :::::::::: " + consumeCases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			//no of tasks performed for 2nd week
			sql = "select COUNT(*) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det where " 
				+ "shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date  between ? and ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week2Date); 
			pstmt.setString(3, week1Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				tasks = checkNull(rs.getString(1));
				System.out.println("No of task performed for 2nd Week :::::::::: " + tasks);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}

			// no of order process for 2nd week
			sql = "select COUNT(distinct wave_task_det.ptcn) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det " 
				+ "where shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date between ? and ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week2Date); 
			pstmt.setString(3, week1Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				order = checkNull(rs.getString(1));
				System.out.println("no of order process for 2nd Week :::::::::: " + order);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// Sum of weight and Total cont of Cases
			totalWeight = weight + distWeight + consumeWeight;
			totalCases = cases + distCases + consumeCases;
			
			rowData = new JSONObject();
			week = "Week 2";
			rowData.put("week", week);
			rowData.put("shipment", shipment);
			rowData.put("cases", totalCases);
			rowData.put("weight", totalWeight);
			rowData.put("tasks", tasks);
			rowData.put("order", order);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("2nd Week data in rowData :::::::::: " + rowData);
			System.out.println("2nd Week data in rawDataJson :::::::::: " + rawDataJson);
			
			
			System.out.println(" ************** 3rd week ****************** ");
			// no of shipment for 3rd week
			sql = "select count(shipment_id) from shipment where site_code = ?  and confirmed = 'Y' and " 
				+ "shipment_date between ? and ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, week3Date); 
			pstmt.setString(3, week2Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				shipment = checkNull(rs.getString(1));
				System.out.println("No of Shipment for 3rd Week :::::::::: " + shipment);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}		
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// no of cases for 3rd week
			sql = "select  sum(despatchdet.no_art) from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
				+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id " 
				+ "and despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id " 
				+ "and ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date between ? and ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week3Date); 
			pstmt.setString(3, week2Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cases = checkNull(rs.getString(1));
				System.out.println("No of cases for 3rd Week :::::::::: " + cases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// no of weight for 3rd week
			sql = "select  sum(despatchdet.gross_weight)  from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
				+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id and " 
				+ "despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date between ? and ? "; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week3Date); 
			pstmt.setString(3, week2Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				weight = checkNull(rs.getString(1));
				System.out.println("Sum of weight for 3rd Week  :::::::::: " + weight);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			

			// sum of weight and no of cases for  D-ISS  1st week
			sql = "select sum(case when distord_issdet.gross_weight is null then 0 else distord_issdet.gross_weight end), " 
				+ "sum(case when distord_issdet.no_art is null then 0 else distord_issdet.no_art end) from distord_iss distord_iss, " 
				+ "distord_issdet distord_issdet, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='D-ISS' and " 
				+ "shipment.confirmed = 'Y' and ship_docs.ref_id = distord_iss.tran_id and distord_issdet.tran_id = distord_iss.tran_id and " 
				+ "distord_issdet.tran_id = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? and " 
				+ "shipment.shipment_date  between ? and ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week3Date); 
			pstmt.setString(3, week2Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				distWeight = checkNull(rs.getString(1));
				distCases = checkNull(rs.getString(2));
				System.out.println("Sum of weight from D-ISS for 3rd Week  :::::::::: " + distWeight);
				System.out.println("No of cases from D-ISS for 3rd Week  :::::::::: " + distCases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// sum of weight and no of cases for  C-ISS  1st week
			sql = "select sum(case when consume_iss.gross_weight is null then 0 else consume_iss.gross_weight end), " 
				+ "sum(case when consume_iss_det.no_art is null then 0 else consume_iss_det.no_art end) from consume_iss consume_iss, " 
				+ "consume_iss_det consume_iss_det, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='C-ISS' and " 
				+ "shipment.confirmed = 'Y' and consume_iss_det.cons_issue = consume_iss.cons_issue and ship_docs.ref_id = consume_iss.cons_issue " 
				+ "and consume_iss_det.cons_issue = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? " 
				+ "and shipment.shipment_date  between ? and ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week3Date); 
			pstmt.setString(3, week2Date); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				consumeWeight = checkNull(rs.getString(1)); 
				consumeCases  = checkNull(rs.getString(2));
				System.out.println("Sum of weight from C-ISS for 3rd Week  :::::::::: " + consumeWeight);
				System.out.println("No of cases from C-ISS for 3rd Week  :::::::::: " + consumeCases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			//no of tasks performed for 3rd week
			sql = "select COUNT(*) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det where " 
				+ "shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date  between ? and ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week3Date); 
			pstmt.setString(3, week2Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				tasks = checkNull(rs.getString(1));
				System.out.println("No of task performed for 3rd Week :::::::::: " + tasks);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}

			// no of order process for 3rd week
			sql = "select COUNT(distinct wave_task_det.ptcn) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det " 
				+ "where shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date between ? and ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week3Date); 
			pstmt.setString(3, week2Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				order = checkNull(rs.getString(1));
				System.out.println("no of order process for 3rd Week :::::::::: " + order);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			// Sum of weight and Total cont of Cases
			totalWeight = weight + distWeight + consumeWeight;
			totalCases = cases + distCases + consumeCases;
			
			rowData = new JSONObject();
			week = "Week 3";
			rowData.put("week", week);
			rowData.put("shipment", shipment);
			rowData.put("cases", totalCases);
			rowData.put("weight", totalWeight);
			rowData.put("tasks", tasks);
			rowData.put("order", order);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("3rd Week data in rowData :::::::::: " + rowData);
			System.out.println("3rd Week data in rawDataJson :::::::::: " + rawDataJson);
			
			System.out.println(" ************** 4th week ****************** ");
			// no of shipment for 4th week
			sql = "select count(shipment_id) from shipment where site_code = ?  and confirmed = 'Y' and " 
				+ "shipment_date between ? and ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week4Date); 
			pstmt.setString(3, week3Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				shipment = checkNull(rs.getString(1));
				System.out.println("No of Shipment for 4th Week :::::::::: " + shipment);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// no of cases for 4th week
			sql = "select  sum(despatchdet.no_art) from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
				+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id " 
				+ "and despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id " 
				+ "and ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date between ? and ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week4Date); 
			pstmt.setString(3, week3Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cases = checkNull(rs.getString(1));
				System.out.println("No of cases for 4th Week :::::::::: " + cases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// no of weight for 4th week
			sql = "select  sum(despatchdet.gross_weight)  from despatchdet despatchdet ,despatch despatch, ship_docs ship_docs, shipment shipment " 
				+ "where despatch.site_code = ? and despatch.desp_id = despatchdet.desp_id and ship_docs.ref_id = despatchdet.desp_id and " 
				+ "despatch.desp_id = ship_docs.ref_id and ship_docs.ref_ser ='S-DSP' and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date between ? and ? "; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week4Date); 
			pstmt.setString(3, week3Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				weight = checkNull(rs.getString(1));
				System.out.println("Sum of weight for 4th Week :::::::::: " + weight);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}

			// sum of weight and no of cases for  D-ISS  1st week
			sql = "select sum(case when distord_issdet.gross_weight is null then 0 else distord_issdet.gross_weight end), " 
				+ "sum(case when distord_issdet.no_art is null then 0 else distord_issdet.no_art end) from distord_iss distord_iss, " 
				+ "distord_issdet distord_issdet, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='D-ISS' and " 
				+ "shipment.confirmed = 'Y' and ship_docs.ref_id = distord_iss.tran_id and distord_issdet.tran_id = distord_iss.tran_id and " 
				+ "distord_issdet.tran_id = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? and " 
				+ "shipment.shipment_date  between ? and ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week4Date); 
			pstmt.setString(3, week3Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				distWeight = checkNull(rs.getString(1));
				distCases = checkNull(rs.getString(2));
				System.out.println("Sum of weight from D-ISS for 4th Week  :::::::::: " + distWeight);
				System.out.println("No of cases from D-ISS for 4th Week  :::::::::: " + distCases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			// sum of weight and no of cases for  C-ISS  1st week
			sql = "select sum(case when consume_iss.gross_weight is null then 0 else consume_iss.gross_weight end), " 
				+ "sum(case when consume_iss_det.no_art is null then 0 else consume_iss_det.no_art end) from consume_iss consume_iss, " 
				+ "consume_iss_det consume_iss_det, ship_docs ship_docs, shipment shipment where ship_docs.ref_ser ='C-ISS' and " 
				+ "shipment.confirmed = 'Y' and consume_iss_det.cons_issue = consume_iss.cons_issue and ship_docs.ref_id = consume_iss.cons_issue " 
				+ "and consume_iss_det.cons_issue = ship_docs.ref_id and ship_docs.shipment_id = shipment.shipment_id and shipment.site_code = ? " 
				+ "and shipment.shipment_date  between ? and ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week4Date); 
			pstmt.setString(3, week3Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				consumeWeight = checkNull(rs.getString(1)); 
				consumeCases  = checkNull(rs.getString(2));
				System.out.println("Sum of weight from C-ISS for 4th Week  :::::::::: " + consumeWeight);
				System.out.println("No of cases from C-ISS for 4th Week  :::::::::: " + consumeCases);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			
			//no of tasks performed for 4th week
			sql = "select COUNT(*) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det where " 
				+ "shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date  between ? and ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week4Date); 
			pstmt.setString(3, week3Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				tasks = checkNull(rs.getString(1));
				System.out.println("No of task performed for 4th Week :::::::::: " + tasks);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}

			// no of order process for 4th week
			sql = "select COUNT(distinct wave_task_det.ptcn) from ship_docs ship_docs, shipment shipment, wave_task_det wave_task_det " 
				+ "where shipment.site_code = ? and ship_docs.ptcn = wave_task_det.ptcn and ship_docs.shipment_id = shipment.shipment_id and " 
				+ "ship_docs.ref_ser ='S-DSP' and shipment.confirmed = 'Y' and shipment.shipment_date between ? and ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode); 
			pstmt.setString(2, week4Date); 
			pstmt.setString(3, week3Date);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				order = checkNull(rs.getString(1));
				System.out.println("no of order process for 4th Week :::::::::: " + order);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
			// Sum of weight and Total cont of Cases
			totalWeight = weight + distWeight + consumeWeight;
			totalCases = cases + distCases + consumeCases;
			
			rowData = new JSONObject();
			week = "Week 4";
			rowData.put("week", week);
			rowData.put("shipment", shipment);
			rowData.put("cases", totalCases);
			rowData.put("weight", totalWeight);
			rowData.put("tasks", tasks);
			rowData.put("order", order);
			rawDataJson.put(count, rowData);
			count++;
			System.out.println("3rd Week data in rowData :::::::::: " + rowData);
			System.out.println("3rd Week data in rawDataJson :::::::::: " + rawDataJson);
		*/
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}				
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ConsignmentDetails.getConsignmentDetails(String dataSourceName, String siteCode):" + d.getMessage());
				throw new ITMException(d);
			}
		}
	
		return rawDataJson;
	}
	
	private String checkNull(String str)
	{
		if(str == null)
		{
			return "0";
		}
		else
		{
			return str.trim();
		}

	}
		
}
