package ibase.dashboard.sfa.ejb;
import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;
import org.json.simple.JSONObject;
/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class ComplianceDB2 extends ValidatorEJB implements ComplianceDB2Local, ComplianceDB2Remote
{
	public ComplianceDB2() {
        // TODO Auto-generated constructor stub
    }
	 GenericUtility genericUtility = GenericUtility.getInstance();
	 /*Start Below 3 methods for Franco Compliance Report by Nikhil 
		on Dated 21/06/2016*/
		
		
		    @SuppressWarnings("unchecked")
			@Override
		    public JSONObject getComplianceHirarchyDB2(String loginId,String dataSourceName,String period) throws RemoteException, ITMException
		    {
				JSONObject rawDataComplianceHirarchyDB2Json = new JSONObject();
				JSONObject rowData = null;
				String sql = "";
				ResultSet rs = null;
				PreparedStatement pstmt = null;
				Connection conn = null;
				ConnDriver connDriver = new ConnDriver();
				try
				{
					System.out.println(" Inside ComplianceDB2 for getComplianceHirarchyDB2 Data Soruc Namem 11 ="+dataSourceName+" loginId=:"+ loginId+"---- month=:"+ period);
					conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;	
								
					/*old test sql for Franco*/
					
					/*sql = " Select  NSMCODE, NSMNAME, NSMDESG,SMCODE,SMNAME, SMDESG, RSECODE, RSENAME, RSEDESG, REPCODE, " +
					      " REPNAME, REPDESG, REP_NONREP,CNT " +
					      " FROM Temp_SALES_HIER_JJ_CNT ORDER BY smcode,rsecode, repcode"; */
					
					
					/*Final SQL for Franco Compliance by Nikhil on Dated 23 June 2016*/
					sql =   "SELECT F.NSMCODE ,F.NSMNAME ,F.NSMDESG ,F.SMCODE ,F.SMNAME ,F.SMDESG ," +
							"F.RSECODE ,F.RSENAME ,F.RSEDESG ,F.REPCODE ,F.REPNAME ,F.REPDESG ," +
							"F.REP_NONREP ,COUNT(*) CNT FROM ( SELECT DISTINCT UF.NSMCODE ,UF.NSMNAME ," +
							"UF.NSMDESG ,UF.SMCODE ,UF.SMNAME ,UF.SMDESG ,UF.RSECODE ,UF.RSENAME ," +
							"UF.RSEDESG ,UF.REPCODE ,UF.REPNAME ,UF.REPDESG ,UF.AVAILABLE_DY ," +
							"UF.ACTIVITY_CODE ,UF.REP_NONREP ,UF.CUSTOMER_NAME " +
							"FROM ( SELECT NSMCODE ,NSMNAME ,NSMDESG ,SMCODE ,SMNAME ,SMDESG ,RSECODE ," +
							"RSENAME ,RSEDESG ,REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ," +
							"SPRS_ACT_TRAN.ACTIVITY_CODE ,( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' " +
							"WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL " +
							"THEN '-' ELSE 'NR' END ) AS REP_NONREP ,CONCAT(CONCAT(COALESCE(STRG_CUSTOMER.FIRST_NAME, ''), " +
							"COALESCE(STRG_CUSTOMER.MIDDLE_NAME, '')), COALESCE(STRG_CUSTOMER.LAST_NAME, '')) AS CUSTOMER_NAME " +
							"FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY " +
							"FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ WHERE (NSMCODE = '"+loginId+"'  OR SMCODE = '"+loginId+"'  OR RSECODE = '"+loginId+"'  OR REPCODE = '"+loginId+"' )) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a " +
							"FROM sfa_time WHERE dt > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ," +
							"'00:00:00') AND DT <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') ) AV_DATES WHERE VW_SALES_HIER_JJ.a = AV_DATES.a  EXCEPT  " +
							"SELECT EMPLOYEE.EMP_CODE AS SALESPERS ,holiday.hol_date AS AVAILABLE_DY " +
							"FROM holiday ,EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno " +
							"AND holiday.hol_date > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ,'00:00:00') " +
							"AND holiday.hol_date <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') " +
							"AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code " +
							"AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV LEFT JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S " +
							"WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY " +
							"LEFT JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE " +
							"AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID " +
							"LEFT JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ " +
							"WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE " +
							"AND VW_SALES_HIER_JJ.NSMCODE = '"+loginId+"'  " +
							"UNION ALL  SELECT '' AS NSMCODE ,'' AS NSMNAME ,'' AS NSMDESG ,SMCODE ,SMNAME ,SMDESG ,RSECODE ,RSENAME ,RSEDESG ,REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ,SPRS_ACT_TRAN.ACTIVITY_CODE ,( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 " +
							"AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ," +
							"AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL " +
							"THEN '-' ELSE 'NR' END ) AS REP_NONREP ,CONCAT(CONCAT(COALESCE(STRG_CUSTOMER.FIRST_NAME, ''), " +
							"COALESCE(STRG_CUSTOMER.MIDDLE_NAME, '')), COALESCE(STRG_CUSTOMER.LAST_NAME, '')) AS CUSTOMER_NAME " +
							"FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY " +
							"FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ ) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a " +
							"FROM sfa_time WHERE dt > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ,'00:00:00') " +
							"AND DT <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') ) AV_DATES " +
							"WHERE VW_SALES_HIER_JJ.a = AV_DATES.a  EXCEPT  " +
							"SELECT EMPLOYEE.EMP_CODE AS SALESPERS ,holiday.hol_date AS AVAILABLE_DY FROM holiday ," +
							"EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno " +
							"AND holiday.hol_date > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ,'00:00:00') " +
							"AND holiday.hol_date <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') " +
							"AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code " +
							"AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV " +
							"LEFT JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' " +
							"AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS " +
							"AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY " +
							"LEFT JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS " +
							"AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID " +
							"LEFT JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ " +
							"WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE " +
							"AND VW_SALES_HIER_JJ.SMCODE = '"+loginId+"'  " +
							"UNION ALL  SELECT '' AS NSMCODE ,'' AS NSMNAME ,'' AS NSMDESG ,'' AS SMCODE ,'' AS SMNAME ,'' AS SMDESG ,RSECODE ,RSENAME ,RSEDESG ," +
							"REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ,SPRS_ACT_TRAN.ACTIVITY_CODE ,( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 " +
							"AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' " +
							"WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ," +
							"AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL " +
							"THEN '-' ELSE 'NR' END ) AS REP_NONREP ,CONCAT(CONCAT(COALESCE(STRG_CUSTOMER.FIRST_NAME, ''), " +
							"COALESCE(STRG_CUSTOMER.MIDDLE_NAME, '')), COALESCE(STRG_CUSTOMER.LAST_NAME, '')) AS CUSTOMER_NAME " +
							"FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY " +
							"FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ ) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a FROM sfa_time " +
							"WHERE dt > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ,'00:00:00') " +
							"AND DT <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') ) AV_DATES " +
							"WHERE VW_SALES_HIER_JJ.a = AV_DATES.a  EXCEPT  SELECT EMPLOYEE.EMP_CODE AS SALESPERS ," +
							"holiday.hol_date AS AVAILABLE_DY FROM holiday ,EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno " +
							"AND holiday.hol_date > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ,'00:00:00') " +
							"AND holiday.hol_date <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') " +
	                        "AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code " +
							"AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV LEFT JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S " +
							"WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS " +
							"AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY " +
							"LEFT JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS " +
							"AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID " +
							"LEFT JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ " +
							"WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE " +
							"AND VW_SALES_HIER_JJ.RSECODE = '"+loginId+"'  " +
							"UNION ALL  SELECT '' AS NSMCODE ,'' AS NSMNAME ,'' AS NSMDESG ,'' AS SMCODE ,'' AS SMNAME ,'' AS SMDESG ,'' AS RSECODE ,'' AS RSENAME ,'' AS RSEDESG ," +
							"REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ,SPRS_ACT_TRAN.ACTIVITY_CODE ,( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY " +
							"ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' " +
							"WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ," +
							"AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL " +
							"THEN '-' ELSE 'NR' END ) AS REP_NONREP ,CONCAT(CONCAT(COALESCE(STRG_CUSTOMER.FIRST_NAME, '')," +
							" COALESCE(STRG_CUSTOMER.MIDDLE_NAME, '')), COALESCE(STRG_CUSTOMER.LAST_NAME, '')) AS CUSTOMER_NAME " +
							"FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY " +
							"FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ ) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a " +
							"FROM sfa_time WHERE dt > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ,'00:00:00') " +
							"AND DT <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') ) AV_DATES " +
					        "WHERE VW_SALES_HIER_JJ.a = AV_DATES.a  EXCEPT  " +
					        "SELECT EMPLOYEE.EMP_CODE AS SALESPERS ,holiday.hol_date AS AVAILABLE_DY FROM holiday ," +
					        "EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno " +
					        "AND holiday.hol_date > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ,'00:00:00') " +
							"AND holiday.hol_date <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') AND NOT EXISTS ( SELECT * FROM sprs_act_tran s " +
							"WHERE s.sales_pers = employee.emp_code AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV " +
							"LEFT JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' " +
							"AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS " +
							"AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT JOIN ( SELECT S.* FROM STRG_MEET S " +
							"WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS " +
							"AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID " +
							"LEFT JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ " +
							"WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE " +
							"AND VW_SALES_HIER_JJ.REPCODE = '"+loginId+"' ) UF WHERE UF.REP_NONREP <> '-' ) F " +
							"GROUP BY F.NSMCODE ,F.NSMNAME ,F.NSMDESG ,F.SMCODE ,F.SMNAME ,F.SMDESG ," +
							"F.RSECODE ,F.RSENAME ,F.RSEDESG ,F.REPCODE ,F.REPNAME ,F.REPDESG ,F.REP_NONREP " +
							"ORDER BY F.NSMCODE ,F.SMCODE ,F.RSECODE ,F.REPCODE ";

					
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					int count = 0;	
					while (rs.next())
					{
						rowData = new JSONObject();
						
						rowData.put("nsmcode", checkNull(rs.getString("NSMCODE")).trim());	
						rowData.put("nsmname", checkNull(rs.getString("NSMNAME")).trim());	
						rowData.put("nsmdesg", checkNull(rs.getString("NSMDESG")).trim());
						
						rowData.put("smcode", checkNull(rs.getString("SMCODE")).trim());	
						rowData.put("smname", checkNull(rs.getString("SMNAME")).trim());	
						rowData.put("smdesg", checkNull(rs.getString("SMDESG")).trim());	
						
						rowData.put("rsecode", checkNull(rs.getString("RSECODE")).trim());	
						rowData.put("rsename", checkNull(rs.getString("RSENAME")).trim());	
						rowData.put("rsedesg", checkNull(rs.getString("RSEDESG")).trim());
						
						rowData.put("repcode", checkNull(rs.getString("REPCODE")).trim());	
						rowData.put("repname", checkNull(rs.getString("REPNAME")).trim());	
						rowData.put("repdesg", checkNull(rs.getString("REPDESG")).trim());
						
						rowData.put("rep_nonrep", checkNull(rs.getString("REP_NONREP")).trim());
						rowData.put("count", rs.getString("CNT"));	
						rawDataComplianceHirarchyDB2Json.put(count, rowData);
						count++;
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
				}
				catch (Exception e)
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
				finally
				{
					try
					{
						if (conn != null)
						{
							if (rs != null)
							rs.close();
							rs = null;
							if (pstmt != null)
							pstmt.close();
							pstmt = null;
							conn.close();
							conn = null;
						}
						conn = null;
					} catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in :ComplianceDB2:" + d.getMessage());
						throw new ITMException(d);
					}
				}
				System.out.println("ComplianceDB2 JSON String======>>"+rawDataComplianceHirarchyDB2Json.toString());
				return rawDataComplianceHirarchyDB2Json;
				
			}
		    @SuppressWarnings("unchecked")
		    @Override
		    public JSONObject getComplianceSummaryDB2(String firstVal, String cellVal, String dataSourceName) throws RemoteException, ITMException
		    {
		    	JSONObject rawDataComplianceSummaryDB2Json = new JSONObject();
				JSONObject rowData = null;
				String sql = "";
				ResultSet rs = null;
				PreparedStatement pstmt = null;
				Connection conn = null;
				ConnDriver connDriver = new ConnDriver();
				try
				{
					System.out.println(" Inside ComplianceEJB for getComplianceSummaryDB2 Data Soruc Name ="+dataSourceName+" firstVal=:"+ firstVal + "===cellVal :"+ cellVal);
					conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;
					//SimpleDateFormat gridDateFormat = new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss");
					//SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat("dd/MM/yy");
					SimpleDateFormat gridDateFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
					SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat(genericUtility.getApplDateFormat());
					if(cellVal!=null && cellVal.length()>0)	
					{
					cellVal = gridDateFormat.format(convrtToTimStmDate.parse(cellVal));
					}
					System.out.println("cellVal :"+cellVal);
					
					/*sql = "Select 'DH' as STRG_TYPE, 'Dhanendra' as CUST_NAME from Dual";*/
					
					sql = "SELECT SM.STRG_TYPE, (SC.FIRST_NAME ||' '||SC.MIDDLE_NAME ||' '||SC.LAST_NAME) AS CUST_NAME " +
						  "FROM STRG_MEET SM INNER JOIN STRG_CUSTOMER SC ON SM.STRG_CODE = SC.SC_CODE " +
						  "INNER JOIN VW_SALES_HIER_JJ VW ON SM.SALES_PERS = VW.REPCODE " +
						  "WHERE  SM.EVENT_DATE = TIMESTAMP('"+cellVal.trim()+"') " +
						  "AND VW.REPNAME = '"+firstVal.trim()+"' ";
					
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					int count = 0;		
					while (rs.next())
					{
						rowData = new JSONObject();
						rowData.put("customer_name", checkNull(rs.getString("CUST_NAME")));
						rowData.put("strg_type", checkNull(rs.getString("STRG_TYPE")));
						rawDataComplianceSummaryDB2Json.put(count, rowData);
						count++;
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
				}
				catch (Exception e)
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
				finally
				{
					try
					{
						if (conn != null)
						{
							if (rs != null)
							rs.close();
							rs = null;
							if (pstmt != null)
							pstmt.close();
							pstmt = null;
							conn.close();
							conn = null;
						}
						conn = null;
					} catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in :ComplianceDB2:" + d.getMessage());
						throw new ITMException(d);
					}
				}
				System.out.println("ComplianceEJB rawDataComplianceSummaryDB2Json String======>>"+rawDataComplianceSummaryDB2Json.toString());
			    return rawDataComplianceSummaryDB2Json;
		    }	    	    	   
			@SuppressWarnings("unchecked")
		    @Override
		    public JSONObject getComplianceDetailsDB2(String period, String personName, String dataSourceName) throws RemoteException, ITMException
		    {

		    	JSONObject rawDataComplianceDetailsDB2Json = new JSONObject();
				JSONObject rowData = null;
				String sql = "";
				ResultSet rs = null;
				PreparedStatement pstmt = null;
				Connection conn = null;
				ConnDriver connDriver = new ConnDriver();
				try
				{
					System.out.println(" Inside ComplianceEJB for getComplianceDetailsDB2 Data Soruc Name ="+dataSourceName+" period=:"+ period + "=== personName :"+ personName);
					conn = connDriver.getConnectDB(dataSourceName);
					connDriver = null;
					
					/*sql =   "Select '01/10/2015' as AVAILABLE_DY, 'FW' as ACTIVITY_CODE from Dual";*/
					

					sql =   "SELECT F.REPCODE , F.REPNAME , F.REPDESG , F.REP_NONREP , " +
							"DATE(F.AVAILABLE_DY)  AS AVAILABLE_DY , " +
							"F.ACTIVITY_CODE,(select descr from fieldactivity " +
							"where ACTIVITY_CODE =F.ACTIVITY_CODE) as ACTIVITY_Descr " +
							"FROM ( SELECT DISTINCT REPCODE , REPNAME , REPDESG , SALES_PERS_AV.AVAILABLE_DY , " +
							"SPRS_ACT_TRAN.ACTIVITY_CODE , ( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE , " +
							"AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' " +
							"WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE , " +
							"AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN '-' ELSE 'NR' END ) " +
							"AS REP_NONREP ,CONCAT(CONCAT(COALESCE(STRG_CUSTOMER.FIRST_NAME, ''), " +
							"COALESCE(STRG_CUSTOMER.MIDDLE_NAME, '')), COALESCE(STRG_CUSTOMER.LAST_NAME, '')) AS CUSTOMER_NAME " +
							"FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY " +
							"FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ WHERE (NSMCODE = '"+personName+"'  OR SMCODE = '"+personName+"'  OR RSECODE = '"+personName+"'  OR REPCODE = '"+personName+"' )) VW_SALES_HIER_JJ ," +
							"( SELECT dt AS available_dy ,'a' AS a FROM sfa_time WHERE dt > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ,'00:00:00') " +
							"AND DT <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') ) AV_DATES " +
							"WHERE VW_SALES_HIER_JJ.a = AV_DATES.a  EXCEPT  SELECT EMPLOYEE.EMP_CODE AS SALESPERS , " +
							"holiday.hol_date AS AVAILABLE_DY FROM holiday ,EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno " +
							"AND holiday.hol_date > TIMESTAMP(last_day((to_date(('"+period+"'),('YYYYMM'))) - 1 month) ,'00:00:00') " +
							"AND holiday.hol_date <= TIMESTAMP(last_day(to_date(('"+period+"'),('YYYYMM'))) ,'00:00:00') " +
							"AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code " +
							"AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV LEFT JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' " +
							"AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS " +
							"AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) " +
							"STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID " +
							"LEFT JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ " +
							"WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE AND VW_SALES_HIER_JJ.REPNAME = '"+personName+"' ) F WHERE F.REP_NONREP <> '-' ORDER BY F.AVAILABLE_DY ";


					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					int count = 0;	
					String activityCode = "";
					while (rs.next())
					{
						rowData = new JSONObject();
						
						rowData.put("activity_descr", checkNull(rs.getString("ACTIVITY_DESCR")).trim());
						rowData.put("repcode", checkNull(rs.getString("REPCODE")).trim());
						rowData.put("repname", checkNull(rs.getString("REPNAME")).trim());
						rowData.put("repdesg", checkNull(rs.getString("REPDESG")).trim());
						rowData.put("rep_nonrep", checkNull(rs.getString("REP_NONREP")).trim());				
						rowData.put("available_dy", checkNull(rs.getString("AVAILABLE_DY")).trim());
						
						activityCode = rs.getString("ACTIVITY_CODE");
						System.out.println("activityCode :"+activityCode);
						if(activityCode == null)
						{
							rowData.put("activity_code", "Not-Reported");
						}else
						{
							rowData.put("activity_code", rs.getString("ACTIVITY_CODE"));	
						}
						
						rawDataComplianceDetailsDB2Json.put(count, rowData);
						count++;
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
				}
				catch (Exception e)
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
				finally
				{
					try
					{
						if (conn != null)
						{
							if (rs != null)
							rs.close();
							rs = null;
							if (pstmt != null)
							pstmt.close();
							pstmt = null;
							conn.close();
							conn = null;
						}
						conn = null;
					} catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in :ComplianceDB2: getComplianceDetailsDB2 " + d.getMessage());
						throw new ITMException(d);
					}
				}
				return rawDataComplianceDetailsDB2Json;
		    
		    }
		/*End Below 3 methods for Franco Compliance Report by Nikhil 
		on Dated 21/06/2016*/	
	private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str ;
   		}

   	}	
	
	/*Added by chetan mahajan on 1-July-2016 for compliance dashboard reports - Start*/
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getComplMTDSummary(String dataSourceName, String fromDate, String toDate, String salePersons, String loginEmpCode) throws RemoteException, ITMException 
	{
		JSONObject rawDataMTDWorkSummJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String userImagePath ="";
		String empFullName = "";
		DashboardUtility dashboardUtility = null;
		String appendSqlStr = "";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			dashboardUtility = new DashboardUtility();
			connDriver = null;
			loginEmpCode = dashboardUtility.getCommaSeparated(loginEmpCode);
			salePersons = dashboardUtility.getCommaSeparated(salePersons);
			userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
			System.out.println("salePersons ="+salePersons+ " salePersons.length = "+salePersons.length());
			if(salePersons != null && salePersons.length() != 0)
			{
				appendSqlStr = "and E.emp_code in ("+salePersons+")";
			}
			else
			{
				appendSqlStr = "";
			}
			System.out.println("appendSqlStr :"+appendSqlStr);
			//sql = "select a.emp_code, a.emp_name from (select emp_code, emp_fname ||' '|| emp_lname emp_name from employee where report_to = "+loginEmpCode+" ) a " +
					//" " + appendSqlStr + " " ;
			sql = "select E.emp_code, CONCAT(CONCAT(E.emp_Fname,' '),E.EMP_LNAME) AS EMP_NAME " +
					"FROM EMPLOYEE E WHERE E.emp_code in " +
					"( select emp_code from  EMPLOYEE WHERE (fn_get_hierarcy_NIGEL(emp_code,"+loginEmpCode+"))>0 ) " +
					" " + appendSqlStr + " " ;
					
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int i = 0;
			String dynamicImgColor = "";
			while (rs.next())
			{
				rowData = new JSONObject();
				
				empFullName = checkNull (rs.getString("emp_name"));
				rowData.put("emp_name",empFullName);		
				
				
				String empCode = checkNull (rs.getString("emp_code")).trim();
				rowData.put("emp_code",empCode);
				
				File file = new File(userImagePath+empCode+".png");
				if(file.exists())
				{
					rowData.put("emp_img", "<div class='defaultUserImgDiv'> <img class='defaultUserImage' src='/ibase/resource/images/users/"+empCode+".png'/> </div>");
				}else
				{

					String[] splited = empFullName.split(" ");
					System.out.println("splited :"+splited[0].charAt(0));
					String defaultUserImg = ""+splited[0].charAt(0);
					
					if(splited.length>1)
					{
						System.out.println("splited 1 :"+splited[1]);
						defaultUserImg = defaultUserImg + ""+splited[1].charAt(0);
					}
					if(i == 0)
					{
						dynamicImgColor = "#EE7A67";
					}
					else if(i == 1)
					{
						dynamicImgColor = "#67D7EE";
					}
					else if(i == 2)
					{
						dynamicImgColor = "#72A2C3";
					}
					else if(i == 3)
					{
						dynamicImgColor = "#B47ABD";
					}
					rowData.put("emp_img", "<div class='defaultUserImgLbl' style='background-color: "+dynamicImgColor+"!important'> <div class='userImageText'>"+defaultUserImg+" </div></div>");
					i++;
					if(i == 4)
					{
						i = 0;
					}
				}
				
				rawDataMTDWorkSummJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ComplianceDB2 : getComplMTDSummary" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMTDWorkSummJson;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getComplDayWiseSummary(String dataSourceName, String fromDate, String toDate, String selectedSalePerson) throws RemoteException, ITMException 
	{
		JSONObject rawDataMTDWorkSummJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Calendar calendar = null;
		try
		{
			//Code for base Start
			/*SimpleDateFormat gridDateFormat = new SimpleDateFormat( "dd-MMM-yy");
			SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat("dd/MM/yy");*/
			//Code for base End
			
            //Code for db2 Start
			SimpleDateFormat gridDateFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
            SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat(genericUtility.getApplDateFormat());
            //Code for db2 End
            
            if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 	
            	//Code for db2 Start
            	calendar = Calendar.getInstance();
            	toDate = convrtToTimStmDate.format(calendar.getTime());
            	toDate = gridDateFormat.format(convrtToTimStmDate.parse(toDate));
            	System.out.println(" toDate = "+toDate);
            	
            	calendar = Calendar.getInstance();
            	calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
            	fromDate = convrtToTimStmDate.format(calendar.getTime());
            	fromDate = gridDateFormat.format(convrtToTimStmDate.parse(fromDate));
            	System.out.println(" fromDate = "+fromDate);
            	//Code for db2 end
            	
            	//Code for base Start
            	/*calendar = Calendar.getInstance();
            	toDate = convrtToTimStmDate.format(calendar.getTime());
            	toDate = gridDateFormat.format(convrtToTimStmDate.parse(toDate));
            	System.out.println(" toDate = "+toDate);
            	
            	calendar = Calendar.getInstance();
            	calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
            	fromDate = convrtToTimStmDate.format(calendar.getTime());
            	fromDate = gridDateFormat.format(convrtToTimStmDate.parse(fromDate));
            	System.out.println(" fromDate = "+fromDate);*/
            	//Code for base End
			}
            else if(fromDate!=null && fromDate.length()>0 && toDate!=null && toDate.length()>0)    
            {	
            	//Code for db2 Start
            	fromDate = gridDateFormat.format(convrtToTimStmDate.parse(fromDate));
            	toDate = gridDateFormat.format(convrtToTimStmDate.parse(toDate));
            	//Code for db2 End
            }
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			System.out.println("In getComplDayWiseSummary selected ==>>fromDate = ["+fromDate+"] toDate = ["+toDate+"] selectedSalePerson = ["+selectedSalePerson+"]" );
			
			//Code for db2 Start
			sql = "SELECT M.SALES_PERS " +
					",S.SP_NAME " +
					",DATE (M.EVENT_DATE) AS EVENT_DATE " +
					",(SELECT COUNT(ST.LOCALITY_CODE) FROM SPRS_TRAVEL ST where M.EVENT_DATE= ST.TRAVEL_DATE  AND M.SALES_PERS = ST.SALES_PERS) LOCALITY " +
					",COUNT(CASE WHEN D.CUST_TYPE = 'D' THEN D.SC_CODE END) DR_CNT " +
					",COUNT(CASE WHEN D.CUST_TYPE = 'C' THEN D.SC_CODE END) CHM_CNT " +
					"FROM STRG_MEET M " +
					" LEFT JOIN SALES_PERS S ON S.SALES_PERS = M.SALES_PERS " +
					" LEFT JOIN STRG_CUSTOMER D ON D.SC_CODE = M.STRG_CODE " +
					" WHERE M.SALES_PERS = '"+selectedSalePerson+"' AND M.EVENT_DATE BETWEEN TIMESTAMP('"+fromDate+"') AND TIMESTAMP('"+toDate+"') " +
					" GROUP BY S.SP_NAME ,M.EVENT_DATE ,M.SALES_PERS ORDER BY M.EVENT_DATE DESC";
			//Code for db2 End
			
			//Code for base Start
			/*sql = "SELECT S.SALES_PERS, " +
					"S.SP_NAME, " +
					"to_char(M.EVENT_DATE,'dd/mm/yy') as EVENT_DATE, " +
					"COUNT(M.LOCALITY_CODE) LOC_CODE, " +
					"COUNT(CASE WHEN D.CUST_TYPE='D' THEN D.SC_CODE END ) DR_CNT, " +
					"COUNT(CASE WHEN D.CUST_TYPE='C' THEN D.SC_CODE END ) CHM_CNT " +
					"FROM STRG_MEET M " +
					"INNER JOIN SALES_PERS S ON S.SALES_PERS = M.SALES_PERS " +
					"INNER JOIN STRG_CUSTOMER D ON D.SC_CODE = M.STRG_CODE " +
					"WHERE M.SALES_PERS = '"+selectedSalePerson+"' " +
					"AND M.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'" +
					" AND D.CUST_TYPE != 'S' " +
					"GROUP BY S.SP_NAME,M.EVENT_DATE,S.SALES_PERS " +
					"ORDER BY M.EVENT_DATE";*/
			//Code for base Start
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("sales_pers", checkNull(rs.getString("SALES_PERS")));
				rowData.put("sp_name",checkNull( rs.getString("SP_NAME")));
				rowData.put("event_date", checkNull(rs.getString("EVENT_DATE")));
				rowData.put("loc_code",checkNull( rs.getString("LOCALITY")));
				rowData.put("dr_cnt",checkNull( rs.getString("DR_CNT")));
				rowData.put("chm_cnt",checkNull( rs.getString("CHM_CNT")));
				
				rawDataMTDWorkSummJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ComplianceDB2 : getComplDayWiseSummary" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMTDWorkSummJson;
	}

	
	@SuppressWarnings("unchecked")
	public JSONObject getComplDayWiseDetail(String dataSourceName, String eventDate, String salesPersCode) throws RemoteException, ITMException 
	{
		PreparedStatement pstmt = null;
		ConnDriver connDriver = new ConnDriver();
		ResultSet    rs	= null;
		Connection conn = null;
		String sql = "";
		String dcrId  	= "" ;
		String lastDCRDate = "";
		String spFullName = "";
		String doctorName 		= "";
		String teamName   		= "" ;
		int count = 0;
		JSONObject complDayWiseDetailJson = null;
		JSONObject rowData = null;
		JSONObject complDayWiseDetailFinalJsn = new JSONObject();
		
		
		
		
		try
		{
			
			 //Code for db2 Start
			SimpleDateFormat gridDateFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
            SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat(genericUtility.getApplDateFormat());
            //Code for db2 End
			
            //Code for  Base Start
			/*SimpleDateFormat gridDateFormat = new SimpleDateFormat( "dd-MMM-yy");
			SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat("dd/MM/yy");*/
			//Code for  Base End
			
			eventDate = gridDateFormat.format(convrtToTimStmDate.parse(eventDate));

			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			sql = " SELECT S.TRAN_ID, " +
					" VARCHAR(DATE(S.EVENT_DATE)) AS EVENT_DATE, " +
					"S.ACTIVITY_CODE,F.DESCR AS ACTIVITY_DESCR, S.SALES_PERS, S.REMARKS, " +
					" E.EMP_FNAME , E.EMP_MNAME,  E.EMP_LNAME," +
					" S.SPRS_CODE__WW,S.DCR_ID,S.OTH_PARTICIPANT,S.CONFIRMED   FROM  SPRS_ACT_TRAN S , " +
					" EMPLOYEE  E, FIELDACTIVITY F WHERE   S.SALES_PERS = E.EMP_CODE AND S.ACTIVITY_CODE = F.ACTIVITY_CODE AND " +
					" S.SALES_PERS = '"+salesPersCode+"' AND  S.EVENT_DATE = TIMESTAMP('"+eventDate+"') ";
			
			//Code for Base Start
			/*sql = " SELECT S.TRAN_ID, " +
					"to_char(S.EVENT_DATE,'dd/mm/yy') as EVENT_DATE, " +
					"S.ACTIVITY_CODE,F.DESCR AS ACTIVITY_DESCR, S.SALES_PERS, S.REMARKS, " +
					" E.EMP_FNAME , E.EMP_MNAME,  E.EMP_LNAME," +
					" S.SPRS_CODE__WW,S.DCR_ID,S.OTH_PARTICIPANT,S.CONFIRMED   FROM  SPRS_ACT_TRAN S , " +
					" EMPLOYEE  E, FIELDACTIVITY F WHERE   S.SALES_PERS = E.EMP_CODE AND S.ACTIVITY_CODE = F.ACTIVITY_CODE AND " +
					" S.SALES_PERS = '"+salesPersCode+"' AND  S.EVENT_DATE = '"+eventDate+"' ";*/
			//Code for  Base End
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			complDayWiseDetailJson = new JSONObject();
			count = 0;
			if(rs.next())
			{
				dcrId 		      =	rs.getString("DCR_ID") == null ? "" : rs.getString("DCR_ID") ;
				spFullName 		  = (rs.getString("EMP_FNAME") == null ? "" : rs.getString("EMP_FNAME")) + " " + (rs.getString("EMP_LNAME") == null ? "" : rs.getString("EMP_LNAME")) ;

				lastDCRDate =   this.getSalesPersLastDCRDate(conn, salesPersCode, dcrId);

				rowData = new JSONObject();
				
				
				rowData.put("sales_pers", checkNull(rs.getString("SALES_PERS")));
				rowData.put("sp_name", checkNull(spFullName));
				rowData.put("event_date", checkNull(rs.getString("EVENT_DATE")));
				rowData.put("last_dcr_date", checkNull(lastDCRDate));
				rowData.put("oth_participant", checkNull(rs.getString("OTH_PARTICIPANT")));
				rowData.put("activity_descr", checkNull(rs.getString("ACTIVITY_DESCR")));
				rowData.put("remarks", checkNull(rs.getString("REMARKS")));
				
				complDayWiseDetailJson.put(count, rowData);
				count++;
			}
				complDayWiseDetailFinalJsn.put("1", complDayWiseDetailJson);
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				sql = " SELECT ST.TRAN_ID, ST.PLAN_ID, ST.SALES_PERS, ST.TRAVEL_DATE, ST.LOCALITY_CODE,L.DESCR AS LOCALITY_DESCR, ST.STAN_CODE, S1.DESCR AS STAN_DESCR, " +
						"	ST.STAN_CODE__FROM, S2.DESCR AS STAN_CODE__FROM_DESCR, ST.TRAVEL_MODE, ST.OVER_NIGHT, ST.ACTIVITY_CODE, ST.LOCALITY_CODE_FROM," +
						" ST.TEMPLATE_FILE, ST.SALES_TEAM, ST.OTH_PARTICIPANT, ST.SPRS_CODE__WW, E.EMP_FNAME,E.EMP_MNAME,E.EMP_LNAME ," +
						" ST.ORDER_OF_VISIT, ST.DCR_ID, ST.LINE_NO, ST.DR_VISIT, ST.CHEM_VISIT FROM SPRS_TRAVEL ST " +
						" LEFT  JOIN LOCALITY L  ON  L.LOCALITY_CODE = ST.LOCALITY_CODE " +
						" LEFT  JOIN EMPLOYEE E  ON  E.EMP_CODE  = ST.SPRS_CODE__WW " +
						" LEFT  JOIN STATION S1  ON  S1.STAN_CODE = ST.STAN_CODE " +
						" LEFT  JOIN STATION S2  ON  S2.STAN_CODE = ST.STAN_CODE " +
						"  WHERE ST.DCR_ID =  '"+dcrId+"'     ";
				
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				int localityCount = 1;
				complDayWiseDetailJson = new JSONObject();
				count = 0;
				while(rs.next())
				{

					System.out.println("In Locality localityCount = "+localityCount);

					rowData = new JSONObject();
					rowData.put("sr_no", localityCount);
					rowData.put("locality_descr", checkNull(rs.getString("LOCALITY_DESCR")));
					rowData.put("stan_code__from_descr", checkNull(rs.getString("STAN_CODE__FROM_DESCR")));
					rowData.put("travel_mode", checkNull(rs.getString("TRAVEL_MODE")));
					
					complDayWiseDetailJson.put(count, rowData);
					count++;
					localityCount++;
				}
				complDayWiseDetailFinalJsn.put("2", complDayWiseDetailJson);
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				//Code for  db2 Start
				sql = "SELECT SM.TRAN_ID, SP.SH_NAME AS WORK_WITH, SM.PLAN_ID, SM.EVENT_DATE, SM.EVENT_TYPE, SM.STRG_CODE,SM.STRG_NAME" +
						", CUST1.FIRST_NAME AS CUST_FNAME,  SM_ITEM.QUANTITY, SM_ITEM.BRIEFED_DESCR, SM_ITEM.ITEM_CODE" +
						", ITEM.DESCR AS ITEM_DESCR, CUST1.MIDDLE_NAME CUST_MNAME , CUST1.LAST_NAME AS CUST_LNAME " +
						", SM.STRG_TYPE, SM.STRG_NO_VISIT, SM.EVENT_TIME_START,  SM.EVENT_TIME_END, SM.STRG_CLASS_CODE  " +
						", CUST_CLASS.CLASS_CODE_DESCR, SM.SALES_PERS, E.EMP_FNAME AS SPRS_FNAME, E.EMP_MNAME AS SPRS_MNAME" +
						", E.EMP_LNAME AS SPRS_LNAME, SM.SALES_TEAM, E1.EMP_FNAME AS SALES_TEAM_FNAME, E1.EMP_MNAME AS SALES_TEAM_MNAME" +
						", E1.EMP_LNAME AS SALES_TEAM_LNAME ,  SM.OTH_PARTICIPANT, SM.REMARKS,SM.ORDER_BOOKED, SM.MEET_SUMM, SM.LOCALITY_CODE" +
						", SM.TEMPLATE_FILE, SM.SPRS_CODE__WW,  E2.EMP_FNAME AS SPRS_CODE__WW_FNAME, E2.EMP_MNAME AS SPRS_CODE__WW_MNAME" +
						", E2.EMP_LNAME AS SPRS_CODE__WW_LNAME, SM.LAST_MEET_SUMM, SM.LAST_MEET_DATE, SM.LAST_PROD_BRF, SM.REF_TRAN_ID" +
						", SM.CONF_DATE, SM.CONFIRMED, SM.EMP_CODE__APRV, SM.SHORT_ID, SM.SC_CODE__REF, SM.MEET_SUMM_MGR, SM.DCR_ID" +
						", SM.WORK_TEAM, SM.WORK_WITH_OTHER, SM.POB_VAL " +
						" ,SM.LOCALITY_CODE " +
						" ,LOCALITY.DESCR AS LOC_DESCR" +
						" FROM STRG_MEET SM " +
						" LEFT JOIN STRG_CUSTOMER CUST1 ON CUST1.SC_CODE = SM.STRG_CODE " +
						" LEFT JOIN  EMPLOYEE E  ON E.EMP_CODE  =  SM.SALES_PERS " +
						" LEFT JOIN  EMPLOYEE E1  ON E1.EMP_CODE  =  SM.SALES_TEAM " +
						" LEFT JOIN  EMPLOYEE E2  ON E2.EMP_CODE  =  SM.SPRS_CODE__WW " +
						" LEFT JOIN  STRG_CUST_CLASS CUST_CLASS ON CUST_CLASS.CLASS_CODE = SM.STRG_CLASS_CODE " +
						" LEFT JOIN STRG_MEET_ITEMS SM_ITEM ON  SM_ITEM.DCR_ID = SM.DCR_ID and  SM_ITEM.strg_code = SM.strg_code " +
						" LEFT JOIN ITEM ITEM ON ITEM.ITEM_CODE  = SM_ITEM.ITEM_CODE  " +
						" LEFT JOIN LOCALITY ON LOCALITY.LOCALITY_CODE=SM.LOCALITY_CODE " +
						" LEFT JOIN STRG_MEET_TEAM SMT ON SM.DCR_ID = SMT.DCR_ID AND SM.STRG_CODE = SMT.STRG_CODE " +
						" LEFT JOIN SALES_PERS SP ON SP.SALES_PERS = SM.SPRS_CODE__WW  " +
						" WHERE SM.DCR_ID = '"+dcrId+"' AND CUST_CLASS.CUST_TYPE ='D' AND  SM.STRG_TYPE = 'D'" +
						" ORDER BY SM.STRG_CODE";
				//Code for  db2 End
				
				//Code for  Base Start
				//This sql remove some table only For testing purpuse only
				/*sql = " SELECT SM.TRAN_ID, SM.PLAN_ID, SM.EVENT_DATE, SM.EVENT_TYPE, " +
						//" SM_ITEM.QUANTITY, SM_ITEM.BRIEFED_DESCR, SM_ITEM.ITEM_CODE, ITEM.DESCR AS ITEM_DESCR," +
						"SM.STRG_CODE,SM.STRG_NAME, CUST1.FIRST_NAME AS CUST_FNAME," +
						" CUST1.MIDDLE_NAME CUST_MNAME , CUST1.LAST_NAME AS CUST_LNAME , " +
						"SM.STRG_TYPE, SM.STRG_NO_VISIT, SM.EVENT_TIME_START, " +
						" SM.EVENT_TIME_END, SM.STRG_CLASS_CODE  , " +
						"SM.SALES_PERS, E.EMP_FNAME AS SPRS_FNAME, " +
						"E.EMP_MNAME AS SPRS_MNAME," +
						" E.EMP_LNAME AS SPRS_LNAME, SM.SALES_TEAM, E1.EMP_FNAME AS SALES_TEAM_FNAME, E1.EMP_MNAME AS SALES_TEAM_MNAME, E1.EMP_LNAME AS SALES_TEAM_LNAME , " +
						" SM.OTH_PARTICIPANT, SM.REMARKS,SM.ORDER_BOOKED, SM.MEET_SUMM, SM.LOCALITY_CODE, SM.TEMPLATE_FILE, SM.SPRS_CODE__WW, " +
						" E2.EMP_FNAME AS SPRS_CODE__WW_FNAME, E2.EMP_MNAME AS SPRS_CODE__WW_MNAME, E2.EMP_LNAME AS SPRS_CODE__WW_LNAME, SM.LAST_MEET_SUMM," +
						" SM.LAST_MEET_DATE, SM.LAST_PROD_BRF, SM.REF_TRAN_ID, SM.CONF_DATE, SM.CONFIRMED, SM.EMP_CODE__APRV, SM.SHORT_ID, SM.SC_CODE__REF," +
						" SM.MEET_SUMM_MGR, SM.DCR_ID, SM.WORK_TEAM, SM.WORK_WITH_OTHER, SM.POB_VAL FROM   STRG_MEET SM" +
						" LEFT JOIN STRG_CUSTOMER CUST1 ON CUST1.SC_CODE = SM.STRG_CODE" +
						" LEFT JOIN  EMPLOYEE E  ON E.EMP_CODE  =  SM.SALES_PERS" +
						" LEFT JOIN  EMPLOYEE E1  ON E1.EMP_CODE  =  SM.SALES_TEAM" +
						" LEFT JOIN  EMPLOYEE E2  ON E2.EMP_CODE  =  SM.SPRS_CODE__WW " +
						//" LEFT JOIN STRG_MEET_ITEMS SM_ITEM ON  SM_ITEM.DCR_ID =  SM.DCR_ID " +
						//" LEFT JOIN ITEM ITEM ON ITEM.ITEM_CODE  = SM_ITEM.ITEM_CODE " +
						" WHERE   SM.DCR_ID = '"+dcrId+"' AND SM.STRG_TYPE = 'D'";*/
				//Code for  Base End
				
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				int doctorCount = 1;
				complDayWiseDetailJson = new JSONObject();
				count = 0;
				String briefDescr = "";
				String remarksDescr = "";
				//String strgCode = "";
				while(rs.next())
				{
					System.out.println("In doctor doctorCount = "+doctorCount);
					doctorName       	=  (rs.getString("CUST_FNAME") == null ? "" : rs.getString("CUST_FNAME")) + " " + (rs.getString("CUST_MNAME") == null ? "" : rs.getString("CUST_MNAME")) + " " + (rs.getString("CUST_LNAME") == null ? "" : rs.getString("CUST_LNAME")) ;
					spFullName       	=  (rs.getString("SPRS_FNAME") == null ? "" : rs.getString("SPRS_FNAME")) + " " + (rs.getString("SPRS_MNAME") == null ? "" : rs.getString("SPRS_MNAME")) + " " + (rs.getString("SPRS_LNAME") == null ? "" : rs.getString("SPRS_LNAME")) ;
					teamName       		=  (rs.getString("SALES_TEAM_FNAME") == null ? "" : rs.getString("SALES_TEAM_FNAME")) + " " + (rs.getString("SALES_TEAM_MNAME") == null ? "" : rs.getString("SALES_TEAM_MNAME")) + " " + (rs.getString("SALES_TEAM_LNAME") == null ? "" : rs.getString("SALES_TEAM_LNAME")) ;
					
					rowData = new JSONObject();
					rowData.put("sno_doc", doctorCount);
					rowData.put("str_class_code_descr", checkNull(rs.getString("CLASS_CODE_DESCR")));
					rowData.put("doctor_name", checkNull(doctorName));
					if(checkNull(rs.getString("ITEM_CODE")) == "")
					{
						briefDescr = checkNull(rs.getString("BRIEFED_DESCR"));
					}
					else
					{
						briefDescr = checkNull(rs.getString("ITEM_DESCR"));
					}
					rowData.put("product_name", briefDescr);
					rowData.put("quantity", checkNull(rs.getString("QUANTITY")));
					//rowData.put("product_name", "-");
					//rowData.put("quantity", "-");
					rowData.put("ordered_booked", checkNull(rs.getString("ORDER_BOOKED")));
					rowData.put("meeting_summ", checkNull(rs.getString("MEET_SUMM")));
					rowData.put("other_parti_doctor", checkNull(rs.getString("OTH_PARTICIPANT")));
					rowData.put("team_sale_name", checkNull(teamName));
					if(checkNull(rs.getString("MEET_SUMM_MGR")) == "")
					{
						remarksDescr =  checkNull(rs.getString("REMARKS"));
					}
					else
					{
						remarksDescr = checkNull(rs.getString("MEET_SUMM_MGR"));
					}
					rowData.put("remrks_doctor", remarksDescr);
					rowData.put("locality_doctor", checkNull(rs.getString("LOC_DESCR"))); //Show locality on table
					rowData.put("strg_code_doctor", checkNull(rs.getString("STRG_CODE")));
					rowData.put("work_with", checkNull(rs.getString("WORK_WITH")));
					complDayWiseDetailJson.put(count, rowData);
					count++;
					doctorCount++;
				}
				complDayWiseDetailFinalJsn.put("3", complDayWiseDetailJson);
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				//Code for  db2 Start
				sql = "SELECT SM.TRAN_ID ,SM.PLAN_ID ,SM.EVENT_DATE ,SM.EVENT_TYPE ,SM.STRG_CODE ,SM.STRG_NAME " +
						",CUST1.FIRST_NAME AS CUST_FNAME ,SM_ITEM.QUANTITY ,SM_ITEM.BRIEFED_DESCR ,SM_ITEM.ITEM_CODE " +
						",ITEM.DESCR AS ITEM_DESCR ,CUST1.MIDDLE_NAME CUST_MNAME ,CUST1.LAST_NAME AS CUST_LNAME ,SM.STRG_TYPE " +
						",SM.STRG_NO_VISIT ,SM.EVENT_TIME_START ,SM.EVENT_TIME_END ,SM.STRG_CLASS_CODE ,CUST_CLASS.CLASS_CODE_DESCR " +
						",SM.SALES_PERS ,E.EMP_FNAME AS SPRS_FNAME ,E.EMP_MNAME AS SPRS_MNAME ,E.EMP_LNAME AS SPRS_LNAME ,SM.SALES_TEAM " +
						",E1.EMP_FNAME AS SALES_TEAM_FNAME ,E1.EMP_MNAME AS SALES_TEAM_MNAME ,E1.EMP_LNAME AS SALES_TEAM_LNAME ,SM.OTH_PARTICIPANT " +
						",SM.REMARKS ,SM.ORDER_BOOKED ,SM.MEET_SUMM ,SM.LOCALITY_CODE ,SM.TEMPLATE_FILE ,SM.SPRS_CODE__WW " +
						",E2.EMP_FNAME AS SPRS_CODE__WW_FNAME ,E2.EMP_MNAME AS SPRS_CODE__WW_MNAME ,E2.EMP_LNAME AS SPRS_CODE__WW_LNAME " +
						",SM.LAST_MEET_SUMM ,SM.LAST_MEET_DATE ,SM.LAST_PROD_BRF ,SM.REF_TRAN_ID ,SM.CONF_DATE ,SM.CONFIRMED ,SM.EMP_CODE__APRV " +
						",SM.SHORT_ID ,SM.SC_CODE__REF ,SM.MEET_SUMM_MGR ,SM.DCR_ID ,SM.WORK_TEAM ,SM.WORK_WITH_OTHER ,SM.POB_VAL " +
						" ,SM.LOCALITY_CODE " +
						" ,LOCALITY.DESCR AS LOC_DESCR" +
						" FROM STRG_MEET SM " +
						" LEFT JOIN STRG_CUSTOMER CUST1 ON CUST1.SC_CODE = SM.STRG_CODE " +
						" LEFT JOIN EMPLOYEE E ON E.EMP_CODE = SM.SALES_PERS " +
						" LEFT JOIN EMPLOYEE E1 ON E1.EMP_CODE = SM.SALES_TEAM " +
						" LEFT JOIN EMPLOYEE E2 ON E2.EMP_CODE = SM.SPRS_CODE__WW " +
						" LEFT JOIN STRG_CUST_CLASS CUST_CLASS ON CUST_CLASS.CLASS_CODE = SM.STRG_CLASS_CODE " +
						" LEFT JOIN STRG_MEET_ITEMS SM_ITEM ON SM_ITEM.DCR_ID = SM.DCR_ID and  SM_ITEM.strg_code = SM.strg_code " +
						" LEFT JOIN ITEM ITEM ON ITEM.ITEM_CODE = SM_ITEM.ITEM_CODE " +
						" LEFT JOIN LOCALITY ON LOCALITY.LOCALITY_CODE=SM.LOCALITY_CODE " +
						" WHERE SM.DCR_ID = '"+dcrId+"' AND CUST_CLASS.CUST_TYPE = 'C' AND SM.STRG_TYPE = 'C'" +
						" ORDER BY SM.STRG_CODE";
				//Code for  db2 End
				
				
				//Code for  Base Start
				//This sql remove some table only For testing purpuse only
				/*sql = " SELECT SM.TRAN_ID, SM.PLAN_ID, SM.EVENT_DATE, SM.EVENT_TYPE, " +
						"SM.STRG_CODE,SM.STRG_NAME, CUST1.FIRST_NAME AS CUST_FNAME," +
						//" SM_ITEM.QUANTITY, SM_ITEM.BRIEFED_DESCR, SM_ITEM.ITEM_CODE, ITEM.DESCR AS ITEM_DESCR," +
						" CUST1.MIDDLE_NAME CUST_MNAME , CUST1.LAST_NAME AS CUST_LNAME , " +
						"SM.STRG_TYPE, SM.STRG_NO_VISIT, SM.EVENT_TIME_START, " +
						" SM.EVENT_TIME_END, SM.STRG_CLASS_CODE  , " +
						"SM.SALES_PERS, E.EMP_FNAME AS SPRS_FNAME, E.EMP_MNAME AS SPRS_MNAME," +
						" E.EMP_LNAME AS SPRS_LNAME, SM.SALES_TEAM, E1.EMP_FNAME AS SALES_TEAM_FNAME, E1.EMP_MNAME AS SALES_TEAM_MNAME, E1.EMP_LNAME AS SALES_TEAM_LNAME , " +
						" SM.OTH_PARTICIPANT, SM.REMARKS,SM.ORDER_BOOKED, SM.MEET_SUMM, SM.LOCALITY_CODE, SM.TEMPLATE_FILE, SM.SPRS_CODE__WW, " +
						" E2.EMP_FNAME AS SPRS_CODE__WW_FNAME, E2.EMP_MNAME AS SPRS_CODE__WW_MNAME, E2.EMP_LNAME AS SPRS_CODE__WW_LNAME, SM.LAST_MEET_SUMM," +
						" SM.LAST_MEET_DATE, SM.LAST_PROD_BRF, SM.REF_TRAN_ID, SM.CONF_DATE, SM.CONFIRMED, SM.EMP_CODE__APRV, SM.SHORT_ID, SM.SC_CODE__REF," +
						" SM.MEET_SUMM_MGR, SM.DCR_ID, SM.WORK_TEAM, SM.WORK_WITH_OTHER, SM.POB_VAL FROM   STRG_MEET SM" +
						" LEFT JOIN STRG_CUSTOMER CUST1 ON CUST1.SC_CODE = SM.STRG_CODE" +
						" LEFT JOIN  EMPLOYEE E  ON E.EMP_CODE  =  SM.SALES_PERS" +
						" LEFT JOIN  EMPLOYEE E1  ON E1.EMP_CODE  =  SM.SALES_TEAM" +
						" LEFT JOIN  EMPLOYEE E2  ON E2.EMP_CODE  =  SM.SPRS_CODE__WW " +
						//" LEFT JOIN STRG_MEET_ITEMS SM_ITEM ON  SM_ITEM.DCR_ID =  SM.DCR_ID " +
						//" LEFT JOIN ITEM ITEM ON ITEM.ITEM_CODE  = SM_ITEM.ITEM_CODE " +
						" WHERE SM.DCR_ID = '"+dcrId+"'  AND SM.STRG_TYPE = 'C'";*/
				//Code for  Base End
				
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				int chemistCount = 1;
				complDayWiseDetailJson = new JSONObject();
				count = 0;
				while(rs.next())
				{
					System.out.println("In chemist chemistCount = "+chemistCount);
					doctorName       	=  (rs.getString("CUST_FNAME") == null ? "" : rs.getString("CUST_FNAME")) + " " + (rs.getString("CUST_MNAME") == null ? "" : rs.getString("CUST_MNAME")) + " " + (rs.getString("CUST_LNAME") == null ? "" : rs.getString("CUST_LNAME")) ;
					spFullName       	=  (rs.getString("SPRS_FNAME") == null ? "" : rs.getString("SPRS_FNAME")) + " " + (rs.getString("SPRS_MNAME") == null ? "" : rs.getString("SPRS_MNAME")) + " " + (rs.getString("SPRS_LNAME") == null ? "" : rs.getString("SPRS_LNAME")) ;
					teamName       		=  (rs.getString("SALES_TEAM_FNAME") == null ? "" : rs.getString("SALES_TEAM_FNAME")) + " " + (rs.getString("SALES_TEAM_MNAME") == null ? "" : rs.getString("SALES_TEAM_MNAME")) + " " + (rs.getString("SALES_TEAM_LNAME") == null ? "" : rs.getString("SALES_TEAM_LNAME")) ;
					
					rowData = new JSONObject();
					rowData.put("srno_chemist", chemistCount);
					rowData.put("strgclass_descr_chemist", checkNull(rs.getString("CLASS_CODE_DESCR")));
					rowData.put("chemist_name", checkNull(doctorName));
					
					if(checkNull(rs.getString("ITEM_CODE")) == "")
					{
						briefDescr = checkNull(rs.getString("BRIEFED_DESCR"));
					}
					else
					{
						briefDescr = checkNull(rs.getString("ITEM_DESCR"));
					}
					rowData.put("prod_name", briefDescr);
					rowData.put("che_quantity", checkNull(rs.getString("QUANTITY")));
					rowData.put("ord_book_chemist", checkNull(rs.getString("ORDER_BOOKED")));
					rowData.put("oth_parti_chemist", checkNull(rs.getString("OTH_PARTICIPANT")));
					rowData.put("saleteam_name_chemist", checkNull(teamName));
					rowData.put("remk_chemist", checkNull(rs.getString("MEET_SUMM")));
					rowData.put("loca_chemist", checkNull(rs.getString("LOC_DESCR"))); //Show locality on table
					rowData.put("strg_code_chemist", checkNull(rs.getString("STRG_CODE")));
					complDayWiseDetailJson.put(count, rowData);
					count++;
					chemistCount++;

				}
				complDayWiseDetailFinalJsn.put("4", complDayWiseDetailJson);
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			System.out.println("In getComplDayWiseDetail1 selected ==>>eventDate = ["+eventDate+"] salesPersCode = ["+salesPersCode+"]" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ComplianceDB2 : getComplDayWiseDetail1" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return complDayWiseDetailFinalJsn;
	}
	
	private String getSalesPersLastDCRDate (Connection conn, String salesPers, String currDCRId)
	{
		String lastDCRDate = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//SimpleDateFormat gridDateFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
            //SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat(genericUtility.getApplDateFormat());
          
            //Code for Base Start
			/*SimpleDateFormat gridDateFormat = new SimpleDateFormat( "dd-MMM-yy");
			SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat("dd/MM/yy");*/
            //Code for Base End
            //VARCHAR(DATE(S.EVENT_DATE)) AS EVENT_DATE
			sql= "SELECT DATE(MAX(EVENT_DATE)) AS LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE SALES_PERS =  ? AND DCR_ID != ?  ";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			pstmt.setString(2, currDCRId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				//eventDate = gridDateFormat.format(convrtToTimStmDate.parse(eventDate));
				//lastDCRDate = rs.getString(1) == null ? "" : gridDateFormat.format(convrtToTimStmDate.parse(rs.getString(1)));
				lastDCRDate = (rs.getString("LAST_DCR_DATE"));
				System.out.println(" last DCR Date = "+lastDCRDate);
			}
			else
			{
				System.out.println("No Last DCR date details found for ["+salesPers+"] and DCR ID other than ["+currDCRId+"]");

				if(rs != null)
				{
					rs.close();
					rs =null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				sql= "SELECT DATE(MAX(EVENT_DATE)) AS LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE SALES_PERS =  ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, salesPers);
				pstmt.setString(2, currDCRId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					//lastDCRDate = rs.getString(1) == null ? "" : gridDateFormat.format(convrtToTimStmDate.parse(rs.getString(1)));
					lastDCRDate = (rs.getString("LAST_DCR_DATE"));
				}
			}
			if(rs != null)
			{
				rs.close();
				rs =null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception ex)
		{

		}
		return lastDCRDate;
	}
	/*Added by chetan mahajan on 1-July-2016 for compliance dashboard reports - End*/
}
