package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.CDNDetails;
import ibase.webitm.bean.gst.CDNR;
import ibase.webitm.bean.gst.InvLineItem;

public class CDNRSerializer extends JsonSerializer<CDNR>
{
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
    final SimpleDateFormat gstFmt = new SimpleDateFormat(gstCommonUtil.getGSTDateFormat());
	@Override
	public void serialize(CDNR cdnr, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		json.writeStringField("ctin", cdnr.ctin);
		
		json.writeFieldName("nt");
        json.writeStartArray();

        for(CDNDetails cdnDetails : cdnr.cdnDetails)
        {
        	writeCDNDetails(cdnr, json, cdnDetails);
        }
        
        json.writeEndArray();
        
        json.writeEndObject();
	}
	
	private void writeCDNDetails(CDNR cdnr, JsonGenerator json, CDNDetails cdnDetails)
	{
		try
		{
			json.writeStartObject();
			
			json.writeStringField("ntty", cdnDetails.cdnNoteType);
			json.writeStringField("nt_num", cdnDetails.cdNoteNumber);
			json.writeStringField("nt_dt", gstFmt.format(cdnDetails.cdNoteDate));
			json.writeStringField("inum", cdnDetails.invoiceNumber);
			json.writeStringField("idt", gstFmt.format(cdnDetails.invoiceDate));
			json.writeNumberField("val", cdnDetails.val);
			if(cdnDetails.reason != null && cdnDetails.reason.trim().length()>0)
			{
				json.writeStringField("rsn", cdnDetails.reason);
			}
			json.writeStringField("p_gst", cdnDetails.isPreGSTInvoice ? "Y" : "N");
			if(cdnDetails.taxPayerAction != null && cdnDetails.taxPayerAction.length() > 0)
			{
				json.writeStringField("flag", cdnDetails.taxPayerAction);
			}
			if(cdnDetails.checksum != null && cdnDetails.checksum.trim().length() > 0)
			{
				json.writeStringField("chksum", cdnDetails.checksum);
			}
			
			writeCDNLineItems(cdnDetails, json);

			json.writeEndObject();
		}
		catch(Exception e)
		{
			System.out.println("CDNRSerializer.writecdnDetails()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	
	private void writeCDNLineItems(CDNDetails cdnDetails, JsonGenerator json)
	{
		try 
		{
			json.writeFieldName("itms");
			json.writeStartArray();
	        
	        for(InvLineItem li : cdnDetails.items)
	        {
	        	writeLineItem(li, json);
	        }

	        json.writeEndArray();
		} 
		catch (IOException e) 
		{
			System.out.println("CDNRSerializer.writeCDNLineItems()["+e.getMessage()+"]");
			e.printStackTrace();
		}
        
		
	}
	
	private void writeLineItem(InvLineItem li, JsonGenerator json) 
    {
        try 
        {
            json.writeStartObject();
            
        	json.writeNumberField("num", li.num);
        	
        	json.writeFieldName("itm_det");
        	json.writeStartObject();
        	
            json.writeNumberField("rt", li.rate);
            json.writeNumberField("txval", li.taxval);

            if(li.iamt > 0)
            {
            	json.writeNumberField("iamt", li.iamt);
            }
            if(li.camt > 0)
            {
            	json.writeNumberField("camt", li.camt);
            }
            if(li.samt > 0)
            {
            	json.writeNumberField("samt", li.samt);
            }
            if(li.csamt > 0)
            {
            	json.writeNumberField("csamt", li.csamt);
            }
            json.writeEndObject();
            
            if(li.itcType != null)
            {
            	json.writeFieldName("itc");
            	json.writeStartObject();
            	
            	json.writeStringField("elg", li.itcType);
            	json.writeNumberField("tx_i", li.igstInputTax);
            	json.writeNumberField("tx_s", li.cgstInputTax);
            	json.writeNumberField("tx_c", li.sgstInputTax);
            	json.writeNumberField("tx_cs", li.cessInputTax);
            	
            	json.writeEndObject();
            }
            
            json.writeEndObject();
        }
        catch (Exception e) 
        {
        	System.out.println("CDNRSerializer.writeLineItem()["+e.getMessage()+"]");
            e.printStackTrace();
        }
    }

}
