package ibase.dashboard.wms.bean;
import ibase.dashboard.wms.ejb.*;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.naming.InitialContext;

@SuppressWarnings("serial")
public class EORLocationStockBean implements Serializable
{

	EORLocationStockRemote  eORLocationStockRemote = null;  

	public EORLocationStockBean()
	{
		System.out.println("inside LocationStockOccuBean Created");
		InitialContext ctx  = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			eORLocationStockRemote = (EORLocationStockRemote) ctx.lookup("ibase/EORLocationStock/remote");
		}
		catch(Exception e)
		{
			System.out.println("Exception :ibase.dashboard.scm.bean:EORLocationStockBean:EORLocationStockBean() "+e);
			e.printStackTrace();
		}
	}
	
	public String getEORLocPhyArea() throws RemoteException, ITMException
	{
		String xmlData = "";
		try
		{
			xmlData = eORLocationStockRemote.getEORLocPhyArea();
		}
		catch(Exception e)
		{
			System.out.println("Exception :ibase.dashboard.scm.bean::EORLocationStockBean:getLocPhyArea()"+e);
			e.printStackTrace();
			xmlData = null;
		}
		return xmlData;
	}
	
	public String getSelectedArea()
	{
		String selectedEntity="";
		try
		{
			selectedEntity = eORLocationStockRemote.getSelectedArea();
		}
		catch(Exception e)
		{
			System.out.println("Exception :ibase.dashboard.scm.bean::EORLocationStockBean:getSelectedArea()"+e);
			e.printStackTrace();
			selectedEntity = null;
		}
		return selectedEntity;
	}
	
	public String getEORLocDtl(String locPhyArea, String siteCode,String locationRange, String expDate,String reTestDate) throws RemoteException, ITMException
	{
		String xmlData ="";		
		try
		{			
			xmlData = eORLocationStockRemote.getEORLocDtl(locPhyArea,siteCode,locationRange,expDate,reTestDate);
		}
		catch(Exception e)
		{
			System.out.println("Exception :ibase.dashboard.scm.bean::EORLocationStockBean:getLocDtl()"+e);
			e.printStackTrace();
			xmlData = null;
		}
		return xmlData;
	}
}
