package ibase.dashboard.mfg.servlet;

import ibase.dashboard.mfg.ejb.PendingQCPurchaseOrderRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class PendingQCOrderPurchaseServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		PendingQCPurchaseOrderRemote pendingQCOrderRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String siteCode = "";
		String geoLocation = "";
		
		
		try
		{
			System.out.println("in  PendingQCOrderPurchaseServlet  " );
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			
			dataSourceName 	= request.getParameter("dataSourceName");
			siteCode 		= request.getParameter("sitecode");
			geoLocation 	= request.getParameter("geoLocation");
			geoLocation 	= geoLocation.replace("@", "&");
			session.setAttribute("geoLocation", geoLocation);
			session.setAttribute("siteCode", siteCode);
			
			System.out.println("in PendingQCOrderPurchaseServlet SiteCode :"+siteCode+"----geoLocation :"+geoLocation);
			
			context = new InitialContext(appConnectParm.getProperty());
			pendingQCOrderRemote = (PendingQCPurchaseOrderRemote) context.lookup("ibase/PendingQCPurchaseOrder/remote");
			/*setUserInfo(userInfo) for DB connection on dated:14062016*/
			pendingQCOrderRemote.setUserInfo(userInfo);
			JSONObject jsonObjData = (JSONObject) pendingQCOrderRemote.getPendingQCOrderPurchase(geoLocation,siteCode,dataSourceName);
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("  in servlet Final data set for PendingQCOrderPurchaseServlet  build the Graph is===" + jsonObjData);
		} catch (Exception e)
		{
			System.out.println("Exception : PendingQCOrderPurchaseServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}