 package ibase.dashboard.pai.ejb;
 
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;
import org.json.simple.JSONObject;
 
@Stateless
public class PendingOrderPai extends ValidatorEJB  implements PendingOrderPaiRemote, PendingOrderPaiLocal

{
	GenericUtility genericUtility = new GenericUtility();
	
	/********** Start of method getPendingOrderServlet()
	* EJB Name           : PendingOrder.java
	* Method Name        : getPendingOrderPaiServlet(String,String)
	* Servlet Name       : PendingOrderPaiServlet
	* Metadata xml Name  : pendingorder.xml
	* 
	* */
	
	@SuppressWarnings("unchecked")
	public JSONObject getPendingOrderPaiServlet(String dataSourceName,String custCode) throws RemoteException, ITMException
	{
		JSONObject pendingOrderJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		int count=0;
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			System.out.println(" Inside getPendingOrderPaiServlet() Data Soruc Name ="+dataSourceName);
			  SimpleDateFormat appDateFormat = new SimpleDateFormat( genericUtility.getApplDateFormat());
			  SimpleDateFormat dbDateFormat= new SimpleDateFormat(genericUtility.getDBDateFormat());
		    sql = " select s.sale_order, s.due_date,(select count(1) from sorditem i where "
		    	  +" i.sale_order = s.sale_order    and i.line_type = 'I') as no_items,s.TOT_ORD_VALUE,"
		    	  +" case when nvl((select sum(si.qty_desp) from sorditem si where "
		    	  +" si.sale_order = s.sale_order),0) = 0 then 'Full' else 'Partial' end as status " 
				  +" from sorder s  where s.confirmed = 'Y' and s.status not in ('C','X') and s.cust_code = ?  ";   
		    
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, custCode);
		    rs = pstmt.executeQuery();
			while (rs.next())
			 {
				rowData = new JSONObject();
				String dueDate= checkNull(rs.getString("due_date"));
				if(dueDate.trim().length()>0)
				{
					rowData.put("due_date", appDateFormat.format(dbDateFormat.parse(dueDate)));
				}
				else
				{							
					rowData.put("due_date", checkNull(rs.getString("due_date")));
				}
				rowData.put("no_of_item",   checkNull(rs.getString("no_items")));
				rowData.put("order_value",   checkNull(rs.getString("TOT_ORD_VALUE")));
				rowData.put("status",   checkNull(rs.getString("status")));
				rowData.put("sale_order",   checkNull(rs.getString("sale_order")));
				pendingOrderJson.put(count, rowData);
				count++;
			 }
			System.out.println("JSON in getPendingOrderPaiServlet() : "+pendingOrderJson);
		 }
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :PendingOrderPai: getPendingOrderPaiServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return pendingOrderJson;
	}
	/********** End of method getPendingOrderServlet()  ******/
	

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}

 }

