CREATE TABLE  MULTI_PICK_ISS (
TRAN_ID			CHAR(10) NOT NULL, 
TRAN_DATE		DATE NOT NULL, 
SITE_CODE		CHAR(5) NOT NULL, 
STATUS			CHAR(1), 
STATUS_DATE		DATE, 
CONFIRMED		CHAR(1), 
CONF_DATE		DATE, 
REMARKS			VARCHAR2(60), 
EMP_CODE__USER		CHAR(10),
CHG_DATE		DATE NOT NULL, 
CHG_USER		CHAR(10) NOT NULL, 
CHG_TERM		VARCHAR2(15) NOT NULL 
) TABLESPACE ITM_DIS_D2;
ALTER TABLE MULTI_PICK_ISS ADD  CONSTRAINT MPTCN_PICK_X PRIMARY KEY ( TRAN_ID ) USING INDEX TABLESPACE ITM_DIS_I1;
ALTER TABLE MULTI_PICK_ISS ADD CONSTRAINT FK_MPTCN_PICK_SITE_CODE FOREIGN KEY (SITE_CODE) REFERENCES site (SITE_CODE);


CREATE TABLE MULTI_PICK_ISS_HDR (
TRAN_ID			CHAR(10) NOT NULL, 
LINE_NO			NUMBER(14,3) NOT NULL, 
PTCN			CHAR(10), 
SALE_ORDER		CHAR(10), 
WAVE_ID			VARCHAR2(10) 
) TABLESPACE ITM_DIS_D2;
ALTER TABLE MULTI_PICK_ISS_HDR ADD  CONSTRAINT MPTCN_PICK_DET_X PRIMARY KEY ( TRAN_ID,LINE_NO ) USING 
INDEX TABLESPACE ITM_DIS_I1;

CREATE TABLE MULTI_PICK_ISS_DET (
TRAN_ID			CHAR(10) NOT NULL, 
LINE_NO			NUMBER(14,3) NOT NULL, 
SITE_CODE		CHAR(5) NOT NULL, 
PTCN			CHAR(10), 
SALE_ORDER		CHAR(10), 
LINE_NO__SORD		CHAR(3),
PICK_ORDER		CHAR(10),
LOC_CODE		CHAR(8), 
ITEM_CODE		CHAR(10), 
LOT_NO			CHAR(15), 
LOT_SL			CHAR(15), 
QUANTITY		NUMBER(14,3), 
NO_ART			NUMBER(6),
STATUS			CHAR(1),
CARTON_NO		VARCHAR2(20),
OUTER_CARTON_NO		VARCHAR2(20),
DEALLOC_QTY		NUMBER(14,3)
)TABLESPACE ITM_DIS_D2;
ALTER TABLE MULTI_PICK_ISS_DET ADD  CONSTRAINT MPTCN_PICK_ITEM_X PRIMARY KEY ( TRAN_ID,LINE_NO ) USING INDEX TABLESPACE ITM_DIS_I1;
ALTER TABLE MULTI_PICK_ISS_DET ADD CONSTRAINT FK_MPTCN_PICK_ITEM_SITE_CODE FOREIGN KEY (SITE_CODE) REFERENCES SITE (SITE_CODE);



Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,CLOSE_ICON,OPEN_ICON,OBJ_TYPE,CHG_DATE,CHG_TERM,CHG_USER,MOB_DEPLOY) values 
('WMS',1,63,0,0,0,'w_multi_pick_iss','Multi Picking',null,'WMS.1.63.0.0.0','e12_logo.gif',null,null,'W',sysdate,'BASE','BASE','Y');


Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,SCAN_FLAG,SCAN_METADATA,AUTO_ACCEPT_SCAN,PROPERTY_INFO,EXT_COM,EXT_METADATA,EXT_SETUP,AFTER_SAVE,COLUMN_ON_SAVE,SCAN_DELIMITER,AUTO_ACCEPT_WEIGHDATA,DEFAULT_VIEW,SELECTION_MODE,STORAGE_KEY_METADATA,ASSISTED_MODE,PARENT_KEY_COL,QTY_COL,FORM_TYPE,DISP_METADATA,RATE_COL,AUTO_ADDON_ENTRY)
values ('w_multi_pick_iss','Multi Picking',null,null,null,null,null,null,'1','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,'E',null,null,null,null,null,null);

Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,SCAN_FLAG,SCAN_METADATA,AUTO_ACCEPT_SCAN,PROPERTY_INFO,EXT_COM,EXT_METADATA,EXT_SETUP,AFTER_SAVE,COLUMN_ON_SAVE,SCAN_DELIMITER,AUTO_ACCEPT_WEIGHDATA,DEFAULT_VIEW,SELECTION_MODE,STORAGE_KEY_METADATA,ASSISTED_MODE,PARENT_KEY_COL,QTY_COL,FORM_TYPE,DISP_METADATA,RATE_COL,AUTO_ADDON_ENTRY) 
values ('w_multi_pick_iss','Header',null,null,null,null,null,null,'2','T',null,'<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>',null,null,null,null,null,null,null,null,null,null,null,null,'A',null,null,null,'checkedImage@img<ptcn>,<sale_order>,<wave_id>',null,null);

Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,SCAN_FLAG,SCAN_METADATA,AUTO_ACCEPT_SCAN,PROPERTY_INFO,EXT_COM,EXT_METADATA,EXT_SETUP,AFTER_SAVE,COLUMN_ON_SAVE,SCAN_DELIMITER,AUTO_ACCEPT_WEIGHDATA,DEFAULT_VIEW,SELECTION_MODE,STORAGE_KEY_METADATA,ASSISTED_MODE,PARENT_KEY_COL,QTY_COL,FORM_TYPE,DISP_METADATA,RATE_COL,AUTO_ADDON_ENTRY) 
values ('w_multi_pick_iss','Detail',null,null,null,null,null,null,'3','T',null,'<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>Pick Location:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>Quantity:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>quantity</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>',null,null,null,null,null,null,null,null,null,'U',null,null,'E',null,null,null,'checkedImage@img<ptcn>,<loc_code>,<item_descr> - <item_code>, <quantity>',null,null);


Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',1,'N',null,null,'Next','Next',null,'1',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',2,'P','a','a','Prev','Prev',null,'2',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',3,'N','a','a','Next','Next',null,'2',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',4,'P','a','a','Prev','Prev',null,'3',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',5,'A',null,null,'Add Record','Add',null,'2',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',6,'S',null,null,'Saving','Finish',null,'3',null,null,'U',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_pick_iss',7,'A',null,null,'Add Record','Add',null,'3',null,null,'U',null,to_timestamp('29-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE           ','BASE      ',null,null,null);


Insert into transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,UDF_1,UDF_2,UDF_3,UDF_4,UDF_5,REPEATE_ADD,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,SITE_ACC_COL,CONFIRM_COL,CONFIRM_VAL,REPEAT_ADD_DET,LOAD_MODE,AUTO_CONFIRM,LEDG_POST_CONF,CHG_DATE_ON_CONF,TRAN_ID_COL,MAIL_OPTION,CONFIRM_MODE,GARBAGE_OPT,VAL_FLAG_EDI,VERIFY_PASSWORD,TABLE_NAME,APPLICATION,TABLE_DESC,TRAN_DATE_COL,SALES_PERS_ACC_COL,CUST_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_COL,EMP_ACC_COL,WORKFLOW_OPT,TRAN_ID__FROM,TRAN_ID__TO,MULTITIRE_OPT,REF_SER,VIEW_MODE,TABLE_NAME_DET1,TABLE_NAME_DET2,TABLE_NAME_DET3,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CUSTOM_PREVIEW_OBJ,CHILDDATA_ARGOPT,IGNOREERRLIST_ONLOAD,EDIT_TMPLT,WRKFLW_INIT,FORMAL_ARGS,EDIT_OPT,AUDIT_TRAIL_OPT,EDITTAX,CACHE_OPT,OPTIMIZE_MODE,EDIT_EXPR,TRANSFER_MODE,RATE_COL,QTY_COL,RCP_CACHE_STATUS,PRINT_CONTROL,PROFILE_ID__RES,TRAN_COMPL_MSG,EXEC_TYPE,START_FORM,PERIOD_OPTION,HEADER_FORM_NO,WRKFLW_PRIORITY,EDIT_EXPR_INP,ISATTACHMENT,ITEM_SER_ACC_CODE,REPEATADDDET,ALLOW_ATTACH,DISP_META_DATA,MSG_ONSAVE,WF_STATUS,CONFIRM_BY_COL,CONFIRM_DATE_COL,RESTART_FORM) values ('w_multi_pick_iss','A','2','A','seq10','Y',null,null,null,null,'N',to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE           ','0',null,null,null,null,null,null,'Y','Y','TRAN_ID','0','0','N',null,null,'multi_pick_iss','WMS',null,null,null,null,null,null,null,null,null,null,null,'M-PTCN','F',null,null,null,null,null,null,null,'2',null,null,null,null,null,'0',null,null,null,null,null,null,null,null,null,null,null,null,null,'M','1',null,null,null,null,null,null,null,null,null,null,null,null);


Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','default_data_wiz','1','mpick_iss_default_data',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWiz',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','post_item_change','1','poic_default_ejb',null,to_timestamp('09-10-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWiz',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','post_save','1','mpick_iss_pos',null,to_timestamp('30-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWizPos',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','pre_navigate_finish','1','pos_mpick_iss_finish',null,to_timestamp('30-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWizPos',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','pre_navigate_next','1','prv_mpick_iss',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWiz',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_pick_iss','pre_validate','1','prv_mpick_iss',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','2','0','EJB','MultiplePtcnWiz',null);


Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('mpick_iss_default_data','Default Data','http://localhost:9090/axis/services/ValidatorService','BASE','itemChanged','String','S',null,null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE');
Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('mpick_iss_pos','post save','http://localhost:9090/axis/services/ValidatorService','BASE','postSave','String','S',null,null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE');
Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('poic_default_ejb',null,'http://localhost:9090/axis/services/ValidatorService',null,'itemChanged','String','S',null,null,to_timestamp('01-06-12','DD-MM-RR HH12:MI:SSXFF AM'),'Subrata   ','Subu');
Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('prv_mpick_iss','Validation','http://localhost:9090/axis/services/ValidatorService','BASE','wfValData','String','S',null,null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'          ','BASE');



Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',1,'COMPONENT_TYPE','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',2,'COMPONENT_NAME','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','MultiplePtcnWiz');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',3,'XML_DATA','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',4,'XML_DATA_1','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',5,'XML_DATA_ALL','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',6,'OBJ_CONTEXT','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',7,'FOCUSED_COLUMN','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',8,'EDIT_FLAG','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_default_data',9,'XTRA_PARAMS','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',1,'COMPONENT_TYPE','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',2,'COMPONENT_NAME','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','MultiplePtcnWizPos');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',3,'XML_DATA_ALL','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',4,'<tran_id>','I',null,'B.String',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',5,'EDIT_FLAG','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',6,'XTRA_PARAMS','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('mpick_iss_pos',7,'DB_CONN','I',null,'S.Connection',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',1,'COMPONENT_TYPE','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',2,'COMPONENT_NAME','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',3,'XML_DATA','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',4,'XML_DATA_1','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',5,'XML_DATA_ALL','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',6,'OBJ_CONTEXT','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',7,'FOCUSED_COLUMN','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',8,'EDIT_FLAG','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('poic_default_ejb',9,'XTRA_PARAMS','I',null,'S',null,null,null,null,null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',1,'COMPONENT_TYPE','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',2,'COMPONENT_NAME','I',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE','MultiplePtcnWiz');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',3,'XML_DATA','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',4,'XML_DATA_1','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',5,'XML_DATA_ALL','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',6,'OBJ_CONTEXT','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',7,'EDIT_FLAG','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('prv_mpick_iss',8,'XTRA_PARAMS','l',null,'S',null,to_timestamp('23-12-14','DD-MM-RR HH12:MI:SSXFF AM'),'BASE      ','BASE',null);


Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('multi_pick_iss','2','ptcn',null);

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNNN','Empty PTCN !!!','PTCN can not be blank.Please enter PTCN','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNNE','Invalid PTCN','Entered PTCN is not defined in wave_task_det master','E',sysdate,'BASE','BASE');


insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNAC','Confirmed PTCN','All task selected PTCN are confirmed','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNAS','PTCN already scanned','Entered PTCN already scanned','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNOH','PTCN on hold','Entered PTCN on hold please check','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNIC','Cancel PTCN','Entered PTCN is cancel please check','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNQG','Invalid Quantity !!!','Entered quantity cannot be greater picking quantity','E',sysdate,'BASE','BASE');

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNTNC','Task incompleted','Dependent task not completed for this PTCN','E',sysdate,'BASE','BASE');

Insert into disparm (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','IMEDIATE_LOC','S','ISTAG   ','INTERMEDIATE LOCATION ACTIVE PICK',0,sysdate,'BASE','BASE');

Insert into location (LOC_CODE,DESCR,SH_DESCR,LOC_TYPE,INV_STAT,ONE_ITEM,CAPACITY,CAP_UOM,LOC_GROUP,TEMP,SITE_CODE,SITE_CODE__OWN,ITEM_CODE,EFF_FROM,VALID_UPTO,HIRE_CHARGE,USABLE,CHG_DATE,CHG_USER,CHG_TERM,ZONE,PALLET_BASED,SINGLE_LOT_SL,ITEM_LOT_OPT,CYCLE_COUNT_REQD,PHY_HAN_BASIS,FACILITY_CODE)
 values ('ISTAG   ','INTERMEDIATE LOCATION FOR ACTIVES','INTERMEDIATE LOC','N','STAG ','N',9999,null,'S    ','N',null,null,null,null,null,0,'Y',SYSDATE,'BASE      ','base-Lenovo    ',null,'N','N','2','N','L','          ');

update obj_forms set scan_metadata = '<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>Pick Location:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>Lot No.:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_no</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="4"><SCAN_LABEL>Lot sl:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_sl</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="5"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>Quantity:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>quantity</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>'
where win_name ='w_multi_pick_iss' and form_no = 3;

update obj_forms set disp_metadata = 'checkedImage@img<ptcn>,<loc_code>,<lot_no>,<lot_sl>,<item_descr> - <item_code>, <quantity>' 
where win_name ='w_multi_pick_iss' and form_no = 3;

INSERT INTO OBJ_ITEMCHANGE(OBJ_NAME,fORM_nO,FIELD_NAME,MANDATORY)VALUES('wavegen','1','batch_id','Y');

alter table wave_task add batch_id varchar2(10); 

INSERT INTO messages (    msg_no , 	msg_str, 	msg_descr , 	msg_type , 	msg_opt , 	msg_time , 	alarm , 	err_source , 	chg_date , 	chg_user , 	chg_term , 	override_input , 	mail_option ) VALUES ( 	'VTNOBATCH7', 	'No Pending orders!', 	'There is no pending orders for this batch id', 	'E', 	'Y', 	NULL, 	NULL, 	NULL, 	fn_sysdate(), 	'BASE      ', 	'BASE      ', 	NULL, 	NULL);
INSERT INTO messages ( 	msg_no , 	msg_str, 	msg_descr , 	msg_type , 	msg_opt , 	msg_time , 	alarm , 	err_source , 	chg_date , 	chg_user , 	chg_term , 	override_input , 	mail_option ) VALUES ( 	'VTINVBATCW', 	'Invalid Batch Id!', 	'Entered batch id is not valid, please enter valid batch id ', 	'E', 	'Y', 	NULL, 	NULL, 	NULL, 	fn_sysdate(), 	'BASE      ', 	'BASE      ', 	NULL, 	NULL);


--24/02/15

delete from system_events where obj_name ='multi_pick_iss' and event_code ='post_save';
delete from system_event_services where  service_code in (select service_code from system_events where obj_name ='multi_pick_iss' and event_code ='post_save');  
delete from system_service_args where  service_code in (select service_code from system_events where obj_name ='multi_pick_iss' and event_code ='post_save');  

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM)
values ('pos_mpick_iss_finish','post save ','http://localhost:9090/axis/services/ValidatorService','BASE','postSave','String','S',null,null,sysdate,'BASE      ','BASE');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',1,'COMPONENT_TYPE','I',null,'S',null,sysdate,'BASE      ','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',2,'COMPONENT_NAME','I',null,'S',null,sysdate,'BASE      ','BASE','MultiplePtcnWizPos');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',3,'XML_DATA_ALL','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',4,'<tran_id>','I',null,'B.String',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',5,'EDIT_FLAG','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',6,'XTRA_PARAMS','I',null,'S',null,sysdate,'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_finish',7,'DB_CONN','I',null,'S.Connection',null,sysdate,'BASE      ','BASE',null);

update obj_forms set scan_metadata ='<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>Pick Location:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>Lot No.:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_no</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="4"><SCAN_LABEL>Lot sl:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_sl</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="5"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>Quantity:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>quantity</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>'
where win_name ='w_multi_pick_iss' and form_no = 3;

update obj_forms set disp_metadata ='checkedImage@img<loc_code>, <item_code>, <lot_no>, <lot_sl>, <ptcn>, <quantity>'
where win_name ='w_multi_pick_iss' and form_no = 3;

--26/02/15
Insert into obj_actions (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) 
values ('multi_pick_iss',8,'Q',null,null,'Deselect Item','DESELECT',null,'2',null,null,'U',null,sysdate,null,null,null,null,null);


CREATE OR REPLACE
TRIGGER multi_PTCN_TRG
AFTER  DELETE ON multi_pick_iss_hdr
FOR EACH ROW
BEGIN
  delete from multi_pick_iss_det 
  where tran_id = :OLD.tran_id 
  and ptcn = :old.ptcn;
END ;


ALTER TABLE multi_pick_iss_det ADD PICK_ORD__LINE_NO  char(3);
update  obj_forms set scan_metadata= '<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></INPUT_SCAN><SCAN_CONDITION field="ptcn">ptcn =="null" ||ptcn == ""</SCAN_CONDITION></SCAN_INFO>'
 where win_name ='w_multi_pick_iss' and form_no =2;
 
 delete from obj_actions where obj_name ='multi_pick_iss' and form_no =3 and title like '%Add%';
 
 --03/02/15 
ALTER TABLE multi_pick_iss_hdr MODIFY  line_no char(3);
ALTER TABLE multi_pick_iss_det MODIFY  line_no char(3);

ALTER TABLE MULTI_PICK_ISS_HDR DROP CONSTRAINT MPTCN_PICK_DET_X;

ALTER TABLE MULTI_PICK_ISS_HDR ADD  CONSTRAINT MPTCN_PICK_DET_X PRIMARY KEY ( TRAN_ID,PTCN ) USING 
INDEX TABLESPACE ITM_DIS_I1;

--09/03/15

insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTPTCNAS','Remarks length error','Entered remarks should not be greater than 60 character','E',sysdate,'BASE','BASE');

 ------------Changed By Dadaso/Samadhan for multi ptcn and consolidated replenishment.Start (12-JUN-15)---

 

Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,CLOSE_ICON,OPEN_ICON,OBJ_TYPE,CHG_DATE,CHG_TERM,CHG_USER,MOB_DEPLOY) values 
('WMS',1,66,0,0,0,'w_consolidate_repl','Consolidate Repliehshment',null,'WMS.1.66.0.0.0','e12_logo.gif',null,null,'W',sysdate,'BASE','BASE','Y');


Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW) values ('w_consolidate_repl','Consolidated Repl',null,null,null,null,null,null,'1','F',null,null,'<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>Replenishment Task ID:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>repl_order</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>',null,null,null,null,null,null,null,null,null,null,null,null,null,'E',null,null,'A');
Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW) values ('w_consolidate_repl','RT-Order',null,null,null,null,null,null,'2','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'E',null,null,'A');
Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW) values ('w_consolidate_repl','RT-Inventory',null,null,null,null,null,null,'3','T',null,null,'<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>Location From:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>LPN Number:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_sl</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD ORDER="0" start="6" end="15" >item_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="4"><SCAN_LABEL>Lot Number:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD ORDER="0" start="13" end="22" >lot_no</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>New LPN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_sl__new</FIELD></FIELDS></INPUT_SCAN><INPUT_SCAN ORDER="2"><SCAN_LABEL>No of CASE</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD  ORDER="0" mandatory = "N">no_art</FIELD></FIELDS></INPUT_SCAN><INPUT_SCAN ORDER="3"><SCAN_LABEL>Quantity</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD  ORDER="0" mandatory = "N">quantity</FIELD></FIELDS></INPUT_SCAN><SCAN_CONDITION field="lot_sl__new">order_type == "V" || order_type == "U"</SCAN_CONDITION><SCAN_CONDITION field="quantity">no_art == "null" || no_art == "0" || no_art == ""</SCAN_CONDITION></SCAN_INFO>',null,null,null,null,null,null,null,null,null,'checkedImage@img<loc_code>, <item_code>, <lot_no>, <lot_sl>, <no_art> <unit> = <loc_code__to> <lot_sl__new>',null,null,null,'E',null,null,'A');
Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW) values ('w_consolidate_repl','AP-Locate',null,null,null,null,null,null,'4','T',null,null,'<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>LPN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>lot_sl__new</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>To  Location :</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code__to</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>',null,null,null,null,null,null,null,null,null,'checkedImage@img<lot_sl__new>, <loc_code__sys>',null,null,null,'E',null,null,'A');


Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('consolidate_repl',1,null,'Saving',null,null,'S','Finish','4',null,null,'U',null,sysdate,'BASE','Dadaso',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('consolidate_repl',2,null,'Prev','a','a','P','Previous','2',null,null,'U',null,null,null,null,null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('consolidate_repl',3,null,'Next','a','a','N','Next','1',null,null,'U',null,null,null,null,null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('consolidate_repl',4,'confirm~normal.gif','Confirming records','pre_confirm','a','F','Confirm','2','2','1','S',null,null,null,null,null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('consolidate_repl',5,null,'Prev',null,null,'P','Previous','3',null,null,'U',null,null,null,null,null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('consolidate_repl',6,null,'Next',null,null,'N','Next','2',null,null,'U',null,null,null,null,null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('consolidate_repl',7,null,'Next','a','a','N','Next','3',null,null,'U',null,null,null,null,null,null,null);



Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('consolidate_repl','default_data_wiz','1','repl_iss_default_data',null,'0',sysdate,'Dadaso','BASE','2','EJB','ReplIssIC',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('consolidate_repl','post_save','1','pos_repl_iss',null,'0',sysdate,'chaitali  ','BASE','2','EJB','ReplIssPos',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('consolidate_repl','post_validate','1','post_gen_val',null,'0',sysdate,'BASE','BASE','2','EJB','GenValidate',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('consolidate_repl','pre_navigate_next','1','prv_repl_iss_next',null,'0',sysdate,'Dadaso ','BASE','2','EJB','ReplIssIC',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('consolidate_repl','pre_validate','1','prv_repl_iss',null,'0',sysdate,'Dadaso','BASE','2','EJB','ReplIssIC',null);


Insert into transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,UDF_1,UDF_2,UDF_3,UDF_4,UDF_5,REPEATE_ADD,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,SITE_ACC_COL,CONFIRM_COL,CONFIRM_VAL,REPEAT_ADD_DET,REPEATADDDET,LOAD_MODE,AUTO_CONFIRM,LEDG_POST_CONF,CHG_DATE_ON_CONF,TRAN_ID_COL,MAIL_OPTION,CONFIRM_MODE,GARBAGE_OPT,VAL_FLAG_EDI,VERIFY_PASSWORD,CUST_ACC_COL,SALES_PERS_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_CODE,EMP_ACC_COL,ITEM_SER_ACC_COL,WORKFLOW_OPT,TABLE_NAME,APPLICATION,TABLE_DESC,TRAN_DATE_COL,TRAN_ID__FROM,TRAN_ID__TO,TABLE_NAME_DET1,TABLE_NAME_DET2,TABLE_NAME_DET3,MULTITIRE_OPT,REF_SER,VIEW_MODE,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CUSTOM_PREVIEW_OBJ,IGNOREERRLIST_ONLOAD,CHILDDATA_ARGOPT,EDIT_TMPLT,WRKFLW_INIT,EDITTAX,FORMAL_ARGS,AUDIT_TRAIL_OPT,EDIT_OPT,CACHE_OPT,OPTIMIZE_MODE,EDIT_EXPR,RATE_COL,QTY_COL,EDIT_EXPR_INP,RCP_CACHE_STATUS,PRINT_CONTROL,TRANSFER_MODE,PROFILE_ID__RES,TRAN_COMPL_MSG,PERIOD_OPTION,WRKFLW_PRIORITY,EXEC_TYPE,DISP_META_DATA,ALLOW_ATTACH,START_FORM,ISATTACHMENT,HEADER_FORM_NO,CONFIRM_DATE_COL,CONFIRM_BY_COL,MSG_ONSAVE,WF_STATUS,RESTART_FORM,CMS_PATH,BROW_DATA_DEF,DEF_VIEW,VIEW_OPTS) 
values ('w_consolidate_repl','A','2','A','seq10',null,null,null,null,null,'N',sysdate,'Dadaso','BASE','0','site_code','CONFIRMED','Y',null,null,null,null,null,null,'TRAN_ID','0','0',null,null,null,null,null,null,null,null,null,null,'repl_iss_hdr',null,null,null,null,null,null,null,null,null,'REPISS','F',null,null,null,null,null,null,null,null,null,null,'2',null,null,null,null,null,null,null,null,null,null,null,null,'M',null,null,null,null,null,null,'2',null,null,null,null,null,null,null,null,null);


insert into messages
(msg_no,msg_str,msg_descr,msg_type,chg_date,chg_user,chg_term) 
values 
('VTCRORDNA',' ',' ','E',sysdate,'BASE','BASE');



Insert into wave_seq (REF_SER,PRIORITY) values ('C-STG ',2);
Insert into refser (REF_SER,DESCR,TYPE,SYS_SER,PREFIX,CHG_DATE,CHG_USER,CHG_TERM,SEQ_NAME,TAX_FORM_REQD,TRANS_TYPE) 
values ('C-STG ','ReplenishmentTask (CASPK-STAGE)','S','C-STG ',null,to_date('06-JUN-12','DD-MON-RR'),'base      ','base           ',null,null,null);
insert into wave_seq(ref_ser,priority) values ('A-STG',4); 
Insert into refser (REF_SER,DESCR,TYPE,SYS_SER,PREFIX,CHG_DATE,
CHG_USER,CHG_TERM,SEQ_NAME,TAX_FORM_REQD,TRANS_TYPE) values 
('A-STG','ReplenishmentTask (Active-Stage)','S',null,null,SYSDATE,'BASE','BASE',null,null,null);


Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,ICON_PATH,CLOSE_ICON,OPEN_ICON,OBJ_TYPE,CHG_DATE,CHG_TERM,CHG_USER,MOB_DEPLOY) values ('WMS',1,64,0,0,0,'w_multi_master_pick','Multi Master Picking',null,'WMS.1.64.0.0.0','e12_logo.gif',null,null,'W',to_date('15-MAY-15','DD-MON-RR'),'BASE ','BASE','Y');



Insert into OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW) values ('w_multi_master_pick','Multi Picking',null,null,null,null,null,null,'1','F',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,'E',null,null,null);
Insert into OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW) values ('w_multi_master_pick','Header',null,null,null,null,null,null,'2','T',null,null,'<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></INPUT_SCAN><SCAN_CONDITION field="ptcn">ptcn =="null" ||ptcn == ""</SCAN_CONDITION></SCAN_INFO>',null,null,null,null,null,null,null,null,null,'checkedImage@img<ptcn>,<sale_order>,<wave_id>',null,null,null,'A',null,null,null);
Insert into OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW) values ('w_multi_master_pick','Detail',null,null,null,null,null,null,'3','T',null,null,'<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>Pick Location:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>loc_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="2"><SCAN_LABEL>Item Code:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>item_code</FIELD></FIELDS></MAPPING_SCAN><MAPPING_SCAN ORDER="3"><SCAN_LABEL>PTCN:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>ptcn</FIELD></FIELDS></MAPPING_SCAN><INPUT_SCAN ORDER="1"><SCAN_LABEL>Quantity:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>quantity</FIELD></FIELDS></INPUT_SCAN></SCAN_INFO>',null,null,null,null,null,null,null,null,null,'checkedImage@img<loc_code>,<item_code>, <ptcn>, <quantity>',null,null,null,'E',null,null,'U');
Insert into OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW) values ('w_multi_master_pick','Master Carton No',null,null,null,null,null,null,'4','T',null,null,'<SCAN_INFO><INPUT_SCAN ORDER="1"><SCAN_LABEL>Master Carton No:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>master_carton_no</FIELD></FIELDS></INPUT_SCAN><SCAN_CONDITION field="master_carton_no">master_carton_no =="null" ||master_carton_no == ""</SCAN_CONDITION></SCAN_INFO>',null,null,null,null,null,null,null,null,null,'checkedImage@img<master_carton_no>',null,null,null,'A',null,null,null);
Insert into OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW) values ('w_multi_master_pick','Carton No',null,null,null,null,null,null,'5','T',null,null,'<SCAN_INFO><MAPPING_SCAN ORDER="1"><SCAN_LABEL>Carton No:</SCAN_LABEL><FIELDS SEPARATOR="" DELIMITER=""><FIELD>carton_no</FIELD></FIELDS></MAPPING_SCAN></SCAN_INFO>',null,null,null,null,null,null,null,null,null,'checkedImage@img<carton_no>,<master_carton>',null,null,null,'E',null,null,null);

Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',1,null,'Next',null,null,'N','Next','1',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',2,null,'Prev','a','a','P','Prev','2',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',3,null,'Next','a','a','N','Next','2',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',4,null,'Prev','a','a','P','Prev','3',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',5,null,'Add Record',null,null,'A','Add','2',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',6,null,'Next','a','a','N','Next','3',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',7,null,'Prev','a','a','P','Prev','4',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',8,null,'Next','a','a','N','Next','4',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',9,null,'Add Record',null,null,'A','Add','4',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',10,null,'Prev','a','a','P','Prev','5',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',11,null,'Saving',null,null,'S','Finish','5',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),'BASE           ','BASE      ',null,null,null);
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) values ('multi_master_pick',12,null,'Deselect Item',null,null,'Q','DESELECT','2',null,null,'U',null,to_date('15-MAY-15','DD-MON-RR'),null,null,null,null,null);


Insert into transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,UDF_1,UDF_2,UDF_3,UDF_4,UDF_5,REPEATE_ADD,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,SITE_ACC_COL,CONFIRM_COL,CONFIRM_VAL,REPEAT_ADD_DET,REPEATADDDET,LOAD_MODE,AUTO_CONFIRM,LEDG_POST_CONF,CHG_DATE_ON_CONF,TRAN_ID_COL,MAIL_OPTION,CONFIRM_MODE,GARBAGE_OPT,VAL_FLAG_EDI,VERIFY_PASSWORD,CUST_ACC_COL,SALES_PERS_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_CODE,EMP_ACC_COL,ITEM_SER_ACC_COL,WORKFLOW_OPT,TABLE_NAME,APPLICATION,TABLE_DESC,TRAN_DATE_COL,TRAN_ID__FROM,TRAN_ID__TO,TABLE_NAME_DET1,TABLE_NAME_DET2,TABLE_NAME_DET3,MULTITIRE_OPT,REF_SER,VIEW_MODE,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CUSTOM_PREVIEW_OBJ,IGNOREERRLIST_ONLOAD,CHILDDATA_ARGOPT,EDIT_TMPLT,WRKFLW_INIT,EDITTAX,FORMAL_ARGS,AUDIT_TRAIL_OPT,EDIT_OPT,CACHE_OPT,OPTIMIZE_MODE,EDIT_EXPR,RATE_COL,QTY_COL,EDIT_EXPR_INP,RCP_CACHE_STATUS,PRINT_CONTROL,TRANSFER_MODE,PROFILE_ID__RES,TRAN_COMPL_MSG,PERIOD_OPTION,WRKFLW_PRIORITY,EXEC_TYPE,DISP_META_DATA,ALLOW_ATTACH,START_FORM,ISATTACHMENT,HEADER_FORM_NO,CONFIRM_DATE_COL,CONFIRM_BY_COL,MSG_ONSAVE,WF_STATUS,RESTART_FORM,CMS_PATH,BROW_DATA_DEF,DEF_VIEW,VIEW_OPTS) values ('w_multi_master_pick','A','2','A','seq10','Y',null,null,null,null,'N',to_date('15-MAY-15','DD-MON-RR'),'BASE      ','BASE           ','0',null,null,null,null,null,null,null,'Y','Y','TRAN_ID','0','0','N',null,null,null,null,null,null,null,null,null,'multi_pick_iss','WMS',null,null,null,null,null,null,null,null,'M-PTCN','F',null,null,null,null,null,'2',null,null,null,null,'0',null,null,null,null,null,null,null,null,null,null,null,null,'M',null,null,null,null,null,null,'1',null,null,null,null,null,null,null,null,null);


Insert into obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('multi_master_pick','2  ','ptcn',null);


Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_master_pick','default_data_wiz','1','mpick_iss_default_data',null,'0',to_date('15-MAY-15','DD-MON-RR'),'BASE      ','BASE','2','EJB','MultiplePtcnWiz',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_master_pick','post_item_change','1','poic_default_ejb',null,'0',to_date('15-MAY-15','DD-MON-RR'),'BASE      ','BASE','2','EJB','MultiplePtcnWiz',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_master_pick','post_save','1','pos_mpick_iss_scan',null,'0',to_date('15-MAY-15','DD-MON-RR'),'BASE      ','BASE','2','EJB','MultipleMasterPackWizPos',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_master_pick','pre_navigate_finish','1','pos_mpick_iss_finish',null,'0',to_date('15-MAY-15','DD-MON-RR'),'BASE      ','BASE','2','EJB','MultiplePtcnWizPos',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_master_pick','pre_navigate_next','1','prv_mpick_iss',null,'0',to_date('15-MAY-15','DD-MON-RR'),'BASE      ','BASE','2','EJB','MultiplePtcnWiz',null);
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) values ('multi_master_pick','pre_validate','1','prv_mpick_iss',null,'0',to_date('15-MAY-15','DD-MON-RR'),'BASE      ','BASE','2','EJB','MultiplePtcnWiz',null);


Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('pos_mpick_iss_scan','post save ','http://localhost:9090/axis/services/ValidatorService','BASE','postSave','String','S',null,null,to_date('08-MAY-15','DD-MON-RR'),'BASE      ','BASE');


Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_scan',1,'COMPONENT_TYPE','I',null,'S',null,to_date('08-MAY-15','DD-MON-RR'),'BASE      ','BASE','');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_scan',2,'COMPONENT_NAME','I',null,'S',null,to_date('08-MAY-15','DD-MON-RR'),'BASE      ','BASE','');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_scan',3,'XML_DATA_ALL','I',null,'S',null,to_date('08-MAY-15','DD-MON-RR'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_scan',4,'<tran_id>','I',null,'B.String',null,to_date('08-MAY-15','DD-MON-RR'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_scan',5,'EDIT_FLAG','I',null,'S',null,to_date('08-MAY-15','DD-MON-RR'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_scan',6,'XTRA_PARAMS','I',null,'S',null,to_date('08-MAY-15','DD-MON-RR'),'BASE      ','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) values ('pos_mpick_iss_scan',7,'DB_CONN','I',null,'S.Connection',null,to_date('08-MAY-15','DD-MON-RR'),'BASE      ','BASE',null);


Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) values ('VTCARNNSCN','Invalid Carton No','Master Carton No Can not be blank','E','Y',null,null,null,to_date('13-MAY-15','DD-MON-RR'),'BASE      ','BASE           ',null,null);
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) values ('VTCARNOINV','Invalid Carton No','Entered Carton No does not Exist with PTCN','E','Y',null,null,null,to_date('12-MAY-15','DD-MON-RR'),'BASE      ','BASE           ',null,null);

CREATE OR REPLACE function FN_WAVE_DESCRIPTION(VI_REF_SER IN CHAR,VI_REF_ID IN CHAR, VI_PTCN
IN VARCHAR)
RETURN VARCHAR2 IS TEMP_DESCR VARCHAR2(200);
CNT1 NUMBER;
--TEMP_DESCR VARCHAR2(200);
TEMP_HAZARDOUS CHAR;
TEMP_ITEM_CODE CHAR(10);
TEMP_REF_ID CHAR(10);
TEMP_CASE VARCHAR2(20);
TEMP_ACTIVE VARCHAR2(20);
TEMP_REF_SER CHAR(6);
ISTACKDONE  CHAR(1);

BEGIN

  BEGIN

  --ISTACKDONE := 'N';

  IF(VI_REF_SER = 'R-DSO') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'R-PND') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'S-DSP') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'R-CPA') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'R-TASK') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'RD-DSA') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'RN-DSA') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'RP-ACT') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'RP-PND') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'RP-PND') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'RR-DSA') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'RS-DSO') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'S-DOC') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'M-PACK') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'A-PACK') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'C-STG') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR; 

  ELSIF (VI_REF_SER = 'A-STG') THEN

    SELECT DESCR INTO TEMP_DESCR FROM REFSER WHERE REF_SER = VI_REF_SER ;

    RETURN TEMP_DESCR; 

  END IF;

    if( VI_REF_SER = 'C-PICK') then

        TEMP_HAZARDOUS := '';

        select wtd.ref_id,WTD.REF_SER, (CASE WHEN I.hazardous IS NULL THEN

'N' ELSE I.hazardous END) AS HAZ into TEMP_REF_ID,TEMP_REF_SER,

TEMP_HAZARDOUS

        from wave_task_det WTD, ITEM I , PICK_ORD_DET POD

        where WTD.ptcn= VI_PTCN and WTD.ref_ser ='C-PICK' and WTD.REF_ID =

VI_REF_ID

        AND WTD.REF_ID = POD.PICK_ORDER AND I.ITEM_CODE = POD.ITEM_CODE

AND ROWNUM = 1;

        IF (TEMP_REF_SER = 'C-PICK' AND TEMP_HAZARDOUS = 'Y' ) THEN

          TEMP_CASE := 'HAZ_CASE_CASE';

          ISTACKDONE := 'Y';

        ELSIF (TEMP_REF_SER = 'C-PICK' AND TEMP_HAZARDOUS = 'N' ) THEN

           TEMP_CASE := 'CASE_CASE';

           ISTACKDONE := 'Y';

        END IF;

    END IF;

    IF ( VI_REF_SER = 'M-PICK') then

       select wtd.ref_id,WTD.REF_SER, (CASE WHEN I.hazardous IS NULL THEN

'N' ELSE I.hazardous END) AS HAZ into TEMP_REF_ID,TEMP_REF_SER,

TEMP_HAZARDOUS

       from wave_task_det WTD, ITEM I , PICK_ORD_DET POD

       where WTD.ptcn= VI_PTCN and WTD.ref_ser ='M-PICK' and WTD.REF_ID  =

VI_REF_ID

       AND WTD.REF_ID = POD.PICK_ORDER AND I.ITEM_CODE = POD.ITEM_CODE AND

ROWNUM = 1;

       IF (TEMP_REF_SER = 'M-PICK' AND TEMP_HAZARDOUS = 'Y' ) THEN

         TEMP_CASE := 'HAZ_MASTER_CASE';

         --RETURN TEMP_CASE;

         ISTACKDONE := 'Y';

       ELSIF (TEMP_REF_SER = 'M-PICK' AND TEMP_HAZARDOUS = 'N' ) THEN

         TEMP_CASE := 'MASTER_CASE';

         ISTACKDONE := 'Y';

       END IF;

    ELSIF ( VI_REF_SER = 'P-PICK' ) then

       TEMP_HAZARDOUS := '';

       select wtd.ref_id,WTD.REF_SER, (CASE WHEN I.hazardous IS NULL THEN

'N' ELSE I.hazardous END) AS HAZ into TEMP_REF_ID,TEMP_REF_SER,

TEMP_HAZARDOUS

       from wave_task_det WTD, ITEM I , PICK_ORD_DET POD

       where WTD.ptcn= VI_PTCN and WTD.ref_ser ='P-PICK' and WTD.REF_ID  =

VI_REF_ID

       AND WTD.REF_ID = POD.PICK_ORDER AND I.ITEM_CODE = POD.ITEM_CODE AND

ROWNUM = 1;

       IF (TEMP_REF_SER = 'P-PICK' AND TEMP_HAZARDOUS = 'Y' ) THEN

         TEMP_CASE := 'HAZ_PARCEL_CASE';

         ISTACKDONE := 'Y';

       ELSIF (TEMP_REF_SER = 'P-PICK' AND TEMP_HAZARDOUS = 'N' ) THEN

         TEMP_CASE := 'PARCEL_CASE';

         ISTACKDONE := 'Y';

       END IF;

     ELSIF ( VI_REF_SER = 'A-PICK' ) then

        select count(*) as cont into CNT1 from wave_task_det WTD where

WTD.ptcn = VI_PTCN and WTD.ref_ser ='C-PICK';

       IF (CNT1 > 0 ) then

          TEMP_CASE := 'CASE_CASE';

      end if;

      select count(*) as cont into CNT1 from wave_task_det WTD where

WTD.ptcn = VI_PTCN and WTD.ref_ser ='M-PICK';

       IF (CNT1 > 0 ) then

          TEMP_CASE := 'MASTER_CASE';

      end if;

      select count(*) as cont into CNT1 from wave_task_det WTD where

WTD.ptcn = VI_PTCN and WTD.ref_ser ='P-PICK';

       IF (CNT1 > 0 ) then

          TEMP_CASE := 'PARCEL_CASE';

      end if;

      select count(*) as cont into CNT1 from wave_task_det

WTD,wave_status_org O where WTD.ptcn = VI_PTCN and o.ptcn = WTD.ptcn

 and WTD.ref_ser ='A-PICK';

      IF (CNT1 > 0 ) then

                TEMP_CASE := 'PARCEL_CASE';

        end if;

       select count(*) as cont into CNT1 from wave_task_det WTD where

WTD.ptcn = VI_PTCN and WTD.ref_ser ='M-PICK';

       IF (CNT1 > 0 ) then

          TEMP_CASE := 'MASTER_CASE';

      end if;

    end if;

  IF(VI_REF_SER = 'C-PICK' AND TEMP_CASE = 'HAZ_CASE_CASE' ) THEN

    SELECT DESCR INTO TEMP_DESCR FROM GENcodes WHERE FLD_NAME =

'HAZ_CASE_CASE' and MOD_NAME = 'WAVE_TASK' ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'C-PICK' AND TEMP_CASE = 'CASE_CASE' ) THEN

    SELECT DESCR INTO TEMP_DESCR FROM GENcodes WHERE FLD_NAME =

'CASE_CASE' and MOD_NAME = 'WAVE_TASK' ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'M-PICK' AND TEMP_CASE = 'HAZ_MASTER_CASE' ) THEN

---// for normal MASTER pick ------- start

    SELECT DESCR INTO TEMP_DESCR FROM GENcodes WHERE FLD_NAME =

'HAZ_MASTER_CASE' and MOD_NAME = 'WAVE_TASK' ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'M-PICK' AND TEMP_CASE = 'MASTER_CASE' ) THEN

    SELECT DESCR INTO TEMP_DESCR FROM GENcodes WHERE FLD_NAME =

'MASTER_CASE' and MOD_NAME = 'WAVE_TASK' ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'P-PICK' AND TEMP_CASE = 'HAZ_PARCEL_CASE' ) THEN

---// for normal MASTER pick ------- start

    SELECT DESCR INTO TEMP_DESCR FROM GENcodes WHERE FLD_NAME =

'HAZ_PARCEL_CASE' and MOD_NAME = 'WAVE_TASK' ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'P-PICK' AND TEMP_CASE = 'PARCEL_CASE' ) THEN

    SELECT DESCR INTO TEMP_DESCR FROM GENcodes WHERE FLD_NAME =

'PARCEL_CASE' and MOD_NAME = 'WAVE_TASK' ;

    RETURN TEMP_DESCR;

  ELSIF (VI_REF_SER = 'A-PICK') THEN

       IF ( (TEMP_CASE <> 'PARCEL_CASE' AND TEMP_CASE <> 'MASTER_CASE') or

TEMP_CASE is null ) THEN

           SELECT DESCR INTO TEMP_DESCR FROM GENcodes WHERE FLD_NAME =

'CASE_ACTIVE' and MOD_NAME = 'WAVE_TASK' ;

            RETURN TEMP_DESCR;

        ELSIF ( TEMP_CASE = 'MASTER_CASE') THEN

            SELECT DESCR INTO TEMP_DESCR FROM GENcodes WHERE FLD_NAME =

'MASTER_ACTIVE' and MOD_NAME = 'WAVE_TASK' ;

            RETURN TEMP_DESCR;

        ELSIF ( TEMP_CASE = 'PARCEL_CASE') THEN

           SELECT DESCR INTO TEMP_DESCR FROM GENcodes WHERE FLD_NAME =

'PARCEL_ACTIVE' and MOD_NAME = 'WAVE_TASK' ;

           RETURN TEMP_DESCR;

        END IF;

  END IF;

  EXCEPTION

  WHEN NO_DATA_FOUND  THEN

   TEMP_DESCR :='';

  END;

  RETURN TEMP_DESCR;

END;

------------Changed By Dadaso/Samadhan for multi ptcn and consolidated replenishment.end (12-JUN-15)---


