/*
 * Author:Wasim Ansari
 * Date:10-Mar-15
 * Request ID:D14JKAT004 (Delivery Date Ammendment)
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.POrderAmdConf;
import ibase.webitm.ejb.dis.POrderAmdConfRemote;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Properties;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class DDPorderWizAmdPosEJB extends ValidatorEJB implements DDPorderWizAmdPosEJBRemote, DDPorderWizAmdPosEJBLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private String tranId = "";
	
	
    public DDPorderWizAmdPosEJB()
    {
       
    }

	@Override
	public String postSave(String xmlStringAll, String dcrId, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		
		System.out.println("PostSave Action Called for Ammendment Wizard:::");
		
		try 
		{
			retString = generateAmmend(xmlStringAll, xtraParams, "", conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retString;
	}
	
		
	public String generateAmmend(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("In generate Ammendment");
		
		String retString = "";
		String retStr = "";
		boolean isError = false;
		String errString = "";
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;	
		
		String loginEmpCode = "";
		String userId = "";
		String loginSite = "";
		
		FinCommon finCommon = null;
		Document dom = null;
		
		String newdlvDate = "";
		String dlvDate = "";
		String dlvDateO = "";
	
		String itemCode = "";
		String suppCode = "";
		String purcOrder = "";
		
		String lineNo = "";
		String lineNoOrd = "";
		String siteCode = "";
		String siteCodeO = "";
		String indNo = "";
		String quantity = "";
		String quantityO = "";
		String unit = "";
		String rate = "";
		String rateO = "";
		String discount = ""; 
		String taxAmt = "";
		String totAmt = "";
		String locCode = "";
		//String reqDate = "";
		//String reqDateO = "";
		Timestamp reqDate = null;
		Timestamp reqDateO = null;
		String dlvQty = "";
		String taxChap = "";
		String taxClass = "";
		String taxEnv = "";
		String remarks = "";
		String workOrder = "";
		String unitRate = "";
		String conqStduom = "";
		String conrtStduom = "";
		String unitStd = "";
		String qtyStduom = ""; 
		String rateStduom = "";
		String packCode = "";
		String noArt = "";
		String packInstr = ""; 
		String acctCodedr = "";
		String cctrCodedr = "";
		String acctCodecr = "";
		String cctrCodecr = "";
		String acctCodedrO = "";
		String cctrCodedrO = "";
		String acctCodecrO = "";
		String cctrCodecrO = "";
		
		String disctType = "";
		String status = "";
		String empCodeQc = "";
		String empCodeQcO = "";
		String specificInstr = ""; 
		String specificInstrO = "";
		String suppCodeMnfr = "";
		String suppCodeMnfrO = "";
		String rateClg = "";
		String reason = "";
		String specialInstr = ""; 
		String specialInstrO = "";
		String benType = "";
		String benTypeO = "";
		String licNo = "";
		String licNoO= "";
		String formNO = "";
		String formNOold= "";
		String dutyPaid = "";
		String dutyPaidO = "";
		String deptCode = "";
		
		
		String amdDate = "";
		String amdType = "";
		String pordType = "";
		//String ordDate = "";
		Timestamp ordDate = null;
		String siteCodeDlv = "";
		String siteCodeDlvOld = "";
		String siteCodeOrd = "";
		String siteCodeOrdOld = "";
		String siteCodeBill = "";
		String siteCodeBillOld = "";
		
		String deptCodeO = "";
		String empCode = "";
		String empCodeO = "";
		String orderDb = "";
		String itemSer = "";
		String itemSerO = "";
		String taxOpt = "";
		String taxOptO = "";
		String crTerm = "";
		String crTermO = "";
		String ordAmt = "";
		String ordAmtO = "";
		
		String taxAmtO = "";
		String currCode = "";
		String currCodeO = "";
		String exchrate = "";
		String exchrateO = "";
		taxChap = "";
		String taxChapO = "";
		String taxClassO = "";
		String taxEnvO = "";
		
		String totAmtPorder = "";
		String totAmtPorderOld = "";
		
		//String taxDate= "";
		Timestamp taxDate = null;
		//String taxDateO = "";
		Timestamp taxDateO = null;
		String proCode= "";
		String proCodeO = "";
		String salesPers= "";
		String salesPersO = "";
		String commPerc= "";
		String commPercO = "";
		String commPercOn= "";
		String commPercOnO = "";
		String currCodeComm= "";
		String currCodeCommO = "";
		String quotNo= "";
		String quotNoOld = "";
		String tranCode= "";
		String tranCodeO = "";
		String frtAmt= "";
		String frtAmtO = "";
		String currCodeFrt= "";
		String currCodeFrtO = "";
		String frtTerm= "";
		String frtTermtO = "";
		String dlvTerm= "";
		String dlvTermO = "";
		String insAmt= "";
		String insAmtO = "";
		String currCodeIns= "";
		String currCodeInsO = "";
		String empCodeApr= "";
		String empCodeAprO = "";
		//String refDate= "";
		Timestamp refDate = null;
		//String refDateO = "";
		Timestamp refDateO = null;
		String confirmed = "";
		//String confDate = "";
		Timestamp confDate = null;
		String wflStatus = "";
		String parentTranId = "";
		String revTran = "";
		String insTerm = "";
		String suppCodeO = "";
		String analCode = "";
		String frtAmtQty = "";
		String frtAmtFix = "";
		String frtTypeO = "";
		String frtRateO = "";
		String frtAmtQtyO = "";
		String frtAmtFixO = "";
		String effFor = ""; 
		String lineNumber = "";
		String empCodeQcApr = "";
		String empCodeQcAprO = "";
		
		String ordSite = "";
		String id = "";
		String empcode = "";
		String fFlag = "";
		String prevPorder = "";
		String preAmdNo = "";
		
		ArrayList<String> amdArray = new ArrayList<String>();
		ArrayList<String> poMail = new ArrayList<String>();
		
		java.sql.Timestamp currDate = null;
		
		String amdNo = "";
		Timestamp today = new Timestamp(System.currentTimeMillis());
		MasterStatefulLocal masterStatefulLocal = null;
		int preline = 0;
		int lineamdDet = 0;
		
		try
		{
			//conn.setAutoCommit(false);
			
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			finCommon = new FinCommon();
			System.out.println("XTRA PARAMS ["+xtraParams+"]");
			System.out.println("Getting XML String ["+xmlstring+"]");
			
			dom = genericUtility.parseString(xmlstring);
			
			NodeList detail2NodeList = dom.getElementsByTagName("Detail2");
			int detail2NodeListlen = detail2NodeList.getLength();
			System.out.println("Total Length="+detail2NodeListlen);
			
			for(int ctrH = 0; ctrH < detail2NodeListlen ; ctrH++)
			{
				NodeList childNodeList = detail2NodeList.item(ctrH).getChildNodes();
				int detail2ListLen = childNodeList.getLength();
				
				for(int ctr = 0 ;ctr < detail2ListLen; ctr++)
				{
					Node childNode = childNodeList.item(ctr);
					
					if(childNode == null || childNode.getNodeType() != childNode.ELEMENT_NODE)
					{
						continue;
					}
					
					if(childNode != null && "dlv_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						dlvDate = childNode.getFirstChild().getNodeValue();
						newdlvDate = dlvDate;
						System.out.println("New Dlv Date="+dlvDate);
					}
					
					else if(childNode != null && "item_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						itemCode = childNode.getFirstChild().getNodeValue();
						System.out.println("Item Code="+itemCode);
					}
					
					else if(childNode != null && "supp_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						suppCode = childNode.getFirstChild().getNodeValue();
						System.out.println("Supplier Code="+suppCode);
					}
					
					else if(childNode != null && "purc_order".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						purcOrder = childNode.getFirstChild().getNodeValue();
						System.out.println("Purchase Order="+purcOrder);
					}
					
					else if(childNode != null && "site_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						loginSite = childNode.getFirstChild().getNodeValue();
						System.out.println("Site Code="+loginSite);
					}
					
					else if(childNode != null && "line_no".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						lineNumber = childNode.getFirstChild().getNodeValue();
						System.out.println("Line Number="+lineNumber);
					}
					
					else if(childNode != null && "emp_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						empcode = childNode.getFirstChild().getNodeValue();
						System.out.println("Emp Code="+empcode);
					}
					
					else if(childNode != null && "extra1".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						id = childNode.getFirstChild().getNodeValue();
						System.out.println("Login ID="+id);
					}
				
				 }
			//}//end for loop		
				
							lineamdDet = 0;
							
							currDate = new java.sql.Timestamp(System.currentTimeMillis());
							SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String date = sdf.format(currDate);
							
							System.out.println("Your Site Code="+loginSite);
							System.out.println("Todays Date="+date);
							
							//amdNo = generateTranId("w_porderamd", loginSite, date , conn);
							//System.out.println("Your Amd Number is="+amdNo);
							
						if(!(purcOrder.equals(prevPorder)))
						{	
							preline = lineamdDet+1;
							System.out.println("Poamd Line Number="+preline);
							
							amdNo = generateTranId("w_porderamd", loginSite, date , conn);
							System.out.println("Your New Amd Number is="+amdNo);
							
							amdArray.add(amdNo);
							
							sql = "select * from porder where purc_order = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,purcOrder);
							rs = pstmt.executeQuery();
							
							while (rs.next())
							{
								//amdDate = "16-FEB-15";
								purcOrder = checkNullAndTrim(rs.getString("purc_order"));
								ordDate = rs.getTimestamp("ord_date");
								pordType = checkNullAndTrim(rs.getString("pord_type"));
								suppCode = checkNullAndTrim(rs.getString("supp_code"));
								siteCodeDlv = checkNullAndTrim(rs.getString("site_code__dlv"));
								siteCodeDlvOld = siteCodeDlv;
								siteCodeOrd = checkNullAndTrim(rs.getString("site_code__ord"));
								siteCodeOrdOld = siteCodeOrd;
								siteCodeBill = checkNullAndTrim(rs.getString("site_code__bill"));
								siteCodeBillOld = siteCodeBill;
								deptCode = checkNullAndTrim(rs.getString("dept_code"));
								deptCodeO = deptCode;
								empCode = checkNullAndTrim(rs.getString("emp_code"));
								empCodeO = empCode;
								orderDb = checkNullAndTrim(rs.getString("order_db"));
								itemSer = checkNullAndTrim(rs.getString("item_ser"));
								itemSerO = itemSer;
								taxOpt = checkNullAndTrim(rs.getString("tax_opt"));
								taxOptO = taxOpt;
								crTerm = checkNullAndTrim(rs.getString("cr_term"));
								crTermO = crTerm;
								ordAmt = checkNullAndTrim(rs.getString("ord_amt"));
								ordAmtO = ordAmt;
								taxAmt = checkNullAndTrim(rs.getString("tax_amt"));
								taxAmtO = taxAmt;
								
								totAmtPorder = checkNullAndTrim(rs.getString("tot_amt"));
								totAmtPorderOld = totAmtPorder;
								
								currCode = checkNullAndTrim(rs.getString("curr_code"));
								currCodeO = currCode;
								exchrate = checkNullAndTrim(rs.getString("exch_rate"));
								exchrateO = exchrate;
								taxChap = checkNullAndTrim(rs.getString("tax_chap"));
								taxChapO = taxChap;
								taxClass= checkNullAndTrim(rs.getString("tax_class"));
								taxClassO = taxClass;
								taxEnv= checkNullAndTrim(rs.getString("tax_env"));
								taxEnvO = taxEnv;
								remarks = checkNullAndTrim(rs.getString("remarks"));
								taxDate= rs.getTimestamp("tax_date");
								taxDateO = taxDate;
								proCode= checkNullAndTrim(rs.getString("proj_code"));
								proCodeO = proCode;
								salesPers= checkNullAndTrim(rs.getString("sales_pers"));
								salesPersO = salesPers;
								commPerc= checkNullAndTrim(rs.getString("comm_perc"));
								commPercO = commPerc;
								commPercOn= checkNullAndTrim(rs.getString("comm_perc__on"));
								commPercOnO = commPercOn;
								currCodeComm= checkNullAndTrim(rs.getString("curr_code__comm"));
								currCodeCommO = currCodeComm;
								quotNo= checkNullAndTrim(rs.getString("quot_no"));
								quotNoOld = quotNo;
								tranCode= checkNullAndTrim(rs.getString("tran_code"));
								tranCodeO = tranCode;
								frtAmt= checkNullAndTrim(rs.getString("frt_amt"));
								frtAmtO = frtAmt;
								currCodeFrt= checkNullAndTrim(rs.getString("curr_code__frt"));
								currCodeFrtO = currCodeFrt;
								frtTerm= checkNullAndTrim(rs.getString("frt_term"));
								frtTermtO = frtTerm;
								dlvTerm= checkNullAndTrim(rs.getString("dlv_term"));
								dlvTermO = dlvTerm;
								insAmt= checkNullAndTrim(rs.getString("insurance_amt"));
								insAmtO = insAmt;
								currCodeIns= checkNullAndTrim(rs.getString("curr_code__ins"));
								currCodeInsO = currCodeIns;
								empCodeApr= checkNullAndTrim(rs.getString("emp_code__aprv"));
								empCodeAprO = empCodeApr;
								refDate= rs.getTimestamp("ref_date");
								refDateO = refDate;
								confirmed = checkNullAndTrim(rs.getString("confirmed"));
								confDate = rs.getTimestamp("conf_date");
								status = checkNullAndTrim(rs.getString("status"));
								wflStatus = checkNullAndTrim(rs.getString("workflow_status"));
								parentTranId = checkNullAndTrim(rs.getString("parent__tran_id"));
								revTran = checkNullAndTrim(rs.getString("rev__tran"));
								insTerm = checkNullAndTrim(rs.getString("ins_term"));
								suppCodeO = suppCode;
								analCode = checkNullAndTrim(rs.getString("anal_code"));
								frtAmtQty = checkNullAndTrim(rs.getString("frt_amt__qty"));
								frtAmtFix = checkNullAndTrim(rs.getString("frt_amt__fixed"));
								frtTypeO = checkNullAndTrim(rs.getString("frt_type"));
								frtRateO = checkNullAndTrim(rs.getString("frt_rate"));
								frtAmtQtyO = checkNullAndTrim(rs.getString("frt_amt__qty"));
								frtAmtFixO = checkNullAndTrim(rs.getString("frt_amt__fixed"));
							}
							
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							
							
							sql = "insert into poamd_hdr (amd_no,amd_date,amd_type,purc_order,ord_date,pord_type,supp_code,site_code__dlv,site_code__dlv__o,"
									+ "site_code__ord,site_code__ord__o,site_code__bill,site_code__bill__o,dept_code,dept_code__o,emp_code,emp_code__o,"
									+ "order_db,item_ser,item_ser__o,tax_opt,tax_opt__o,cr_term,cr_term__o,"
									+ "ord_amt,ord_amt__o,tax_amt,tax_amt__o,"
									+ "tot_amt,tot_amt__o,"
									+ "curr_code,curr_code__o,exch_rate,exch_rate__o,tax_chap,tax_chap__o,tax_class,tax_class__o,tax_env,tax_env__o,"
									+ "remarks,tax_date,tax_date__o,proj_code,proj_code__o,sales_pers,sales_pers__o,comm_perc,comm_perc__o,"
									+ "comm_perc__on,comm_perc__on__o,quot_no,quot_no__o,tran_code,tran_code__o,frt_amt,frt_amt__o,dlv_term,dlv_term__o,"
									+ "insurance_amt,insurance_amt__o,curr_code__ins,curr_code__ins__o,emp_code__aprv,emp_code__aprv__o,ref_date,ref_date__o,"
									+ "confirmed,conf_date,chg_date,status,workflow_status,parent__tran_id,rev__tran,ins_term,supp_code__o,anal_code,frt_amt__qty,"
									+ "frt_amt__fixed,frt_type__o,frt_rate__o,frt_amt__qty__o,frt_amt__fixed__o,effective_for )"
									+ " values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,"
									+ "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ) ";
							
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, amdNo);
							pstmt.setTimestamp(2, today);
							pstmt.setString(3, amdType);
							pstmt.setString(4, purcOrder);
							//pstmt.setString(5, ordDate);
							pstmt.setTimestamp(5, ordDate);
							pstmt.setString(6, pordType);
							pstmt.setString(7, suppCode);
						   //pstmt.setString(8, siteCode);
							pstmt.setString(8, siteCodeDlv);
							pstmt.setString(9, siteCodeDlvOld);
							pstmt.setString(10, siteCodeOrd);
							pstmt.setString(11, siteCodeOrdOld);
							pstmt.setString(12, siteCodeBill);
							pstmt.setString(13, siteCodeBillOld);
							pstmt.setString(14, deptCode);
							pstmt.setString(15, deptCodeO);
							pstmt.setString(16, empCode);
							pstmt.setString(17, empCodeO);
							pstmt.setString(18, orderDb);
							pstmt.setString(19, itemSer);
							pstmt.setString(20, itemSerO);
							pstmt.setString(21, taxOpt);
							pstmt.setString(22, taxOptO);
							pstmt.setString(23, crTerm);
							pstmt.setString(24, crTermO);
							pstmt.setString(25, ordAmt);
							pstmt.setString(26, ordAmtO);
							pstmt.setString(27, taxAmt);
							pstmt.setString(28, taxAmtO);
							
							pstmt.setString(29, totAmtPorder);
							pstmt.setString(30, totAmtPorderOld);
							
							pstmt.setString(31, currCode);
							pstmt.setString(32, currCodeO);
							pstmt.setString(33, exchrate);
							pstmt.setString(34, exchrateO);
							pstmt.setString(35, taxChap);
							pstmt.setString(36, taxChapO);
							pstmt.setString(37, taxClass);
							pstmt.setString(38, taxClassO);
							pstmt.setString(39, taxEnv);
							pstmt.setString(40, taxEnvO);
							pstmt.setString(41, remarks);
							//pstmt.setString(40, taxDate);
							pstmt.setTimestamp(42, taxDate);
							//pstmt.setString(41, taxDateO);
							pstmt.setTimestamp(43, taxDateO);
							pstmt.setString(44, proCode);
							pstmt.setString(45, proCodeO);
							pstmt.setString(46, salesPers);
							pstmt.setString(47, salesPersO);
							pstmt.setString(48, commPerc);
							pstmt.setString(49, commPercO);
							pstmt.setString(50, commPercOn);
							pstmt.setString(51, commPercOnO);
							pstmt.setString(52, quotNo);
							pstmt.setString(53, quotNoOld);
							pstmt.setString(54, tranCode);
							pstmt.setString(55, tranCodeO);
							pstmt.setString(56, frtAmt);
							pstmt.setString(57, frtAmtO);
							pstmt.setString(58, dlvTerm);
							pstmt.setString(59, dlvTermO);
							pstmt.setString(60, insAmt);
							pstmt.setString(61, insAmtO);
							pstmt.setString(62, currCodeIns);
							pstmt.setString(63, currCodeInsO);
							pstmt.setString(64, empCodeApr);
							pstmt.setString(65, empCodeAprO);
							//pstmt.setString(64, refDate);
							pstmt.setTimestamp(66, refDate);
							//pstmt.setString(65, refDateO);
							pstmt.setTimestamp(67, refDateO);
							confirmed = "N";
							pstmt.setString(68, confirmed);
							//pstmt.setString(67, confDate);
							pstmt.setTimestamp(69, confDate);
							pstmt.setTimestamp(70, today);
							pstmt.setString(71, status);
							pstmt.setString(72, wflStatus);
							pstmt.setString(73, parentTranId);
							pstmt.setString(74, revTran);
							pstmt.setString(75, insTerm);
							pstmt.setString(76, suppCodeO);
							pstmt.setString(77, analCode);
							pstmt.setString(78, frtAmtQty);
							pstmt.setString(79, frtAmtFix);
							pstmt.setString(80, frtTypeO);
							pstmt.setString(81, frtRateO);
							pstmt.setString(82, frtAmtQtyO);
							pstmt.setString(83, frtAmtFixO);
							pstmt.setString(84, effFor);
							
							pstmt.executeUpdate();
							
							pstmt.close(); pstmt = null;
							
						System.out.println("Record inserted successfully in header....");
						
					}//end for line wise item header insert single.	
					else
					{
						System.out.println("Hello your previous amd number="+amdNo);
						preline++;
					}
						
						lineNumber = "   "+lineNumber;
						lineNumber = lineNumber.substring(lineNumber.length()-3);
						System.out.println("New Line Number="+lineNumber);
						
						sql = "select * from porddet where purc_order = ? and line_no = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,purcOrder);
						pstmt.setString(2,lineNumber);
						rs = pstmt.executeQuery();
						
						Timestamp detdlvDate = null;
						
						
						if(rs.next())
						{
							lineNo = checkNullAndTrim(rs.getString("line_no"));
							siteCode = checkNullAndTrim(rs.getString("site_code"));
							siteCodeO = siteCode;
							indNo = checkNullAndTrim(rs.getString("ind_no"));
							itemCode = checkNullAndTrim(rs.getString("item_code"));
							quantity = checkNullAndTrim(rs.getString("quantity"));
							quantityO = quantity;
							unit = checkNullAndTrim(rs.getString("unit"));
							rate = checkNullAndTrim(rs.getString("rate"));
							rateO = rate;
							discount = checkNullAndTrim(rs.getString("discount"));
							taxAmt = checkNullAndTrim(rs.getString("tax_amt"));
							totAmt = checkNullAndTrim(rs.getString("tot_amt"));
							locCode = checkNullAndTrim(rs.getString("loc_code"));
							reqDate = rs.getTimestamp("req_date");
							reqDateO = reqDate;
							//dlvDate = checkNullAndTrim(rs.getString("dlv_date"));
							detdlvDate = rs.getTimestamp("dlv_date");
							dlvQty = checkNullAndTrim(rs.getString("dlv_qty"));
							taxChap = checkNullAndTrim(rs.getString("tax_chap"));
							taxClass = checkNullAndTrim(rs.getString("tax_class"));
							taxEnv = checkNullAndTrim(rs.getString("tax_env"));
							remarks = checkNullAndTrim(rs.getString("remarks"));
							workOrder = checkNullAndTrim(rs.getString("work_order"));
							unitRate = checkNullAndTrim(rs.getString("unit__rate"));
							conqStduom = checkNullAndTrim(rs.getString("conv__qty_stduom"));
							conrtStduom = checkNullAndTrim(rs.getString("conv__rtuom_stduom"));
							unitStd = checkNullAndTrim(rs.getString("unit__std"));
							qtyStduom = checkNullAndTrim(rs.getString("quantity__stduom"));
							rateStduom = checkNullAndTrim(rs.getString("rate__stduom"));
							packCode = checkNullAndTrim(rs.getString("pack_code"));
							noArt = checkNullAndTrim(rs.getString("no_art"));
							packInstr = checkNullAndTrim(rs.getString("pack_instr"));
							acctCodedr = checkNullAndTrim(rs.getString("acct_code__dr"));
							cctrCodedr = checkNullAndTrim(rs.getString("cctr_code__dr"));
							acctCodecr = checkNullAndTrim(rs.getString("acct_code__cr"));
							cctrCodecr = checkNullAndTrim(rs.getString("cctr_code__cr"));
							disctType = checkNullAndTrim(rs.getString("discount_type"));
							status = checkNullAndTrim(rs.getString("status"));
							taxClassO = taxClass;
							taxChapO = taxChap;
							taxEnvO = taxEnv;
							//empCodeQc = checkNullAndTrim(rs.getString("emp_code__qcaprv"));
							//empCodeQcO = empCodeQc;
							empCodeQcApr = checkNullAndTrim(rs.getString("emp_code__qcaprv"));
							empCodeQcAprO = empCodeQcApr;
							dlvDateO = dlvDate;
							specificInstr = checkNullAndTrim(rs.getString("specific_instr"));
							specificInstrO = specificInstr;
							suppCodeMnfr = checkNullAndTrim(rs.getString("supp_code__mnfr"));
							suppCodeMnfrO = suppCodeMnfr;
							rateClg = checkNullAndTrim(rs.getString("rate__clg"));
							specialInstr = checkNullAndTrim(rs.getString("special_instr"));
							specialInstrO = specialInstr;
							benType = checkNullAndTrim(rs.getString("benefit_type"));
							benTypeO = benType;
							licNo = checkNullAndTrim(rs.getString("licence_no"));
							licNoO = licNo;
							formNO = checkNullAndTrim(rs.getString("form_no"));
							formNOold = formNO;
							dutyPaid = checkNullAndTrim(rs.getString("duty_paid"));
							dutyPaidO = dutyPaid;
							acctCodedrO = acctCodedr;
							cctrCodedrO = cctrCodedr;
							acctCodecrO = acctCodecr;
							cctrCodecrO = cctrCodecr;
							deptCode = checkNullAndTrim(rs.getString("dept_code"));
						}
						
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						
						sql ="insert into poamd_det (amd_no,line_no,purc_order,line_no__ord,site_code,ind_no,item_code,quantity,quantity__o,"
								+ "unit,rate,rate__o,discount,tax_amt,tot_amt,loc_code,req_date,req_date__o,dlv_date,dlv_qty,tax_class,tax_chap,"
								+ "tax_env,remarks,work_order,unit__rate,conv__qty_stduom,conv__rtuom_stduom,unit__std,quantity__stduom,"
								+ "rate__stduom,pack_code,no_art,pack_instr,acct_code__dr,cctr_code__dr,acct_code__cr,cctr_code__cr,discount_type,"
								+ "status,tax_class__o,tax_chap__o,tax_env__o,emp_code__qcaprv,emp_code__qcaprv__o,dlv_date__o,specific_instr,"
								+ "specific_instr__o,supp_code_mnfr,supp_code_mnfr__o,rate__clg,special_instr,special_instr__o,"
								+ "benefit_type,benefit_type__o,licence_no,licence_no__o,form_no,form_no__o,duty_paid,duty_paid__o,"
								+ "acct_code__dr__o,cctr_code__dr__o,acct_code__cr__o,cctr_code__cr__o,dept_code )"
								+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,"
								+ "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
						
						pstmt = conn.prepareStatement(sql);

						pstmt.setString(1, amdNo);
						//pstmt.setString(2, lineNo);
						pstmt.setInt(2, preline);
						pstmt.setString(3, purcOrder);
					  //pstmt.setString(4, lineNoOrd);
						lineNoOrd = "   "+lineNo;
						lineNoOrd = lineNoOrd.substring(lineNoOrd.length()-3);
						pstmt.setString(4, lineNoOrd);
						pstmt.setString(5, siteCode);
						pstmt.setString(6, indNo);
						pstmt.setString(7, itemCode);
						pstmt.setString(8, quantity);
						pstmt.setString(9, quantityO);
						pstmt.setString(10, unit);
						pstmt.setString(11, rate);
						pstmt.setString(12, rateO);
						pstmt.setString(13, discount);
						pstmt.setString(14, taxAmt);
						pstmt.setString(15, totAmt);
						pstmt.setString(16, locCode);
						pstmt.setTimestamp(17, reqDate);
						pstmt.setTimestamp(18, reqDateO);
						
						System.out.println("Date is="+newdlvDate);
						newdlvDate = genericUtility.getValidDateString( newdlvDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateTimeFormat());
						System.out.println("After Date is="+newdlvDate);
						
						pstmt.setTimestamp(19, Timestamp.valueOf(newdlvDate));
						
						pstmt.setString(20, dlvQty);
						pstmt.setString(21, taxClass);
						pstmt.setString(22, taxChap);
						pstmt.setString(23, taxEnv);
						pstmt.setString(24, remarks);
						pstmt.setString(25, workOrder);
						pstmt.setString(26, unitRate);
						pstmt.setString(27, conqStduom);
						pstmt.setString(28, conrtStduom);
						pstmt.setString(29, unitStd);
						pstmt.setString(30, qtyStduom);
						pstmt.setString(31, rateStduom);
						pstmt.setString(32, packCode);
						pstmt.setString(33, noArt);
						pstmt.setString(34, packInstr);
						pstmt.setString(35, acctCodedr);
						pstmt.setString(36, cctrCodedr);
						pstmt.setString(37, acctCodecr);
						pstmt.setString(38, cctrCodecr);
						pstmt.setString(39, disctType);
						pstmt.setString(40, status);
						pstmt.setString(41, taxClassO);
						pstmt.setString(42, taxChapO);
						pstmt.setString(43, taxEnvO);
						//pstmt.setString(44, empCodeApr);
						//pstmt.setString(45, empCodeAprO);
						pstmt.setString(44, empCodeQcApr);
						pstmt.setString(45, empCodeQcAprO);
						//pstmt.setString(46, dlvDateO);
						pstmt.setTimestamp(46, detdlvDate);
						pstmt.setString(47, specialInstr);
						pstmt.setString(48, specialInstrO);
						pstmt.setString(49, suppCodeMnfr);
						pstmt.setString(50, suppCodeMnfrO);
						pstmt.setString(51, rateClg);
						pstmt.setString(52, specialInstr);
						pstmt.setString(53, specialInstrO);
						pstmt.setString(54, benType);
						pstmt.setString(55, benTypeO);
						pstmt.setString(56, licNo);
						pstmt.setString(57, licNoO);
						pstmt.setString(58, formNO);
						pstmt.setString(59, formNOold);
						pstmt.setString(60, dutyPaid);
						pstmt.setString(61, dutyPaidO);
						pstmt.setString(62, acctCodedrO);
						pstmt.setString(63, cctrCodedrO);
						pstmt.setString(64, acctCodecrO);
						pstmt.setString(65, cctrCodecrO);
						pstmt.setString(66, deptCode);
					
						pstmt.executeUpdate();
						
						pstmt.close(); pstmt = null;
						//conn.commit();
						System.out.println("Record inserted successfully in detail ....");
						
						/*************************************************************************/
						
				            /*if(xtraParams != null)
				            {
				            	xtraParams = getXtraParams(id,loginSite,empcode,conn);
				            }
				            System.out.println("XTRA params is="+xtraParams);
				            
				            POrderAmdConfRemote poamdConf = null;
				            InitialContext contxt = new InitialContext( new AppConnectParm().getProperty() );
							poamdConf = (ibase.webitm.ejb.dis.POrderAmdConfRemote) contxt.lookup("ibase/POrderAmdConf/remote");
							String retStr = poamdConf.confirm(amdNo, xtraParams, fFlag);
				         
				            System.out.println("Return String="+retStr);*/
								
								/*if(xtraParams != null)
					            {
					            	xtraParams = getXtraParams(id,loginSite,empcode,conn);
					            }
					            System.out.println("XTRA params is="+xtraParams);
					            
					            POrderAmdConfRemote poamdConf = null;
					            InitialContext contxt = new InitialContext( new AppConnectParm().getProperty() );
								poamdConf = (ibase.webitm.ejb.dis.POrderAmdConfRemote) contxt.lookup("ibase/POrderAmdConf/remote");
								
								String retStr = poamdConf.confirm(amdNo, xtraParams, fFlag);
								System.out.println("Return String="+retStr);*/
								
								
				        /*************************************************************************/
				            prevPorder = purcOrder;	
				            System.out.println("Your Prevoius Purchase Order="+prevPorder);
				         
			}//end for loop	
			
			
				if(xtraParams != null)
	            {
	            	xtraParams = getXtraParams(id,loginSite,empcode,conn);
	            }
	            System.out.println("XTRA params is="+xtraParams);
	            
	            /*POrderAmdConfRemote poamdConf = null;
	            InitialContext contxt = new InitialContext( new AppConnectParm().getProperty() );
				poamdConf = (ibase.webitm.ejb.dis.POrderAmdConfRemote) contxt.lookup("ibase/POrderAmdConf/remote");*/
				
				int errorCnt = 0; 
				String po = "";
				String ln = "";
				
				System.out.println("Total Ammendment Numbers: " + amdArray);
				Iterator<String> itr = amdArray.iterator();
				
				  while(itr.hasNext())
				  {  
					 /* if(errorCnt > 0)
					  {
						  isError = true;
						  //return retStr;
						  break;
					  }
					  else
					  {	 */
						  String amd = itr.next();
						  System.out.println("Amd No for Confirm="+amd); 
						  
						  /****************************/
						   Double pretotAmt = 0.0;
						   Double pretaxAmt = 0.0;
						   Double hdrTax;
						   Double hdrTot;
						   sql = " select tax_amt,tot_amt from poamd_det where amd_no = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, amd);
							rs = pstmt.executeQuery();
							while( rs.next() )
							{
								hdrTot = Double.parseDouble(checkNullAndTrim(rs.getString("tot_amt")));
								hdrTax = Double.parseDouble(checkNullAndTrim(rs.getString("tax_amt")));
								System.out.println("Total tax="+hdrTax);
								System.out.println("Total Amt="+hdrTot);
								
								pretotAmt = pretotAmt + hdrTot;
								pretaxAmt = pretaxAmt + hdrTax;
							}
							System.out.println("Final Total tax="+pretaxAmt);
							System.out.println("Final Total Amt="+pretotAmt);
							rs.close();rs = null;
							pstmt.close();pstmt = null;
							
							
							sql = " update poamd_hdr set tot_amt = ?,tax_amt = ? where amd_no = ?  ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setDouble(1, pretotAmt);
							pstmt.setDouble(2, pretaxAmt);
							pstmt.setString(3, amd);
							pstmt.executeUpdate();
							pstmt.close();pstmt = null;
							System.out.println("Updated Successfully");
						  
						  /****************************/
						 /////////////////////////////// 
						  sql = " select purc_order,line_no from poamd_det where amd_no = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, amd);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								 po = rs.getString("purc_order");
								 ln = rs.getString("line_no");
								System.out.println("Purchase Order="+po);
								System.out.println("Line No="+ln);
							}
							rs.close();rs = null;
							pstmt.close();pstmt = null;
						////////////////////////////////	
						  
						  System.out.println("isError in while ="+isError); 
						    //retStr = poamdConf.confirm(amd, xtraParams, fFlag);
						    retStr = confirm(amd, xtraParams, fFlag,conn);
						  
							System.out.println("Return String="+retStr);
							if (retStr != null && retStr.indexOf("PRCUSUCCES")>0)
							{
								System.out.println("isError in while if="+isError); 
								errorCnt++;
								System.out.println("Purchase Order Ammendment Report="+po);
								poMail.add(po);
								//DDPorderReportSendMail mail = new DDPorderReportSendMail();
								//mail.actionHandler(po, xtraParams, forcedFlag);
								continue;
							}
							else
							{
								System.out.println("isError in while else ="+isError); 
								isError = true;
								System.out.println("Error is in following record");
								System.out.println("Purchase Order="+po);
								System.out.println("Line No="+ln);
								
								/*dom = genericUtility.parseString(retStr);
								System.out.println("DOM="+dom);
								
								NodeList tracing = dom.getElementsByTagName("trace");
								
								Node ff = tracing.item(0);
								String val = ff.getFirstChild().getNodeValue();
								System.out.println("Previous trace="+val);
								
								ff.getFirstChild().setNodeValue("Purchase Order="+po);
								System.out.println("Trace value="+ff.getFirstChild().getNodeValue());
								
								retStr = genericUtility.serializeDom(dom);
								
								System.out.println("Final Error String="+retStr);*/
								
								//return retStr;
								break;
							}
					  }	
				  //} 
				
			
		}
		
		catch(Exception e)
		{
			isError = true;
			errString = "ERROR";
			try
			{
				conn.rollback();
				retString = retStr;
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		finally
		{
			System.out.println("is Error in finally="+isError);
			try
			{
				if(isError)
				{
					System.out.println("Closing error");
					conn.rollback();
					retString = retStr;
				}
				else
				{
					System.out.println("Transaction Committed in finally");
					conn.commit();
					DDPorderReportSendMail mail = new DDPorderReportSendMail();
					for (int i = 0; i < poMail.size(); i++) 
					{
						mail.actionHandler(poMail.get(i), xtraParams, forcedFlag);
			            System.out.println("Purchase Order Mailed="+poMail.get(i));
			        }
					
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("errString from generatePorder =["+errString+"]");
		return retString;			
                
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn )throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";

		java.sql.Date effDate = null;

		try
		{
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			//System.out.println("selSql :"+selSql);
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<site_code__ord__o>" + siteCode + "</site_code__ord__o>";
			xmlValues = xmlValues +		"<amd_date>" + tranDateStr + "</amd_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);

		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		return tranId;
	}//generateTranTd()
	
	public String getXtraParams( String loginCode, String siteCode,String empCode,Connection  conn)throws Exception
	{
		String remotehost = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";
		String userLang = "";
		String userCountry = "";	
		StringBuffer xtraParamsBuff = new StringBuffer();
		
		String sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
			
		
		try
		{
				sql = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,LOGGER_TYPE,USER_LANG,"+
					  "USER_COUNTRY,TRANS_DB, USER_THEME FROM USERS WHERE CODE = ? ";
				pstmt = conn.prepareStatement(sql);			
				pstmt.setString(1,loginCode);			
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					entityCode = rs.getString("ENTITY_CODE");
					profileId  = rs.getString("PROFILE_ID");
					userType   = rs.getString("USER_TYPE");
					userLang   = rs.getString("USER_LANG");
					userCountry= rs.getString("USER_COUNTRY");
				}			
				
				remotehost =  InetAddress.getLocalHost().getHostAddress();
				String XTRA_PARAMS_SEPARATOR = "~~";
				
				xtraParamsBuff.append("loginCode=" + loginCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + empCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + siteCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + entityCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + profileId);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userType);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userLang);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userCountry);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + CommonConstants.ENCODING);
				
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+remotehost);
		
				String chgTerm = remotehost;
				if( chgTerm != null && chgTerm.length() > 15 )
				{
					chgTerm = chgTerm.substring(0, 15);
				}
				else if( chgTerm == null || chgTerm.length() == 0 )
				{
					chgTerm = remotehost;
				}
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm );
				
				System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");
				
				
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return xtraParamsBuff.toString();
	}
	
	public String getUserInfo( String xtraParams )throws ITMException
	{
		StringBuffer userInfoStr = new StringBuffer();
		String userId = "";
		String loginEmpCode = "";
		String loginSiteCode = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";
		
		String chgTerm = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId");
			userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userType");
			
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			
			System.out.println("xtraParams  is @@@@@ " + xtraParams);

			userInfoStr.append("<UserInfo>");
			userInfoStr.append("<loginCode>").append("<![CDATA["+userId+"]]>").append("</loginCode>\r\n");
			userInfoStr.append("<empCode>").append("<![CDATA["+loginEmpCode+"]]>").append("</empCode>\r\n");
			userInfoStr.append("<siteCode>").append("<![CDATA["+loginSiteCode+"]]>").append("</siteCode>\r\n");
			userInfoStr.append("<entityCode>").append("<![CDATA["+entityCode+"]]>").append("</entityCode>\r\n");
			userInfoStr.append("<profileId>").append("<![CDATA["+profileId+"]]>").append("</profileId>\r\n");
			userInfoStr.append("<userType>").append("<![CDATA["+userType+"]]>").append("</userType>\r\n");
			
			userInfoStr.append("<remoteHost>").append("<![CDATA["+chgTerm+"]]>").append("</remoteHost>\r\n");
			userInfoStr.append("</UserInfo>");
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return userInfoStr.toString();
	}
	
	/****************Confirm Component*********************/
	public String confirm(String tranId, String xtraParams, String forcedFlag,Connection conn) throws RemoteException, ITMException
	{
		System.out.println("This is my POrderAmdConf confirm called..............");
		String confirmed = "";
		String sql = "";
		// String sql1 = "";
		// int status = 0;
		// double frtAmt = 0.0;
		// Date lrDate = null;
		//Connection conn = null;
		PreparedStatement pstmt = null;
		// PreparedStatement pstmt1 = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		String errString = null, errCode = "";
		ResultSet rs = null;
		// ResultSet rs1 = null;
		String purcOrder = "", poStatus = "", amdNo = "", workflowStatus = "";
		int recCnt = 0, cnt = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try
		{
			itmDBAccessEJB = new ITMDBAccessEJB();
			//ConnDriver connDriver = null;
			//connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			
			if (errString == null || errString.trim().length() == 0)
			{
				amdNo = tranId;
				if (tranId != null && tranId.trim().length() > 0)
				{
					purcOrder = setDescription("purc_order", "poamd_hdr", "amd_no", tranId, conn);

					if (purcOrder != null && purcOrder.trim().length() > 0)
					{
						poStatus = setDescription("status", "porder", "purc_order", purcOrder, conn);

						if ("C".equalsIgnoreCase(poStatus) || "X".equalsIgnoreCase(poStatus))
						{
							errString = "VTPOCX";
							//errString = itmDBAccessLocal.getErrorString("", errString, "");WERROR
							errString = getError(purcOrder, "" , errString, conn);
							return errString;
						}

						sql = "	select confirmed, (case when workflow_status is null then '0' else workflow_status end) " +
						" from   poamd_hdr where amd_no = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, amdNo);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							recCnt++;
							confirmed = rs.getString(1);
							workflowStatus = rs.getString(2);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if (recCnt == 0)
						{
							errString = "VTMCONF20";
							//errString = itmDBAccessLocal.getErrorString("", errString, "");WERROR
							errString = getError(purcOrder, "" , errString, conn);
							return errString;

						} else if ("Y".equalsIgnoreCase(confirmed))
						{
							errString = "VTPACONF1";
							//errString = itmDBAccessLocal.getErrorString("", errString, "");WERROR
							errString = getError(purcOrder, "" , errString, conn);
							return errString;
						}

						sql = " select count(1) from poamd_det where amd_no = ? and purc_order <> ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, amdNo);
						pstmt.setString(2, purcOrder);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("@@@@@@@@111 cnt[" + cnt + "]");
						if (cnt > 0)
						{
							errString = "VTPOHRDT";
							//errString = itmDBAccessLocal.getErrorString("", errString, "");EEE
							errString = getError(purcOrder, "" , errString, conn);
							return errString;
						}

						sql = " select count(1) from   poamd_term where amd_no = ? and purc_order <> ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, amdNo);
						pstmt.setString(2, purcOrder);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("@@@@@@@@222 cnt[" + cnt + "]");
						if (cnt > 0)
						{
							errString = "VTPOHRDT";
							//errString = itmDBAccessLocal.getErrorString("", errString, "");EEE
							errString = getError(purcOrder, "" , errString, conn);
							return errString;
						}

						if (errString == null || errString.trim().length() == 0)
						{
							errString = RetrievePordAmd(amdNo, xtraParams, conn);
						}
					}
				}
				if (errString == null || errString.trim().length() == 0)
				{
					errString = "PRCUSUCCES";
					//errString = itmDBAccessLocal.getErrorString("", errString, "");EEE
					errString = getError(purcOrder, "" , errString, conn);
					return errString;
				}

			} // end if errstrng
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			System.out.println("Error String if confirm="+errString);
			try
			{
				//if (errString != null && errString.trim().length() > 0 && !("PRCUSUCCES".equalsIgnoreCase(errString)))
				if(errString!=null && !(errString.indexOf("PRCUSUCCES") > 0))
				{
					conn.rollback();
					System.out.println("Transaction rollback... ");
					
					//conn.close();
					//conn = null;
				} else
				{
					//conn.commit(); // test
					System.out.println("@@@@ Transaction commit... ");
					//conn.close();
					//conn = null;
				}
			} catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("errString[" + errString + "]:::::::::::errCode[" + errCode + "]");
		return errString;
	}
	private String RetrievePordAmd(String amdNo, String xtraParams, Connection conn) throws RemoteException, ITMException
	{

		PreparedStatement pstmt = null, pstmt1 = null, pstmtSql = null;
		ResultSet rs = null, rs1 = null;
		int cnt = 0;
		String retString = "", sql = "", sql1 = "", purcOrder = "", lineNoOrd = "", errCode = "";
		String loginEmpCode = "", ediOption = "", dataStr = "";
		double vouchAdv = 0, amdDetTot = 0, poDetTot = 0, poHdrTot = 0;
		Timestamp sysDate = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try
		{
			System.out.println("@@@@@@@@@@@@@@@ RetrievePordAmd confirm called..............");

			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf.format(currentDate.getTime());
			System.out.println("Now the date is :=>  " + sysDateStr + ":::loginEmpCode[" + loginEmpCode + "]");
			sysDate = Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");

			sql = " select a.tot_amt, case when a.vouch_adv_amt is null then 0 else a.vouch_adv_amt end " + " from porder a, poamd_hdr b " + " where a.purc_order = b.purc_order " + " and b.amd_no = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, amdNo);

			rs = pstmt.executeQuery();
			if (rs.next())
			{
				poHdrTot = rs.getDouble(1);
				vouchAdv = rs.getDouble(2);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if (vouchAdv > 0) // lc_vouchadv > 0 then
			{
				sql = " select purc_order,line_no__ord, tot_amt from poamd_det where amd_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, amdNo);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					purcOrder = rs.getString("purc_order");
					lineNoOrd = rs.getString("line_no__ord");
					amdDetTot = rs.getDouble("tot_amt");

					if (lineNoOrd != null && lineNoOrd.trim().length() > 0 && purcOrder != null && purcOrder.trim().length() > 0)
					{
						sql1 = " select tot_amt from porddet where purc_order = ? and line_no = ?  ";
						pstmt1 = conn.prepareStatement(sql1);
						pstmt1.setString(1, purcOrder);
						pstmt1.setString(2, lineNoOrd);
						rs1 = pstmt1.executeQuery();
						if (rs1.next())
						{
							poDetTot = rs1.getDouble("tot_amt");
						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
					}
					poHdrTot = poHdrTot - poDetTot + amdDetTot;
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				System.out.println("@@@@@@@@@ vouchAdv[" + vouchAdv + "]:::::poHdrTot[" + poHdrTot + "]");

				if (vouchAdv > poHdrTot)
				{
					errCode = "VTADVEXCES";
					//errCode = itmDBAccessLocal.getErrorString("", errCode, "");EEE
					errCode = getError(purcOrder, lineNoOrd , errCode, conn);
					return errCode;
				}
			}

			errCode = ConfirmPordAmd(amdNo, conn);
			System.out.println("Error String after confirm ConfirmPordAmd(amdNo, conn)"+errCode);
			if (errCode != null && errCode.trim().length() > 0)
			{
				conn.rollback();
			} 
			else
			{
				sql = "select edi_option from transetup where tran_window = 'w_porderamd' ";
				pstmtSql = conn.prepareStatement(sql);
				rs = pstmtSql.executeQuery();
				if (rs.next())
				{
					ediOption = rs.getString("EDI_OPTION");
				}
				rs.close();
				rs = null;
				pstmtSql.close();
				pstmtSql = null;
				//changed by  wasim on 09-03-2015 to check edi option null start.
				ediOption = ediOption != null?ediOption:"0";
				int ediOpt = Integer.parseInt(ediOption);
				System.out.println("@@@@@@@@@@@@@@@ ediOption  called next..............");
				if(ediOpt > 0)
				{
					CreateRCPXML createRCPXML = new CreateRCPXML("w_porderamd", "tran_id");
					dataStr = createRCPXML.getTranXML(amdNo, conn);
					System.out.println("dataStr =[ " + dataStr + "]");
					Document ediDataDom = genericUtility.parseString(dataStr);

					E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
					retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_porderamd", ""+ediOpt , xtraParams, conn);
					createRCPXML = null;
					e12CreateBatchLoad = null;

					if (retString != null && "SUCCESS".equals(retString))
					{
						System.out.println("retString from batchload = [" + retString + "]");
					}
				}
				
				/*if ("2".equals(ediOption))
				{
					CreateRCPXML createRCPXML = new CreateRCPXML("w_porderamd", "tran_id");
					dataStr = createRCPXML.getTranXML(amdNo, conn);
					System.out.println("dataStr =[ " + dataStr + "]");
					Document ediDataDom = genericUtility.parseString(dataStr);

					E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
					retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_porderamd", "2", xtraParams, conn);
					createRCPXML = null;
					e12CreateBatchLoad = null;

					if (retString != null && "SUCCESS".equals(retString))
					{
						System.out.println("retString from batchload = [" + retString + "]");
					}
				}

				else
				{

					CreateRCPXML createRCPXML = new CreateRCPXML("w_porderamd", "tran_id");
					dataStr = createRCPXML.getTranXML(amdNo, conn);
					System.out.println("dataStr =[ " + dataStr + "]");
					Document ediDataDom = genericUtility.parseString(dataStr);

					E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
					retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_porderamd", ediOption, xtraParams, conn);
					createRCPXML = null;
					e12CreateBatchLoad = null;

					if (retString != null && "SUCCESS".equals(retString))
					{
						System.out.println("retString from batchload = [" + retString + "]");
					}
				}
				System.out.println("@@@@@@@@@@@@@@@ ediOption  called end..............");*/
				//changed by  wasim on 09-03-2015 to check edi option null end.

			}

			if (errCode == null || errCode.trim().length() == 0)
			{
				sql = " update poamd_hdr set confirmed = 'Y',conf_date = ?, emp_code__aprv = ? where amd_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, sysDate);
				pstmt.setString(2, loginEmpCode);
				pstmt.setString(3, amdNo);
				cnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				System.out.println("@@@@@@ cnt...[" + cnt + "]");
				if (!(cnt == 1))
				{
					errCode = "VTNOAMD";
					//errCode = itmDBAccessLocal.getErrorString("", errCode, "");EEE
					errCode = getError(purcOrder, lineNoOrd , errCode, conn);
					return errCode;
				}
			}

			if (errCode != null && errCode.trim().length() > 0)
			{
				conn.rollback();
			} else
			{
				//conn.commit();
			}
		} catch (Exception e)
		{
			System.out.println("Exception :conf ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}

		return errCode;
	}
	private String ConfirmPordAmd(String amdNo, Connection conn) throws RemoteException, ITMException

	{
		PreparedStatement pstmt = null, pstmt1 = null, pstmt3 = null, pstmtSql = null, pstmt4 = null;
		ResultSet rs = null, rs1 = null, rs3 = null;
		int cnt = 0;
		// Document dom = null;
		String retString = "", sql = "", sql1 = "", sql3 = "", purcOrder = "", lineNoOrd = "", errCode = "", sql4 = null;
		// String loginEmpCode = "", ediOption = "", dataStr = "";
		// double pohdrTot = 0, vouchAdv = 0, amdDetTot = 0, poDetTot = 0,
		// poHdrTot = 0;
		Timestamp sysDate = null, taxDate = null, refDate = null, amdDate = null;
		String siteCodeDlv = "", siteCodeOrd = "", siteCodeBill = "", deptCode = "", empCode = "", itemSer = "", taxOpt = "", crTerm = "";
		String currCode = "", taxChapHdr = "", taxClassHdr = "", taxEnvHdr = "", remarks = "", projCode = "", salesPers = "", commPerc = "", commPercOn = "";
		String currCodeComm = "", quotNo = "", tranCode = "", currCodeFrt = "", frtTerm = "", dlvTerm = "", currCodeIns = "", empCodeAprv = "", suppCode = "";
		double ordAmt = 0, taxAmt = 0, totAmt = 0, exchRate = 0, frtAmt = 0, insuranceAmt = 0;
		String siteCode = "", indNo = "", itemCode = "", lineNo = "", discountType = "", taxClass = "";
		double quantity = 0, rate = 0, convQtyStduom = 0, convRtuomStduom = 0, quantityStduom = 0, rateStduom = 0;
		double discount = 0, rateClg = 0;
		String UnitStd = "", unitRate = "";
		Timestamp reqDate = null, dlvDate = null;
		String taxChap = "", taxEnv = "", workOrder = "", packCode = "", packInstr = "", acctCodeDr = "", cctrCodeDr = "";
		String acctCodeCr = "", cctrCodeCr = "";
		double noArt = 0;
		String locCode = "", status = "", specificInstr = "", suppCodeMnfr = "", unit = "";
		String specialInstr = "", benefitType = "", licenceNo = "", dutyPaid = "", formNo = "", lineNoPO = "";

		String lineNoTax = "", taxCode = "", taxBase = "", taxPerc = "", chgStat = "", taxSet = "", effect = "", acctCodeReco = "";
		String cctrCodeReco = "", recoPerc = "", acctCode = "", cctrCode = "", rateType = "", round = "", roundTo = "", taxForm = "";
		String acctCodeApAdv = "", cctrCodeApAdv = ""; // VALLABH KADAM Add two
													   // new field 19/NOV/14
		String chgUser = "", chgTerm = "", posted = "", payTax = "", orderOpt = "", bom = "", oldItem = "", lastTermLine = "";
		double taxableAmt = 0, recoAmont = 0, dlvQuantity = 0, clgRate = 0, ordQty = 0, totOrdQty = 0, quantStduom = 0;
		Timestamp taxFormDate = null, chgDate = null;
		int updCnt = 0;
		double taxAmtS = 0, totAmtS = 0, ordAmtS = 0;
		double vouchAmt = 0;
		String advance = "";
		String frtType = "";
		double frtRate = 0, frtAmtQty = 0, frtAmtFixed = 0;
		E12GenericUtility genericUtility = new E12GenericUtility();
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		String termCode = "", descr = "", printOpt = "";
		try
		{
			System.out.println("@@@@@@@@@@@@@@@ ConfirmPordAmd method called next..............");
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf.format(currentDate.getTime());
			System.out.println("Now the date is :=>  " + sysDateStr);
			sysDate = Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");

			sql = " select purc_order,site_code__dlv,site_code__ord,site_code__bill,dept_code,emp_code,item_ser,tax_opt," + "	cr_term,ord_amt,tax_amt,tot_amt,curr_code,exch_rate,tax_chap,tax_class,tax_env,remarks,tax_date," + " proj_code,sales_pers,comm_perc,comm_perc__on,curr_code__comm,quot_no,tran_code,frt_amt,curr_code__frt," + " frt_term,dlv_term,insurance_amt,curr_code__ins,emp_code__aprv,ref_date,amd_date,supp_code," + "  FRT_TYPE, FRT_RATE,FRT_AMT__QTY, FRT_AMT__FIXED " + " from poamd_hdr where amd_no = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, amdNo);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cnt++;
				purcOrder = rs.getString("purc_order");
				siteCodeDlv = rs.getString("site_code__dlv");
				siteCodeOrd = rs.getString("site_code__ord");
				siteCodeBill = rs.getString("site_code__bill");
				deptCode = rs.getString("dept_code");
				empCode = rs.getString("emp_code");
				itemSer = rs.getString("item_ser");
				taxOpt = rs.getString("tax_opt");
				crTerm = rs.getString("cr_term");
				ordAmt = rs.getDouble("ord_amt");
				taxAmt = rs.getDouble("tax_amt");
				totAmt = rs.getDouble("tot_amt");
				currCode = rs.getString("curr_code");
				exchRate = rs.getDouble("exch_rate");
				taxChapHdr = rs.getString("tax_chap");
				taxClassHdr = rs.getString("tax_class");
				taxEnvHdr = rs.getString("tax_env");
				remarks = rs.getString("remarks");
				taxDate = rs.getTimestamp("tax_date");
				projCode = rs.getString("proj_code");
				salesPers = rs.getString("sales_pers");
				commPerc = rs.getString("comm_perc");
				commPercOn = rs.getString("comm_perc__on");
				currCodeComm = rs.getString("curr_code__comm");
				quotNo = rs.getString("quot_no");
				tranCode = rs.getString("tran_code");
				frtAmt = rs.getDouble("frt_amt");
				currCodeFrt = rs.getString("curr_code__frt");
				frtTerm = rs.getString("frt_term");
				dlvTerm = rs.getString("dlv_term");
				insuranceAmt = rs.getDouble("insurance_amt");
				currCodeIns = rs.getString("curr_code__ins");
				empCodeAprv = rs.getString("emp_code__aprv");
				refDate = rs.getTimestamp("ref_date");
				amdDate = rs.getTimestamp("amd_date");
				suppCode = rs.getString("supp_code");
				// added by cpatil
				frtType = rs.getString("FRT_TYPE");
				frtRate = rs.getDouble("FRT_RATE");
				frtAmtQty = rs.getDouble("FRT_AMT__QTY");
				frtAmtFixed = rs.getDouble("FRT_AMT__FIXED");
				// end

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if (cnt == 0)
			{
				errCode = "VTNOAMD";
				//errCode = itmDBAccessLocal.getErrorString("", errCode, "");
				errCode = getError(purcOrder, lineNoOrd , errCode, conn);
				return errCode;
			}
			/**
			 * VALLABH select Advance account code CCTR code from header
			 * supp_code VALLABH KADAM 19/NOV/14 END
			 */
			sql = "select ACCT_CODE__AP_ADV,CCTR_CODE__AP_ADV from supplier where supp_code=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, suppCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				acctCodeApAdv = rs.getString("ACCT_CODE__AP_ADV");
				cctrCodeApAdv = rs.getString("CCTR_CODE__AP_ADV");

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			/**
			 * VALLABH select Advance account code CCTR code from header
			 * supp_code VALLABH KADAM 19/NOV/14 END
			 */
			System.out.println("000000000000000 suppCode[" + suppCode + "]");
			System.out.println("000000000000000 acctCodeApAdv[" + acctCodeApAdv + "]");
			System.out.println("000000000000000 cctrCodeApAdv[" + cctrCodeApAdv + "]");

			sql = " select count(*) from poamd_det where amd_no = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, amdNo);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cnt = rs.getInt(1);

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("@@@@@@ inside cnt " + cnt);
			if (cnt > 0)
			{
				System.out.println("@@@@@@ inside cnt " + cnt);

				sql1 = " select purc_order,line_no__ord,site_code,ind_no,item_code,quantity,rate,tax_amt,tot_amt,req_date,"
				+ "	conv__qty_stduom,conv__rtuom_stduom,quantity__stduom,rate__stduom,line_no,unit,discount,"
						+ " discount_type,tax_class,tax_chap,tax_env,remarks,work_order,pack_code,pack_instr,acct_code__dr,"
				+ "	cctr_code__dr,acct_code__cr,cctr_code__cr,no_art,unit__std,unit__rate,dlv_date,loc_code,status,"
						+ "	specific_instr,supp_code_mnfr,rate__clg,special_instr,benefit_type,licence_no,duty_paid,form_no" 
				+ " from   poamd_det where  amd_no = ? ";
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1, amdNo);
				rs1 = pstmt1.executeQuery();
				while (rs1.next())
				{
					System.out.println("@@@@@@ inside while ");
					purcOrder = checknull(rs1.getString("purc_order"));
					lineNoOrd = checknull(rs1.getString("line_no__ord"));
					siteCode = checknull(rs1.getString("site_code"));
					indNo = checknull(rs1.getString("ind_no"));
					itemCode = checknull(rs1.getString("item_code"));
					quantity = rs1.getDouble("quantity");
					rate = rs1.getDouble("rate");
					taxAmt = rs1.getDouble("tax_amt");
					totAmt = rs1.getDouble("tot_amt");
					reqDate = rs1.getTimestamp("req_date");
					convQtyStduom = rs1.getDouble("conv__qty_stduom");
					convRtuomStduom = rs1.getDouble("conv__rtuom_stduom");
					quantityStduom = rs1.getDouble("quantity__stduom");
					rateStduom = rs1.getDouble("rate__stduom");
					lineNo = checknull(rs1.getString("line_no"));
					unit = rs1.getString("unit");
					discount = rs1.getDouble("discount");
					discountType = checknull(rs1.getString("discount_type"));
					taxClass = checknull(rs1.getString("tax_class"));
					taxChap = checknull(rs1.getString("tax_chap"));
					taxEnv = checknull(rs1.getString("tax_env"));
					remarks = checknull(rs1.getString("remarks"));
					workOrder = checknull(rs1.getString("work_order"));
					packCode = checknull(rs1.getString("pack_code"));
					packInstr = checknull(rs1.getString("pack_instr"));
					acctCodeDr = checknull(rs1.getString("acct_code__dr"));
					cctrCodeDr = checknull(rs1.getString("cctr_code__dr"));
					acctCodeCr = checknull(rs1.getString("acct_code__cr"));
					cctrCodeCr = checknull(rs1.getString("cctr_code__cr"));
					noArt = rs1.getDouble("no_art");
					UnitStd = rs1.getString("unit__std");
					unitRate = rs1.getString("unit__rate");
					dlvDate = rs1.getTimestamp("dlv_date");
					locCode = checknull(rs1.getString("loc_code"));
					status = checknull(rs1.getString("status"));
					specificInstr = checknull(rs1.getString("specific_instr"));
					suppCodeMnfr = checknull(rs1.getString("supp_code_mnfr"));
					rateClg = rs1.getDouble("rate__clg");
					specialInstr = checknull(rs1.getString("special_instr"));
					benefitType = checknull(rs1.getString("benefit_type"));
					licenceNo = checknull(rs1.getString("licence_no"));
					dutyPaid = checknull(rs1.getString("duty_paid"));
					formNo = checknull(rs1.getString("form_no"));

					System.out.println("@@@@@@@@ indNo [" + indNo + "]");
					System.out.println("CLG rate  select from poamd_det[" + rateClg + "]");
					if (indNo != null && indNo.trim().length() > 0)
					{
						sql = " select quantity__stduom,ord_qty from indent where  ind_no = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, amdNo);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							quantity = rs.getDouble("quantity__stduom");
							ordQty = rs.getDouble("ord_qty");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						// adding ord qty from table + ord qty entered
						sql = "	select quantity__stduom from porddet where purc_order = ? and line_no = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrder);
						pstmt.setString(2, lineNoOrd);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							quantStduom = rs.getDouble("quantity__stduom");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						totOrdQty = (ordQty - quantStduom) + quantityStduom;

						if (quantity > totOrdQty)
						{
							sql = " update indent set status = 'O', status_date = ? , ord_qty = ?," + " unit__ord   = ?  where  ind_no  = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setTimestamp(1, sysDate);
							pstmt.setDouble(2, totOrdQty);
							pstmt.setString(3, UnitStd);
							pstmt.setString(4, indNo);
							updCnt = pstmt.executeUpdate();
							pstmt.close();
							pstmt = null;

						} else
						// status= 'L' (complete)
						{
							sql = " update indent set status = 'L', status_date = ? , ord_qty = ? ," + " unit__ord = ? where  ind_no = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setTimestamp(1, sysDate);
							pstmt.setDouble(2, totOrdQty);
							pstmt.setString(3, UnitStd);
							pstmt.setString(4, indNo);
							updCnt = pstmt.executeUpdate();
							pstmt.close();
							pstmt = null;

						}
						if (updCnt == 0)
						{
							errCode = "VTINDUPD";
							errCode = itmDBAccessLocal.getErrorString("", errCode, "");
							return errCode;
						}
					}

					System.out.println("@@@@@@ lineNoOrd indNo [" + indNo + "]:::lineNoOrd[" + lineNoOrd + "]");

					if (lineNoOrd != null && lineNoOrd.trim().length() > 0)
					{
						System.out.println("@@@@@@ inside indNo [" + indNo + "]:::lineNoOrd[" + lineNoOrd + "]");

						sql3 = " select item_code from  porddet where purc_order = ? and  line_no = ? ";
						pstmt3 = conn.prepareStatement(sql3);
						pstmt3.setString(1, purcOrder);
						pstmt3.setString(2, lineNoOrd);
						rs3 = pstmt3.executeQuery();
						if (rs3.next())
						{
							oldItem = rs3.getString("item_code");

							{
								System.out.println("@@@@@@@@@@oldItem[" + oldItem + "]::::itemCode[" + itemCode + "]");
								if (!(itemCode.equalsIgnoreCase(oldItem)))
								{
									errCode = "VTITEMDIFF";
									errCode = itmDBAccessLocal.getErrorString("", errCode, "");
									return errCode;
								}
								sql = " update porddet set site_code = ?,quantity = ?,rate = ?,tax_amt = ?,tot_amt = ?,"
								+ " remarks = ?, discount_type = ?,discount = ?,req_date = ?,conv__qty_stduom = ?,"
										+ " conv__rtuom_stduom = ?,quantity__stduom = ?,rate__stduom = ?,tax_class = ?,"
								+ " tax_chap = ?, tax_env= ?,status = ?,status_date = ?, pack_instr = ?, specific_instr= ?,"
										+ " supp_code__mnfr = ?,rate__clg = ?,special_instr = ?,dlv_date = ?,benefit_type = ?,"
								+ " licence_no	= ?,acct_code__ap_adv=?,cctr_code__ap_adv=?"
								+ " where purc_order = ?	and line_no = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, siteCode);
								pstmt.setDouble(2, quantity);
								pstmt.setDouble(3, rate);
								pstmt.setDouble(4, taxAmt);
								pstmt.setDouble(5, totAmt);
								pstmt.setString(6, remarks);
								pstmt.setString(7, discountType);
								pstmt.setDouble(8, discount);
								pstmt.setTimestamp(9, reqDate);
								pstmt.setDouble(10, convQtyStduom);
								pstmt.setDouble(11, convRtuomStduom);
								pstmt.setDouble(12, quantityStduom);
								pstmt.setDouble(13, rateStduom);
								pstmt.setString(14, taxClass);
								pstmt.setString(15, taxChap);
								pstmt.setString(16, taxEnv);
								pstmt.setString(17, status);
								pstmt.setTimestamp(18, sysDate);
								pstmt.setString(19, packInstr);
								pstmt.setString(20, specificInstr);
								pstmt.setString(21, suppCodeMnfr);
								// pstmt.setDouble(22, clgRate);
								pstmt.setDouble(22, rateClg); // VALLABH KADAM
															  // 7-NOV-14
															  // DI3ESUN002
															  // change variable
															  // from [clgRate]
															  // to [rateClg]
								pstmt.setString(23, specialInstr);
								pstmt.setTimestamp(24, dlvDate);
								pstmt.setString(25, benefitType);
								pstmt.setString(26, licenceNo);
								pstmt.setString(27, acctCodeApAdv);
								pstmt.setString(28, cctrCodeApAdv);
								
								pstmt.setString(29, purcOrder);
								pstmt.setString(30, lineNoOrd);
								

								updCnt = pstmt.executeUpdate();
								pstmt.close();
								pstmt = null;

								if (!(updCnt == 1))
								{
									errCode = "VTORDDT1";
									//errCode = itmDBAccessLocal.getErrorString("", errCode, "");EEE
									errCode = getError(purcOrder, lineNoOrd , errCode, conn);
									return errCode;
								}

								// modify for ORO on 15/12/14 by cpatil start
								System.out.println("@@@@@@@@@@@- code for P-ORO-----");
								
								sql = " delete from taxtran where tran_code = 'P-ORO' and tran_id = ? and line_no = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, purcOrder);
								pstmt.setString(2, lineNoOrd);
								pstmt.executeUpdate();
								pstmt.close();
								pstmt = null;
								
								
								sql = " select line_no__tax,tax_code,"
										 + " tax_class,tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set,effect,"
												+ " acct_code__reco,cctr_code__reco,reco_perc,reco_amount,acct_code,cctr_code,rate_type,round,round_to,"
										 + " tax_form,chg_date,chg_user,chg_term,posted,tax_form_date,pay_tax "
												+ " from taxtran where tran_code = ?  and   tran_id = ? and   line_no = ? ";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1, "P-ORD");
										pstmt.setString(2, purcOrder);
										pstmt.setString(3, lineNoOrd);
										rs = pstmt.executeQuery();
										// if (rs.next()) {
										while (rs.next())
										{
											lineNoTax = rs.getString("line_no__tax");
											taxCode = rs.getString("tax_code");
											taxClass = rs.getString("tax_class");
											taxChap = rs.getString("tax_chap");
											taxBase = rs.getString("tax_base");
											taxEnv = rs.getString("tax_env");
											taxableAmt = rs.getDouble("taxable_amt");
											taxPerc = rs.getString("tax_perc");
											taxAmt = rs.getDouble("tax_amt");
											chgStat = rs.getString("chg_stat");
											taxSet = rs.getString("tax_set");
											effect = rs.getString("effect");
											acctCodeReco = rs.getString("acct_code__reco");
											cctrCodeReco = rs.getString("cctr_code__reco");
											recoPerc = rs.getString("reco_perc");
											recoAmont = rs.getDouble("reco_amount");
											acctCode = rs.getString("acct_code");
											cctrCode = rs.getString("cctr_code");
											rateType = rs.getString("rate_type");
											round = rs.getString("round");
											roundTo = rs.getString("round_to");
											taxForm = rs.getString("tax_form");
											chgDate = rs.getTimestamp("chg_date");
											chgUser = rs.getString("chg_user");
											chgTerm = rs.getString("chg_term");
											posted = rs.getString("posted");
											taxFormDate = rs.getTimestamp("tax_form_date");
											payTax = rs.getString("pay_tax");

											/** Insert taxtran rows */
											sql4 = " insert into taxtran (tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class,"
											+ " tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set	,	"
													+ " effect,acct_code__reco,	cctr_code__reco,reco_perc,reco_amount,acct_code,"
											+ "	cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,"
													+ "	posted,tax_form_date,pay_tax) "
											+ " values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ) ";
											pstmt4 = conn.prepareStatement(sql4);
											pstmt4.setString(1, "P-ORO");
											pstmt4.setString(2, purcOrder);
											pstmt4.setString(3, lineNoOrd); 
											pstmt4.setString(4, lineNoTax);
											pstmt4.setString(5, taxCode);
											pstmt4.setString(6, taxClass);
											pstmt4.setString(7, taxChap);
											pstmt4.setString(8, taxBase);
											pstmt4.setString(9, taxEnv);
											pstmt4.setDouble(10, taxableAmt);
											pstmt4.setString(11, taxPerc);
											pstmt4.setDouble(12, taxAmt);
											pstmt4.setString(13, chgStat);
											pstmt4.setString(14, taxSet);
											pstmt4.setString(15, effect);
											pstmt4.setString(16, acctCodeReco);
											pstmt4.setString(17, cctrCodeReco);
											pstmt4.setString(18, recoPerc);
											pstmt4.setDouble(19, recoAmont);
											pstmt4.setString(20, acctCode);
											pstmt4.setString(21, cctrCode);
											pstmt4.setString(22, rateType);
											pstmt4.setString(23, round);
											pstmt4.setString(24, roundTo);
											pstmt4.setString(25, taxForm);
											pstmt4.setTimestamp(26, chgDate);
											pstmt4.setString(27, chgUser);
											pstmt4.setString(28, chgTerm);
											pstmt4.setString(29, posted);
											pstmt4.setTimestamp(30, taxFormDate);
											pstmt4.setString(31, payTax);

											cnt = pstmt4.executeUpdate();
											pstmt4.close();
											pstmt4 = null;
											/** Indert taxtran rows END */

										}

										rs.close();
										rs = null;
										pstmt.close();
										pstmt = null;

								
								
								
								// modify for ORO on 15/12/14 by cpatil end								
								
								sql = " delete from taxtran where tran_code = 'P-ORD' and tran_id = ? and line_no = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, purcOrder);
								pstmt.setString(2, lineNoOrd);
								pstmt.executeUpdate();
								pstmt.close();
								pstmt = null;

								lineNo = "    " + lineNo;
								lineNo = lineNo.substring(lineNo.length() - 3, lineNo.length());

								sql = " select count(*) from taxtran where tran_code = 'P-AMD'" 
								+ " and tran_id = ?	and line_no = ? and	 taxable_amt <> 0 and tax_amt <> 0 ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, amdNo);
								pstmt.setString(2, lineNo);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									cnt = rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if (cnt > 0)
								{

									/*
									 * sql =
									 * " insert into taxtran ( tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class,tax_chap,tax_base,tax_env,"
									 * +
									 * " taxable_amt,tax_perc,tax_amt,chg_stat,tax_set,effect,acct_code__reco,cctr_code__reco,reco_perc,reco_amount,"
									 * +
									 * " acct_code,cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,posted,tax_form_date,pay_tax  ) "
									 * +
									 * " select 'P-ORD',tran_id,line_no,line_no__tax,tax_code,tax_class,tax_chap,tax_base,tax_env,taxable_amt,"
									 * +
									 * " tax_perc,tax_amt,chg_stat,tax_set,effect,acct_code__reco,cctr_code__reco,reco_perc,reco_amount,acct_code,cctr_code,"
									 * +
									 * " rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,posted	,tax_form_date, pay_tax "
									 * +
									 * " from taxtran where tran_code = ?	and   tran_id = ? and 	line_no = ? "
									 * ; pstmt = conn.prepareStatement(sql);
									 * pstmt.setString(1, "P-AMD");
									 * pstmt.setString(2, amdNo);
									 * pstmt.setString(3, lineNo); int cnt2 =
									 * pstmt.executeUpdate(); pstmt.close();
									 * pstmt = null;
									 * 
									 * System.out.println("@@@@1 cnt2["+cnt2+"]")
									 * ;
									 *//**/
									sql = " select line_no__tax,tax_code,"
									 + " tax_class,tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set,effect,"
											+ " acct_code__reco,cctr_code__reco,reco_perc,reco_amount,acct_code,cctr_code,rate_type,round,round_to,"
									 + " tax_form,chg_date,chg_user,chg_term,posted,tax_form_date,pay_tax "
											+ " from taxtran where tran_code = ?  and   tran_id = ? and   line_no = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, "P-AMD");
									pstmt.setString(2, amdNo);
									pstmt.setString(3, lineNo);
									rs = pstmt.executeQuery();
									// if (rs.next()) {
									while (rs.next())
									{ // Change fom if to while loop VALLABH
									  // KADAM 19/NOV/14
										lineNoTax = rs.getString("line_no__tax");
										taxCode = rs.getString("tax_code");
										taxClass = rs.getString("tax_class");
										taxChap = rs.getString("tax_chap");
										taxBase = rs.getString("tax_base");
										taxEnv = rs.getString("tax_env");
										taxableAmt = rs.getDouble("taxable_amt");
										taxPerc = rs.getString("tax_perc");
										taxAmt = rs.getDouble("tax_amt");
										chgStat = rs.getString("chg_stat");
										taxSet = rs.getString("tax_set");
										effect = rs.getString("effect");
										acctCodeReco = rs.getString("acct_code__reco");
										cctrCodeReco = rs.getString("cctr_code__reco");
										recoPerc = rs.getString("reco_perc");
										recoAmont = rs.getDouble("reco_amount");
										acctCode = rs.getString("acct_code");
										cctrCode = rs.getString("cctr_code");
										rateType = rs.getString("rate_type");
										round = rs.getString("round");
										roundTo = rs.getString("round_to");
										taxForm = rs.getString("tax_form");
										chgDate = rs.getTimestamp("chg_date");
										chgUser = rs.getString("chg_user");
										chgTerm = rs.getString("chg_term");
										posted = rs.getString("posted");
										taxFormDate = rs.getTimestamp("tax_form_date");
										payTax = rs.getString("pay_tax");

										/** Insert taxtran rows */
										sql4 = " insert into taxtran (tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class,"
										+ " tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set	,	"
												+ " effect,acct_code__reco,	cctr_code__reco,reco_perc,reco_amount,acct_code,"
										+ "	cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,"
												+ "	posted,tax_form_date,pay_tax) "
										+ " values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ) ";
										pstmt4 = conn.prepareStatement(sql4);
										pstmt4.setString(1, "P-ORD");
										pstmt4.setString(2, purcOrder);
										pstmt4.setString(3, lineNoOrd); // lineNo
																		// change
																		// by
																		// cpatil
																		// on
																		// 17/10/13
										pstmt4.setString(4, lineNoTax);
										pstmt4.setString(5, taxCode);
										pstmt4.setString(6, taxClass);
										pstmt4.setString(7, taxChap);
										pstmt4.setString(8, taxBase);
										pstmt4.setString(9, taxEnv);
										pstmt4.setDouble(10, taxableAmt);
										pstmt4.setString(11, taxPerc);
										pstmt4.setDouble(12, taxAmt);
										pstmt4.setString(13, chgStat);
										pstmt4.setString(14, taxSet);
										pstmt4.setString(15, effect);
										pstmt4.setString(16, acctCodeReco);
										pstmt4.setString(17, cctrCodeReco);
										pstmt4.setString(18, recoPerc);
										pstmt4.setDouble(19, recoAmont);
										pstmt4.setString(20, acctCode);
										pstmt4.setString(21, cctrCode);
										pstmt4.setString(22, rateType);
										pstmt4.setString(23, round);
										pstmt4.setString(24, roundTo);
										pstmt4.setString(25, taxForm);
										pstmt4.setTimestamp(26, chgDate);
										pstmt4.setString(27, chgUser);
										pstmt4.setString(28, chgTerm);
										pstmt4.setString(29, posted);
										pstmt4.setTimestamp(30, taxFormDate);
										pstmt4.setString(31, payTax);

										cnt = pstmt4.executeUpdate();
										pstmt4.close();
										pstmt4 = null;
										/** Indert taxtran rows END */

									}

									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									// sql =
									// " insert into taxtran (tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class,"
									// +
									// " tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set	,	"
									// +
									// " effect,acct_code__reco,	cctr_code__reco,reco_perc,reco_amount,acct_code,"
									// +
									// "	cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,"
									// + "	posted,tax_form_date,pay_tax) "
									// +
									// " values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ) ";
									// pstmt = conn.prepareStatement(sql);
									// pstmt.setString(1, "P-ORD");
									// pstmt.setString(2, purcOrder);
									// pstmt.setString(3, lineNoOrd); //lineNo
									// change by cpatil on 17/10/13
									// pstmt.setString(4, lineNoTax);
									// pstmt.setString(5, taxCode);
									// pstmt.setString(6, taxClass);
									// pstmt.setString(7, taxChap);
									// pstmt.setString(8, taxBase);
									// pstmt.setString(9, taxEnv);
									// pstmt.setDouble(10, taxableAmt);
									// pstmt.setString(11, taxPerc);
									// pstmt.setDouble(12, taxAmt);
									// pstmt.setString(13, chgStat);
									// pstmt.setString(14, taxSet);
									// pstmt.setString(15, effect);
									// pstmt.setString(16, acctCodeReco);
									// pstmt.setString(17, cctrCodeReco);
									// pstmt.setString(18, recoPerc);
									// pstmt.setDouble(19, recoAmont);
									// pstmt.setString(20, acctCode);
									// pstmt.setString(21, cctrCode);
									// pstmt.setString(22, rateType);
									// pstmt.setString(23, round);
									// pstmt.setString(24, roundTo);
									// pstmt.setString(25, taxForm);
									// pstmt.setTimestamp(26, chgDate);
									// pstmt.setString(27, chgUser);
									// pstmt.setString(28, chgTerm);
									// pstmt.setString(29, posted);
									// pstmt.setTimestamp(30, taxFormDate);
									// pstmt.setString(31, payTax);
									//
									// cnt = pstmt.executeUpdate();
									// pstmt.close();
									// pstmt = null;
									// /**/
									// System.out.println("@@@@1 cnt["+cnt+"]");
								}
								// end if
							}

						} else
						// if (oldItem == null || oldItem.trim().length() == 0)
						{
							lineNo = "    " + lineNo;
							lineNo = lineNo.substring(lineNo.length() - 3, lineNo.length());
							System.out.println("@@@@In the ELSE No item code found for purchase order and Line no");
							if (cctrCodeDr == null)
							{
								cctrCodeDr = "";
							}

							if (cctrCodeCr == null)
							{
								cctrCodeCr = "";
							}
							
							sql = " insert into porddet ( purc_order,line_no,site_code,ind_no,item_code,quantity,unit,rate,"
							+ "	discount,tax_amt,tot_amt,loc_code,req_date,dlv_date,dlv_qty,status,status_date," 
									+ " tax_class,tax_chap,tax_env,remarks,work_order,unit__rate,conv__qty_stduom,conv__rtuom_stduom," 
							+ "	unit__std,quantity__stduom,rate__stduom,pack_code,no_art,pack_instr,acct_code__dr," 
									+ " cctr_code__dr,acct_code__cr,cctr_code__cr,discount_type,supp_code__mnfr,order_opt,bom_code,"
							+ "	specific_instr,rate__clg,special_instr,benefit_type,licence_no,duty_paid,form_no,"
							+ "acct_code__ap_adv,cctr_code__ap_adv) "
									+ " values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,"
									+ "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ) ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, purcOrder); // v
							// pstmt.setString(2, lineNo); // line_no
							pstmt.setString(2, lineNoOrd); // line_no Change
														   // from [lineNo] to
														   // [lineNoOrd]
														   // VALLABH KADAM
														   // 17/NOV/14
							pstmt.setString(3, siteCode); // site_code
							pstmt.setString(4, indNo); // ind_no
							pstmt.setString(5, itemCode); // item code
							pstmt.setDouble(6, quantity);// quantity
							pstmt.setString(7, unit); // unit
							pstmt.setDouble(8, rate); // rate

							pstmt.setDouble(9, discount); // discount
							pstmt.setDouble(10, taxAmt); // tax_amt
							pstmt.setDouble(11, totAmt); // tot_amt
							pstmt.setString(12, locCode); // loc_code
							pstmt.setTimestamp(13, reqDate); // req_date
							pstmt.setTimestamp(14, dlvDate); // dlv_date
							pstmt.setDouble(15, dlvQuantity); // dlv_qty
							pstmt.setString(16, status); // status
							pstmt.setTimestamp(17, sysDate); // status_date

							pstmt.setString(18, taxClass); // tax_class
							pstmt.setString(19, taxChap); // tax_chap
							pstmt.setString(20, taxEnv); // tax_env
							pstmt.setString(21, remarks); // remarks
							pstmt.setString(22, workOrder); // work_order
							pstmt.setString(23, unitRate); // unit__rate
							pstmt.setDouble(24, convQtyStduom); // conv__qty_stduom
							pstmt.setDouble(25, convRtuomStduom); // conv__rtuom_stduom

							pstmt.setString(26, UnitStd); // unit__std
							pstmt.setDouble(27, quantityStduom); // quantity__stduom
							pstmt.setDouble(28, rateStduom); // rate__stduom
							pstmt.setString(29, packCode); // pack_code
							pstmt.setDouble(30, noArt); // no_art
							pstmt.setString(31, packInstr); // pack_instr
							pstmt.setString(32, acctCodeDr); // acct_code__dr

							pstmt.setString(33, cctrCodeDr); // cctr_code__dr
							pstmt.setString(34, acctCodeCr); // acct_code__cr
							pstmt.setString(35, cctrCodeCr); // cctr_code__cr
							pstmt.setString(36, discountType); // discount_type
							pstmt.setString(37, suppCodeMnfr); // supp_code__mnfr
							pstmt.setString(38, orderOpt); // order_opt
							pstmt.setString(39, bom); // bom_code

							pstmt.setString(40, specificInstr); // specific_instr
							// pstmt.setDouble(41, clgRate); // rate__clg
							pstmt.setDouble(41, rateClg); // rate__clg Change
														  // from [clgRate] to
														  // [rateClg] VALLABH
														  // KADAM 17/NOV/14
							pstmt.setString(42, specialInstr); // special_instr
							pstmt.setString(43, benefitType); // benefit_type
							pstmt.setString(44, licenceNo); // licence_no
							pstmt.setString(45, dutyPaid); // duty_paid
							pstmt.setString(46, formNo); // form_no
							pstmt.setString(47, acctCodeApAdv);// Add column for
							   // insert VALLABH
							   // KADAM 19/NOV/14
							pstmt.setString(48, cctrCodeApAdv);// Add column for
							   // insert VALLABH
							   // KADAM 19/NOV/14
							cnt = pstmt.executeUpdate();
							pstmt.close();
							pstmt = null;

							/*
							 * sql =
							 * " insert into taxtran ( tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class,tax_chap,tax_base,tax_env,"
							 * +
							 * " taxable_amt,tax_perc,tax_amt,chg_stat,tax_set,effect,acct_code__reco,cctr_code__reco,reco_perc,reco_amount,"
							 * +
							 * " acct_code,cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,posted,tax_form_date,pay_tax  ) "
							 * +
							 * " select 'P-ORD',tran_id,line_no,line_no__tax,tax_code,tax_class,tax_chap,tax_base,tax_env,taxable_amt,"
							 * +
							 * " tax_perc,tax_amt,chg_stat,tax_set,effect,acct_code__reco,cctr_code__reco,reco_perc,reco_amount,acct_code,cctr_code,"
							 * +
							 * " rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,posted	,tax_form_date, pay_tax "
							 * +
							 * " from taxtran where tran_code = ?	and   tran_id = ? and 	line_no = ? "
							 * ; pstmt = conn.prepareStatement(sql);
							 * pstmt.setString(1, "P-AMD"); pstmt.setString(2,
							 * amdNo); pstmt.setString(3, lineNo); cnt =
							 * pstmt.executeUpdate(); pstmt.close(); pstmt =
							 * null; System.out.println("@@@@2 cnt["+cnt+"]");
							 */
							/**/{
								sql = " select line_no__tax,tax_code,"
							+ " tax_class,tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set,effect,"
										+ " acct_code__reco,cctr_code__reco,reco_perc,reco_amount,acct_code,cctr_code,rate_type,round,round_to," 
							+ " tax_form,chg_date,chg_user,chg_term,posted,tax_form_date,pay_tax "
										+ " from taxtran where tran_code = 'P-AMD' and   tran_id = ? and   line_no = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, amdNo);
								pstmt.setString(2, lineNo);
								rs = pstmt.executeQuery();
								// if (rs.next()) {
								while (rs.next())
								{ // Change from if to while VALLABH KADAM
								  // 19/NOV/14
									lineNoTax = rs.getString("line_no__tax");
									taxCode = rs.getString("tax_code");
									taxClass = rs.getString("tax_class");
									taxChap = rs.getString("tax_chap");
									taxBase = rs.getString("tax_base");
									taxEnv = rs.getString("tax_env");
									taxableAmt = rs.getDouble("taxable_amt");
									taxPerc = rs.getString("tax_perc");
									taxAmt = rs.getDouble("tax_amt");
									chgStat = rs.getString("chg_stat");
									taxSet = rs.getString("tax_set");
									effect = rs.getString("effect");
									acctCodeReco = rs.getString("acct_code__reco");
									cctrCodeReco = rs.getString("cctr_code__reco");
									recoPerc = rs.getString("reco_perc");
									recoAmont = rs.getDouble("reco_amount");
									acctCode = rs.getString("acct_code");
									cctrCode = rs.getString("cctr_code");
									rateType = rs.getString("rate_type");
									round = rs.getString("round");
									roundTo = rs.getString("round_to");
									taxForm = rs.getString("tax_form");
									chgDate = rs.getTimestamp("chg_date");
									chgUser = rs.getString("chg_user");
									chgTerm = rs.getString("chg_term");
									posted = rs.getString("posted");
									taxFormDate = rs.getTimestamp("tax_form_date");
									payTax = rs.getString("pay_tax");

									/** Insert taxtran rows */
									sql4 = " insert into taxtran (tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class," 
									+ " tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set	,	"
											+ " effect,acct_code__reco,	cctr_code__reco,reco_perc,reco_amount,acct_code,"
									+ "	cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,"
											+ "	posted,tax_form_date,pay_tax) "
									+ " values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ) ";
									pstmt4 = conn.prepareStatement(sql4);
									pstmt4.setString(1, "P-ORD");
									pstmt4.setString(2, purcOrder);
									pstmt4.setString(3, lineNoOrd); // lineNo
																	// change by
																	// cpatil on
																	// 17/10/13
									pstmt4.setString(4, lineNoTax);
									pstmt4.setString(5, taxCode);
									pstmt4.setString(6, taxClass);
									pstmt4.setString(7, taxChap);
									pstmt4.setString(8, taxBase);
									pstmt4.setString(9, taxEnv);
									pstmt4.setDouble(10, taxableAmt);
									pstmt4.setString(11, taxPerc);
									pstmt4.setDouble(12, taxAmt);
									pstmt4.setString(13, chgStat);
									pstmt4.setString(14, taxSet);
									pstmt4.setString(15, effect);
									pstmt4.setString(16, acctCodeReco);
									pstmt4.setString(17, cctrCodeReco);
									pstmt4.setString(18, recoPerc);
									pstmt4.setDouble(19, recoAmont);
									pstmt4.setString(20, acctCode);
									pstmt4.setString(21, cctrCode);
									pstmt4.setString(22, rateType);
									pstmt4.setString(23, round);
									pstmt4.setString(24, roundTo);
									pstmt4.setString(25, taxForm);
									pstmt4.setTimestamp(26, chgDate);
									pstmt4.setString(27, chgUser);
									pstmt4.setString(28, chgTerm);
									pstmt4.setString(29, posted);
									pstmt4.setTimestamp(30, taxFormDate);
									pstmt4.setString(31, payTax);

									cnt = pstmt4.executeUpdate();
									pstmt4.close();
									pstmt4 = null;

									/** Insert in taxtran rows END */
								}

								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								// sql =
								// " insert into taxtran (tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class,"
								// +
								// " tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set	,	"
								// +
								// " effect,acct_code__reco,	cctr_code__reco,reco_perc,reco_amount,acct_code,"
								// +
								// "	cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,"
								// + "	posted,tax_form_date,pay_tax) "
								// +
								// " values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ) ";
								// pstmt = conn.prepareStatement(sql);
								// pstmt.setString(1, "P-ORD");
								// pstmt.setString(2, purcOrder);
								// pstmt.setString(3, lineNoOrd); //lineNo
								// change by cpatil on 17/10/13
								// pstmt.setString(4, lineNoTax);
								// pstmt.setString(5, taxCode);
								// pstmt.setString(6, taxClass);
								// pstmt.setString(7, taxChap);
								// pstmt.setString(8, taxBase);
								// pstmt.setString(9, taxEnv);
								// pstmt.setDouble(10, taxableAmt);
								// pstmt.setString(11, taxPerc);
								// pstmt.setDouble(12, taxAmt);
								// pstmt.setString(13, chgStat);
								// pstmt.setString(14, taxSet);
								// pstmt.setString(15, effect);
								// pstmt.setString(16, acctCodeReco);
								// pstmt.setString(17, cctrCodeReco);
								// pstmt.setString(18, recoPerc);
								// pstmt.setDouble(19, recoAmont);
								// pstmt.setString(20, acctCode);
								// pstmt.setString(21, cctrCode);
								// pstmt.setString(22, rateType);
								// pstmt.setString(23, round);
								// pstmt.setString(24, roundTo);
								// pstmt.setString(25, taxForm);
								// pstmt.setTimestamp(26, chgDate);
								// pstmt.setString(27, chgUser);
								// pstmt.setString(28, chgTerm);
								// pstmt.setString(29, posted);
								// pstmt.setTimestamp(30, taxFormDate);
								// pstmt.setString(31, payTax);
								//
								// cnt = pstmt.executeUpdate();
								// pstmt.close();
								// pstmt = null;
								// System.out.println("@@@@2 cnt["+cnt+"]");

							} // end if
							/**/
						}

						rs3.close();
						rs3 = null;
						pstmt3.close();
						pstmt3 = null;
					} else
					{
						lineNo = "    " + lineNo;
						lineNo = lineNo.substring(lineNo.length() - 3, lineNo.length());
						
						
						sql = " select max(line_no)	 from porddet where purc_order = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrder);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							lineNoPO = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						System.out.println("@@@@@@lineNoPO1[" + lineNoPO + "]");

						if (lineNoPO == null)
						{
							lineNoPO = "0";
						}
						int tempId = (Integer.parseInt(lineNoPO.trim()) + 1);
						lineNoPO = "    " + tempId;
						lineNoPO = lineNoPO.substring(lineNoPO.length() - 3, lineNoPO.length());
						System.out.println("@@@@@@lineNoPO4[" + lineNoPO + "]");
						if (cctrCodeDr == null || cctrCodeDr.trim().length() == 0)
						{
							cctrCodeDr = " ";
						}

						if (cctrCodeCr == null || cctrCodeCr.trim().length() == 0)
						{
							cctrCodeCr = " ";
						}

						sql = " insert into porddet ( purc_order,line_no,site_code,ind_no,item_code,quantity,unit,rate,"
						+ "	discount,tax_amt,tot_amt,loc_code,req_date,dlv_date,dlv_qty,status,status_date,"
								+ " tax_class,tax_chap,tax_env,remarks,work_order,unit__rate,conv__qty_stduom,conv__rtuom_stduom,"
						+ "	unit__std,quantity__stduom,rate__stduom,pack_code,no_art,pack_instr,acct_code__dr,"
								+ " cctr_code__dr,acct_code__cr,cctr_code__cr,discount_type,supp_code__mnfr,order_opt,bom_code,"
						+ "	specific_instr,rate__clg,special_instr,benefit_type,licence_no,duty_paid,form_no,"
								+ "acct_code__ap_adv,cctr_code__ap_adv) " // Add
																																																																																																																																																										   // column
																																																																																																																																																										   // for
																																																																																																																																																										   // insert
																																																																																																																																																										   // VALLABH
																																																																																																																																																										   // KADAM
																																																																																																																																																										   // 19/NOV/14
						        + " values ( " + "?,?,?,?,?,?,?,?,?,?," 
								+ "?,?,?,?,?,?,?,?,?,?," 
						        + "?,?,?,?,?,?,?,?,?,?," 
								+ "?,?,?,?,?,?,?,?,?,?," 
						        + "?,?,?,?,?,?,?,? ) ";

						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrder);
						pstmt.setString(2, lineNoPO);
						pstmt.setString(3, siteCode);
						pstmt.setString(4, indNo);
						pstmt.setString(5, itemCode);
						pstmt.setDouble(6, quantity);
						pstmt.setString(7, unit);
						pstmt.setDouble(8, rate);
						pstmt.setDouble(9, discount);
						pstmt.setDouble(10, taxAmt);
						pstmt.setDouble(11, totAmt);
						pstmt.setString(12, locCode);
						pstmt.setTimestamp(13, reqDate);
						pstmt.setTimestamp(14, dlvDate);
						pstmt.setDouble(15, dlvQuantity);
						pstmt.setString(16, status);
						pstmt.setTimestamp(17, sysDate);
						pstmt.setString(18, taxClass);
						pstmt.setString(19, taxChap);
						pstmt.setString(20, taxEnv);
						pstmt.setString(21, remarks);
						pstmt.setString(22, workOrder);
						pstmt.setString(23, unitRate);
						pstmt.setDouble(24, convQtyStduom);
						pstmt.setDouble(25, convRtuomStduom);
						pstmt.setString(26, UnitStd);
						pstmt.setDouble(27, quantityStduom);
						pstmt.setDouble(28, rateStduom);
						pstmt.setString(29, packCode);
						pstmt.setDouble(30, noArt);
						pstmt.setString(31, packInstr);
						pstmt.setString(32, acctCodeDr);
						pstmt.setString(33, cctrCodeDr);
						pstmt.setString(34, acctCodeCr);
						pstmt.setString(35, cctrCodeCr);
						pstmt.setString(36, discountType);
						pstmt.setString(37, suppCodeMnfr);
						pstmt.setString(38, orderOpt);
						pstmt.setString(39, bom); // bom_code
						pstmt.setString(40, specificInstr);
						// pstmt.setDouble(41, clgRate);
						pstmt.setDouble(41, rateClg); // Change from clgRate to
													  // rateClg VALLABH KADAM
													  // 17/NOV/14
						pstmt.setString(42, specialInstr);
						pstmt.setString(43, benefitType);
						pstmt.setString(44, licenceNo);
						pstmt.setString(45, dutyPaid);
						pstmt.setString(46, formNo);
						pstmt.setString(47, acctCodeApAdv);// Add column for
														   // insert VALLABH
														   // KADAM 19/NOV/14
						pstmt.setString(48, cctrCodeApAdv);// Add column for
														   // insert VALLABH
														   // KADAM 19/NOV/14
						cnt = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;

//						if (cnt == 0)
							if (cnt > 0)   //Change condtion from if (cnt == 0) to if (cnt > 0) VALLABH KADAM 20/NOV/14  
						{
							/*
							 * sql =
							 * " insert into taxtran ( tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class,tax_chap,tax_base,tax_env,"
							 * +
							 * " taxable_amt,tax_perc,tax_amt,chg_stat,tax_set,effect,acct_code__reco,cctr_code__reco,reco_perc,reco_amount,"
							 * +
							 * " acct_code,cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,posted,tax_form_date,pay_tax  ) "
							 * +
							 * " select 'P-ORD' ,tran_id,line_no,line_no__tax,tax_code,tax_class,tax_chap,tax_base,tax_env,taxable_amt,"
							 * +
							 * " tax_perc,tax_amt,chg_stat,tax_set,effect,acct_code__reco,cctr_code__reco,reco_perc,reco_amount,acct_code,cctr_code,"
							 * +
							 * " rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,posted	,tax_form_date, pay_tax "
							 * +
							 * " from taxtran where tran_code = ?	and   tran_id = ? and 	line_no = ? "
							 * ; pstmt = conn.prepareStatement(sql);
							 * pstmt.setString(1, "P-AMD"); pstmt.setString(2,
							 * amdNo); pstmt.setString(3, lineNo); cnt =
							 * pstmt.executeUpdate(); pstmt.close(); pstmt =
							 * null; System.out.println("@@@@3 cnt["+cnt+"]");
							 *//**/
							sql = " select line_no__tax,tax_code,"
							 + " tax_class,tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set,effect,"
									+ " acct_code__reco,cctr_code__reco,reco_perc,reco_amount,acct_code,cctr_code,rate_type,round,round_to,"
							 + " tax_form,chg_date,chg_user,chg_term,posted,tax_form_date,pay_tax "
									+ " from taxtran where tran_code = ?  and   tran_id = ? and   line_no = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "P-AMD");
							pstmt.setString(2, amdNo);
							pstmt.setString(3, lineNo);
							rs = pstmt.executeQuery();
//							if (rs.next())
							while (rs.next())   // Change from if to while VALLABH KADAM 19/NOV/14
							{
								lineNoTax = rs.getString("line_no__tax");
								taxCode = rs.getString("tax_code");
								taxClass = rs.getString("tax_class");
								taxChap = rs.getString("tax_chap");
								taxBase = rs.getString("tax_base");
								taxEnv = rs.getString("tax_env");
								taxableAmt = rs.getDouble("taxable_amt");
								taxPerc = rs.getString("tax_perc");
								taxAmt = rs.getDouble("tax_amt");
								chgStat = rs.getString("chg_stat");
								taxSet = rs.getString("tax_set");
								effect = rs.getString("effect");
								acctCodeReco = rs.getString("acct_code__reco");
								cctrCodeReco = rs.getString("cctr_code__reco");
								recoPerc = rs.getString("reco_perc");
								recoAmont = rs.getDouble("reco_amount");
								acctCode = rs.getString("acct_code");
								cctrCode = rs.getString("cctr_code");
								rateType = rs.getString("rate_type");
								round = rs.getString("round");
								roundTo = rs.getString("round_to");
								taxForm = rs.getString("tax_form");
								chgDate = rs.getTimestamp("chg_date");
								chgUser = rs.getString("chg_user");
								chgTerm = rs.getString("chg_term");
								posted = rs.getString("posted");
								taxFormDate = rs.getTimestamp("tax_form_date");
								payTax = rs.getString("pay_tax");
								
								/** Insert tax tran row */
								sql4 = " insert into taxtran (tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class,"
										+ " tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set	,	"
												+ " effect,acct_code__reco,	cctr_code__reco,reco_perc,reco_amount,acct_code," 
										+ "	cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,"
												+ "	posted,tax_form_date,pay_tax) "
										+ " values ("
												+ " ?,?,?,?,?,?,?,?,?,?," 
										+ " ?,?,?,?,?,?,?,?,?,?," 
												+ " ?,?,?,?,?,?,?,?,?,?," 
										+ " ? ) ";
										pstmt4 = conn.prepareStatement(sql4);
										pstmt4.setString(1, "P-ORD");
										pstmt4.setString(2, purcOrder);
//										pstmt4.setString(3, lineNoOrd); // lineNo change bycpatil on 17/10/13
										pstmt4.setString(3, lineNoPO); // Chanfe from lineNoOrd to lineNoPO VALLABH KADAM 20/NOV/14 
										pstmt4.setString(4, lineNoTax);
										pstmt4.setString(5, taxCode);
										pstmt4.setString(6, taxClass);
										pstmt4.setString(7, taxChap);
										pstmt4.setString(8, taxBase);
										pstmt4.setString(9, taxEnv);
										pstmt4.setDouble(10, taxableAmt);
										pstmt4.setString(11, taxPerc);
										pstmt4.setDouble(12, taxAmt);
										pstmt4.setString(13, chgStat);
										pstmt4.setString(14, taxSet);
										pstmt4.setString(15, effect);
										pstmt4.setString(16, acctCodeReco);
										pstmt4.setString(17, cctrCodeReco);
										pstmt4.setString(18, recoPerc);
										pstmt4.setDouble(19, recoAmont);
										pstmt4.setString(20, acctCode);
										pstmt4.setString(21, cctrCode);
										pstmt4.setString(22, rateType);
										pstmt4.setString(23, round);
										pstmt4.setString(24, roundTo);
										pstmt4.setString(25, taxForm);
										pstmt4.setTimestamp(26, chgDate);
										pstmt4.setString(27, chgUser);
										pstmt4.setString(28, chgTerm);
										pstmt4.setString(29, posted);
										pstmt4.setTimestamp(30, taxFormDate);
										pstmt4.setString(31, payTax);

										cnt = pstmt4.executeUpdate();
										pstmt4.close();
										pstmt4 = null;
										/** Insert tax tran row END */
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

//							sql = " insert into taxtran (tran_code,tran_id,line_no,line_no__tax,tax_code,tax_class,"
//							+ " tax_chap,tax_base,tax_env,taxable_amt,tax_perc,tax_amt,chg_stat,tax_set	,	"
//									+ " effect,acct_code__reco,	cctr_code__reco,reco_perc,reco_amount,acct_code," 
//							+ "	cctr_code,rate_type,round,round_to,tax_form,chg_date,chg_user,chg_term,"
//									+ "	posted,tax_form_date,pay_tax) "
//							+ " values ("
//									+ " ?,?,?,?,?,?,?,?,?,?," 
//							+ " ?,?,?,?,?,?,?,?,?,?," 
//									+ " ?,?,?,?,?,?,?,?,?,?," 
//							+ " ? ) ";
//							pstmt = conn.prepareStatement(sql);
//							pstmt.setString(1, "P-ORD");
//							pstmt.setString(2, purcOrder);
//							pstmt.setString(3, lineNoOrd); // lineNo change by
//														   // cpatil on 17/10/13
//							pstmt.setString(4, lineNoTax);
//							pstmt.setString(5, taxCode);
//							pstmt.setString(6, taxClass);
//							pstmt.setString(7, taxChap);
//							pstmt.setString(8, taxBase);
//							pstmt.setString(9, taxEnv);
//							pstmt.setDouble(10, taxableAmt);
//							pstmt.setString(11, taxPerc);
//							pstmt.setDouble(12, taxAmt);
//							pstmt.setString(13, chgStat);
//							pstmt.setString(14, taxSet);
//							pstmt.setString(15, effect);
//							pstmt.setString(16, acctCodeReco);
//							pstmt.setString(17, cctrCodeReco);
//							pstmt.setString(18, recoPerc);
//							pstmt.setDouble(19, recoAmont);
//							pstmt.setString(20, acctCode);
//							pstmt.setString(21, cctrCode);
//							pstmt.setString(22, rateType);
//							pstmt.setString(23, round);
//							pstmt.setString(24, roundTo);
//							pstmt.setString(25, taxForm);
//							pstmt.setTimestamp(26, chgDate);
//							pstmt.setString(27, chgUser);
//							pstmt.setString(28, chgTerm);
//							pstmt.setString(29, posted);
//							pstmt.setTimestamp(30, taxFormDate);
//							pstmt.setString(31, payTax);
//
//							cnt = pstmt.executeUpdate();
//							pstmt.close();
//							pstmt = null;
							System.out.println("@@@@3 cnt[" + cnt + "]");
							/*					*/
							sql = "	update poamd_det set line_no__ord = ?  where amd_no  = ? and line_no = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, lineNoPO);
							pstmt.setString(2, amdNo);
							pstmt.setString(3, lineNo);
							updCnt = pstmt.executeUpdate();
							pstmt.close();
							pstmt = null;

							if (!(updCnt == 1))
							{
								errCode = "VTAMDDT";
								//errCode = itmDBAccessLocal.getErrorString("", errCode, "");EEE
								errCode = getError(purcOrder, lineNo , errCode, conn);
								return errCode;
							}
						}
					}
				} // end while
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
			}
			if (errCode == null || errCode.trim().length() == 0)
			{
				int cntTerm = 0;
				sql = " select count(1) from poamd_term where amd_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, amdNo);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					cntTerm = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				System.out.println("@@@@@@@@@trem cntTerm:[" + cntTerm + "]");
				if (cntTerm > 0)
				{
					sql = " select max(line_no) from  pord_term where purc_order = ?  ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						lastTermLine = rs.getString(1) == null ? "0" : rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					System.out.println("@@@@@@@@@trem lastTermLine:[" + lastTermLine + "]");
					// for (int i = 1; i < Integer.parseInt(lastTermLine); i++)
					for (int i = 1; i <= cntTerm; i++)
					{
						System.out.println("@@@@@@@@@term for Line:[" + i + "]::lineNo[" + lineNo + "]");
						// 31/10/13 manoharan print_opt added
						sql = " select purc_order,line_no_ord,term_code,descr, print_opt from poamd_term where amd_no = ? and line_no = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, amdNo);
						// pstmt.setString(2, lineNo);
						pstmt.setString(2, "" + i);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							purcOrder = rs.getString("purc_order");
							lineNoPO = rs.getString("line_no_ord");
							termCode = rs.getString("term_code");
							descr = rs.getString("descr");
							printOpt = rs.getString("print_opt");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						System.out.println("@@@@@@@@@trem lineNoPO:[" + lineNoPO + "]");
						if (lineNoPO == null || lineNoPO.trim().length() == 0)
						{
							System.out.println("@@@@@@@@@trem insert executed.... lineNoPO:[" + lineNoPO + "]");
							int temp = Integer.parseInt(lastTermLine) + 1;
							lastTermLine = "" + temp;

							lineNoPO = lastTermLine;

							sql = " insert into pord_term ( purc_order, line_no, term_code, descr , print_opt) values (?,?,?,?, ?) ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, purcOrder);
							pstmt.setString(2, lineNoPO);
							pstmt.setString(3, termCode);
							pstmt.setString(4, descr);
							pstmt.setString(5, printOpt);

							cnt = pstmt.executeUpdate();
							pstmt.close();
							pstmt = null;

						} else
						{
							System.out.println("@@@@@@@@@trem update executed.... lineNoPO:[" + lineNoPO + "]");
							sql = "	update pord_term set term_code = ?, descr = ?, print_opt = ?  where purc_order = ? and   line_no = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, termCode);
							pstmt.setString(2, descr);
							pstmt.setString(3, printOpt);
							pstmt.setString(4, purcOrder);
							pstmt.setString(5, lineNoPO);
							updCnt = pstmt.executeUpdate();
							pstmt.close();
							pstmt = null;
							if (!(updCnt == 1))
							{
								errCode = "VTORDTERM";
								//errCode = itmDBAccessLocal.getErrorString("", errCode, "");EEE
								errCode = getError(purcOrder, lineNoPO , errCode, conn);
								return errCode;
							}
						}
					}
				}
			}

			if (errCode == null || errCode.trim().length() == 0)
			{

				sql = " select sum(case when tax_amt is null then 0 else tax_amt end), sum(case when tot_amt is null then 0 else tot_amt end), " 
				+ " sum(case when tot_amt is null then 0 else tot_amt end  - case when tax_amt is null then 0 else tax_amt end) "
						+ " from  porddet where purc_order = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, purcOrder);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					taxAmtS = rs.getDouble(1);
					totAmtS = rs.getDouble(2);
					ordAmtS = rs.getDouble(3);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if (errCode == null || errCode.trim().length() == 0)
				{
					sql = "	select sum(case when net_amt is null then 0 else net_amt end)  from	voucher where purc_order = ? " 
				+ " and	vouch_type = ? and confirmed  = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					pstmt.setString(2, "A");
					pstmt.setString(3, "Y");
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						vouchAmt = rs.getDouble(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					if (totAmtS < vouchAmt)
					{
						errCode = "ORDLESSVCH";
						//errCode = itmDBAccessLocal.getErrorString("", errCode, "");EEE
						errCode = getError(purcOrder, "" , errCode, conn);
						return errCode;
					}
				}

			}

			if (errCode == null || errCode.trim().length() == 0)
			{
				sql = " select count(1) from porder where purc_order = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, purcOrder);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					cnt = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				// 31/10/13 manoharan emp_code__aprv should not be changed to
				// amendment approver
				if (cnt > 0)
				{
					sql = " update porder set amd_no = ?, amd_date=?, site_code__dlv=?, site_code__ord=?,site_code__bill=?,dept_code=?,"
				+ "supp_code=?,emp_code=?,item_ser=?,tax_opt=?,cr_term=?,ord_amt=?,tax_amt=?,tot_amt=?,curr_code=?,exch_rate=?,"
							+ "tax_chap=?,tax_class=?,tax_env=?,remarks=?,tax_date=?,proj_code=?,sales_pers=?,comm_perc=?,comm_perc__on=?,"
				+ "curr_code__comm=?,quot_no=?,tran_code=?,frt_amt=?,curr_code__frt=?,frt_term=?,dlv_term=?,insurance_amt	=?,"
							+ "curr_code__ins	=?,ref_date=?,advance=?, " + "frt_type = ?, frt_rate=?, frt_amt__qty=? , frt_amt__fixed = ? "
				+ " where purc_order = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, amdNo);
					pstmt.setTimestamp(2, amdDate);
					pstmt.setString(3, siteCodeDlv);
					pstmt.setString(4, siteCodeOrd);
					pstmt.setString(5, siteCodeBill);
					pstmt.setString(6, deptCode);
					pstmt.setString(7, suppCode);
					pstmt.setString(8, empCode);
					pstmt.setString(9, itemSer);
					pstmt.setString(10, taxOpt);
					pstmt.setString(11, crTerm);
					pstmt.setDouble(12, ordAmtS);
					pstmt.setDouble(13, taxAmtS);
					pstmt.setDouble(14, totAmtS);
					pstmt.setString(15, currCode);
					pstmt.setDouble(16, exchRate);
					pstmt.setString(17, taxChapHdr);
					pstmt.setString(18, taxClassHdr);
					pstmt.setString(19, taxEnvHdr);
					pstmt.setString(20, remarks);
					pstmt.setTimestamp(21, taxDate);
					pstmt.setString(22, projCode);
					pstmt.setString(23, salesPers);
					pstmt.setString(24, commPerc);
					pstmt.setString(25, commPercOn);
					pstmt.setString(26, currCodeComm);
					pstmt.setString(27, quotNo);
					pstmt.setString(28, tranCode);
					pstmt.setDouble(29, frtAmt);
					pstmt.setString(30, currCodeFrt);
					pstmt.setString(31, frtTerm);
					pstmt.setString(32, dlvTerm);
					pstmt.setDouble(33, insuranceAmt);
					pstmt.setString(34, currCodeIns);
					// pstmt.setString(35, empCodeAprv);
					pstmt.setTimestamp(35, refDate);
					pstmt.setString(36, advance);
					pstmt.setString(37, frtType);
					pstmt.setDouble(38, frtRate);
					pstmt.setDouble(39, frtAmtQty);
					pstmt.setDouble(40, frtAmtFixed);
					pstmt.setString(41, purcOrder);
					updCnt = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;

				} else
				{
					errCode = "VTPORD1";
					//errCode = itmDBAccessLocal.getErrorString("", errCode, "");EEE
					errCode = getError(purcOrder, "" , errCode, conn);
					return errCode;
				}

				if (updCnt > 0)
				{
					double updFrtAmtQty = 0;
					System.out.println("@@@@@@@@ for cross update into java.....");

					sql = " select frt_type, frt_rate, frt_amt__qty, frt_amt__fixed from porder	where purc_order = ?	 ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						frtType = rs.getString("frt_type");
						frtRate = rs.getDouble("frt_rate");
						frtAmtQty = rs.getDouble("frt_amt__qty");
						frtAmtFixed = rs.getDouble("frt_amt__fixed");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					System.out.println("@@@@frtType[" + frtType + "]frtRate[" + frtRate + "]frtAmtQty[" + frtAmtQty + "]frtAmtFixed[" + frtAmtFixed + "]");

					if ("F".equalsIgnoreCase(frtType))
					{
						sql = "	update porder set frt_amt__fixed = ? ,frt_amt = ? ,frt_amt__qty = 0  where purc_order = ?  ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setDouble(1, (frtAmtFixed + frtAmtQty));
						pstmt.setDouble(2, (frtAmtFixed + frtAmtQty));
						pstmt.setString(3, purcOrder);
						updCnt = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;

					} else if ("Q".equalsIgnoreCase(frtType))
					{
						sql = " select quantity from porddet where purc_order = ?	 ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrder);
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							quantity = rs.getDouble("quantity");
							updFrtAmtQty = updFrtAmtQty + (quantity * frtRate);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("@@@@@updFrtAmtQty[" + updFrtAmtQty + "]");
						sql = "	update porder set frt_amt__qty = ? , frt_amt= ? , frt_amt__fixed = 0   where purc_order = ?  ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setDouble(1, updFrtAmtQty);
						pstmt.setDouble(2, updFrtAmtQty);
						pstmt.setString(3, purcOrder);
						updCnt = pstmt.executeUpdate();
						pstmt.close();
						pstmt = null;

					}

				}
			}

			// } for test
		} // end try
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}

		return errCode;
	}
	private String checknull(String string)
	{
		if (string == null)
		{
			string = "";
		}
		return string;
	}

	private String setDescription(String descr, String table, String field, String value, Connection conn) throws SQLException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		System.out.println("@@@@@@@@table[" + table + "]:::field[" + field + "]::value[" + value + "]");
		sql = "select " + descr + " from " + table + " where " + field + " = ? ";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, value);
		rs = pstmt.executeQuery();
		if (rs.next())
		{
			descr = checknull(rs.getString(1));
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;
		System.out.print("::descr[" + descr);
		return descr;
	}
	
	public  String getError(String purcOrder,String lineNo, String Code,Connection conn)  throws ITMException, Exception
    {
        String mainStr ="";
        
        try
        {
        	String errString = "";
        	errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+"Invalid Data"+"</message><description>";
			//mainStr= mainStr+"Purchase Order ["+purcOrder+":"+lineNo+":"+Code+"]";
			mainStr= mainStr+"Purchase Order ["+purcOrder+":"+lineNo+""+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
        }
        catch(Exception e)
        {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return mainStr;
    }
	/****************Confirm Component End****************/

	
	
}
