package ibase.webitm.ejb.fin;


import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.ejb.Stateless; // added for ejb3

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class AssetSales extends ValidatorEJB implements AssetSalesLocal,AssetSalesRemote
{
//	GenericUtility genericUtility = GenericUtility.getInstance();
	E12GenericUtility genericUtility = new E12GenericUtility();
    FinCommon finCommon = new FinCommon();
	public String wfValData(String xmlString, String xmlString1, String xmlString2,String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("------------@ wfvalData method called-----------------");
		System.out.println("Xml String : ["+xmlString+"]");
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception : AssetSales.java : wfValData(String xmlString) : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		
		return errString;
	}

	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0;
		String childNodeName = null;
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		String sql = "";
		String userId="",siteCode = "",errCode="",itemser="",pricelist="",reasCode="",remarks="",amtOld="",cctrCodeInv="",cctrCodeInvrev="";
		String tranId = "",keyFlag="",effDate="",itemCode="",locCode="",lotNo="",lotSl="",quantity="",acctCodeInv="",acctCodeInvrev="";
		double conquan,getquan = 0;
		int cnt=0;
		int cnt1=0;
		int currentFormNo=0;
		int childNodeListLength;
		String oRate="",tranType="",assetCode="",custCode="",currCode="",taxClass="",taxchat="",taxChap="",acctCdAr="",acctCdMd="",cctrCdAr="",cctrCdMd="",taxEnv="";
		String acctCdPl="",acctCdLo="",cctrCdPl="",cctrCdLo="";
		double rate =0,saleAmt=0,taxAmt=0;
		String saleamt = "", taxamt ="";
		String prdCode="",statFin="";
		Timestamp tranDateTs=null;
		String tranDateStr = "",siteCodeFor="";
		String siteCodlogin="";
		
		String oldRate="",AmtRate="",oldAmtRate="";
		double conoldate= 0.0,highval = 0.0,conAmtdate=0.0,conolAmtdate=0.0;
		
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("user ID form XtraParam : "+userId);
			siteCodlogin =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					 if(childNodeName.equalsIgnoreCase("tran_date"))
					{
						tranDateStr = genericUtility.getColumnValue("tran_date",dom);
						tranDateTs = Timestamp.valueOf(genericUtility.getValidDateString(tranDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");
						if (tranDateStr == null || tranDateStr.trim().length() == 0 )
						{
							errCode = "";
							errString = getErrorString("tran_date",errCode,userId);
							break;
						}
						siteCode = genericUtility.getColumnValue("site_code", dom);
			          
						sql = "Select code from period where ? between fr_date and to_date ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, tranDateTs);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							prdCode = rs.getString("code");
							System.out.println("Period Code>>>>>>"+prdCode);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						if (prdCode != null && prdCode.trim().length() > 0) 
						{
							sql = "Select count(1) from period_stat where prd_code = ? "
									+ " AND site_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, prdCode.trim());
							pstmt.setString(2, siteCodlogin.trim());
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								cnt = rs.getInt(1);
								System.out.println("Count for prdCode>>>>>>>>>>"+cnt);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if (cnt > 0) 
							{
								sql = "Select stat_fin from period_stat where prd_code = ? and site_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, prdCode.trim());
								pstmt.setString(2, siteCodlogin.trim());
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									statFin = rs.getString("stat_fin");
									System.out.println("Status Fin>>>>>>>"+statFin);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								//if(statFin != null && statFin.equalsIgnoreCase("N"))
								if(statFin != null && "N".equalsIgnoreCase(statFin))
								{																		
									errCode = "VTPRDFIN";
									errString = getErrorString("tran_date",errCode,userId);
									break;
									
								}
							} 
							else 
							{
								errCode = "VMSTATSND";
								errString = getErrorString("tran_date",errCode,userId);
								break;
							}
						} 
						else 
						{
							errCode = "VMPRDNTDF";
							errString = getErrorString("tran_date",errCode,userId);
							break;
						}
					}
					
					else if(childNodeName.equalsIgnoreCase("tran_type"))
					{

						tranType = genericUtility.getColumnValue("tran_type",dom);
						if (tranType == null || tranType.trim().length() == 0 )
						{
							errCode = "VTTRANTYPE";
							errString = getErrorString("tran_type",errCode,userId);
							break;
						}
					
					}
				
					else if(childNodeName.equalsIgnoreCase("cust_code"))
					{

						custCode = genericUtility.getColumnValue("cust_code",dom);
						if (custCode == null || custCode.trim().length() == 0 )
						{
							System.out.println("cust code");
							errCode = "VTCUST1";
							errString = getErrorString("cust_code",errCode,userId);
							break;
						}else
						{

                            sql = "select count(1) from customer where cust_code = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,custCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VTCUSTCD1";
								errString = getErrorString("cust_code",errCode,userId);
								break;
							}
						
						
						}
					
					}
					
					else if(childNodeName.equalsIgnoreCase("curr_code"))
					{

						currCode = genericUtility.getColumnValue("curr_code",dom);
						if (currCode == null || currCode.trim().length() == 0 )
						{
							errCode = "CURRCODBL";
							errString = getErrorString("curr_code",errCode,userId);
							break;
						}
						else
						{



							sql = "select count(1) from currency where curr_code = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,currCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VTCURRCD1";
								errString = getErrorString("curr_code",errCode,userId);
								break;
							}
						
						
						
						}
					
					}
					
					else if(childNodeName.equalsIgnoreCase("tax_class"))
					{
                           taxClass = checkNull(genericUtility.getColumnValue("tax_class",dom));
                           if(taxClass != null && taxClass.length()> 0)
                           {
                            sql = "select count(1) from taxclass where tax_class = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,taxClass);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VMTACLA1";
								errString = getErrorString("tax_class",errCode,userId);
								break;
							}
                           }
						
					}
					else if(childNodeName.equalsIgnoreCase("tax_chap"))
					{
                            taxChap = checkNull(genericUtility.getColumnValue("tax_chap",dom));
                            if(taxChap != null && taxChap.length()>0)
                            {
                            sql = "select count(1) from taxchap where tax_chap = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,taxChap);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VMTACHA1";
								errString = getErrorString("tax_chap",errCode,userId);
								break;
							}
                          }
					}
					
					else if(childNodeName.equalsIgnoreCase("tax_env"))
					{
                            taxEnv = checkNull(genericUtility.getColumnValue("tax_env",dom));
                            if(  taxEnv!= null && taxEnv.length() > 0 )
                            {
                            sql = "select count(1) from taxenv where tax_env = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,taxEnv);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							if(cnt == 0)
							{
								errCode = "VMTAENV1";
								errString = getErrorString("tax_env",errCode,userId);
								break;
							}
                           }
                            
					}
					
					else if(childNodeName.equalsIgnoreCase("sale_amt"))
					{
						saleamt= checkNull(genericUtility.getColumnValue("sale_amt",dom));
						System.out.println("Sale AMount"+saleamt);
						saleamt=saleamt != null && saleamt.trim().length() > 0 ? saleamt.trim() : "0";
						saleAmt= Double.parseDouble(saleamt);
						System.out.println("Sale amount parse double "+saleAmt);
						if(saleAmt < 0)
						{
							errCode = "VTSLAMT";
							errString = getErrorString("sale_amt",errCode,userId);        // Sale amount can not be less than 0
							break;
							
						}
					
					
					}
				
					else if(childNodeName.equalsIgnoreCase("tax_amt"))
					{
                         taxamt= checkNull(genericUtility.getColumnValue("tax_amt", dom));
                         System.out.println("TAx Amount is "+taxamt);
                         taxamt = taxamt !=null && taxamt.trim().length() >0 ?taxamt.trim() : "0";
						taxAmt = Double.parseDouble(taxamt);
						System.out.println("TAx Amount parse double is "+taxAmt);
						if(taxAmt < 0)
						{
							errCode = "VTTAXAMT";
							errString = getErrorString("tax_amt",errCode,userId);       
							break;
						}
					
					
					}
					
					
					
				}
				
				break;
			    case 2:
			    	
			    	parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						System.out.println("value of child node : "+childNode);
						
						if(childNodeName.equalsIgnoreCase("asset_code"))
						{
							assetCode = genericUtility.getColumnValue("asset_code",dom);
							if (assetCode == null || assetCode.trim().length() == 0 )
							{
								errCode = "VTASCODNUL";
								errString = getErrorString("asset_code",errCode,userId);
								break;
							}else
							{
								sql = "select count(1) from asset_register where asset_code = ? ";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,assetCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								System.out.println("Blank Asset COde COunt>>>>"+cnt);
								if(cnt == 0)
								{
									errCode = "VMASSET1";
									errString = getErrorString("asset_code",errCode,userId);
									break;
								}
								
								sql = "select count(1) from asset_register where asset_code = ? and status= ?";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,assetCode);
								pstmt.setString(2,"S");
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt1 = rs.getInt(1);
								}
								System.out.println("Sale Asset Status Count>>>>>"+cnt1);
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								if(cnt1> 0)
								{
									errCode = "VTASSCODES";
									errString = getErrorString("asset_code",errCode,userId);
									break;
								}
							
							
							}
						
						}
						
						else if(childNodeName.equalsIgnoreCase("sale_amt"))
						{

							
							
						String	saleAmts = genericUtility.getColumnValue("sale_amt",dom);

							if(saleAmts == null || saleAmts.trim().length() == 0)
							{
								saleAmt = 0;
							}else
							{
								saleAmt = Double.parseDouble(genericUtility.getColumnValue("sale_amt",dom));
							}
							
							if(saleAmt <= 0)
							{
								errCode = "VTSLAMT";
								errString = getErrorString("sale_amt",errCode,userId);        // Sale amount can not be less than 0
								break;
								
							}
						
						
						}
						
						else if(childNodeName.equalsIgnoreCase("tax_amt"))
						{

							String	taxAmts = genericUtility.getColumnValue("tax_amt",dom);

							if(taxAmts == null || taxAmts.trim().length() == 0)
							{
								taxAmt = 0;
							}else
							{
								taxAmt = Double.parseDouble(genericUtility.getColumnValue("tax_amt",dom));
							}
							
							if(taxAmt < 0)
							{
								errCode = "VTTAXAMT";
								errString = getErrorString("tax_amt",errCode,userId);       
								break;
								
							}
						
						
						}
						
						else if(childNodeName.equalsIgnoreCase("acct_code__ar"))
						{
	                            acctCdAr = genericUtility.getColumnValue("acct_code__ar",dom);
	                           
	                            if (acctCdAr == null || acctCdAr.trim().length() == 0 )
	    						{
	    							errCode = "";
	    							errString = getErrorString("acct_code__ar",errCode,userId);
	    							break;
	    						}
	    						else
	    						{



	    							sql = "select count(1) from accounts where acct_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,acctCdAr);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VMACCTCDX ";
	    								errString = getErrorString("acct_code__ar",errCode,userId);
	    								break;
	    							}
	    						
	    						
	    						
	    						}
	                            
						}
						
						else if(childNodeName.equalsIgnoreCase("cctr_code__ar"))
						{
	                            cctrCdAr = genericUtility.getColumnValue("cctr_code__ar",dom);
	                           
	                            if (cctrCdAr == null || cctrCdAr.trim().length() == 0 )
	    						{
	    							errCode = "";
	    							errString = getErrorString("cctr_code__ar",errCode,userId);
	    							break;
	    						}
	    						else
	    						{



	    							sql = "select count(1) from costctr where cctr_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,cctrCdAr);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VMACCTCDX ";
	    								errString = getErrorString("cctr_code__ar",errCode,userId);
	    								break;
	    							}
	    						
	    						
	    						
	    						}
	                            
						}
						/*else if(childNodeName.equalsIgnoreCase("acct_code__mod"))
						{
	                            acctCdMd = genericUtility.getColumnValue("acct_code__mod",dom);
	                           
	                            if (acctCdMd == null || acctCdMd.trim().length() == 0 )
	    						{
	    							errCode = "";
	    							errString = getErrorString("acct_code__mod",errCode,userId);
	    							break;
	    						}
	    						else
	    						{



	    							sql = "select count(1) from accounts where acct_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,acctCdMd);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VTACCTCDMD";
	    								errString = getErrorString("acct_code__mod",errCode,userId);
	    								break;
	    							}
	    						
	    						
	    						
	    						}
	                            
						}
						
						else if(childNodeName.equalsIgnoreCase("cctr_code__mod"))
						{
	                            cctrCdMd = genericUtility.getColumnValue("cctr_code__mod",dom);
	                           
	                            if (cctrCdMd == null || cctrCdMd.trim().length() == 0 )
	    						{
	    							errCode = "";
	    							errString = getErrorString("cctr_code__mod",errCode,userId);
	    							break;
	    						}
	    						else
	    						{



	    							sql = "select count(1) from costctr where cctr_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,cctrCdMd);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "";
	    								errString = getErrorString("cctr_code__mod",errCode,userId);
	    								break;
	    							}
	    						
	    						
	    						
	    						}
	                            
						}*/
					// case "acct_code__pl","acct_code__loss"
					
						
						else if(childNodeName.equalsIgnoreCase("acct_code__pl") 
								|| childNodeName.equalsIgnoreCase("acct_code__loss"))
						{
							
							 acctCdPl = genericUtility.getColumnValue("acct_code__pl",dom);
							 acctCdLo = genericUtility.getColumnValue("acct_code__loss",dom);
							 
							 if(acctCdPl == null || acctCdPl == "")
							 {
								 acctCdPl = " ";
							 }
							 else if (acctCdLo == null || acctCdLo == "") 
							 {
								 acctCdLo = " ";
							 }
							
							 if (acctCdPl == null || acctCdPl.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("acct_code__pl",errCode,userId);
	    							break;
	    						}
							 
							 else
							 {
								 sql = "select count(1) from accounts where acct_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,acctCdPl);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VMACCTCDX";
	    								errString = getErrorString("acct_code__pl",errCode,userId);
	    								break;
	    							}
							 }
							 
							 if (acctCdLo == null || acctCdLo.trim().length() == 0 )
	    						{
	    							errCode = "";
	    							errString = getErrorString("acct_code__loss",errCode,userId);
	    							break;
	    						}
							 
							 else
							 { 
						    sql = "select count(1) from accounts where acct_code = ?";
 							pstmt=conn.prepareStatement(sql);
 							pstmt.setString(1,acctCdLo);
 							rs = pstmt.executeQuery();
 							if(rs.next())
 							{
 								cnt = rs.getInt(1);
 							}
 							pstmt.close();
 							rs.close();
 							pstmt = null;
 							rs = null;
 							if(cnt == 0)
 							{
 								errCode = "VMACCTCDX";
 								errString = getErrorString("acct_code__loss",errCode,userId);
 								break;
 							}}
							 
						}
						
						else if(childNodeName.equalsIgnoreCase("cctr_code__pl") 
								|| childNodeName.equalsIgnoreCase("cctr_code__loss"))
						{
							
							 cctrCdPl = genericUtility.getColumnValue("cctr_code__pl",dom);
							 cctrCdLo = genericUtility.getColumnValue("cctr_code__loss",dom);
							 
							 if(cctrCdPl == null || cctrCdPl == "")
							 {
								 cctrCdPl = " ";
							 }
							 else if (cctrCdLo == null || cctrCdLo == "") 
							 {
								 cctrCdLo = " ";
							 }
							
							 if (cctrCdPl == null || cctrCdPl.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("cctr_code__pl",errCode,userId);
	    							break;
	    						}
							 
							 else
							 {
								 sql = "select count(1) from costctr where cctr_code = ?";
	    							pstmt=conn.prepareStatement(sql);
	    							pstmt.setString(1,cctrCdPl);
	    							rs = pstmt.executeQuery();
	    							if(rs.next())
	    							{
	    								cnt = rs.getInt(1);
	    							}
	    							pstmt.close();
	    							rs.close();
	    							pstmt = null;
	    							rs = null;
	    							if(cnt == 0)
	    							{
	    								errCode = "VMACCTCDX";
	    								errString = getErrorString("cctr_code__pl",errCode,userId);
	    								break;
	    							}
							 }
							 
							 if (cctrCdLo == null || cctrCdLo.trim().length() == 0 )
	    						{
	    							errCode = " ";
	    							errString = getErrorString("cctr_code__loss",errCode,userId);
	    							break;
	    						}
							 
							 else
							 { 
						    sql = "select count(1) from costctr where cctr_code = ?";
 							pstmt=conn.prepareStatement(sql);
 							pstmt.setString(1,cctrCdLo);
 							rs = pstmt.executeQuery();
 							if(rs.next())
 							{
 								cnt = rs.getInt(1);
 							}
 							pstmt.close();
 							rs.close();
 							pstmt = null;
 							rs = null;
 							if(cnt == 0)
 							{
 								errCode = "VMACCTCDX";
 								errString = getErrorString("cctr_code__loss",errCode,userId);
 								break;
 							}}
							 
						}
						else if (childNodeName.equalsIgnoreCase("tax_class")) 
						{
							taxClass = genericUtility.getColumnValue("tax_class",
									dom);
							if (taxClass != null && taxClass.length() > 0) {
								errCode = isExist("taxclass", "tax_class",
										taxClass, conn);
								if ("FALSE".equalsIgnoreCase(errCode))
								{
									errCode = "VTTCLASS1";
									errString = getErrorString("cctr_code__loss",errCode,userId);
	 								break;
								}
							}
						}

						else if (childNodeName.equalsIgnoreCase("tax_chap")) {
							taxChap = genericUtility
									.getColumnValue("tax_chap", dom);
							if (taxChap != null && taxChap.length() > 0) {
								errCode = isExist("taxchap", "tax_chap", taxChap,
										conn);
								if ("FALSE".equalsIgnoreCase(errCode)) {
									errCode = "VTTCHAP1";
									errString = getErrorString("cctr_code__loss",errCode,userId);
	 								break;
								}
							}
						}

						else if ( childNodeName.equalsIgnoreCase( "tax_env" ) )
						{
							taxEnv = genericUtility.getColumnValue( "tax_env", dom );
							if(	taxEnv != null && taxEnv.trim().length() > 0 )
							{
								sql = " SELECT COUNT(*) FROM taxenv WHERE tax_env = ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString(1,taxEnv.trim());
								rs = pstmt.executeQuery();
								cnt = 0;
								if( rs.next() )
								{
									cnt = rs.getInt( 1 );
								} 
								if( cnt == 0 )
								{
									errCode = "INTAXENV";
									errString = getErrorString( "tax_env", errCode, userId );
								}
								rs.close();
								rs = null;

								pstmt.close();
								pstmt = null;
							}
						} 
					}
			}
			
		}
			catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException ( e );
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
			  d.printStackTrace();
			  throw new ITMException ( d );
			}			
		}
		return errString;
	}


		private String isExist(String table, String field, String value,
				Connection conn) throws SQLException {
			String sql = "", retStr = "";
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			int cnt = 0;

			sql = " SELECT COUNT(1) FROM " + table + " WHERE " + field + " = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, value);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				cnt = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if (cnt > 0) {
				retStr = "TRUE";
			}
			if (cnt == 0) {
				retStr = "FALSE";
			}
			System.out.println("@@@@ isexist[" + value + "]:::[" + retStr + "]:::["
					+ cnt + "]");
			return retStr;
		}
	public String itemChanged(String xmlString,String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("------------------ itemChanged called------------------");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [AssetSales][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{

		System.out.println("@@@@@@@ itemChanged called");
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sql = "";
		String childNodeName = null;
//		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		@SuppressWarnings("unused")
		String siteCode = "",sitedesc="",priclit="";
		int currentFormNo =0;
		String columnValue="",chgTerm="",chgUser="",priceList="",tranDate="",listType="",oRate="",oldRateS="";
		String itemCode="",locCode="",lotNo="",lotsl="",quantity="",itmdesc="",loginSite="";
		Date utranDate;
		double rate = 0,conquan,conOldRate,oldAmount,amount,amtdiff,oldRate=0,getquantity=0;
		
		String asstCode="",itemSer="",grpCode="",descr="",cctrCode="",tranType="",getAcctCctrPl="",getAcctCctrLo="";
		String custCode="",getAcctCctrAr="";
		Date procDate2;
		double taxRecoAmt= 0;
		String[] acctCctrPl,acctCctrLo,acctCctrAr;
		String acctCodePl="",acctCodeLo="",cctrCodePl="",cctrCodeLo="",acctCodeAr="",cctrCodeAr="";
		String custName="",currCode="",acctCodeArLs="",cctrCodeArLs="",saleAmts="",taxAmts="",taxRecos="";
		double excRate=0,saleAmt,taxAmt = 0,taxReco=0;
		java.sql.Timestamp procDate2ts = null;
		Date pdate = null, cdate = null;
		double modVat = 0;
		SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
		String procDate2d = "";
		int cnt = 0;
		double exciseAmt = 0;
		String currAppdate="";
		String userId = "";
		int childNodeListLength;
		int ctr = 0;
		String taxEnv = "", taxChap = "", taxClass = "";
		double totalSale=0,totalTax = 0, totalExco=0;

		
		try
		{
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;

			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext.trim());
			}

			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");

			System.out.println("**********ITEMCHANGE FOR CASE" + currentFormNo+ "**************");
			
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();
				do {
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn)) {
						if (childNode.getFirstChild() != null) {
							columnValue = childNode.getFirstChild()
									.getNodeValue().trim();
						}
					}
					ctr++;
				} while (ctr < childNodeListLength
						&& !childNodeName.equals(currentColumn));
				System.out.println("[" + currentColumn + "] ==> '"
						+ columnValue + "'");

					
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("------------@@@@@@@@in itm_default@@@@@@@@@---------");
					Calendar currentDate = Calendar.getInstance();
					SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
					String systemDate = simpleDateFormatObj.format(currentDate.getTime());
					System.out.println("Now the date is :=>  " + systemDate);
					valueXmlString.append("<tran_date>").append("<![CDATA[" + systemDate + "]]>").append("</tran_date>");
					
				}
				
				if(childNodeName.equalsIgnoreCase("cust_code"))
				{
					
					custCode = genericUtility.getColumnValue("cust_code",dom);
					tranType = genericUtility.getColumnValue("tran_type",dom);
					
					sql = "select cust_name,curr_code,acct_code__ar,cctr_code__ar from "
							+ "customer where cust_code = ?";
							
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1,custCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						custName = rs.getString(1) == null ? "":rs.getString(1);
						currCode = rs.getString(2) == null ? "":rs.getString(2);
						acctCodeArLs = rs.getString(3) == null ? "":rs.getString(3);
						cctrCodeArLs = rs.getString(4) == null ? "":rs.getString(4);
						
					}
					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					
					sql = "select std_exrt from currency where curr_code = ?";
							
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1,currCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						excRate = rs.getDouble(1);
						
					}
					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					
					if(custCode != null && custCode.trim().length()>0 )
					{
						
					
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + excRate + "]]>").append("</exch_rate>");
					valueXmlString.append("<cust_name>").append("<![CDATA[" + custName + "]]>").append("</cust_name>");
					valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
				
					
					}
					else
					{
						valueXmlString.append("<exch_rate>").append("<![CDATA[]]>").append("</exch_rate>");
						valueXmlString.append("<cust_name>").append("<![CDATA[]]>").append("</cust_name>");
						valueXmlString.append("<curr_code>").append("<![CDATA[]]>").append("</curr_code>");
					
					}	
				}
				if(currentColumn.trim().equalsIgnoreCase("curr_code"))
				{
					currCode = genericUtility.getColumnValue("curr_code",dom);
					
					if(currCode != null && currCode.trim().length()>0 )
					{
					
					sql = "select std_exrt from currency where curr_code = ?";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1,currCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						excRate = rs.getDouble(1);
						
					}
					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + excRate + "]]>").append("</exch_rate>");
					}
					else
					{
						valueXmlString.append("<exch_rate>").append("<![CDATA[]]>").append("</exch_rate>");
					}
					}
			valueXmlString.append("</Detail1>");
				break;
				
		    	case 2:
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				valueXmlString.append("<Detail2>");
				childNodeListLength = childNodeList.getLength();
				do {
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn)) {
						if (childNode.getFirstChild() != null) {
							columnValue = childNode.getFirstChild()
									.getNodeValue().trim();
						}
					}
					ctr++;
				} while (ctr < childNodeListLength&& !childNodeName.equals(currentColumn));
				System.out.println("[" + currentColumn + "] ==> '"
						+ columnValue + "'");
					siteCode = checkNull(genericUtility.getColumnValue("site_code",dom1));
				    tranDate = checkNull(genericUtility.getColumnValue("tran_date",dom1));
					SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
					utranDate = simpleDateFormatObj.parse(tranDate);
					if(currentColumn.trim().equalsIgnoreCase("itm_default")) 
					{
						custCode = genericUtility.getColumnValue("cust_code",dom1);

						sql = "select acct_code__ar,cctr_code__ar from "
								+ "customer where cust_code = ?";
								
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1,custCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							acctCodeArLs = rs.getString(1) == null ? "":rs.getString(1);
							cctrCodeArLs = rs.getString(2) == null ? "":rs.getString(2);
							
						}
						pstmt.close();
						rs.close();
						pstmt = null;
						rs = null;
						if(custCode != null && custCode.trim().length()>0 )
						{
							valueXmlString.append("<acct_code__ar>").append("<![CDATA[" + acctCodeArLs + "]]>").append("</acct_code__ar>");
							valueXmlString.append("<cctr_code__ar>").append("<![CDATA[" + cctrCodeArLs + "]]>").append("</cctr_code__ar>");
							
						}
						else
						{
							valueXmlString.append("<acct_code__ar>").append("<![CDATA[]]>").append("</acct_code__ar>");
							valueXmlString.append("<cctr_code__ar>").append("<![CDATA[]]>").append("</cctr_code__ar>");
						
						}	
						
						taxChap = genericUtility.getColumnValue("tax_chap",dom1);
						taxClass = genericUtility.getColumnValue("tax_class",dom1);
						taxEnv = genericUtility.getColumnValue("tax_env",dom1);
						
						if(taxChap != null && taxChap.trim().length()>0 )
						{
							valueXmlString.append("<tax_chap>").append("<![CDATA[" + taxChap + "]]>").append("</tax_chap>");
							
						}
						else
						{
							valueXmlString.append("<tax_chap>").append("<![CDATA[]]>").append("</tax_chap>");
						
						}
						if(taxClass != null && taxClass.trim().length()>0 )
						{
							valueXmlString.append("<tax_class>").append("<![CDATA[" + taxClass + "]]>").append("</tax_class>");
							
						}
						else
						{
							valueXmlString.append("<tax_class>").append("<![CDATA[]]>").append("</tax_class>");
						}
						if(taxEnv != null && taxEnv.trim().length()>0 )
						{
							valueXmlString.append("<tax_env>").append("<![CDATA[" + taxEnv + "]]>").append("</tax_env>");
						}
						else
						{
							valueXmlString.append("<tax_env>").append("<![CDATA[]]>").append("</tax_env>");
						}
						
						
					}
				if(currentColumn.trim().equalsIgnoreCase("asset_code"))
				{
					asstCode = genericUtility.getColumnValue("asset_code",dom);
					tranType = genericUtility.getColumnValue("tran_type",dom1);
					
					if(asstCode != null && asstCode.trim().length()>0 )
					{
									
						sql = "select item_ser, grp_code, item_code, descr, site_code, cctr_code, "
								+ "proc_date_2,tax_reco_amt from asset_register where asset_code = ?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1,asstCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							itemSer = rs.getString(1) == null ? "":rs.getString(1);
							grpCode = rs.getString(2) == null ? "":rs.getString(2);
							itemCode = rs.getString(3) == null ? "":rs.getString(3);
							descr = rs.getString(4) == null ? "":rs.getString(4);
							siteCode = rs.getString(5) == null ? "":rs.getString(5);
							cctrCode = rs.getString(6) == null ? "":rs.getString(6);
							procDate2 = rs.getDate(7);
							taxRecoAmt = rs.getDouble(8);
						}
						pstmt.close();
						rs.close();
						pstmt = null;
						rs = null;
						
						getAcctCctrPl = finCommon.getAcctDetrTtype(itemCode, itemSer, "FA-PL", tranType, conn);
					
						if(getAcctCctrPl.equals(" , ") || getAcctCctrPl.equals(","))
						{
							acctCodePl = "";
						}
						else
						{
							acctCctrPl = getAcctCctrPl.split(",");
							System.out.println(">>>>"+acctCctrPl[0]);
							acctCodePl = acctCctrPl[0];
						}
						
					
						cctrCodePl = cctrCode;
						
						
						getAcctCctrLo = finCommon.getAcctDetrTtype(itemCode, itemSer, "FA-LOSS", tranType, conn);
						
						if(getAcctCctrLo.equals(" , ") || getAcctCctrLo.equals(","))
						{
							acctCodeLo = "";
						}
						else
						{
							acctCctrLo = getAcctCctrLo.split(",");
							System.out.println(">>>>"+acctCctrLo[1]);
							
							acctCodeLo = acctCctrLo[0];
						}
						
						
						cctrCodeLo = cctrCode;
						/*getAcctCctrAr = finCommon.getAcctDetrTtype(itemCode, itemSer, "AR", tranType, conn);
						
						if((getAcctCctrAr.equals(" , ") || getAcctCctrAr.equals(",")))
						{
							acctCodeAr = "";
							cctrCodeAr = "";
						}
						else
						{
							acctCctrAr = getAcctCctrAr.split(",");
							System.out.println(">>>>"+acctCctrAr[1]);
							
							acctCodeAr = acctCctrAr[0];
							cctrCodeAr = acctCctrAr[1];
						}*/						
						valueXmlString.append("<site_code>").append("<![CDATA[" + siteCode + "]]>").append("</site_code>");
						valueXmlString.append("<descr>").append("<![CDATA[" + descr + "]]>").append("</descr>");
						valueXmlString.append("<grp_code>").append("<![CDATA[" + grpCode + "]]>").append("</grp_code>");
						valueXmlString.append("<acct_code__pl>").append("<![CDATA[" + acctCodePl + "]]>").append("</acct_code__pl>");
						valueXmlString.append("<cctr_code__pl>").append("<![CDATA[" + cctrCodePl + "]]>").append("</cctr_code__pl>");
						valueXmlString.append("<acct_code__loss>").append("<![CDATA[" + acctCodeLo + "]]>").append("</acct_code__loss>");
						valueXmlString.append("<cctr_code__loss>").append("<![CDATA[" + cctrCodeLo + "]]>").append("</cctr_code__loss>");
						/*valueXmlString.append("<acct_code__ar>").append("<![CDATA[" + acctCodeAr + "]]>").append("</acct_code__ar>");
						valueXmlString.append("<cctr_code__ar>").append("<![CDATA[" + cctrCodeAr + "]]>").append("</cctr_code__ar>");*/
						
					}else
					{
						
						valueXmlString.append("<site_code>").append("<![CDATA[]]>").append("</site_code>");
						valueXmlString.append("<descr>").append("<![CDATA[]]>").append("</descr>");
						valueXmlString.append("<grp_code>").append("<![CDATA[]]>").append("</grp_code>");
						valueXmlString.append("<acct_code__pl>").append("<![CDATA[]]>").append("</acct_code__pl>");
						valueXmlString.append("<cctr_code__pl>").append("<![CDATA[]]>").append("</cctr_code__pl>");
						valueXmlString.append("<acct_code__loss>").append("<![CDATA[]]>").append("</acct_code__loss>");
						valueXmlString.append("<cctr_code__loss>").append("<![CDATA[]]>").append("</cctr_code__loss>");
						/*valueXmlString.append("<acct_code__ar>").append("<![CDATA[]]>").append("</acct_code__ar>");
						valueXmlString.append("<cctr_code__ar>").append("<![CDATA[]]>").append("</cctr_code__ar>");*/
					}
				}
				
				        if(currentColumn.trim().equalsIgnoreCase("sale_amt"))
				          {
				    	    saleAmts = genericUtility.getColumnValue("sale_amt",dom);
			    	        //taxAmts = genericUtility.getColumnValue("tax_amt",dom);
			    	        taxRecos = genericUtility.getColumnValue("excreco_amt",dom);
			    	        System.out.println("tax_amt dom"+taxAmts);
			    	        System.out.println("excreco_amt"+taxRecos);
			    	        if(saleAmts == null)
			    	        {
			    	        	System.out.println("sale amount is null:"+saleAmts);
			    	        	saleAmt = 0;
			    	        }else
			    	        {
			    	        	saleAmt = Double.parseDouble(saleAmts);
			    	        	System.out.println("Sale amount is not null:"+saleAmt);
			    	        }
			    	        if(taxRecos == null)
			    	        {
			    	        	System.out.println("taxRecos amount is null:"+taxRecos);
			    	        	taxReco = 0;
			    	        }else
			    	        {
			    	        	System.out.println("taxAmt amount is not null:"+taxReco);
			    	        	taxReco = Double.parseDouble(taxRecos);
			    	        }
			    	        
			    	        
			    	        if((saleAmts != null && saleAmts.trim().length()>0))
			    	        {
			    	        	System.out.println("Sale amount "+saleAmt);
			    	        	System.out.println("tax_amt "+taxAmts);
				    	        System.out.println("excreco_amt"+taxRecos);
			    	        	totalSale = saleAmt + taxAmt + taxReco;
			    	        	System.out.println("total amount "+totalSale);//net_amt
			    	        	valueXmlString.append("<amount>").append("<![CDATA[" + totalSale + "]]>").append("</amount>");
			    	        	valueXmlString.append("<net_amt>").append("<![CDATA[" + totalSale + "]]>").append("</net_amt>");
			    	        }else
			    	        {
			    	        	valueXmlString.append("<amount>").append("<![CDATA[]]>").append("</amount>");
			    	        	valueXmlString.append("<net_amt>").append("<![CDATA[]]>").append("</net_amt>");
			    	        }
				    }
				     if(currentColumn.trim().equalsIgnoreCase("excreco_amt") )
				    {
				    	    saleAmts = genericUtility.getColumnValue("sale_amt",dom);
			    	        taxAmts = genericUtility.getColumnValue("tax_amt",dom);
			    	        taxRecos = genericUtility.getColumnValue("excreco_amt",dom);
			    	        System.out.println("tax_amt dom"+taxAmts);
			    	        System.out.println("excreco_amt"+taxRecos);
			    	        if(saleAmts == null)
			    	        {
			    	        	System.out.println("sale amount is null:"+saleAmts);
			    	        	saleAmt = 0;
			    	        }else
			    	        {
			    	        	saleAmt = Double.parseDouble(saleAmts);
			    	        	System.out.println("Sale amount is not null:"+saleAmt);
			    	        }
			    	        if(taxRecos == null)
			    	        {
			    	        	System.out.println("taxRecos amount is null:"+taxRecos);
			    	        	taxReco = 0;
			    	        }else
			    	        {
			    	        	System.out.println("taxAmt amount is not null:"+taxReco);
			    	        	taxReco = Double.parseDouble(taxRecos);
			    	        }
			    	        
			    	        
			    	        if((taxRecos != null && taxRecos.trim().length()>0))
			    	        {
			    	        	System.out.println("Sale amount "+saleAmt);
			    	        	System.out.println("tax_amt "+taxAmts);
				    	        System.out.println("excreco_amt"+taxRecos);
				    	        totalExco = saleAmt + taxAmt + taxReco;
			    	        	System.out.println("total amount "+totalExco);
			    	        	valueXmlString.append("<amount>").append("<![CDATA[" + totalExco + "]]>").append("</amount>");
			    	        	valueXmlString.append("<net_amt>").append("<![CDATA[" + totalExco + "]]>").append("</net_amt>");
			    	        }else
			    	        {
			    	        	valueXmlString.append("<amount>").append("<![CDATA[]]>").append("</amount>");
			    	        	valueXmlString.append("<net_amt>").append("<![CDATA[]]>").append("</net_amt>");
			    	        }
				    }
					
				 
				valueXmlString.append("</Detail2>");	
			}
			
			valueXmlString.append("</Root>");
		}
		
		catch(Exception e)
		{
            e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
			  d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	
	}

	private String checkNull(String input)
	{
		if(input == null)
		{
		  return "";
		}
		return input.trim();
	}
	private java.util.Date addMonths(java.util.Date date, int months)throws Exception, ITMException // added by Kunal on 10/12/12
      { 
         java.util.Date calculatedDate = null;

          if (date != null) 
          {
	        final GregorianCalendar calendar = new GregorianCalendar();
	        calendar.setTime(date);
	        calendar.add(Calendar.MONTH, months);
	         calculatedDate = new java.util.Date(calendar.getTime().getTime());
}

return calculatedDate;
}
}
