package ibase.e12ria.e12widgets.client;

import com.google.gwt.core.client.Callback;
import com.google.gwt.geolocation.client.Position;
import com.google.gwt.geolocation.client.Position.Coordinates;
import com.google.gwt.geolocation.client.PositionError;
import com.google.gwt.user.client.Window;

public class Geolocation {
	
	protected com.google.gwt.geolocation.client.Geolocation geolocation = com.google.gwt.geolocation.client.Geolocation.getIfSupported();
	
	public static class LocalityGPSInfo implements Coordinates {
		
		protected double latitude;
		protected double longitude;
		protected double thresholdInKm;
		
		public LocalityGPSInfo(double latitude, double longitude) {
			this(latitude, longitude, 9.9);
		}
		
		public LocalityGPSInfo(double latitude, double longitude, double thresholdInKm) {
			this.latitude = latitude;
			this.longitude = longitude;
			this.thresholdInKm = thresholdInKm;
		}
		
		public static double getDistance(Coordinates arg1, Coordinates arg2) {
			double latitude1 = arg1.getLatitude();
			double latitude2 = arg2.getLatitude();
			double longitude1 = arg1.getLongitude();
			double longitude2 = arg2.getLongitude();
			double x = latitude1 - latitude2;
			double y = longitude1 - longitude2;
			double dist = Math.sqrt((x * x) + (y * y));
			return dist;
		}
		
		@Override
		public double getLatitude() {
			return latitude;
		}

		@Override
		public double getLongitude() {
			return longitude;
		}

		@Override
		public double getAccuracy() {
			throw new UnsupportedOperationException();
		}

		@Override
		public Double getAltitude() {
			throw new UnsupportedOperationException();
		}

		@Override
		public Double getAltitudeAccuracy() {
			throw new UnsupportedOperationException();
		}

		@Override
		public Double getHeading() {
			throw new UnsupportedOperationException();
		}

		@Override
		public Double getSpeed() {
			throw new UnsupportedOperationException();
		}
		
		public static double getDisatanceInKm(Coordinates arg1, Coordinates arg2) {
			double radDistKm  = 0.0;
			try
			{
				double lat1 = radian( arg1.getLatitude() );
				double lon1 = radian( arg1.getLongitude() );
				double lat2 = radian( arg2.getLatitude() );
				double lon2 = radian( arg2.getLongitude() );
				
				double t1 = Math.sin(lat1) * Math.sin(lat2);
				double t2 = Math.cos(lat1) * Math.cos(lat2);
				double t3 = Math.cos(lon1 - lon2);
				double t4 = t2 * t3;
				double t5 = t1 + t4;
				double radDist = Math.atan( -t5 / Math.sqrt( -t5 * t5 + 1 ) ) + 2 * Math.atan(1);
				
				double radDistMiles = radDist * 3437.74677 * 1.1508;// Statute Mile
				radDistKm = radDistMiles * 1.6093470878864446;
			}
			catch(Exception exp)
			{
				Window.alert("Exception in getDisatanceInKm... " + exp.getMessage() + "]");
			}
			//double radDistFeets = radDistKm * 5.2800102998e+3;
			//Window.alert("[lat1,lon1]( " + lat1 + "," + lon1 + " )[lat2,lon2](" + lat2 + "," + lon2 + ")"+
			//			"[t1,t2,t3,t4,t5]( " + t1 + ","+ t2 + ","+ t3 + ","+ t4 + ","+ t5 + " )" +
			//			"[radDist,radDistMiles,radDistKm](" + radDist + "," + radDistMiles + "," + radDistKm + ")");
			return radDistKm;
		}
		
		private static double radian(double value) {
			return value * (Math.PI / 180) ;
		}

		public double getThresholdInKm() {
			return thresholdInKm;
		}
		
	}
	
	public void getCurrentLocation(Callback<Position, PositionError> callback) {
		geolocation.getCurrentPosition(callback);
	}
	
	public void getClosest(final LocalityGPSInfo[] coordinateses, final Callback<Integer, PositionError> callback) {
		getCurrentLocation(new Callback<Position, PositionError>() {

			@Override
			public void onSuccess(Position result) {
				if (callback != null) {
					int index = getClosest(result.getCoordinates(), coordinateses);
					callback.onSuccess(index);
				}
			}
			
			@Override
			public void onFailure(PositionError reason) {
				if (callback != null) {
					callback.onFailure(reason);
				}
			}

		});
	}
	
	public int getClosest(Coordinates currentCoordinates, LocalityGPSInfo[] coordinateses) {
		if (coordinateses == null || ( coordinateses != null && coordinateses.length == 0 ) ) {
			return -1;
		}
		double minDist = -1.0;
		double thresholdInKm = 1.0;
		int index = -1;
		int len = coordinateses.length;
		for (int i = 0; i < len; i++) {
			LocalityGPSInfo coordinates = coordinateses[i];
			if (coordinates == null) {
				continue;
			}
			//double dist = LocalityGPSInfo.getDistance(currentCoordinates, coordinates);
			double dist = LocalityGPSInfo.getDisatanceInKm(currentCoordinates, coordinates);
			thresholdInKm = coordinates.getThresholdInKm();
			if (minDist < 0) {
				minDist = dist;
				index = i;
			} else if (dist < minDist ) {
				minDist = dist;
				index = i;
			}
			//Window.alert( i + " of " + len + " minDist[" + minDist + "]thresholdInKm[" + thresholdInKm + "]");
		}
		
		if (minDist > thresholdInKm) {
			index = -1;
		}		
		return index;
	}
}
