/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.resources;

import com.fusioncharts.exporter.FusionChartsExportHelper;
import com.fusioncharts.exporter.beans.ChartMetadata;
import com.fusioncharts.exporter.beans.ExportBean;
import com.fusioncharts.exporter.beans.ExportConfiguration;
import com.fusioncharts.exporter.beans.LogMessageSetVO;
import com.fusioncharts.exporter.error.LOGMESSAGE;
import com.fusioncharts.exporter.error.Status;
import com.fusioncharts.exporter.generators.PDFGenerator;
import com.fusioncharts.exporter.resources.FCExporter_Format;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class FCExporter_PDF
extends FCExporter_Format {
    private ExportBean exportBean = null;

    public String exportOutput(Object exportObj, HttpServletResponse response) {
        byte[] pdfBytes = (byte[])exportObj;
        String action = (String)this.exportBean.getExportParameterValue("exportaction");
        String exportFormat = (String)this.exportBean.getExportParameterValue("exportformat");
        String exportTargetWindow = (String)this.exportBean.getExportParameterValue("exporttargetwindow");
        String fileNameWithoutExt = (String)this.exportBean.getExportParameterValue("exportfilename");
        String extension = FusionChartsExportHelper.getExtensionFor((String)exportFormat.toLowerCase());
        String fileName = String.valueOf(fileNameWithoutExt) + "." + extension;
        String stream = this.exportBean.getStream();
        ChartMetadata metadata = this.exportBean.getMetadata();
        boolean isHTML = false;
        if (action.equals("download")) {
            isHTML = true;
        }
        LogMessageSetVO logMessageSetVO = new LogMessageSetVO();
        String noticeMessage = "";
        String meta_values = this.exportBean.getMetadataAsQueryString(null, false, isHTML);
        if (!action.equalsIgnoreCase("download")) {
            noticeMessage = "&notice=";
            String pathToWebAppRoot = (String)this.exportBean.getExportParameterValue("webapproot");
            String pathToSaveFolder = ExportConfiguration.SAVEABSOLUTEPATH;
            File saveFolder = new File(pathToSaveFolder);
            String completeFilePath = String.valueOf(pathToSaveFolder) + File.separator + fileName;
            String completeFilePathWithoutExt = String.valueOf(pathToSaveFolder) + File.separator + fileNameWithoutExt;
            File saveFile = new File(completeFilePath);
            if (saveFile.exists()) {
                noticeMessage = String.valueOf(noticeMessage) + LOGMESSAGE.W509;
                if (!ExportConfiguration.OVERWRITEFILE && ExportConfiguration.INTELLIGENTFILENAMING) {
                    noticeMessage = String.valueOf(noticeMessage) + LOGMESSAGE.W514;
                    completeFilePath = FusionChartsExportHelper.getUniqueFileName((String)completeFilePathWithoutExt, (String)extension);
                    File tempFile = new File(completeFilePath);
                    fileName = tempFile.getName();
                    noticeMessage = String.valueOf(noticeMessage) + LOGMESSAGE.W515 + fileName;
                    logMessageSetVO.addWarning(LOGMESSAGE.W515);
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(completeFilePath);
                int i = 0;
                while (i < pdfBytes.length) {
                    fos.write(pdfBytes[i]);
                    ++i;
                }
                fos.flush();
                fos.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e) {
                logMessageSetVO.addError(LOGMESSAGE.E600);
            }
            String pathToDisplay = String.valueOf(ExportConfiguration.HTTP_URI) + "/" + fileName;
            if (ExportConfiguration.HTTP_URI.endsWith("/")) {
                pathToDisplay = String.valueOf(ExportConfiguration.HTTP_URI) + fileName;
            }
            meta_values = this.exportBean.getMetadataAsQueryString(pathToDisplay, false, isHTML);
            if (logMessageSetVO.getErrorsSet() == null || logMessageSetVO.getErrorsSet().isEmpty()) {
                try {
                    PrintWriter out = response.getWriter();
                    out.print(String.valueOf(meta_values) + noticeMessage + "&statusCode=" + Status.SUCCESS.getCode() + "&statusMessage=" + Status.SUCCESS);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            response.setContentType(FusionChartsExportHelper.getMimeTypeFor((String)exportFormat.toLowerCase()));
            if (exportTargetWindow.equalsIgnoreCase("_self")) {
                response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            } else {
                response.addHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
            }
            try {
                ServletOutputStream os = response.getOutputStream();
                int i = 0;
                while (i < pdfBytes.length) {
                    os.write(pdfBytes[i]);
                    ++i;
                }
                os.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (logMessageSetVO.getErrorsSet() == null || logMessageSetVO.getErrorsSet().isEmpty()) {
            meta_values = this.exportBean.getMetadataAsQueryString(null, true, isHTML);
            try {
                PrintWriter out = response.getWriter();
                out.print(String.valueOf(meta_values) + noticeMessage + "&statusCode=" + Status.SUCCESS.getCode() + "&statusMessage=" + Status.SUCCESS);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object exportProcessor(ExportBean pExportBean) {
        this.exportBean = pExportBean;
        String stream = this.exportBean.getStream();
        ChartMetadata metadata = this.exportBean.getMetadata();
        PDFGenerator pdf = new PDFGenerator(stream, metadata);
        byte[] pdfBytes = pdf.getPDFObjects(true);
        return pdfBytes;
    }
}

