/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.CustomObjectInputStream;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;

public class UnitOfWorkChangeSet
implements Serializable,
org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet {
    protected Map<Class, Map<ObjectChangeSet, ObjectChangeSet>> objectChanges;
    protected Map<Class, Map<ObjectChangeSet, ObjectChangeSet>> newObjectChangeSets;
    protected Map<Object, ObjectChangeSet> cloneToObjectChangeSet;
    protected Map<ObjectChangeSet, Object> objectChangeSetToUOWClone;
    protected Map<ObjectChangeSet, ObjectChangeSet> aggregateChangeSets;
    protected Map<ObjectChangeSet, ObjectChangeSet> allChangeSets;
    protected Map<ObjectChangeSet, ObjectChangeSet> deletedObjects;
    protected boolean hasChanges;
    protected boolean hasForcedChanges;
    protected boolean isChangeSetFromOutsideUOW = false;
    protected transient AbstractSession session;

    public UnitOfWorkChangeSet() {
        this.setHasChanges(false);
    }

    public UnitOfWorkChangeSet(AbstractSession session) {
        this.session = session;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public UnitOfWorkChangeSet(byte[] bytes, AbstractSession session) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        CustomObjectInputStream objectIn = new CustomObjectInputStream(byteIn, session);
        this.allChangeSets = (Map)objectIn.readObject();
        this.deletedObjects = (Map)objectIn.readObject();
    }

    public void addDeletedObjects(Map deletedObjects, AbstractSession session) {
        for (Object object : deletedObjects.keySet()) {
            this.addDeletedObject(object, session);
        }
    }

    public void addDeletedObject(Object object, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(object);
        if (!descriptor.isAggregateCollectionDescriptor()) {
            ObjectChangeSet set = descriptor.getObjectBuilder().createObjectChangeSet(object, this, false, session);
            set.setShouldBeDeleted(true);
            this.getDeletedObjects().put(set, set);
        }
    }

    public void addObjectChangeSet(ObjectChangeSet objectChanges, AbstractSession session, boolean forceToNewObjectList) {
        if (objectChanges != null) {
            if (objectChanges.isNew() && forceToNewObjectList) {
                this.addNewObjectChangeSet(objectChanges, session);
                this.getAllChangeSets().put(objectChanges, objectChanges);
            } else {
                boolean objectChangeSetHasChanges = objectChanges.hasChanges();
                if (objectChangeSetHasChanges) {
                    this.setHasChanges(true);
                    this.hasForcedChanges = this.hasForcedChanges || objectChanges.hasForcedChanges();
                } else {
                    this.hasForcedChanges = true;
                }
                if (!objectChanges.isAggregate()) {
                    if (objectChangeSetHasChanges) {
                        this.getAllChangeSets().put(objectChanges, objectChanges);
                    }
                    if (objectChanges.getId() != null) {
                        Map<ObjectChangeSet, ObjectChangeSet> map = this.getObjectChanges().get(objectChanges.getClassType());
                        if (map == null) {
                            map = new HashMap<ObjectChangeSet, ObjectChangeSet>();
                            this.getObjectChanges().put(objectChanges.getClassType(), map);
                            map.put(objectChanges, objectChanges);
                        } else {
                            map.put(objectChanges, objectChanges);
                        }
                    }
                }
            }
        }
    }

    protected void addNewObjectChangeSet(ObjectChangeSet objectChanges, AbstractSession session) {
        Map<ObjectChangeSet, ObjectChangeSet> changeSetTable = this.getNewObjectChangeSets().get(objectChanges.getClassType(session));
        if (changeSetTable == null) {
            changeSetTable = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
            this.getNewObjectChangeSets().put(objectChanges.getClassType(session), changeSetTable);
        }
        changeSetTable.put(objectChanges, objectChanges);
        this.hasChanges = true;
    }

    public ObjectChangeSet findObjectChangeSet(ObjectChangeSet changeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        Map<ObjectChangeSet, ObjectChangeSet> changes = this.getObjectChanges().get(changeSet.getClassName());
        ObjectChangeSet potential = null;
        if (changes != null) {
            potential = changes.get(changeSet);
        }
        if (potential == null) {
            potential = (ObjectChangeSet)this.getObjectChangeSetForClone(changeSet.getUnitOfWorkClone());
        }
        return potential;
    }

    public ObjectChangeSet findOrIntegrateObjectChangeSet(ObjectChangeSet tofind, UnitOfWorkChangeSet mergeFromChangeSet) {
        if (tofind == null) {
            return tofind;
        }
        ObjectChangeSet localChangeSet = this.findObjectChangeSet(tofind, mergeFromChangeSet);
        if (localChangeSet == null) {
            if (tofind.getDescriptor() == null) {
                tofind.getClassType(this.session);
                tofind.setDescriptor(this.session.getDescriptor(tofind.getClassType()));
            }
            localChangeSet = new ObjectChangeSet(tofind.getId(), tofind.getDescriptor(), tofind.getUnitOfWorkClone(), this, tofind.isNew());
            this.addObjectChangeSetForIdentity(localChangeSet, localChangeSet.getUnitOfWorkClone());
        }
        return localChangeSet;
    }

    public ObjectChangeSet findOrCreateLocalObjectChangeSet(Object entityClone, ClassDescriptor descriptor, boolean isNew) {
        ObjectChangeSet changes = (ObjectChangeSet)this.getObjectChangeSetForClone(entityClone);
        if (changes == null) {
            changes = descriptor.isAggregateDescriptor() ? new AggregateObjectChangeSet(CacheId.EMPTY, descriptor, entityClone, this, isNew) : new ObjectChangeSet(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(entityClone, this.session), descriptor, entityClone, this, isNew);
            changes.setIsAggregate(descriptor.isDescriptorTypeAggregate());
            this.addObjectChangeSetForIdentity(changes, entityClone);
        }
        return changes;
    }

    public void addObjectChangeSetForIdentity(ObjectChangeSet objectChanges, Object object) {
        if (objectChanges == null || object == null) {
            return;
        }
        if (objectChanges.isAggregate()) {
            this.getAggregateChangeSets().put(objectChanges, objectChanges);
        }
        this.getObjectChangeSetToUOWClone().put(objectChanges, object);
        this.getCloneToObjectChangeSet().put(object, objectChanges);
    }

    public Map<ObjectChangeSet, ObjectChangeSet> getAggregateChangeSets() {
        if (this.aggregateChangeSets == null) {
            this.aggregateChangeSets = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
        }
        return this.aggregateChangeSets;
    }

    @Override
    public Map<ObjectChangeSet, ObjectChangeSet> getAllChangeSets() {
        if (this.allChangeSets == null) {
            this.allChangeSets = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
        }
        return this.allChangeSets;
    }

    public byte[] getByteArrayRepresentation(AbstractSession session) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> writableChangeSets = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
        for (ObjectChangeSet changeSet : this.getAllChangeSets().values()) {
            ClassDescriptor descriptor = changeSet.getDescriptor();
            int syncType = descriptor.getCachePolicy().getCacheSynchronizationType();
            if (syncType == 4 || changeSet.isNew() && syncType != 3) continue;
            writableChangeSets.put(changeSet, changeSet);
        }
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> sendableDeletedObjects = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
        for (ObjectChangeSet changeSet : this.getDeletedObjects().keySet()) {
            ClassDescriptor descriptor = changeSet.getDescriptor();
            int syncType = descriptor.getCacheSynchronizationType();
            if (syncType == 4) continue;
            sendableDeletedObjects.put(changeSet, changeSet);
        }
        if (writableChangeSets.isEmpty() && sendableDeletedObjects.isEmpty()) {
            return null;
        }
        objectOut.writeObject(writableChangeSets);
        objectOut.writeObject(sendableDeletedObjects);
        return byteOut.toByteArray();
    }

    public Map<Object, ObjectChangeSet> getCloneToObjectChangeSet() {
        if (this.cloneToObjectChangeSet == null) {
            this.cloneToObjectChangeSet = new IdentityHashMap<Object, ObjectChangeSet>();
        }
        return this.cloneToObjectChangeSet;
    }

    @Override
    public Map<ObjectChangeSet, ObjectChangeSet> getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
        }
        return this.deletedObjects;
    }

    public Map<Class, Map<ObjectChangeSet, ObjectChangeSet>> getObjectChanges() {
        if (this.objectChanges == null) {
            this.objectChanges = new HashMap<Class, Map<ObjectChangeSet, ObjectChangeSet>>();
        }
        return this.objectChanges;
    }

    public Set<ClassDescriptor> findUpdatedObjectsClasses() {
        if (this.objectChanges == null || this.objectChanges.isEmpty()) {
            return null;
        }
        HashSet<ClassDescriptor> updatedObjectsClasses = new HashSet<ClassDescriptor>(this.getObjectChanges().size());
        block0: for (Map<ObjectChangeSet, ObjectChangeSet> objectChanges : this.getObjectChanges().values()) {
            for (ObjectChangeSet changeSet : objectChanges.values()) {
                if (changeSet.isNew()) continue;
                updatedObjectsClasses.add(changeSet.getDescriptor());
                continue block0;
            }
        }
        return updatedObjectsClasses;
    }

    @Override
    public org.eclipse.persistence.sessions.changesets.ObjectChangeSet getObjectChangeSetForClone(Object clone) {
        if (clone == null || this.cloneToObjectChangeSet == null) {
            return null;
        }
        return this.cloneToObjectChangeSet.get(clone);
    }

    protected Map<ObjectChangeSet, Object> getObjectChangeSetToUOWClone() {
        if (this.objectChangeSetToUOWClone == null) {
            this.objectChangeSetToUOWClone = new IdentityHashMap<ObjectChangeSet, Object>();
        }
        return this.objectChangeSetToUOWClone;
    }

    @Override
    public Object getUOWCloneForObjectChangeSet(org.eclipse.persistence.sessions.changesets.ObjectChangeSet changeSet) {
        if (changeSet == null || this.objectChangeSetToUOWClone == null) {
            return null;
        }
        return this.objectChangeSetToUOWClone.get(changeSet);
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges || this.deletedObjects != null && !this.deletedObjects.isEmpty();
    }

    public boolean hasDeletedObjects() {
        return this.deletedObjects != null && !this.deletedObjects.isEmpty();
    }

    public void setHasChanges(boolean flag) {
        this.hasChanges = flag;
    }

    public boolean hasForcedChanges() {
        return this.hasForcedChanges;
    }

    public ObjectChangeSet mergeObjectChanges(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        ObjectChangeSet localChangeSet = this.findOrIntegrateObjectChangeSet(objectChangeSet, mergeFromChangeSet);
        if (localChangeSet != null) {
            localChangeSet.mergeObjectChanges(objectChangeSet, this, mergeFromChangeSet);
        }
        return localChangeSet;
    }

    public void mergeUnitOfWorkChangeSet(UnitOfWorkChangeSet mergeFromChangeSet, AbstractSession session, boolean postCommit) {
        if (mergeFromChangeSet == null) {
            return;
        }
        for (Map<ObjectChangeSet, ObjectChangeSet> objectChanges : mergeFromChangeSet.getObjectChanges().values()) {
            for (ObjectChangeSet objectChangeSet : objectChanges.values()) {
                objectChangeSet = this.mergeObjectChanges(objectChangeSet, mergeFromChangeSet);
                this.addObjectChangeSet(objectChangeSet, session, !postCommit);
            }
        }
        if (mergeFromChangeSet.hasDeletedObjects()) {
            for (ObjectChangeSet objectChangeSet : mergeFromChangeSet.getDeletedObjects().values()) {
                ObjectChangeSet localObjectChangeSet = this.findObjectChangeSet(objectChangeSet, mergeFromChangeSet);
                if (localObjectChangeSet == null) {
                    localObjectChangeSet = objectChangeSet;
                }
                this.getDeletedObjects().put(localObjectChangeSet, localObjectChangeSet);
            }
        }
    }

    public void putNewObjectInChangesList(ObjectChangeSet objectChangeSet, AbstractSession session) {
        if (objectChangeSet.getId() == null) {
            Object clone = objectChangeSet.getUnitOfWorkClone();
            objectChangeSet.setId(session.getDescriptor(clone.getClass()).getObjectBuilder().extractPrimaryKeyFromObject(clone, session, false));
        }
        this.addObjectChangeSet(objectChangeSet, session, false);
        this.removeObjectChangeSetFromNewList(objectChangeSet, session);
    }

    public void removeObjectChangeSetFromNewList(ObjectChangeSet objectChangeSet, AbstractSession session) {
        Map<ObjectChangeSet, ObjectChangeSet> table = this.getNewObjectChangeSets().get(objectChangeSet.getClassType(session));
        if (table != null) {
            table.remove(objectChangeSet);
        }
    }

    public void removeObjectChangeSet(ObjectChangeSet changeSet) {
        if (changeSet == null) {
            return;
        }
        Object object = this.getObjectChangeSetToUOWClone().get(changeSet);
        if (changeSet.isAggregate()) {
            this.getAggregateChangeSets().remove(changeSet);
        } else {
            Map<ObjectChangeSet, ObjectChangeSet> classChanges = this.getObjectChanges().get(object.getClass());
            if (classChanges != null) {
                classChanges.remove(changeSet);
            }
        }
        this.getObjectChangeSetToUOWClone().remove(changeSet);
        if (object != null) {
            this.getCloneToObjectChangeSet().remove(object);
        }
        this.getAllChangeSets().remove(changeSet);
    }

    public void setIsChangeSetFromOutsideUOW(boolean isChangeSetFromOutsideUOW) {
        this.isChangeSetFromOutsideUOW = isChangeSetFromOutsideUOW;
    }

    public boolean isChangeSetFromOutsideUOW() {
        return this.isChangeSetFromOutsideUOW;
    }

    public void setCloneToObjectChangeSet(Map<Object, ObjectChangeSet> cloneToObjectChangeSet) {
        this.cloneToObjectChangeSet = cloneToObjectChangeSet;
    }

    protected void setObjectChanges(Map objectChanges) {
        this.objectChanges = objectChanges;
    }

    public void setObjectChangeSetToUOWClone(Map<ObjectChangeSet, Object> objectChangeSetToUOWClone) {
        this.objectChangeSetToUOWClone = objectChangeSetToUOWClone;
    }

    public Map<Class, Map<ObjectChangeSet, ObjectChangeSet>> getNewObjectChangeSets() {
        if (this.newObjectChangeSets == null) {
            this.newObjectChangeSets = new HashMap<Class, Map<ObjectChangeSet, ObjectChangeSet>>();
        }
        return this.newObjectChangeSets;
    }
}

