/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.HeaderBlockConstants;
import org.apache.poi.util.IntegerField;
import org.apache.poi.util.LongField;
import org.apache.poi.util.ShortField;

public class HeaderBlockWriter
extends BigBlock
implements HeaderBlockConstants {
    private static final byte _default_value = -1;
    private IntegerField _bat_count;
    private IntegerField _property_start;
    private IntegerField _sbat_start;
    private IntegerField _sbat_block_count;
    private IntegerField _xbat_start;
    private IntegerField _xbat_count;
    private byte[] _data = new byte[512];

    public HeaderBlockWriter() {
        Arrays.fill(this._data, (byte)-1);
        new LongField(0, -2226271756974174256L, this._data);
        new IntegerField(8, 0, this._data);
        new IntegerField(12, 0, this._data);
        new IntegerField(16, 0, this._data);
        new IntegerField(20, 0, this._data);
        new ShortField(24, 59, this._data);
        new ShortField(26, 3, this._data);
        new ShortField(28, -2, this._data);
        new ShortField(30, 9, this._data);
        new IntegerField(32, 6, this._data);
        new IntegerField(36, 0, this._data);
        new IntegerField(40, 0, this._data);
        this._bat_count = new IntegerField(44, 0, this._data);
        this._property_start = new IntegerField(48, -2, this._data);
        new IntegerField(52, 0, this._data);
        new IntegerField(56, 4096, this._data);
        this._sbat_start = new IntegerField(60, -2, this._data);
        this._sbat_block_count = new IntegerField(64, 0, this._data);
        this._xbat_start = new IntegerField(68, -2, this._data);
        this._xbat_count = new IntegerField(72, 0, this._data);
    }

    public BATBlock[] setBATBlocks(int blockCount, int startBlock) {
        BATBlock[] rvalue;
        this._bat_count.set(blockCount, this._data);
        int limit = Math.min(blockCount, 109);
        int offset = 76;
        for (int j = 0; j < limit; ++j) {
            new IntegerField(offset, startBlock + j, this._data);
            offset += 4;
        }
        if (blockCount > 109) {
            int excess_blocks = blockCount - 109;
            int[] excess_block_array = new int[excess_blocks];
            for (int j = 0; j < excess_blocks; ++j) {
                excess_block_array[j] = startBlock + j + 109;
            }
            rvalue = BATBlock.createXBATBlocks(excess_block_array, startBlock + blockCount);
            this._xbat_start.set(startBlock + blockCount, this._data);
        } else {
            rvalue = BATBlock.createXBATBlocks(new int[0], 0);
            this._xbat_start.set(-2, this._data);
        }
        this._xbat_count.set(rvalue.length, this._data);
        return rvalue;
    }

    public void setPropertyStart(int startBlock) {
        this._property_start.set(startBlock, this._data);
    }

    public void setSBATStart(int startBlock) {
        this._sbat_start.set(startBlock, this._data);
    }

    public void setSBATBlockCount(int count) {
        this._sbat_block_count.set(count, this._data);
    }

    static int calculateXBATStorageRequirements(int blockCount) {
        return blockCount > 109 ? BATBlock.calculateXBATStorageRequirements(blockCount - 109) : 0;
    }

    void writeData(OutputStream stream) throws IOException {
        this.doWriteData(stream, this._data);
    }
}

