package ibase.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;

public class SmartFiltrCreator extends Composite
{
	LinkedHashMap<String, ArrayList<String>> datsSourceDtlMap = null;
	LinkedHashMap<String, JSONObject> componentDataMap = null;
	PopupPanel mainPopupPnl = new PopupPanel();
	final VerticalPanel popUpHPnl = new VerticalPanel();
	JSONObject jsonObjMetaData = null;
	ArrayList<String> fltrColumnDataList = null;
	HashMap<String, ArrayList<String>> fltrDataMap = null;
	String columnName = "";
	Document document = null;
	String xmlMetadata = null;
	Node rootNode = null;
	NodeList rootNodeList = null;
	NodeList filtrNodeList = null;
	NodeList fltrDtlNodeList = null;
	Node columNode = null;
	ArrayList<SmrtFilterInfo> fltrDtlList = null;
	SmrtFilterInfo filterInfo = null;
	ArrayList<String> parameterList = null;
	String viewOptionSelectd = "";
	GraphComponent component = null;
	MetaDataDtl dataDtl = null;

	public SmartFiltrCreator(LinkedHashMap<String, ArrayList<String>> datsSourceDtlMap, LinkedHashMap<String, JSONObject> componentDataMap, JSONObject jsonObjMetaData, ArrayList<String> parameterList)
	{
		this.datsSourceDtlMap = datsSourceDtlMap;
		this.componentDataMap = componentDataMap;
		this.jsonObjMetaData = jsonObjMetaData;
		this.parameterList = parameterList;
		viewOptionSelectd = parameterList.get(parameterList.size() - 1);
		component = new GraphComponent(parameterList, jsonObjMetaData, "N");
		dataDtl = new MetaDataDtl();
		this.initPopUpPnl();
	}

	private void initPopUpPnl()
	{
		mainPopupPnl.setPopupPosition(30, 50);
		mainPopupPnl.setStylePrimaryName("vPanelCSS");
		mainPopupPnl.getElement().setId("smartFilterMainOuterDiv");
		this.buildSmrtFiltr();
		mainPopupPnl.add(popUpHPnl);
		mainPopupPnl.show();
		this.filtrClickActn(fltrDtlList);
	}

	public HashMap<String, ArrayList<String>> getFilterData()
	{
		JSONObject dataJsn = null;
		JSONObject fetchRowWiseVal = null;
		String data = "";
		fltrDtlList = this.getSmartFilters(jsonObjMetaData);
		fltrColumnDataList = new ArrayList<String>();
		fltrDataMap = new HashMap<String, ArrayList<String>>();
		for (SmrtFilterInfo smrtFilterInfo : fltrDtlList)
		{
			fltrColumnDataList = new ArrayList<String>();
			columnName = smrtFilterInfo.getFltrColName();
			for (Map.Entry<String, JSONObject> entry : componentDataMap.entrySet())
			{
				dataJsn = entry.getValue();
				dataJsn = (JSONObject) dataJsn.get(entry.getKey());
				for (int jsnCnt = 0; jsnCnt < dataJsn.size(); jsnCnt++)
				{
					fetchRowWiseVal = (JSONObject) dataJsn.get(String.valueOf(jsnCnt));
					data = "" + fetchRowWiseVal.get(columnName);
					if (!"null".equals(data))
					{
						data = data.replace('"', ' ');
						if (data.trim().length() != 0)
						{
							if (!fltrColumnDataList.contains(data))
							{
								fltrColumnDataList.add(data);
							}
						}
					}
				}
			}
			fltrDataMap.put(columnName, fltrColumnDataList);
		}
		return fltrDataMap;
	}

	public ArrayList<SmrtFilterInfo> getSmartFilters(JSONObject jsonObjMetadata)
	{
		fltrDtlList = new ArrayList<SmrtFilterInfo>();
		if (jsonObjMetadata != null)
		{
			xmlMetadata = jsonObjMetadata.get("metaData").toString();
			xmlMetadata = jsonObjMetadata.get("metaData").toString().replace("\\", "").trim();
			xmlMetadata = xmlMetadata.replace('"', ' ').trim();
			try
			{
				document = XMLParser.parse(xmlMetadata);
				XMLParser.removeWhitespace(document);
				if (document != null)
				{
					rootNodeList = document.getElementsByTagName("Root").item(0).getChildNodes();
					for (int rootCtr = 0; rootCtr < rootNodeList.getLength(); rootCtr++)
					{
						rootNode = rootNodeList.item(rootCtr);
						if ("smart_filters".equals(rootNode.getNodeName()))
						{
							filtrNodeList = rootNode.getChildNodes();
							for (int fltrCtr = 0; fltrCtr < filtrNodeList.getLength(); fltrCtr++)
							{
								fltrDtlNodeList = filtrNodeList.item(fltrCtr).getChildNodes();
								filterInfo = new SmrtFilterInfo();

								filterInfo.setFltrType(filtrNodeList.item(fltrCtr).getAttributes().getNamedItem("type").getNodeValue());
								for (int dtlCnt = 0; dtlCnt < fltrDtlNodeList.getLength(); dtlCnt++)
								{
									columNode = fltrDtlNodeList.item(dtlCnt);
									if ("title_filter".equals(columNode.getNodeName()))
									{
										filterInfo.setFltrTitle(columNode.getChildNodes().item(0).getNodeValue());
									}
									if ("col_name_filter".equals(columNode.getNodeName()))
									{
										filterInfo.setFltrColName(columNode.getChildNodes().item(0).getNodeValue());
									}
									if ("selection_mode".equals(columNode.getNodeName()))
									{
										filterInfo.setFltrSelectnMode(columNode.getChildNodes().item(0).getNodeValue());
									}
								}
								fltrDtlList.add(filterInfo);
							}
						}
					}
				}
			} catch (Exception e)
			{
				Window.alert(" Exception :: SmartFiltrCreator:: getSmartFilters() :: MetaDataDtl  [" + e.getMessage() + "]");
			}
		}
		return fltrDtlList;
	}

	public void buildSmrtFiltr()
	{
		String fltrTitle = "";
		String fltrSelectnMode = "";
		String fltrType = "";
		VerticalPanel outerVPanel = null;
		VerticalPanel fltrTitlPnl = null;
		HorizontalPanel fltrComponentPnl = null;
		DateTimeFormat dateFormat = null;
		DateBox dateBox = null;
		TextBox inputTxtBox = null;
		Label fltrTitlLbl = null;

		fltrDtlList = this.getSmartFilters(jsonObjMetaData);
		fltrDataMap = this.getFilterData();

		for (SmrtFilterInfo smrtFilterInfo : fltrDtlList)
		{
			columnName = smrtFilterInfo.getFltrColName();
			fltrTitle = smrtFilterInfo.getFltrTitle();
			fltrSelectnMode = smrtFilterInfo.getFltrSelectnMode();
			fltrType = smrtFilterInfo.getFltrType();
			fltrColumnDataList = fltrDataMap.get(columnName);

			fltrTitlLbl = new Label(fltrTitle);
			outerVPanel = new VerticalPanel();
			fltrComponentPnl = new HorizontalPanel();
			fltrTitlPnl = new VerticalPanel();

			fltrTitlPnl.add(fltrTitlLbl);
			fltrTitlLbl.setStyleName("filterHeaderLabel");
			fltrTitlPnl.setStyleName("filterHeaderPanel");
			outerVPanel.add(fltrTitlPnl);

			if ("1".equals(fltrType))
			{
				if ("1".equals(fltrSelectnMode))
				{
					inputTxtBox = new TextBox();
					inputTxtBox.setTitle(columnName);
					inputTxtBox.setStylePrimaryName("textBoxCss");

					fltrComponentPnl.add(inputTxtBox);
					outerVPanel.add(fltrComponentPnl);
					popUpHPnl.add(outerVPanel);

				} else if ("2".equals(fltrSelectnMode))
				{
					new InputListWidget(fltrColumnDataList, fltrComponentPnl, smrtFilterInfo);
					outerVPanel.add(fltrComponentPnl);
					popUpHPnl.add(outerVPanel);

				} else if ("4".equals(fltrSelectnMode))
				{
					dateFormat = DateTimeFormat.getFormat("dd/MM/yyyy");
					dateBox = new DateBox();
					dateBox.setFormat(new DateBox.DefaultFormat(dateFormat));
					dateBox.setTitle(columnName);

					dateBox.setStylePrimaryName("textBoxCss");
					fltrComponentPnl.add(dateBox);
					outerVPanel.add(fltrComponentPnl);
					popUpHPnl.add(outerVPanel);
				} else if ("5".equals(fltrSelectnMode) || "3".equals(fltrSelectnMode))
				{
					if ("3".equals(fltrSelectnMode))
					{
						fltrComponentPnl.add(this.getChkBoxSlectnOptn(smrtFilterInfo, fltrColumnDataList));
					} else
					{
						fltrComponentPnl.add(this.getRdoBtnSlectnOptn(smrtFilterInfo, fltrColumnDataList));
					}
					outerVPanel.setHeight("200px");
					outerVPanel.add(fltrComponentPnl);
					popUpHPnl.add(outerVPanel);
				}
			}
		}
	}

	public Widget getChkBoxSlectnOptn(SmrtFilterInfo smrtFilterInfo, ArrayList<String> fltrColumnDataList)
	{
		final ScrollPanel checkboxScrlPnl = new ScrollPanel();
		checkboxScrlPnl.setTitle(smrtFilterInfo.getFltrColName());
		checkboxScrlPnl.setStyleName("filterScrlPnl");
		CheckBox chkBox = null;
		try
		{
			final FlexTable flexTable = new FlexTable();
			//flexTable.setBorderWidth(1);
			flexTable.setStyleName("flexTable");
			final CheckBox selectAllChkBox = new CheckBox();

			for (int colNo = 0; colNo < 2; colNo++)
			{
				if (colNo == 0)
				{
					flexTable.setWidget(0, 0, selectAllChkBox);
					flexTable.getCellFormatter().setAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
					flexTable.getCellFormatter().addStyleName(0, 0, "flexTable-cell");
				} else
				{
					flexTable.setText(0, 1, "All");
					flexTable.getCellFormatter().addStyleName(0, 1, "flexTable-cell");
				}
			}
			selectAllChkBox.addClickHandler(new ClickHandler()
			{
				@Override
				public void onClick(ClickEvent event)
				{
					CheckBox checkBox = (CheckBox) event.getSource();
					int noOfRow = flexTable.getRowCount();
					for (int rowCnt = 0; rowCnt < noOfRow; rowCnt++)
					{
						if (checkBox.getValue())
						{
							CheckBox box = (CheckBox) flexTable.getWidget(rowCnt + 1, 0);
							box.setValue(true);
						} else
						{
							CheckBox box = (CheckBox) flexTable.getWidget(rowCnt + 1, 0);
							box.setValue(false);
						}
					}
				}
			});
			for (int rowNo = 0; rowNo < fltrColumnDataList.size(); rowNo++)
			{
				int row = rowNo + 1;

				for (int colNo = 0; colNo < 2; colNo++)
				{
					if (colNo == 0)
					{
						chkBox = new CheckBox();
						chkBox.addClickHandler(new ClickHandler()
						{
							@Override
							public void onClick(ClickEvent event)
							{
								CheckBox checkBox = (CheckBox) event.getSource();
								if (!checkBox.getValue())
								{
									selectAllChkBox.setValue(false);
								}
							}
						});
						flexTable.getCellFormatter().setAlignment(row, colNo, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
						flexTable.getCellFormatter().setWidth(row, colNo, "5em");
						flexTable.setWidget(row, colNo, chkBox);
					} else
					{
						flexTable.setText(row, colNo, fltrColumnDataList.get(rowNo));
					}
				}
			}
			checkboxScrlPnl.add(flexTable);
		} catch (Exception e)
		{
			Window.alert(" Exception :: SmartFiltrCreator:: getChkBoxSlectnOptn() " + e.getMessage());
		}
		return checkboxScrlPnl;
	}

	public Widget getRdoBtnSlectnOptn(SmrtFilterInfo smrtFilterInfo, ArrayList<String> fltrColumnDataList)
	{
		final ScrollPanel radioBtnScrlPnl = new ScrollPanel();
		radioBtnScrlPnl.setTitle(smrtFilterInfo.getFltrColName());
		radioBtnScrlPnl.setStyleName("filterScrlPnl");
		RadioButton radioBtn = null;
		FlexTable flexTable = new FlexTable();
		try
		{
			flexTable.setStyleName("flexTable");
			for (int rowNo = 0; rowNo < fltrColumnDataList.size(); rowNo++)
			{
				for (int colNo = 0; colNo < 2; colNo++)
				{
					if (colNo == 0)
					{
						radioBtn = new RadioButton(smrtFilterInfo.getFltrTitle());
						/*
						 * radioBtn.addClickHandler(new ClickHandler() {
						 * 
						 * @Override public void onClick(ClickEvent event) { }
						 * });
						 */
						flexTable.getCellFormatter().setAlignment(rowNo, colNo, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
						flexTable.getCellFormatter().setWidth(rowNo, colNo, "5em");
						flexTable.setWidget(rowNo, colNo, radioBtn);

					} else
					{
						flexTable.setText(rowNo, colNo, fltrColumnDataList.get(rowNo));
					}
				}
			}
			radioBtnScrlPnl.add(flexTable);
		} catch (Exception e)
		{
			Window.alert("Exception :: SmartFiltrCreator:: getRdoBrnSlectnOptn() " + e.getMessage());
		}
		return radioBtnScrlPnl;
	}

	/*
	 * public void filtrClickActn(final ArrayList<SmrtFilterInfo>
	 * smrtFltrDtlList) {
	 * 
	 * mainPopupPnl.addDomHandler(new ClickHandler() {
	 * 
	 * @Override public void onClick(ClickEvent event) { HashMap<String,
	 * ArrayList<String>> selectedDataMap = getSelectnMap(smrtFltrDtlList); if
	 * (!selectedDataMap.isEmpty()) { getFilterdJson(selectedDataMap); } } },
	 * ClickEvent.getType());
	 * 
	 * 
	 * mainPopupPnl.addDomHandler(new KeyUpHandler() { public void
	 * onKeyUp(KeyUpEvent event) { int keyCode = event.getNativeKeyCode(); if
	 * (keyCode == KeyCodes.KEY_ENTER) { HashMap<String, ArrayList<String>>
	 * selectedDataMap = getSelectnMap(smrtFltrDtlList); if
	 * (!selectedDataMap.isEmpty()) { getFilterdJson(selectedDataMap); }
	 * 
	 * } } }, KeyUpEvent.getType()); }
	 */

	public HashMap<String, ArrayList<String>> getSelectnMap(ArrayList<SmrtFilterInfo> smrtFltrDtlList)
	{

		DateBox fltrDateBox = null;
		int row = 0;
		FlexTable grid = null;
		CheckBox checkBox = null;
		TextBox fltrTxtBox = null;
		BulletList bulletList = null;
		ScrollPanel scrollPnl = null;
		SmrtFilterInfo fltrInfo = null;
		String colName = "";
		ListItem listItem = null;
		Paragraph paragraph = null;
		HorizontalPanel horizontalPanel = null;
		VerticalPanel verticalPanel = null;
		ArrayList<String> selectedValueList = null;
		HashMap<String, ArrayList<String>> selectedDataMap = new HashMap<String, ArrayList<String>>();
		for (int i = 0; i < smrtFltrDtlList.size(); i++)
		{
			fltrInfo = smrtFltrDtlList.get(i);
			colName = fltrInfo.getFltrColName();
			for (int scrlPnlCnt = 0; scrlPnlCnt < popUpHPnl.getWidgetCount(); scrlPnlCnt++)
			{
				if (popUpHPnl.getWidget(scrlPnlCnt) instanceof VerticalPanel)
				{
					verticalPanel = (VerticalPanel) popUpHPnl.getWidget(scrlPnlCnt);
					if (verticalPanel.getWidget(1) instanceof HorizontalPanel)
					{
						horizontalPanel = (HorizontalPanel) verticalPanel.getWidget(1);
						if (horizontalPanel.getWidget(0) instanceof ScrollPanel)
						{
							scrollPnl = (ScrollPanel) horizontalPanel.getWidget(0);
							selectedValueList = new ArrayList<String>();
							grid = (FlexTable) scrollPnl.getWidget();
							row = grid.getRowCount();
							for (int rowCnt = 0; rowCnt < row; rowCnt++)
							{
								checkBox = (CheckBox) grid.getWidget(rowCnt, 0);
								if (checkBox.getValue())
								{
									if (rowCnt == 0)
									{
										if (!"All".equals(grid.getText(rowCnt, 1).trim()))
										{
											selectedValueList.add(grid.getText(rowCnt, 1).trim());
										}
									} else
									{
										selectedValueList.add(grid.getText(rowCnt, 1).trim());
									}
								}
							}
							if (scrollPnl.getTitle().equals(colName))
							{
								if (!selectedValueList.isEmpty())

									selectedDataMap.put(colName, selectedValueList);
							}

						} else if (horizontalPanel.getWidget(0) instanceof TextBox)
						{
							selectedValueList = new ArrayList<String>();

							fltrTxtBox = (TextBox) horizontalPanel.getWidget(0);
							if (fltrTxtBox.getTitle().equals(colName))
							{
								if (!fltrTxtBox.getText().isEmpty())
								{
									selectedValueList.add(fltrTxtBox.getText());
								}
								if (!selectedValueList.isEmpty())
									selectedDataMap.put(colName, selectedValueList);
							}
						} else if (horizontalPanel.getWidget(0) instanceof DateBox)
						{
							selectedValueList = new ArrayList<String>();
							fltrDateBox = (DateBox) horizontalPanel.getWidget(0);
							if (fltrDateBox.getTitle().equals(colName))
							{
								selectedValueList.add(DateTimeFormat.getFormat("dd/MM/yyyy").format(fltrDateBox.getValue()));
								fltrDateBox.hideDatePicker();

								if (!selectedValueList.isEmpty())
								{
									selectedDataMap.put(colName, selectedValueList);
								}
							}
						} else if (horizontalPanel.getWidget(0) instanceof BulletList)
						{
							bulletList = (BulletList) horizontalPanel.getWidget(0);
							selectedValueList = new ArrayList<String>();
							if (bulletList.getTitle().equals(colName))
							{
								for (int j = 0; j < bulletList.getWidgetCount(); j++)
								{
									if (bulletList.getWidget(j) instanceof ListItem)
									{
										listItem = (ListItem) bulletList.getWidget(j);
										if (listItem.getWidget(0) instanceof Paragraph)
										{
											paragraph = (Paragraph) listItem.getWidget(0);
											selectedValueList.add(paragraph.getText().trim());
										}
									}
								}
								if (!selectedValueList.isEmpty())
									selectedDataMap.put(colName, selectedValueList);
							}
						}
					}
				}
			}
		}
		return selectedDataMap;
	}

	public HashMap<String, ArrayList<String>> filtrClickActn(final ArrayList<SmrtFilterInfo> smrtFltrDtlList)
	{

		DateBox fltrDateBox = null;
		int row = 0;
		FlexTable grid = null;
		CheckBox checkBox = null;
		TextBox fltrTxtBox = null;
		BulletList bulletList = null;
		ScrollPanel scrollPnl = null;
		HorizontalPanel horizontalPanel = null;
		VerticalPanel verticalPanel = null;
		HashMap<String, ArrayList<String>> selectedDataMap = new HashMap<String, ArrayList<String>>();
		for (int scrlPnlCnt = 0; scrlPnlCnt < popUpHPnl.getWidgetCount(); scrlPnlCnt++)
		{
			if (popUpHPnl.getWidget(scrlPnlCnt) instanceof VerticalPanel)
			{
				verticalPanel = (VerticalPanel) popUpHPnl.getWidget(scrlPnlCnt);
				if (verticalPanel.getWidget(1) instanceof HorizontalPanel)
				{
					horizontalPanel = (HorizontalPanel) verticalPanel.getWidget(1);
					if (horizontalPanel.getWidget(0) instanceof ScrollPanel)
					{
						scrollPnl = (ScrollPanel) horizontalPanel.getWidget(0);
						grid = (FlexTable) scrollPnl.getWidget();
						row = grid.getRowCount();
						for (int rowCnt = 0; rowCnt < row; rowCnt++)
						{
							checkBox = (CheckBox) grid.getWidget(rowCnt, 0);
							this.addEnterKeyHndlr(checkBox, smrtFltrDtlList);
							this.addMouseClickHndlr(checkBox, smrtFltrDtlList);
						}
					} else if (horizontalPanel.getWidget(0) instanceof TextBox)
					{
						fltrTxtBox = (TextBox) horizontalPanel.getWidget(0);
						this.addEnterKeyHndlr(fltrTxtBox, smrtFltrDtlList);
						this.addMouseClickHndlr(fltrTxtBox, smrtFltrDtlList);

					} else if (horizontalPanel.getWidget(0) instanceof DateBox)
					{
						fltrDateBox = (DateBox) horizontalPanel.getWidget(0);
						this.addEnterKeyHndlr(fltrDateBox, smrtFltrDtlList);
						this.addMouseClickHndlr(fltrDateBox, smrtFltrDtlList);

					} else if (horizontalPanel.getWidget(0) instanceof BulletList)
					{
						bulletList = (BulletList) horizontalPanel.getWidget(0);
						this.addEnterKeyHndlr(fltrDateBox, smrtFltrDtlList);
						this.addMouseClickHndlr(fltrDateBox, smrtFltrDtlList);
					}
				}
			}
		}
		return selectedDataMap;
	}

	public void getFilterdJson(HashMap<String, ArrayList<String>> selectedDataMap)
	{
		ArrayList<String> presentKeyList = null;
		JSONObject dataJsn = null;
		JSONObject fetchRowWiseVal = null;
		String data = "";
		String coulumName = "";
		fltrDtlList = this.getSmartFilters(jsonObjMetaData);
		fltrColumnDataList = new ArrayList<String>();
		fltrDataMap = new HashMap<String, ArrayList<String>>();
		ArrayList<String> selectedDataList = null;
		LinkedHashMap<String, JSONObject> filterdDataMap = new LinkedHashMap<String, JSONObject>();
		JSONObject dataJsnObj = null;
		JSONObject filtrdJsn = null;
		for (Map.Entry<String, JSONObject> entry : componentDataMap.entrySet())
		{
			dataJsnObj = new JSONObject();
			dataJsn = entry.getValue();
			presentKeyList = new ArrayList<String>();
			dataJsn = (JSONObject) dataJsn.get(entry.getKey());
			int cnt = 0;
			for (Map.Entry<String, ArrayList<String>> selectedDataMap1 : selectedDataMap.entrySet())
			{
				coulumName = selectedDataMap1.getKey();
				fetchRowWiseVal = (JSONObject) dataJsn.get(String.valueOf(0));
				if (fetchRowWiseVal.containsKey(coulumName))
				{
					presentKeyList.add(coulumName);
				}
			}
			for (int jsnCnt = 0; jsnCnt < dataJsn.size(); jsnCnt++)
			{
				fetchRowWiseVal = (JSONObject) dataJsn.get(String.valueOf(jsnCnt));
				filtrdJsn = new JSONObject();
				int count = 0;
				for (String presntColumn : presentKeyList)
				{
					selectedDataList = selectedDataMap.get(presntColumn);
					data = "" + fetchRowWiseVal.get(presntColumn);
					data = data.replace('"', ' ');
					if (selectedDataList.contains(data.trim()) || selectedDataList.isEmpty())
					{
						count++;
					}
				}
				if (presentKeyList.size() == count && count != 0)
				{
					dataJsnObj.put("" + cnt, fetchRowWiseVal);
					cnt++;
				}
			}
			filtrdJsn.put(entry.getKey(), dataJsnObj);
			if (dataJsnObj.toString().length() > 5)
			{
				filterdDataMap.put(entry.getKey(), filtrdJsn);
			}
		}
		component.buildChart(filterdDataMap, dataDtl.getGridNMapMetData(jsonObjMetaData, viewOptionSelectd));
	}

	private void addMouseClickHndlr(Widget widget, final ArrayList<SmrtFilterInfo> smrtFltrDtlList)
	{
		widget.addDomHandler(new ClickHandler()
		{
			@Override
			public void onClick(ClickEvent event)
			{
				HashMap<String, ArrayList<String>> selectedDataMap = getSelectnMap(smrtFltrDtlList);
				if (!selectedDataMap.isEmpty())
				{
					getFilterdJson(selectedDataMap);
				}
			}
		}, ClickEvent.getType());

	}

	private void addEnterKeyHndlr(Widget widget, final ArrayList<SmrtFilterInfo> smrtFltrDtlList)
	{
		widget.addDomHandler(new KeyUpHandler()
		{
			public void onKeyUp(KeyUpEvent event)
			{
				int keyCode = event.getNativeKeyCode();
				if (keyCode == KeyCodes.KEY_ENTER)
				{
					HashMap<String, ArrayList<String>> selectedDataMap = getSelectnMap(smrtFltrDtlList);
					if (!selectedDataMap.isEmpty())
					{
						getFilterdJson(selectedDataMap);
					}

				}
			}
		}, KeyUpEvent.getType());

	}
}
