package ibase.webitm.ejb.fin;



import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TaxCalculation;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.encoding.XMLType;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

import oracle.sql.TIMESTAMP;

@Stateless
public class AssetSalesConf extends ActionHandlerEJB implements 
AssetSalesConfLocal,AssetSalesConfRemote 
  {

	GenericUtility genericUtility = GenericUtility.getInstance(); 
    FinCommon finCommon = new FinCommon();
   
	
	public String confirm(String tranId,String xtraParams, String forcedFlag) 
            throws RemoteException, ITMException
  {
		System.out.println("in AssetSalesConf EJB confirm action");
		 ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
		 MasterStatefulLocal masterStateful = null;
        Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String confirmed="";
		String  assetCode="",tranType="",acctCdPl="",cctrCdPl="",acctCdLoss="",cctrCdLoss="",itmSer="",itmCode = "",grpCode="",siteCode="",prdCdUpto="",prdCdUpfr="",saleCd="",lineNo="";
		java.sql.Timestamp currDate = null;
		java.sql.Timestamp procDate2ts = null;
		java.sql.Timestamp procdatets = null;
		String procDate2d = "",procdatetsm = "";
		String currCode = null,retString;
		double saleAmt = 0 ,exciseAmt=0,wdvAmt2=0;
		String errString = "",errCode="";
		String transer = "FASALE";
		boolean calc_depreciation;
		ITMDBAccessLocal itmdbAccess=new ITMDBAccessEJB();
		double totval = 0,depramt = 0,depramtrevl = 0,revalamt = 0;
	//	String procdate="",ldDate="";
		String varVal = "",cctrCode="",acctCode=""; 
		double modVat = 0,taxAmt=0,proLoss=0;
		Map addEdit= new HashMap();
		Map setVal= new HashMap();
		 String getAcctCctrLo="",getAcctCctrPl="",loginEmpCode="",getErr="";
		 String [] acctCctr;
		 SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
		 TaxCalculation taxCal = new TaxCalculation("assetsales");
		 int cnt = 0;
		 int cdupto=0,cdfr=0;
		 SimpleDateFormat sdf = null;
		 String currAppdate = "",pDatechk="";
		 int cdsl=0;
		 Date pdate  =null,cdate= null;
		 int rowCount = 0;
		 InitialContext ctx = null;
		 StringBuffer xmlBuff = new StringBuffer();
		 String xmlString="";
		try
	       { 
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			loginEmpCode=GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			loginEmpCode=loginEmpCode==null ? "" :loginEmpCode.trim();
			System.out.println("loginEmpCode---->>["+loginEmpCode+"]");
			
		
			    sql = "select a.confirmed, a.tran_date, a.sale_amt, a.tran_type, a.curr_code,"
			    		+ " b.asset_code,b.acct_code__pl, b.cctr_code__pl, b.acct_code__loss, "
			    		+ "b.cctr_code__loss, b.line_no from asset_sales_hdr a,asset_sales_det b "
			    		+ "where a.tran_id = b.tran_id and b.tran_id = ?";
			    		
			    pstmt=conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					
					confirmed = rs.getString(1) == null ? "":rs.getString(1);
					currDate = rs.getTimestamp(2);
					saleAmt = rs.getDouble(3);
					tranType = rs.getString(4) == null ? "":rs.getString(4);
					currCode =  rs.getString(5) == null ? "":rs.getString(5);
					assetCode = rs.getString(6) == null ? "":rs.getString(6);
		        	acctCdPl = rs.getString(7) == null ? "":rs.getString(7);
		        	cctrCdPl = rs.getString(8) == null ? "":rs.getString(8);
		        	acctCdLoss =  rs.getString(9) == null ? "":rs.getString(9);
		        	cctrCdLoss =  rs.getString(10) == null ? "":rs.getString(10);
		        	lineNo =  rs.getString(11) == null ? "":rs.getString(11);
					
		        	
		        	sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
					currDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
					currAppdate = sdf.format(currDate);
		        	
			 
				if(confirmed == "" || confirmed.equalsIgnoreCase("N"))
				{
										
					   sql = "select item_ser, item_code , grp_code, site_code, proc_date_2"
					    		+ " from asset_register where asset_code = ?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1,assetCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							
							itmSer = rs.getString(1) == null ? "":rs.getString(1);
							itmCode = rs.getString(2) == null ? "":rs.getString(2);
							grpCode = rs.getString(3) == null ? "":rs.getString(3);
							siteCode = rs.getString(4) == null ? "":rs.getString(4);
							procDate2ts = rs.getTimestamp(5);
							
						}
						pstmt.close();
						rs.close();
						pstmt = null;
						rs = null;
					       
						sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
						procDate2d = sdf.format(procDate2ts);
					
						
						
						   sql = "select prd_code__upto from asset_depr"
						    		+ " where asset_code = ? and item_ser = ? and grp_code= ?  and site_code = ?";
						  
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,assetCode);
							pstmt.setString(2,itmSer);
							pstmt.setString(3,grpCode);
							pstmt.setString(4,siteCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								
								prdCdUpto = rs.getString(1) == null ? "":rs.getString(1);
								
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
				
							System.out.println(">>>>PERIOD CODE UP TO>>>"+prdCdUpto);
							
							  if(prdCdUpto == "" || prdCdUpto.trim().length() == 0 )
							  {
								
								    sql = "select code from period where '"+procDate2d+"' between fr_date and to_date"; 		
								    pstmt=conn.prepareStatement(sql);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										prdCdUpto = rs.getString(1) == null ? "":rs.getString(1);
									}
									pstmt.close();
									rs.close();
									pstmt = null;
									rs = null;
								  
									
									sql = "select code from period where fr_date = (select fr_date from period where code = (select acct_prd from period where '"+currAppdate+"' between fr_date and to_date))"; 		
								    pstmt=conn.prepareStatement(sql);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										prdCdUpfr = rs.getString(1) == null ? "":rs.getString(1);
									}
									pstmt.close();
									rs.close();
									pstmt = null;
									rs = null;
									
									
									 System.out.println("prdCdUpfr.compareTo(prdCdUpto) > 0 >>> prdCdUpfr "+prdCdUpfr+">>>>>prdCdUpto"+prdCdUpto);
									if(prdCdUpfr.compareTo(prdCdUpto) > 0)
									{  
										prdCdUpto = prdCdUpfr;
									}
								
								
									   
											
								}
							  
							 
							    sql = "select code from period where '"+currAppdate+"' between fr_date and to_date"; 		
							    pstmt=conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									saleCd = rs.getString(1) == null ? "":rs.getString(1);
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
							    
							    System.out.println("saleCd.compareTo(prdCdUpto) >= 0 >>> sale cd"+saleCd+">>>>>"+prdCdUpto);
								if(saleCd.compareTo(prdCdUpto) >= 0)
								{
									
									    sql = "update asset_register set rem_date = ?,status=?,tran_id__rem=?,tran_ser__rem=?,rem_value=? where asset_code = ?"; 		
									    pstmt=conn.prepareStatement(sql);
									    pstmt.setString(1, currAppdate);
									    pstmt.setString(2, "S");
									    pstmt.setString(3, tranId);
									    pstmt.setString(4, transer);
									    pstmt.setDouble(5, saleAmt);
									    pstmt.setString(6, assetCode);
									    int chk = pstmt.executeUpdate();
										
									    if(chk > 0)
									    {
									    System.out.println("Records Updated");
									    }
									    
										pstmt.close();
										pstmt = null;
									
								}
								
							
								
								calc_depreciation = false;
								if(prdCdUpto.compareTo(saleCd) >= 0)
								{
								calc_depreciation = false;
								}
								else if (saleCd.compareTo(prdCdUpto) > 0)
								{
								calc_depreciation = true;
								}
								if(calc_depreciation == false)
								{
									errString = itmdbAccess.getErrorString("", "VTASSTSALE", "", "", conn);
									return errString;
								}
								else
								{
									
								     retString = confirmJournalVoucher("depr_proc_month", tranId, xtraParams, "", conn);
									 
								     if(retString.indexOf("Errors") > -1)
									   {
									    	errCode = retString;
											errString = itmDBAccess.getErrorString("",errCode,"","",conn);
											System.out.println("errString :>>kkk"+errString);
											return errString;
									    }
									
								}
								
								System.out.println("calling taxCalc");
								retString = taxCal.taxCalc(transer, tranId, currAppdate, "sale_amt", "", currCode, siteCode, "2");
								
								System.out.println("exit taxCalc>>"+retString);  
								if(retString.indexOf("Errors") > -1)
								 {
								    	errCode = retString;
										errString = itmDBAccess.getErrorString("",errCode,"","",conn);
										System.out.println("errString :>>kkk"+errString);
										return errString;
								  }
								
								
							
								sql = "select item_code, item_ser, total_value, excise_amt, wdv_amt_2, depr_amt_2, grp_code, depr_amt_revl_2 from 	asset_register where asset_code = ?"; 		
							    pstmt=conn.prepareStatement(sql);
							    pstmt.setString(1, assetCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									 itmCode = rs.getString(1) == null ? "":rs.getString(1);
									 itmSer = rs.getString(2) == null ? "":rs.getString(2);
									 totval = rs.getDouble(3);
									 exciseAmt = rs.getDouble(4);
									 wdvAmt2 = rs.getDouble(5);
									 depramt = rs.getDouble(6);
									 grpCode = rs.getString(7) == null ? "":rs.getString(7);
									 depramtrevl =  rs.getDouble(8);
									
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								
								
								
								sql = "select sum(case when revalue_amt is null then 0 else revalue_amt end) from asset_revalue where asset_code = ? and confirmed = ?"; 		
							    pstmt=conn.prepareStatement(sql);
								pstmt.setString(1, assetCode);
								pstmt.setString(2, "Y");
							    rs = pstmt.executeQuery();
								if(rs.next())
								{
									revalamt = rs.getDouble(1);
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								
								// Total Cost is Total Value + Ravalued Amount
								totval	= totval + revalamt;
								
								//ldDate = procdate;
								    pdate = formatter.parse(procDate2d);
	                                cdate = formatter.parse(currAppdate);
							   	
                              do {
                               
                              	pdate = addMonths(pdate, 3);
                              	System.out.println("Pdate is >>>>"+pdate);
                                System.out.println("CDate is >>>>"+cdate);
                              	cnt = cnt + 1;
                              	if(pdate.compareTo(cdate) >= 0)
                              	{
                              		System.out.println("BREAK>>>>>");
                              		break;
                              	}
								} while (true);
                             
                                System.out.println("loop exit>>cnt val"+cnt);
								modVat = ((totval * 2.5) / 100) * cnt;
								System.out.println("((totval * 2.5) / 100) * cnt = "+ modVat);
                                modVat = totval - modVat;
                                System.out.println("totval - modVat = "+ modVat);
                              
								
								sql = "select rtrim(var_value) from finparm where  prd_code = ? and var_name = ?"; 		
							    pstmt=conn.prepareStatement(sql);
								pstmt.setString(1, "999999");
								pstmt.setString(2, "FA_OLD_MODVAT");
							    rs = pstmt.executeQuery();
								if(rs.next())
								{
									varVal = rs.getString(1) == null ? "":rs.getString(1);
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								
								
								
								if(varVal == null || varVal.equals("N"))
								{
									sql = "select excreco_amt from asset_sales_hdr where tran_id = ?"; 		
								    pstmt=conn.prepareStatement(sql);
									pstmt.setString(1, tranId);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										modVat = rs.getDouble(1);
									}
									pstmt.close();
									rs.close();
									pstmt = null;
									rs = null;
								}
								
								
								
								
								proLoss = (saleAmt + depramt + depramtrevl) - (totval + modVat + taxAmt);
								System.out.println("(saleAmt + depramt + depramtrevl) - (totval + modVat + taxAmt) = "+proLoss);
								
								
								if(proLoss > 0)
								{
									if(acctCdPl != null && acctCdPl.trim().length() > 0)
									{
										cctrCode = cctrCdPl;
										acctCode = acctCdPl;		
									}else
									{
										
										getAcctCctrPl = finCommon.getAcctDetrTtype(itmCode, itmSer, "FA-PL", tranType, conn);
										
										if(getAcctCctrPl.equals(" , ") || getAcctCctrPl.equals(","))
										{
											acctCode = "";
											cctrCode = "";
										}
										else
										{
											acctCctr = getAcctCctrPl.split(",");
											acctCode = acctCctr[0];
											cctrCode = acctCctr[1];
										}
										
									}
									
								 
									
								}
								else
								{
									if(acctCdLoss != null && acctCdLoss.trim().length() > 0)
									{
										cctrCode = cctrCdLoss;
										acctCode = acctCdLoss;		
									}else
									{
										
										getAcctCctrLo = finCommon.getAcctDetrTtype(itmCode, itmSer, "FA-LOSS", tranType, conn);
										
										if(getAcctCctrLo.equals(" , ") || getAcctCctrLo.equals(","))
										{
											acctCode = "";
											cctrCode = "";
										}
										else
										{
											acctCctr = getAcctCctrLo.split(",");
											acctCode = acctCctr[0];
											cctrCode = acctCctr[1];
										}
										
									}
									
									
								}
									
								
								String errshow = gbfAssetSalePost(tranId, transer, lineNo, conn);
								System.out.println(">>>>ERR STRING CALL>>"+errshow);
								 if(errshow.length() > 0)
								 {
								    	System.out.println("mahesh called method");
									    errString = itmdbAccess.getErrorString("", "", "", "", conn);
										return errString;
										
								   }
								
								
								
									
									
									sql = "update asset_register set profit_loss = ? where asset_code = ?"; 		
								    pstmt=conn.prepareStatement(sql);
								    pstmt.setDouble(1, proLoss);
								    pstmt.setString(2, assetCode);
								    pstmt.executeUpdate();
									
									pstmt.close();
									pstmt = null;
							  
				  
				
				
				
				}
				else
				{
					System.out.println("already confirmed transaction");
					errString = itmdbAccess.getErrorString("", "VTFAPOST", "", "", conn);
					return errString;
				}
				
		        }
		
	   	
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
		        if(proLoss > 0)
				{
					sql = "update asset_sales_hdr set amount_profit = ? where tran_id = ?"; 		
				    pstmt=conn.prepareStatement(sql);
					pstmt.setDouble(1, Math.abs(proLoss));
					pstmt.setString(2, tranId);
					pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					
				}
				else
				{
					sql = "update asset_sales_hdr set amount_loss = ? where tran_id = ?"; 		
				    pstmt=conn.prepareStatement(sql);
					pstmt.setDouble(1, Math.abs(proLoss));
					pstmt.setString(2, tranId);
					pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
				}
				
			    sql = "update asset_sales_hdr set confirmed = ?,conf_date = ?,emp_code__aprv = ? where tran_id = ?"; 		
			    pstmt=conn.prepareStatement(sql);
			    pstmt.setString(1, "Y");
			    pstmt.setDate(2, new java.sql.Date(System.currentTimeMillis()));
			    pstmt.setString(3, loginEmpCode);
			    pstmt.setString(4, tranId);
			    
			    int chk = pstmt.executeUpdate();
				
			    if(chk > 0)
			    {
			    System.out.println("asset_sales Records Updated");
			    }
			    
				pstmt.close();
				pstmt = null;
			
	       }
	       catch(Exception e)
	       {
	    	    e.printStackTrace();
				System.out.println("Exception AssetSalesConf:confirm " 
	    	                       + e.getMessage());
				errString = e.getMessage();
				throw new ITMException(e);
	         
	       }  finally {
				try {
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
					if (conn != null) {
						conn.close();
					}
					conn = null;
				} catch (Exception d) {
					d.printStackTrace();
					System.out.println("Exception AssetSalesConf:confirm " + d);
				}
			}
	       return errString;
	
}
	private java.util.Date addMonths(java.util.Date date, int months) throws Exception ,ITMException //added by Kunal on 10/12/12 
	{
		java.util.Date calculatedDate = null;

		if (date != null) {
			final GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			calendar.add(Calendar.MONTH, months);
			calculatedDate = new java.util.Date(calendar.getTime().getTime());
		}

		return calculatedDate;
	}
	
	public String gbfAssetSalePost(String asTranId, String asTranser, String lineNo, Connection conn){
		String lsErrcode = "", lsConfirm = "", lsTranId = "", lsAssetCode = "", lsSiteCode = "", lsFinEntity = "";
		String lsCurrCode = "", lsItemSer = "",	lsGrpCode = "", lsItemCode = "", lsRemarks = "", lsCustCode = "";
		String lsBankCode = "", lsCrTerm = "", lsAcctCode = "", lsCctrCode1 = "", lsCctrCode = "", lsAcctAccCode = "";
		String lsCctrAccCode = "", lsAcctCodeAr = "", lsCctrCodeAr = "", lsAcctCodeMod = "", lsCctrCodeMod = "";
		String lsAcctCodePl = "", lsCctrCodePl = "", lsAcctCodeTax = "", lsCctrCodeTax = "", lsVarValue = "";
		String lsAcctCodeDrrev = "", lsCctrCodeDrrev = "", lsAcctCodeRrev = "", lsCctrCodeRrev = "";
		String lsCreditPrd = "", lsSaleType = "";
		
		/*java.sql.Date ldTranDate = new java.sql.Date(System.currentTimeMillis());
		java.sql.Date ldToday = new java.sql.Date(System.currentTimeMillis());
		java.sql.Date ldEffDate = new java.sql.Date(System.currentTimeMillis());
		java.sql.Date ldUseDate = new java.sql.Date(System.currentTimeMillis());
		java.sql.Date ldDate = new java.sql.Date(System.currentTimeMillis());
		java.sql.Date ldDueDate = new java.sql.Date(System.currentTimeMillis());*/
	
		Timestamp ldTranDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
		Timestamp ldEffDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
		Timestamp ldUseDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
		Timestamp ldDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
		Timestamp ldDueDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
		
		
		double lcTotalAmt = 0, lcSaleAmt = 0, lcTotalValue = 0, lcOrgExcise = 0;
		double lcWdvAmt2 = 0, lcDeprAmt2 = 0, lcRevalueAmt = 0, lcProfitLoss = 0;
		double lcExchRate = 0, lcTaxAmt = 0, lcModAmt = 0, lnAmountTax = 0;
		double lcExcrecoAmt = 0, lcDeprAmtRevl2 = 0, lcDeprAmtDel = 0, lcDeletionAmt = 0;
		double lcDeprAmtDelrevl = 0, lcDeletionAmtRevl = 0;
		
		String lsCctrCodeTemp[] = null;
		String lsCctrAccCodeTemp[] = null;
		String lsCctrCodeDrrevTemp[] = null;
		String lsCctrCodeRrevTemp[] = null;
		
		long llCnt = 0, llCreditPrd = 0;
		
		Calendar calendarInstance = Calendar.getInstance();
		Calendar calendarInstance2 = Calendar.getInstance();
		HashMap<String, Comparable> glTrace = null;
		HashMap glReceivables = null;
		
		boolean isError = false;
		
		    
			PreparedStatement pstmt = null,pstmt2 = null;
			ResultSet rs,rs2 = null;
			
		
		try{
			
				lsTranId	=	asTranId;
				
				String sql = "select  a.tran_date     , 	a.confirmed, 			a.total_amt, "+
						 " a.sale_amt      , 		a.tax_amt       , 	a.cust_code, "+
						 " (case when a.amount_profit = 0 then 0 - a.amount_loss else a.amount_profit end ), "+
						 " a.excreco_amt, b.asset_code, b.depr_amt_del, b.acct_code__ar , 		b.cctr_code__ar , 	b.deletion_amt, 		b.depr_amt_delrevl, "+
						 " b.acct_code__mod, 		b.cctr_code__mod, 	b.sale_type,			b.deletion_amt_revl, "+
						 " (case when b.amount_profit = 0 then b.acct_code__loss else b.acct_code__pl end ), "+
						 " (case when b.amount_profit = 0 then b.cctr_code__loss else b.cctr_code__pl end ) "
						 + "from asset_sales_hdr a,asset_sales_det b where	a.tran_id = b.tran_id and b.tran_id = ? and b.line_no = ?";
				
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,asTranId);
							pstmt.setString(2,lineNo);
							rs = pstmt.executeQuery();
				
						if(rs.next())
						{
							
							ldTranDate = rs.getTimestamp(1);
							lsConfirm = rs.getString(2);
							lcTotalAmt = rs.getDouble(3);
							lcSaleAmt = rs.getDouble(4);
							lcTaxAmt = rs.getDouble(5);
							lsCustCode = rs.getString(6);
							lcProfitLoss = rs.getDouble(7);
							lcExcrecoAmt = rs.getDouble(8);
							lsAssetCode = rs.getString(9);
							lcDeprAmtDel = rs.getDouble(10);
							lsAcctCodeAr = rs.getString(11);
							lsCctrCodeAr = rs.getString(12);
							lcDeletionAmt = rs.getDouble(13);
							lcDeprAmtDelrevl = rs.getDouble(14);
							lsAcctCodeMod = rs.getString(15);
							lsCctrCodeMod = rs.getString(16);
							lsSaleType = rs.getString(17);
							lcDeletionAmtRevl = rs.getDouble(18);
							lsAcctCodePl = rs.getString(19);
							lsCctrCodePl = rs.getString(20);
						
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						//end
				
						
					if("Y".equalsIgnoreCase(lsConfirm)){
						lsErrcode = "VTASETPOST";
					}
				
					lsRemarks = "On Sale of Asset :- " + lsAssetCode;
					ldEffDate = ldTranDate;
				
					sql = "select coalesce(credit_prd,0), bank_code, cr_term from customer where cust_code = ?";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,lsCustCode);
					rs = pstmt.executeQuery();
				
					if(rs.next()){
						llCreditPrd = rs.getLong(1);
						lsBankCode = rs.getString(2);
						lsCrTerm  = rs.getString(3);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
				if(llCreditPrd == 0){
					lsCreditPrd = finCommon.getFinparams("999999","DEF_CR_TERM", conn);
					lsCreditPrd = lsCreditPrd == null ? "" : lsCreditPrd.trim();
					if("NULLFOUND".equals(lsCreditPrd)){
						lsErrcode = "VSENVAR1";
					}else{
						llCreditPrd = Integer.parseInt(lsCreditPrd);
					}
				}
				
				// Due Date calculation
				calendarInstance.setTime(ldTranDate);
				calendarInstance.add(Calendar.DATE, (int) llCreditPrd);
				ldDueDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
				
				// Taking Original Value,Excise,WDV Amount from Asset Register
					sql = "select item_ser, site_code, grp_code, item_code, total_value, excise_amt, wdv_amt_2, depr_amt_2, " +
					  	  " use_date, cctr_code, depr_amt_revl_2 from asset_register where asset_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,lsAssetCode);
					rs = pstmt.executeQuery();
					
					if(rs.next()){
						lsItemSer = rs.getString(1).trim();
						lsSiteCode = rs.getString(2);
						lsGrpCode  = rs.getString(3).trim();
						lsItemCode = rs.getString(4).trim();
						lcTotalValue = rs.getDouble(5);
						lcOrgExcise = rs.getDouble(6); 
						lcWdvAmt2 = rs.getDouble(7);
						lcDeprAmt2 = rs.getDouble(8);
						ldUseDate = rs.getTimestamp(9); 
						lsCctrCode1 = rs.getString(10);
						lcDeprAmtRevl2 = rs.getDouble(11);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
				// Checking Financial Entity
					sql = "select fin_entity from site where site_code = ?";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,lsSiteCode);
					rs = pstmt.executeQuery();
				
					if(rs.next()){
						lsFinEntity = rs.getString(1);
					}else{
						lsErrcode = "VTFINENT";
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
				// Checking Currency Code
					sql = "select curr_code from finent where fin_entity = ?";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,lsFinEntity);
					rs = pstmt.executeQuery();
				
					if(rs.next()){
						lsCurrCode = rs.getString(1);
					}else{
						lsErrcode = "VTCURFIN";
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				
				// Checking Exchange Rate
					sql = "select std_exrt from currency where curr_code = ?";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,lsCurrCode);
					rs = pstmt.executeQuery();
				
					if(rs.next()){
						lcExchRate = rs.getDouble(1);
					}else{
						lsErrcode = "VTSRET2";
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					if(lcExchRate == 0){
						lsErrcode = "VTEXCHRATE";
					}
				
				lsCctrCode = finCommon.getAcctDetrTtype(lsItemCode,lsItemSer,"FA",lsGrpCode,conn);
				lsCctrCode = lsCctrCode == null ? "" : lsCctrCode.trim();
				lsCctrCodeTemp = lsCctrCode.split(",");
				lsAcctCode = lsCctrCodeTemp[0];
				
				lsAcctCode = lsAcctCode == null ? "" : lsAcctCode.trim();
				
				if(lsAcctCode.length() == 0){
					lsErrcode = "VTACCTCD1";
				}
				
				if(lsCctrCode1.length() > 0){
					lsCctrCode = lsCctrCode1;
				}
				
				// for ACCDEPR  	
				lsCctrAccCode = finCommon.getAcctDetrTtype(lsItemCode,lsItemSer,"ACCDEPR",lsGrpCode,conn);
				lsCctrAccCode = lsCctrAccCode == null ? "" : lsCctrAccCode.trim();
				lsCctrAccCodeTemp = lsCctrAccCode.split(",");
				lsAcctAccCode = lsCctrAccCodeTemp[0];
				
				if(lsAcctAccCode.length() == 0){
					lsErrcode = "VTACCTCD1";
				}
				
				if(lsCctrCode1.trim().length() > 0){
					lsCctrAccCode = lsCctrCode1;
				}
				
				// Taking total of Revalue Amount from Asset Revalue
				
				sql = "select coalesce(sum(revalue_amt),0) from asset_revalue where asset_code = ?";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,lsAssetCode);
				rs = pstmt.executeQuery();
			
				if(rs.next()){
					lcRevalueAmt = rs.getDouble(1);
				}
				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				// Counting the Modvat Period
				ldDate = ldUseDate;
				
				do{
					calendarInstance2.setTime(ldDate);
					calendarInstance2.add(Calendar.MONTH, 3);
					ldDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
					llCnt = llCnt + 1;
					
					if(ldDate.after(ldTranDate) || ldDate == ldTranDate){
						break;
					}
				}while(true);
				
				
				lcModAmt = ((lcOrgExcise * 2.5) / 100) * llCnt;
				lcModAmt = lcOrgExcise - lcModAmt;
				
				sql = "select rtrim(var_value) from finparm where prd_code = '999999' and  var_name = 'FA_OLD_MODVAT'";
				
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
			
				if(rs.next()){
					lsVarValue = rs.getString(1);
				}
				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				lsVarValue = lsVarValue == null ? "" : lsVarValue.trim();
				
				if(lsVarValue.length() == 0 || "N".equals(lsVarValue)){
					lcModAmt = lcExcrecoAmt;
				}
				
				if(lsCctrCode1.length() > 0){
					lsCctrCodeAr = lsCctrCode1;
				}else if(lsCctrCodeAr == null || lsCctrCodeAr.length() == 0){
					lsCctrCodeAr = "";
				}
				
				
				glTrace = new HashMap();
				
			    glTrace.put("tran_date",ldTranDate);
			    glTrace.put("eff_date",ldEffDate);
			    glTrace.put("fin_entity",lsFinEntity);
			    glTrace.put("site_code",lsSiteCode);
			    glTrace.put("sundry_type","C");
			    glTrace.put("sundry_code",lsCustCode);
			    glTrace.put("acct_code",lsAcctCodeAr);
			    glTrace.put("cctr_code",lsCctrCodeAr);
			    glTrace.put("emp_code","");
			    glTrace.put("anal_code","");
			    glTrace.put("curr_code",lsCurrCode);
			    glTrace.put("exch_rate",lcExchRate);
			    
			    if(lcTotalAmt >= 0){
			        glTrace.put("dr_amt",lcTotalAmt);
			        glTrace.put("cr_amt",0);
			    }else{
			        glTrace.put("dr_amt","0");
			        glTrace.put("cr_amt",0 - lcTotalAmt);
			    }
			    glTrace.put("ref_type","F");
			    glTrace.put("remarks",lsRemarks);
			    glTrace.put("ref_ser",asTranser);
			    glTrace.put("ref_id",lsTranId);
				
			    lsErrcode = finCommon.glTraceUpdate(glTrace,conn);
				if(lsErrcode.trim().length() > 0){
					return lsErrcode;
				}
				
				// Debiting Accumulated Depereciation A/c
				glTrace = new HashMap();
				
			    glTrace.put("tran_date",ldTranDate);
			    glTrace.put("eff_date",ldEffDate);
			    glTrace.put("fin_entity",lsFinEntity);
			    glTrace.put("site_code",lsSiteCode);
			    glTrace.put("sundry_type","O");
			    glTrace.put("sundry_code","");
			    glTrace.put("acct_code",lsAcctAccCode);
			    glTrace.put("cctr_code",lsCctrAccCode);
			    glTrace.put("emp_code","");
			    glTrace.put("anal_code","");
			    glTrace.put("curr_code",lsCurrCode);
			    glTrace.put("exch_rate",lcExchRate);
			    
			    if(lcDeprAmt2 >= 0){
			        glTrace.put("dr_amt",lcDeprAmt2);
			        glTrace.put("cr_amt",0);
			    }else{
			        glTrace.put("dr_amt","0");
			        glTrace.put("cr_amt", 0 - lcDeprAmt2);
			    }
			    glTrace.put("ref_type","F");
			    glTrace.put("remarks",lsRemarks);
			    glTrace.put("ref_ser",asTranser);
			    glTrace.put("ref_id",lsTranId);
				
			    lsErrcode = finCommon.glTraceUpdate(glTrace,conn);
				if(lsErrcode.trim().length() > 0){
					return lsErrcode;
				}
				
				
				if(lsCctrCode1.trim().length() > 0){
					lsCctrCodePl = lsCctrCode1;
				}else if(lsCctrCodePl == null || lsCctrCodePl.length() == 0){
					lsCctrCodePl = "";
				}
				
				// Profit OR Loss - Dr/Cr
				
				glTrace = new HashMap();
				
			    glTrace.put("tran_date",ldTranDate);
			    glTrace.put("eff_date",ldEffDate);
			    glTrace.put("fin_entity",lsFinEntity);
			    glTrace.put("site_code",lsSiteCode);
			    glTrace.put("sundry_type","O");
			    glTrace.put("sundry_code","");
			    glTrace.put("acct_code",lsAcctCodePl);
			    glTrace.put("cctr_code",lsCctrCodePl);
			    glTrace.put("emp_code","");
			    glTrace.put("anal_code","");
			    glTrace.put("curr_code",lsCurrCode);
			    glTrace.put("exch_rate",lcExchRate);
			    
			    if(lcProfitLoss >= 0){
			        glTrace.put("dr_amt",0);
			        glTrace.put("cr_amt",lcProfitLoss);
			    }else{
			        glTrace.put("dr_amt",0 - lcProfitLoss);
			        glTrace.put("cr_amt", 0);
			    }
			    glTrace.put("ref_type","F");
			    glTrace.put("remarks",lsRemarks);
			    glTrace.put("ref_ser",asTranser);
			    glTrace.put("ref_id",lsTranId);
				
			    lsErrcode = finCommon.glTraceUpdate(glTrace,conn);
				if(lsErrcode.trim().length() > 0){
					return lsErrcode;
				}
				
				// Crediting Fixed Asset A/c
				
				glTrace = new HashMap();
				
			    glTrace.put("tran_date",ldTranDate);
			    glTrace.put("eff_date",ldEffDate);
			    glTrace.put("fin_entity",lsFinEntity);
			    glTrace.put("site_code",lsSiteCode);
			    glTrace.put("sundry_type","O");
			    glTrace.put("sundry_code","");
			    glTrace.put("acct_code",lsAcctCode);
			    glTrace.put("cctr_code",lsCctrCodePl);
			    glTrace.put("emp_code","");
			    glTrace.put("anal_code","");
			    glTrace.put("curr_code",lsCurrCode);
			    glTrace.put("exch_rate",lcExchRate);
			    
			    if(lcTotalValue >= 0){
			        glTrace.put("dr_amt",0);
			        glTrace.put("cr_amt",lcTotalValue);
			    }else{
			        glTrace.put("dr_amt",0 - lcTotalValue);
			        glTrace.put("cr_amt", 0);
			    }
			    glTrace.put("ref_type","F");
			    glTrace.put("remarks",lsRemarks);
			    glTrace.put("ref_ser",asTranser);
			    glTrace.put("ref_id",lsTranId);
				
			    lsErrcode = finCommon.glTraceUpdate(glTrace,conn);
				if(lsErrcode.trim().length() > 0){
					return lsErrcode;
				}
				
				// following condition added - sheetal - 18/2/03
				if(lsCctrCode1.trim().length() > 0){
					lsCctrCodeMod = lsCctrCode1;  
				}else if(lsCctrCodeMod == null || lsCctrCodeMod.trim().length() == 0){
					lsCctrCodeMod = "";
				}
				
				// Crediting Modvat A/c
				
				glTrace = new HashMap();
				
			    glTrace.put("tran_date",ldTranDate);
			    glTrace.put("eff_date",ldEffDate);
			    glTrace.put("fin_entity",lsFinEntity);
			    glTrace.put("site_code",lsSiteCode);
			    glTrace.put("sundry_type","O");
			    glTrace.put("sundry_code","");
			    glTrace.put("acct_code",lsAcctCodeMod);
			    glTrace.put("cctr_code",lsCctrCodeMod);
			    glTrace.put("emp_code","");
			    glTrace.put("anal_code","");
			    glTrace.put("curr_code",lsCurrCode);
			    glTrace.put("exch_rate",lcExchRate);
			    
			    if(lcModAmt >= 0){
			        glTrace.put("dr_amt",0);
			        glTrace.put("cr_amt",lcModAmt);
			    }else{
			        glTrace.put("dr_amt",0 - lcModAmt);
			        glTrace.put("cr_amt", 0);
			    }
			    glTrace.put("ref_type","F");
			    glTrace.put("remarks",lsRemarks);
			    glTrace.put("ref_ser",asTranser);
			    glTrace.put("ref_id",lsTranId);
				
			    lsErrcode = finCommon.glTraceUpdate(glTrace,conn);
				if(lsErrcode.trim().length() > 0){
					return lsErrcode;
				}
				
				// Debiting the Customer for Receivables
				
				
				glReceivables = new HashMap();
				
				glReceivables.put("tran_ser",asTranser);
				glReceivables.put("tran_date",ldTranDate);
				glReceivables.put("eff_date",ldEffDate);
				glReceivables.put("fin_entity",lsFinEntity);
				glReceivables.put("site_code",lsSiteCode);
				glReceivables.put("ref_no",lsTranId);
				glReceivables.put("ref_date",ldTranDate);
				glReceivables.put("due_date",ldDueDate);
				glReceivables.put("curr_code",lsCurrCode);
				glReceivables.put("exch_rate",lcExchRate);
				glReceivables.put("cust_code",lsCustCode);
				glReceivables.put("acct_code",lsAcctCodeAr);
				glReceivables.put("cctr_code",lsCctrCodeAr);
				glReceivables.put("tax_amt",lcTaxAmt);
				glReceivables.put("discount",0);
				glReceivables.put("tot_amt",lcTotalAmt);
				glReceivables.put("bank_code",lsBankCode);
				glReceivables.put("cr_term",lsCrTerm);
				glReceivables.put("sales_pers","");
				glReceivables.put("item_ser",lsItemSer);
				glReceivables.put("mrp_value",0);
				glReceivables.put("gp_no","");
				glReceivables.put("gp_date","");
				glReceivables.put("cust_ref_no","");
				glReceivables.put("cust_ref_date","");
				glReceivables.put("cust_ref_amt","");
				
				lsErrcode = finCommon.gbfReceivablesUpd(glReceivables,conn);
				if(lsErrcode.trim().length() > 0){
					return lsErrcode;
				}
				
				// Credit Sales Tax A/c
				
				if(lcTaxAmt != 0){
					sql = "select acct_code, cctr_code, sum(case when tax_amt is null then 0 else tax_amt end)" +
						  " from taxtran where tran_code = ? and tran_id = ? group BY acct_code,cctr_code";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,asTranser);
					pstmt.setString(2,lsTranId);
					rs = pstmt.executeQuery();
					
					while(rs.next()){
						lsAcctCodeTax = rs.getString(1);
						lsCctrCodeTax = rs.getString(2);
						lnAmountTax = rs.getDouble(3);
						
						if(lnAmountTax != 0){
							if(lsAcctCodeTax == null || lsAcctCodeTax.length() == 0){
								sql = "select itemser.acct_code__sal, itemser.cctr_code__sal from itemser " +
									  " where item_ser = ?";
								pstmt2 = conn.prepareStatement(sql);
								pstmt2.setString(1,lsItemSer);
								rs2 = pstmt2.executeQuery();
								if(rs2.next()){
									lsAcctCodeTax = rs2.getString(1);
									lsCctrCodeTax = rs2.getString(2);
								}
								rs2.close();
								rs2 = null;
								pstmt2.close();
								pstmt2 = null;
							}
							
							glTrace = new HashMap();
							
						    glTrace.put("tran_date",ldTranDate);
						    glTrace.put("eff_date",ldEffDate);
						    glTrace.put("fin_entity",lsFinEntity);
						    glTrace.put("site_code",lsSiteCode);
						    glTrace.put("sundry_type","O");
						    glTrace.put("sundry_code","");
						    glTrace.put("acct_code",lsAcctCodeTax);
						    glTrace.put("cctr_code",lsCctrCodeTax);
						    glTrace.put("emp_code","");
						    glTrace.put("anal_code","");
						    glTrace.put("curr_code",lsCurrCode);
						    glTrace.put("exch_rate",lcExchRate);
						    
						    if(lnAmountTax >= 0){
						        glTrace.put("dr_amt",0);
						        glTrace.put("cr_amt",lnAmountTax);
						    }else{
						        glTrace.put("dr_amt",0 - lnAmountTax);
						        glTrace.put("cr_amt", 0);
						    }
						    glTrace.put("ref_type","F");
						    glTrace.put("remarks",lsRemarks);
						    glTrace.put("ref_ser",asTranser);
						    glTrace.put("ref_id",lsTranId);
							
						    lsErrcode = finCommon.glTraceUpdate(glTrace,conn);
							if(lsErrcode.trim().length() > 0){
								return lsErrcode;
							}
						}
					}
				}
				
				if(lcDeprAmtRevl2 != 0){
					//Get Depr. reserv revalue account code
					lsCctrCodeDrrev = finCommon.getAcctDetrTtype(lsItemCode,lsItemSer,"DRREV",lsGrpCode,conn);
					lsCctrCodeDrrev = lsCctrCodeDrrev == null ? "" : lsCctrCodeDrrev.trim();
					lsCctrCodeDrrevTemp = lsCctrCodeDrrev.split(",");
					lsAcctCodeDrrev = lsCctrAccCodeTemp[0];
					
					if(lsAcctCodeDrrev.length() == 0){
						lsErrcode = "VTACCTCD1";
						return lsErrcode;
					}
					// Debiting Depr. Reserve Revalue A/c
					glTrace = new HashMap();
					
				    glTrace.put("tran_date",ldTranDate);
				    glTrace.put("eff_date",ldEffDate);
				    glTrace.put("fin_entity",lsFinEntity);
				    glTrace.put("site_code",lsSiteCode);
				    glTrace.put("sundry_type","O");
				    glTrace.put("sundry_code","");
				    glTrace.put("acct_code",lsAcctCodeDrrev);
				    glTrace.put("cctr_code",lsCctrCodeDrrev);
				    glTrace.put("emp_code","");
				    glTrace.put("anal_code","");
				    glTrace.put("curr_code",lsCurrCode);
				    glTrace.put("exch_rate",lcExchRate);
				    
				    if(lcDeprAmtRevl2 >= 0){
				        glTrace.put("dr_amt",lcDeprAmtRevl2);
				        glTrace.put("cr_amt",0);
				    }else{
				        glTrace.put("dr_amt", 0);
				        glTrace.put("cr_amt", 0 - lcDeprAmtRevl2);
				    }
				    glTrace.put("ref_type","F");
				    glTrace.put("remarks",lsRemarks);
				    glTrace.put("ref_ser",asTranser);
				    glTrace.put("ref_id",lsTranId);
					
				    lsErrcode = finCommon.glTraceUpdate(glTrace,conn);
					if(lsErrcode.trim().length() > 0){
						return lsErrcode;
					}
				}
				
				if(lcRevalueAmt != 0){
				//Get Depr. Reserv Revalue account code
				lsCctrCodeRrev = finCommon.getAcctDetrTtype(lsItemCode,lsItemSer,"AREV",lsGrpCode,conn);
				lsCctrCodeRrev = lsCctrCodeRrev == null ? "" : lsCctrCodeRrev.trim();
				lsCctrCodeRrevTemp = lsCctrCodeRrev.split(",");
				lsAcctCodeRrev = lsCctrCodeRrevTemp[0];
					if(lsCctrCodeRrev.length() == 0){
						lsErrcode = "VTACCTCD1";
						return lsErrcode;
					}
				
				// Crediting Revalue A/c
				
				glTrace = new HashMap();
				
			    glTrace.put("tran_date",ldTranDate);
			    glTrace.put("eff_date",ldEffDate);
			    glTrace.put("fin_entity",lsFinEntity);
			    glTrace.put("site_code",lsSiteCode);
			    glTrace.put("sundry_type","O");
			    glTrace.put("sundry_code","");
			    glTrace.put("acct_code",lsAcctCodeDrrev);
			    glTrace.put("cctr_code",lsCctrCodeDrrev);
			    glTrace.put("emp_code","");
			    glTrace.put("anal_code","");
			    glTrace.put("curr_code",lsCurrCode);
			    glTrace.put("exch_rate",lcExchRate);
			    
			    if(lcRevalueAmt >= 0){
			        glTrace.put("dr_amt",0);
			        glTrace.put("cr_amt",lcRevalueAmt);
			    }else{
			        glTrace.put("dr_amt", 0 - lcRevalueAmt);
			        glTrace.put("cr_amt", 0);
			    }
			    glTrace.put("ref_type","F");
			    glTrace.put("remarks",lsRemarks);
			    glTrace.put("ref_ser",asTranser);
			    glTrace.put("ref_id",lsTranId);
				
			    lsErrcode = finCommon.glTraceUpdate(glTrace,conn);
				if(lsErrcode.trim().length() > 0){
					return lsErrcode;
				}
			}
				
			/* Note : The code in function gbf_post_online() is commented in PB it returns by default "Y" always and not migrated in Java
				thats why  here in if condition directly considered as function returns "Y" and condition become true always.*/ 
	
				/*			if(gbf_post_online() == "Y"){
					lsErrcode = finComman.checkGlTranDrCr(asTranser, lsTranId, conn);
				}*/
				lsErrcode = finCommon.checkGlTranDrCr(asTranser, lsTranId, conn);
				
			//}while(true);
		}catch(Exception e){
			
			try {
				conn.rollback();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			isError = true;
			System.out.println("Exception : : :==>\n"+e.getMessage());
			e.printStackTrace();
			//throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmt2 != null)
				{
					pstmt2.close();
					pstmt2 = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : : :==>\n"+e.getMessage());
				try
				{
					System.out.println("Before rollback");
					conn.rollback();
				}

				catch(SQLException sqle)
				{
					System.out.println(sqle);
				}
				//throw new ITMException(e);
			}
		}
			return lsErrcode;
	}
	
	
	 private String saveData(String siteCode, String xmlString, Connection conn,String xtraParams) throws ITMException
		{
		    System.out.println(siteCode+"enter in save data xtra params in sitecode"+siteCode);
			System.out.println("saving data...........");
			InitialContext ctx = null;
			String retString = null;
			MasterStatefulLocal masterStateful = null;
			try
			{
				AppConnectParm appConnect = new AppConnectParm();
				ctx = new InitialContext(appConnect.getProperty());
				masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");

				String [] authencate = new String[2];
				authencate[0] = "";
				authencate[1] = "";
				System.out.println("xmlString :::: " + xmlString);
				
				
				ValidatorEJB validatorEJB = new ValidatorEJB();
			    String userId = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			  //  siteCode = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			    DBAccessLocal dbAccess = (DBAccessLocal) ctx.lookup("ibase/DBAccessEJB/local");
			    String[] userInfoArray = dbAccess.getEmpInfo(userId, siteCode);
			    System.out.println("^^^^^^^ UserInfo ..> " + Arrays.toString(userInfoArray));
			    UserInfoBean userInfoBean = new UserInfoBean();
			    userInfoBean.setLoginCode(userId);
			    userInfoBean.setEmpCode(userInfoArray[0]);
			    userInfoBean.setEmpName(userInfoArray[1]);
			    userInfoBean.setReportTo(userInfoArray[2]);
			    userInfoBean.setDeptCode(userInfoArray[3]);
			    userInfoBean.setDeptDescr(userInfoArray[4]);
			    userInfoBean.setSiteCode(siteCode);
			    userInfoBean.setSiteDescr(userInfoArray[6]);
			    userInfoBean.setUserLevel(userInfoArray[7]);
			    userInfoBean.setUserType(userInfoArray[8]);
			    userInfoBean.setEntityCode(userInfoArray[9]);
			    userInfoBean.setProfileId(userInfoArray[10]);
			    userInfoBean.setItemSer(userInfoArray[11]);
			    userInfoBean.setEmailIdOff(userInfoArray[12]);
			    userInfoBean.setLoggerType(userInfoArray[13]);
			    userInfoBean.setStanCode(userInfoArray[14]);
			    userInfoBean.setDesignation(userInfoArray[15]);
			    userInfoBean.setDateJoin(userInfoArray[16]);
			    userInfoBean.setDivision(userInfoArray[17]);
			    userInfoBean.setUserLanguage(userInfoArray[18]);
			    userInfoBean.setUserCountry(userInfoArray[19]);
			    masterStateful = (MasterStatefulLocal) ctx.lookup("ibase/MasterStatefulEJB/local");
			    retString = masterStateful.processRequest(userInfoBean, xmlString, true, conn);
				
				
				System.out.println("masterstatefull,dbaccess and ctx will be null here");
				//retString = masterStateful.processRequest(authencate, siteCode, true, xmlString, true, conn);
				masterStateful = null;
//				dbAccess = null;
//				ctx = null;
				
			}
			catch(ITMException itme)
			{
				System.out.println("ITMException :PosConfirm :saveData :==>");
				throw itme;
			}
			catch(Exception e)
			{
				System.out.println("Exception :PosConfirm :saveData :==>");
				throw new ITMException(e);
			}
			return retString;
		} 
	
	 public String confirmJournalVoucher(String businessObj, String tranIdFr,String xtraParams, String forcedFlag, Connection conn) throws ITMException
	 {
	  String methodName = "";
	  String compName = "";
	  String retString = "";
	  String serviceCode = "";
	  String serviceURI = "";
	  String actionURI = "";
	  String sql = "";
	  PreparedStatement pstmt = null;
	  ResultSet rs = null;
	  //System.out.println("confirmJournalVoucher(String businessObj, String tranIdFr,String xtraParams, String forcedFlag, Connection conn) called >>>");

	  try
	  {
	   //ConnDriver connDriver = new ConnDriver();
	   //conn = connDriver.getConnectDB("DriverITM");

	   methodName = "gbf_post";
	   actionURI = "http://NvoServiceurl.org/" + methodName;

	   sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'process' ";
	   pstmt = conn.prepareStatement(sql);
	   pstmt.setString(1,businessObj);
	   rs = pstmt.executeQuery();
	   if ( rs.next() )
	   {
	    serviceCode = rs.getString("SERVICE_CODE");
	    compName = rs.getString("COMP_NAME");
	   }
	   System.out.println("serviceCode = "+serviceCode+" compName "+compName);
	   sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
	   pstmt = conn.prepareStatement(sql);
	   pstmt.setString(1,serviceCode);
	   rs = pstmt.executeQuery();
	   if ( rs.next() )
	   {
	    serviceURI = rs.getString("SERVICE_URI");
	   }
	   System.out.println("serviceURI = "+serviceURI+" compName = "+compName);
	   Service service = new Service();
	   Call call = (Call)service.createCall();
	   call.setTargetEndpointAddress(new java.net.URL(serviceURI));
	   call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
	   call.setUseSOAPAction(true);
	   call.setSOAPActionURI(actionURI);
	   Object[] aobj = new Object[4];

	   call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
	   call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
	   call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
	   call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

	   aobj[0] = new String(compName);
	   aobj[1] = new String(tranIdFr);
	   aobj[2] = new String(xtraParams);
	   aobj[3] = new String(forcedFlag);
	   //System.out.println("@@@@@@@@@@loginEmpCode:" +genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode")+":");
	   System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
	   call.setReturnType(XMLType.XSD_STRING);

	   retString = (String)call.invoke(aobj);

	   System.out.println("Confirm Complete @@@@@@@@@@@ Return string from NVO is:==>["+retString+"]");

	  }
	  catch(Exception e)
	  {
	   e.printStackTrace();
	   throw new ITMException(e);
	  }
	  finally
	  {  
	   try{


	    if (pstmt != null )
	    {
	     pstmt.close();
	     pstmt = null;
	    }
	    /*if( conn != null ){
	     conn.close();
	     conn = null;
	    }*/
	   }
	   catch(Exception e)
	   {
	    System.out.println("Exception inCalling confirmed");
	    e.printStackTrace();
	    try{
	     conn.rollback();

	    }catch (Exception s)
	    {
	     System.out.println("Unable to rollback");
	     s.printStackTrace();
	    }
	    throw new ITMException(e);
	   }

	  }
	  return retString;
	 }
	
}
