/*
 * Copyright 2012 Daniel Kurka
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package com.googlecode.gwtphonegap.client.splashscreen;

/**
 * The SplashScreen object allows to hide the splash screen.
 * 
 * You have to setup correctly the app so as it shows the splash screen earlier when the app is
 * started.
 * 
 * @see http://docs.phonegap.com/en/2.2.0/cordova_splashscreen_splashscreen.md.html
 * 
 * @author Manuel Carrasco
 * 
 */
public interface SplashScreen {

  /**
   * Hide the application splash screen.
   */
  public void hide();

  /**
   * Display the application splash screen.
   */
  public void show();
}
