/**
 *  Purpose:Create transaction  screen Pallet Request, Request ID:  W15GSUN001
 *  Purpose:Create Pallet Request with stock details ,Request ID: W15HSUN003
 *  Pallet Suffix description:::
 *  Normal Pallet         :Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::not in QC
 *  Pallet with suffix 'Q':Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::pending in QC
 *  Pallet with suffix 'X':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::not in QC
 *  Pallet with suffix 'M':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::pending in QC
 *  Pallet with suffix 'B':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::not in QC
 *  Pallet with suffix 'S':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::pending in QC
 *  Pallet with suffix 'P':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::not in QC
 *  Pallet with suffix 'U':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::pending in QC
 *  Pallet with suffix 'R':Rejected Pallet     
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.ejb.Stateless;
import org.w3c.dom.Document;

@Stateless
public class PalletReqExpiryAct extends ActionHandlerEJB
implements PalletReqExpiryActLocal, PalletReqExpiryActRemote
{
	DistCommon distComm = new DistCommon();
	public String actionHandler(String actionType, String xmlString, String xmlString1, String objContext, String xtraParams)
	throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		String retString = "";
		System.out.println("actionHandler:" + actionType);
		E12GenericUtility genericUtility = new E12GenericUtility();
		try {
			if ((xmlString != null) && (xmlString.trim().length() != 0))
			{
				System.out.println("XML String :" + xmlString);
				dom = genericUtility.parseString(xmlString);
			}
			if ((xmlString1 != null) && (xmlString1.trim().length() != 0))
			{
				System.out.println("XML String1 :" + xmlString1);
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (actionType.equalsIgnoreCase("EXPIRY"))
			{
				retString = stockExpiry(dom, dom1, "", null, false);
			}
			if (actionType.equalsIgnoreCase("NEXPIRY"))
			{
				retString = stockNearExpiry(dom, dom1, "", null, false);
			}
			if (actionType.equalsIgnoreCase("DEFAULT"))
			{
				retString = defaultData(dom, dom1, "", null, false);
			}
			if (actionType.equalsIgnoreCase("REJECTED"))
			{
				retString = invRejected(dom, dom1, "", null, false);
			}
			System.out.println("actionType:" + actionType + ":");
		}
		catch (Exception e)
		{
			System.out.println("Exception :PalletReqExpiryAct :actionHandler(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from PalletReqExpiryAct : actionHandler" + retString);
		return retString;
	}

	public String stockExpiry(Document dom, Document dom1, String forcedFlag, Connection conn, boolean conStat) throws Exception
	{
		String sql = ""; String palletNo = ""; String itemCode = ""; String lotNo = ""; String lotSl = ""; String quantity = ""; String noArt = ""; String siteCode = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String locCode = ""; String status = "",actualPallet ="",descr="",invDescr="",palletStatus= "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		//Changed and Commented By Santosh on 14-06-2016 :[START]
		//ConnDriver connDriver = new ConnDriver();
		//conn = connDriver.getConnectDB("DriverITM");
		conn = getConnection();
		//Changed and Commented By Santosh on 14-06-2016 :[END]
		StringBuffer xmlString = new StringBuffer("<Root>");
		String tranId="";
		try
		{
			siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));
			tranId = checkNullAndTrim(genericUtility.getColumnValue("tran_id",dom1));
			System.out.println("tran id---" +tranId);

			//Changed by Jagruti Shinde , for considering one pallet either for pallet out or pallet consolidation Request Id:[W16ASUN004]
			//Changed by Jagruti Shinde,for adding actaul_pallet and desc .Request id:[W16ASUN023]
			sql = " SELECT S.LOC_CODE AS PALLET_NO ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ,S.LOC_CODE AS ACTUAL_PALLET " +
			" ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM INV_HOLD_DET D,INV_HOLD I , LOCATION L ,STOCK S ,SWMS_TO_AWMS A , " +
			" SITEITEM T ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND S.LOT_NO = D.LOT_NO AND " +
			" S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND I.TRAN_ID = D.TRAN_ID  AND " +
			" L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? AND S.SITE_CODE = ? AND " +
			" A.IN_OUT = ? AND A.PALLET_NO = TRIM(S.LOC_CODE) AND A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND " +
			" A.LOT_SL = S.LOT_SL AND FN_CHK_PR(S.LOC_CODE,?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 " +
			" AND S.QTY_PER_ART > 0 AND L.INV_STAT = S.INV_STAT AND L.LOC_CODE = S.LOC_CODE AND T.ITEM_CODE = S.ITEM_CODE " +
			" AND S.SITE_CODE = T.SITE_CODE AND L.LOC_GROUP != ? AND T.ITEM_SER__RG1 NOT IN (?,?) AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART , " +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L , " +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L " +
			" ,STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND" +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1) IS NOT NULL AND  N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ?" +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL AND  " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) IS NOT NULL AND  N.INV_STAT = S.INV_STAT ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "R");
			pstmt.setString(2, "EXP_LOCK");
			pstmt.setString(3, "AWMS");
			pstmt.setString(4, siteCode);
			pstmt.setString(5, "S");
			//pstmt.setString(6, "P");
			pstmt.setString(6, tranId);
			pstmt.setString(7, "EXEX");
			pstmt.setString(8, "FS");
			pstmt.setString(9, "FA");
			pstmt.setString(10, "R");
			pstmt.setString(11, "EXP_LOCK");
			pstmt.setString(12, "AWMSQ");
			pstmt.setString(13, siteCode);
			pstmt.setString(14, "S");
			//pstmt.setString(16, "P");
			pstmt.setString(15, tranId);
			pstmt.setString(16, "R");
			pstmt.setString(17, "EXP_LOCK");
			pstmt.setString(18, "AWMS");
			pstmt.setString(19, siteCode);
			pstmt.setString(20, "S");
			//pstmt.setString(23, "P");
			pstmt.setString(21, tranId);
			pstmt.setString(22, "R");
			pstmt.setString(23, "EXP_LOCK");
			pstmt.setString(24, "AWMS");
			pstmt.setString(25, siteCode);
			pstmt.setString(26, "S");
			//pstmt.setString(30, "P");
			pstmt.setString(27, tranId);
			pstmt.setString(28, "R");
			pstmt.setString(29, "EXP_LOCK");
			pstmt.setString(30, "AWMSQ");
			pstmt.setString(31, siteCode);
			pstmt.setString(32, "S");
			//pstmt.setString(37, "P");
			pstmt.setString(33, tranId);
			pstmt.setString(34, "R");
			pstmt.setString(35, "EXP_LOCK");
			pstmt.setString(36, "AWMSQ");
			pstmt.setString(37, siteCode);
			pstmt.setString(38, "S");
			//pstmt.setString(44, "P");
			pstmt.setString(39, tranId);
			pstmt.setString(40, "R");
			pstmt.setString(41, "EXP_LOCK");
			pstmt.setString(42, "AWMS");
			pstmt.setString(43, siteCode);
			pstmt.setString(44, "S");
			//pstmt.setString(51, "P");
			pstmt.setString(45, tranId);
			pstmt.setString(46, "R");
			pstmt.setString(47, "EXP_LOCK");
			pstmt.setString(48, "AWMSQ");
			pstmt.setString(49, siteCode);
			pstmt.setString(50, "S");
			//pstmt.setString(58, "P");
			pstmt.setString(51, tranId);
			pstmt.setString(52, "R");
			pstmt.setString(53, "EXP_LOCK");
			pstmt.setString(54, "AWMSQ");
			pstmt.setString(55, siteCode);
			pstmt.setString(56, "S");
			//pstmt.setString(65, "P");
			pstmt.setString(57, tranId);
			rs = pstmt.executeQuery();

			while (rs.next())
			{
				palletNo = checkNullAndTrim(rs.getString("PALLET_NO"));
				itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
				lotNo = checkNullAndTrim(rs.getString("LOT_NO"));
				lotSl = checkNullAndTrim(rs.getString("LOT_SL"));
				quantity = checkNullAndTrim(rs.getString("QUANTITY"));
				noArt = checkNullAndTrim(rs.getString("NO_ART"));
				actualPallet = checkNullAndTrim(rs.getString("ACTUAL_PALLET"));
				descr = checkNullAndTrim(rs.getString("DESCR"));
				invDescr = checkNullAndTrim(rs.getString("INVSTAT_DECSR"));
				palletStatus = checkNullAndTrim(rs.getString("PALLET_STATUS"));

				xmlString.append("<Detail>");
				xmlString.append("<pallet_no>").append("<![CDATA[").append(palletNo).append("]]>").append("</pallet_no>");
				xmlString.append("<Actual_Pallet>").append("<![CDATA[").append(actualPallet).append("]]>").append("</Actual_Pallet>");
				xmlString.append("<Description>").append("<![CDATA[").append(descr).append("]]>").append("</Description>");
				xmlString.append("<Inv_Stat_Description>").append("<![CDATA[").append(invDescr).append("]]>").append("</Inv_Stat_Description>");
				xmlString.append("<item_code>").append("<![CDATA[").append(itemCode).append("]]>").append("</item_code>");
				xmlString.append("<lot_no>").append("<![CDATA[").append(lotNo).append("]]>").append("</lot_no>");
				xmlString.append("<lot_sl isSrvCallOnChg='1'>").append("<![CDATA[").append(lotSl).append("]]>").append("</lot_sl>");
				xmlString.append("<quantity isSrvCallOnChg='1'>").append("<![CDATA[").append(quantity).append("]]>").append("</quantity>");
				xmlString.append("<no_art isSrvCallOnChg='1'>").append("<![CDATA[").append(noArt).append("]]>").append("</no_art>");
				xmlString.append("<pallet_status>").append("<![CDATA[").append(palletStatus).append("]]>").append("</pallet_status>");

				xmlString.append("</Detail>");
			}
			xmlString.append("</Root>");
			rs.close();
			pstmt.close();
		}
		catch (SQLException sqx)
		{
			System.out.println("The sqlException occure in PalletReqExpiryAct :" + sqx);
			throw new ITMException(sqx);
		}
		catch (Exception e)
		{
			System.out.println("The Exception occure in PalletReqExpiryAct :" + e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				conn.close();
				conn = null;
			}
			catch (Exception localException1) {
			}
		}
		return xmlString.toString();
	}

	public String stockNearExpiry(Document dom, Document dom1, String forcedFlag, Connection conn, boolean conStat) throws Exception
	{
		String locCode = ""; String status = ""; String palletNo = ""; String itemCode = ""; String lotNo = ""; String lotSl = ""; String quantity = ""; String noArt = ""; String sql = ""; String siteCode = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		StringBuffer xmlString = new StringBuffer("<Root>");
		//Changed and Commented By Santosh on 14-06-2016 :[START]
		//ConnDriver connDriver = new ConnDriver();
		//conn = connDriver.getConnectDB("DriverITM");
		conn = getConnection();
		//Changed and Commented By Santosh on 14-06-2016 :[END]
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String tranId="",actualPallet ="",descr="" ,invDescr="",palletStatus= "";
		try
		{
			siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));
			tranId = checkNullAndTrim(genericUtility.getColumnValue("tran_id",dom1));
			System.out.println("tran id---" +tranId);

			//Changed by Jagruti Shinde , for considering one pallet either for pallet out or pallet consolidation Request Id:[W16ASUN004]
			//Changed by Jagruti Shinde,for adding actaul_pallet and desc .Request id:[W16ASUN023]
			sql = " SELECT S.LOC_CODE AS PALLET_NO ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ,S.LOC_CODE AS ACTUAL_PALLET " +
			" ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM INV_HOLD_DET D,INV_HOLD I , LOCATION L ,STOCK S ,SWMS_TO_AWMS A , " +
			" SITEITEM T ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND S.LOT_NO = D.LOT_NO AND " +
			" S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND I.TRAN_ID = D.TRAN_ID  AND " +
			" L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? AND S.SITE_CODE = ? AND " +
			" A.IN_OUT = ? AND A.PALLET_NO = TRIM(S.LOC_CODE) AND A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND " +
			" A.LOT_SL = S.LOT_SL AND FN_CHK_PR(S.LOC_CODE,?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 " +
			" AND S.QTY_PER_ART > 0 AND L.INV_STAT = S.INV_STAT AND L.LOC_CODE = S.LOC_CODE AND T.ITEM_CODE = S.ITEM_CODE " +
			" AND S.SITE_CODE = T.SITE_CODE AND L.LOC_GROUP != ? AND T.ITEM_SER__RG1 NOT IN (?,?) AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART , " +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L , " +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L " +
			" ,STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND" +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ? " +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1) IS NOT NULL AND  N.INV_STAT = S.INV_STAT " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
			" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
			" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
			" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ?" +
			" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) AND " +
			" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL AND  " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) IS NOT NULL AND  N.INV_STAT = S.INV_STAT ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "R");
			pstmt.setString(2, "NEXP_LOCK");
			pstmt.setString(3, "AWMS");
			pstmt.setString(4, siteCode);
			pstmt.setString(5, "S");
			//pstmt.setString(6, "P");
			pstmt.setString(6, tranId);
			pstmt.setString(7, "EXEX");
			pstmt.setString(8, "FS");
			pstmt.setString(9, "FA");
			pstmt.setString(10, "R");
			pstmt.setString(11, "NEXP_LOCK");
			pstmt.setString(12, "AWMSQ");
			pstmt.setString(13, siteCode);
			pstmt.setString(14, "S");
			//pstmt.setString(16, "P");
			pstmt.setString(15, tranId);
			pstmt.setString(16, "R");
			pstmt.setString(17, "NEXP_LOCK");
			pstmt.setString(18, "AWMS");
			pstmt.setString(19, siteCode);
			pstmt.setString(20, "S");
			//pstmt.setString(23, "P");
			pstmt.setString(21, tranId);
			pstmt.setString(22, "R");
			pstmt.setString(23, "NEXP_LOCK");
			pstmt.setString(24, "AWMS");
			pstmt.setString(25, siteCode);
			pstmt.setString(26, "S");
			//pstmt.setString(30, "P");
			pstmt.setString(27, tranId);
			pstmt.setString(28, "R");
			pstmt.setString(29, "NEXP_LOCK");
			pstmt.setString(30, "AWMSQ");
			pstmt.setString(31, siteCode);
			pstmt.setString(32, "S");
			//pstmt.setString(37, "P");
			pstmt.setString(33, tranId);
			pstmt.setString(34, "R");
			pstmt.setString(35, "NEXP_LOCK");
			pstmt.setString(36, "AWMSQ");
			pstmt.setString(37, siteCode);
			pstmt.setString(38, "S");
			//pstmt.setString(44, "P");
			pstmt.setString(39, tranId);
			pstmt.setString(40, "R");
			pstmt.setString(41, "NEXP_LOCK");
			pstmt.setString(42, "AWMS");
			pstmt.setString(43, siteCode);
			pstmt.setString(44, "S");
			//pstmt.setString(51, "P");
			pstmt.setString(45, tranId);
			pstmt.setString(46, "R");
			pstmt.setString(47, "NEXP_LOCK");
			pstmt.setString(48, "AWMSQ");
			pstmt.setString(49, siteCode);
			pstmt.setString(50, "S");
			//pstmt.setString(58, "P");
			pstmt.setString(51, tranId);
			pstmt.setString(52, "R");
			pstmt.setString(53, "NEXP_LOCK");
			pstmt.setString(54, "AWMSQ");
			pstmt.setString(55, siteCode);
			pstmt.setString(56, "S");
			//pstmt.setString(65, "P");
			pstmt.setString(57, tranId);
			rs = pstmt.executeQuery();

			while (rs.next())
			{
				palletNo = checkNullAndTrim(rs.getString("PALLET_NO"));
				itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
				lotNo = checkNullAndTrim(rs.getString("LOT_NO"));
				lotSl = checkNullAndTrim(rs.getString("LOT_SL"));
				quantity = checkNullAndTrim(rs.getString("QUANTITY"));
				noArt = checkNullAndTrim(rs.getString("NO_ART"));
				actualPallet = checkNullAndTrim(rs.getString("ACTUAL_PALLET"));
				descr = checkNullAndTrim(rs.getString("DESCR"));
				invDescr = checkNullAndTrim(rs.getString("INVSTAT_DECSR"));
				palletStatus = checkNullAndTrim(rs.getString("PALLET_STATUS"));

				xmlString.append("<Detail>");
				xmlString.append("<pallet_no>").append("<![CDATA[").append(palletNo).append("]]>").append("</pallet_no>");
				xmlString.append("<Actual_Pallet>").append("<![CDATA[").append(actualPallet).append("]]>").append("</Actual_Pallet>");
				xmlString.append("<Description>").append("<![CDATA[").append(descr).append("]]>").append("</Description>");
				xmlString.append("<Inv_Stat_Description>").append("<![CDATA[").append(invDescr).append("]]>").append("</Inv_Stat_Description>");
				xmlString.append("<item_code>").append("<![CDATA[").append(itemCode).append("]]>").append("</item_code>");
				xmlString.append("<lot_no>").append("<![CDATA[").append(lotNo).append("]]>").append("</lot_no>");
				xmlString.append("<lot_sl isSrvCallOnChg='1'>").append("<![CDATA[").append(lotSl).append("]]>").append("</lot_sl>");
				xmlString.append("<quantity isSrvCallOnChg='1'>").append("<![CDATA[").append(quantity).append("]]>").append("</quantity>");
				xmlString.append("<no_art isSrvCallOnChg='1'>").append("<![CDATA[").append(noArt).append("]]>").append("</no_art>");
				xmlString.append("<pallet_status>").append("<![CDATA[").append(palletStatus).append("]]>").append("</pallet_status>");

				xmlString.append("</Detail>");
			}
			xmlString.append("</Root>");
			rs.close();
			pstmt.close();
		}
		catch (SQLException sqx)
		{
			System.out.println("The sqlException occure in PalletReqExpiryAct :" + sqx);
			throw new ITMException(sqx);
		}
		catch (Exception e)
		{
			System.out.println("The Exception occure in PalletReqExpiryAct :" + e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				conn.close();
				conn = null;
			}
			catch (Exception localException1)
			{
			}
		}
		return xmlString.toString();
	}

	public String defaultData(Document dom, Document dom1, String forcedFlag, Connection conn, boolean conStat) throws Exception
	{
		String locCode = ""; String status = ""; String palletNo = ""; String itemCode = ""; String lotNo = ""; String lotSl = ""; String quantity = ""; String noArt = ""; String siteCode = ""; String sql = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		StringBuffer xmlString = new StringBuffer("<Root>");
		//Changed and Commented By Santosh on 14-06-2016 :[START]
		//ConnDriver connDriver = new ConnDriver();
		//conn = connDriver.getConnectDB("DriverITM");
		conn = getConnection();
		//Changed and Commented By Santosh on 14-06-2016 :[END]
		String tranId="",actualPallet ="",descr="",invDescr="";
		try
		{
			siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));

			tranId = checkNullAndTrim(genericUtility.getColumnValue("tran_id",dom1));
			System.out.println("tran id---" +tranId);

			//Changed by Jagruti Shinde , for considering one pallet either for pallet out or pallet consolidation Request Id:[W16ASUN004]
			//Changed by Jagruti Shinde,for adding actaul_pallet and desc .Request id:[W16ASUN023]
			//Changed by Jagruti Shinde,for adding CONTROLLED_YN validation to stock  .Request id:[W16DSUN008]
			sql = " SELECT S.LOC_CODE AS PALLET_NO,S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ,S.LOC_CODE AS ACTUAL_PALLET ," +
			" L.DESCR ,N.DESCR AS INVSTAT_DECSR  ,'' AS PALLET_STATUS  FROM STOCK S ,LOCATION L,SITEITEM T ,INVSTAT N ,ITEM I WHERE S.INV_STAT = ? AND " +
			" S.SITE_CODE = ? AND S.QTY_PER_ART > 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND L.INV_STAT = S.INV_STAT AND " +
			" L.LOC_CODE = S.LOC_CODE  AND L.LOC_GROUP != ? AND T.ITEM_CODE = S.ITEM_CODE AND " +
			" S.SITE_CODE = T.SITE_CODE AND T.ITEM_SER__RG1 NOT IN (?,?) AND FN_CHK_PR(S.LOC_CODE,?) = 0 AND " +
			" N.INV_STAT = S.INV_STAT AND S.ITEM_CODE=I.ITEM_CODE  AND S.SITE_CODE=I.SITE_CODE  AND" +
			" (I.CONTROLLED_YN = ? OR I.CONTROLLED_YN IS NULL)" +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1),S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,'' AS PALLET_STATUS  FROM STOCK S ,LOCATION L ,INVSTAT N ,ITEM I WHERE " +
			" S.INV_STAT = ? AND S.SITE_CODE= ? AND S.QTY_PER_ART > 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND  " +
			" L.LOC_CODE = S.LOC_CODE  AND L.INV_STAT = S.INV_STAT AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1),?) = 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'Q')-1) " +
			" IS NOT NULL AND N.INV_STAT = S.INV_STAT AND S.ITEM_CODE=I.ITEM_CODE  AND S.SITE_CODE=I.SITE_CODE" +
			"  AND (I.CONTROLLED_YN = ? OR I.CONTROLLED_YN IS NULL)" +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1),S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,'' AS PALLET_STATUS  FROM STOCK S ,LOCATION L ,INVSTAT N ,ITEM I WHERE " +
			" S.INV_STAT = ? AND S.SITE_CODE= ? AND S.QTY_PER_ART > 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND  " +
			" L.LOC_CODE = S.LOC_CODE  AND L.INV_STAT = S.INV_STAT AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1),?) = 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'B')-1) " +
			" IS NOT NULL AND N.INV_STAT = S.INV_STAT AND S.ITEM_CODE=I.ITEM_CODE  AND S.SITE_CODE=I.SITE_CODE  AND " +
			" (I.CONTROLLED_YN = ? OR I.CONTROLLED_YN IS NULL)" +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1),S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,'' AS PALLET_STATUS FROM STOCK S ,LOCATION L ,INVSTAT N ,ITEM I WHERE " +
			" S.INV_STAT = ? AND S.SITE_CODE= ? AND S.QTY_PER_ART > 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" L.LOC_CODE = S.LOC_CODE AND  L.INV_STAT = S.INV_STAT AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1),?) = 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'X')-1) " +
			" IS NOT NULL AND N.INV_STAT = S.INV_STAT AND S.ITEM_CODE=I.ITEM_CODE  AND S.SITE_CODE=I.SITE_CODE  AND " +
			" (I.CONTROLLED_YN = ? OR I.CONTROLLED_YN IS NULL) " +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1),S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,'' AS PALLET_STATUS  FROM STOCK S ,LOCATION L ,INVSTAT N ,ITEM I WHERE " +
			" S.INV_STAT = ? AND S.SITE_CODE= ? AND S.QTY_PER_ART > 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" L.LOC_CODE = S.LOC_CODE  AND L.INV_STAT = S.INV_STAT AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1),?) = 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'M')-1) " +
			" IS NOT NULL AND N.INV_STAT = S.INV_STAT AND S.ITEM_CODE=I.ITEM_CODE  AND S.SITE_CODE=I.SITE_CODE  " +
			" AND (I.CONTROLLED_YN = ? OR I.CONTROLLED_YN IS NULL)" +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1),S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,'' AS PALLET_STATUS FROM STOCK S ,LOCATION L ,INVSTAT N ,ITEM I WHERE " +
			" S.INV_STAT = ? AND S.SITE_CODE= ? AND S.QTY_PER_ART > 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" L.LOC_CODE = S.LOC_CODE  AND L.INV_STAT = S.INV_STAT AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1),?) = 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'U')-1) " +
			" IS NOT NULL AND N.INV_STAT = S.INV_STAT AND S.ITEM_CODE=I.ITEM_CODE  AND S.SITE_CODE=I.SITE_CODE  AND " +
			" (I.CONTROLLED_YN = ? OR I.CONTROLLED_YN IS NULL)" +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1),S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
			" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,'' AS PALLET_STATUS FROM STOCK S ,LOCATION L ,INVSTAT N ,ITEM I WHERE " +
			" S.INV_STAT = ? AND S.SITE_CODE= ? AND S.QTY_PER_ART > 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" L.LOC_CODE = S.LOC_CODE  AND L.INV_STAT = S.INV_STAT AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1),?) = 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'P')-1) " +
			" IS NOT NULL AND N.INV_STAT = S.INV_STAT AND S.ITEM_CODE=I.ITEM_CODE  AND S.SITE_CODE=I.SITE_CODE  AND " +
			" (I.CONTROLLED_YN = ? OR I.CONTROLLED_YN IS NULL)" +
			" UNION ALL " +
			" SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1),S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART " +
			",S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,'' AS PALLET_STATUS  FROM STOCK S ,LOCATION L ,INVSTAT N ,ITEM I WHERE " +
			" S.INV_STAT = ? AND S.SITE_CODE= ? AND S.QTY_PER_ART > 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			" L.LOC_CODE = S.LOC_CODE  AND L.INV_STAT = S.INV_STAT AND " +
			" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1),?) = 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'S')-1) " +
			" IS NOT NULL AND N.INV_STAT = S.INV_STAT AND S.ITEM_CODE=I.ITEM_CODE  AND S.SITE_CODE=I.SITE_CODE  AND " +
			" (I.CONTROLLED_YN = ? OR I.CONTROLLED_YN IS NULL)";

			PreparedStatement pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "AWMS");
			pstmt.setString(2, siteCode);
			pstmt.setString(3, "EXEX");
			pstmt.setString(4, "FS");
			pstmt.setString(5, "FA");
			pstmt.setString(6, tranId);
			pstmt.setString(7, "N");
			pstmt.setString(8, "AWMSQ");
			pstmt.setString(9, siteCode);
			pstmt.setString(10, tranId);
			pstmt.setString(11, "N");
			pstmt.setString(12, "AWMS");
			pstmt.setString(13, siteCode);
			pstmt.setString(14, tranId);
			pstmt.setString(15, "N");
			pstmt.setString(16, "AWMS");
			pstmt.setString(17, siteCode);
			pstmt.setString(18, tranId);
			pstmt.setString(19, "N");
			pstmt.setString(20, "AWMSQ");
			pstmt.setString(21, siteCode);
			pstmt.setString(22, tranId);
			pstmt.setString(23, "N");
			pstmt.setString(24, "AWMSQ");
			pstmt.setString(25, siteCode);
			pstmt.setString(26, tranId);
			pstmt.setString(27, "N");
			pstmt.setString(28, "AWMS");
			pstmt.setString(29, siteCode);
			pstmt.setString(30, tranId);
			pstmt.setString(31, "N");
			pstmt.setString(32, "AWMSQ");
			pstmt.setString(33, siteCode);
			pstmt.setString(34, tranId);
			pstmt.setString(35, "N");

			ResultSet rs = pstmt.executeQuery();



			while (rs.next())
			{
				palletNo = checkNullAndTrim(rs.getString("PALLET_NO"));
				itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
				lotNo = checkNullAndTrim(rs.getString("LOT_NO"));
				lotSl = checkNullAndTrim(rs.getString("LOT_SL"));
				quantity = checkNullAndTrim(rs.getString("QUANTITY"));
				noArt = checkNullAndTrim(rs.getString("NO_ART"));
				actualPallet = checkNullAndTrim(rs.getString("ACTUAL_PALLET"));
				descr = checkNullAndTrim(rs.getString("DESCR"));
				invDescr = checkNullAndTrim(rs.getString("INVSTAT_DECSR"));

				xmlString.append("<Detail>");
				xmlString.append("<pallet_no>").append("<![CDATA[").append(palletNo).append("]]>").append("</pallet_no>");
				xmlString.append("<Actual_Pallet>").append("<![CDATA[").append(actualPallet).append("]]>").append("</Actual_Pallet>");
				xmlString.append("<Description>").append("<![CDATA[").append(descr).append("]]>").append("</Description>");
				xmlString.append("<Inv_Stat_Description>").append("<![CDATA[").append(invDescr).append("]]>").append("</Inv_Stat_Description>");
				xmlString.append("<item_code>").append("<![CDATA[").append(itemCode).append("]]>").append("</item_code>");
				xmlString.append("<lot_no>").append("<![CDATA[").append(lotNo).append("]]>").append("</lot_no>");
				xmlString.append("<lot_sl isSrvCallOnChg='1'>").append("<![CDATA[").append(lotSl).append("]]>").append("</lot_sl>");
				xmlString.append("<quantity isSrvCallOnChg='1'>").append("<![CDATA[").append(quantity).append("]]>").append("</quantity>");
				xmlString.append("<no_art isSrvCallOnChg='1'>").append("<![CDATA[").append(noArt).append("]]>").append("</no_art>");

				xmlString.append("</Detail>");
			}
			xmlString.append("</Root>");
			rs.close();
			pstmt.close();
		}
		catch (SQLException sqx)
		{
			System.out.println("The sqlException occure in PalletReqExpiryAct :" + sqx);
			throw new ITMException(sqx);
		}
		catch (Exception e)
		{
			System.out.println("The Exception occure in PalletReqExpiryAct :" + e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				conn.close();
				conn = null;
			}
			catch (Exception localException1)
			{
			}
		}
		return xmlString.toString();
	}

	//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet request,Pallet request with stock details.Request id:[W16ASUN022][start]
	public String invRejected(Document dom, Document dom1, String forcedFlag, Connection conn, boolean conStat) throws Exception
	{
		String locCode = "", status = "", palletNo = "", itemCode = "", lotNo = "", lotSl = "", quantity = "", noArt = "", siteCode = "", sql = "",rejectedLoc="";
		E12GenericUtility genericUtility = new E12GenericUtility();
		StringBuffer xmlString = new StringBuffer("<Root>");
		//Changed and Commented By Santosh on 14-06-2016 :[START]
		//ConnDriver connDriver = new ConnDriver();
		//conn = connDriver.getConnectDB("DriverITM");
		conn = getConnection();
		//Changed and Commented By Santosh on 14-06-2016 :[END]
		String tranId="",actualPallet ="",descr="",invDescr ="",palletStatus="";
		rejectedLoc = distComm.getDisparams("999999","REJECTED_LOCKS",conn);
		//Changed by Jagruti Shinde Request id:[W16CSUN009]
		ArrayList<String> rejectedLocArryList = new ArrayList<String>();
		try
		{
			siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code", dom1));

			tranId = checkNullAndTrim(genericUtility.getColumnValue("tran_id",dom1));
			String[] rejectedLocArry=rejectedLoc.split(",");

			for(String value:rejectedLocArry){
				rejectedLocArryList.add(value);
			}

			System.out.println("REJECTED  LOCATINOS ARRAY LIST : "+rejectedLocArryList);

			/*sql = " SELECT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) AS PALLET_NO ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY," +
			      " S.NO_ART ,S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR FROM STOCK S ,LOCATION L ,INVSTAT N " +
			      " WHERE S.INV_STAT = ? AND S.SITE_CODE = ? AND S.QTY_PER_ART > 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
			      " L.LOC_CODE = S.LOC_CODE  AND L.INV_STAT = S.INV_STAT AND " +
			      " FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1),?) = 0 " +
			      " AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) IS NOT NULL AND N.INV_STAT = S.INV_STAT  ";*/

			System.out.println("rejectedLocArryList size"+rejectedLocArryList.size());
			for(int i=0; i< rejectedLocArryList.size(); i++)
			{
				rejectedLoc = rejectedLocArryList.get(i);
				sql = " SELECT DISTINCT SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) AS PALLET_NO ,S.ITEM_CODE, S.LOT_NO,S.LOT_SL,S.QUANTITY, S.NO_ART ," +
				" S.LOC_CODE AS ACTUAL_PALLET ,L.DESCR ,N.DESCR AS INVSTAT_DECSR ,A.PALLET_STATUS FROM  INV_HOLD_DET D,INV_HOLD I , LOCATION L ," +
				" STOCK S ,SWMS_TO_AWMS A ,INVSTAT N WHERE  S.ITEM_CODE = D.ITEM_CODE AND S.LOC_CODE = D.LOC_CODE AND " +
				" S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND S.SITE_CODE = D.SITE_CODE AND D.LOC_CODE = L.LOC_CODE  AND " +
				" I.TRAN_ID = D.TRAN_ID  AND L.LOC_CODE = S.LOC_CODE AND D.HOLD_STATUS != ? AND I.LOCK_CODE = ? AND S.INV_STAT = ?" +
				" AND S.SITE_CODE = ? AND A.IN_OUT = ? AND A.PALLET_NO = SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) AND " +
				" A.ITEM_CODE = S.ITEM_CODE AND A.LOT_NO = S.LOT_NO AND A.LOT_SL = S.LOT_SL  AND " +
				" FN_CHK_PR(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1),?) = 0 AND S.QUANTITY > 0 AND S.NO_ART > 0 AND " +
				" S.QTY_PER_ART > 0 AND SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,'R')-1) IS NOT NULL AND  N.INV_STAT = S.INV_STAT ";

				PreparedStatement pstmt = conn.prepareStatement(sql);
				/*pstmt.setString(1, "AWMSQ");
			      pstmt.setString(2, siteCode);
			      pstmt.setString(3, tranId);*/

				pstmt.setString(1, "R");
				pstmt.setString(2, rejectedLoc);
				pstmt.setString(3, "AWMSQ");
				pstmt.setString(4, siteCode);
				pstmt.setString(5, "S");
				pstmt.setString(6, tranId);

				ResultSet rs = pstmt.executeQuery();

				while (rs.next())
				{
					palletNo = checkNullAndTrim(rs.getString("PALLET_NO"));
					itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
					lotNo = checkNullAndTrim(rs.getString("LOT_NO"));
					lotSl = checkNullAndTrim(rs.getString("LOT_SL"));
					quantity = checkNullAndTrim(rs.getString("QUANTITY"));
					noArt = checkNullAndTrim(rs.getString("NO_ART"));
					actualPallet = checkNullAndTrim(rs.getString("ACTUAL_PALLET"));
					descr = checkNullAndTrim(rs.getString("DESCR"));
					invDescr = checkNullAndTrim(rs.getString("INVSTAT_DECSR"));
					palletStatus = checkNullAndTrim(rs.getString("PALLET_STATUS"));

					xmlString.append("<Detail>");
					xmlString.append("<pallet_no>").append("<![CDATA[").append(palletNo).append("]]>").append("</pallet_no>");
					xmlString.append("<Actual_Pallet>").append("<![CDATA[").append(actualPallet).append("]]>").append("</Actual_Pallet>");
					xmlString.append("<Description>").append("<![CDATA[").append(descr).append("]]>").append("</Description>");
					xmlString.append("<Inv_Stat_Description>").append("<![CDATA[").append(invDescr).append("]]>").append("</Inv_Stat_Description>");
					xmlString.append("<item_code>").append("<![CDATA[").append(itemCode).append("]]>").append("</item_code>");
					xmlString.append("<lot_no>").append("<![CDATA[").append(lotNo).append("]]>").append("</lot_no>");
					xmlString.append("<lot_sl isSrvCallOnChg='1'>").append("<![CDATA[").append(lotSl).append("]]>").append("</lot_sl>");
					xmlString.append("<quantity isSrvCallOnChg='1'>").append("<![CDATA[").append(quantity).append("]]>").append("</quantity>");
					xmlString.append("<no_art isSrvCallOnChg='1'>").append("<![CDATA[").append(noArt).append("]]>").append("</no_art>");
					xmlString.append("<pallet_status>").append("<![CDATA[").append(palletStatus).append("]]>").append("</pallet_status>");

					xmlString.append("</Detail>");
				}

				rs.close();
				pstmt.close();
			}
			xmlString.append("</Root>");
		}
		catch (SQLException sqx)
		{
			System.out.println("The sqlException occure in PalletReqExpiryAct :" + sqx);
			throw new ITMException(sqx);
		}
		catch (Exception e)
		{
			System.out.println("The Exception occure in PalletReqExpiryAct :" + e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				conn.close();
				conn = null;
			}
			catch (Exception localException1)
			{
			}
		}
		return xmlString.toString();
	}
	//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet request,Pallet request with stock details.Request id:[W16ASUN022][End]


	private String checkNullAndTrim(String inputVal)
	{
		if (inputVal == null)
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
}