/*
 * Author:Wasim Ansari
 * Date:02-FEB-15
 * Request ID:D14IKAT004 (PO Wizard)
 */

package ibase.webitm.ejb.wms;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class DDPorderWizEJB extends ValidatorEJB implements DDPorderWizEJBRemote, DDPorderWizEJBLocal
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	//Changed by samadhan for round off
	DistCommon distComm = new DistCommon();
	@Override
	public String wfValData(String xmlString, String xmlString1,
			String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("xmlString:::"+xmlString);
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : Cpp : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		
		return(errString);
	}

	@Override
	public String wfValData(Document dom, Document dom1, Document dom2,	String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException
	{
		String errString = "";
		
		/*Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null;
		PreparedStatement pstmt = null ;
		
		String userId = "";
		int currentFormNo = 0;
		
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength;
		int ctr = 0;
		long cnt = 0;
		String childNodeName = null;
		
		String errCode = "";
		String errorType = "";
		
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		
		try
		{
			conn = connDriver.getConnectDB("DriverITM");	
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					
					for(ctr=0;ctr<childNodeListLength;ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						
						
						if (childNodeName.equalsIgnoreCase("ord_date")) 
						{
							int paramName = 0;
							String ord_date = genericUtility.getColumnValue("ord_date", dom);
							String countSerSql = "SELECT COUNT(1) AS COUNT FROM PORDER WHERE TRIM(ORD_DATE) = ?";
							PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
							pstmtParamName.setString(1, ord_date);
							ResultSet rsCnt = pstmtParamName.executeQuery();
							
							System.out.println("countSerSql" + countSerSql);
							if (rsCnt.next()) 
							{
								paramName = rsCnt.getInt("COUNT");
							}
							
							if (paramName != 0) 
							{
								errCode = "VTQDTNV";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						else if (childNodeName.equalsIgnoreCase("ind_no")) 
						{
							int paramName = 0;
							String ind_no = genericUtility.getColumnValue("ind_no", dom);
							String countSerSql = "SELECT COUNT(1) AS COUNT FROM PORDER WHERE TRIM(IND_NO) = ?";
							PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
							pstmtParamName.setString(1, ind_no);
							ResultSet rsCnt = pstmtParamName.executeQuery();
							
							System.out.println("countSerSql" + countSerSql);
							if (rsCnt.next()) 
							{
								paramName = rsCnt.getInt("COUNT");
							}
							
							if (paramName != 0) 
							{
								errCode = "DUPITEMCD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						else if (childNodeName.equalsIgnoreCase("item_ser")) 
						{
							int paramName = 0;
							String item_ser = genericUtility.getColumnValue("item_ser", dom);
							String countSerSql = "SELECT COUNT(1) AS COUNT FROM PORDER WHERE TRIM(ITEM_SER) = ?";
							PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
							pstmtParamName.setString(1, item_ser);
							ResultSet rsCnt = pstmtParamName.executeQuery();
							
							System.out.println("countSerSql" + countSerSql);
							if (rsCnt.next()) 
							{
								paramName = rsCnt.getInt("COUNT");
							}
							
							if (paramName != 0) 
							{
								errCode = "DUPITEMCD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						else if (childNodeName.equalsIgnoreCase("cr_term")) 
						{
							int paramName = 0;
							String cr_term = genericUtility.getColumnValue("cr_term", dom);
							String countSerSql = "SELECT COUNT(1) AS COUNT FROM PORDER WHERE TRIM(CR_TERM) = ?";
							PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
							pstmtParamName.setString(1, cr_term);
							ResultSet rsCnt = pstmtParamName.executeQuery();
							
							System.out.println("countSerSql" + countSerSql);
							if (rsCnt.next()) 
							{
								paramName = rsCnt.getInt("COUNT");
							}
							
							if (paramName != 0) 
							{
								errCode = "DUPITEMCD";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						
						
					}
					
				break;	
			
				case 2:
						parentNodeList = dom.getElementsByTagName("Detail2");
						parentNode = parentNodeList.item(0);
						childNodeList = parentNode.getChildNodes();
						childNodeListLength = childNodeList.getLength();
						
						for(ctr = 0; ctr < childNodeListLength; ctr++)
						{
							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();
						}
						
						for(ctr=0;ctr<childNodeListLength;ctr++)
						{
							childNode = childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();
							
							if (childNodeName.equalsIgnoreCase("item_code")) 
							{
								int paramName = 0;
								String item_code = genericUtility.getColumnValue("item_code", dom);
								String countSerSql = "SELECT COUNT(1) AS COUNT FROM PORDER WHERE TRIM(ITEM_CODE) = ?";
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, item_code);
								ResultSet rsCnt = pstmtParamName.executeQuery();
								
								System.out.println("countSerSql" + countSerSql);
								if (rsCnt.next()) 
								{
									paramName = rsCnt.getInt("COUNT");
								}
								
								if (paramName != 0) 
								{
									errCode = "DUPITEMCD";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
							
							else if (childNodeName.equalsIgnoreCase("rate")) 
							{
								int paramName = 0;
								String rate = genericUtility.getColumnValue("rate", dom);
								String countSerSql = "SELECT COUNT(1) AS COUNT FROM PORDER WHERE TRIM(RATE) = ?";
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, rate);
								ResultSet rsCnt = pstmtParamName.executeQuery();
								
								System.out.println("countSerSql" + countSerSql);
								if (rsCnt.next()) 
								{
									paramName = rsCnt.getInt("COUNT");
								}
								
								if (paramName != 0) 
								{
									errCode = "DUPITEMCD";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
							
							else if (childNodeName.equalsIgnoreCase("quantity")) 
							{
								int paramName = 0;
								String quantity = genericUtility.getColumnValue("quantity", dom);
								String countSerSql = "SELECT COUNT(1) AS COUNT FROM PORDER WHERE TRIM(QUANTITY) = ?";
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, quantity);
								ResultSet rsCnt = pstmtParamName.executeQuery();
								
								System.out.println("countSerSql" + countSerSql);
								if (rsCnt.next()) 
								{
									paramName = rsCnt.getInt("COUNT");
								}
								
								if (paramName != 0) 
								{
									errCode = "DUPITEMCD";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
				
				}
					
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
			
			
		}//end of try
		
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				connDriver = null;
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		
		errString = errStringXml.toString(); */
		return errString;  
	}

	@Override
	public String itemChanged(String xmlString, String xmlString1,
			String xmlString2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		String errString="";
		
		try
		{
			System.out.println("xmlString["+xmlString+"]");
			System.out.println("xmlString1["+xmlString1+"]");
			System.out.println("xmlString2["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("xmlString["+xmlString+"]");
				
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
				
				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :DDProductWizEJB:itemChanged(String,String,String,String,String,String):" + e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return valueXmlString;
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		System.out.println("<<====== Inside itemChanged ======>>");
		/*		System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");*/

		String errString="";
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		int currentFormNo = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String userId = "";
		String currDate = "";
		String siteDescr = "";
		String randomNum = "";
		
		String sql = "", sqlSel = "";
		ResultSet rs = null, rsSel = null;
		PreparedStatement pstmt = null, pstmtSel = null;
		Date  ordDate = null;
		String deptCodeDisparm = "",deptDescription = "";//Changed by wasim on 15-03-2016
		
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?>\r\n<Root>\r\n<header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</header>\r\n");
			
			String applDateFormat = genericUtility.getApplDateFormat();
			SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);
			currDate = sdf.format(new java.util.Date());
			
			System.out.println("Extra Params is="+xtraParams);
			
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			String siteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			String empCode =  genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			
			System.out.println("EMPCODE="+empCode);
			
			System.out.println("currentColumn["+currentColumn+"]");
			System.out.println("objContext["+objContext+"]");
			
			/************************************************************/
			sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				siteDescr = checkNullAndTrim(rs.getString("descr"));
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			
			/************************************************************/
			
			//Changed by wasim on 15-03-2016 to get department code [START]
			deptCodeDisparm = checkNullAndTrim(distComm.getDisparams("999999", "DEFAULT_DEPT_CODE", conn));
			System.out.println("Deprtment code from disparm["+deptCodeDisparm+"]");
			
			sql = "SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, deptCodeDisparm);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				deptDescription = checkNullAndTrim(rs.getString("DESCR"));
			}
			if(rs!=null)
			{	
				rs.close();rs = null;
			}
			if(pstmt!=null)
			{	
				pstmt.close();pstmt = null;
			}
			//Changed by wasim on 15-03-2016 to get department code [END]
			
			switch(currentFormNo)
			{
				case 1: 
				{	
					System.out.println(" -------- Inside itemchange case 1111111 ------------ ");
					valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r\n");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						// Changed by Sneha on 29-05-2016, for PO AutoSave [Start]
						// IND_NO, SITE_DESCR
						sqlSel = " SELECT  ORD_DATE, ITEM_SER,  SUPP_CODE, SUPP_NAME, CR_TERM, CRTERM_DESCR, REMARKS, DLV_TERM, TRAN_CODE, " 
								+" TRAN_NAME, PRICE_LIST, EXCH_RATE, DEPT_CODE, DEPT_DESCR, TRANS_MODE, SITE_CODE__DLV, SITE_CODE__ORD, PORD_TYPE, " 
								+" TASK_DESC, SITE_ADD1, CURR_CODE,  TERM_TABLE, UDF_STR__2, UDF_STR__1,PURC_ORDER " 
								+" FROM PORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ? ";
						pstmtSel = conn.prepareStatement(sqlSel);
						pstmtSel.setString(1, "A");
						pstmtSel.setString(2, empCode);
						pstmtSel.setString(3, siteCode);
						rsSel = pstmtSel.executeQuery();
						if( rsSel.next() )
						{
							ordDate = rsSel.getDate("ORD_DATE");
							//System.out.println(" -------- Inside if for itemchange case 1111111 ------------ ");
							valueXmlString.append("<tran_date>").append("<![CDATA["+currDate+"]]>").append("</tran_date>\r\n");	
							//valueXmlString.append("<purc_order>").append("<![CDATA[]]>").append("</purc_order>\r\n");
							valueXmlString.append("<purc_order>").append("<![CDATA["+checkNullAndTrim(rsSel.getString("PURC_ORDER"))+"]]>").append("</purc_order>\r\n");
							valueXmlString.append("<ord_date>").append("<![CDATA["+sdf.format(ordDate).toString() +"]]>").append("</ord_date>\r\n");	
							valueXmlString.append("<ind_no>").append("<![CDATA[]]>").append("</ind_no>\r\n");
							valueXmlString.append("<item_ser>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(2))+"]]>").append("</item_ser>\r\n");
							valueXmlString.append("<supp_code>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(3))+"]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(4))+"]]>").append("</supp_name>\r\n");	
							valueXmlString.append("<cr_term>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(5))+"]]>").append("</cr_term>\r\n");
							valueXmlString.append("<crterm_descr>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(6))+"]]>").append("</crterm_descr>\r\n");	
							valueXmlString.append("<remarks>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(7))+"]]>").append("</remarks>\r\n");
							valueXmlString.append("<confirmed>").append("<![CDATA[N]]>").append("</confirmed>\r\n");
							valueXmlString.append("<dlv_term>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(8))+"]]>").append("</dlv_term>\r\n");
							valueXmlString.append("<tran_code>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(9))+"]]>").append("</tran_code>\r\n");
							valueXmlString.append("<tran_name>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(10))+"]]>").append("</tran_name>\r\n");
							valueXmlString.append("<price_list>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(11))+"]]>").append("</price_list>\r\n");
							valueXmlString.append("<conf_date>").append("<![CDATA["+currDate+"]]>").append("</conf_date>\r\n");	
							valueXmlString.append("<exch_rate protect ='1'>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(12))+"]]>").append("</exch_rate>\r\n");
							valueXmlString.append("<dept_code>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(13))+"]]>").append("</dept_code>\r\n");
							valueXmlString.append("<department_descr>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(14))+"]]>").append("</department_descr>\r\n");
							valueXmlString.append("<trans_mode>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(15))+"]]>").append("</trans_mode>\r\n");	
							valueXmlString.append("<item_code>").append("<![CDATA[]]>").append("</item_code>\r\n");	
							valueXmlString.append("<site_code__dlv>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(16))+"]]>").append("</site_code__dlv>\r\n");
							valueXmlString.append("<site_code__ord>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(17))+"]]>").append("</site_code__ord>\r\n");
							valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr>\r\n");
							valueXmlString.append("<pord_type>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(18))+"]]>").append("</pord_type>\r\n");
							valueXmlString.append("<task_desc>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(19))+"]]>").append("</task_desc>\r\n");
							valueXmlString.append("<site_add1>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(20))+"]]>").append("</site_add1>\r\n");
							valueXmlString.append("<emp_code>").append("<![CDATA["+empCode+"]]>").append("</emp_code>\r\n");
							valueXmlString.append("<curr_code>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(21))+"]]>").append("</curr_code>\r\n");	
							valueXmlString.append("<chg_user>").append("<![CDATA["+userId+"]]>").append("</chg_user>\r\n");
							valueXmlString.append("<chg_term>").append("<![CDATA["+chgTerm+"]]>").append("</chg_term>\r\n");
							valueXmlString.append("<term_table>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(22))+"]]>").append("</term_table>\r\n");
							valueXmlString.append("<udf_str__2>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(23))+"]]>").append("</udf_str__2>\r\n");
							valueXmlString.append("<udf_str__1>").append("<![CDATA["+checkNullAndTrim(rsSel.getString(24))+"]]>").append("</udf_str__1>\r\n");
							valueXmlString.append("<udf_str__3>").append("<![CDATA[A]]>").append("</udf_str__3>\r\n");
							valueXmlString.append("<date_format>").append("<![CDATA["+applDateFormat+"]]>").append("</date_format>\r\n");
						}
						
						else
						{
							//System.out.println(" -------- Inside else for itemchange case 1111111 ------------ ");
							valueXmlString.append("<tran_date>").append("<![CDATA["+currDate+"]]>").append("</tran_date>\r\n");	
							valueXmlString.append("<purc_order>").append("<![CDATA[]]>").append("</purc_order>\r\n");
							valueXmlString.append("<ord_date>").append("<![CDATA["+currDate+"]]>").append("</ord_date>\r\n");	
							valueXmlString.append("<ind_no>").append("<![CDATA[]]>").append("</ind_no>\r\n");
							valueXmlString.append("<item_ser>").append("<![CDATA[]]>").append("</item_ser>\r\n");
							valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");	
							valueXmlString.append("<cr_term>").append("<![CDATA[]]>").append("</cr_term>\r\n");
							valueXmlString.append("<crterm_descr>").append("<![CDATA[]]>").append("</crterm_descr>\r\n");	
							valueXmlString.append("<remarks>").append("<![CDATA[]]>").append("</remarks>\r\n");
							valueXmlString.append("<confirmed>").append("<![CDATA[N]]>").append("</confirmed>\r\n");
							valueXmlString.append("<dlv_term>").append("<![CDATA[]]>").append("</dlv_term>\r\n");
							valueXmlString.append("<tran_code>").append("<![CDATA[]]>").append("</tran_code>\r\n");
							valueXmlString.append("<tran_name>").append("<![CDATA[]]>").append("</tran_name>\r\n");
							valueXmlString.append("<price_list>").append("<![CDATA[]]>").append("</price_list>\r\n");
							valueXmlString.append("<conf_date>").append("<![CDATA["+currDate+"]]>").append("</conf_date>\r\n");	
							valueXmlString.append("<exch_rate>").append("<![CDATA[]]>").append("</exch_rate>\r\n");
							/*valueXmlString.append("<dept_code>").append("<![CDATA[DEP03]]>").append("</dept_code>\r\n");
							valueXmlString.append("<department_descr>").append("<![CDATA[Creative Department]]>").append("</department_descr>\r\n");*/
							valueXmlString.append("<dept_code>").append("<![CDATA["+deptCodeDisparm+"]]>").append("</dept_code>\r\n");
							valueXmlString.append("<department_descr>").append("<![CDATA["+deptDescription+"]]>").append("</department_descr>\r\n");
							valueXmlString.append("<trans_mode>").append("<![CDATA[]]>").append("</trans_mode>\r\n");	
							valueXmlString.append("<item_code>").append("<![CDATA[]]>").append("</item_code>\r\n");	
							valueXmlString.append("<site_code__dlv>").append("<![CDATA["+siteCode+"]]>").append("</site_code__dlv>\r\n");
							valueXmlString.append("<site_code__ord>").append("<![CDATA["+siteCode+"]]>").append("</site_code__ord>\r\n");
							valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr>\r\n");
							valueXmlString.append("<pord_type>").append("<![CDATA[T]]>").append("</pord_type>\r\n");
							valueXmlString.append("<task_desc>").append("<![CDATA[]]>").append("</task_desc>\r\n");
							valueXmlString.append("<site_add1>").append("<![CDATA[]]>").append("</site_add1>\r\n");
							valueXmlString.append("<emp_code>").append("<![CDATA["+empCode+"]]>").append("</emp_code>\r\n");
							valueXmlString.append("<curr_code>").append("<![CDATA[]]>").append("</curr_code>\r\n");	
							valueXmlString.append("<chg_user>").append("<![CDATA["+userId+"]]>").append("</chg_user>\r\n");
							valueXmlString.append("<chg_term>").append("<![CDATA["+chgTerm+"]]>").append("</chg_term>\r\n");
							valueXmlString.append("<term_table>").append("<![CDATA[]]>").append("</term_table>\r\n");
							randomNum = String.valueOf(GetRandomNumber());
							System.out.println("Rnadom Numbner is="+randomNum);
							valueXmlString.append("<udf_str__2>").append("<![CDATA["+randomNum+"]]>").append("</udf_str__2>\r\n");
							valueXmlString.append("<udf_str__3>").append("<![CDATA[A]]>").append("</udf_str__3>\r\n");
							valueXmlString.append("<date_format>").append("<![CDATA["+applDateFormat+"]]>").append("</date_format>\r\n");
						}
						if(rsSel != null)
						{
							rsSel.close();
							rsSel = null;
						}
						if(pstmtSel != null)
						{
							pstmtSel.close();
							pstmtSel = null;
						}
						// Changed by Sneha on 29-05-2016 for PO AutoSave [End]
						
						/*
						valueXmlString.append("<tran_date>").append("<![CDATA["+currDate+"]]>").append("</tran_date>\r\n");	
						valueXmlString.append("<purc_order>").append("<![CDATA[]]>").append("</purc_order>\r\n");
						valueXmlString.append("<ord_date>").append("<![CDATA["+currDate+"]]>").append("</ord_date>\r\n");	
						valueXmlString.append("<ind_no>").append("<![CDATA[]]>").append("</ind_no>\r\n");
						valueXmlString.append("<item_ser>").append("<![CDATA[]]>").append("</item_ser>\r\n");
						valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
						valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>\r\n");	
						valueXmlString.append("<cr_term>").append("<![CDATA[]]>").append("</cr_term>\r\n");
						valueXmlString.append("<crterm_descr>").append("<![CDATA[]]>").append("</crterm_descr>\r\n");	
						valueXmlString.append("<remarks>").append("<![CDATA[]]>").append("</remarks>\r\n");
						valueXmlString.append("<confirmed>").append("<![CDATA[N]]>").append("</confirmed>\r\n");
						valueXmlString.append("<dlv_term>").append("<![CDATA[]]>").append("</dlv_term>\r\n");
						valueXmlString.append("<tran_code>").append("<![CDATA[]]>").append("</tran_code>\r\n");
						valueXmlString.append("<tran_name>").append("<![CDATA[]]>").append("</tran_name>\r\n");
						valueXmlString.append("<price_list>").append("<![CDATA[]]>").append("</price_list>\r\n");
						valueXmlString.append("<conf_date>").append("<![CDATA["+currDate+"]]>").append("</conf_date>\r\n");	
						valueXmlString.append("<exch_rate>").append("<![CDATA[]]>").append("</exch_rate>\r\n");
						//Changed by wasim on 15-03-2016 to set the department bydefault [START]
						/*valueXmlString.append("<dept_code>").append("<![CDATA[DEP03]]>").append("</dept_code>\r\n");
						valueXmlString.append("<department_descr>").append("<![CDATA[Creative Department]]>").append("</department_descr>\r\n");
						valueXmlString.append("<dept_code>").append("<![CDATA["+deptCodeDisparm+"]]>").append("</dept_code>\r\n");
						valueXmlString.append("<department_descr>").append("<![CDATA["+deptDescription+"]]>").append("</department_descr>\r\n");
						//Changed by wasim on 15-03-2016 to set the department bydefault [END]
						valueXmlString.append("<trans_mode>").append("<![CDATA[]]>").append("</trans_mode>\r\n");	
						valueXmlString.append("<item_code>").append("<![CDATA[]]>").append("</item_code>\r\n");	
						valueXmlString.append("<site_code__dlv>").append("<![CDATA["+siteCode+"]]>").append("</site_code__dlv>\r\n");
						valueXmlString.append("<site_code__ord>").append("<![CDATA["+siteCode+"]]>").append("</site_code__ord>\r\n");
						valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr>\r\n");
						valueXmlString.append("<pord_type>").append("<![CDATA[T]]>").append("</pord_type>\r\n");
						valueXmlString.append("<task_desc>").append("<![CDATA[]]>").append("</task_desc>\r\n");
						valueXmlString.append("<site_add1>").append("<![CDATA[]]>").append("</site_add1>\r\n");
						valueXmlString.append("<emp_code>").append("<![CDATA["+empCode+"]]>").append("</emp_code>\r\n");
						valueXmlString.append("<curr_code>").append("<![CDATA[]]>").append("</curr_code>\r\n");	
						valueXmlString.append("<chg_user>").append("<![CDATA["+userId+"]]>").append("</chg_user>\r\n");
						valueXmlString.append("<chg_term>").append("<![CDATA["+chgTerm+"]]>").append("</chg_term>\r\n");
						valueXmlString.append("<term_table>").append("<![CDATA[]]>").append("</term_table>\r\n");
						randomNum = String.valueOf(GetRandomNumber());
						System.out.println("Rnadom Numbner is="+randomNum);
						valueXmlString.append("<udf_str__2>").append("<![CDATA["+randomNum+"]]>").append("</udf_str__2>\r\n"); */
					}
					
					valueXmlString.append("</Detail1>\r\n");
					break;
				}
				case 2:
				{
					System.out.println(" -------- Inside itemchange case 2222222 ------------ ");
					String purc_order 		= genericUtility.getColumnValue("purc_order", dom1,"1");
					String ord_date 	    = genericUtility.getColumnValue("ord_date",dom1,"1");
					String ind_no 		    = genericUtility.getColumnValue("ind_no",dom1,"1");
					String item_ser 		= genericUtility.getColumnValue("item_ser", dom1,"1");
					String supp_code 	    = genericUtility.getColumnValue("supp_code",dom1,"1");
					String suppName 	    = genericUtility.getColumnValue("supp_name",dom1,"1");
					String cr_term 		    = genericUtility.getColumnValue("cr_term",dom1,"1");
					String crDescr		    = genericUtility.getColumnValue("crterm_descr",dom1,"1");
					String remarks 	        = genericUtility.getColumnValue("remarks", dom1,"1");
					String confirmed 	    = genericUtility.getColumnValue("confirmed", dom1,"1");
					String dlv_term 	    = genericUtility.getColumnValue("dlv_term", dom1,"1");
					String tran_code 	    = genericUtility.getColumnValue("tran_code", dom1,"1");
					String tranName	    	= genericUtility.getColumnValue("tran_name", dom1,"1");
					String price_list 	    = genericUtility.getColumnValue("price_list", dom1,"1");
					String conf_date 		= genericUtility.getColumnValue("conf_date", dom1,"1");
					String exch_rate 	    = genericUtility.getColumnValue("exch_rate", dom1,"1");
					String dept_code 		= genericUtility.getColumnValue("dept_code", dom1,"1");
					String deptDescr 		= genericUtility.getColumnValue("department_descr", dom1,"1");
					String trans_mode 	    = genericUtility.getColumnValue("trans_mode", dom1,"1");
					String item_code 	    = genericUtility.getColumnValue("item_code", dom1,"1");
					String tran_date	    = genericUtility.getColumnValue("tran_date", dom1,"1");
					String pordType	        = genericUtility.getColumnValue("pord_type", dom1,"1");
					String taskDescr	    = genericUtility.getColumnValue("task_desc", dom1,"1");
					//String sitecode	    = genericUtility.getColumnValue("site_code__dlv", dom1,"1");
					String dlvSite	        = genericUtility.getColumnValue("site_code__dlv", dom1,"1");
					String dlvsiteDescr	    = genericUtility.getColumnValue("site_descr", dom1,"1");
					String ordSite	        = genericUtility.getColumnValue("site_code__ord", dom1,"1");
					String siteAdd			= genericUtility.getColumnValue("site_add1", dom1,"1");
					String currCode			= genericUtility.getColumnValue("curr_code", dom1,"1");
					String termTable		= genericUtility.getColumnValue("term_table", dom1,"1");
					String chgUser  		= genericUtility.getColumnValue("chg_user", dom1,"1");
					String Termchg 		    = genericUtility.getColumnValue("chg_term", dom1,"1");
					String empcode 		    = genericUtility.getColumnValue("emp_code", dom1,"1");
					String random			= genericUtility.getColumnValue("udf_str__2", dom1,"1");
					String udfStr1			= genericUtility.getColumnValue("udf_str__1", dom1,"1");
					String udfStr3			= genericUtility.getColumnValue("udf_str__3", dom1,"1");
					String dlvTermDescr		= genericUtility.getColumnValue("delivery_term_descr", dom1,"1");
					
					String itemParent = "",itemDescr = "";
					
					valueXmlString.append("<Detail2 domID='"+1+"' selected = 'N'>\r\n");
					
					if("itm_default".equalsIgnoreCase(currentColumn))
					{ 
						valueXmlString.append("<purc_order>").append("<![CDATA["+ checkNullAndTrim(purc_order) +"]]>").append("</purc_order>\r\n");
						valueXmlString.append("<tran_date>").append("<![CDATA["+ checkNullAndTrim(tran_date) +"]]>").append("</tran_date>\r\n");
						valueXmlString.append("<ord_date>").append("<![CDATA["+ord_date+"]]>").append("</ord_date>\r\n");
						valueXmlString.append("<ind_no>").append("<![CDATA["+ checkNullAndTrim(ind_no) +"]]>").append("</ind_no>\r\n");
						valueXmlString.append("<item_ser>").append("<![CDATA["+ checkNullAndTrim(item_ser) +"]]>").append("</item_ser>\r\n");
						valueXmlString.append("<supp_code>").append("<![CDATA["+supp_code+"]]>").append("</supp_code>\r\n");
						valueXmlString.append("<supp_name>").append("<![CDATA["+suppName+"]]>").append("</supp_name>\r\n");
						valueXmlString.append("<cr_term>").append("<![CDATA["+ checkNullAndTrim(cr_term) +"]]>").append("</cr_term>\r\n");
						valueXmlString.append("<crterm_descr>").append("<![CDATA["+ checkNullAndTrim(crDescr) +"]]>").append("</crterm_descr>\r\n");
						valueXmlString.append("<remarks>").append("<![CDATA["+ checkNullAndTrim(remarks) +"]]>").append("</remarks>\r\n");
						valueXmlString.append("<confirmed>").append("<![CDATA["+ checkNullAndTrim(confirmed) +"]]>").append("</confirmed>\r\n");
						valueXmlString.append("<dlv_term>").append("<![CDATA["+ checkNullAndTrim(dlv_term) +"]]>").append("</dlv_term>\r\n");
						valueXmlString.append("<tran_code>").append("<![CDATA["+ checkNullAndTrim(tran_code) +"]]>").append("</tran_code>\r\n");
						valueXmlString.append("<tran_name>").append("<![CDATA["+ checkNullAndTrim(tranName) +"]]>").append("</tran_name>\r\n");
						valueXmlString.append("<price_list>").append("<![CDATA["+ checkNullAndTrim(price_list) +"]]>").append("</price_list>\r\n");
						valueXmlString.append("<conf_date>").append("<![CDATA["+ checkNullAndTrim(conf_date) +"]]>").append("</conf_date>\r\n");
						valueXmlString.append("<exch_rate>").append("<![CDATA["+ checkNullAndTrim(exch_rate) +"]]>").append("</exch_rate>\r\n");
						valueXmlString.append("<dept_code>").append("<![CDATA["+ checkNullAndTrim(dept_code) +"]]>").append("</dept_code>\r\n");
						valueXmlString.append("<department_descr>").append("<![CDATA["+ checkNullAndTrim(deptDescr) +"]]>").append("</department_descr>\r\n");
						valueXmlString.append("<trans_mode>").append("<![CDATA["+ checkNullAndTrim(trans_mode) +"]]>").append("</trans_mode>\r\n");
						valueXmlString.append("<dlv_date>").append("<![CDATA["+ checkNullAndTrim(currDate) +"]]>").append("</dlv_date>\r\n");
						valueXmlString.append("<pord_type>").append("<![CDATA["+ checkNullAndTrim(pordType) +"]]>").append("</pord_type>\r\n");
						valueXmlString.append("<task_desc>").append("<![CDATA["+ checkNullAndTrim(taskDescr) +"]]>").append("</task_desc>\r\n");
						valueXmlString.append("<site_code__dlv>").append("<![CDATA["+ checkNullAndTrim(dlvSite) +"]]>").append("</site_code__dlv>\r\n");
						valueXmlString.append("<site_code__ord>").append("<![CDATA["+ checkNullAndTrim(ordSite) +"]]>").append("</site_code__ord>\r\n");
						valueXmlString.append("<site_descr>").append("<![CDATA["+ checkNullAndTrim(dlvsiteDescr) +"]]>").append("</site_descr>\r\n");
						valueXmlString.append("<site_add1>").append("<![CDATA["+ checkNullAndTrim(siteAdd) +"]]>").append("</site_add1>\r\n");
						valueXmlString.append("<emp_code>").append("<![CDATA["+ checkNullAndTrim(empcode) +"]]>").append("</emp_code>\r\n");
						valueXmlString.append("<curr_code>").append("<![CDATA["+ checkNullAndTrim(currCode) +"]]>").append("</curr_code>\r\n");
						valueXmlString.append("<term_table>").append("<![CDATA["+ checkNullAndTrim(termTable) +"]]>").append("</term_table>\r\n");
						valueXmlString.append("<chg_user>").append("<![CDATA["+chgUser+"]]>").append("</chg_user>\r\n");
						valueXmlString.append("<chg_term>").append("<![CDATA["+Termchg+"]]>").append("</chg_term>\r\n");
						valueXmlString.append("<udf_str__2>").append("<![CDATA["+random+"]]>").append("</udf_str__2>\r\n");
						valueXmlString.append("<udf_str__1>").append("<![CDATA["+checkNullAndTrim(udfStr1)+"]]>").append("</udf_str__1>\r\n");
						valueXmlString.append("<udf_str__3>").append("<![CDATA["+udfStr3+"]]>").append("</udf_str__3>\r\n");
						valueXmlString.append("<delivery_term_descr>").append("<![CDATA["+dlvTermDescr+"]]>").append("</delivery_term_descr>\r\n");
						valueXmlString.append("<date_format>").append("<![CDATA["+applDateFormat+"]]>").append("</date_format>\r\n");
					}
				
					valueXmlString.append("</Detail2>\r\n");
						
					break;	
				}
				
				case 3:
				{
					System.out.println(" -------- Inside itemchange case 33333333 ------------ ");
					//System.out.println("*****Case 3*****");
					
					String itemCode = "",quantity = "",detail3Str = "", dlvDate = "",tabNo = "";
					NodeList detail2NodeList = dom2.getElementsByTagName("Detail2");
					
					
					int detail2NodeListlen = detail2NodeList.getLength();
					if("itm_default".equalsIgnoreCase(currentColumn))
					{
						//Changed by Samadhan on 14/07/2015 D15CKAT026 start
						String purc_order 		= genericUtility.getColumnValue("purc_order", dom1,"1");
						String ord_date 	    = genericUtility.getColumnValue("ord_date",dom1,"1");
						String ind_no 		    = genericUtility.getColumnValue("ind_no",dom1,"1");
						String item_ser 		= genericUtility.getColumnValue("item_ser", dom1,"1");
						String supp_code 	    = genericUtility.getColumnValue("supp_code",dom1,"1");
						String suppName 	    = genericUtility.getColumnValue("supp_name",dom1,"1");
						String cr_term 		    = genericUtility.getColumnValue("cr_term",dom1,"1");
						String crDescr		    = genericUtility.getColumnValue("crterm_descr",dom1,"1");
						String remarks 	        = genericUtility.getColumnValue("remarks", dom1,"1");
						String confirmed 	    = genericUtility.getColumnValue("confirmed", dom1,"1");
						String dlv_term 	    = genericUtility.getColumnValue("dlv_term", dom1,"1");
						String tran_code 	    = genericUtility.getColumnValue("tran_code", dom1,"1");
						String tranName	    	= genericUtility.getColumnValue("tran_name", dom1,"1");
						String price_list 	    = genericUtility.getColumnValue("price_list", dom1,"1");
						String conf_date 		= genericUtility.getColumnValue("conf_date", dom1,"1");
						String exch_rate 	    = genericUtility.getColumnValue("exch_rate", dom1,"1");
						String dept_code 		= genericUtility.getColumnValue("dept_code", dom1,"1");
						String deptDescr 		= genericUtility.getColumnValue("department_descr", dom1,"1");
						String trans_mode 	    = genericUtility.getColumnValue("trans_mode", dom1,"1");
						String item_code 	    = genericUtility.getColumnValue("item_code", dom1,"1");
						String tran_date	    = genericUtility.getColumnValue("tran_date", dom1,"1");
						String pordType	        = genericUtility.getColumnValue("pord_type", dom1,"1");
						String taskDescr	    = genericUtility.getColumnValue("task_desc", dom1,"1");
						//String sitecode	    = genericUtility.getColumnValue("site_code__dlv", dom1,"1");
						String dlvSite	        = genericUtility.getColumnValue("site_code__dlv", dom1,"1");
						String dlvsiteDescr	    = genericUtility.getColumnValue("site_descr", dom1,"1");
						String ordSite	        = genericUtility.getColumnValue("site_code__ord", dom1,"1");
						String siteAdd			= genericUtility.getColumnValue("site_add1", dom1,"1");
						String currCode			= genericUtility.getColumnValue("curr_code", dom1,"1");
						String termTable		= genericUtility.getColumnValue("term_table", dom1,"1");
						String chgUser  		= genericUtility.getColumnValue("chg_user", dom1,"1");
						String Termchg 		    = genericUtility.getColumnValue("chg_term", dom1,"1");
						String empcode 		    = genericUtility.getColumnValue("emp_code", dom1,"1");
						String random			= genericUtility.getColumnValue("udf_str__2", dom1,"1");
						String udfStr1			= genericUtility.getColumnValue("udf_str__1", dom1,"1");
						String udfStr3			= genericUtility.getColumnValue("udf_str__3", dom1,"1");
						String dlvTermDescr		= genericUtility.getColumnValue("delivery_term_descr", dom1,"1");
						
						valueXmlString.append("<Detail3 domID='"+0+"' selected = 'N'>\r\n");
							valueXmlString.append("<purc_order>").append("<![CDATA["+ checkNullAndTrim(purc_order) +"]]>").append("</purc_order>\r\n");
							valueXmlString.append("<tran_date>").append("<![CDATA["+ checkNullAndTrim(tran_date) +"]]>").append("</tran_date>\r\n");
							valueXmlString.append("<ord_date>").append("<![CDATA["+ord_date+"]]>").append("</ord_date>\r\n");
							valueXmlString.append("<ind_no>").append("<![CDATA["+ checkNullAndTrim(ind_no) +"]]>").append("</ind_no>\r\n");
							valueXmlString.append("<item_ser>").append("<![CDATA["+ checkNullAndTrim(item_ser) +"]]>").append("</item_ser>\r\n");
							valueXmlString.append("<supp_code>").append("<![CDATA["+supp_code+"]]>").append("</supp_code>\r\n");
							valueXmlString.append("<supp_name>").append("<![CDATA["+suppName+"]]>").append("</supp_name>\r\n");
							valueXmlString.append("<cr_term>").append("<![CDATA["+ checkNullAndTrim(cr_term) +"]]>").append("</cr_term>\r\n");
							valueXmlString.append("<crterm_descr>").append("<![CDATA["+ checkNullAndTrim(crDescr) +"]]>").append("</crterm_descr>\r\n");
							valueXmlString.append("<remarks>").append("<![CDATA["+ checkNullAndTrim(remarks) +"]]>").append("</remarks>\r\n");
							valueXmlString.append("<confirmed>").append("<![CDATA["+ checkNullAndTrim(confirmed) +"]]>").append("</confirmed>\r\n");
							valueXmlString.append("<dlv_term>").append("<![CDATA["+ checkNullAndTrim(dlv_term) +"]]>").append("</dlv_term>\r\n");
							valueXmlString.append("<tran_code>").append("<![CDATA["+ checkNullAndTrim(tran_code) +"]]>").append("</tran_code>\r\n");
							valueXmlString.append("<tran_name>").append("<![CDATA["+ checkNullAndTrim(tranName) +"]]>").append("</tran_name>\r\n");
							valueXmlString.append("<price_list>").append("<![CDATA["+ checkNullAndTrim(price_list) +"]]>").append("</price_list>\r\n");
							valueXmlString.append("<conf_date>").append("<![CDATA["+ checkNullAndTrim(conf_date) +"]]>").append("</conf_date>\r\n");
							valueXmlString.append("<exch_rate>").append("<![CDATA["+ checkNullAndTrim(exch_rate) +"]]>").append("</exch_rate>\r\n");
							valueXmlString.append("<dept_code>").append("<![CDATA["+ checkNullAndTrim(dept_code) +"]]>").append("</dept_code>\r\n");
							valueXmlString.append("<department_descr>").append("<![CDATA["+ checkNullAndTrim(deptDescr) +"]]>").append("</department_descr>\r\n");
							valueXmlString.append("<trans_mode>").append("<![CDATA["+ checkNullAndTrim(trans_mode) +"]]>").append("</trans_mode>\r\n");
							valueXmlString.append("<dlv_date>").append("<![CDATA["+ checkNullAndTrim(currDate) +"]]>").append("</dlv_date>\r\n");
							valueXmlString.append("<pord_type>").append("<![CDATA["+ checkNullAndTrim(pordType) +"]]>").append("</pord_type>\r\n");
							valueXmlString.append("<task_desc>").append("<![CDATA["+ checkNullAndTrim(taskDescr) +"]]>").append("</task_desc>\r\n");
							valueXmlString.append("<site_code__dlv>").append("<![CDATA["+ checkNullAndTrim(dlvSite) +"]]>").append("</site_code__dlv>\r\n");
							valueXmlString.append("<site_code__ord>").append("<![CDATA["+ checkNullAndTrim(ordSite) +"]]>").append("</site_code__ord>\r\n");
							valueXmlString.append("<site_descr>").append("<![CDATA["+ checkNullAndTrim(dlvsiteDescr) +"]]>").append("</site_descr>\r\n");
							valueXmlString.append("<site_add1>").append("<![CDATA["+ checkNullAndTrim(siteAdd) +"]]>").append("</site_add1>\r\n");
							valueXmlString.append("<emp_code>").append("<![CDATA["+ checkNullAndTrim(empcode) +"]]>").append("</emp_code>\r\n");
							valueXmlString.append("<curr_code>").append("<![CDATA["+ checkNullAndTrim(currCode) +"]]>").append("</curr_code>\r\n");
							valueXmlString.append("<term_table>").append("<![CDATA["+ checkNullAndTrim(termTable) +"]]>").append("</term_table>\r\n");
							valueXmlString.append("<chg_user>").append("<![CDATA["+chgUser+"]]>").append("</chg_user>\r\n");
							valueXmlString.append("<chg_term>").append("<![CDATA["+Termchg+"]]>").append("</chg_term>\r\n");
							valueXmlString.append("<udf_str__2>").append("<![CDATA["+random+"]]>").append("</udf_str__2>\r\n");
							valueXmlString.append("<udf_str__1>").append("<![CDATA["+checkNullAndTrim(udfStr1)+"]]>").append("</udf_str__1>\r\n");
							valueXmlString.append("<udf_str__3>").append("<![CDATA["+checkNullAndTrim(udfStr3)+"]]>").append("</udf_str__3>\r\n");
							valueXmlString.append("<delivery_term_descr>").append("<![CDATA["+dlvTermDescr+"]]>").append("</delivery_term_descr>\r\n");
							valueXmlString.append("<date_format>").append("<![CDATA["+applDateFormat+"]]>").append("</date_format>\r\n");
							valueXmlString.append("</Detail3>\r\n");

							HashMap<String, ArrayList> tempMap = new HashMap<String, ArrayList>();
							ArrayList tempList = null;
							String itemParnt  = "", itemSer = "",discount = "";
							
							//Changed by Samadhan on 14/07/2015 D15CKAT026 start
							for(int ctr = 0 ;ctr < detail2NodeListlen;ctr++)
							{
								Node childNode = detail2NodeList.item(ctr);
								
								if(childNode != null && childNode.getNodeType() != childNode.ELEMENT_NODE)
								{
									continue;
								}
								
								NodeList childList = childNode.getChildNodes();
								
								for(int ctrCh = 0; ctrCh < childList.getLength(); ctrCh++)
								{
									Node itmNode = childList.item(ctrCh);
									
									// Changed by Sneha on 25-08-2016, to sort item code according to parent code [Start]
									System.out.println("Current Node Name ["+itmNode.getNodeName()+"]");
									
									if(itmNode !=null && ("item_code").equalsIgnoreCase(itmNode.getNodeName()))
									{
										itemCode = itmNode.getFirstChild().getNodeValue();
										
										sql = " select item_parnt, item_ser from item where item_code = ? ";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1, itemCode);
										rs = pstmt.executeQuery();
										if ( rs.next() )
										{
											itemParnt = checkNullAndTrim(rs.getString("item_parnt"));
											itemSer = checkNullAndTrim(rs.getString("item_ser"));
											
										}
										rs.close();rs = null;
										pstmt.close();pstmt = null;
										
									}
									// Changed by Sneha on 25-08-2016, to sort item code according to parent code [End]
									
									else if(itmNode !=null && ("quantity").equalsIgnoreCase(itmNode.getNodeName()))
									{
										quantity = itmNode.getFirstChild().getNodeValue();
									}
									else if(itmNode !=null && ("dlv_date").equalsIgnoreCase(itmNode.getNodeName()))
									{
										dlvDate = itmNode.getFirstChild().getNodeValue();
									}
									else if(itmNode !=null && ("form_no").equalsIgnoreCase(itmNode.getNodeName()))
									{
										tabNo = itmNode.getFirstChild().getNodeValue();
									}
									else if(itmNode !=null && ("discount").equalsIgnoreCase(itmNode.getNodeName()))
									{
										discount = itmNode.getFirstChild().getNodeValue();
									}
								}
								// Changed by Sneha on 25-08-2016, to sort item code according to parent code [Start]
								System.out.println("itemParnt["+itemParnt+"]");
								if(itemCode != null && itemCode.length() > 0)
								{
									//String dataStr = itemCode + "~" + quantity + "~" + dlvDate;
									//String dataStr = itemCode + "~" + quantity + "~" + dlvDate + "~" + tabNo;
									String dataStr = itemCode + "~" + quantity + "~" + dlvDate + "~" + tabNo + "~" + discount;
									
									if(tempMap.containsKey(itemParnt))
									{
										tempList = (ArrayList)tempMap.get(itemParnt);
									}
									else
									{
										tempList =  new ArrayList();
									}
									tempList.add(dataStr); 
									tempMap.put(itemParnt, tempList);
									itemParnt = "";
								}
								System.out.println("ItemCode ["+itemCode+"]quantity["+quantity+"]dlv_date["+dlvDate+"]");
								
								/*if(itemCode != null && itemCode.length() > 0)
								{
									detail3Str = getPorderDetails(dom1, dom2, itemCode, quantity, dlvDate, ctr + 1, conn);
									System.out.println("detail3Str["+detail3Str+"]");
									valueXmlString.append(detail3Str+"\r\n");
								}*/
							}
						
							ArrayList itemList = null;
							Set keySet =  tempMap.keySet();
							Iterator it = keySet.iterator();
							int count = 1;
							String itemParent = "";
							
							while(it.hasNext())
							{
								itemParent = (String) it.next();
								itemList = tempMap.get(itemParent);
								System.out.println(tempMap.get(itemParent));
								
								System.out.println("Group Item Parant["+itemParnt+"]");
								
								for(int i = 0; i< itemList.size(); i++)
								{
									String itemStr = (String) itemList.get(i);
									
									//Changed by wasim
									/*String[] arr = itemStr.split("~");
									itemCode = arr[0];
									quantity = arr[1];
									dlvDate = arr[2];
									tabNo = arr[3];*/
									
									//System.out.println("itemCode------"+arr[0]);
									//.out.println("quantity------"+arr[1]);
									//System.out.println("dlvDate------"+arr[2]);
									
									//detail3Str = getPorderDetails(dom1, dom2, itemCode, quantity, dlvDate, count++, itemParnt, itemSer, conn);
									//detail3Str = getPorderDetails(dom1, dom2, itemCode, quantity, dlvDate, count++, conn);
									
									//Changed by wasim
									//detail3Str = getPorderDetails(dom1, dom2, itemCode, quantity, dlvDate, tabNo, count++, conn);
									  detail3Str = getPorderDetails(dom1, dom2, itemCode, itemStr,  count++, conn);
									System.out.println("detail3Str["+detail3Str+"]");
									valueXmlString.append(detail3Str+"\r\n");
									
								}
							}
							// Changed by Sneha on 25-08-2016, to sort item code according to parent code [End]
						}
						break;
					}
				}
		}
		catch(Exception e)
		{
			System.out.println("Inside Catch Item change PorderWizardEJB"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				//Commented by Santosh on 14-06-2016
				//connDriver = null;
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}			
		}
		
		valueXmlString.append( "</Root>\r\n" );	
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		
		return valueXmlString.toString();
	}
	
	//public String getList(String field,String extra)	 throws RemoteException, ITMException 
	public String getList(String field,String[] values,String extra,String details)	 throws RemoteException, ITMException
	{
		String sql = "",sql2 = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection conn = null, conn2 = null;
		PreparedStatement pstmt = null, pstmt2 = null,pstmt1 = null;
		ResultSet rs = null,rs1 = null, rs2 = null;
		
		E12GenericUtility genericUtility = new E12GenericUtility();
	    
		FinCommon finCommon = new FinCommon();
		
		String trCode = "",trMode = "";
		try 
		{
			System.out.println("Inside PrderWizardEJB getList---->Field["+field+"] Values["+values+"] Extra["+extra+"] Details["+details+"]");
			
			conn = getConnection();
			
			DateFormat dateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			String [] extras = extra.split("~"); 
			
			if (field.equals("tran_code"))
			{
				sql = "SELECT TRAN_CODE, TRAN_NAME, TRANSPORTER_TYPE FROM TRANSPORTER";
			}
			else if (field.equals("trans_mode"))
			{
				System.out.println("Extra Length="+extra.length());
				String[] trData = extra.split(":");
				trCode = checkNullAndTrim(trData[0]);
				trMode = checkNullAndTrim(trData[1]);
				
				sql = "SELECT TRAN_CODE, TRANS_MODE FROM TRANSPORTER_MODE WHERE TRAN_CODE = ?";
			}
			else if (field.equals("supp_code"))
			{
				sql = "SELECT SUPP_CODE,SUPP_NAME,CR_TERM,PRICE_LIST,DLV_TERM,CURR_CODE FROM SUPPLIER WHERE SUPP_TYPE = ? ";
			}
			else if (field.equals("item_ser"))
			{
				sql = "SELECT ITEM_SER,DESCR FROM ITEMSER WHERE business_type = ? ";
			}
			else if (field.equals("cr_term"))
			{
				sql = "SELECT CR_TERM,DESCR FROM CRTERM";
			}
			else if (field.equals("dept_code"))
			{
				sql = "SELECT DEPT_CODE,DESCR FROM DEPARTMENT";
			}
			else if (field.equals("price_list"))
			{
				sql = "SELECT PRICE_LIST,RATE FROM PRICELIST";
			}
			else if (field.equals("item_code"))
			{
			    if(extras[1].equals("T"))
				{
			    	sql =" select item_code,descr from item where item_code"
						+" in (select  distinct item_parnt from item where item_code in " 
					    +" (select item_code from supplieritem where supp_code = ? )) ";
				}
				else
				{
					sql ="select i.item_code,i.descr from item i,itemser s where i.item_code in " +
							"(select item_code from supplieritem where supp_code = ? ) " +
							"and i.item_ser = s.item_ser and s.business_type  = ? ";
				}
			}
			else if (field.equals("type"))
			{
			      sql ="SELECT RTRIM(FLD_VALUE),DESCR FROM GENCODES WHERE UPPER(RTRIM(FLD_NAME)) = "
			      	+ "'PORD_TYPE' AND MOD_NAME= 'W_PORDER' AND ACTIVE= 'Y' ";
			}
			else if (field.equals("site_code__dlv"))
			{
			      sql =" SELECT SITE_CODE, DESCR FROM SITE ";
			}
			else if (field.equals("curr_code"))
			{
				  sql =" SELECT CURR_CODE,DESCR,STD_EXRT FROM CURRENCY ";
			}
			else if (field.equals("term_table"))
			{
				  sql = " SELECT FLD_VALUE, DESCR FROM GENCODES WHERE FLD_NAME = 'TERM_TABLE' AND MOD_NAME = 'W_PORDER' ";
			}
			else if (field.equals("udf_str__1"))
			{
				   sql = " select fld_value,descr from gencodes where mod_name='W_PORDERWIZ' and fld_name='UDF_STR__1' ";
			}
			else if (field.equals("purc_order"))
			{
				sql = " SELECT PURC_ORDER, '' FROM PORDER WHERE CONFIRMED = 'N' ORDER BY ORD_DATE DESC ";
			}
			
			pstmt = conn.prepareStatement(sql);
			
			if(field.equals("item_code"))
			{
				if(extras[1].equals("T"))
				{
					pstmt.setString(1,extras[0]);
				}
				else
				{
					pstmt.setString(1,extras[0]);
					pstmt.setString(2,extras[1]);
				}
			}
			if(field.equals("trans_mode"))
			{
				pstmt.setString(1,trCode);
			}
			if(field.equals("item_ser"))
			{
				pstmt.setString(1,extra);
			}
			if(field.equals("supp_code"))
			{
				pstmt.setString(1,extras[0]);
			}
			
			rs = pstmt.executeQuery();
			
			String otherField  = "";
			String otherField1 = "";
			String otherField2 = "";
			String otherField3 = "";
			String otherField4 = "";
			String exchRate = "";
			String finEntity = "";
			String finCurrCode = "";
			String exchRateBuy = "";
			
			String descr1	   = "";
			String fieldId     = "";
			String fieldValue  = "";
			
			int num = 1;
			while (rs.next())
			{
				 otherField  = "";
				 otherField1 = "";
				 otherField2 = "";
				 otherField3 = "";
				 otherField4 = "";
				 exchRate = "";
				 finEntity = "";
				 finCurrCode = "";
				 exchRateBuy = "";
				
				 descr1	   = "";
				 fieldId     = "";
				 fieldValue  = "";
				
				fieldId = checkNullAndTrim(rs.getString(1));
			    fieldValue = checkNullAndTrim(rs.getString(2));
				
				
				if (field.equals("tran_code"))
				{
					otherField = checkNullAndTrim(rs.getString(3));
				}
				/*else if (field.equals("purc_order"))
				{
					otherField = checkNullAndTrim(rs.getString("PURC_ORDER"));
				}*/
				else if(field.equals("curr_code"))
				{
					otherField = checkNullAndTrim(rs.getString("STD_EXRT"));

					sql2 = " SELECT EXCH_RATE__BUY FROM DAILY_EXCH_RATE_SELL_BUY WHERE CURR_CODE = ? ";
					pstmt2 = conn.prepareStatement(sql2);
					pstmt2.setString(1,fieldId);
					rs2 = pstmt2.executeQuery();
					
					if (rs2.next())
					{
						otherField1 = checkNullAndTrim(rs2.getString("EXCH_RATE__BUY"));
					}
					else
					{
						otherField1 = "";
					}
					if(rs2!=null)
					{
						rs2.close();rs2 = null;
					}
					if(pstmt2!=null)
					{
						pstmt2.close();pstmt2 = null;
					}
					
					otherField = otherField +":"+ otherField1;
				}
				else if(field.equals("supp_code"))
				{
					otherField1 = checkNullAndTrim(rs.getString(3));
					otherField2 = checkNullAndTrim(rs.getString(4));
					otherField3 = checkNullAndTrim(rs.getString(5));
					otherField4 = checkNullAndTrim(rs.getString(6));
					
					System.out.println("Supplier Currency Code is="+otherField4);
					
					sql2 = " SELECT DESCR FROM CRTERM WHERE CR_TERM = ? ";
					pstmt2 = conn.prepareStatement(sql2);
					pstmt2.setString(1,otherField1);
					rs2 = pstmt2.executeQuery();
					
					while (rs2.next())
					{
						descr1 = checkNullAndTrim(rs2.getString("DESCR"));
					}
					if(rs2!=null)
					{
						rs2.close();rs2 = null;
					}
					if(pstmt2!=null)
					{
						pstmt2.close();pstmt2 = null;
					}
					
					sql2 = " SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE = ? ";
					pstmt2 = conn.prepareStatement(sql2);
					pstmt2.setString(1,extras[1]);
					rs2 = pstmt2.executeQuery();
					
					while (rs2.next())
					{
						finEntity = checkNullAndTrim(rs2.getString("FIN_ENTITY"));
					}
					if(rs2!=null)
					{
						rs2.close();rs2 = null;
					}
					if(pstmt2!=null)
					{
						pstmt2.close();pstmt2 = null;
					}	
					
					sql2 = " SELECT CURR_CODE FROM FINENT WHERE FIN_ENTITY = ? ";
					pstmt2 = conn.prepareStatement(sql2);
					pstmt2.setString(1,finEntity);
					rs2 = pstmt2.executeQuery();
					
					while (rs2.next())
					{
						finCurrCode = checkNullAndTrim(rs2.getString("CURR_CODE"));
					}				
					if(rs2!=null)
					{
						rs2.close();rs2 = null;
					}
					if(pstmt2!=null)
					{
						pstmt2.close();pstmt2 = null;
					}
						
					if(otherField4.equals(finCurrCode))
					{
						exchRate = "1";
						System.out.println("Exchange Rate is="+exchRate);
					}
					else
					{
						java.util.Date currDate = new java.util.Date();
						String currDateStr = dateFormat.format(currDate);
						System.out.println("TODAY IS="+currDateStr);
						System.out.println("Order Site="+extras[1]);
						Double exchRateFinn = finCommon.getDailyExchRateSellBuy(otherField4.trim(),"",extras[1].trim(),currDateStr.trim(),"B", conn);
						
						DistCommon distcommon = new DistCommon();
						if(exchRateFinn != null)
						{
							exchRateFinn = distcommon.getRndamt(exchRateFinn, "R", 0.000001);
						}
						
						exchRate = String.valueOf(exchRateFinn);
						System.out.println("Exch Rate from FinnCommon="+exchRate);
						
						if(exchRate != null && exchRate.equals(""))
						{
							sql2 = " SELECT std_exrt FROM currency WHERE CURR_CODE = ?";
							pstmt1 = conn.prepareStatement(sql2);
							pstmt1.setString(1,otherField4);
							
							rs1 = pstmt1.executeQuery();
							
							if(rs1.next())
							{
								exchRate = checkNullAndTrim(rs1.getString("std_exrt"));
							}
							if(rs1!=null)
							{
								rs1.close();rs1 = null;
							}
							if(pstmt1!=null)
							{
								pstmt1.close();pstmt1 = null;
							}
						}
						
						System.out.println("Exchange Rate is="+exchRate);
					}
					
					otherField = otherField1 +":"+ otherField2 +":"+ otherField3 +":"+ otherField4 +":"+ exchRate +":"+ descr1;
					
				}//end supp_code
				
				if("trans_mode".equalsIgnoreCase(field))
				{
					String[] tr = trMode.split(",");
					valueXmlString.append("<supp_code domID='" + num + "' selected = '" + useLoop(tr, fieldValue) + "' >\r\n");
				}
				else
				{
					valueXmlString.append("<supp_code domID='" + num + "' selected = '" + useLoop(values, fieldId) + "' >\r\n");
				}
				
				valueXmlString.append("<fieldId><![CDATA[").append(fieldId).append("]]></fieldId>\r\n");
				valueXmlString.append("<fieldValue><![CDATA[").append(fieldValue).append("]]></fieldValue>\r\n");
				valueXmlString.append("<otherField><![CDATA[").append(otherField).append("]]></otherField>\r\n");
				
				/*valueXmlString.append("<otherField1><![CDATA[").append(otherField1).append("]]></otherField1>\r\n");
				valueXmlString.append("<otherField2><![CDATA[").append(otherField2).append("]]></otherField2>\r\n");
				valueXmlString.append("<otherField3><![CDATA[").append(otherField3).append("]]></otherField3>\r\n");
				valueXmlString.append("<otherField4><![CDATA[").append(otherField4).append("]]></otherField4>\r\n");
				valueXmlString.append("<otherField5><![CDATA[").append(exchRate).append("]]></otherField5>\r\n");
				valueXmlString.append("<descr1><![CDATA[").append(descr1).append("]]></descr1>\r\n");*/
				
				valueXmlString.append("</supp_code>\r\n");
				num++;
			}
			
			valueXmlString.append(details);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception inside getList PorderWizard="+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		//System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		
		return valueXmlString.toString();
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	/**
	 * 
	 * @param arr
	 * @param targetValue
	 * @return
	 */
	public static String useLoop(String[] arr, String targetValue)
	{
		for(String s: arr)
		{
			String str = checkNullAndTrim(s);
			if(str.equals(targetValue))
				return "Y";
		}
		
		return "N";
	}

	@Override
	//public String getPorderDetails(Document dom1,Document dom2,String itemCode,String quantity,String dlvDate, int ctr , String itemParnt, String itemSer,  Connection conn)
	//public String getPorderDetails(Document dom1,Document dom2,String itemCode,String quantity,String dlvDate,String tabNo, int ctr , Connection conn)
	public String getPorderDetails(Document dom1,Document dom2,String itemCode, String itemStr, int ctr , Connection conn)
	{
		System.out.println("********Inside Porder Details***********itemCode["+itemCode+"] itemStr["+itemStr+"] Ctr["+ctr+"]");
		/*		System.out.println(" itemCode inside getPorderDetails ==========>> " + itemCode);
		System.out.println(" quantity inside getPorderDetails ==========>> " + quantity);
		System.out.println(" dlvDate inside getPorderDetails ==========>> " + dlvDate);
		System.out.println(" ctr inside getPorderDetails ==========>> " + ctr);*/
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		Document dom=null;
		
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		NodeList childNodeList2 = null;
		Node parentNode = null;
		Node childNode = null;
		Node childNode2 = null;
		int childNodeListLength;
		String childNodeName = null;
		PreparedStatement pstmt = null, pstmt1 = null,pstmtItemLotPack = null,pstmtUpdate = null;
		ResultSet rs = null, rs1=null, rsItemLotPack = null;
		String sql="", sql1="";
		
		
	
		StringBuffer valueXmlString = new StringBuffer("");
		String suppCode = "";
		String ordDate = "";
		String deptCode = "";
		String rate1 = "";
		String empCode = "";
		String siteAdd = "";
		String itemParnt = "";
		
		String pOrder = "";
		int lineNo = 0;
		String unit = "";
		String locCode = "";
		String packCode = "";
		int purLeadTime = 0;
		Date dueDate = null;
		Date currDate = null;
		String itemAcctDetr = "";
		String itemSer = "";
		String acctCodeDr = "";
		String cctrCodeDr = "";
		String cctrCodeCr = "";
		String invAcctVal = "";
		String invAcctQcVal = "";
		String acctCodeCr = "";
		String acctCodeAp = "";
		String cctrCodeAp = "";
		String indNo = "";
		String crTerm = "";
		String remarks = "";
		String itemDescr = "";
		double rate = 0d;
		String priceList = "";
		String pricelistClg="";
		String priceListStd = "";
		DistCommon distComm = new DistCommon();
		String sysDateStr = "";
		String postType = "";
		double rateStd = 0d;
		double rateClg = 0d;
		double shipperSize = 0d, grossWeight = 0d, netWeight = 0d, tareWeight = 0d;
		String lotNo = "";
		int noArt = 0;
		String lineNoOrd = "";
		String siteCode = "";
		String currCode = ""; //Changed by wasim on 07-07-2015
		String dlvSiteCode = "";
		String ordSiteCode = "";
		
		SimpleDateFormat simpleDateFormat1 = null;
		FinCommon finCommon = null;
		
		String detailDomStr = "";
		
		String purcOrder = "";
		
		String taxClass = "", taxChap = "", taxEnv = "", taxEnvfun = "", taxEnvQry = "", stationFrom = "", stationTo = "";
		
		try
		{
			String quantity = "",dlvDate = "",tabNo = "",discount = "";
			String[] arr = itemStr.split("~");
			itemCode = arr[0];
			quantity = arr[1];
			dlvDate = arr[2];
			tabNo = arr[3];
			discount = arr[4];
			
			double amount;
			double quan=Double.parseDouble(quantity);
			String dlvleadTime = "";
			
			finCommon = new FinCommon();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar c = Calendar.getInstance();
			
			 purcOrder = genericUtility.getColumnValue("purc_order", dom1,"1");	// Changed by Sneha on 03-06-2016, for PO Edit 
			 purcOrder = (purcOrder == null) ? "" : purcOrder;
			 
			 ordDate		= genericUtility.getColumnValue("ord_date", dom1,"1");
			 indNo 		    = genericUtility.getColumnValue("ind_no", dom1,"1");
			// itemSer 		= genericUtility.getColumnValue("item_ser", dom1,"1");
			 suppCode 	    = genericUtility.getColumnValue("supp_code", dom1,"1");
			 crTerm 	    = genericUtility.getColumnValue("cr_term", dom1,"1");
			 remarks 	    = genericUtility.getColumnValue("remarks", dom1,"1");
			 deptCode 	    = genericUtility.getColumnValue("dept_code", dom1,"1");
		   //siteCode 	    = genericUtility.getColumnValue("site_code__dlv", dom1,"1");
			 dlvSiteCode 	= genericUtility.getColumnValue("site_code__dlv", dom1,"1");
			 ordSiteCode 	= genericUtility.getColumnValue("site_code__ord", dom1,"1");
			 pOrder 	    = genericUtility.getColumnValue("pord_type", dom1,"1");
			 priceList 	    = genericUtility.getColumnValue("price_list", dom1,"1");
			 empCode 	    = genericUtility.getColumnValue("emp_code", dom1,"1");
			 siteAdd 	    = genericUtility.getColumnValue("site_add1", dom1,"1");
			//Changed by wasim on 07-07-2015 to get curr_code [START]
			 currCode 	    = genericUtility.getColumnValue("curr_code", dom1,"1");
			 System.out.println("Currency Code Is="+currCode);
			//Changed by wasim on 07-07-2015 to get curr_code [END]
			 /******************************/
			// Changed by Sneha on 07-06-2016, for PO Edit [Start]
			 /*sql = " select rate from pricelist where item_code = ? "
						+"and price_list in (select price_list from supplier where supp_code = ? )";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				pstmt.setString(2, suppCode);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					rate = Double.parseDouble(checkNullAndTrim(rs.getString("rate")));
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;*/
				
			 if(purcOrder.equalsIgnoreCase(""))	// Add
			 {
				 	// Changed by Sneha on 24-08-2016, for pricelist [Start]
				 	/*sql = " select rate from pricelist where item_code = ? "
							+"and price_list in (select price_list from supplier where supp_dcode = ? ) ";*/
				 	sql = "SELECT * FROM ( " 
				 		+ "SELECT * FROM PRICELIST WHERE ITEM_CODE = ? AND (SYSDATE BETWEEN EFF_FROM AND VALID_UPTO) AND " 
				 		+ "PRICE_LIST IN (SELECT PRICE_LIST FROM SUPPLIER WHERE SUPP_CODE = ? ) ORDER BY PRICELIST.SLAB_NO DESC ) " 
				 		+ "WHERE ROWNUM = 1 ";
				 	// Changed by Sneha on 24-08-2016, for pricelist [End]
				 
				 	pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itemCode);
					pstmt.setString(2, suppCode);
					rs = pstmt.executeQuery();
					if ( rs.next() )
					{
						rate = Double.parseDouble(checkNullAndTrim(rs.getString("rate")));
					}
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
			 }
			 else
			 {
				sql = "SELECT RATE, DLV_DATE FROM PORDDET WHERE ITEM_CODE = ? AND PURC_ORDER = ? ";
				 pstmt = conn.prepareStatement(sql);
				 pstmt.setString(1, itemCode);
				 pstmt.setString(2, purcOrder);
				 rs = pstmt.executeQuery();
				 if ( rs.next() )
				 {
					rate = Double.parseDouble(checkNullAndTrim(rs.getString("rate")));
					// Changed by Sneha on 22-08-2016, for Date Format [Start]
					//dlvDate = checkNullAndTrim(rs.getString("DLV_DATE"));
					
					Date dlvDateDt = rs.getDate("DLV_DATE");
					dlvDate = sdf.format(dlvDateDt).toString();
					//System.out.println("dlvDate ========> "+dlvDate);
					// Changed by Sneha on 22-08-2016, for Date Format [End]
				 }
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			 }
			// Changed by Sneha on 07-06-2016, for PO Edit [End] 
	
				System.out.println("Rate====>>"+rate);
				System.out.println("dlvDate====>>"+dlvDate);
				
				sql = " select item_parnt,item_ser from item where item_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
			
				rs = pstmt.executeQuery();
				
				if ( rs.next() )
				{
					itemParnt = checkNullAndTrim(rs.getString("item_parnt"));
					itemSer   = checkNullAndTrim(rs.getString("item_ser"));
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;
				
			 /*****************************/
			/***********Lead Time************/
				
				sql = " select pur_lead_time from supplieritem where item_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				rs = pstmt.executeQuery();
				
				if ( rs.next() )
				{
					dlvleadTime = checkNullAndTrim(rs.getString("pur_lead_time"));
					
					System.out.println("Pure Lead Time="+dlvleadTime);
					System.out.println("Delivery Date="+dlvDate);
					
					// Changed by Sneha on 22-08-2016, for Date Format [Start]
	                c.setTime(sdf.parse(dlvDate));
	                c.add(Calendar.DATE, Integer.parseInt(dlvleadTime));
	                dlvDate = sdf.format(c.getTime());
	                System.out.println("New Delivery Date--------->>"+dlvDate);
	             // Changed by Sneha on 22-08-2016, for Date Format [End]
				}
				
				rs.close();rs = null;
				pstmt.close();pstmt = null;
				
			/***********Lead Time**********/
				
				//sql = "SELECT ACCT_CODE__AP, CCTR_CODE__AP FROM SUPPLIER WHERE SUPP_CODE = ?";
				sql = "SELECT ACCT_CODE__AP, CCTR_CODE__AP, TAX_CLASS, TAX_CHAP, TAX_ENV FROM SUPPLIER WHERE SUPP_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, suppCode);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					acctCodeAp = checkNullAndTrim(rs.getString("ACCT_CODE__AP"));
					cctrCodeAp = checkNullAndTrim(rs.getString("CCTR_CODE__AP"));
					
					/*taxClass = checkNullAndTrim(rs.getString("TAX_CLASS"));
					taxChap = checkNullAndTrim(rs.getString("TAX_CHAP"));*/
					taxEnvQry = checkNullAndTrim(rs.getString("TAX_ENV"));
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;
				
				//Changed by manish on 21/01/16 for getting tax class, tax chap and tax env [start]
				taxClass = distComm.getTaxClass("S", suppCode, itemCode, dlvSiteCode, conn);
				taxChap = distComm.getTaxChap(itemCode, itemSer, "S", suppCode, dlvSiteCode, conn);
				
				sql = "SELECT STAN_CODE FROM SITE WHERE SITE_CODE =  ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, ordSiteCode);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					stationFrom = checkNullAndTrim(rs.getString(1));
				}
				rs.close();rs = null;
				
				pstmt.clearParameters();
				pstmt.setString(1, dlvSiteCode);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					stationTo = checkNullAndTrim(rs.getString(1));
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;
				
				taxEnvfun = distComm.getTaxEnv(stationFrom, stationTo, taxChap, taxClass, dlvSiteCode, conn);
				
				if(taxEnvfun != null  &&  taxEnvfun.trim().length()> 0)
				{
					System.out.println("tax env function");
					taxEnv = taxEnvfun;
				}
				else
				{
					System.out.println("tax env query");
					taxEnv = taxEnvQry;
				}
				
				System.out.println("taxClass = ["+taxClass+"]");
				System.out.println("taxChap = ["+taxChap+"]");
				System.out.println("taxEnv = ["+taxEnv+"]");
				//Changed by manish on 21/01/16 for getting tax class, tax chap and tax env [end]
				
				// Changed by Sneha on 03-06-2016, for PO Edit [Start]
				valueXmlString.append("<Detail3 domID='"+ctr+"' selected = 'Y'>\r\n");
				
				if(!purcOrder.equalsIgnoreCase(""))	
				{
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
				}
				
				valueXmlString.append("<purc_order><![CDATA[").append(purcOrder).append("]]></purc_order>\r\n");
				// Changed by Sneha on 03-06-2016, for PO Edit [End]
							
				sql = "SELECT  I.UNIT,I.DESCR, I.LOC_CODE, I.ITEM_SER, I.PACK_CODE,I.GROSS_WEIGHT,I.NET_WEIGHT "
						+ " FROM ITEM I WHERE  I.ITEM_CODE = ? ";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itemCode);
					rs = pstmt.executeQuery();
					int domID = 0;
					
					if( rs.next())
					{
						domID++;
						lineNo = domID;
						
						unit = rs.getString("UNIT");
						//locCode = rs.getString("LOC_CODE");
						locCode = checkNullAndTrim(rs.getString("LOC_CODE"));
						locCode = (locCode!=null && locCode.length()>0) ? locCode:"FRSH";
						System.out.println("Location code="+locCode);
						//itemDescr = checkNullAndTrim("DESCR");
						itemDescr = checkNullAndTrim(rs.getString("DESCR"));
						shipperSize =  0;//Will be taken from user as it is not defined.
						grossWeight =  rs.getDouble("GROSS_WEIGHT");
						grossWeight = grossWeight * Double.parseDouble(quantity);
						netWeight =  rs.getDouble("NET_WEIGHT");
						netWeight = netWeight * Double.parseDouble(quantity);
						tareWeight = grossWeight - netWeight;
						
						packCode = checkNullAndTrim(rs.getString("PACK_CODE"));
						
						sql1 = " SELECT PUR_LEAD_TIME FROM ITEM WHERE ITEM_CODE = ?";
						
						pstmt1 = conn.prepareStatement(sql1);
						pstmt1.setString(1, itemCode);
						rs1 = pstmt1.executeQuery();
						if( rs1.next() )
						{
							purLeadTime = rs1.getInt( "PUR_LEAD_TIME" );
							System.out.println("PUR_LEAD_TIME ="+purLeadTime);
						}
						rs1.close();
						pstmt1.close();
						pstmt1 = null;
						rs1 = null;
						dueDate = addDays(currDate, purLeadTime) ;
						System.out.println("dueDate="+dueDate);
						
						
						System.out.println("Tran Type is="+pOrder);
						//itemAcctDetr  = finCommon.getFromAcctDetr(itemCode, itemSer, "IN", conn);
						//itemAcctDetr  = finCommon.getAcctDetrTtype(itemCode, itemSer, "IN", pOrder, conn);
						itemAcctDetr  = finCommon.getAcctDetrTtype(itemCode, itemSer, "IN", pOrder, conn);
						System.out.println("XYZ="+itemAcctDetr);
						String tokens [] = itemAcctDetr.split(",");
						
						System.out.println("Length="+tokens.length);
						
						if ( tokens.length >= 2)
						{
							acctCodeDr = tokens[0];
							cctrCodeDr = tokens[1];
							
							acctCodeDr = checkNullAndTrim(acctCodeDr);
							cctrCodeDr = checkNullAndTrim(cctrCodeDr);
							System.out.println("acctCodeDr="+acctCodeDr);
							System.out.println("cctrCodeDr="+cctrCodeDr);
						}
						else
						{
							//Changed by wasim on 27-OCT-2016 for removing -1 from substring
							//acctCodeDr = itemAcctDetr.substring(0,itemAcctDetr.indexOf(",") -1);
							acctCodeDr = itemAcctDetr.substring(0,itemAcctDetr.indexOf(","));
							cctrCodeDr = itemAcctDetr.substring(itemAcctDetr.indexOf(",") + 1);
						}
						
						tokens = null;

						invAcctVal = finCommon.getFinparams("999999", "INV_ACCT_PORCP", conn);
						if ( "NULLFOUND".equals(invAcctVal.trim()) || invAcctVal.trim().length() == 0 )
						{
							invAcctVal = "N";
						}

						invAcctQcVal = finCommon.getFinparams("999999", "INV_ACCT_QCORDER", conn);
						if ( "NULLFOUND".equals(invAcctQcVal.trim()) || invAcctQcVal.trim().length() == 0 )
						{
							invAcctQcVal = "N";
						}
						if ( "Y".equals(invAcctVal) && !"Y".equals(invAcctQcVal) )
						{
							itemAcctDetr  = finCommon.getFromAcctDetr(itemCode, itemSer, "PO", conn);
						}
						else
						{
							itemAcctDetr  = finCommon.getFromAcctDetr(itemCode, itemSer, "PORCP", conn);
						}
						
						tokens = itemAcctDetr.split(",");

						if ( tokens.length >= 2)
						{
							acctCodeCr = tokens[0];
							cctrCodeCr = tokens[1];
						}
						else
						{
							acctCodeCr = itemAcctDetr.substring(0,itemAcctDetr.indexOf(",") -1+ 1);
							cctrCodeCr = itemAcctDetr.substring(itemAcctDetr.indexOf(",") + 1);
						}
						
						if ( acctCodeCr == null || acctCodeCr.trim().length() == 0 )
						{
							acctCodeCr = acctCodeAp;
							cctrCodeCr = cctrCodeAp;
						}

						//rate = distComm.pickRate( priceList, sysDateStr, itemCode, " ", "L", conn );
						//System.out.println("Rate="+rate);
						
						if (cctrCodeCr == null || "null".equals(cctrCodeCr) || cctrCodeCr.trim().length() == 0)
						{
							cctrCodeCr = "    ";
						}
						if (cctrCodeDr == null || "null".equals(cctrCodeDr) || cctrCodeDr.trim().length() == 0)
						{
							cctrCodeDr = "    ";
						}
					
						priceListStd = "";
						if("S".equalsIgnoreCase(postType.trim()))
						{
							priceListStd = checkNullAndTrim(distComm.getDisparams("999999", "STD_PO_PL", conn));
							if( priceListStd.trim().length() > 0 )
							{
								rateStd = distComm.pickRate( priceListStd, sysDateStr, itemCode, " ", "L", conn );
							}
						}
						if ( rateStd == 0 )
						{
							rateStd = rate;
						}
						System.out.println("PriceListClg="+pricelistClg);
						if( pricelistClg.trim().length() > 0 )
						{
							rateClg = distComm.pickRate( pricelistClg, sysDateStr, itemCode, " ", "L", conn );
						}
						if ( rateClg == 0 )
						{
							rateClg = rate;
						}
						System.out.println("Final Rate CLG="+rateClg);
						amount= quan * rate;
						System.out.println("Actual Amount:"+amount);
						//Changed by samadhan for rounding amount
						amount = distComm.getRndamt(amount, "R", 0.01);
						amount = Double.parseDouble(new DecimalFormat("##.####").format(amount));	// Changed by Sneha on 03-08-2016 for decimal 2digit
						
						lineNoOrd = "   " + ctr;
						lineNoOrd = lineNoOrd.substring( lineNoOrd.length()-3 );
						valueXmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
						valueXmlString.append("<item_parnt><![CDATA[").append(itemParnt).append("]]></item_parnt>\r\n");
						valueXmlString.append("<descr><![CDATA[").append(itemDescr).append("]]></descr>\r\n");
						valueXmlString.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>\r\n");
						valueXmlString.append("<dlv_date><![CDATA[").append(dlvDate).append("]]></dlv_date>\r\n");
						valueXmlString.append("<supp_code><![CDATA[").append(suppCode).append("]]></supp_code>\r\n");
						valueXmlString.append("<ord_date><![CDATA[").append(ordDate).append("]]></ord_date>\r\n");
						valueXmlString.append("<dept_code><![CDATA[").append( checkNullAndTrim(deptCode) ).append("]]></dept_code>\r\n");
						valueXmlString.append("<item_ser><![CDATA[").append( checkNullAndTrim(itemSer) ).append("]]></item_ser>\r\n");
						valueXmlString.append("<line_no><![CDATA[").append(lineNoOrd).append("]]></line_no>");
						valueXmlString.append("<status><![CDATA[").append("O").append("]]></status>");
						valueXmlString.append("<status_date><![CDATA[").append(sysDateStr).append("]]></status_date>");
						valueXmlString.append("<quantity__stduom><![CDATA[").append(quantity).append("]]></quantity__stduom>");
						valueXmlString.append("<unit><![CDATA[").append(unit).append("]]></unit>");
						valueXmlString.append("<unit__std><![CDATA[").append(unit).append("]]></unit__std>");
						valueXmlString.append("<unit__rate><![CDATA[").append(unit).append("]]></unit__rate>");
						valueXmlString.append("<rate><![CDATA[").append( rate ).append("]]></rate>");
						//valueXmlString.append("<discount><![CDATA[0]]></discount>");
						valueXmlString.append("<tax_amt><![CDATA[0]]></tax_amt>");
						valueXmlString.append("<dlv_qty><![CDATA[0]]></dlv_qty>");
	                    if(dueDate != null)
	                    {
	                    	valueXmlString.append("<dlv_date><![CDATA["+simpleDateFormat1.format(dueDate)+"]]></dlv_date>");
	                    }
	                    valueXmlString.append("<rate__stduom><![CDATA[").append(rate).append("]]></rate__stduom>");
	                    valueXmlString.append("<pack_code><![CDATA[").append(packCode).append("]]></pack_code>");
	                    valueXmlString.append("<rate__clg><![CDATA[").append(rateClg).append("]]></rate__clg>"); 
	                    valueXmlString.append("<std_rate><![CDATA[").append( rateStd ).append("]]></std_rate>");
	                    valueXmlString.append("<conv__qty_stduom><![CDATA[").append("1").append("]]></conv__qty_stduom>");
	                    valueXmlString.append("<conv__rtuom_stduom><![CDATA[").append("1").append("]]></conv__rtuom_stduom>");
	                    valueXmlString.append("<req_date><![CDATA[").append(sysDateStr).append("]]></req_date>");
	                    valueXmlString.append("<loc_code><![CDATA[").append(locCode).append("]]></loc_code>");
	                    valueXmlString.append("<acct_code__dr><![CDATA[").append(acctCodeDr).append("]]></acct_code__dr>");
	                    valueXmlString.append("<cctr_code__dr><![CDATA[").append(cctrCodeDr).append("]]></cctr_code__dr>");
	                    valueXmlString.append("<acct_code__cr><![CDATA[").append(acctCodeCr).append("]]></acct_code__cr>");
	                    valueXmlString.append("<cctr_code__cr><![CDATA[").append(cctrCodeCr).append("]]></cctr_code__cr>");
	                    valueXmlString.append("<operation><![CDATA[").append("0").append("]]></operation>");
	                    valueXmlString.append("<git_qty><![CDATA[").append("0").append("]]></git_qty>");
	                    valueXmlString.append("<adj_qty><![CDATA[").append("0").append("]]></adj_qty>");
						valueXmlString.append("<quantity__fc><![CDATA[").append("0").append("]]></quantity__fc>");
						valueXmlString.append("<tot_amt><![CDATA[").append(amount).append("]]></tot_amt>");
					  //valueXmlString.append("<site_code__dlv><![CDATA[").append(siteCode).append("]]></site_code__dlv>");
						valueXmlString.append("<site_code__dlv><![CDATA[").append(dlvSiteCode).append("]]></site_code__dlv>");
						valueXmlString.append("<site_code__ord><![CDATA[").append(ordSiteCode).append("]]></site_code__ord>");
						valueXmlString.append("<pord_type><![CDATA[").append(pOrder).append("]]></pord_type>");
						valueXmlString.append("<emp_code><![CDATA[").append(empCode).append("]]></emp_code>");
						valueXmlString.append("<remarks><![CDATA[").append(remarks).append("]]></remarks>");
						valueXmlString.append("<siteAdd1><![CDATA[").append(siteAdd).append("]]></siteAdd1>");
						valueXmlString.append("<spec_metadata><![CDATA[").append("abc").append("]]></spec_metadata>");
						
						valueXmlString.append("<tax_class><![CDATA[").append(taxClass).append("]]></tax_class>");
						valueXmlString.append("<tax_chap><![CDATA[").append(taxChap).append("]]></tax_chap>");
						valueXmlString.append("<tax_env><![CDATA[").append(taxEnv).append("]]></tax_env>");
						valueXmlString.append("<curr_code><![CDATA[").append(checkNullAndTrim(currCode)).append("]]></curr_code>");//Changed by wasim on 07-07-2015 for currCode

					}	
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					
					valueXmlString.append("<form_no><![CDATA[").append(tabNo).append("]]></form_no>\r\n");
					valueXmlString.append("<discount><![CDATA[").append(discount).append("]]></discount>\r\n");
					valueXmlString.append("</Detail3>\r\n");
		}
		catch(Exception e)
		{
			System.out.println("Exception inside getPorderDetails PorderWiz"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
					
		return valueXmlString.toString();
	}
	
	public static java.util.Date addDays(java.util.Date date, int days)
	{
		java.sql.Date calculatedDate = null;
		if (date != null) 
		{
			final GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			calendar.add(Calendar.DATE,days);
			calculatedDate = new java.sql.Date(calendar.getTime().getTime());
		}

		return calculatedDate;
	}
	
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	
		public int GetRandomNumber()
	    {
	        long timeSeed = System.nanoTime(); // to get the current date time value
	        double randSeed = Math.random() * 1000; // random number generation
	        long midSeed = (long) (timeSeed * randSeed); 
	        String s = midSeed + "";
	        String subStr = s.substring(0, 9);
	        int finalSeed = Integer.parseInt(subStr);    // integer value
	        return finalSeed;
	    }
		
		public String getPoDetails(String obj,String random)
		{
			System.out.println("Inside EJB getPoDetails");
			Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			String sql = "";
			
			String purcOrder = "";
			String remarks = "";
			String suppCode = "";
			String suppName = "";
			String taxAmtHeader = "";
			String taxAmtDetail = "";
			String itemCode = "";
			String totAmt = "";
			String quantity = "";
			
			String taxClass = "", taxChap = "", taxEnv = "",itemRef = "";
			
			StringBuffer details = new StringBuffer("<root>"); 
			details.append("<finish>");
			try
			{
				//Changed and Commented By Santosh on 14-06-2016 :[START]
				//ConnDriver connDriver = new ConnDriver();
				//conn = connDriver.getConnectDB("DriverITM");
				conn = getConnection();
				//Changed and Commented By Santosh on 14-06-2016 :[END]
				
				sql = "SELECT PURC_ORDER,REMARKS,SUPP_CODE,TAX_AMT FROM PORDER WHERE UDF_STR__2 = ?";
				pstmt = conn.prepareStatement(sql);			
				pstmt.setString(1,random);			
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					purcOrder = checkNullAndTrim(rs.getString("PURC_ORDER"));
					remarks   = checkNullAndTrim(rs.getString("REMARKS"));
					suppCode  = checkNullAndTrim(rs.getString("SUPP_CODE"));
					taxAmtHeader    = checkNullAndTrim(rs.getString("TAX_AMT"));
				}		
				
				rs.close();rs = null;
				pstmt.close();pstmt = null;
				
				sql = "SELECT SUPP_NAME FROM SUPPLIER WHERE SUPP_CODE = ?";
				pstmt = conn.prepareStatement(sql);			
				pstmt.setString(1,suppCode);			
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					suppName = checkNullAndTrim(rs.getString("SUPP_NAME"));
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;
				
					details.append("<fieldId><![CDATA[").append(purcOrder).append("]]></fieldId>\r\n");
					details.append("<fieldValue><![CDATA[").append(remarks).append("]]></fieldValue>\r\n");
					details.append("<supp_code><![CDATA[").append(suppCode).append("]]></supp_code>\r\n");
					details.append("<supp_name><![CDATA[").append(suppName).append("]]></supp_name>\r\n");
					details.append("<tax_amt><![CDATA[").append(taxAmtHeader).append("]]></tax_amt>\r\n");
					
				details.append("</finish>");
				
				//sql = "SELECT ITEM_CODE,TOT_AMT,QUANTITY,TAX_AMT FROM PORDDET WHERE PURC_ORDER = ? ";
				//sql = "SELECT ITEM_CODE,TOT_AMT,QUANTITY,TAX_AMT,TAX_CLASS,TAX_CHAP,TAX_ENV FROM PORDDET WHERE PURC_ORDER = ? ";
				sql = " SELECT P.ITEM_CODE,P.TOT_AMT,P.QUANTITY,P.TAX_AMT,P.TAX_CLASS,P.TAX_CHAP,P.TAX_ENV,I.PHY_ATTRIB_4 FROM PORDDET P,ITEM I WHERE P.PURC_ORDER = ? "
					+ " AND P.ITEM_CODE = I.ITEM_CODE ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, purcOrder);
				rs = pstmt.executeQuery();
				int domID = 0;
				
				while(rs.next())
				{
					itemCode  = checkNullAndTrim(rs.getString("ITEM_CODE"));
					totAmt 	  = checkNullAndTrim(rs.getString("TOT_AMT"));
					quantity  = checkNullAndTrim(rs.getString("QUANTITY"));
					taxAmtDetail  = checkNullAndTrim(rs.getString("TAX_AMT"));

					taxClass  = checkNullAndTrim(rs.getString("TAX_CLASS"));
					taxChap   = checkNullAndTrim(rs.getString("TAX_CHAP"));
					taxEnv    = checkNullAndTrim(rs.getString("TAX_ENV"));
					
					itemRef    = checkNullAndTrim(rs.getString("PHY_ATTRIB_4"));
					
					domID++;
					
					details.append("<extra>");
						details.append("<supp_name><![CDATA[").append(suppName).append("]]></supp_name>\r\n");
						details.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>\r\n");
						details.append("<tot_amt><![CDATA[").append(totAmt).append("]]></tot_amt>\r\n");
						details.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>\r\n");
						details.append("<tax_amt><![CDATA[").append(taxAmtDetail).append("]]></tax_amt>\r\n");

						details.append("<tax_class><![CDATA[").append(taxClass).append("]]></tax_class>\r\n");
						details.append("<tax_chap><![CDATA[").append(taxChap).append("]]></tax_chap>\r\n");
						details.append("<tax_env><![CDATA[").append(taxEnv).append("]]></tax_env>\r\n");
						
						details.append("<item_ref><![CDATA[").append(itemRef).append("]]></item_ref>\r\n");
					details.append("</extra>");	
					
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;
				//details.append("</finish>");
				details.append("</root>");
			}
			catch(Exception e)
			{
				System.out.println("Exception inside getPoDetails PorderWiz"+e.getMessage());
				e.printStackTrace();
			}
			finally
			{
				try
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}	
			return details.toString();
		}
		
		
		
		//Changed by wasim to add code from servlet to EJB [START]
		public String getSKUDetail(String itemParentData,String itemDLVDate,String paraData,String otherDetails) throws ITMException 
		{
			System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ inside Purchase getSKUDetail ]XXXXXXXXXXXXXXXXXXXX");
			String sql = "";
			
			Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			String color,size,dimension,itemCode = "";
			
			String dColor,dSize,dDim = "",dColorDescr = "",dDimDescr = "";
			
			HashMap dataMap = new HashMap();
			ArrayList sizeList = new ArrayList();
			ArrayList colorList = new ArrayList();
			ArrayList dimensionList = new ArrayList();
			
			ArrayList tooltip = new ArrayList();
			
			HashMap colorData = new HashMap();
			HashMap dimensionData = new HashMap();
			
			int cntColors = 0, cntDimension = 0, cntSizes = 0;
			StringBuffer valueXmlString = null;
			
			try 
			{
				System.out.println("ItemParent["+itemParentData+"]  Date["+itemDLVDate+"]  Para Details["+paraData+"] otherDetails ["+otherDetails+"]");
				
				conn = getConnection();

				valueXmlString = new StringBuffer("<Root>\r\n");
				valueXmlString.append("<PRODUCT_SET selected = 'N'>\r\n");
				
				
				String itmDLVDate [] = itemDLVDate.split("~");
				String paraDatas [] = paraData.split("~");
				String tranType = paraDatas[0];
				
				//String itmcode = itemParentData;
				String itemData[] = itemParentData.split(":");
				String itmcode = itemData[0];
				String tabNum = itemData[1];
				
				String  DLVDate="";
				String dSizeDescr="";

				System.out.println("TRANTYPE = ["+tranType+"]");
				
				if("T".equalsIgnoreCase(tranType))
				{
					valueXmlString.append("<TH_SET selected = 'N'>\r\n");
					sql = " SELECT DISTINCT TRIM(V.ATTRIB_ID),SORT_ORDER AS PSIZE,V.DESCR FROM ITEM I, ITM_ATTRIB_VAL V WHERE V.ATTRIB_ID = I.PHY_ATTRIB_1 AND "
						+" I.ITEM_PARNT = ? AND I.ITEM_CODE != ? AND V.ATTRIB_CODE = I.PHY_ATTRIB_22 "
						+ " AND I.ACTIVE = 'Y' "
						+" order by SORT_ORDER ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itmcode);
					pstmt.setString(2, itmcode);
					rs = pstmt.executeQuery();
					valueXmlString.append("<SET><![CDATA[").append("Color").append("]]></SET>\r\n");
					valueXmlString.append("<SET><![CDATA[").append("Dimension").append("]]></SET>\r\n");
					valueXmlString.append("<SET><![CDATA[").append("Quantity").append("]]></SET>\r\n");
					while (rs.next())
					{
						dSize = checkNullAndTrim(rs.getString(1));
						dSizeDescr = checkNullAndTrim(rs.getString(3));
						sizeList.add(dSize);
						valueXmlString.append("<SET><![CDATA[").append(dSizeDescr).append("]]></SET>\r\n");
						
						cntSizes++;
					}

					if (rs != null) 
					{					
						rs.close();
						rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();
						pstmt = null;
					}


					valueXmlString.append("</TH_SET>\r\n");

					sql = "SELECT DISTINCT I.PHY_ATTRIB_2,V.DESCR FROM ITEM I,ITM_ATTRIB_VAL V WHERE I.ITEM_PARNT = ? AND I.ITEM_CODE != ?"
						+" AND I.PHY_ATTRIB_2 = V.ATTRIB_ID "
						+" AND V.ATTRIB_CODE='COLOR' " 
						+ " AND I.ACTIVE = 'Y' "
						+" ORDER BY I.PHY_ATTRIB_2";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itmcode);
					pstmt.setString(2, itmcode);
					rs = pstmt.executeQuery();
					while (rs.next())
					{
						dColor = checkNullAndTrim(rs.getString(1));
						dColorDescr = checkNullAndTrim(rs.getString(2));
						colorList.add(dColor);
						colorData.put(dColor, dColorDescr);
						
						cntColors++;
					}
					if (rs != null) 
					{					
						rs.close();
						rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();
						pstmt = null;
					}
					sql = "SELECT DISTINCT I.PHY_ATTRIB_3,V.DESCR FROM ITEM I,ITM_ATTRIB_VAL V "
							+" WHERE I.ITEM_PARNT = ? AND I.ITEM_CODE != ? AND I.PHY_ATTRIB_3 = V.ATTRIB_ID"
							+" AND V.ATTRIB_CODE='DIMENSION' " 
							+ " AND I.ACTIVE = 'Y' "
							+"ORDER BY I.PHY_ATTRIB_3";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itmcode);
					pstmt.setString(2, itmcode);
					rs = pstmt.executeQuery();
					while (rs.next())
					{
						dDim = checkNullAndTrim(rs.getString(1));
						dDimDescr = checkNullAndTrim(rs.getString(2));
						dimensionList.add(dDim);
						dimensionData.put(dDim,dDimDescr);
						
						cntDimension++;
					}
					if (rs != null) 
					{					
						rs.close();
						rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();
						pstmt = null;
					}

					sql = " SELECT PHY_ATTRIB_2 COLOR, PHY_ATTRIB_3 ITEMDIMENSION,ITEM_CODE,PHY_ATTRIB_1 SIZE1"
						+" FROM ITEM WHERE item_parnt = ? AND ITEM_CODE != ? and  decode(catalog_no,null,'N',catalog_no) ='N' "
						+ " AND ACTIVE = 'Y' "
						+" GROUP BY ITEM_CODE,PHY_ATTRIB_2,PHY_ATTRIB_1,PHY_ATTRIB_3 " 		
						+"ORDER BY PHY_ATTRIB_1 ";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itmcode);
					pstmt.setString(2, itmcode);
					rs = pstmt.executeQuery();

					int num = 1;
					while (rs.next())
					{
						color = checkNullAndTrim(rs.getString("COLOR"));
						dimension = checkNullAndTrim(rs.getString("ITEMDIMENSION"));
						size = checkNullAndTrim(rs.getString("SIZE1"));
						itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
						dataMap.put(color+":"+dimension+":"+size, itemCode);
					}

					if (rs != null) 
					{					
						rs.close();
						rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<RECORDS>\r\n");
					
					String qty ="0",discount = "0.0";
					int dimlistlen = dimensionList.size();
					int colorlen = colorList.size();
					int sizelen = sizeList.size();
					String key = "";
					StringBuffer temStrBuffer = null;
					boolean isItemExist = false;
					for(int i=0;i<dimlistlen;i++)
					{
						for(int j=0;j<colorlen;j++)
						{
							temStrBuffer = new StringBuffer("");
							isItemExist = false;
							temStrBuffer.append("<tr>\r\n");
							temStrBuffer.append("<td><![CDATA[").append(colorData.get(colorList.get(j))).append("]]></td>\r\n"); 
							temStrBuffer.append("<td><![CDATA[").append(dimensionData.get(dimensionList.get(i))).append("]]></td>\r\n");
							temStrBuffer.append("<td><![CDATA[").append(0).append("]]></td>\r\n");
							for(int k=0;k<sizelen;k++)
							{

								key = colorList.get(j) + ":"+ dimensionList.get(i) + ":"+ sizeList.get(k);

								System.out.println("Current Key["+key+"]");

								temStrBuffer.append("<td>\r\n");
								if(dataMap.containsKey(key))
								{
									isItemExist =true;
									
									//String qty ="0";
									qty ="0";
									discount = "0.0";
									for (int x=1;x<paraDatas.length; x++)
									{
										String itmQty[] = paraDatas[x].split("::");

										if(itmQty[0].equals(dataMap.get(key)))
										{
											qty = itmQty[1];
											discount = itmQty[2];
											break;
										}
									}

									if(qty.equals("0"))
									{
										//temStrBuffer.append("<![CDATA[").append(dataMap.get(key)).append("]]>\r\n");
										temStrBuffer.append("<![CDATA[").append(dataMap.get(key)+"~"+qty+"~"+discount).append("]]>\r\n");
									}
									else
									{
										//temStrBuffer.append("<![CDATA[").append(dataMap.get(key)+"~"+qty).append("]]>\r\n");
										temStrBuffer.append("<![CDATA[").append(dataMap.get(key)+"~"+qty+"~"+discount).append("]]>\r\n");
									}
									System.out.println("Your Key is="+key);
									
									String toolTipData =  "Item Code: "+dataMap.get(key)+""+
														  "&#010;Color: "+colorList.get(j)+
											              "&#010;Dimension "+dimensionList.get(i)+
											              "&#010;Size: "+dimensionList.get(i)+"";
									
									//tooltip.add(key);
									tooltip.add(toolTipData);
								}
								else
								{
									isItemExist =true;
									temStrBuffer.append("<![CDATA[").append("X").append("]]>\r\n");

								}
								temStrBuffer.append("</td>\r\n");

							}
							temStrBuffer.append("</tr>\r\n");

							/***********************************************************/




							/************************************************************/

							if(isItemExist)
							{
								valueXmlString.append(temStrBuffer.toString());
							}
						}

					}

					for (int i = 0; i < tooltip.size(); i++) 
					{
						System.out.println("Adding="+tooltip.get(i));

						valueXmlString.append("<tooltip>\r\n");
						valueXmlString.append("<![CDATA[").append(tooltip.get(i)).append("]]>\r\n");
						valueXmlString.append("</tooltip>\r\n");
					}
					sql = " SELECT ITEM_CODE,descr FROM ITEM I WHERE I.ITEM_CODE = ?  AND I.ACTIVE = 'Y' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itmcode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						//valueXmlString.append("<Descr><![CDATA[").append(checkNullAndTrim(rs.getString(2))).append("]]></Descr>\r\n");
						valueXmlString.append("<Descr><![CDATA[").append(checkNullAndTrim(rs.getString(2) +"  available in "+cntColors+" color(s) and "+cntSizes+" size(s)  " )).append("]]></Descr>\r\n");
					}
					if (rs != null) 
					{					
						rs.close();rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();pstmt = null;
					}
					
					if(itmDLVDate.length>1)
					{
						DLVDate = itmDLVDate[1];
						valueXmlString.append("<DLVDate><![CDATA[").append(checkNullAndTrim(DLVDate)).append("]]></DLVDate>\r\n");
					}
					
					valueXmlString.append("<tab_no><![CDATA[").append(tabNum).append("]]></tab_no>\r\n");

					valueXmlString.append("</RECORDS>\r\n");

					valueXmlString.append("</PRODUCT_SET>\r\n");
					valueXmlString.append("</Root>");
				}
		        else
		        {
		        	sql = " SELECT ITEM_CODE,descr,decode(catalog_no,null,'N',catalog_no) FROM ITEM I WHERE I.ITEM_CODE = ? AND I.ACTIVE = 'Y' AND I.ITEM_PARNT IS NULL ";
		        	pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itmcode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
					valueXmlString.append("<TH_SET selected = 'N'>\r\n");
					valueXmlString.append("<SET><![CDATA[").append("Item Description").append("]]></SET>\r\n");
					valueXmlString.append("<SET><![CDATA[").append("Total Quantity").append("]]></SET>\r\n");
					valueXmlString.append("<SET><![CDATA[").append("Quantity").append("]]></SET>\r\n");
					valueXmlString.append("</TH_SET>\r\n");
					valueXmlString.append("<RECORDS>\r\n");
					valueXmlString.append("<tr>\r\n");
					valueXmlString.append("<td><![CDATA[").append(checkNullAndTrim(rs.getString(2))).append("]]></td>\r\n");
					valueXmlString.append("<td><![CDATA[").append("0.0").append("]]></td>\r\n");

					//if(rs.getString(3).equals("Y"))
					if("Y".equals(rs.getString(3)))
					{
						valueXmlString.append("<td><![CDATA[").append("X").append("]]></td>\r\n");
					}
					else
					{
						if(paraDatas.length>1)
						{
							//Changed by wasim for edit mode [START]
							//valueXmlString.append("<td><![CDATA[").append(itmcode+"~"+paraDatas[1]).append("]]></td>\r\n");
							String [] qty = paraDatas[1].split("::");
							if(qty.length > 1)
							{
								valueXmlString.append("<td><![CDATA[").append(itmcode+"~"+qty[1]).append("]]></td>\r\n");
							}
							else
							{
								valueXmlString.append("<td><![CDATA[").append(itmcode+"~"+paraDatas[1]).append("]]></td>\r\n");
							}
							//Changed by wasim for edit mode [END]
						}
						else
						{
							valueXmlString.append("<td><![CDATA[").append(itmcode).append("]]></td>\r\n");
						}
					}
					valueXmlString.append("</tr>\r\n");
					valueXmlString.append("<tooltip><![CDATA[").append("Quantity").append("]]></tooltip>\r\n");
					
					//valueXmlString.append("<Descr><![CDATA[").append(checkNullAndTrim(rs.getString(2))).append("]]></Descr>\r\n");
					valueXmlString.append("<Descr><![CDATA[").append(checkNullAndTrim(rs.getString(2) +"  available in "+1+" color and "+1+" size " )).append("]]></Descr>\r\n");
					
					System.out.println("Length="+itmDLVDate.length);
					
					if(itmDLVDate.length>1)
					{
						valueXmlString.append("<DLVDate><![CDATA[").append(checkNullAndTrim(itmDLVDate[1])).append("]]></DLVDate>\r\n");
					}
					else
					{
						DLVDate = itemDLVDate;
						valueXmlString.append("<DLVDate><![CDATA[").append(checkNullAndTrim(DLVDate)).append("]]></DLVDate>\r\n");
					}
					
					valueXmlString.append("<tab_no><![CDATA[").append(tabNum).append("]]></tab_no>\r\n");
					
					valueXmlString.append("</RECORDS>\r\n");
					valueXmlString.append("</PRODUCT_SET>\r\n");
					valueXmlString.append("</Root>");
					}
					
					if (rs != null) 
					{					
						rs.close();rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();pstmt = null;
					}
		        }
				
			}//End try
			catch (Exception e)
			{
				System.out.println("Exception inside PorderWiz getSKUDetail="+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally 
			{
				try 
				{
					if (rs != null) 
					{					
						rs.close();
						rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();
						pstmt = null;
					}
					if (conn != null && !conn.isClosed()) 
					{					
						conn.close();
						conn = null;
					}
				} 
				catch (Exception ex) 
				{
					ex.printStackTrace();
				}
			}
			
	        //System.out.println("return Product Set=["+valueXmlString.toString()+"]");
	        return valueXmlString.toString();
		}
		
		
		// Changed by Sneha on 31-05-2016, for PO details [Start]
		public String getPurcDetail1(String purcOrder, String flag) throws ITMException 
		{
			System.out.println("--------- Inside getPurcDetail1 ----------");
			E12GenericUtility genericUtility = new E12GenericUtility();
			StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
			Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			Date ordDate = null;
			String currDate = "", itemSer = "", pordType = "", suppCode = "", siteCodeDlv = "", siteCodeOrd = "", deptCode = "", empCode = "", 
					crTerm = "", currCode = "", chgDate = "", 	chgUser = "", chgTerm = "",	udfStr1 = "", confirmed = "",  confDate = "", remarks = "",
					tranCode = "", dlvTerm = "", type = "", priceList = "", exchRate = "", termTable = "", indNo = "", transMode = "", siteDescr = "", 
					udfStr2 = "", itemSerDescr = "", suppName = "", crTermDescr = "", tranName = "", departmentDescr = "", relAmt = "", 
					purOrderDb = "", amtType = "";
			try 
			{
				//ConnDriver connDriver = new ConnDriver();
				//conn = connDriver.getConnectDB("DriverITM");
				conn = getConnection();
				
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				currDate = sdf.format(new java.util.Date());
				
				int count = 0;
				String sql = "",conf = "";
				
				sql = " SELECT CONFIRMED FROM PORDER WHERE PURC_ORDER = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, purcOrder);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					conf = checkNullAndTrim(rs.getString("CONFIRMED"));
					count++;
				}
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				
				if("Y".equalsIgnoreCase(conf))
				{
					return "Y";
				}
				
				if(count == 0)
				{
					return "0";
				}
				else //else purchase order is present
				{
					count = 0;
					
					sql = " SELECT COUNT(1) FROM PORDER_TEMP WHERE PURC_ORDER = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						count = rs.getInt(1);
					}
					if (rs != null) 
					{					
						rs.close();
						rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();
						pstmt = null;
					}
					if(count > 0)	// 
					{
						sql = " SELECT PURC_ORDER, ORD_DATE, TRAN_DATE, IND_NO, PORD_TYPE, ITEM_SER, TASK_DESC, SUPP_CODE, SUPP_NAME, CR_TERM, CRTERM_DESCR," 
							+ " REMARKS, DLV_TERM, TRAN_CODE, TRAN_NAME, PRICE_LIST, EXCH_RATE, DEPT_CODE, DEPT_DESCR, TRANS_MODE, SITE_CODE__DLV, " 
							+ " SITE_CODE__ORD, SITE_DESCR, SITE_ADD1, CURR_CODE, TERM_TABLE, UDF_STR__1, UDF_STR__2, EMP_CODE, CHG_DATE, CHG_USER,  " 
							+ " CHG_TERM, STATUS FROM PORDER_TEMP WHERE PURC_ORDER = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrder);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							 purOrderDb = checkNullAndTrim(rs.getString("PURC_ORDER"));
							 ordDate = rs.getDate("ORD_DATE");
							 indNo = checkNullAndTrim(rs.getString("IND_NO"));
							 pordType = checkNullAndTrim(rs.getString("PORD_TYPE"));
							 itemSer = checkNullAndTrim(rs.getString("ITEM_SER"));
							 itemSerDescr = checkNullAndTrim(rs.getString("TASK_DESC"));
							 suppCode = checkNullAndTrim(rs.getString("SUPP_CODE"));
							 suppName = checkNullAndTrim(rs.getString("SUPP_NAME"));
							 crTerm = checkNullAndTrim(rs.getString("CR_TERM"));
							 crTermDescr = checkNullAndTrim(rs.getString("CRTERM_DESCR"));
							 remarks = checkNullAndTrim(rs.getString("REMARKS"));
							 dlvTerm = checkNullAndTrim(rs.getString("DLV_TERM"));
							 tranCode = checkNullAndTrim(rs.getString("TRAN_CODE"));
							 tranName = checkNullAndTrim(rs.getString("TRAN_NAME"));
							 priceList = checkNullAndTrim(rs.getString("PRICE_LIST"));
							 exchRate = checkNullAndTrim(rs.getString("EXCH_RATE"));		
							 deptCode = checkNullAndTrim(rs.getString("DEPT_CODE"));
							 departmentDescr = checkNullAndTrim(rs.getString("DEPT_DESCR"));
							 transMode = checkNullAndTrim(rs.getString("TRANS_MODE"));
							 siteCodeDlv = checkNullAndTrim(rs.getString("SITE_CODE__DLV"));
							 siteCodeOrd = checkNullAndTrim(rs.getString("SITE_CODE__ORD"));
							 siteDescr = checkNullAndTrim(rs.getString("SITE_DESCR"));
							 currCode = checkNullAndTrim(rs.getString("CURR_CODE"));
							 termTable = checkNullAndTrim(rs.getString("TERM_TABLE"));
							 udfStr1 = checkNullAndTrim(rs.getString("UDF_STR__1"));
							 udfStr2 = checkNullAndTrim(rs.getString("UDF_STR__2"));
							 empCode = checkNullAndTrim(rs.getString("EMP_CODE"));
							 chgDate = checkNullAndTrim(rs.getString("CHG_DATE"));
							 chgUser = checkNullAndTrim(rs.getString("CHG_USER"));
							 chgTerm = checkNullAndTrim(rs.getString("CHG_TERM"));
							 type = checkNullAndTrim(rs.getString("UDF_STR__1"));
							 relAmt = checkNullAndTrim(rs.getString("SITE_ADD1"));
	
							 udfStr2 = checkNullAndTrim(rs.getString("UDF_STR__2"));
							 confirmed = "N";
							 confDate = currDate;	
							 
							 if(udfStr1.equalsIgnoreCase("% of base"))
							 {
								 amtType = "01";
							 }
							 else if(udfStr1.equalsIgnoreCase("% of net"))
							 {
								 amtType = "02";
							 }
							 else if(udfStr1.equalsIgnoreCase("Fixed Amount"))
							 {
								 amtType = "03";
							 }
						}
						if (rs != null) 
						{					
							rs.close();
							rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();
							pstmt = null;
						}
					}
					else	//
					{
						sql = " SELECT PURC_ORDER, ORD_DATE, PORD_TYPE, SUPP_CODE, SITE_CODE__DLV, SITE_CODE__ORD, DEPT_CODE, EMP_CODE, ITEM_SER, CR_TERM, " 
								+ " CURR_CODE, CHG_DATE, CHG_USER, CHG_TERM, UDF_STR__1, CONFIRMED, CONF_DATE, REMARKS, TRAN_CODE, DLV_TERM, PRICE_LIST, "
								+ " EXCH_RATE, TERM_TABLE, IND_NO, TRANS_MODE, SITE_DESCR, UDF_STR__2 FROM PORDER WHERE PURC_ORDER = ? "
								+ " AND CONFIRMED = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrder);
						pstmt.setString(2, "N");
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							 purOrderDb = checkNullAndTrim(rs.getString("PURC_ORDER"));
							 ordDate = rs.getDate("ORD_DATE");
							 pordType = checkNullAndTrim(rs.getString("PORD_TYPE"));
							 suppCode = checkNullAndTrim(rs.getString("SUPP_CODE"));
							 siteCodeDlv = checkNullAndTrim(rs.getString("SITE_CODE__DLV"));
							 siteCodeOrd = checkNullAndTrim(rs.getString("SITE_CODE__ORD"));
							 deptCode = checkNullAndTrim(rs.getString("DEPT_CODE"));
							 empCode = checkNullAndTrim(rs.getString("EMP_CODE"));
							 itemSer = checkNullAndTrim(rs.getString("ITEM_SER"));
							 crTerm = checkNullAndTrim(rs.getString("CR_TERM"));
							 currCode = checkNullAndTrim(rs.getString("CURR_CODE"));
							 chgDate = checkNullAndTrim(rs.getString("CHG_DATE"));
							 chgUser = checkNullAndTrim(rs.getString("CHG_USER"));
							 chgTerm = checkNullAndTrim(rs.getString("CHG_TERM"));
							 udfStr1 = checkNullAndTrim(rs.getString("UDF_STR__1"));
							 confirmed = checkNullAndTrim(rs.getString("CONFIRMED"));
							 confDate = checkNullAndTrim(rs.getString("CONF_DATE"));
							 remarks = checkNullAndTrim(rs.getString("REMARKS"));
							 tranCode = checkNullAndTrim(rs.getString("TRAN_CODE"));
							 dlvTerm = checkNullAndTrim(rs.getString("DLV_TERM"));
							 priceList = checkNullAndTrim(rs.getString("PRICE_LIST"));
							 exchRate = checkNullAndTrim(rs.getString("EXCH_RATE"));			
							 termTable = checkNullAndTrim(rs.getString("TERM_TABLE"));
							 indNo = checkNullAndTrim(rs.getString("IND_NO"));
							 transMode = checkNullAndTrim(rs.getString("TRANS_MODE"));
							 siteDescr = checkNullAndTrim(rs.getString("SITE_DESCR"));
							 udfStr2 = checkNullAndTrim(rs.getString("UDF_STR__2"));
						}
						if (rs != null) 
						{					
							rs.close();
							rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();
							pstmt = null;
						}
						
						sql = " SELECT REL_AMT, TYPE, AMT_TYPE FROM PORD_PAY_TERM WHERE PURC_ORDER = ?  ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrder);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							 relAmt = checkNullAndTrim(rs.getString("REL_AMT"));
							 type = checkNullAndTrim(rs.getString("TYPE"));
							 amtType = checkNullAndTrim(rs.getString("AMT_TYPE"));
						}
						if (rs != null) 
						{					
							rs.close();
							rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();
							pstmt = null;
						}
						
						sql = " SELECT DESCR FROM ITEMSER WHERE ITEM_SER = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, itemSer);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							 itemSerDescr = checkNullAndTrim(rs.getString("DESCR"));
						}
						if (rs != null) 
						{					
							rs.close();
							rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();
							pstmt = null;
						}
						
						sql = " SELECT SUPP_NAME FROM SUPPLIER WHERE SUPP_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, suppCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							 suppName = checkNullAndTrim(rs.getString("SUPP_NAME"));
						}
						if (rs != null) 
						{					
							rs.close();
							rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();
							pstmt = null;
						}
						
						sql = "SELECT DESCR FROM CRTERM where CR_TERM = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, crTerm);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							crTermDescr = checkNullAndTrim(rs.getString("DESCR"));
						}
						if (rs != null) 
						{					
							rs.close();
							rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();
							pstmt = null;
						}
						
						sql = "SELECT TRAN_NAME FROM TRANSPORTER WHERE TRAN_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							tranName = checkNullAndTrim(rs.getString("TRAN_NAME"));
						}
						if (rs != null) 
						{					
							rs.close();
							rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();
							pstmt = null;
						}
						
						sql = "SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, deptCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							departmentDescr = checkNullAndTrim(rs.getString("DESCR"));
						}
						if (rs != null) 
						{					
							rs.close();
							rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();
							pstmt = null;
						}
					}
	
					valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r\n");
					valueXmlString.append("<flag>").append("<![CDATA["+flag+"]]>").append("</flag>\r\n");
					valueXmlString.append("<purc_order>").append("<![CDATA["+purOrderDb+"]]>").append("</purc_order>\r\n");
					valueXmlString.append("<tran_date>").append("<![CDATA["+currDate+"]]>").append("</tran_date>\r\n");	
					valueXmlString.append("<ord_date>").append("<![CDATA["+sdf.format(ordDate).toString() +"]]>").append("</ord_date>\r\n");	
					valueXmlString.append("<pord_type>").append("<![CDATA["+pordType+"]]>").append("</pord_type>\r\n");	
					valueXmlString.append("<ind_no>").append("<![CDATA["+indNo+"]]>").append("</ind_no>\r\n");
					valueXmlString.append("<item_ser>").append("<![CDATA["+itemSer+"]]>").append("</item_ser>\r\n");
					valueXmlString.append("<item_descr>").append("<![CDATA["+itemSerDescr+"]]>").append("</item_descr>\r\n");
					valueXmlString.append("<supp_code>").append("<![CDATA["+suppCode+"]]>").append("</supp_code>\r\n");	
					valueXmlString.append("<supp_name>").append("<![CDATA["+suppName+"]]>").append("</supp_name>\r\n");	
					valueXmlString.append("<cr_term>").append("<![CDATA["+crTerm+"]]>").append("</cr_term>\r\n");	
					valueXmlString.append("<crterm_descr>").append("<![CDATA["+crTermDescr+"]]>").append("</crterm_descr>\r\n");	
					valueXmlString.append("<remarks>").append("<![CDATA["+remarks+"]]>").append("</remarks>\r\n");	
					valueXmlString.append("<confirmed>").append("<![CDATA["+confirmed+"]]>").append("</confirmed>\r\n");	
					valueXmlString.append("<dlv_term>").append("<![CDATA["+dlvTerm+"]]>").append("</dlv_term>\r\n");	
					valueXmlString.append("<tran_code>").append("<![CDATA["+tranCode+"]]>").append("</tran_code>\r\n");	
					valueXmlString.append("<tran_name>").append("<![CDATA["+tranName+"]]>").append("</tran_name>\r\n");
					valueXmlString.append("<price_list>").append("<![CDATA["+priceList+"]]>").append("</price_list>\r\n");	
					
					valueXmlString.append("<conf_date>").append("<![CDATA["+confDate+"]]>").append("</conf_date>\r\n");	
					valueXmlString.append("<exch_rate>").append("<![CDATA["+exchRate+"]]>").append("</exch_rate>\r\n");	
					valueXmlString.append("<dept_code>").append("<![CDATA["+deptCode+"]]>").append("</dept_code>\r\n");	
					valueXmlString.append("<department_descr>").append("<![CDATA["+departmentDescr+"]]>").append("</department_descr>\r\n");	
					valueXmlString.append("<trans_mode>").append("<![CDATA["+transMode+"]]>").append("</trans_mode>\r\n");
					valueXmlString.append("<site_code__dlv>").append("<![CDATA["+siteCodeDlv+"]]>").append("</site_code__dlv>\r\n");	
					valueXmlString.append("<site_code__ord>").append("<![CDATA["+siteCodeOrd+"]]>").append("</site_code__ord>\r\n");	
					valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr>\r\n");	
					//valueXmlString.append("<task_desc>").append("<![CDATA["+taskDesc+"]]>").append("</task_desc>\r\n");	
					valueXmlString.append("<site_add1>").append("<![CDATA["+relAmt+"]]>").append("</site_add1>\r\n");	
					valueXmlString.append("<emp_code>").append("<![CDATA["+empCode+"]]>").append("</emp_code>\r\n");	
					valueXmlString.append("<curr_code>").append("<![CDATA["+currCode+"]]>").append("</curr_code>\r\n");	
					valueXmlString.append("<chg_date>").append("<![CDATA["+chgDate+"]]>").append("</chg_date>\r\n");	
					valueXmlString.append("<chg_user>").append("<![CDATA["+chgUser+"]]>").append("</chg_user>\r\n");	
					valueXmlString.append("<chg_term>").append("<![CDATA["+chgTerm+"]]>").append("</chg_term>\r\n");	
					valueXmlString.append("<term_table>").append("<![CDATA["+termTable+"]]>").append("</term_table>\r\n");	
					valueXmlString.append("<udf_str__2>").append("<![CDATA["+udfStr2+"]]>").append("</udf_str__2>\r\n");
					valueXmlString.append("<udf_str__1>").append("<![CDATA["+amtType+"]]>").append("</udf_str__1>\r\n");
					//valueXmlString.append("<udf_str__3>").append("<![CDATA[]]>").append("</udf_str__3>\r\n");
					valueXmlString.append("</Detail1>\r\n");
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				System.out.println("Exception :PorderDetailBean :getPurcDetail1(String):"	+ e.getMessage() + ":");
				valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			} 
			finally 
			{
				try 
				{
					if (rs != null) 
					{					
						rs.close();
						rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();
						pstmt = null;
					}
					if (conn != null && !conn.isClosed()) 
					{					
						conn.close();
						conn = null;
					}
				} 
				catch (Exception e) 
				{
					System.out.println("Exception :PorderDetailBean :getPurcDetail1(String) :==>\n"+ e.getMessage());
					throw new ITMException(e);
				}
			}
			valueXmlString.append("</Root>\r\n");
			System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
			
			return valueXmlString.toString();
		}
		// Changed by Sneha on 31-05-2016, for PO details [Start]
		
		public String getPorderDetail2(String siteCode,String empCodeFrmReq,String purcOrder,String flag)throws ITMException 
		{
			System.out.println("******** Inside getPorderDetail2 ***********");
			System.out.println("******** SiteCode["+siteCode+"] EmpCode["+empCodeFrmReq+"] SaleOrder["+purcOrder+"] Status["+flag+"] ***********");
			
			String sql = "",retStr = "";
			PreparedStatement pstmt = null,pstmtSel = null;
			ResultSet rs = null,rsSel = null;
			Connection conn = null;
			
			String itemParent = "",itemCode = "",finalItmQtyStr = "",quantity = "",dspDateStr = "",saleOrderTemp = "",tabNum = "",dlvDate = "";
			String sqlSel = "",purcOrderTemp = "";
			
			HashMap<String, String> hm = new HashMap<String, String>();
			Date dlvDateDt = null;
			
			double discount = 0;
			try
			{
				conn = getConnection();
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				
				System.out.println("purcOrder Inside if GET_PURC_DET_2 = ["+ purcOrder +"]");
				
				//Changed by wasim on 09-03-2017
			    //if("A".equalsIgnoreCase(flag) && purcOrder.length() <= 0)	// Add mode, Purchase order blank
				if("A".equalsIgnoreCase(flag))	
			    {
			    	sqlSel = " SELECT PURC_ORDER FROM PORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ?   ";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, "A");
					pstmtSel.setString(2, empCodeFrmReq);
					pstmtSel.setString(3, siteCode);		
					rsSel = pstmtSel.executeQuery();
					if(rsSel.next())
					{
						purcOrderTemp = checkNullAndTrim(rsSel.getString("PURC_ORDER"));
						
						//Changed by wasim added discount column
						/*sql = " SELECT I.ITEM_PARNT, P.ITEM_CODE, P.DLV_DATE, P.QUANTITY, P.TAB_NO FROM PORDDET_TEMP P, ITEM I WHERE PURC_ORDER = ? " 
							+ " AND I.ITEM_CODE = P.ITEM_CODE ORDER BY I.ITEM_PARNT,  P.ITEM_CODE ";*/
						sql = " SELECT I.ITEM_PARNT, P.ITEM_CODE, P.DLV_DATE, P.QUANTITY, P.TAB_NO, P.DISCOUNT FROM PORDDET_TEMP P, ITEM I WHERE PURC_ORDER = ? " 
								+ " AND I.ITEM_CODE = P.ITEM_CODE ORDER BY I.ITEM_PARNT,  P.ITEM_CODE ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrderTemp);
					}
					if(rsSel != null)
					{
						rsSel.close();
						rsSel = null;
					}
					if(pstmtSel != null)
					{
						pstmtSel.close();
						pstmtSel = null;
					}
			    }
				else if("E".equalsIgnoreCase(flag) && purcOrder.length() > 0)	// Edit mode, Purchase order found
			    {
					//System.out.println("Inside 333333333 ["+ purcOrder +"]");
					
					//Changed by wasim added discount column
					/*sql = "SELECT  I.ITEM_PARNT, P.ITEM_CODE, P.DLV_DATE, P.QUANTITY, P.FORM_NO AS TAB_NO  FROM PORDDET P, ITEM I WHERE PURC_ORDER = ? AND " 
						+ "I.ITEM_CODE = P.ITEM_CODE AND P.Item_code not in (SELECT  PT.ITEM_CODE FROM PORDDET_TEMP PT WHERE PURC_ORDER = ? ) " 
						+ "UNION  " 
						+ "SELECT  I.ITEM_PARNT, PT.ITEM_CODE, PT.DLV_DATE, PT.QUANTITY, PT.TAB_NO FROM PORDDET_TEMP PT, ITEM I WHERE PURC_ORDER = ? " 
						+ "AND I.ITEM_CODE = PT.ITEM_CODE ORDER BY TAB_NO ";*/
					sql = "SELECT  I.ITEM_PARNT, P.ITEM_CODE, P.DLV_DATE, P.QUANTITY, P.FORM_NO AS TAB_NO,P.DISCOUNT  FROM PORDDET P, ITEM I WHERE PURC_ORDER = ? AND " 
							+ "I.ITEM_CODE = P.ITEM_CODE AND P.Item_code not in (SELECT  PT.ITEM_CODE FROM PORDDET_TEMP PT WHERE PURC_ORDER = ? ) " 
							+ "UNION  " 
							+ "SELECT  I.ITEM_PARNT, PT.ITEM_CODE, PT.DLV_DATE, PT.QUANTITY, PT.TAB_NO,PT.DISCOUNT FROM PORDDET_TEMP PT, ITEM I WHERE PURC_ORDER = ? " 
							+ "AND I.ITEM_CODE = PT.ITEM_CODE ORDER BY TAB_NO ";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					pstmt.setString(2, purcOrder);
					pstmt.setString(3, purcOrder);
			    }
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					itemParent = checkNullAndTrim(rs.getString("ITEM_PARNT"));
					itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
					dlvDateDt = rs.getDate("DLV_DATE");
					quantity = checkNullAndTrim(rs.getString("QUANTITY"));
					
					dlvDate = sdf.format(dlvDateDt).toString();
					
					tabNum = checkNullAndTrim(rs.getString("TAB_NO"));
					discount = rs.getDouble("DISCOUNT");
					
					if(itemParent == null || itemParent.length() == 0)
					{
						itemParent = itemCode+":"+tabNum;
					}
					else
					{
						itemParent = itemParent+":"+tabNum;
					}
					
					System.out.println("Final Item Parent with Tab number="+itemParent);
					
					if(hm.containsKey(itemParent))
					{	
						String itemQtyStr = hm.get(itemParent); 
						//Changed by wasim
						//hm.put(itemParent, itemQtyStr + itemCode + "::" + quantity + "~");
						hm.put(itemParent, itemQtyStr + itemCode + "::" + quantity + "::" + discount + "~" );
					}
					else
					{
						//10115C****301761~02/06/16****301761::1||||10****301738~02/06/16****301738::2~301736::3
						//Changed by wasim
						//hm.put(itemParent, (itemParent + "****" + itemCode + "~" + dlvDate + "****" +itemCode + "::" + quantity + "~"));
						hm.put(itemParent, (itemParent + "****" + itemCode + "~" + dlvDate + "****" +itemCode + "::" + quantity + "::" + discount + "~" ));
					}
					itemParent = "";
					itemCode = "";
					dlvDateDt = null;
					quantity = "";
				}
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				
				 Set<String> setOfKeys = hm.keySet();
				 Iterator<String> iterator = setOfKeys.iterator();
				 finalItmQtyStr = "";
				 while (iterator.hasNext()) 
				 {
					 String key = (String) iterator.next();
					 String value = hm.get(key);
					 finalItmQtyStr = finalItmQtyStr+value.substring(0,value.length()-1)+"||||";
				 }
				 retStr = finalItmQtyStr;
			}
			catch(Exception e)
			{
				System.out.println("Inside catch getPorderDetail2"+e.getMessage());
				e.printStackTrace();
			}
			finally
			{
				try
				{
					if (rsSel != null) 
					{					
						rsSel.close();
						rsSel = null;
					}
					if (pstmtSel != null ) 
					{					
						pstmtSel.close();
						pstmtSel = null;
					}
					if( pstmt != null )
					{
						pstmt.close();pstmt = null;
					}
					if (rs != null)
					{
						rs.close();rs = null;
					}
					if (conn != null)
					{
						conn.close();conn = null;
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}
			System.out.println("Returning getPorderDetail2"+retStr);			
			return retStr;
		}
		
		
		public String savePorderHeader(String str,String ordSiteCode) throws ITMException 
		{
			String sql= "",sqlSel = "",retStr = "",purcOrderTemp = "";
			PreparedStatement pstmt = null,pstmtSel = null;
			ResultSet rs = null,rsSel = null;
			Connection conn = null;
			
			boolean isError = false;
			try
			{
				conn = getConnection();
				
				System.out.println("------Inside SAVE_PODtl1 ---------");

				java.sql.Timestamp currdate = new java.sql.Timestamp( System.currentTimeMillis() );
				
				String[] detail = str.split("~");

				if(detail[29].equalsIgnoreCase("A"))
				{
					sqlSel = " SELECT PURC_ORDER FROM PORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ? ";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, detail[29]);
					pstmtSel.setString(2, detail[26]);
					pstmtSel.setString(3, detail[2]);		
				}
				else if(detail[29].equalsIgnoreCase("E"))
				{
					sqlSel = " SELECT PURC_ORDER FROM PORDER_TEMP WHERE STATUS in (?,?) AND EMP_CODE = ? AND SITE_CODE__ORD = ? AND PURC_ORDER = ? ";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, detail[29]);
					pstmtSel.setString(2, "O");
					pstmtSel.setString(3, detail[26]);
					pstmtSel.setString(4, detail[2]);
					pstmtSel.setString(5, detail[0]);
				}
				rsSel = pstmtSel.executeQuery();
				if( rsSel.next() )
				{	
					purcOrderTemp = checkNullAndTrim(rsSel.getString("PURC_ORDER"));
				}
				if(rsSel != null)
				{
					rsSel.close();
					rsSel = null;
				}
				if(pstmtSel != null)
				{
					pstmtSel.close();
					pstmtSel = null;
				}
				
				if(detail[0].length() <= 0 && purcOrderTemp.length() > 0)	// Add mode old record
				{
					detail[0] = purcOrderTemp;
				}
				else if(detail[0].length() <= 0 && purcOrderTemp.length() <= 0)	// Add mode new record
				{
					detail[0] = generateTranId( "w_porderWiz_temp", ordSiteCode, conn );
					System.out.println("purchase order after generateTranId ======>>" + detail[0]);
				}
				System.out.println("------- purchase order after ----- " + detail[0]);
				
				if(purcOrderTemp.length() > 0)		// purchase order found blank and Status = "A"  ADD 
				{
					System.out.println("UPDATE PORDER_TEMP ======>>"+detail[0]);

					sql = "UPDATE PORDER_TEMP SET TRAN_DATE = ?, PORD_TYPE = ?, ITEM_SER = ?, TASK_DESC = ?, SUPP_CODE = ?, SUPP_NAME = ?, " 
					+ "CR_TERM = ?, CRTERM_DESCR = ?, REMARKS = ?, DLV_TERM = ?, TRAN_CODE = ?, TRAN_NAME = ?, PRICE_LIST = ?, " 
					+ "EXCH_RATE = ?, DEPT_CODE = ?, DEPT_DESCR = ?, TRANS_MODE = ?, SITE_ADD1 = ?, CURR_CODE = ?, TERM_TABLE = ?, " 
					+ "UDF_STR__1 = ?, CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ?, STATUS = ? " 
					+ "WHERE PURC_ORDER = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, currdate);	// TRAN_DATE
					pstmt.setString(2, detail[3]);		// pord_type
					pstmt.setString(3, detail[4]);		// itmser
					pstmt.setString(4, detail[5]);		// itmdescr/TASK_DESC
					pstmt.setString(5, detail[6]);		// supcode
					pstmt.setString(6, detail[7]);		// supname
					pstmt.setString(7, detail[8]);		// crterm
					pstmt.setString(8, detail[9]);		// crdescr
					pstmt.setString(9, detail[10]);		// remarks
					pstmt.setString(10, detail[12]);	// dlvterm
					pstmt.setString(11, detail[13]);	// trcode
					pstmt.setString(12, detail[14]);	// trdescr
					pstmt.setString(13, detail[17]);	// prlist
					pstmt.setString(14, detail[19]);	// exch_rate
					pstmt.setString(15, detail[20]);	// dcode
					pstmt.setString(16, detail[21]);	// ddescr
					pstmt.setString(17, detail[15]);	// trmode
					pstmt.setString(18, detail[24]);	// site_add1
					pstmt.setString(19, detail[18]);	// curr_code
					pstmt.setString(20, detail[22]);	// term_table
					pstmt.setString(21, detail[23]);	// udf_str__1
					pstmt.setTimestamp(22, currdate);	// CHG_DATE
					pstmt.setString(23, detail[27]);	// CHG_USER
					pstmt.setString(24, detail[28]);	// CHG_TERM
					pstmt.setString(25, detail[29]);	// STATUS
					
					pstmt.setString(26, detail[0]);		// purc_order
					pstmt.setString(27, detail[26]);	// EMP_CODE
					pstmt.setString(28, detail[2]);		// SITE_CODE__ORD
					pstmt.executeUpdate();
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
				else if(purcOrderTemp.length() <= 0)	
				{
					System.out.println("INSERT into PORDER_TEMP ======>>"+detail[0]);					
					
					String orddate = genericUtility.getValidDateTimeString(
						checkNullAndTrim(detail[1]), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

					sql = "INSERT INTO PORDER_TEMP(PURC_ORDER, ORD_DATE, TRAN_DATE, PORD_TYPE, ITEM_SER, TASK_DESC, SUPP_CODE, SUPP_NAME, " 
						+ "CR_TERM, CRTERM_DESCR, REMARKS, DLV_TERM, TRAN_CODE, TRAN_NAME, PRICE_LIST, EXCH_RATE, DEPT_CODE, DEPT_DESCR, " 
						+ "TRANS_MODE, SITE_CODE__DLV, SITE_CODE__ORD, SITE_ADD1, CURR_CODE, TERM_TABLE, UDF_STR__1, " 
						+ "UDF_STR__2, EMP_CODE, CHG_DATE, CHG_USER, CHG_TERM, STATUS) " 
						+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, detail[0]);		// purc_order
					pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(orddate));		// orddate
					pstmt.setTimestamp(3, currdate);	// TRAN_DATE
					pstmt.setString(4, detail[3]);		// pord_type
					pstmt.setString(5, detail[4]);		// itmser
					pstmt.setString(6, detail[5]);		// itmdescr/TASK_DESC
					pstmt.setString(7, detail[6]);		// supcode
					pstmt.setString(8, detail[7]);		// supname
					pstmt.setString(9, detail[8]);		// crterm
					pstmt.setString(10, detail[9]);		// crdescr
					pstmt.setString(11, detail[10]);	// remarks
					pstmt.setString(12, detail[12]);	// dlvterm
					pstmt.setString(13, detail[13]);	// trcode
					pstmt.setString(14, detail[14]);	// trdescr
					pstmt.setString(15, detail[17]);	// prlist
					pstmt.setString(16, detail[19]);	// exch_rate
					pstmt.setString(17, detail[20]);	// dcode
					pstmt.setString(18, detail[21]);	// ddescr
					pstmt.setString(19, detail[15]);	// trmode
					pstmt.setString(20, detail[11]);	// site_code__dlv
					pstmt.setString(21, detail[2]);		// order_site/SITE_CODE__ORD
					pstmt.setString(22, detail[24]);	// site_add1
					pstmt.setString(23, detail[18]);	// curr_code
					pstmt.setString(24, detail[22]);	// term_table
					pstmt.setString(25, detail[23]);	// udf_str__1
					pstmt.setString(26, detail[25]);	// udf_str__2
					pstmt.setString(27, detail[26]);	// EMP_CODE
					pstmt.setTimestamp(28, currdate);	// CHG_DATE
					pstmt.setString(29, detail[27]);	// CHG_USER
					pstmt.setString(30, detail[28]);	// CHG_TERM
					pstmt.setString(31, detail[29]);			// STATUS
					//pstmt.setString(28, detail[17]);	// delivery_term_descr
					pstmt.executeUpdate();
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				//retStr = detail[0];
			}
			catch (Exception e)
			{
				System.out.println("Exception inside savePorderHeader PorderWiz"+e.getMessage());
				e.printStackTrace();
				isError = true;
			}
			finally
			{
				try
				{
					if(isError)
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
					if (rsSel != null) 
					{					
						rsSel.close();
						rsSel = null;
					}
					if (pstmtSel != null ) 
					{					
						pstmtSel.close();
						pstmtSel = null;
					}
					if( pstmt != null )
					{
						pstmt.close();pstmt = null;
					}
					if (rs != null)
					{
						rs.close();rs = null;
					}
					if (conn != null)
					{
						conn.close();conn = null;
					}
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}
			return retStr;
		}
		
		public String savePorderDetail(String str) throws ITMException 
		{
			String sql= "",sqlSel = "",retStr = "",purcOrderTemp = "",dlvDate = "";
			PreparedStatement pstmt = null,pstmtSel = null;
			ResultSet rs = null,rsSel = null;
			Connection conn = null;
			boolean isError = false;
			try
			{
				conn = getConnection();
				
				System.out.println("Inside savePorderDetail ["+str+"]");
				String[] detail = str.split("~");
				
				String purcOrderFrmHdr = "",pordType = "";	
				if(detail[6].equalsIgnoreCase("A"))		// Status
				{
					sqlSel = " SELECT PURC_ORDER,PORD_TYPE FROM PORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ? ";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, detail[6]);		 //Status
					pstmtSel.setString(2, detail[4]);		 // Emp_Code
					pstmtSel.setString(3, detail[5]);		// order_site/SITE_CODE__ORD
					rsSel = pstmtSel.executeQuery();
					if(rsSel.next())
					{
						purcOrderFrmHdr = rsSel.getString("PURC_ORDER");
						pordType = rsSel.getString("PORD_TYPE");
					}
					if(rsSel != null)
					{
						rsSel.close();
						rsSel = null;
					}
					if(pstmtSel != null)
					{
						pstmtSel.close();
						pstmtSel = null;
					}
				}
				else
				{
					purcOrderFrmHdr = detail[7];
				}
				
				if("DELETE".equalsIgnoreCase(detail[2])) //Deleting accordian
				{
					System.out.println("Inside delete acrrodian["+pordType+"]");
					//sql = " DELETE FROM PORDDET_TEMP WHERE PURC_ORDER = ? AND ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = ?) AND TAB_NO = ?";
					//sql = " DELETE FROM PORDDET_TEMP WHERE PURC_ORDER = ? AND ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = ?) ";
					
					if(pordType == null || pordType.length() == 0)
					{
						pordType = checkNullAndTrim(detail[9]);
					}
					
					if("T".equalsIgnoreCase(pordType))
					{
						sql = " DELETE FROM PORDDET_TEMP WHERE PURC_ORDER = ? AND ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = ?) AND TAB_NO = ? ";
					}
					else
					{
						sql = " DELETE FROM PORDDET_TEMP WHERE PURC_ORDER = ? AND ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_CODE = ?) AND TAB_NO = ? ";
					}
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrderFrmHdr);
					pstmt.setString(2, detail[1]);
					pstmt.setString(3, detail[8]);
					int upd = pstmt.executeUpdate();
					System.out.println("Deleted Items="+upd);
					if( pstmt != null )
					{
						pstmt.close();pstmt = null;
					}
					return "";
				}
					
				//if(!detail[2].trim().equalsIgnoreCase("") && Integer.parseInt(detail[2]) > 0)
				if(!detail[2].trim().equalsIgnoreCase("") && Double.parseDouble(detail[2]) > 0)//Changed by wasim on 09-03-2017 for parsing			
				{
					//sqlSel = "SELECT ITEM_CODE FROM PORDDET_TEMP PD WHERE PURC_ORDER = ? AND ITEM_CODE = ? ";
					sqlSel = "SELECT ITEM_CODE FROM PORDDET_TEMP PD WHERE PURC_ORDER = ? AND ITEM_CODE = ? AND TAB_NO = ?";
					pstmtSel = conn.prepareStatement(sqlSel);
					pstmtSel.setString(1, purcOrderFrmHdr);			// PURC_ORDER
					pstmtSel.setString(2, detail[1]);
					pstmtSel.setString(3, detail[8]);
					rsSel = pstmtSel.executeQuery();
					if( rsSel.next() )
					{
						//sql = "UPDATE PORDDET_TEMP SET QUANTITY = ? WHERE PURC_ORDER = ? AND ITEM_CODE = ? ";
						//Added discount field by wasim in porddet_temp table
						sql = "UPDATE PORDDET_TEMP SET QUANTITY = ?,DISCOUNT = ? WHERE PURC_ORDER = ? AND ITEM_CODE = ? AND TAB_NO = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, detail[2]);				// QUANTITY
						pstmt.setDouble(2, Double.parseDouble(detail[9]));
						pstmt.setString(3, purcOrderFrmHdr);		// PURC_ORDER
						pstmt.setString(4, detail[1]);				// ITEM_CODE
						pstmt.setString(5, detail[8]);
						pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else
					{
						dlvDate = genericUtility.getValidDateTimeString(
								checkNullAndTrim(detail[3]), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

						sql = "INSERT INTO PORDDET_TEMP(PURC_ORDER, SITE_CODE, ITEM_CODE, QUANTITY, DLV_DATE, TAB_NO, DISCOUNT) " 
								+ " VALUES(?,?,?,?,?,?,?)";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, purcOrderFrmHdr);	// PURC_ORDER
						pstmt.setString(2, detail[0]);			// SITE_CODE
						pstmt.setString(3, detail[1]);			// ITEM_CODE
						pstmt.setString(4, detail[2]);			// QUANTITY	
						pstmt.setTimestamp(5, java.sql.Timestamp.valueOf(dlvDate));		// DLV_DATE
						pstmt.setString(6, detail[8]);
						pstmt.setDouble(7, Double.parseDouble( detail[9]));//ADDED DISCOUNT COLUMN ON 10-09-2017
						pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					if(rsSel != null)
					{
						rsSel.close();
						rsSel = null;
					}
					if(pstmtSel != null)
					{
						pstmtSel.close();
						pstmtSel = null;
					}
				}
				//else if(detail[2].trim().equalsIgnoreCase("") || Integer.parseInt(detail[2]) <= 0)	// if Quantity is zero
				else if(detail[2].trim().equalsIgnoreCase("") || Double.parseDouble(detail[2]) <= 0)//Changed by wasim on 09-03-2017 for parsing		
				{
					//sql = "DELETE FROM PORDDET_TEMP WHERE PURC_ORDER = ? AND ITEM_CODE = ? ";
					sql = " DELETE FROM PORDDET_TEMP WHERE PURC_ORDER = ? AND ITEM_CODE = ? AND TAB_NO = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrderFrmHdr);		// PURC_ORDER
					pstmt.setString(2, detail[1]);				// ITEM_CODE
					pstmt.setString(3, detail[8]);	
					pstmt.executeUpdate();
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			catch (Exception e)
			{
				System.out.println("Inside catchs savePorderDetail"+e.getMessage());
				e.printStackTrace();
				isError = true;
			}
			finally
			{
				try
				{
					System.out.println("isError="+isError);
					if(isError)
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
					if (rsSel != null) 
					{					
						rsSel.close();
						rsSel = null;
					}
					if (pstmtSel != null ) 
					{					
						pstmtSel.close();
						pstmtSel = null;
					}
					if( pstmt != null )
					{
						pstmt.close();pstmt = null;
					}
					if (rs != null)
					{
						rs.close();rs = null;
					}
					if (conn != null)
					{
						conn.close();conn = null;
					}
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}
			return retStr;
		}
		
		public String validatePorder(String itemCode) throws ITMException 
		{
			String sql = "",retStr = "";
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			Connection conn = null;

			try
			{
				conn = getConnection();
				
				int count = 0;
				
				sql = " SELECT COUNT(*) FROM PORDER WHERE PURC_ORDER = ? AND CONFIRMED = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				pstmt.setString(2, "N");
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					count = rs.getInt(1);
				}
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				
				retStr = String.valueOf(count);
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
			finally
			{
				try
				{
					if( pstmt != null )
					{
						pstmt.close();pstmt = null;
					}
					if (rs != null)
					{
						rs.close();rs = null;
					}
					if (conn != null)
					{
						conn.close();conn = null;
					}
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}
			return retStr;
		}
		
		public String resetPorderHeader(String str) throws ITMException 
		{
			String sql = "",retStr = "";
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			Connection conn = null;
			
			boolean isError = false;
			try
			{
				conn = getConnection();
				
				String[] detail = str.split("~");
				
				sql = "UPDATE PORDER_TEMP SET STATUS = ? WHERE  STATUS = ? AND EMP_CODE = ? AND SITE_CODE__ORD = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "C");				
				pstmt.setString(2, detail[2]);		
				pstmt.setString(3, detail[0]);	
				pstmt.setString(4, detail[1]);	
				pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception inside resetPorderHeader PorderWiz"+e.getMessage());
				e.printStackTrace();
				isError = true;
			}
			finally
			{
				try
				{
					if(isError)
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
					if( pstmt != null )
					{
						pstmt.close();pstmt = null;
					}
					if (rs != null)
					{
						rs.close();rs = null;
					}
					if (conn != null)
					{
						conn.close();conn = null;
					}
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}
			return retStr;
		}
		
		
		// Changed by Sneha, on 28-07-2016 for generating tran_id [Start]
		private String generateTranId( String windowName, String siteCode, Connection conn )throws ITMException
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			String selSql = "";
			String tranId = "";
			String tranSer = "";
			String keyString = "";
			String keyCol = "";
			String xmlValues = "";
			String paySiteCode = "";
			String effectiveDate = "";
			java.sql.Timestamp currDate = null;
			java.sql.Date effDate = null;
			E12GenericUtility genericUtility = new E12GenericUtility();

			try
			{

				SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());

				currDate = new java.sql.Timestamp(System.currentTimeMillis());
				String currDateStr = sdfAppl.format(currDate);

				selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";

				pstmt = conn.prepareStatement(selSql);
				pstmt.setString( 1, windowName );
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					keyString = rs.getString("KEY_STRING");
					keyCol = rs.getString("TRAN_ID_COL");
					tranSer = rs.getString("REF_SER");
				}
				rs.close();rs = null;
				pstmt.close();pstmt = null;
				System.out.println("keyString :"+keyString);
				System.out.println("keyCol :"+keyCol);
				System.out.println("tranSer :"+tranSer);

				xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<tran_id></tran_id>";
				xmlValues = xmlValues +        "<site_code>" + siteCode + "</site_code>";
				xmlValues = xmlValues +        "<tran_date>" + currDateStr + "</tran_date>";
				xmlValues = xmlValues + "</Detail1></Root>";
				System.out.println("xmlValues  :["+xmlValues+"]");
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
				System.out.println("tranId :"+tranId);
			}
			catch (SQLException ex)
			{
				System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
				ex.printStackTrace();
				throw new ITMException(ex);
			}
			catch (Exception e)
			{
				System.out.println("Exception ::" + e.getMessage() + ":");
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				catch(Exception e){}
			}
			return checkNullAndTrim(tranId);
		}
		// Changed by Sneha, on 28-07-2016 for generating tran_id [End]
		
		//Changed by Samadhan on 14/07/2015 D15CKAT026 End
		private String getSubLeadTime(String itemCode,String dlvDate,Connection conn)
		{
			String sql = "";
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			String dlvleadTime = "";
			sql = " select pur_lead_time from supplieritem where item_code = ? ";
			try
			{
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					dlvleadTime = checkNullAndTrim(rs.getString("pur_lead_time"));

					System.out.println("Pure Lead Time="+dlvleadTime);
					System.out.println("Delivery Date="+dlvDate);
					SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
					Calendar c = Calendar.getInstance();
					c.setTime(sdf.parse(dlvDate));
					c.add(Calendar.DATE, (-Integer.parseInt(dlvleadTime)));
					dlvDate = sdf.format(c.getTime());
					System.out.println("New Delivery Date--------->>"+dlvDate);
				}
			}catch (Exception e)
			{

			}
			return dlvDate;
		}
	//Changed by Samadhan on 14/07/2015 D15CKAT026 End
		//Changed by wasim to add code from servlet to EJB [START]
		
}
	

