package ibase.dashboard.sfa.ejb;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import javax.ejb.Stateless;

/**
 * Session Bean implementation class CustomerMeetingTrends
 */
@Stateless
public class CustomerMeetingTrends extends ValidatorEJB implements CustomerMeetingTrendsRemote, CustomerMeetingTrendsLocal
{
	/**
	 * Default constructor.
	 */

	String salePersn = "";
	public String getSalePersn()
	{
		return salePersn;
	}

	public void setSalePersn(String salePersn)
	{
		this.salePersn = salePersn;
	}

	public CustomerMeetingTrends()
	{

		// TODO Auto-generated constructor stub
	}

	public String getData() throws RemoteException, ITMException
	{
		return "";
	}
	

	public String getData(String loginCode) throws RemoteException, ITMException
	{
		String sql = "";
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer xmlData = null;
	
		List<String> weekList     = new ArrayList<String>();
		List<String> cyearList    = new ArrayList<String>();
		List<String> doctorList   = new ArrayList<String>();
		List<String> chemistList  = new ArrayList<String>();
		List<String> stockistList = new ArrayList<String>();
		List<String> unlistedList = new ArrayList<String>();
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;

			sql = "select sp.sales_pers, sp.sp_name, sp.year, sp.week, Sum(Case When Strg_Meet.Strg_Type = 'D' and Strg_Meet.Strg_Code Not Like 'UL%'  then 1 Else 0 End) as Doctors, Sum(Case When Strg_Meet.Strg_Type = 'C' and Strg_Meet.Strg_Code Not Like 'UL%'  then 1 Else 0 End) as Chemist, Sum(Case When Strg_Meet.Strg_Type = 'S' and Strg_Meet.Strg_Code Not Like 'UL%'  then 1 Else 0 End) as STockist, Sum(Case When Strg_Meet.Strg_Type = 'D' and Strg_Meet.Strg_Code Like 'UL%'  then 1 Else 0 End) as Unlisted from ( select sales_pers, SP_NAME, Dt, to_char(dt,'WW') as Week, month_no AS Month, TO_CHAR(DT,'MON') as Month_Mon, year from sales_pers cross join sfa_time where sales_pers =? and Sfa_time.dt >= (trunc(sysdate,'WW')+6)-41 and Sfa_time.dt <= to_Date(sysdate) ) sp left Join strg_meet on strg_meet.sales_pers=sp.sales_pers and strg_meet.event_date = sp.dt Group by sp.sales_pers, sp.sp_name, sp.year, sp.week Order by Year asc , Week asc";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginCode);
			rs = pstmt.executeQuery();
			
			xmlData = new StringBuffer("<?xml version='1.0'?> <Root>");
			
			while (rs.next())
			{
				cyearList.add(rs.getString(3));
				weekList.add(rs.getString(4));				
				doctorList.add(rs.getString(5));
				chemistList.add(rs.getString(6));
				stockistList.add(rs.getString(7));
				unlistedList.add(rs.getString(8));				
				
			}
			
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			/** XML String for year-week **/

			xmlData.append("<Detail1>");
			for(int i=0;i<cyearList.size();i++)
			{				
				xmlData.append("<yearweek><![CDATA[ ").append(cyearList.get(i)+"-"+weekList.get(i)).append( "]]></yearweek>");
			}
			xmlData.append("</Detail1>");			
				
			
			/** XML String for Doctors **/

			xmlData.append("<Detail2>");
			for (String doctor : doctorList)
			{				
				xmlData.append("<doctor><![CDATA[ ").append(doctor).append( "]]></doctor>");
			}
			xmlData.append("</Detail2>");	
						
			
			/** XML String for Chemist **/
			xmlData.append("<Detail3>");
			for (String chemist : chemistList)
			{
				
				xmlData.append("<chemist><![CDATA[ ").append(chemist).append( "]]></chemist>");
			}
			xmlData.append("</Detail3>");

			
			/** XML String for Stockist **/
			xmlData.append("<Detail4>");

			for (String stockist : stockistList)
			{
				
				xmlData.append("<stockist><![CDATA[ ").append(stockist).append( "]]></stockist>");
			}
			xmlData.append("</Detail4>");
			

			/** XML String for Unlisted **/
			xmlData.append("<Detail5>");
			for (String unListed : unlistedList)
			{
				
				xmlData.append("<unlisted><![CDATA[ ").append(unListed).append( "]]></unlisted>");
			}
			xmlData.append("</Detail5>");
			xmlData.append("</Root>");
			System.out.println("data xml-->[" + xmlData.toString() + "]");
			
			

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return xmlData.toString();
	}
	
	private String checkNull(String input)
	{
		System.out.print("in check null method =" + input);

		if (input == null)
		{
			input = "";
		} else
		{
			input = input.trim();
		}
		return input;
	}

}
