package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class AttdDayDetEJB
 */
/**
 * This class perform validation and itemchange on Attendance Day Detail option
 * 
 * @author Ahmed
 *
 */
@Stateless
public class AttdDayDetEJB extends ValidatorEJB implements AttdDayDetEJBRemote, AttdDayDetEJBLocal 
{
	public String itemChanged() throws RemoteException, ITMException 
	{
		// TODO Auto-generated method stub
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		// TODO Auto-generated method stub
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";

		try 
		{
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) 
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) 
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : AttdDayDetEJB : [itemChanged(String,String)] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		// TODO Auto-generated method stub
		//GenericUtility genericUtility = null;
		Connection conn = null;
		int currentFormNo = 0;

		ResultSet rs = null;
		String query = "";
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString;
		String loginEmpCode = "";
		String loginCode = "";
		String chgTerm = "";
		String empSite = "";
		String empName = "";
		SimpleDateFormat simpleDateFormat = null;
		java.util.Date currDate = new java.util.Date();
		String attdDate = "";
		String inTime = "";
		String outTime = "";
		String workShift = "";//Modified By Ahmed on [17-06-2016] [A15IBAS001] [To get value of employee workshift ]
		try 
		{
			valueXmlString = new StringBuffer();
			//genericUtility = GenericUtility.getInstance();
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			valueXmlString = new StringBuffer(
					"<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			switch (currentFormNo) 
			{
				case 1:
					valueXmlString.append("<Detail1>");									
					if(currentColumn.trim().equalsIgnoreCase("itm_default")) 
					{
						loginEmpCode = checkNull(getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
						loginCode = checkNull(getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
						chgTerm = checkNull(getValueFromXTRA_PARAMS(xtraParams, "chgTerm"));
						query = " select emp_site, FN_GET_EMP_NAME(?,'X') as emp_name from employee where emp_code = ? ";
						pstmt = conn.prepareStatement(query);
						pstmt.setString(1, loginEmpCode);
						pstmt.setString(2, loginEmpCode);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							empSite = checkNull(rs.getString("emp_site"));
							empName = checkNull(rs.getString("emp_name"));
						}
						if (rs != null) 
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
						
						simpleDateFormat = new SimpleDateFormat(getApplDateFormat());
						attdDate = simpleDateFormat.format(currDate);
						System.out.println("currDate ::"+currDate);
						System.out.println("attdDate ::"+attdDate);
						inTime = "00:00";
						outTime = "00:00";
						//Modified By Ahmed on [17-06-2016] [A15IBAS001] [To get value of employee workshift ] [Start]
						workShift = checkNull(getWorkShift(loginEmpCode, attdDate, conn));
						//Modified By Ahmed on [17-06-2016] [A15IBAS001] [To get value of employee workshift ] [End]
						valueXmlString.append("<attd_date protect='1'>").append("<![CDATA[" + attdDate + "]]>").append("</attd_date>\r\n");
						valueXmlString.append("<emp_code protect='1'>").append("<![CDATA[" + loginEmpCode + "]]>").append("</emp_code>\r\n");
						valueXmlString.append("<emp_name protect='1'>").append("<![CDATA[" + empName + "]]>").append("</emp_name>\r\n");
						valueXmlString.append("<in_time>").append("<![CDATA[" + inTime + "]]>").append("</in_time>\r\n");
						valueXmlString.append("<out_time>").append("<![CDATA[" + outTime + "]]>").append("</out_time>\r\n");
						valueXmlString.append("<emp_site protect='1'>").append("<![CDATA[" + empSite + "]]>").append("</emp_site>\r\n");
						valueXmlString.append("<status>").append("<![CDATA[U]]>").append("</status>\r\n");
						//Modified by Sana on [20/05/16][A15IBAS001][To handle primary key issue from metadata][Start]
						/* valueXmlString.append("<chg_date protect='1'>").append("<![CDATA[" + attdDate + "]]>").append("</chg_date>\r\n");
						valueXmlString.append("<chg_user protect='1'>").append("<![CDATA[" + loginCode + "]]>").append("</chg_user>\r\n");
						valueXmlString.append("<chg_term protect='1'>").append("<![CDATA[" + chgTerm + "]]>").append("</chg_term>\r\n"); */
						valueXmlString.append("<attd_date_emp protect='1'>").append("<![CDATA[" + attdDate + "]]>").append("</attd_date_emp>\r\n");
						valueXmlString.append("<emp_code_attd protect='1'>").append("<![CDATA[" + loginEmpCode + "]]>").append("</emp_code_attd>\r\n");
						//Modified by Sana on [20/05/16][A15IBAS001][To handle primary key issue from metadata][End]
						//Modified By Ahmed on [17-06-2016] [A15IBAS001] [To set value of employee workshift ] [Start]
						valueXmlString.append("<shift protect='1'>").append("<![CDATA[" + workShift + "]]>").append("</shift>\r\n");
						//Modified By Ahmed on [17-06-2016] [A15IBAS001] [To set value of employee workshift ] [End]
					}
					//Modified By Ahmed on [17-06-2016] [A15IBAS001] [To set value of employee workshift in edit mode] [Start]
					if (currentColumn.equalsIgnoreCase("itm_defaultedit"))
					{
						loginEmpCode = checkNull(getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
						attdDate = checkNull(getColumnValue("attd_date", dom));
						System.out.println("attdDate ::"+attdDate);
						workShift = checkNull(getWorkShift(loginEmpCode, attdDate, conn));
						System.out.println("workShift ::"+workShift);
						valueXmlString.append("<shift protect='1'>").append("<![CDATA[" + workShift + "]]>").append("</shift>\r\n");
					}
					//Modified By Ahmed on [17-06-2016] [A15IBAS001] [To set value of employee workshift in edit mode] [End]

					/*else if(currentColumn.trim().equalsIgnoreCase("emp_code"))
					{
						query = " select FN_GET_EMP_NAME(?,'X') as emp_name from dual ";
						pstmt = conn.prepareStatement(query);
						pstmt.setString(1, loginEmpCode);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							empName = checkNull(rs.getString("emp_name"));
						}
						if (rs != null) 
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<emp_name protect=\"1\">").append("<![CDATA[" + empName + "]]>").append("</emp_name>\r\n");
					}*/
					valueXmlString.append("</Detail1>");
					break;
				}
				valueXmlString.append("</Root>");
			} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} 
		finally 
		{
			try 
			{
				//Modified By Ahmed on [17-06-2016][To close and handle resultset and prepared statement][START]
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				//Modified By Ahmed on [17-06-2016][To close and handle resultset and prepared statement][END]
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			} catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		System.out.println("valueXmlString:::::" + valueXmlString.toString());
		return valueXmlString.toString();
	}

	public String wfValData() throws RemoteException, ITMException 
	{
		// TODO Auto-generated method stub
		return "";
	}


	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		// TODO Auto-generated method stub
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		//Modified By Ahmed on [17-06-2016] [A15IBAS001] [Replaced GenericUtility since it will be deprecated][START]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Ahmed on [17-06-2016] [A15IBAS001] [Replaced GenericUtility since it will be deprecated][END]
		try 
		{
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) 
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) 
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : FinEntAcctPrd : wfValData(String xmlString) : ==>" + e.getMessage());
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);//Modified By Ahmed on [17-06-2016] [A15IBAS001] [Thrown ITMException in case there is exception]
		}
		return errString;
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		// TODO Auto-generated method stub
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo = 0, childNodeListLength = 0;
		String userId = "";
		String childNodeName = null;
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String query = "";
		SimpleDateFormat simpleDateTimeFormat = null;
		java.sql.Timestamp attdDateTime = null;
		String attdDate = "";
		String inTime = "";
		String outTime = "";
		String custName = "";
		int rowCount = 0;
		String empCode = "";
		java.util.Date inTimeFormat = null;
		java.util.Date outTimeFormat = null;
		
		String msgType = "";
		
		//Modified By Ahmed on [17-06-2016] [A15IBAS001] [Replaced GenericUtility since it will be deprecated][START]
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new E12GenericUtility();
		//Modified By Ahmed on [17-06-2016] [A15IBAS001] [Replaced GenericUtility since it will be deprecated][END]

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			simpleDateTimeFormat = new SimpleDateFormat("hh:mm");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) 
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for (int ctr = 0; ctr < childNodeListLength; ctr++) 
					{
						childNode = childNodeList.item(ctr);
						if (childNode.getNodeType() != Node.ELEMENT_NODE) 
						{
							continue;
						}
						childNodeName = childNode.getNodeName();

						System.out.println("childNodeName.editFlag." + childNodeName + ".." + editFlag);
						rowCount = 0;
						
						if (childNodeName.equalsIgnoreCase("attd_date")) 
						{
							attdDate = checkNull(genericUtility.getColumnValue("attd_date", dom));
							attdDateTime = java.sql.Timestamp.valueOf((genericUtility.getValidDateTimeString(attdDate, genericUtility.getApplDateTimeFormat(), genericUtility.getDBDateTimeFormat())));
							empCode = checkNull(genericUtility.getColumnValue("emp_code", dom));
							if("A".equalsIgnoreCase(editFlag))
							{
								query = " select count(1) as row_count from attendance_day where attd_date = ? and emp_code = ?";
								pstmt = conn.prepareStatement(query);
								pstmt.setTimestamp(1, attdDateTime);
								pstmt.setString(2, empCode);
								rs = pstmt.executeQuery();
								if (rs.next()) 
								{
									rowCount = rs.getInt("row_count");
								}
								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}
								if(rowCount > 0)
								{
									System.out.println("duplicate for attd_date");
									errList.add("VMATTDET07");
									errFields.add(childNodeName.toLowerCase());
	
									msgType = errorType(conn, "VMATTDET07");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
							}
							query = " select fn_check_attd_month_prd(?,?) as attd_month_process from dual ";
							pstmt = conn.prepareStatement(query);
							pstmt.setTimestamp(1, attdDateTime);
							pstmt.setString(2, empCode);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								rowCount = rs.getInt("attd_month_process");
							}
							if (rs != null) 
							{
								rs.close();
								rs = null;
							}
							if (pstmt != null) 
							{
								pstmt.close();
								pstmt = null;
							}
							if(rowCount > 0)
							{
								System.out.println("attd_month_process");
								errList.add("VMATTDET08");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMATTDET08");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
						}
						if (childNodeName.equalsIgnoreCase("punch_str")) 
						{
							custName = checkNull(genericUtility.getColumnValue("punch_str", dom));
							if (custName == null || custName.trim().length() == 0) 
							{
								System.out.println("punch_str is null");
								errList.add("VMATTDET01");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMATTDET01");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("in_time")) 
						{
							inTime = checkNull(genericUtility.getColumnValue("in_time", dom));
							attdDate = checkNull(genericUtility.getColumnValue("attd_date", dom));
							if (inTime == null || inTime.trim().length() == 0) 
							{
								System.out.println("in_time is null");
								errList.add("VMATTDET02");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMATTDET02");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
							else
							{
								try
								{
									inTimeFormat = simpleDateTimeFormat.parse(inTime);
								}
								catch(Exception e)
								{
									System.out.println("in_time is invalid");
									errList.add("VMATTDET03");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMATTDET03");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
								if(inTime.equalsIgnoreCase("00:00"))
								{
									System.out.println("in_time is 00:00");
									errList.add("VMATTDET02");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMATTDET02");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
								if(inTime.length()!=5)
								{
									System.out.println("VMATTDET03 1 ");
									System.out.println("in_time is invalid");
									errList.add("VMATTDET03");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMATTDET03");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
								else
								{
									System.out.println("In char : "+inTime.charAt(2));
									System.out.println("In int : "+(int)inTime.charAt(2));
									System.out.println("In char : "+inTime.charAt(1));
									System.out.println("In int : "+(int)inTime.charAt(1));
									if(inTime.charAt(2) != ':')
									{
										System.out.println("VMATTDET03 2 ");
										System.out.println("in_time is invalid");
										errList.add("VMATTDET03");
										errFields.add(childNodeName.toLowerCase());

										msgType = errorType(conn, "VMATTDET03");
										if (msgType.equalsIgnoreCase("E")) 
										{
											break;
										}
									}
									if( ((int)inTime.charAt(1) < 48 || (int)inTime.charAt(1) > 57) || ((int)inTime.charAt(4) < 48 || (int)inTime.charAt(4) > 57) )
									{
										System.out.println("VMATTDET03 3 ");
										System.out.println("in_time is invalid");
										errList.add("VMATTDET03");
										errFields.add(childNodeName.toLowerCase());

										msgType = errorType(conn, "VMATTDET03");
										if (msgType.equalsIgnoreCase("E")) 
										{
											break;
										}
									}
									if((int)inTime.charAt(3) < 48 || (int)inTime.charAt(3) > 53)
									{
										System.out.println("VMATTDET03 4 ");
										System.out.println("in_time is invalid");
										errList.add("VMATTDET03");
										errFields.add(childNodeName.toLowerCase());

										msgType = errorType(conn, "VMATTDET03");
										if (msgType.equalsIgnoreCase("E")) 
										{
											break;
										}
									}
									if((int)inTime.charAt(0) < 48 || (int)inTime.charAt(0) > 50 || ( (int)inTime.charAt(0) == 50 && (int)inTime.charAt(1) > 51 ) )
									{
										System.out.println("VMATTDET03 5 ");
										System.out.println("in_time is invalid");
										errList.add("VMATTDET03");
										errFields.add(childNodeName.toLowerCase());

										msgType = errorType(conn, "VMATTDET03");
										if (msgType.equalsIgnoreCase("E")) 
										{
											break;
										}
									}
								}
								
							}
						}
						else if (childNodeName.equalsIgnoreCase("out_time")) 
						{
							inTime = checkNull(genericUtility.getColumnValue("in_time", dom));
							outTime = checkNull(genericUtility.getColumnValue("out_time", dom));
						//Modified by Sana on [01/04/2016][A15IBAS001][To ignore validation if out time is blank][Start]
						/* if (outTime == null || outTime.trim().length() == 0) 
							{
								System.out.println("out_time is null");
								errList.add("VMATTDET04");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMATTDET04");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							} 
							else
						 */
						if(outTime != null && outTime.trim().length() > 0)
						{
							try
							{
								inTimeFormat = simpleDateTimeFormat.parse(inTime);
							}
							catch(Exception e)
							{
								System.out.println("in_time is invalid");
								errList.add("VMATTDET03");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMATTDET03");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
							try
							{
								outTimeFormat = simpleDateTimeFormat.parse(outTime);
							}
							catch(Exception e)
							{
								System.out.println("out_time is invalid");
								errList.add("VMATTDET05");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMATTDET05");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
							
						//Modified by Sana on [01/04/2016][A15IBAS001][To ignore validation if out time is blank][Start]
						/* if(outTime.equalsIgnoreCase("00:00"))
							{
								System.out.println("out_time is 00:00");
								errList.add("VMATTDET04");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMATTDET04");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							} */
						//Modified by Sana on [01/04/2016][A15IBAS001][To ignore validation if out time is blank][End]

							if(outTime.length()!=5)
							{
								System.out.println("VMATTDET05 1 ");
								System.out.println("in_time is invalid");
								errList.add("VMATTDET05");
								errFields.add(childNodeName.toLowerCase());
	
								msgType = errorType(conn, "VMATTDET05");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
							else
							{
								System.out.println("In char : "+outTime.charAt(2));
								System.out.println("In int : "+(int)outTime.charAt(2));
								System.out.println("In char : "+outTime.charAt(1));
								System.out.println("In int : "+(int)outTime.charAt(1));
								if(outTime.charAt(2) != ':')
								{
									System.out.println("VMATTDET05 2 ");
									System.out.println("in_time is invalid");
									errList.add("VMATTDET05");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMATTDET05");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
								if( ((int)outTime.charAt(1) < 48 || (int)outTime.charAt(1) > 57) || ((int)outTime.charAt(4) < 48 || (int)outTime.charAt(4) > 57) )
								{
									System.out.println("VMATTDET05 3 ");
									System.out.println("in_time is invalid");
									errList.add("VMATTDET05");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMATTDET05");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
								if((int)outTime.charAt(3) < 48 || (int)outTime.charAt(3) > 53)
								{
									System.out.println("VMATTDET05 4 ");
									System.out.println("in_time is invalid");
									errList.add("VMATTDET05");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMATTDET05");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
								if((int)outTime.charAt(0) < 48 || (int)outTime.charAt(0) > 50 || ( (int)outTime.charAt(0) == 50 && (int)outTime.charAt(1) > 51 ) )
								{
									System.out.println("VMATTDET05 5 ");
									System.out.println("in_time is invalid");
									errList.add("VMATTDET05");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMATTDET05");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
							}
							//Modified by Sana on [01/04/2016][A15IBAS001][To ignore validation if out time is blank][Start]
							if(outTime != null && outTime.trim().length() > 0 && !("00:00").equalsIgnoreCase(outTime))
							{
							//Modified by Sana on [01/04/2016][A15IBAS001][To ignore validation if out time is blank][End]
								if(inTimeFormat.compareTo(outTimeFormat) >= 0) 
								{
									errList.add("VMATTDET06");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMATTDET06");
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
				}
				break;
			}

			int errListSize = errList.size();
			StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");

			if (errList != null && errListSize > 0) 
			{
				for (int cnt = 0; cnt < errListSize; cnt++) 
				{
					String errCode = (String) errList.get(cnt);
					String errFldName = (String) errFields.get(cnt);
					System.out.println("errCode .........." + errCode);

					errString = getErrorString(errFldName, errCode, userId);
					System.out.println("errString is : ::::>>>> " + errString);
					msgType = errorType(conn, errCode);
					if (errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........." + errStringXml);
						errString = "";
					}
					if (msgType.equalsIgnoreCase("E")) 
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			} 
			else 
			{
				errStringXml = new StringBuffer("");
			}
			errString = errStringXml.toString();
		} 
		
		catch (Exception e) 
		{
			System.out.println("Exception ::" + e);
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		} 
		finally 
		{
			try 
			{
				//Modified By Ahmed on [17-06-2016][To close and handle resultset and prepared statement][START]
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				//Modified By Ahmed on [17-06-2016][To close and handle resultset and prepared statement][END]
				if (conn != null) 
				{
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d) 
			{
				d.printStackTrace();
			}
		}
		System.out.println("ErrString ::" + errString);
		return errString;
	}

	private String errorType(Connection conn, String errorCode) throws ITMException 
	{
		// TODO Auto-generated method stub
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				msgType = rs.getString("MSG_TYPE");
			}
		} 
		catch (Exception ex) 
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
	private String checkNull(String input) 
	{
		// TODO Auto-generated method stub
		if (input == null) 
		{
			input = "";
		} 
		else 
		{
			input = input.trim();
		}
		return input;
	}
	
	//Modified by Ahmed on 17/06/2016[To get value of employee workshift][START]
	private String getWorkShift(String empCode, String attdDate, Connection conn) throws ITMException
	{
		String sql = "", shift = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			Timestamp attdDateTimeStamp = Timestamp.valueOf(genericUtility.getValidDateTimeString(attdDate, getApplDateFormat(), getDBDateFormat()));
			sql = " SELECT SHIFT FROM WORK_SHIFT WHERE EMP_CODE = ? AND FROM_DT <= ? AND TO_DT >= ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, empCode );
			pstmt.setTimestamp( 2, attdDateTimeStamp );
			pstmt.setTimestamp( 3, attdDateTimeStamp );
			rs = pstmt.executeQuery();
			if( rs.next() ) 
			{
				shift = checkNull( rs.getString( "SHIFT" ) );
			}
			if( rs != null ) 
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null ) 
			{
				pstmt.close();
				pstmt = null;
			}
			if( shift == null || shift.trim().length() == 0 )
			{
				sql = "";
				sql = " SELECT WORK_SHIFT FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString( 1, empCode );
				rs = pstmt.executeQuery();
				if( rs.next() ) 
				{
					shift = checkNull(rs.getString("WORK_SHIFT"));
				}
				if( rs != null ) 
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null ) 
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null ) 
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null ) 
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return shift;
	}
	//Modified by Ahmed on 17/06/2016[To get value of employee workshift][END]
}
