--- Department Master - Request ID: A15FSUN004 - CCF No.: IT2015-82F.Start ---
ALTER TABLE DEPARTMENT ADD (DEPT_CODE__PARENT CHAR(5));
ALTER TABLE DEPARTMENT ADD (BU_CODE CHAR(5));
ALTER TABLE DEPARTMENT ADD (FUNC_CODE CHAR(5));
ALTER TABLE DEPARTMENT ADD (EMP_CODE__FUNCHEAD CHAR(10));


CREATE OR REPLACE FUNCTION FN_GET_BUCODE_DESCR(as_bu_code char)  
return varchar2 is ls_descr varchar2(120);
begin
	begin  
		select descr into ls_descr  from  BUSINESS_UNITS   
		where bu_code = as_bu_code;  
	exception  
	  when no_data_found then  
		ls_descr := null;  
	end;  
	return ls_descr;  
end;
/

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'dept',
	'1',
	'descr',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'dept',
	'1',
	'dept_code',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'dept',
	'1',
	'dept_code__parent',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'dept',
	'1',
	'bu_code',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'dept',
	'1',
	'func_code',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'dept',
	'1',
	'emp_code__head',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'dept',
	'1',
	'emp_code__funchead',
	'Y'
);

COMMIT;

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMDEPTPD01',
	'Invalid Parent Department!',
	'Specified parent department is not defined in system, please either first define the same or specify another one which is already defined',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMDEPTPD02',
	'Recursive Parent Department!',
	'Specified parent department is recursively used which establish cyclic relation, please specify another one',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMDEPTPD03',
	'Empty Parent Department!',
	'Parent department code cannot be null or empty, please specify parent department',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMDEPTBU01',
	'Invalid Business Unit!',
	'Specified business unit is not defined in system, please either first define the same or specify another one which is already defined',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMDEPTFU01',
	'Invalid Function Code!',
	'Specified function code is not defined in system, please either first define the same or specify another one which is already defined',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMDEPTFH01',
	'Invalid Function Head!',
	'Specified code of function head not existing in system, please specify another function head who is existing in system',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMDEPTFH02',
	'Function Head is Separated!',
	'Specified function head is already separated, please specify another function head who is not separated',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMDEPTFH03',
	'Function Head is Relieved!',
	'Specified function head is already relieved, please specify another function head who is not relieved',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

COMMIT;

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'DEPT_CODE__PARENT',
	'W_DEPT',
	'SELECT DEPT_CODE AS Code, DESCR AS Description FROM DEPARTMENT',
	'DEPARTMENT LIST',
	0,
	0,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	1,
	1
);

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'BU_CODE',
	'W_DEPT',
	'SELECT BU_CODE AS CODE, DESCR AS Description FROM BUSINESS_UNITS',
	'BUSINESS UNITS',
	0,
	0,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	1,
	1
);

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'FUNC_CODE',
	'W_DEPT',
	'SELECT FUNC_CODE AS CODE, DESCR AS Description FROM BUSI_FUNCTIONS',
	'BUSINESS FUNCTIONS',
	0,
	0,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	1,
	1
);

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'EMP_CODE__FUNCHEAD',
	'W_DEPT',
	'SELECT EMP_CODE AS Code, TRIM(EMP_FNAME) || '' '' || TRIM(EMP_MNAME) || '' '' || TRIM(EMP_LNAME) FROM EMPLOYEE WHERE CASE WHEN STATUS IS NULL THEN '' '' ELSE STATUS END <> ''S'' AND (RELIEVE_DATE IS NULL OR TRUNC(RELIEVE_DATE) > TRUNC(SYSDATE)) AND LENGTH(TRIM(''?'')) >= 3 AND (EMP_FNAME LIKE ''%'' || TRIM(?) || ''%'' OR EMP_MNAME LIKE ''%'' TRIM(?) || ''%'' OR EMP_LNAME LIKE ''%'' || TRIM(?) || ''%'')',
	'EMPLOYEE LIST',
	0,
	0,
	fn_sysdate(),
	'BASE',
	'BASE',
	':emp_code__funchead,:emp_code__funchead,:emp_code__funchead,:emp_code__funchead',
	1,
	1
);

COMMIT;

--- Department Master - Request ID: A15FSUN004 - CCF No.: IT2015-82F.End ---
