SET DEFINE OFF


ALTER TABLE EMPLOYEE ADD MOTHER_TONGUE VARCHAR2(10);
ALTER TABLE EMPLOYEE ADD CAST_CATEGORY CHAR(5);
ALTER TABLE EMPLOYEE ADD COUNT_CODE__BIRTH CHAR(5);
ALTER TABLE EMPLOYEE ADD JOB_TITLE VARCHAR2(200);
ALTER TABLE EMPLOYEE ADD EMP_ID_EXTERNAL VARCHAR2(20);

ALTER TABLE EMPQUAL ADD COURSE_TYPE CHAR(5);
ALTER TABLE EMPQUAL ADD COURSE_DURATION NUMBER(3);
ALTER TABLE EMPQUAL ADD COUNT_CODE__QUAL CHAR(5);

ALTER TABLE EMPEXPERIENCE ADD COUNT_CODE__WORK CHAR(5);

ALTER TABLE EMPLOYEE_DET_CHANGE ADD MOTHER_TONGUE__O VARCHAR2(10);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD MOTHER_TONGUE VARCHAR2(10);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD CAST_CATEGORY__O CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD CAST_CATEGORY CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD COUNT_CODE__BIRTH_O CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD COUNT_CODE__BIRTH CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD JOB_TITLE_O VARCHAR2(200);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD JOB_TITLE VARCHAR2(200);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_ID_EXTERNAL_O VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_ID_EXTERNAL VARCHAR2(20);

CREATE OR REPLACE FUNCTION FN_GET_COUNT_DESCR(AS_COUNT_CODE In CHAR) 
RETURN VARCHAR2 IS COUNT_DESCR VARCHAR2(200);

BEGIN
	COUNT_DESCR := ''; 
	BEGIN
	SELECT DESCR INTO COUNT_DESCR  FROM COUNTRY WHERE COUNT_CODE = AS_COUNT_CODE;
		EXCEPTION WHEN NO_DATA_FOUND THEN 
		COUNT_DESCR := ''; 
	END;
	RETURN COUNT_DESCR;
END;
/

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_complete',
	'1',
	'mother_tongue',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_complete',
	'1',
	'cast_category',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_complete',
	'1',
	'count_code__birth',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_complete',
	'4',
	'course_type',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_complete',
	'4',
	'count_code__qual',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_complete',
	'4',
	'course_duration',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_complete',
	'6',
	'count_code__work',
	'Y'
);

COMMIT;

INSERT INTO GENMST 
(
	FLD_NAME,
	MOD_NAME,
	DESCR,
	ERROR_CD,
	BLANK_OPT,
	FLD_TYPE,
	FLD_MIN,
	FLD_MAX,
	VAL_TYPE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	FORM_NO
)
VALUES 
(
	'RELIGION',
	'W_EMP_COMPLETE',
	'Religion validation against gencodes',
	'GVRELIG001',
	'Y',
	'C',
	NULL,
	NULL,
	'M',
	SYSDATE,
	'BASE',
	'BASE',
	'1'
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'GVRELIG001',
	'Blank or undefined religion!',
	'Please enter religion which is defined in system',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPBCNT2',
	'Invalid Country of Birth!',
	'Entered Country of Birth is not existing in system Please enter Country of Birth which is already defined in system',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPMLNG2',
	'Invalid Primary Language!',
	'Entered Primary Language is not existing in system Please enter Primary Language which is already defined in system',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPCCTG2',
	'Invalid Cast Category!',
	'Entered Cast Category is not existing in system Please enter Cast Category which is already defined in system',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPQLF02',
	'Invalid Country of Qualification!',
	'Entered Country of Qualification is not existing in system Please enter Country of Qualification which is already defined in system',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPQLF03',
	'Invalid Course Tyoe!',
	'Entered Course Type is not existing in system Please enter Course Type which is already defined in system',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPQLF04',
	'Course Duration Zero!',
	'Course Duration can not be empty, Please enter 0 or grater than 0 in Course Duration',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPQLF05',
	'Negative Course Duration!',
	'Course Duration can not be less than 0, Please enter 0 or grater than 0 in Course Duration',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPEXP04',
	'Invalid Country of Work!',
	'Entered Country of Work is not existing in system Please enter Country of Work which is already defined in system',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	NULL
);


COMMIT;

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'RELIGION',
	'X',
	'SELECT FLD_VALUE AS Religion FROM GENCODES WHERE FLD_NAME=''RELIGION'' AND MOD_NAME IN (''W_EMP_COMPLETE'',''X'') AND CASE WHEN ACTIVE IS NULL THEN ''Y'' ELSE ACTIVE END = ''Y'' ORDER BY FLD_VALUE',
	'Religion',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	1,
	1
);

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'MOTHER_TONGUE',
	'X',
	'SELECT FLD_VALUE AS Language FROM GENCODES WHERE FLD_NAME=''LANGUAGE'' AND MOD_NAME IN (''W_EMP_COMPLETE'',''X'') AND CASE WHEN ACTIVE IS NULL THEN ''Y'' ELSE ACTIVE END = ''Y''  ORDER BY FLD_VALUE',
	'Language',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	1,
	1
);

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'CAST_CATEGORY',
	'X',
	'SELECT FLD_VALUE AS Cast_Category,DESCR AS Description FROM GENCODES WHERE FLD_NAME=''CAST_CATEGORY'' AND MOD_NAME IN (''W_EMP_COMPLETE'',''X'') AND CASE WHEN ACTIVE IS NULL THEN ''Y'' ELSE ACTIVE END = ''Y''  ORDER BY FLD_VALUE',
	'Cast Category',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	1,
	1
);

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION,
	AUTO_FILL_LEN
)
VALUES
(
	'COUNT_CODE',
	'X',
	'SELECT COUNT_CODE AS Country_Code, DESCR AS Country_Name FROM COUNTRY ORDER BY DESCR',
	'Country',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	1,
	1,
	'3'
);

COMMIT;

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION,
	AUTO_FILL_LEN
)
VALUES
(
	'COUNT_CODE__BIRTH',
	'X',
	'SELECT COUNT_CODE AS Country_Code, DESCR AS Country_Name FROM COUNTRY ORDER BY DESCR',
	'Country',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	1,
	1,
	'3'
);

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION,
	AUTO_FILL_LEN
)
VALUES
(
	'COUNT_CODE__QUAL',
	'X',
	'SELECT COUNT_CODE AS Country_Code, DESCR AS Country_Name FROM COUNTRY ORDER BY DESCR',
	'Country',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	1,
	1,
	'3'
);

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION,
	AUTO_FILL_LEN
)
VALUES
(
	'COUNT_CODE__WORK',
	'X',
	'SELECT COUNT_CODE AS Country_Code, DESCR AS Country_Name FROM COUNTRY ORDER BY DESCR',
	'Country',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	1,
	1,
	'3'
);

COMMIT;

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_det_chg',
	'1',
	'mother_tongue',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_det_chg',
	'1',
	'cast_category',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_det_chg',
	'1',
	'count_code__birth',
	'Y'
);

COMMIT;


INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'CAST_CATEGORY',
	'W_EMP_COMPLETE',
	'ST   ',
	'Schedule Tribes',
	'ST',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	NULL,
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'CAST_CATEGORY',
	'W_EMP_COMPLETE',
	'SC   ',
	'Schedule Cast',
	'SC',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	NULL,
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'CAST_CATEGORY',
	'W_EMP_COMPLETE',
	'OBC  ',
	'OBC',
	'OBC',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	NULL,
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'CAST_CATEGORY',
	'W_EMP_COMPLETE',
	'OPEN ',
	'Open - General Category',
	'OPEN',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	NULL,
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'COURSE_TYPE',
	'W_EMP_COMPLETE',
	'FULLT',
	'Full Time Course',
	'Full Time',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	NULL,
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'COURSE_TYPE',
	'W_EMP_COMPLETE',
	'PARTT',
	'Part Time Course',
	'Part Time',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	NULL,
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'COURSE_TYPE',
	'W_EMP_COMPLETE',
	'DISTL',
	'DIstance Learning',
	'DIstance',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	NULL,
	NULL,
	NULL
);

INSERT INTO GENCODES 
(
	FLD_NAME ,
	MOD_NAME ,
	FLD_VALUE ,
	DESCR ,
	SH_DESCR ,
	CHG_DATE ,
	CHG_USER ,
	CHG_TERM ,
	ACTIVE ,
	UDF_STR1 ,
	UDF_STR2 ,
	UDF_STR3 
)
VALUES 
(
	'COURSE_TYPE',
	'W_EMP_COMPLETE',
	'CORSP',
	'Correspondence Course',
	'Correspondence',
	SYSDATE,
	'BASE',
	'BASE',
	'Y',
	NULL,
	NULL,
	NULL
);


COMMIT;

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'COURSE_TYPE',
	'X',
	'SELECT FLD_VALUE AS Course_Type,DESCR AS Description FROM GENCODES WHERE FLD_NAME=''COURSE_TYPE'' AND MOD_NAME IN (''W_EMP_COMPLETE'',''X'') AND CASE WHEN ACTIVE IS NULL THEN ''Y'' ELSE ACTIVE END = ''Y''  ORDER BY FLD_VALUE',
	'Cast Category',
	0,
	0,
	SYSDATE,
	'BASE',
	'BASE',
	NULL,
	1,
	1
);

COMMIT;

UPDATE EMPQUAL SET COURSE_DURATION = 0 WHERE COURSE_DURATION IS NULL;
COMMIT;
