/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.SchemaLoader;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.processing.RawProcessor;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;

public final class RefResolver
extends RawProcessor<SchemaTree, SchemaTree> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final SchemaLoader loader;

    public RefResolver(SchemaLoader loader) {
        super("schema", "schema");
        this.loader = loader;
    }

    @Override
    public SchemaTree rawProcess(ProcessingReport report, SchemaTree input) throws ProcessingException {
        JsonNode node;
        JsonRef ref;
        LinkedHashSet refs = Sets.newLinkedHashSet();
        SchemaTree tree = input;
        while ((ref = RefResolver.nodeAsRef(node = tree.getNode())) != null) {
            JsonPointer ptr;
            if (!refs.add(ref = tree.resolve(ref))) {
                throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.refLoop")).put("schema", tree).putArgument("ref", ref).put("path", refs));
            }
            if (!tree.containsRef(ref)) {
                tree = this.loader.get(ref.getLocator());
            }
            if ((ptr = tree.matchingPointer(ref)) == null) {
                throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.danglingRef")).put("schema", tree).putArgument("ref", ref));
            }
            tree = tree.setPointer(ptr);
        }
        return tree;
    }

    private static JsonRef nodeAsRef(JsonNode node) {
        JsonNode refNode = node.path("$ref");
        if (!refNode.isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(refNode.textValue());
        }
        catch (JsonReferenceException ignored) {
            return null;
        }
    }

    public String toString() {
        return "ref resolver";
    }
}

