package ibase.webitm.servlet.gst;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.gst.GSTDataSubmitWizEJB;
import ibase.webitm.ejb.gst.GSTDataSubmitWizEJBRemote;
import ibase.webitm.utility.ITMException;

public class GSTDataSubmitWizServlet extends HttpServlet 
{
	private static final long serialVersionUID = 1L;
	InitialContext ctx = null;
	E12GenericUtility e12GenericUtility = new E12GenericUtility();

    public GSTDataSubmitWizServlet() {
        super();
    }

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		doPost( request, response );
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ GSTDataSubmitWizServlet START]XXXXXXXXXXXXXXXXXXXX");
		request.setCharacterEncoding(CommonConstants.ENCODING);
		String action = "", responseXML = "";
		GSTDataSubmitWizEJBRemote gstDataSubmitWizRemote = null;
		
		try 
		{	
			UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
			action = request.getParameter("action");
			System.out.println("GSTDataSubmitWizServlet ACTION ["+action+"]");
			
			if("SAVE_HTML_DATA".equalsIgnoreCase(action))
			{
				String prevHTMLData = request.getParameter("HTML_DATA");
				request.getSession().setAttribute( "GST_WIZ_HTML_DATA", prevHTMLData);
			}
			else if("DISPLAY_HTML_DATA".equalsIgnoreCase(action))
			{
				String htmlDataErr = (String) request.getSession().getAttribute( "GST_WIZ_HTML_DATA");
				request.getSession().removeAttribute( "GST_WIZ_HTML_DATA");
				
				response.setContentType("text/html");
		         
		        if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(htmlDataErr.getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", CommonConstants.CONTENT_ENCODING);
					OutputStream outStream = response.getOutputStream();
					outStream.write(htmlDataErr.getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			else if("GET_OFFLINE_FILE".equalsIgnoreCase(action))
			{

				String fileName = "";
				Workbook retDataWorkbook = null;


				String prdCode = request.getParameter("prd_code");
				String recType = request.getParameter("rec_type");
				String siteCode = request.getParameter("site_code");
				
				System.out.println("siteCode ["+siteCode+"]");
				System.out.println("prdCode ["+prdCode+"]");
				System.out.println("recType ["+recType+"]");

				fileName = "GSTR"+recType+"_"+prdCode+"_Offline_Data.xlsx";

				GSTDataSubmitWizEJB gstDataSubmitWizEJB = new GSTDataSubmitWizEJB();

				Object retObj = gstDataSubmitWizEJB.generateOfflineFile(prdCode, siteCode, recType);

				if(retObj != null)
				{
					boolean isWorkbook = retObj instanceof Workbook;
					System.out.println("isWorkbook : "+ isWorkbook);

					if(retObj instanceof String)
					{
						response.setContentType( "text/html; charset=UTF8,"+CommonConstants.ENCODING );
						responseXML = (String) retObj.toString();
						System.out.println("responseXML["+responseXML+"]");
						Document errDom = e12GenericUtility.parseString(responseXML);
						String errMsg = errDom.getElementsByTagName("message").item(0).getFirstChild().getNodeValue();
						String responseStr = "<HTML><HEAD><meta http-equiv='Content-Type' content='text/html; charset=UTF-8'><SCRIPT language=JAVASCRIPT>alert('"+errMsg+"');window.location.href = '/ibase/webitm/jsp/GetGSTOfflineFile.jsp'</SCRIPT></HEAD></HTML>";

						if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
						{
							response.setHeader("Content-Encoding", "gzip");
							GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
							gzOutStream.write(responseStr.getBytes());
							gzOutStream.flush();
							gzOutStream.close();
						}
						else
						{
							response.setHeader("Content-Encoding", "");
							OutputStream outStream = response.getOutputStream();
							outStream.write(responseStr.getBytes());
							outStream.flush();
							outStream.close();
						}
					}
					else if(retObj instanceof Workbook)
					{
						retDataWorkbook = (XSSFWorkbook) retObj;
						response.setContentType("application/excel");

						if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
						{
							response.setHeader("Content-Encoding", "gzip");
							response.setHeader("Content-Disposition","attachment; fileName=\"" + fileName + "\"");
							GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
							retDataWorkbook.write(gzOutStream);
							gzOutStream.flush();
							gzOutStream.close();
						}
						else
						{
							response.setHeader("Content-Encoding", "");
							response.setHeader("Content-Disposition","attachment; fileName=\"" + fileName + "\"");
							OutputStream outStream = response.getOutputStream();
							retDataWorkbook.write(outStream);
							outStream.flush();
							outStream.close();
						}
					}
				}
			}
			else
			{
				HashMap<String,String> requestParamMap = new HashMap<String,String>();
				String paramName = "", paramValue = "";
				
				Enumeration<String> reqParams = request.getParameterNames();
				while(reqParams.hasMoreElements())
				{
					Object paramObj = reqParams.nextElement();
					paramName = (String) paramObj;
					paramValue = (String)request.getParameter(paramName);
					if(!paramValue.equalsIgnoreCase(""))
						requestParamMap.put(paramName,paramValue);
				}
				System.out.println("Request Parameter map :"+requestParamMap);
				
				ctx=getInitialContext();
				gstDataSubmitWizRemote = (ibase.webitm.ejb.gst.GSTDataSubmitWizEJBRemote) ctx.lookup("ibase/GSTDataSubmitWizEJB/remote");
				responseXML = gstDataSubmitWizRemote.handleRequest(requestParamMap, userInfo);
				
				response.setContentType("text/xml");
		         
		        if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(responseXML.getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(responseXML.getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			
		} 
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizServlet.doPost():doPost"+e.getMessage());
			e.printStackTrace();
			OutputStream out = response.getOutputStream();
			out.write(e.getMessage().getBytes());
			out.flush();
			out.close();
		}
		
         System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ GSTDataSubmitWizServlet END]XXXXXXXXXXXXXXXXXXXX");
	}
	
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("GSTDataSubmitWizServlet.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizServlet.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}
}
