package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.CurrentDayWrkSummaryRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class CurrentDaySummaryDetailServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		CurrentDayWrkSummaryRemote currencyRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String loginUser ="";
		String date = "";
		String salePerson = "";
		try
		{
			response.setContentType("application/xml");

			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) request.getSession().getAttribute("USER_INFO");
			
			if(userInfo != null)
			{
				loginUser = userInfo.getLoginCode();
			}
			
			date = request.getParameter("curDate");
			dataSourceName = request.getParameter("dataSourceName");
			salePerson = (request.getParameter("aseName"));
			System.out.println("salePerson :"+salePerson);
			System.out.println("salePerson.lenght()  :"+salePerson.length());
			if(salePerson.length()== 0)
			{
				salePerson = loginUser;
			}
			
			System.out.println("In CurrentDaySummaryServlet dataSourceName: ---- "+dataSourceName+ " ---- date :"+date+" ---- salePerson :"+salePerson);
			context = new InitialContext(appConnectParm.getProperty());
			currencyRemote = (CurrentDayWrkSummaryRemote) context.lookup("ibase/CurrentDayWrkSummary/remote");
			JSONObject jsonObjData = (JSONObject) currencyRemote.getCurrentDayWorkSummaryDetail(dataSourceName, date, salePerson);
			OutputStream outputStream   = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for CurrentDaySummaryServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : CurrentDaySummaryServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}