--------------- DDL from payroll_admin.sql.Start -------

alter table emp_employ_events add ( WORK_CTR__TO    char(10), WORK_CTR__FR char(10));
alter table emp_employ_events add ( WORK_CTR__TO    char(10));
alter table emp_employ_events add ( WORK_CTR__FR char(10));

---- function for employee holiday change.Start -----

create or replace
function fn_get_holtblno (AS_EMP_CODE char,AS_DATE date) return char is
  cursor c1 is select eff_date,conf_date,chg_date,hol_tblno__fr from emp_employ_events
    where emp_code = AS_EMP_CODE
    and eff_date > AS_DATE
    and confirmed = 'Y'
    order by emp_code,eff_date;
  a_hol_tblno employee.hol_tblno%type;
  a_eff_date date;
  a_conf_date date;
  a_chg_date date;
begin
  for i in c1
  loop
    if (i.eff_date != a_eff_date and a_eff_date is not null) then
      exit;
    end if;
    if (a_conf_date is null) then
      a_hol_tblno := i.hol_tblno__fr;
      a_conf_date := i.conf_date;
      a_chg_date := i.chg_date;
    else
      if (i.conf_date < a_conf_date) then
        a_hol_tblno := i.hol_tblno__fr;
        a_conf_date := i.conf_date;
        a_chg_date := i.chg_date;
      elsif (i.conf_date = a_conf_date) then
        if (i.chg_date < a_chg_date) then
          a_hol_tblno := i.hol_tblno__fr;
          a_chg_date := i.chg_date;
        end if;
      end if;
    end if;
    a_eff_date := i.eff_date;
  end loop;
  if (trim(a_hol_tblno) is null) then
    select hol_tblno into a_hol_tblno from employee where emp_code = AS_EMP_CODE;
  end if;
  if (trim(a_hol_tblno) is null) then
    select hol_tblno into a_hol_tblno from site where site_code = ddf_hr_status(AS_EMP_CODE,AS_DATE,'W');
  end if;
  return a_hol_tblno;
end;
/

---- function for employee holiday change.End -----


--------------- DDL from payroll_admin.sql.End -------

--------------- DDL from ADM-RCP-DDL-V2.SQL.Start -------


ALTER TABLE LEAVES ADD ALLOW_ADV_LEAVE CHAR(1);

ALTER TABLE LVETABLE ADD ALLOW_ADV_LEAVE CHAR(1);

-- K) For new table SITE_STAN_PAYTBL

CREATE TABLE SITE_STAN_PAYTBL
	(
		SITE_CODE CHAR(5) NOT NULL ,
		STATE_CODE CHAR(5) NOT NULL ,
		STAN_CODE CHAR(5) NOT NULL ,
		PAY_TABLE CHAR(5) NOT NULL ,
		CHG_DATE DATE NOT NULL,
		CHG_USER VARCHAR2(10) NOT NULL,
		CHG_TERM VARCHAR2(15) NOT NULL
	) TABLESPACE ITM_ADM_MST;

ALTER TABLE SITE_STAN_PAYTBL ADD CONSTRAINT SITE_STAN_PAYTBL_X PRIMARY KEY (SITE_CODE,STATE_CODE,STAN_CODE);
ALTER TABLE SITE_STAN_PAYTBL ADD CONSTRAINT FK_SITESTANPAYTBL_SITE FOREIGN KEY ( SITE_CODE ) REFERENCES SITE ;
ALTER TABLE SITE_STAN_PAYTBL ADD CONSTRAINT FK_SITESTANPAYTBL_STAT FOREIGN KEY ( STATE_CODE ) REFERENCES STATE;

--------------- DDL from ADM-RCP-DDL-V2.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V6.SQL.Start -------

------ Employee Period Wise Leave.Start ------

ALTER TABLE EMPLEAVE ADD ENCASH_MODE CHAR(1);
ALTER TABLE EMPLEAVE ADD PRD_CODE__PAYROLL CHAR(6);

------ Employee Period Wise Leave.End ------

------ Encasment Arrears.Start -----

ALTER TABLE EMPLEAVE_ENCH_ARR ADD PRD_CODE__PAYROLL CHAR(6);

------ Encasment Arrears.End -----

------ Employee Induction.Start ----
ALTER TABLE EMPINDUCTION ADD STATUS_DATE DATE;
ALTER TABLE EMPINDUCTION ADD STATUS CHAR(1);
------ Employee Induction.End ----

--------------- DDL from ADM-RCP-DDL-V6.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V7.SQL.Start -------


CREATE TABLE WORK_LOCATIONS 
(
	WORK_LOC_CODE	CHAR(5) NOT NULL,
	DESCR	VARCHAR2(60) NOT NULL,
	SH_DESCR	VARCHAR2(20),
	ADR1	VARCHAR2(60),
	ADR2	VARCHAR2(60),
	ADR3	VARCHAR2(60),
	CITY	VARCHAR2(20),
	PIN	VARCHAR2(15),
	STATE_CODE	CHAR(5),
	TELE1	VARCHAR2(15),
	TELE2	VARCHAR2(15),
	TELE3	VARCHAR2(15),
	ACTIVE	CHAR(1) NOT NULL,
	CHG_DATE	DATE NOT NULL,
	CHG_USER	VARCHAR2(10) NOT NULL,
	CHG_TERM	VARCHAR2(15) NOT NULL
) TABLESPACE ITM_ADM_MST;

ALTER TABLE WORK_LOCATIONS ADD ( CONSTRAINT WORK_LOCATIONS_X PRIMARY KEY(WORK_LOC_CODE) );
ALTER TABLE WORK_LOCATIONS ADD ( CONSTRAINT FK_WORK_LOCATIONS1 FOREIGN KEY ( STATE_CODE ) REFERENCES STATE ) ;

ALTER TABLE DEPARTMENT ADD DEPT_HEAD_1 CHAR(10);
ALTER TABLE DEPARTMENT ADD DEPT_TYPE VARCHAR2(10);

ALTER TABLE EMPLOYEE ADD USER_ID VARCHAR2(20);
ALTER TABLE EMPLOYEE ADD WORK_LOC_CODE CHAR(5);
ALTER TABLE EMPLOYEE ADD PARENT_DEPT CHAR(5);
ALTER TABLE EMPLOYEE ADD EXT_NO VARCHAR2(10);

ALTER TABLE EMPLOYEE ADD ( CONSTRAINT FK_EMPLOYEE1 FOREIGN KEY ( WORK_LOC_CODE ) REFERENCES WORK_LOCATIONS ) ;

ALTER TABLE EMPLOYEE_DET_CHANGE ADD (USER_ID_O	VARCHAR2(20));
ALTER TABLE EMPLOYEE_DET_CHANGE ADD (USER_ID	VARCHAR2(20));
ALTER TABLE EMPLOYEE_DET_CHANGE ADD (WORK_LOC_CODE__O	CHAR(5));
ALTER TABLE EMPLOYEE_DET_CHANGE ADD (WORK_LOC_CODE__N	CHAR(5));
ALTER TABLE EMPLOYEE_DET_CHANGE ADD (EXT_NO_O	VARCHAR2(10));
ALTER TABLE EMPLOYEE_DET_CHANGE ADD (EXT_NO_N	VARCHAR2(10));
ALTER TABLE EMPLOYEE_DET_CHANGE ADD (PARENT_DEPT__O	CHAR(5));
ALTER TABLE EMPLOYEE_DET_CHANGE ADD (PARENT_DEPT__N	CHAR(5));

ALTER TABLE EMP_EMPLOY_EVENTS ADD PARENT_DEPT__FR CHAR(5);
ALTER TABLE EMP_EMPLOY_EVENTS ADD PARENT_DEPT__TO CHAR(5);
ALTER TABLE EMP_EMPLOY_EVENTS ADD WORK_LOC_CODE__FR CHAR(5);
ALTER TABLE EMP_EMPLOY_EVENTS ADD WORK_LOC_CODE__TO CHAR(5);
ALTER TABLE EMP_EMPLOY_EVENTS ADD EXT_NO_FR VARCHAR2(10);
ALTER TABLE EMP_EMPLOY_EVENTS ADD EXT_NO_TO VARCHAR2(10);

CREATE OR REPLACE function DDF_GET_DEPT_DESCR 
 ( 
    as_dept_code char) 
return varchar2 is 
ls_descr varchar2(40); 
begin 
begin 
select descr into ls_descr 
from department 
where dept_code = as_dept_code; 
exception 
  when no_data_found then 
 ls_descr := null; 
end; 
return ls_descr; 
end;
/

CREATE SYNONYM FN_GET_DEPT_DESCR FOR DDF_GET_DEPT_DESCR;

CREATE OR REPLACE FUNCTION FN_GET_WORKLOC_DESCR(AS_WORK_LOC_CODE WORK_LOCATIONS.WORK_LOC_CODE%TYPE) 
RETURN VARCHAR2 IS LS_DESCR WORK_LOCATIONS.DESCR%TYPE; 
BEGIN
	BEGIN 
		SELECT DESCR INTO LS_DESCR FROM WORK_LOCATIONS 
			WHERE WORK_LOC_CODE = AS_WORK_LOC_CODE; 
	EXCEPTION 
		WHEN NO_DATA_FOUND THEN 
		LS_DESCR := NULL; 
	END; 
	RETURN LS_DESCR; 
END;
/



---- Function used in Shift Rotate homre page data fetching.Start -----

create or replace function fn_shiftdates_inrange(shift_frdt date, shift_todt date , from_date date , to_date date) 
return number is lc_cnt number( 1 );
begin
	If ((Shift_Frdt Between From_Date And To_Date) Or (Shift_Todt Between From_Date And To_Date) ) then
		lc_cnt := 1;
	else
		lc_cnt := 0;
	end if;
	return lc_cnt;
end;
/

---- Function used in Shift Rotate home page data fetching.Start -----

--------------- DDL from ADM-RCP-DDL-V7.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V8.SQL.Start -------

SET DEFINE OFF

--------- Modified by Piyush on 29/10/2014.Start --------------------------------
-- Changes made in bellow function to take care when leave is cancelled or approved from ERP

CREATE OR REPLACE Function Fn_Get_Leave_History(
	Vi_Status In Char,
	Vi_Auth_Sign In Char, 
	Vi_Wrkflw_Status In Char, 
	Vi_Tran_Id_1 In VARCHAR2,
	vi_for_history in char,
	vi_for_emp in char)      
Return Varchar2 Is History_Descr Varchar2(1000);

Vi_Use_Flag Char(1);
vi_leave_type VARCHAR2(10);
Vi_Tran_Id VARCHAR2(50);
Vi_EMP_CODE VARCHAR2(10);
sign_date  VARCHAR2(10); 
emp_fname  VARCHAR2(15); 
emp_mname  VARCHAR2(15); 
emp_lname  VARCHAR2(15); 
historyFormat VARCHAR2(1000);
hist_descr1 VARCHAR2(1000);
empCode VARCHAR2(10); 
roleEmp VARCHAR2(10); 
roleEmpName VARCHAR2(50); 
fullName  VARCHAR2(50);
signStatus CHAR(1); 
ls_entry_by CHAR(1); 
reportTo VARCHAR2(10);
reportToAdmin VARCHAR2(10);
reportToFullName  VARCHAR2(200);
reportToAdminFullName VARCHAR2(200);
hrEmpCode varchar2(10); 
roleCode varchar2(10); 
sign_counter number; 
unsign_counter number; 
rej_counter number; 
li_cnt number; 
lc_no_days number(14,3); 
refser CHAR(6); 
signremarks varchar2(200); 

BEGIN      
	Begin       
		Vi_Tran_Id:=trim(Vi_Tran_Id_1);
		Vi_Use_Flag := 'C';
		vi_leave_type := ' ';
		Vi_EMP_CODE := '';
		sign_date  := ''; 
		emp_fname  := ''; 
		emp_mname  := ''; 
		emp_lname  := ''; 
		historyFormat := '';
		empCode := ''; 
		fullName  := '';
		roleEmp  := '';
		roleEmpName := '';
		signStatus  := ''; 
		reportTo  := '';
		reportToAdmin  := '';
		reportToFullName   := '';
		reportToAdminFullName  := '';
		hrEmpCode  := ''; 
		sign_counter := 0; 
		unsign_counter := 0; 
		rej_counter := 0; 
		li_cnt := 0;
		refser := '';
		hist_descr1 := '';
		ls_entry_by := '';
		signremarks := '';
		lc_no_days := 0;
		History_Descr := '';

		Select Use_Flag,Lve_CODE, emp_code, emp_code__aprv, AUTH_EMP, AUTH_EMP_ALTERNATE, entry_by , no_days 
		Into Vi_Use_Flag,Vi_Leave_Type, Vi_EMP_CODE, hrEmpCode, reportTo, reportToAdmin, ls_entry_by , lc_no_days  
		From Empleave Where Trim(Tran_Id) = Trim(Vi_Tran_Id);

		select emp_fname, emp_mname, emp_lname into emp_fname, emp_mname, emp_lname 
		from employee where emp_code = reportTo; 

		reportToFullName := trim(emp_fname) || ' ' || case when emp_mname is null 
		or length(trim(emp_mname)) = 0 then '' else trim(emp_mname) end || ' ' ||  
		case when emp_lname is null or length(trim(emp_lname)) = 0 then '' else trim(emp_lname) end; 

		select emp_fname, emp_mname, emp_lname into emp_fname, emp_mname, emp_lname 
		from employee where emp_code = reportToAdmin; 

		reportToAdminFullName := trim(emp_fname) || ' ' || case when emp_mname is null 
		or length(trim(emp_mname)) = 0 then '' else trim(emp_mname) end || ' ' ||  
		case when emp_lname is null or length(trim(emp_lname)) = 0 then '' else trim(emp_lname) end; 

		if (Vi_Status = 'C' And Vi_Wrkflw_Status = 'X' ) then
			if (Vi_For_History = 'R') then 
				return 'Cancelled by Employee'; 
			else
				return '';
			end if;
		-- elsif (Vi_Status = 'C') then -- Remarked and modified bellow by Piyush on 29/10/2014 for taking care when action taken from Metis ERP
		elsif (Vi_Status = 'C' and Vi_Wrkflw_Status <> 'Z') then
			li_cnt := 0;
			select count(1) into li_cnt From Obj_Sign_Trans Where Ref_Ser  in ( 'E-LVF', 'E-LVN')
			And Ref_Id = Vi_Tran_Id and sign_status = 'R';
			if li_cnt = 0 then
				if (Vi_For_History = 'R') then
					return 'Rejected'; 
				else
					return '';
				end if;
			end if;
		-- elsif (Vi_Status = 'A') then -- Remarked and modified bellow by Piyush on 29/10/2014 for taking care when action taken from Metis ERP
		elsif (Vi_Status = 'A' and Vi_Wrkflw_Status <> 'Z') then 
			li_cnt := 0;
			select count(1) into li_cnt From Obj_Sign_Trans Where Ref_Ser  in ( 'E-LVF', 'E-LVN')
			And Ref_Id = Vi_Tran_Id and sign_status = 'S';
			if li_cnt = 0 then
				if (Vi_For_History = 'R') then
					return 'Approved'; 
				else
					return '';
				end if;
			end if;
		end if ;

		if (Vi_For_History = 'R') then
			if (Vi_Auth_Sign = 'R') then
				roleCode := 'RECOMEN';
				roleEmp := reportTo;
				roleEmpName := reportToFullName;
			end if;
		elsif (Vi_For_History = 'A') then
			if (Vi_Auth_Sign = 'R' or Vi_Auth_Sign = 'A') then
				roleCode := 'APPROV';
				roleEmp := reportToAdmin;
				roleEmpName := reportToAdminFullName;
			end if;
		end if;
		if (Vi_For_History = 'R' or Vi_For_History = 'A') then
			select count(1) into li_cnt From Obj_Sign_Trans Where Ref_Ser  in ( 'E-LVF', 'E-LVN')
			And Ref_Id = Vi_Tran_Id And Role_Code__Sign = roleCode;
			if (li_cnt > 0) then
				Select trim(Sign_Remarks), emp_code, sign_date, sign_status  Into signremarks, empCode, 
				sign_date, signStatus   From Obj_Sign_Trans Where Ref_Ser  in ( 'E-LVF', 'E-LVN') 
				And Ref_Id = Vi_Tran_Id And Role_Code__Sign = roleCode;
				if (empCode is null or length(trim(empCode)) = 0) then 
					empCode := roleEmp;
					fullName := roleEmpName;
				else
					select emp_fname, emp_mname, emp_lname into emp_fname, emp_mname, emp_lname 
					from employee where emp_code=empCode ;

					fullName := trim(emp_fname) || ' ' || case when emp_mname is null 
					or length(trim(emp_mname)) = 0 then '' else trim(emp_mname) end || ' ' ||  
					case when emp_lname is null or length(trim(emp_lname)) = 0 then '' 
					else trim(emp_lname) end;
				end if;
				if(signStatus = 'R') then       
					historyFormat := 'Rejected by '  || fullName || ' on ' || sign_date || ' ' || 
					'Remarks - ' || signremarks; 
					History_Descr := historyFormat  ; 
				elsif (signStatus = 'S') then            
					historyFormat := 'Approved by '  || fullName || ' on ' || sign_date || ' ' || 
					'Remarks - ' || signremarks; 
					History_Descr := historyFormat  ;
				elsif (signStatus = 'U') then
					if (vi_status not in ('A' , 'C')) then 
						historyFormat := 'Awaiting approval from '  || fullName ; 
						History_Descr := historyFormat  ;
					end if; 
				end if; 
			else
				if (vi_status not in ('A' , 'C')) then 
					empCode := roleEmp;
					fullName := roleEmpName;
					if (Vi_For_History = 'R') then
						if (Vi_Auth_Sign = 'R') then
							History_Descr := 'Awaiting approval from ' || fullName ; 
						end if;
					elsif (Vi_Auth_Sign = 'A') then
						History_Descr := 'Awaiting approval from ' || fullName ; 
					elsif (Vi_Auth_Sign = 'R') then
						li_cnt := 0;
						select count(1) into li_cnt From Obj_Sign_Trans Where Ref_Ser  in ( 'E-LVF', 'E-LVN')
						And Ref_Id = Vi_Tran_Id And Role_Code__Sign = 'RECOMEN';
						if (li_cnt > 0) then
							Select Sign_Remarks, emp_code, sign_date, sign_status, ref_ser  Into signremarks, empCode, 
							sign_date, signStatus, refser   From Obj_Sign_Trans Where Ref_Ser  in ( 'E-LVF', 'E-LVN') 
							And Ref_Id = Vi_Tran_Id And Role_Code__Sign = 'RECOMEN';
							if (((signStatus = 'R' and refser = 'E-LVF') or (signStatus = 'S')) and reportTo <> reportToAdmin) then 
								History_Descr := 'Awaiting approval from ' || fullName ; 
							end if; 
						end if;
					end if;
				end if;

			end if;
			return History_Descr;
		end if;

		if (Vi_For_History = 'H') Then      
			Select  sum(case when sign_status = 'S' then 1 else 0 end) as sign_counter,
			sum(case when sign_status = 'R' then 1 else 0 end) as rej_counter,
			sum(case when sign_status = 'U' then 1 else 0 end) as unsign_counter 
			into sign_counter, rej_counter, unsign_counter From  Obj_Sign_Trans 
			Where  Ref_Ser in ( 'E-LVF', 'E-LVN') And Ref_Id = Vi_Tran_Id 
			AND Role_Code__Sign IN ('HRP','HRPF', 'HRP2') AND USER_ID__SIGN IS NOT NULL  ; 
			if sign_counter is null then 
				sign_counter := 0;
			end if;
			if rej_counter is null then 
				rej_counter := 0;
			end if;
			if unsign_counter is null then 
				unsign_counter := 0;
			end if;
			if (sign_counter > 0 ) then  
				--if (vi_status <> 'C') then
					Select trim(Sign_Remarks), emp_code, sign_date, sign_status  Into signremarks, 
					empCode, sign_date, signStatus From Obj_Sign_Trans 
					Where Ref_Ser  in ( 'E-LVF', 'E-LVN') And Ref_Id = Vi_Tran_Id  
					AND Role_Code__Sign IN ('HRP','HRPF', 'HRP2') AND USER_ID__SIGN IS NOT NULL  
					and sign_status = 'S' and rownum < 2; 

					select emp_fname, emp_mname, emp_lname into emp_fname, emp_mname, emp_lname 
					from employee where emp_code = empCode ; 

					fullName := trim(emp_fname) || ' ' || case when emp_mname is null 
					or length(trim(emp_mname)) = 0 then '' else trim(emp_mname) end || ' ' || 
					case when emp_lname is null or length(trim(emp_lname)) = 0 then '' 
					else trim(emp_lname) end; 

					historyFormat := 'Approved by '  || fullName || ' on ' || sign_date || ' ' || 
					'Remarks - ' || signremarks; 
					History_Descr := historyFormat  ;
				--end if;
			elsif (rej_counter > 0 ) then      
				--if (vi_status <> 'A') then
					Select trim(Sign_Remarks), emp_code, sign_date, sign_status  Into signremarks, 
					empCode, sign_date, signStatus From Obj_Sign_Trans 
					Where Ref_Ser  in ( 'E-LVF', 'E-LVN') And Ref_Id = Vi_Tran_Id  
					AND Role_Code__Sign IN ('HRP','HRPF', 'HRP2') AND USER_ID__SIGN IS NOT NULL  
					and sign_status = 'R' and rownum < 2; 

					select emp_fname, emp_mname, emp_lname into emp_fname, emp_mname, emp_lname 
					from employee where emp_code=empCode ; 

					fullName := trim(emp_fname) || ' ' || case when emp_mname is null 
					or length(trim(emp_mname)) = 0 then '' else trim(emp_mname) end || ' ' || 
					case when emp_lname is null or length(trim(emp_lname)) = 0 then '' 
					else trim(emp_lname) end; 

					historyFormat := 'Rejected by '  || fullName || ' on ' || sign_date || ' ' || 
					'Remarks - ' || signremarks; 
					History_Descr := historyFormat  ;
				--end if;
			elsif (unsign_counter > 0 ) then      
				if (vi_status not in ('A','C')) then
					Select Sign_Remarks, emp_code, sign_date, sign_status  Into signremarks, 
					empCode, sign_date, signStatus From Obj_Sign_Trans 
					Where Ref_Ser  in ( 'E-LVF', 'E-LVN') And Ref_Id = Vi_Tran_Id  
					AND Role_Code__Sign IN ('HRP','HRPF', 'HRP2') AND USER_ID__SIGN IS NOT NULL  
					and sign_status = 'U' and rownum < 2; 

					select emp_fname, emp_mname, emp_lname into emp_fname, emp_mname, emp_lname 
					from employee where emp_code=empCode ; 

					fullName := trim(emp_fname) || ' ' || case when emp_mname is null 
					or length(trim(emp_mname)) = 0 then '' else trim(emp_mname) end || ' ' || 
					case when emp_lname is null or length(trim(emp_lname)) = 0 then '' 
					else trim(emp_lname) end; 

					historyFormat := 'Awaiting approval from HR'; 
					History_Descr := historyFormat  ;
				end if;
			elsif (vi_status not in ('A','C')) then
				if (Vi_Auth_Sign = 'H') then
					History_Descr := 'Awaiting approval from HR'; 
				else
					if (Vi_Leave_Type = 'ML') 
						or (ls_entry_by = 'F' and Vi_Leave_Type = 'SL' and lc_no_days >= 3) 
						or (ls_entry_by = 'N' and Vi_Leave_Type = 'COFF') then
						if (Vi_Auth_Sign = 'A' or reportTo <> reportToAdmin) then
							rolecode := 'APPROV';
						else
							rolecode := 'RECOMEN';
						end if;
						select count(1) into li_cnt from obj_sign_trans where Ref_Ser  in ( 'E-LVF', 'E-LVN') And Ref_Id = Vi_Tran_Id  
						AND Role_Code__Sign = rolecode and sign_status = 'S';
						if li_cnt > 0 then
							History_Descr := 'Awaiting approval from HR'; 
						end if;
					end if;
				end if;
					
			end if;
			-- Modified by Piyush on 29/10/2014 for taking care when action taken from Metis ERP.Start
			if (vi_status = 'A' and Vi_Wrkflw_Status = 'Z') then
				History_Descr := 'Approved in ERP - ' || History_Descr;
			elsif (vi_status = 'C' and Vi_Wrkflw_Status = 'Z') then
				History_Descr := 'Cancelled in ERP - ' || History_Descr;
			end if;
			-- Modified by Piyush on 29/10/2014 for taking care when action taken from Metis ERP.End
		end if;
		EXCEPTION 
		When No_Data_Found Then 
		HISTORY_DESCR :=' ';
	END;
	Return History_Descr;
End;

/

CREATE OR REPLACE FUNCTION FN_GET_LVESTSDESCR
	(VI_STATUS IN CHAR, VI_WRKFLW_STATUS IN CHAR , VI_TRANID IN VARCHAR )
RETURN VARCHAR2 IS L_STATUS VARCHAR2(30);
li_cnt number;
li_cnt1 number;
li_cnt2 number;
VI_TRANID1 varchar2(50);
vi_sign_status char(1);
ls_auth_sign char(1);
ls_entry_by char(1);
ls_auth_emp char(10);
ls_auth_emp_alternate char(10);
ls_lve_code char(5);
lc_no_days number(14,3);
BEGIN
	VI_TRANID1 := trim(VI_TRANID);
	ls_auth_sign := '';
	ls_entry_by := '';
	li_cnt := 0;
	li_cnt1 := 0;
	li_cnt2 := 0;
	ls_auth_emp := '';
	ls_auth_emp_alternate := '';
	ls_lve_code := '';
	lc_no_days := 0;

	if ( Vi_Status = 'A' ) then
		return 'Approved';
	elsif ( Vi_Status = 'C' ) then
		-- if VI_WRKFLW_STATUS = 'X' then -- Remarked and modified bellow by Piyush on 29/10/2014 for taking care when action taken from Metis ERP

		if (VI_WRKFLW_STATUS = 'X' or VI_WRKFLW_STATUS = 'Z') then
			return 'Cancelled';
		else
			return 'Rejected';
		end if;
	else
		select nvl(auth_sign , ' '), nvl(entry_by,' '), auth_emp, auth_emp_alternate, lve_code , no_days  
			into ls_auth_sign, ls_entry_by, ls_auth_emp, ls_auth_emp_alternate, ls_lve_code, lc_no_days  
			from empleave where tran_id = VI_TRANID;
		if ls_auth_sign = 'R' then
			select count(1) into li_cnt from obj_sign_trans 
				where ref_ser in ('E-LVF','E-LVN','E-LVE') and ref_id = VI_TRANID1 
					And Role_Code__Sign = 'RECOMEN' ;
			if li_cnt > 0 then
				select sign_status into vi_sign_status from obj_sign_trans 
				where ref_ser in ('E-LVF','E-LVN','E-LVE') and ref_id = VI_TRANID1 
					And Role_Code__Sign = 'RECOMEN' ;
				if vi_sign_status = 'U' then
					return 'Pending from Recommender';
				elsif vi_sign_status = 'R' then
					if ls_entry_by <> 'F' then
						return 'Rejected';
					end if;
				end if;
			else
				return 'Pending from Recommender';
			end if;
		end if;

		li_cnt := 0;
		li_cnt1 := 0;
		li_cnt2 := 0;

		if ls_auth_sign = 'A' or (ls_auth_sign = 'R' and ls_auth_emp <> ls_auth_emp_alternate) then
			select count(1) into li_cnt from obj_sign_trans 
				where ref_ser in ('E-LVF','E-LVN','E-LVE') and ref_id = VI_TRANID1 
					And Role_Code__Sign = 'APPROV' ;
			if li_cnt > 0 then
				select sign_status into vi_sign_status from obj_sign_trans 
				where ref_ser in ('E-LVF','E-LVN','E-LVE') and ref_id = VI_TRANID1 
					And Role_Code__Sign = 'APPROV' ;
				if vi_sign_status = 'U' then
					return 'Pending from Approver';
				elsif vi_sign_status = 'R' then
					return 'Rejected';
				end if;
			else
				return 'Pending from Approver';
			end if;
		end if;
		ls_lve_code := trim(ls_lve_code);

		li_cnt := 0;
		li_cnt1 := 0;
		li_cnt2 := 0;

		if ls_auth_sign = 'H' 
			or (ls_lve_code = 'ML') 
			or (ls_entry_by = 'F' and ls_lve_code = 'SL' and lc_no_days >= 3) 
			or (ls_entry_by = 'N' and ls_lve_code = 'COFF') then

			select sum(case when sign_status = 'S' then 1 else 0 end) as li_cnt,
				sum(case when sign_status = 'R' then 1 else 0 end) as li_cnt1,
				sum(case when sign_status = 'U' then 1 else 0 end) as li_cnt2 
				into li_cnt, li_cnt1, li_cnt2 from obj_sign_trans 
				where ref_ser in ('E-LVF','E-LVN','E-LVE') and ref_id = VI_TRANID1 
					And Role_Code__Sign in('HRP','HRPF','HRP2') ;
			if li_cnt is null then 
				li_cnt := 0;
			end if;
			if li_cnt1 is null then 
				li_cnt1 := 0;
			end if;
			if li_cnt2 is null then 
				li_cnt2 := 0;
			end if;
			if li_cnt + li_cnt1 + li_cnt2 = 0 then
					return  'Pending from HR';
			elsif li_cnt = 0 then
				if li_cnt1 > 0 then
					return  'Rejected';
				elsif li_cnt2 > 0 then
					return  'Pending from HR';
				end if;
			end if;
		end if;
	end if;
	return 'Pending for System Process';
end;
/


--------- Modified by Piyush on 29/10/2014.End --------------------------------

--------------- DDL from ADM-RCP-DDL-V8.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V9.SQL.Start -------

SET DEFINE OFF

ALTER TABLE EMPLOYEE ADD USER_ID VARCHAR2(20);
ALTER TABLE EMPLOYEE ADD WORK_LOC_CODE CHAR(5);
ALTER TABLE EMPLOYEE ADD PARENT_DEPT CHAR(5);
ALTER TABLE EMPLOYEE ADD EXT_NO VARCHAR2(10);
ALTER TABLE EMPLOYEE ADD AADHAR_CARD_NO VARCHAR2(20);
ALTER TABLE EMPLOYEE ADD ELECTION_CARD_NO VARCHAR2(20);
ALTER TABLE EMPLOYEE ADD DRIV_LIC_NO VARCHAR2(20);
ALTER TABLE EMPLOYEE ADD DRIV_LIC_VALID_UPTO DATE;
ALTER TABLE EMPLOYEE ADD PHYSICAL_HANDICAP CHAR(1);
ALTER TABLE EMPLOYEE ADD HANDICAP_CATEGORY CHAR(5);
ALTER TABLE EMPLOYEE ADD PF_UAN VARCHAR2(20);
ALTER TABLE EMPLOYEE ADD GROUP_MEDICLAIM CHAR(1);
ALTER TABLE EMPLOYEE ADD INSIDER_TRADING_OPT CHAR(1);

ALTER TABLE EMPFAMILY ADD GROUP_MEDICLAIM CHAR(1);

ALTER TABLE EMPQUAL ADD PRINT_SEQ NUMBER(3);
ALTER TABLE EMPEXPERIENCE ADD PRINT_SEQ NUMBER(3);

ALTER TABLE EMPLOYEE_DET_CHANGE ADD AADHAR_CARD_NO_O VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD AADHAR_CARD_NO VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD ELECTION_CARD_NO_O VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD ELECTION_CARD_NO VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD DRIV_LIC_NO_O VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD DRIV_LIC_NO VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD DRIV_LIC_VALID_UPTO_O DATE;
ALTER TABLE EMPLOYEE_DET_CHANGE ADD DRIV_LIC_VALID_UPTO DATE;
ALTER TABLE EMPLOYEE_DET_CHANGE ADD PHYSICAL_HANDICAP_O CHAR(1);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD PHYSICAL_HANDICAP CHAR(1);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD HANDICAP_CATEGORY__O CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD HANDICAP_CATEGORY CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD PF_UAN_O VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD PF_UAN VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD GROUP_MEDICLAIM_O CHAR(1);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD GROUP_MEDICLAIM CHAR(1);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD INSIDER_TRADING_OPT_O CHAR(1);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD INSIDER_TRADING_OPT CHAR(1);

--------------- DDL from ADM-RCP-DDL-V9.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V10.SQL.Start -------
ALTER TABLE EMP_EMPLOY_EVENTS ADD GROUP_MEDICLAIM_FR CHAR(1);
ALTER TABLE EMP_EMPLOY_EVENTS ADD GROUP_MEDICLAIM_TO CHAR(1);

ALTER TABLE EMP_EMPLOY_EVENTS ADD INSIDER_TRADING_OPT_FR CHAR(1);
ALTER TABLE EMP_EMPLOY_EVENTS ADD INSIDER_TRADING_OPT_TO CHAR(1);

--------------- DDL from ADM-RCP-DDL-V10.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V11.SQL.Start -------
ALTER TABLE USERS ADD USER_ID VARCHAR2(20);

--------------- DDL from ADM-RCP-DDL-V11.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V12.SQL.Start -------

ALTER TABLE EMPTRANSFER ADD WORK_CTR__FR CHAR(5);
ALTER TABLE EMPTRANSFER ADD WORK_CTR__TO CHAR(5);

ALTER TABLE EMPLOYEE ADD PENSION_ELIGIBLE CHAR(1);

--------------- DDL from ADM-RCP-DDL-V12.SQL.End -------


--------------- DDL from ADM-RCP-DDL-V13.SQL.Start -------

---------- Function to calculate leave bal days for auto encashment as per new logic.Start ----------
-- [Changes against CCF : CQ14-CS6023 - A14ESUN002]
create or replace function FN_GET_ENC_LVEBAL
(
	ls_emp_code char, 
	ls_lve_code char,
	ld_laps_on_date date, 
	ld_ench_date date, 
	ls_empsite char , 
	ls_worksite char, 
	ls_paysite char, 
	ls_grade char, 
	ls_cadre char, 
	ls_lve_tblno char
) 
Return Number Is Lc_Bal_Days Number(14,1);
Lc_Bal_Days1 Number(14,1);
lc_used_days1 Number(14,1);
begin
	lc_bal_days1 := 0.00;
	lc_used_days1 := 0.00;

	SELECT Sum(LEAVEBAL.BAL_DAYS) as bal_days into lc_bal_days1 
	FROM leavebal
	where leavebal.lve_code = ls_lve_code AND  
	leavebal.emp_code = ls_emp_code AND  
	Leavebal.Exp_Date >= Ld_Laps_On_Date;

	Select Sum(Emplve_Trace.Lves_Alloc) Into Lc_Used_Days1 From Emplve_Trace Where 
	Emplve_Trace.Emp_Code = Ls_Emp_Code 
	And Emplve_Trace.Lve_Code = Ls_Lve_Code 
	and emplve_trace.lve_date_fr > ld_laps_on_date ;

	If Lc_Bal_Days1 Is Null Then 
		Lc_Bal_Days1 := 0;
	end if;
	If Lc_Used_Days1 Is Null Then 
		Lc_Used_Days1 := 0;
	End If;
	lc_bal_days := lc_bal_days1 + lc_used_days1;
	return lc_bal_days;
end;
/

---------- Function to calculate leave bal days for auto encashment as per new logic.End ----------

---------- Function to calculate leave bal days for auto lapse as per new logic.Start ----------
-- [Changes against CCF : CQ14-CS6023 - A14ESUN002]

create or replace function FN_GET_LAPSE_LVEBAL
(
	ls_emp_code char, 
	ls_lve_code char,
	ld_laps_on_date date, 
	ld_ench_date date, 
	ls_empsite char , 
	ls_worksite char, 
	ls_paysite char, 
	ls_grade char, 
	ls_cadre char, 
	ls_lve_tblno char
) 
Return Number Is Lc_Bal_Days Number(14,1);
Lc_Bal_Days1 Number(14,1);
lc_used_days1 Number(14,1);
begin
	lc_bal_days1 := 0.00;
	lc_used_days1 := 0.00;

	SELECT Sum(LEAVEBAL.BAL_DAYS) as bal_days into lc_bal_days1 
	FROM leavebal
	where leavebal.lve_code = ls_lve_code AND  
	leavebal.emp_code = ls_emp_code AND  
	leavebal.eff_date <= Ld_Laps_On_Date and
	Leavebal.Exp_Date >= Ld_Laps_On_Date and 
	leavebal.bal_days > 0;

	Select Sum(a.Lves_Alloc) Into Lc_Used_Days1 From Emplve_Trace a Where 
	a.Emp_Code = Ls_Emp_Code 
	And a.Lve_Code = Ls_Lve_Code 
	and a.lve_date_fr > ld_laps_on_date 
	and a.eff_date <= Ld_Laps_On_Date 
	and (select b.exp_date from leavebal b where b.emp_code = a.emp_code 
		and b.lve_code = a.lve_code and b.eff_date = a.eff_date 
		and b.upto_date = a.upto_date) >= Ld_Laps_On_Date;

	If Lc_Bal_Days1 Is Null Then 
		Lc_Bal_Days1 := 0;
	end if;
	If Lc_Used_Days1 Is Null Then 
		Lc_Used_Days1 := 0;
	End If;
	lc_bal_days := lc_bal_days1 + lc_used_days1;
	return lc_bal_days;
end;
/


---------- Function to calculate leave bal days for auto lapse as per new logic.End ----------

--------------- DDL from ADM-RCP-DDL-V13.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V14.SQL.End -------


---------- Function to filter employee type for temperory employee.Start ----------
create or replace function FN_FILTER_TEMPEMP
(
	ls_emp_type char
) 
Return Number Is li_cnt Number(1);
begin
	li_cnt := 0;
	select count(1) into li_cnt from gencodes where fld_name = 'EMP_TYPE' 
		and mod_name = 'W_EMP_TYPE' and fld_value = ls_emp_type;
	return li_cnt;
end;
/

---------- Function to filter employee type for temperory employee.End ----------

--------------- DDL from ADM-RCP-DDL-V14.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V15.SQL.Start -------

CREATE OR REPLACE FUNCTION FN_HRS_TO_MIN(A_HRS IN NUMBER) RETURN NUMBER IS R_MIN NUMBER(10);

C_HRS NUMBER(10,2);
N_SIGN NUMBER(1);
I_PART1 NUMBER(10);
I_PART2 NUMBER(10);

BEGIN
	C_HRS := A_HRS;
	R_MIN := 0;
	IF C_HRS <> 0 THEN
		IF C_HRS < 0 THEN
			N_SIGN := -1;
			C_HRS := ABS(C_HRS);
		END IF;
	END IF;
	I_PART1 := FLOOR(C_HRS / 1);
	I_PART2 := ((C_HRS - (I_PART1)) * 100);
	R_MIN := (I_PART1 * 60) + (I_PART2);
	RETURN R_MIN;
END;
/

CREATE OR REPLACE FUNCTION FN_MIN_TO_DEC_HRS(A_MIN NUMBER) RETURN NUMBER IS R_HRS NUMBER(12,2);

I_MIN NUMBER(10);
N_SIGN NUMBER(1);
I_PART1 NUMBER(10);
I_PART2 NUMBER(10);

BEGIN
	I_MIN := A_MIN;
	R_HRS := 0;
	IF I_MIN <> 0 THEN
		IF I_MIN < 0 THEN
			N_SIGN := -1;
			I_MIN := ABS(I_MIN);
		END IF;
	END IF;
	I_PART1 := FLOOR(I_MIN / 60);
	I_PART2 := I_MIN - (I_PART1 * 60);
	R_HRS := I_PART1 + (I_PART2 / 100);
	RETURN R_HRS;
END;
/

--------------- DDL from ADM-RCP-DDL-V15.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V16.SQL.Start -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V16.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V17.SQL.Start -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V17.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V18.SQL.Start -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V18.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V19.SQL.Start -------

ALTER TABLE MPREQ ADD TRAN_ID__REF CHAR(10);
ALTER TABLE MPREQ ADD TRAN_TYPE__REF CHAR(1);
ALTER TABLE MPREQ ADD TRAN_SER__REF CHAR(6);

--------------- DDL from ADM-RCP-DDL-V19.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V20.SQL.End -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V20.SQL.End -------

--------------- RCP-DDL from W14CSUN012-Employee Master on WEB.Start -------

CREATE OR REPLACE function fn_get_pos_descr(AS_EMP_CODE char,AS_DEPT_CODE char,AS_POS_CODE char) return varchar2 is 
  a_pos_descr org_structure.descr%type; 
  a_version_id org_structure.version_id%type; 
  a_table_no org_structure.table_no%type; 
  a_dept_code department.dept_code%type; 
  a_level_no org_structure.level_no%type; 
begin 
  if (AS_POS_CODE is null or AS_EMP_CODE is null) then 
    return a_pos_descr; 
  end if; 
  a_dept_code := AS_DEPT_CODE; 
  if (a_dept_code is null) then 
    select dept_code into a_dept_code from employee where emp_code = AS_EMP_CODE; 
  end if; 
  if (a_dept_code is null) then 
    return a_pos_descr; 
  end if; 
  select version_id into a_version_id from version where trunc(sysdate) between eff_from and valid_upto; 
  select item_ser into a_table_no from department where dept_code = a_dept_code; 
  select b.level_no into a_level_no from employee a,grade b where b.grade_code = a.grade and a.emp_code = AS_EMP_CODE; 
  if (a_table_no in ('ET','OL','OT')) then 
    a_level_no := a_level_no + 1; 
  end if; 
  select descr into a_pos_descr from org_structure where version_id = a_version_id and table_no = a_table_no and pos_code = AS_POS_CODE and level_no = a_level_no; 
  return a_pos_descr; 
end;
/

--------------- RCP-DDL from W14CSUN012-Employee Master on WEB.End -------

--------------- DDL from ADM-RCP-DDL-V21.SQL.Start -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V21.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V22.SQL.Start -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V22.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V23.SQL.Start -------


CREATE TABLE FINENT_ACCTPRD
(
	FIN_ENTITY CHAR(10) NOT NULL,
	ACCT_PRD CHAR(6) NOT NULL,
	DESCR VARCHAR2(30) NOT NULL,
	FR_DATE DATE NOT NULL,
	TO_DATE DATE NOT NULL,
	IT_FR_DATE DATE,
	IT_TO_DATE DATE,
	CHG_DATE DATE NOT NULL,
	CHG_USER VARCHAR2(10) NOT NULL,
	CHG_TERM VARCHAR2(15) NOT NULL
);

ALTER TABLE FINENT_ACCTPRD ADD ( CONSTRAINT FINENT_ACCTPRD_X PRIMARY KEY (FIN_ENTITY,ACCT_PRD) );
ALTER TABLE FINENT_ACCTPRD ADD ( CONSTRAINT FK_FINENT_ACCTPRD_FENT FOREIGN KEY (FIN_ENTITY) REFERENCES FINENT ) ;
ALTER TABLE FINENT_ACCTPRD ADD ( CONSTRAINT FK_FINENT_ACCTPRD_APRD FOREIGN KEY (ACCT_PRD) REFERENCES ACCTPRD ) ;


--------------- DDL from ADM-RCP-DDL-V23.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V24.SQL.Start -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V24.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V25.SQL.Start -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V25.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V26.SQL.Start -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V26.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V27.SQL.Start -------

--- Request ID : F15DSUN007.Start ---

ALTER TABLE EMPLOYEE ADD IFSC VARCHAR2(60);

ALTER TABLE EMPLOYEE_DET_CHANGE ADD IFSC_O VARCHAR2(60);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD IFSC VARCHAR2(60);

ALTER TABLE EMP_EMPLOY_EVENTS ADD IFSC_FR varchar2(60);

ALTER TABLE EMP_EMPLOY_EVENTS ADD IFSC_TO varchar2(60);

--- Request ID : F15DSUN007.End ---

--- Request ID: A15CSUN007.Start ---


ALTER TABLE ATTENDANCE_DAY MODIFY (PUNCH_STR VARCHAR2(3000));

ALTER TABLE ATTD_REG MODIFY (PUNCH_STR VARCHAR2(3000)); 

ALTER TABLE ATTD_REGULARIZE MODIFY (PUNCH_STR VARCHAR2(3000)); 
ALTER TABLE ATTD_REGULARIZE MODIFY (ORG_PUNCH_STR VARCHAR2(3000)); 
ALTER TABLE ATTD_REGULARIZE MODIFY (PUNCHSTR_BEFORE_APRV VARCHAR2(3000)); 

--- Request ID: A15CSUN007.End ---

--- Employee Bond Master [Request ID: A15DSUN002].Start ---

CREATE TABLE EMPLOYEE_BOND 
(
	EMP_CODE CHAR(10) NOT NULL, 
	LINE_NO NUMBER(3,0) NOT NULL, 
	BOND_PRD NUMBER(2,0), 
	BOND_AMT NUMBER(14,3),
	CHG_DATE DATE ,
	CHG_USER VARCHAR2(10) ,
	CHG_TERM VARCHAR2(15) 
) ;
ALTER TABLE EMPLOYEE_BOND ADD ( CONSTRAINT EMPLOYEE_BOND_X PRIMARY KEY ( EMP_CODE, LINE_NO )) ;
ALTER TABLE EMPLOYEE_BOND ADD ( CHG_DATE DATE);
ALTER TABLE EMPLOYEE_BOND ADD ( CHG_USER VARCHAR2(10));
ALTER TABLE EMPLOYEE_BOND ADD ( CHG_TERM VARCHAR2(15));

ALTER TABLE EMPLOYEE_BOND ADD ( CONSTRAINT FK_EMPLOYEE_BOND1 FOREIGN KEY ( EMP_CODE ) REFERENCES EMPLOYEE ) ;

--- Employee Bond Master [Request ID: A15DSUN002].End ---

--- Employee Bond Definition Transaction [Request ID: A15ESUN002].Start ----

CREATE TABLE EMPLOYEE_BOND_DEF 
(
	TRAN_ID CHAR(10) NOT NULL, 
	TRAN_DATE DATE, 
	SITE_CODE CHAR(5) NOT NULL, 
	EMP_CODE CHAR(10) NOT NULL, 
	CONFIRMED CHAR(1), 
	CONF_DATE DATE, 
	EMP_CODE__APRV CHAR(10), 
	CHG_DATE DATE NOT NULL,
	CHG_USER VARCHAR2(10) NOT NULL, 
	CHG_TERM VARCHAR2(15) NOT NULL
) ;
ALTER TABLE EMPLOYEE_BOND_DEF ADD ( CONSTRAINT EMPLOYEE_BOND_DEF_X PRIMARY KEY ( TRAN_ID )) ;
CREATE UNIQUE INDEX EMPLOYEE_BOND_DEF_X ON EMPLOYEE_BOND_DEF (TRAN_ID ) ;

ALTER TABLE EMPLOYEE_BOND_DEF ADD ( CONSTRAINT FK_EMPLOYEE_BOND_DEF1 FOREIGN KEY ( EMP_CODE ) REFERENCES EMPLOYEE ) ;

CREATE TABLE EMPLOYEE_BOND_DEF_DET 
(
	TRAN_ID CHAR(10) NOT NULL, 
	LINE_NO NUMBER(3,0) NOT NULL, 
	BOND_AMT__CURR NUMBER(14,3), 
	BOND_PRD__CURR NUMBER(2,0), 
	BOND_AMT NUMBER(14,3), 
	BOND_PRD NUMBER(2,0), 
	LINE_NO__REF NUMBER(3,0)
) ;
ALTER TABLE EMPLOYEE_BOND_DEF_DET ADD ( CONSTRAINT EMPLOYEE_BOND_DEF_DET_X PRIMARY KEY ( TRAN_ID, LINE_NO )) ;

ALTER TABLE EMPLOYEE_BOND_DEF_DET ADD ( CONSTRAINT FK_EMPLOYEE_BOND_DEF_DET FOREIGN KEY ( TRAN_ID ) REFERENCES EMPLOYEE_BOND_DEF ON DELETE CASCADE ) ;

ALTER TABLE EMPLOYEE_BOND_DEF_DET ADD LINE_NO__REF NUMBER (3);

--- Employee Bond Definition Transaction [Request ID: A15ESUN002].End ----

--------------- DDL from ADM-RCP-DDL-V27.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V27-1.SQL.Start -------
-- No DDL in this version
--------------- DDL from ADM-RCP-DDL-V27-1.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V28.SQL.Start -------


ALTER TABLE EMPLOYEE MODIFY CUR_ADD1 VARCHAR2(50);
ALTER TABLE EMPLOYEE MODIFY CUR_ADD2 VARCHAR2(50);
ALTER TABLE EMPLOYEE MODIFY CUR_ADD3 VARCHAR2(50);

ALTER TABLE EMPLOYEE MODIFY PER_ADD1 VARCHAR2(50);
ALTER TABLE EMPLOYEE MODIFY PER_ADD2 VARCHAR2(50);
ALTER TABLE EMPLOYEE MODIFY PER_ADD3 VARCHAR2(50);

ALTER TABLE EMPLOYEE MODIFY CONTACT_ADD1 VARCHAR2(50);
ALTER TABLE EMPLOYEE MODIFY CONTACT_ADD2 VARCHAR2(50);
ALTER TABLE EMPLOYEE MODIFY CONTACT_ADD3 VARCHAR2(50);

ALTER TABLE EMPLOYEE_ADD_CHANGE MODIFY CUR_ADD1 VARCHAR2(50);
ALTER TABLE EMPLOYEE_ADD_CHANGE MODIFY CUR_ADD2 VARCHAR2(50);
ALTER TABLE EMPLOYEE_ADD_CHANGE MODIFY CUR_ADD3 VARCHAR2(50);

ALTER TABLE EMPLOYEE_ADD_CHANGE MODIFY PER_ADD1 VARCHAR2(50);
ALTER TABLE EMPLOYEE_ADD_CHANGE MODIFY PER_ADD2 VARCHAR2(50);
ALTER TABLE EMPLOYEE_ADD_CHANGE MODIFY PER_ADD3 VARCHAR2(50);

ALTER TABLE EMPLOYEE_ADD_CHANGE MODIFY EMAIL_ID_OFF VARCHAR2(75);
ALTER TABLE EMPLOYEE_ADD_CHANGE MODIFY EMAIL_ID_PER VARCHAR2(75);


-- Request ID: A15FSUN002.Start --

CREATE TABLE BUSINESS_UNITS
(
	BU_CODE CHAR(5) NOT NULL,
	DESCR VARCHAR(120) NOT NULL,
	SH_DESCR VARCHAR(40),
	EMP_CODE__HEAD CHAR(10) NOT NULL,
	ADD_DATE DATE NOT NULL,
	ADD_USER CHAR(10) NOT NULL,
	ADD_TERM VARCHAR2(15) NOT NULL,
	CHG_DATE DATE NOT NULL,
	CHG_USER CHAR(10) NOT NULL,
	CHG_TERM VARCHAR2(15) NOT NULL
);
ALTER TABLE BUSINESS_UNITS ADD CONSTRAINT BUSINESS_UNITS_X PRIMARY KEY(BU_CODE);

-- Request ID: A15FSUN002.End --

-- Request ID: A15FSUN003.Start --

CREATE TABLE BUSI_FUNCTIONS
(
	FUNC_CODE CHAR(5) NOT NULL,
	DESCR VARCHAR(120) NOT NULL,
	SH_DESCR VARCHAR(40) NOT NULL,
	ADD_DATE DATE NOT NULL,
	ADD_USER CHAR(10) NOT NULL,
	ADD_TERM VARCHAR2(15) NOT NULL,
	CHG_DATE DATE NOT NULL,
	CHG_USER CHAR(10) NOT NULL,
	CHG_TERM VARCHAR2(15) NOT NULL
);
ALTER TABLE BUSI_FUNCTIONS ADD CONSTRAINT BUSI_FUNCTIONS_X PRIMARY KEY(FUNC_CODE);

-- Request ID: A15FSUN003.End --

--- Department Master - Request ID: A15FSUN004 - CCF No.: IT2015-82F.Start ---
ALTER TABLE DEPARTMENT ADD (DEPT_CODE__PARENT CHAR(5));
ALTER TABLE DEPARTMENT ADD (BU_CODE CHAR(5));
ALTER TABLE DEPARTMENT ADD (FUNC_CODE CHAR(5));
ALTER TABLE DEPARTMENT ADD (EMP_CODE__FUNCHEAD CHAR(10));


CREATE OR REPLACE FUNCTION FN_GET_BUCODE_DESCR(as_bu_code char)  
return varchar2 is ls_descr varchar2(120);
begin
	begin  
		select descr into ls_descr  from  BUSINESS_UNITS   
		where bu_code = as_bu_code;  
	exception  
	  when no_data_found then  
		ls_descr := null;  
	end;  
	return ls_descr;  
end;
/

--- Department Master - Request ID: A15FSUN004 - CCF No.: IT2015-82F.End ---

-- Request ID: A15FSUN006.Start --

create or replace
FUNCTION FN_DEPT_HIER_DESC(as_dept_code char)
return varchar2 is
  ls_dept_hierarchy varchar2(4000);
begin
	ls_dept_hierarchy := '';
	  select sys_connect_by_path(descr,'>>') into ls_dept_hierarchy from DEPARTMENT where dept_code = as_dept_code and level in (select max(level) from  DEPARTMENT where dept_code = as_dept_code connect by prior dept_code = dept_code__parent) connect by prior dept_code=dept_code__parent;
	  --select substr(ls_dept_hierarchy,5) into ls_dept_hierarchy from dual;
	  return substr(ls_dept_hierarchy,3);
end;
/

CREATE OR REPLACE FUNCTION FN_GET_BUFUNC_DESCR  
 (  
    as_func_code char)  
return varchar2 is  
ls_descr varchar2(120);  
begin  
begin  
select descr into ls_descr  
from  BUSI_FUNCTIONS  
where func_code = as_func_code;  
exception  
  when no_data_found then  
 ls_descr := null;  
end;  
return ls_descr;  
end;
/

-- Request ID: A15FSUN006.End --

--- Request ID: F15GSUN012.Start ----

ALTER TABLE TOUR  ADD (TOUR_ADV_AMT NUMBER(14,3));

--- Request ID: F15GSUN012.End ----

--------------- DDL from ADM-RCP-DDL-V28.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V29.SQL.Start -------
SET DEFINE OFF

create or replace
FUNCTION FN_DEPT_HIER_DESC(as_dept_code char)
return varchar2 is
  ls_dept_hierarchy varchar2(4000);
  ls_connect_col NUMBER(4);
  ls_maxlevel number(4);
  ls_connectmax_col number(4);
begin
	ls_dept_hierarchy := '';
	select max(level), CONNECT_BY_ISCYCLE into ls_maxlevel, ls_connectmax_col from DEPARTMENT 
		where dept_code = as_dept_code 
		AND DEPT_CODE__PARENT IS NOT NULL 
		AND DEPT_CODE__PARENT <> DEPT_CODE 
		group by CONNECT_BY_ISCYCLE 
		connect by NOCYCLE prior dept_code = dept_code__parent;

	select sys_connect_by_path(descr,'>>'), CONNECT_BY_ISCYCLE into ls_dept_hierarchy, 
		ls_connect_col from DEPARTMENT where dept_code = as_dept_code 
		AND  DEPT_CODE__PARENT IS NOT NULL AND DEPT_CODE__PARENT <> DEPT_CODE and level in (ls_maxlevel) connect by NOCYCLE prior dept_code=dept_code__parent;
	ls_dept_hierarchy := substr(ls_dept_hierarchy,3);
	return nvl(ls_dept_hierarchy , ' ');
end;
/

--------------- DDL from ADM-RCP-DDL-V29.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V30.SQL.Start -------
create or replace
FUNCTION FN_DEPT_HIER_DESC(as_dept_code char)
return varchar2 is
  ls_dept_hierarchy varchar2(4000);
  ls_connect_col NUMBER(4);
  ls_maxlevel number(4);
  ls_connectmax_col number(4);
begin
	ls_dept_hierarchy := '';
	select max(level), CONNECT_BY_ISCYCLE into ls_maxlevel, ls_connectmax_col from DEPARTMENT 
		where dept_code = as_dept_code 
		AND DEPT_CODE__PARENT IS NOT NULL 
		AND DEPT_CODE__PARENT <> DEPT_CODE 
		group by CONNECT_BY_ISCYCLE 
		connect by NOCYCLE prior dept_code = dept_code__parent;

	select sys_connect_by_path(descr,'>>'), CONNECT_BY_ISCYCLE into ls_dept_hierarchy, 
		ls_connect_col from DEPARTMENT where dept_code = as_dept_code 
		AND  DEPT_CODE__PARENT IS NOT NULL AND DEPT_CODE__PARENT <> DEPT_CODE and level in (ls_maxlevel) connect by NOCYCLE prior dept_code=dept_code__parent;
	ls_dept_hierarchy := substr(ls_dept_hierarchy,3);
	return nvl(ls_dept_hierarchy , ' ');
end;
/

--------------- DDL from ADM-RCP-DDL-V30.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V31.SQL.Start -------
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY CONTACT_ADD1_O VARCHAR2(50);
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY CONTACT_ADD2_O VARCHAR2(50);
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY CONTACT_ADD3_O VARCHAR2(50);
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY CONTACT_ADD1 VARCHAR2(50);
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY CONTACT_ADD2 VARCHAR2(50);
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY CONTACT_ADD3 VARCHAR2(50); 

--- F16ASUN005.Start ---

DROP FUNCTION FN_TF_LOAN_INT_INFO;
DROP TYPE TFT_LOAN_INT_INFO;
DROP TYPE TFO_LOAN_INT_INFO;

CREATE TYPE TFO_LOAN_INT_INFO AS OBJECT 
(
	ACCT_PRD_ARG CHAR(6),
	ACCT_PRD_DATA CHAR(6),
	PRD_CODE__FR CHAR(6),
	PRD_CODE__TO CHAR(6),
	EMP_CODE CHAR(10),
	EMP_FULL_NAME VARCHAR2(120),
	PAY_SITE CHAR(5),
	FIN_ENTITY CHAR(10),
	CCTR_CODE__SAL CHAR(4),
	LOAN_NO CHAR(15),
	SCHEME_NO CHAR(10),
	SCHEME_TYPE CHAR(5),
	LOAN_AMT NUMBER(12,3),
	TERM NUMBER(3),
	INT_TERM CHAR(5),
	ISSUE_DATE DATE,
	LOAN_DISB_DATE DATE,
	LOAN_START_RECO_DATE DATE,
	LOAN_CLOUSRE_DATE DATE,
	MON_INST NUMBER(12,3),
	PRE_PAID_EMP_BENIFIT NUMBER(12,3),
	INTEREST NUMBER(6,2),
	ISA_EFF_INT_RATE NUMBER(6,2),
	APPR_DATE DATE,
	BALANCE_AMT NUMBER(12,3),
	DATE__BALANCE DATE,
	DATE__INTEREST DATE,
	LOAN_TYPE CHAR(1),
	EMI_NO NUMBER(10),
	EMI_PRD_CODE CHAR(6),
	EMI_PRD_DESCR VARCHAR2(10),
	OP_BALANCE_AMT NUMBER(12,3),
	INTEREST_AMT NUMBER(12,3),
	PRINC_CUM_INTEREST_AMT NUMBER(12,3),
	MON_DEDN NUMBER(12,3),
	RECOVER_AMT NUMBER(12,3),
	CL_BALANCE_AMT NUMBER(12,3),
	PRINC_DEDN NUMBER(12,3),
	PV_FACTOR NUMBER(10,4),
	PRESENT_VALUE NUMBER(12,3),
	AMORTISED_COST_OP_BAL NUMBER(12,3),
	INTEREST_AT_EFF_RATE NUMBER(12,3),
	REPAYMENT_INCL_INTEREST NUMBER(12,3),
	AMORTISED_COST_CL_BAL NUMBER(12,3),
	EMP_BENEFIT NUMBER(12,3),
	DIFF_PRINC_DEDN NUMBER(12,3),
	LOAN_INT_CALC_STR VARCHAR2(4000)
)
/
CREATE TYPE TFT_LOAN_INT_INFO AS TABLE OF TFO_LOAN_INT_INFO
/

CREATE OR REPLACE
FUNCTION FN_TF_LOAN_INT_INFO
	(
		FIN_ENTITY_CODE_FR FINENT.FIN_ENTITY%TYPE,
		FIN_ENTITY_CODE_TO FINENT.FIN_ENTITY%TYPE,
		ACCT_PRD ACCTPRD.CODE%TYPE,
		PRD_CODE__FR PERIOD.CODE%TYPE,
		PRD_CODE__TO PERIOD.CODE%TYPE,
		SITE_CODE__FR SITE.SITE_CODE%TYPE,
		SITE_CODE__TO SITE.SITE_CODE%TYPE,
		CCTR_CODE__FR EMPLOYEE.CCTR_CODE__SAL%TYPE,
		CCTR_CODE__TO EMPLOYEE.CCTR_CODE__SAL%TYPE,
		EMP_CODE__FR EMPLOYEE.EMP_CODE%TYPE, 
		EMP_CODE__TO EMPLOYEE.EMP_CODE%TYPE,
		EFF_INT_RATE LOANS.INTEREST%TYPE
	)
RETURN TFT_LOAN_INT_INFO 
PIPELINED IS 
OUT_REC TFO_LOAN_INT_INFO := TFO_LOAN_INT_INFO(	NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

LI_CNT NUMBER(6);
LI_CNT1 NUMBER(6);
LI_CNT2 NUMBER(6);
EMI_NO NUMBER(6);
TOT_INST_DEDN NUMBER(6);
TOT_INST_NO NUMBER(6);
LC_LOAN_OP_BAL LOANS.LOAN_AMT%TYPE;
LC_LOAN_RECO LOANS.LOAN_AMT%TYPE;
LD_LOAN_CLOUSRE_DATE DATE;
LD_INT_FIRST_DATE DATE;
LD_INT_LAST_DATE DATE;
EMI_PRD_CODE PERIOD.CODE%TYPE;
EMI_PRD_DESCR PERIOD.DESCR%TYPE;
PV_FACTOR NUMBER(12,4);
PRESENT_VALUE LOANS.LOAN_AMT%TYPE;
TOT_PRESENT_VALUE LOANS.LOAN_AMT%TYPE;
AMORTISED_COST_OP_BAL LOANS.LOAN_AMT%TYPE;
INTEREST_AT_EFF_RATE LOANS.LOAN_AMT%TYPE;
AMORTISED_COST_CL_BAL LOANS.LOAN_AMT%TYPE;
EMP_BENEFIT LOANS.LOAN_AMT%TYPE;
DIFF_PRINC_DEDN LOANS.LOAN_AMT%TYPE;
LC_PRINC_DEDN LOANS.LOAN_AMT%TYPE;
LC_INT_DEDN LOANS.LOAN_AMT%TYPE;
LC_OTH_RECOVERY LOANS.LOAN_AMT%TYPE;
LC_EFF_INT_RATE LOANS.INTEREST%TYPE;
LS_EXCLUDE_SCHEME_TYPE VARCHAR2(1024);
LOAN_INT_CALC_STR VARCHAR2(4000);
ARG_ACCT_PRD_CODE ACCTPRD.CODE%TYPE;
LD_CAL_FDATE ACCTPRD.FR_DATE%TYPE;
LD_CAL_TDATE ACCTPRD.TO_DATE%TYPE;
LI_NO_DAYS_IN_CAL_YR NUMBER(3);

CURSOR LOAN_INFO(AS_EXCLUDE_SCHEME_TYPE VARCHAR2) IS 
	SELECT 
	LN.EMP_CODE AS EMP_CODE ,
	TRIM(EM.EMP_FNAME) || ' ' || TRIM(EM.EMP_MNAME) || TRIM(EM.EMP_LNAME) AS EMP_FULL_NAME,
	EM.PAY_SITE AS PAY_SITE,
	EM.CCTR_CODE__SAL AS CCTR_CODE__SAL,
	LN.LOAN_NO AS LOAN_NO,
	LN.SCHEME_NO SCHEME_NO,
	LN.ISSUE_DATE AS ISSUE_DATE,
	LN.START_RECO AS START_RECO,
	LN.TERM AS TERM,
	LN.LOAN_AMT AS LOAN_AMT,
	LN.INTEREST AS INTEREST,
	LN.MON_INST AS MON_INST,
	LN.INT_TERM AS INT_TERM,
	LN.INTEREST_AMT AS INTEREST_AMT,
	LN.RECOVER_AMT AS RECOVER_AMT,
	LN.APPR_DATE AS APPR_DATE,
	LN.BALANCE_AMT AS BALANCE_AMT,
	LN.DATE__BALANCE AS DATE__BALANCE,
	LN.DATE__INTEREST AS DATE__INTEREST,
	LN.LOAN_TYPE AS LOAN_TYPE,
	LN.ACT_TERM AS ACT_TERM,
	AP.FR_DATE AS FY_FROM_DATE,
	AP.TO_DATE AS FY_TO_DATE,
	LS.AD_CODE__INT AS AD_CODE__INT,
	LS.AD_CODE__DED AS AD_CODE__DED,
	LS.SCHEME_TYPE AS SCHEME_TYPE,
	SM.FIN_ENTITY AS FIN_ENTITY
	FROM LOANS LN, EMPLOYEE EM, SITE SM, ACCTPRD AP, LOAN_SCHEME LS 
	WHERE EM.EMP_CODE = LN.EMP_CODE 
	AND LN.EMP_CODE >= EMP_CODE__FR 
	AND LN.EMP_CODE <= EMP_CODE__TO 
	AND EM.PAY_SITE >= SITE_CODE__FR 
	AND EM.PAY_SITE <= SITE_CODE__TO 
	AND SM.SITE_CODE = EM.PAY_SITE 
	--AND SM.FIN_ENTITY = FIN_ENTITY_CODE_FR 
	AND SM.FIN_ENTITY BETWEEN FIN_ENTITY_CODE_FR AND FIN_ENTITY_CODE_TO 
	AND LN.ISSUE_DATE <= AP.TO_DATE 
	AND AP.CODE = ACCT_PRD 
	AND LN.STATUS IN ('A','E')
	AND LS.SCHEME_NO = LN.SCHEME_NO 
	--AND LS.SCHEME_TYPE NOT IN ('A','B') 
	-- AND LS.SCHEME_TYPE NOT IN (AS_EXCLUDE_SCHEME_TYPE) 
	AND LS.SCHEME_TYPE NOT IN ( SELECT regexp_substr(AS_EXCLUDE_SCHEME_TYPE, '[^,]+', 1, LEVEL) 
		token FROM dual CONNECT BY LEVEL <= length(AS_EXCLUDE_SCHEME_TYPE) - 
			length(REPLACE(AS_EXCLUDE_SCHEME_TYPE, ',', '')) + 1) 
	ORDER BY SM.FIN_ENTITY,LN.EMP_CODE,LN.ISSUE_DATE;

CURSOR PRD_INFO(START_DATE DATE) IS SELECT A.CODE,A.FR_DATE,A.TO_DATE,
	A.ACCT_PRD AS P_ACCT_PRD,B.FR_DATE AS FY_FROM_DATE,B.TO_DATE AS FY_TO_DATE 
	FROM PERIOD A,ACCTPRD B
	WHERE B.CODE = A.ACCT_PRD AND A.TO_DATE >= START_DATE ORDER BY TO_DATE;

CURSOR LOAN_INST_INFO(ARG_LOAN_NO CHAR) IS SELECT * FROM LOANS_SCHEDULE 
	WHERE LOAN_NO = ARG_LOAN_NO  
	AND (NO_INST <> NO_INST_DED OR (NO_INST IS NULL AND PRD_CODE IS NULL)) ORDER BY LINE_NO ;

CURSOR LOAN_RECO_INFO(ARG_LOAN_NO CHAR , ARG_FR_DATE DATE , ARG_TO_DATE DATE) 
	IS SELECT * FROM LOAN_REG WHERE LOAN_NO = ARG_LOAN_NO 
	AND TRAN_DATE BETWEEN ARG_FR_DATE AND ARG_TO_DATE 
	AND AMOUNT <> 0 AND TRAN_TYPE NOT IN ('P') AND 
	CASE WHEN INT_CALCULATED IS NULL THEN 'N' ELSE INT_CALCULATED END = 'N' 
	ORDER BY TRAN_DATE;

CURSOR LOAN_INT_CALC_INFO(ARG_LOAN_NO CHAR , ARG_PRD_CODE CHAR) 
	IS SELECT * FROM LOANS_INTEREST_DET WHERE LOAN_NO = ARG_LOAN_NO 
	AND PRD_CODE = ARG_PRD_CODE ORDER BY PRD_CODE,LINE_NO;

BEGIN
	ARG_ACCT_PRD_CODE := ACCT_PRD;
	LI_CNT2 := 0;
	SELECT COUNT(1) INTO LI_CNT2 FROM PERIOD WHERE CODE BETWEEN PRD_CODE__FR AND PRD_CODE__TO 
		AND ACCT_PRD = ARG_ACCT_PRD_CODE;
	IF LI_CNT2 = 0 THEN
		RETURN;
	END IF;
	LI_CNT2 := 0;
	SELECT COUNT(1) INTO LI_CNT2 FROM PAYRPARM 
		WHERE PRD_CODE = '999999' AND VAR_NAME = 'IAS_LNREPO_EXCL_SCHM';
	IF LI_CNT2 > 0 THEN
		SELECT TRIM(VAR_VALUE) INTO LS_EXCLUDE_SCHEME_TYPE FROM PAYRPARM 
			WHERE PRD_CODE = '999999' AND VAR_NAME = 'IAS_LNREPO_EXCL_SCHM';
	ELSE
		LS_EXCLUDE_SCHEME_TYPE := '';
	END IF;
	IF LS_EXCLUDE_SCHEME_TYPE IS NULL OR LENGTH(TRIM(LS_EXCLUDE_SCHEME_TYPE)) = 0 THEN
		LS_EXCLUDE_SCHEME_TYPE := '**********';
	END IF;
	DBMS_OUTPUT.PUT_LINE(LS_EXCLUDE_SCHEME_TYPE);
	LI_CNT2 := 0;
	FOR I IN LOAN_INFO(LS_EXCLUDE_SCHEME_TYPE)
	LOOP
		LI_CNT2 := LI_CNT2 + 1;
		LI_CNT := 0;
		LC_LOAN_OP_BAL := I.LOAN_AMT;
		SELECT SUM(AMOUNT) INTO LC_LOAN_RECO FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
		AND TRAN_DATE < I.FY_FROM_DATE;
		IF LC_LOAN_RECO IS NOT NULL THEN 
			LC_LOAN_OP_BAL := LC_LOAN_OP_BAL - LC_LOAN_RECO;
		END IF;
		LI_CNT1 := 0;
		SELECT COUNT(1), MIN(FROM_DATE) INTO LI_CNT1, LD_INT_FIRST_DATE FROM LOAN_INT_REG WHERE LOAN_NO=I.LOAN_NO ;
		IF LI_CNT1 > 0 THEN
			LD_INT_LAST_DATE := I.DATE__INTEREST + 1;
		ELSE
			LD_INT_LAST_DATE := I.DATE__INTEREST;
			LD_INT_FIRST_DATE := I.DATE__INTEREST;
		END IF;
		LI_CNT1 := 0;
		SELECT CASE WHEN LD_INT_FIRST_DATE > (SELECT TO_DATE FROM PERIOD 
			WHERE CODE = PRD_CODE__TO) THEN 0 ELSE LC_LOAN_OP_BAL END INTO LC_LOAN_OP_BAL 
			FROM DUAL;
		SELECT SUM(INT_RATE) INTO LC_EFF_INT_RATE FROM LOANSCHEME_INT_RATE 
		WHERE SCHEME_TYPE = I.SCHEME_TYPE AND LD_INT_FIRST_DATE BETWEEN EFF_FROM AND VALID_UPTO;
		IF LC_EFF_INT_RATE IS NULL THEN 
			LC_EFF_INT_RATE := CASE WHEN EFF_INT_RATE IS NULL OR EFF_INT_RATE <= 0 THEN 
			I.INTEREST ELSE EFF_INT_RATE END;
		END IF;
		IF LC_EFF_INT_RATE <= I.INTEREST THEN 
			LC_LOAN_OP_BAL := 0;
		END IF;
		IF LC_LOAN_OP_BAL > 0 THEN
			EMI_NO := 0;
			TOT_PRESENT_VALUE := 0;
			LC_LOAN_OP_BAL := I.LOAN_AMT;

			FOR J IN PRD_INFO(LD_INT_FIRST_DATE)
			LOOP
				LD_CAL_FDATE := TO_DATE('01/01/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
				LD_CAL_TDATE := TO_DATE('31/12/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
				LI_NO_DAYS_IN_CAL_YR := LD_CAL_TDATE - LD_CAL_FDATE + 1;
				IF LC_LOAN_OP_BAL > 0 THEN
					EMI_NO := EMI_NO + 1;
					LI_CNT1 := 0;
					LC_PRINC_DEDN := 0;
					SELECT COUNT(1) INTO LI_CNT1 FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
					AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
					IF LI_CNT1 > 0 THEN
						SELECT SUM(CASE WHEN AMOUNT IS NULL THEN 0 ELSE AMOUNT END) 
						INTO LC_PRINC_DEDN FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
						AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
					ELSE
						LI_CNT1 := 0;
						SELECT COUNT(1) INTO LI_CNT1 FROM PAYROLL WHERE EMP_CODE = I.EMP_CODE 
						AND PRD_CODE = J.CODE;
						IF LI_CNT1 > 0 THEN
							SELECT AMOUNT INTO LC_PRINC_DEDN FROM PAYROLLDET 
							WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND 
							((REF_TYPE = 'L' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__DED);
						ELSE
							IF I.START_RECO <= J.FR_DATE THEN
								TOT_INST_DEDN := 0;
								TOT_INST_NO := 0;
								FOR K IN LOAN_INST_INFO(I.LOAN_NO)
								LOOP
									TOT_INST_NO := TOT_INST_NO + CASE WHEN K.NO_INST IS NULL THEN 9999 
										ELSE K.NO_INST END;
									IF TOT_INST_NO >= EMI_NO THEN
										LC_PRINC_DEDN := CASE WHEN LC_LOAN_OP_BAL > K.AMOUNT THEN K.AMOUNT ELSE LC_LOAN_OP_BAL END;
										EXIT;
									END IF;
								END LOOP;
							END IF;
						END IF;
					END IF;
					PV_FACTOR := 0;
					PRESENT_VALUE := 0;
					LC_OTH_RECOVERY := 0;
					LC_INT_DEDN := 0;
					IF LI_CNT1 > 0 THEN
						SELECT AMOUNT INTO LC_INT_DEDN FROM PAYROLLDET WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND ((REF_TYPE = 'N' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__INT);
					ELSE
						LC_INT_DEDN := ROUND((LC_LOAN_OP_BAL * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1),2);
						FOR L IN LOAN_RECO_INFO(I.LOAN_NO, J.FR_DATE, J.TO_DATE)
						LOOP
							LC_INT_DEDN := LC_INT_DEDN - (ROUND((L.AMOUNT * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - L.TRAN_DATE) + 1),2));
						END LOOP;
						LC_INT_DEDN := CASE WHEN LC_INT_DEDN >= 0 THEN LC_INT_DEDN ELSE 0 END;
						IF TRIM(I.INT_TERM) = 'EMI' THEN
							LC_PRINC_DEDN := I.MON_INST - LC_INT_DEDN;
						ELSE
							LC_PRINC_DEDN := I.MON_INST;
						END IF;
					END IF;
					IF LC_PRINC_DEDN > LC_LOAN_OP_BAL THEN
						LC_PRINC_DEDN := LC_LOAN_OP_BAL;
					END IF;

					SELECT SUM(AMOUNT) INTO LC_OTH_RECOVERY FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE AND TRAN_TYPE NOT IN ('P');
					IF LC_OTH_RECOVERY IS NULL THEN 
						LC_OTH_RECOVERY := 0;
					END IF;
					PV_FACTOR := ROUND(1 / POWER((1 + ROUND(LC_EFF_INT_RATE / 1200 , 4)),EMI_NO),4);
					PRESENT_VALUE := ROUND((LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) * PV_FACTOR , 2);
					TOT_PRESENT_VALUE := TOT_PRESENT_VALUE + PRESENT_VALUE;
					LC_LOAN_OP_BAL := LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY;
					LD_LOAN_CLOUSRE_DATE := J.TO_DATE;
				ELSE
					EXIT;
				END IF;
			END LOOP;

			IF LD_LOAN_CLOUSRE_DATE >= I.FY_FROM_DATE THEN
				LC_LOAN_OP_BAL := I.LOAN_AMT;
				LI_CNT1 := 0;
				SELECT CASE WHEN LD_INT_FIRST_DATE > (SELECT TO_DATE FROM PERIOD 
					WHERE CODE = PRD_CODE__TO) THEN 0 ELSE LC_LOAN_OP_BAL END INTO LC_LOAN_OP_BAL 
					FROM DUAL;
				PV_FACTOR := 0;
				PRESENT_VALUE := 0;
				LC_OTH_RECOVERY := 0;
				LC_INT_DEDN := 0;
				LC_PRINC_DEDN := 0;
				EMI_NO := 0;

				FOR J IN PRD_INFO(LD_INT_FIRST_DATE)
				LOOP
					LD_CAL_FDATE := TO_DATE('01/01/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
					LD_CAL_TDATE := TO_DATE('31/12/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
					LI_NO_DAYS_IN_CAL_YR := LD_CAL_TDATE - LD_CAL_FDATE + 1;
					IF LC_LOAN_OP_BAL > 0 THEN
						LC_OTH_RECOVERY := 0;
						EMI_NO := EMI_NO + 1;
						LI_CNT1 := 0;
						LC_PRINC_DEDN := 0;
						LC_OTH_RECOVERY := 0;
						LC_INT_DEDN := 0;
						SELECT COUNT(1) INTO LI_CNT1 FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
						AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
						IF LI_CNT1 > 0 THEN
							SELECT SUM(CASE WHEN AMOUNT IS NULL THEN 0 ELSE AMOUNT END) 
							INTO LC_PRINC_DEDN FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
							AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
						ELSE
							LI_CNT1 := 0;
							SELECT COUNT(1) INTO LI_CNT1 FROM PAYROLL WHERE EMP_CODE = I.EMP_CODE 
							AND PRD_CODE = J.CODE;
							IF LI_CNT1 > 0 THEN
								SELECT AMOUNT INTO LC_PRINC_DEDN FROM PAYROLLDET 
								WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND 
								((REF_TYPE = 'L' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__DED);
							ELSE
								IF I.START_RECO <= J.FR_DATE THEN
									TOT_INST_DEDN := 0;
									TOT_INST_NO := 0;
									FOR K IN LOAN_INST_INFO(I.LOAN_NO)
									LOOP
										TOT_INST_NO := TOT_INST_NO + CASE WHEN K.NO_INST IS NULL THEN 999999 
											ELSE K.NO_INST END;
										IF TOT_INST_NO >= EMI_NO THEN
											LC_PRINC_DEDN := CASE WHEN LC_LOAN_OP_BAL > K.AMOUNT THEN K.AMOUNT ELSE LC_LOAN_OP_BAL END;
											EXIT;
										END IF;
									END LOOP;
								END IF;
							END IF;
						END IF;
						PV_FACTOR := 0;
						PRESENT_VALUE := 0;
						LC_OTH_RECOVERY := 0;
						LC_INT_DEDN := 0;
						LOAN_INT_CALC_STR := '';
						IF LI_CNT1 > 0 THEN
							SELECT AMOUNT INTO LC_INT_DEDN FROM PAYROLLDET WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND ((REF_TYPE = 'N' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__INT);
							FOR M IN LOAN_INT_CALC_INFO(I.LOAN_NO , J.CODE) 
							LOOP
								LOAN_INT_CALC_STR := LOAN_INT_CALC_STR || '[AI-' || M.REF_TYPE || '-' || 
									TRIM(TO_CHAR(M.AMOUNT)) || 
									'-' || TO_CHAR(M.DATE__FROM , 'DD-MON-YY') || '-' || 
									'-' || TO_CHAR(M.DATE__TO , 'DD-MON-YY') || '-' || 
									'-' || TRIM(TO_CHAR(M.NO_DAYS)) || '-' || 
									TRIM(TO_CHAR(M.INT_PERC)) || '-' || 
									TRIM(TO_CHAR(M.INTEREST_AMT__DIFF)) || ']';
							END LOOP;
						ELSE
							LC_INT_DEDN := ROUND((LC_LOAN_OP_BAL * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1),2);
							LOAN_INT_CALC_STR := LOAN_INT_CALC_STR || '[PI-LOANBL-' || 
								TRIM(TO_CHAR(LC_LOAN_OP_BAL)) || '-' || 
								TO_CHAR(CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END , 'DD-MON-YY') || '-' ||
								TO_CHAR(J.TO_DATE , 'DD-MON-YY') || '-' ||
								TRIM(TO_CHAR(((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1))) || '-' || 
								TRIM(TO_CHAR(I.INTEREST)) || '-' || 
								TRIM(TO_CHAR(LC_INT_DEDN)) || ']' ;
							
							FOR L IN LOAN_RECO_INFO(I.LOAN_NO, J.FR_DATE, J.TO_DATE)
							LOOP
								LC_INT_DEDN := LC_INT_DEDN - (ROUND((L.AMOUNT * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - L.TRAN_DATE) + 1),2));
								LOAN_INT_CALC_STR := LOAN_INT_CALC_STR || '[PI-LNRECO-' || 
									TRIM(TO_CHAR(L.AMOUNT)) || '-' || 
									TO_CHAR(L.TRAN_DATE , 'DD-MON-YY') || '-' ||
									TO_CHAR(J.TO_DATE , 'DD-MON-YY') || '-' ||
									TRIM(TO_CHAR(((J.TO_DATE - L.TRAN_DATE) + 1))) || '-' || 
									TRIM(TO_CHAR(I.INTEREST)) || '-' || 
									TRIM(TO_CHAR((ROUND((L.AMOUNT * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - L.TRAN_DATE) + 1),2)))) || ']' ;
							END LOOP;
							LC_INT_DEDN := CASE WHEN LC_INT_DEDN >= 0 THEN LC_INT_DEDN ELSE 0 END;
							IF TRIM(I.INT_TERM) = 'EMI' THEN
								LC_PRINC_DEDN := I.MON_INST - LC_INT_DEDN;
							ELSE
								LC_PRINC_DEDN := I.MON_INST;
							END IF;
						END IF;
						IF LC_PRINC_DEDN > LC_LOAN_OP_BAL THEN
							LC_PRINC_DEDN := LC_LOAN_OP_BAL;
						END IF;

						SELECT SUM(AMOUNT) INTO LC_OTH_RECOVERY FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE AND TRAN_TYPE NOT IN ('P');
						IF LC_OTH_RECOVERY IS NULL THEN 
							LC_OTH_RECOVERY := 0;
						END IF;

						AMORTISED_COST_OP_BAL := CASE WHEN EMI_NO = 1 THEN TOT_PRESENT_VALUE ELSE AMORTISED_COST_CL_BAL END;

						INTEREST_AT_EFF_RATE := ROUND((AMORTISED_COST_OP_BAL * LC_EFF_INT_RATE / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1),2);

						AMORTISED_COST_CL_BAL := AMORTISED_COST_OP_BAL + INTEREST_AT_EFF_RATE - (LC_PRINC_DEDN + LC_OTH_RECOVERY + LC_INT_DEDN);

						PV_FACTOR := ROUND(1 / POWER((1 + ROUND(LC_EFF_INT_RATE / 1200 , 4)),EMI_NO),4);
						PRESENT_VALUE := ROUND((LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) * PV_FACTOR , 2);

						EMP_BENEFIT := INTEREST_AT_EFF_RATE - LC_INT_DEDN;

						DIFF_PRINC_DEDN := (LC_LOAN_OP_BAL - (LC_PRINC_DEDN + LC_OTH_RECOVERY)) - AMORTISED_COST_CL_BAL;

						OUT_REC.ACCT_PRD_ARG := ACCT_PRD; 
						OUT_REC.ACCT_PRD_DATA := J.P_ACCT_PRD; 
						OUT_REC.PRD_CODE__FR := PRD_CODE__FR; 
						OUT_REC.PRD_CODE__TO := PRD_CODE__TO; 
						OUT_REC.FIN_ENTITY := I.FIN_ENTITY; 
						OUT_REC.EMP_CODE := I.EMP_CODE; 
						OUT_REC.EMP_FULL_NAME := I.EMP_FULL_NAME; 
						OUT_REC.PAY_SITE := I.PAY_SITE; 
						OUT_REC.CCTR_CODE__SAL := I.CCTR_CODE__SAL; 
						OUT_REC.LOAN_NO := I.LOAN_NO; 
						OUT_REC.SCHEME_NO := I.SCHEME_NO; 
						OUT_REC.SCHEME_TYPE := I.SCHEME_TYPE; 
						OUT_REC.ISSUE_DATE := I.ISSUE_DATE; 
						OUT_REC.LOAN_DISB_DATE := LD_INT_FIRST_DATE;
						OUT_REC.TERM := I.TERM; 
						OUT_REC.LOAN_AMT := I.LOAN_AMT; 
						OUT_REC.INTEREST := I.INTEREST; 
						OUT_REC.MON_INST := I.MON_INST; 
						OUT_REC.INT_TERM := I.INT_TERM; 
						OUT_REC.APPR_DATE := I.APPR_DATE; 
						OUT_REC.DATE__BALANCE := I.DATE__BALANCE; 
						OUT_REC.DATE__INTEREST := I.DATE__INTEREST; 
						OUT_REC.LOAN_TYPE := I.LOAN_TYPE; 
						OUT_REC.LOAN_CLOUSRE_DATE := LD_LOAN_CLOUSRE_DATE; 
						OUT_REC.ISA_EFF_INT_RATE := LC_EFF_INT_RATE; 
						OUT_REC.BALANCE_AMT := LC_LOAN_OP_BAL; 
						OUT_REC.LOAN_START_RECO_DATE := I.START_RECO; 

						OUT_REC.EMI_NO := EMI_NO; 
						OUT_REC.EMI_PRD_CODE := J.CODE; 
						OUT_REC.EMI_PRD_DESCR := TO_CHAR(J.FR_DATE , 'MON-YY'); 
						OUT_REC.OP_BALANCE_AMT := LC_LOAN_OP_BAL; 
						OUT_REC.INTEREST_AMT := LC_INT_DEDN; 
						OUT_REC.PRINC_CUM_INTEREST_AMT := (LC_LOAN_OP_BAL + LC_INT_DEDN); 
						OUT_REC.MON_DEDN := (LC_PRINC_DEDN + LC_INT_DEDN); 
						OUT_REC.PRINC_DEDN := LC_PRINC_DEDN; 
						OUT_REC.RECOVER_AMT := LC_OTH_RECOVERY; 
						OUT_REC.CL_BALANCE_AMT := LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY; 

						OUT_REC.PV_FACTOR := PV_FACTOR; 
						OUT_REC.PRESENT_VALUE := PRESENT_VALUE; 
						OUT_REC.AMORTISED_COST_OP_BAL := AMORTISED_COST_OP_BAL; 
						OUT_REC.INTEREST_AT_EFF_RATE := INTEREST_AT_EFF_RATE; 
						OUT_REC.REPAYMENT_INCL_INTEREST := (LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY); 
						OUT_REC.AMORTISED_COST_CL_BAL := AMORTISED_COST_CL_BAL; 
						OUT_REC.EMP_BENEFIT := EMP_BENEFIT; 
						OUT_REC.DIFF_PRINC_DEDN := DIFF_PRINC_DEDN; 
						OUT_REC.PRINC_DEDN := LC_PRINC_DEDN; 
						OUT_REC.LOAN_INT_CALC_STR := LOAN_INT_CALC_STR; 
						LC_LOAN_OP_BAL := LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY;
						pipe row ( out_rec ); 
					ELSE
						EXIT;
					END IF;
				END LOOP;
			END IF;
		END IF;
	END LOOP;

	RETURN ;
END;
/

--- F16ASUN005.End ---

--- F16ASUN014.Start ---

CREATE TABLE LOANSCHEME_INT_RATE
(
	SCHEME_TYPE CHAR(5) NOT NULL,
	EFF_FROM DATE NOT NULL,
	VALID_UPTO DATE NOT NULL,
	INT_RATE NUMBER(6,2) NOT NULL,
	REMARKS VARCHAR2(60),
	ADD_DATE DATE NOT NULL,
	ADD_USER VARCHAR2(10) NOT NULL,
	ADD_TERM VARCHAR2(15) NOT NULL,
	CHG_DATE DATE NOT NULL,
	CHG_USER VARCHAR2(10) NOT NULL,
	CHG_TERM VARCHAR2(15) NOT NULL
) TABLESPACE ITM_ADM_MST;

ALTER TABLE LOANSCHEME_INT_RATE ADD CONSTRAINT LOANSCHEME_INT_RATE_X PRIMARY KEY(SCHEME_TYPE, EFF_FROM);


--- F16ASUN014.End ---


--------------- DDL from ADM-RCP-DDL-V31.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V32.SQL.Start -------

--- SUN CCF No: IT2016-028 Request ID: A16DSUN001.Start --- 
ALTER TABLE DEPARTMENT ADD ITEM_SER CHAR(5);
ALTER TABLE DEPARTMENT ADD CONSTRAINT FK_DEPARTMENT_ITEM_SER FOREIGN KEY ( ITEM_SER ) REFERENCES ITEMSER ;
--- SUN CCF No: IT2016-028 Request ID: A16DSUN001.End --- 

--- F16ASUN005.Start ---

----- Modified on 17/06/2016.Start ----

CREATE TYPE TFO_LOAN_INT_INFO AS OBJECT 
(
	ACCT_PRD_ARG CHAR(6),
	ACCT_PRD_DATA CHAR(6),
	PRD_CODE__FR CHAR(6),
	PRD_CODE__TO CHAR(6),
	EMP_CODE CHAR(10),
	EMP_FULL_NAME VARCHAR2(120),
	PAY_SITE CHAR(5),
	FIN_ENTITY CHAR(10),
	CCTR_CODE__SAL CHAR(4),
	LOAN_NO CHAR(15),
	SCHEME_NO CHAR(10),
	SCHEME_TYPE CHAR(5),
	LOAN_AMT NUMBER(12,3),
	TERM NUMBER(3),
	INT_TERM CHAR(5),
	ISSUE_DATE DATE,
	LOAN_DISB_DATE DATE,
	LOAN_START_RECO_DATE DATE,
	LOAN_CLOUSRE_DATE DATE,
	MON_INST NUMBER(12,3),
	PRE_PAID_EMP_BENIFIT NUMBER(12,3),
	INTEREST NUMBER(6,2),
	ISA_EFF_INT_RATE NUMBER(6,2),
	APPR_DATE DATE,
	BALANCE_AMT NUMBER(12,3),
	DATE__BALANCE DATE,
	DATE__INTEREST DATE,
	LOAN_TYPE CHAR(1),
	EMI_NO NUMBER(10),
	EMI_PRD_CODE CHAR(6),
	EMI_PRD_DESCR VARCHAR2(10),
	OP_BALANCE_AMT NUMBER(12,3),
	INTEREST_AMT NUMBER(12,3),
	PRINC_CUM_INTEREST_AMT NUMBER(12,3),
	MON_DEDN NUMBER(12,3),
	RECOVER_AMT NUMBER(12,3),
	CL_BALANCE_AMT NUMBER(12,3),
	PRINC_DEDN NUMBER(12,3),
	PV_FACTOR NUMBER(10,4),
	PRESENT_VALUE NUMBER(12,3),
	AMORTISED_COST_OP_BAL NUMBER(12,3),
	INTEREST_AT_EFF_RATE NUMBER(12,3),
	REPAYMENT_INCL_INTEREST NUMBER(12,3),
	AMORTISED_COST_CL_BAL NUMBER(12,3),
	EMP_BENEFIT NUMBER(12,3),
	DIFF_PRINC_DEDN NUMBER(12,3),
	LOAN_INT_CALC_STR VARCHAR2(4000),
	REPAYMENT_INCL_INTEREST_1 NUMBER(12,3)
)
/
CREATE TYPE TFT_LOAN_INT_INFO AS TABLE OF TFO_LOAN_INT_INFO
/

CREATE OR REPLACE
FUNCTION FN_TF_LOAN_INT_INFO
	(
		FIN_ENTITY_CODE_FR FINENT.FIN_ENTITY%TYPE,
		FIN_ENTITY_CODE_TO FINENT.FIN_ENTITY%TYPE,
		ACCT_PRD ACCTPRD.CODE%TYPE,
		PRD_CODE__FR PERIOD.CODE%TYPE,
		PRD_CODE__TO PERIOD.CODE%TYPE,
		SITE_CODE__FR SITE.SITE_CODE%TYPE,
		SITE_CODE__TO SITE.SITE_CODE%TYPE,
		CCTR_CODE__FR EMPLOYEE.CCTR_CODE__SAL%TYPE,
		CCTR_CODE__TO EMPLOYEE.CCTR_CODE__SAL%TYPE,
		EMP_CODE__FR EMPLOYEE.EMP_CODE%TYPE, 
		EMP_CODE__TO EMPLOYEE.EMP_CODE%TYPE,
		EFF_INT_RATE LOANS.INTEREST%TYPE
	)
RETURN TFT_LOAN_INT_INFO 
PIPELINED IS 
OUT_REC TFO_LOAN_INT_INFO := TFO_LOAN_INT_INFO(	NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

LI_CNT NUMBER(6);
LI_CNT1 NUMBER(6);
LI_CNT2 NUMBER(6);
EMI_NO NUMBER(6);
TOT_INST_DEDN NUMBER(6);
TOT_INST_NO NUMBER(6);
LC_LOAN_OP_BAL LOANS.LOAN_AMT%TYPE;
LC_LOAN_RECO LOANS.LOAN_AMT%TYPE;
LD_LOAN_CLOUSRE_DATE DATE;
LD_INT_FIRST_DATE DATE;
LD_INT_LAST_DATE DATE;
EMI_PRD_CODE PERIOD.CODE%TYPE;
EMI_PRD_DESCR PERIOD.DESCR%TYPE;
PV_FACTOR NUMBER(12,4);
PRESENT_VALUE LOANS.LOAN_AMT%TYPE;
TOT_PRESENT_VALUE LOANS.LOAN_AMT%TYPE;
AMORTISED_COST_OP_BAL LOANS.LOAN_AMT%TYPE;
INTEREST_AT_EFF_RATE LOANS.LOAN_AMT%TYPE;
AMORTISED_COST_CL_BAL LOANS.LOAN_AMT%TYPE;
EMP_BENEFIT LOANS.LOAN_AMT%TYPE;
DIFF_PRINC_DEDN LOANS.LOAN_AMT%TYPE;
LC_PRINC_DEDN LOANS.LOAN_AMT%TYPE;
LC_INT_DEDN LOANS.LOAN_AMT%TYPE;
LC_OTH_RECOVERY LOANS.LOAN_AMT%TYPE;
LC_EFF_INT_RATE LOANS.INTEREST%TYPE;
LS_EXCLUDE_SCHEME_TYPE VARCHAR2(1024);
LOAN_INT_CALC_STR VARCHAR2(4000);
ARG_ACCT_PRD_CODE ACCTPRD.CODE%TYPE;
LD_CAL_FDATE ACCTPRD.FR_DATE%TYPE;
LD_CAL_TDATE ACCTPRD.TO_DATE%TYPE;
LI_NO_DAYS_IN_CAL_YR NUMBER(3);

CURSOR LOAN_INFO(AS_EXCLUDE_SCHEME_TYPE VARCHAR2) IS 
	SELECT 
	LN.EMP_CODE AS EMP_CODE ,
	TRIM(EM.EMP_FNAME) || ' ' || TRIM(EM.EMP_MNAME) || TRIM(EM.EMP_LNAME) AS EMP_FULL_NAME,
	EM.PAY_SITE AS PAY_SITE,
	EM.CCTR_CODE__SAL AS CCTR_CODE__SAL,
	LN.LOAN_NO AS LOAN_NO,
	LN.SCHEME_NO SCHEME_NO,
	LN.ISSUE_DATE AS ISSUE_DATE,
	LN.START_RECO AS START_RECO,
	LN.TERM AS TERM,
	LN.LOAN_AMT AS LOAN_AMT,
	LN.INTEREST AS INTEREST,
	LN.MON_INST AS MON_INST,
	LN.INT_TERM AS INT_TERM,
	LN.INTEREST_AMT AS INTEREST_AMT,
	LN.RECOVER_AMT AS RECOVER_AMT,
	LN.APPR_DATE AS APPR_DATE,
	LN.BALANCE_AMT AS BALANCE_AMT,
	LN.DATE__BALANCE AS DATE__BALANCE,
	LN.DATE__INTEREST AS DATE__INTEREST,
	LN.LOAN_TYPE AS LOAN_TYPE,
	LN.ACT_TERM AS ACT_TERM,
	AP.FR_DATE AS FY_FROM_DATE,
	AP.TO_DATE AS FY_TO_DATE,
	LS.AD_CODE__INT AS AD_CODE__INT,
	LS.AD_CODE__DED AS AD_CODE__DED,
	LS.SCHEME_TYPE AS SCHEME_TYPE,
	SM.FIN_ENTITY AS FIN_ENTITY
	FROM LOANS LN, EMPLOYEE EM, SITE SM, ACCTPRD AP, LOAN_SCHEME LS 
	WHERE EM.EMP_CODE = LN.EMP_CODE 
	AND LN.EMP_CODE >= EMP_CODE__FR 
	AND LN.EMP_CODE <= EMP_CODE__TO 
	AND EM.PAY_SITE >= SITE_CODE__FR 
	AND EM.PAY_SITE <= SITE_CODE__TO 
	AND SM.SITE_CODE = EM.PAY_SITE 
	--AND SM.FIN_ENTITY = FIN_ENTITY_CODE_FR 
	AND SM.FIN_ENTITY BETWEEN FIN_ENTITY_CODE_FR AND FIN_ENTITY_CODE_TO 
	AND LN.ISSUE_DATE <= AP.TO_DATE 
	AND AP.CODE = ACCT_PRD 
	AND LN.STATUS IN ('A','E')
	AND LS.SCHEME_NO = LN.SCHEME_NO 
	--AND LS.SCHEME_TYPE NOT IN ('A','B') 
	-- AND LS.SCHEME_TYPE NOT IN (AS_EXCLUDE_SCHEME_TYPE) 
	AND LS.SCHEME_TYPE NOT IN ( SELECT regexp_substr(AS_EXCLUDE_SCHEME_TYPE, '[^,]+', 1, LEVEL) 
		token FROM dual CONNECT BY LEVEL <= length(AS_EXCLUDE_SCHEME_TYPE) - 
			length(REPLACE(AS_EXCLUDE_SCHEME_TYPE, ',', '')) + 1) 
	ORDER BY SM.FIN_ENTITY,LN.EMP_CODE,LN.ISSUE_DATE;

CURSOR PRD_INFO(START_DATE DATE) IS SELECT A.CODE,A.FR_DATE,A.TO_DATE,
	A.ACCT_PRD AS P_ACCT_PRD,B.FR_DATE AS FY_FROM_DATE,B.TO_DATE AS FY_TO_DATE 
	FROM PERIOD A,ACCTPRD B
	WHERE B.CODE = A.ACCT_PRD AND A.TO_DATE >= START_DATE ORDER BY TO_DATE;

CURSOR LOAN_INST_INFO(ARG_LOAN_NO CHAR) IS SELECT * FROM LOANS_SCHEDULE 
	WHERE LOAN_NO = ARG_LOAN_NO  
	AND (NO_INST <> NO_INST_DED OR (NO_INST IS NULL AND PRD_CODE IS NULL)) ORDER BY LINE_NO ;

CURSOR LOAN_RECO_INFO(ARG_LOAN_NO CHAR , ARG_FR_DATE DATE , ARG_TO_DATE DATE) 
	IS SELECT * FROM LOAN_REG WHERE LOAN_NO = ARG_LOAN_NO 
	AND TRAN_DATE BETWEEN ARG_FR_DATE AND ARG_TO_DATE 
	AND AMOUNT <> 0 AND TRAN_TYPE NOT IN ('P') AND 
	CASE WHEN INT_CALCULATED IS NULL THEN 'N' ELSE INT_CALCULATED END = 'N' 
	ORDER BY TRAN_DATE;

CURSOR LOAN_INT_CALC_INFO(ARG_LOAN_NO CHAR , ARG_PRD_CODE CHAR) 
	IS SELECT * FROM LOANS_INTEREST_DET WHERE LOAN_NO = ARG_LOAN_NO 
	AND PRD_CODE = ARG_PRD_CODE ORDER BY PRD_CODE,LINE_NO;

BEGIN
	ARG_ACCT_PRD_CODE := ACCT_PRD;
	LI_CNT2 := 0;
	SELECT COUNT(1) INTO LI_CNT2 FROM PERIOD WHERE CODE BETWEEN PRD_CODE__FR AND PRD_CODE__TO 
		AND ACCT_PRD = ARG_ACCT_PRD_CODE;
	IF LI_CNT2 = 0 THEN
		RETURN;
	END IF;
	LI_CNT2 := 0;
	SELECT COUNT(1) INTO LI_CNT2 FROM PAYRPARM 
		WHERE PRD_CODE = '999999' AND VAR_NAME = 'IAS_LNREPO_EXCL_SCHM';
	IF LI_CNT2 > 0 THEN
		SELECT TRIM(VAR_VALUE) INTO LS_EXCLUDE_SCHEME_TYPE FROM PAYRPARM 
			WHERE PRD_CODE = '999999' AND VAR_NAME = 'IAS_LNREPO_EXCL_SCHM';
	ELSE
		LS_EXCLUDE_SCHEME_TYPE := '';
	END IF;
	IF LS_EXCLUDE_SCHEME_TYPE IS NULL OR LENGTH(TRIM(LS_EXCLUDE_SCHEME_TYPE)) = 0 THEN
		LS_EXCLUDE_SCHEME_TYPE := '**********';
	END IF;
	DBMS_OUTPUT.PUT_LINE(LS_EXCLUDE_SCHEME_TYPE);
	LI_CNT2 := 0;
	FOR I IN LOAN_INFO(LS_EXCLUDE_SCHEME_TYPE)
	LOOP
		LI_CNT2 := LI_CNT2 + 1;
		LI_CNT := 0;
		LC_LOAN_OP_BAL := I.LOAN_AMT;
		SELECT SUM(AMOUNT) INTO LC_LOAN_RECO FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
		AND TRAN_DATE < I.FY_FROM_DATE;
		IF LC_LOAN_RECO IS NOT NULL THEN 
			LC_LOAN_OP_BAL := LC_LOAN_OP_BAL - LC_LOAN_RECO;
		END IF;
		LI_CNT1 := 0;
		SELECT COUNT(1), MIN(FROM_DATE) INTO LI_CNT1, LD_INT_FIRST_DATE FROM LOAN_INT_REG WHERE LOAN_NO=I.LOAN_NO ;
		IF LI_CNT1 > 0 THEN
			LD_INT_LAST_DATE := I.DATE__INTEREST + 1;
		ELSE
			LD_INT_LAST_DATE := I.DATE__INTEREST;
			LD_INT_FIRST_DATE := I.DATE__INTEREST;
		END IF;
		LI_CNT1 := 0;
		SELECT CASE WHEN LD_INT_FIRST_DATE > (SELECT TO_DATE FROM PERIOD 
			WHERE CODE = PRD_CODE__TO) THEN 0 ELSE LC_LOAN_OP_BAL END INTO LC_LOAN_OP_BAL 
			FROM DUAL;
		SELECT SUM(INT_RATE) INTO LC_EFF_INT_RATE FROM LOANSCHEME_INT_RATE 
		WHERE SCHEME_TYPE = I.SCHEME_TYPE AND LD_INT_FIRST_DATE BETWEEN EFF_FROM AND VALID_UPTO;
		IF LC_EFF_INT_RATE IS NULL THEN 
			LC_EFF_INT_RATE := CASE WHEN EFF_INT_RATE IS NULL OR EFF_INT_RATE <= 0 THEN 
			I.INTEREST ELSE EFF_INT_RATE END;
		END IF;
		IF LC_EFF_INT_RATE <= I.INTEREST THEN 
			LC_LOAN_OP_BAL := 0;
		END IF;
		IF LC_LOAN_OP_BAL > 0 THEN
			EMI_NO := 0;
			TOT_PRESENT_VALUE := 0;
			LC_LOAN_OP_BAL := I.LOAN_AMT;

			FOR J IN PRD_INFO(LD_INT_FIRST_DATE)
			LOOP
				LD_CAL_FDATE := TO_DATE('01/01/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
				LD_CAL_TDATE := TO_DATE('31/12/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
				LI_NO_DAYS_IN_CAL_YR := LD_CAL_TDATE - LD_CAL_FDATE + 1;
				LI_NO_DAYS_IN_CAL_YR := 365; -- Modified by Piyush on 17/06/2016 as per ERP
				IF LC_LOAN_OP_BAL > 0 THEN
					EMI_NO := EMI_NO + 1;
					LI_CNT1 := 0;
					LC_PRINC_DEDN := 0;
					SELECT COUNT(1) INTO LI_CNT1 FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
					AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
					IF LI_CNT1 > 0 THEN
						SELECT SUM(CASE WHEN AMOUNT IS NULL THEN 0 ELSE AMOUNT END) 
						INTO LC_PRINC_DEDN FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
						AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
					ELSE
						LI_CNT1 := 0;
						SELECT COUNT(1) INTO LI_CNT1 FROM PAYROLL WHERE EMP_CODE = I.EMP_CODE 
						AND PRD_CODE = J.CODE;
						IF LI_CNT1 > 0 THEN
							SELECT AMOUNT INTO LC_PRINC_DEDN FROM PAYROLLDET 
							WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND 
							((REF_TYPE = 'L' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__DED);
						ELSE
							IF I.START_RECO <= J.FR_DATE THEN
								TOT_INST_DEDN := 0;
								TOT_INST_NO := 0;
								FOR K IN LOAN_INST_INFO(I.LOAN_NO)
								LOOP
									TOT_INST_NO := TOT_INST_NO + CASE WHEN K.NO_INST IS NULL THEN 9999 
										ELSE K.NO_INST END;
									IF TOT_INST_NO >= EMI_NO THEN
										LC_PRINC_DEDN := CASE WHEN LC_LOAN_OP_BAL > K.AMOUNT THEN K.AMOUNT ELSE LC_LOAN_OP_BAL END;
										EXIT;
									END IF;
								END LOOP;
							END IF;
						END IF;
					END IF;
					PV_FACTOR := 0;
					PRESENT_VALUE := 0;
					LC_OTH_RECOVERY := 0;
					LC_INT_DEDN := 0;
					IF LI_CNT1 > 0 THEN
						SELECT AMOUNT INTO LC_INT_DEDN FROM PAYROLLDET WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND ((REF_TYPE = 'N' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__INT);
					ELSE
						LC_INT_DEDN := ROUND((LC_LOAN_OP_BAL * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1),2);
						FOR L IN LOAN_RECO_INFO(I.LOAN_NO, J.FR_DATE, J.TO_DATE)
						LOOP
							LC_INT_DEDN := LC_INT_DEDN - (ROUND((L.AMOUNT * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - L.TRAN_DATE) + 1),2));
						END LOOP;
						LC_INT_DEDN := CASE WHEN LC_INT_DEDN >= 0 THEN LC_INT_DEDN ELSE 0 END;
						IF TRIM(I.INT_TERM) = 'EMI' THEN
							LC_PRINC_DEDN := I.MON_INST - LC_INT_DEDN;
						ELSE
							LC_PRINC_DEDN := I.MON_INST;
						END IF;
					END IF;
					IF LC_PRINC_DEDN > LC_LOAN_OP_BAL THEN
						LC_PRINC_DEDN := LC_LOAN_OP_BAL;
					END IF;

					SELECT SUM(AMOUNT) INTO LC_OTH_RECOVERY FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE AND TRAN_TYPE NOT IN ('P');
					IF LC_OTH_RECOVERY IS NULL THEN 
						LC_OTH_RECOVERY := 0;
					END IF;
					PV_FACTOR := ROUND(1 / POWER((1 + ROUND(LC_EFF_INT_RATE / 1200 , 4)),EMI_NO),4);
					PRESENT_VALUE := ROUND((LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) * PV_FACTOR , 2);
					TOT_PRESENT_VALUE := TOT_PRESENT_VALUE + PRESENT_VALUE;
					LC_LOAN_OP_BAL := LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY;
					LD_LOAN_CLOUSRE_DATE := J.TO_DATE;
				ELSE
					EXIT;
				END IF;
			END LOOP;

			IF LD_LOAN_CLOUSRE_DATE >= I.FY_FROM_DATE THEN
				LC_LOAN_OP_BAL := I.LOAN_AMT;
				LI_CNT1 := 0;
				SELECT CASE WHEN LD_INT_FIRST_DATE > (SELECT TO_DATE FROM PERIOD 
					WHERE CODE = PRD_CODE__TO) THEN 0 ELSE LC_LOAN_OP_BAL END INTO LC_LOAN_OP_BAL 
					FROM DUAL;
				PV_FACTOR := 0;
				PRESENT_VALUE := 0;
				LC_OTH_RECOVERY := 0;
				LC_INT_DEDN := 0;
				LC_PRINC_DEDN := 0;
				EMI_NO := 0;

				FOR J IN PRD_INFO(LD_INT_FIRST_DATE)
				LOOP
					LD_CAL_FDATE := TO_DATE('01/01/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
					LD_CAL_TDATE := TO_DATE('31/12/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
					LI_NO_DAYS_IN_CAL_YR := LD_CAL_TDATE - LD_CAL_FDATE + 1;
					LI_NO_DAYS_IN_CAL_YR := 365;  -- Modified by Piyush on 17/06/2016 as per ERP
					IF LC_LOAN_OP_BAL > 0 THEN
						LC_OTH_RECOVERY := 0;
						EMI_NO := EMI_NO + 1;
						LI_CNT1 := 0;
						LC_PRINC_DEDN := 0;
						LC_OTH_RECOVERY := 0;
						LC_INT_DEDN := 0;
						SELECT COUNT(1) INTO LI_CNT1 FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
						AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
						IF LI_CNT1 > 0 THEN
							SELECT SUM(CASE WHEN AMOUNT IS NULL THEN 0 ELSE AMOUNT END) 
							INTO LC_PRINC_DEDN FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
							AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
						ELSE
							LI_CNT1 := 0;
							SELECT COUNT(1) INTO LI_CNT1 FROM PAYROLL WHERE EMP_CODE = I.EMP_CODE 
							AND PRD_CODE = J.CODE;
							IF LI_CNT1 > 0 THEN
								SELECT AMOUNT INTO LC_PRINC_DEDN FROM PAYROLLDET 
								WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND 
								((REF_TYPE = 'L' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__DED);
							ELSE
								IF I.START_RECO <= J.FR_DATE THEN
									TOT_INST_DEDN := 0;
									TOT_INST_NO := 0;
									FOR K IN LOAN_INST_INFO(I.LOAN_NO)
									LOOP
										TOT_INST_NO := TOT_INST_NO + CASE WHEN K.NO_INST IS NULL THEN 999999 
											ELSE K.NO_INST END;
										IF TOT_INST_NO >= EMI_NO THEN
											LC_PRINC_DEDN := CASE WHEN LC_LOAN_OP_BAL > K.AMOUNT THEN K.AMOUNT ELSE LC_LOAN_OP_BAL END;
											EXIT;
										END IF;
									END LOOP;
								END IF;
							END IF;
						END IF;
						PV_FACTOR := 0;
						PRESENT_VALUE := 0;
						LC_OTH_RECOVERY := 0;
						LC_INT_DEDN := 0;
						LOAN_INT_CALC_STR := '';
						-- Modified to calculate interest as per ERP.Start
						INTEREST_AT_EFF_RATE := 0.00;
						-- Modified to calculate interest as per ERP.End

						IF LI_CNT1 > 0 THEN
							SELECT AMOUNT INTO LC_INT_DEDN FROM PAYROLLDET WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND ((REF_TYPE = 'N' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__INT);
							FOR M IN LOAN_INT_CALC_INFO(I.LOAN_NO , J.CODE) 
							LOOP
								LOAN_INT_CALC_STR := LOAN_INT_CALC_STR || '[AI-' || M.REF_TYPE || '-' || 
									TRIM(TO_CHAR(M.AMOUNT)) || 
									'-' || TO_CHAR(M.DATE__FROM , 'DD-MON-YY') || '-' || 
									'-' || TO_CHAR(M.DATE__TO , 'DD-MON-YY') || '-' || 
									'-' || TRIM(TO_CHAR(M.NO_DAYS)) || '-' || 
									TRIM(TO_CHAR(M.INT_PERC)) || '-' || 
									TRIM(TO_CHAR(M.INTEREST_AMT__DIFF)) || ']';
							END LOOP;
						ELSE
							LC_INT_DEDN := ROUND((LC_LOAN_OP_BAL * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1),2);
							LOAN_INT_CALC_STR := LOAN_INT_CALC_STR || '[PI-LOANBL-' || 
								TRIM(TO_CHAR(LC_LOAN_OP_BAL)) || '-' || 
								TO_CHAR(CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END , 'DD-MON-YY') || '-' ||
								TO_CHAR(J.TO_DATE , 'DD-MON-YY') || '-' ||
								TRIM(TO_CHAR(((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1))) || '-' || 
								TRIM(TO_CHAR(I.INTEREST)) || '-' || 
								TRIM(TO_CHAR(LC_INT_DEDN)) || ']' ;
							
							FOR L IN LOAN_RECO_INFO(I.LOAN_NO, J.FR_DATE, J.TO_DATE)
							LOOP
								LC_INT_DEDN := LC_INT_DEDN - (ROUND((L.AMOUNT * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - L.TRAN_DATE) + 1),2));
								LOAN_INT_CALC_STR := LOAN_INT_CALC_STR || '[PI-LNRECO-' || 
									TRIM(TO_CHAR(L.AMOUNT)) || '-' || 
									TO_CHAR(L.TRAN_DATE , 'DD-MON-YY') || '-' ||
									TO_CHAR(J.TO_DATE , 'DD-MON-YY') || '-' ||
									TRIM(TO_CHAR(((J.TO_DATE - L.TRAN_DATE) + 1))) || '-' || 
									TRIM(TO_CHAR(I.INTEREST)) || '-' || 
									TRIM(TO_CHAR((ROUND((L.AMOUNT * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - L.TRAN_DATE) + 1),2)))) || ']' ;
								-- Modified to calculate interest as per ERP.Start
								INTEREST_AT_EFF_RATE := INTEREST_AT_EFF_RATE - (ROUND((L.AMOUNT * LC_EFF_INT_RATE / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - L.TRAN_DATE) + 1),2));
								-- Modified to calculate interest as per ERP.End
							END LOOP;
							LC_INT_DEDN := CASE WHEN LC_INT_DEDN >= 0 THEN LC_INT_DEDN ELSE 0 END;
							IF TRIM(I.INT_TERM) = 'EMI' THEN
								LC_PRINC_DEDN := I.MON_INST - LC_INT_DEDN;
							ELSE
								LC_PRINC_DEDN := I.MON_INST;
							END IF;
						END IF;
						IF LC_PRINC_DEDN > LC_LOAN_OP_BAL THEN
							LC_PRINC_DEDN := LC_LOAN_OP_BAL;
						END IF;

						SELECT SUM(AMOUNT) INTO LC_OTH_RECOVERY FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE AND TRAN_TYPE NOT IN ('P');
						IF LC_OTH_RECOVERY IS NULL THEN 
							LC_OTH_RECOVERY := 0;
						END IF;

						AMORTISED_COST_OP_BAL := CASE WHEN EMI_NO = 1 THEN TOT_PRESENT_VALUE ELSE AMORTISED_COST_CL_BAL END;

						-- Commented and shofted above to calculate interest as per ERP logic
						-- INTEREST_AT_EFF_RATE := ROUND((AMORTISED_COST_OP_BAL * LC_EFF_INT_RATE / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1),2);

						INTEREST_AT_EFF_RATE := INTEREST_AT_EFF_RATE + (ROUND((AMORTISED_COST_OP_BAL * LC_EFF_INT_RATE / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1),2));

						-- Commented and modified bellow to set cl bal 0 on clauser of loan.Start
						--AMORTISED_COST_CL_BAL := AMORTISED_COST_OP_BAL + INTEREST_AT_EFF_RATE - (LC_PRINC_DEDN + LC_OTH_RECOVERY + LC_INT_DEDN);

						if LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY > 0 then
							AMORTISED_COST_CL_BAL := AMORTISED_COST_OP_BAL + INTEREST_AT_EFF_RATE - (LC_PRINC_DEDN + LC_OTH_RECOVERY + LC_INT_DEDN);
						else
							AMORTISED_COST_CL_BAL := 0;
						end if;
						-- Commented and modified bellow to set cl bal 0 on clauser of loan.End

						PV_FACTOR := ROUND(1 / POWER((1 + ROUND(LC_EFF_INT_RATE / 1200 , 4)),EMI_NO),4);
						PRESENT_VALUE := ROUND((LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) * PV_FACTOR , 2);

						EMP_BENEFIT := INTEREST_AT_EFF_RATE - LC_INT_DEDN;

						DIFF_PRINC_DEDN := (LC_LOAN_OP_BAL - (LC_PRINC_DEDN + LC_OTH_RECOVERY)) - AMORTISED_COST_CL_BAL;

						OUT_REC.ACCT_PRD_ARG := ACCT_PRD; 
						OUT_REC.ACCT_PRD_DATA := J.P_ACCT_PRD; 
						OUT_REC.PRD_CODE__FR := PRD_CODE__FR; 
						OUT_REC.PRD_CODE__TO := PRD_CODE__TO; 
						OUT_REC.FIN_ENTITY := I.FIN_ENTITY; 
						OUT_REC.EMP_CODE := I.EMP_CODE; 
						OUT_REC.EMP_FULL_NAME := I.EMP_FULL_NAME; 
						OUT_REC.PAY_SITE := I.PAY_SITE; 
						OUT_REC.CCTR_CODE__SAL := I.CCTR_CODE__SAL; 
						OUT_REC.LOAN_NO := I.LOAN_NO; 
						OUT_REC.SCHEME_NO := I.SCHEME_NO; 
						OUT_REC.SCHEME_TYPE := I.SCHEME_TYPE; 
						OUT_REC.ISSUE_DATE := I.ISSUE_DATE; 
						OUT_REC.LOAN_DISB_DATE := LD_INT_FIRST_DATE;
						OUT_REC.TERM := I.TERM; 
						OUT_REC.LOAN_AMT := I.LOAN_AMT; 
						OUT_REC.INTEREST := I.INTEREST; 
						OUT_REC.MON_INST := I.MON_INST; 
						OUT_REC.INT_TERM := I.INT_TERM; 
						OUT_REC.APPR_DATE := I.APPR_DATE; 
						OUT_REC.DATE__BALANCE := I.DATE__BALANCE; 
						OUT_REC.DATE__INTEREST := I.DATE__INTEREST; 
						OUT_REC.LOAN_TYPE := I.LOAN_TYPE; 
						OUT_REC.LOAN_CLOUSRE_DATE := LD_LOAN_CLOUSRE_DATE; 
						OUT_REC.ISA_EFF_INT_RATE := LC_EFF_INT_RATE; 
						OUT_REC.BALANCE_AMT := LC_LOAN_OP_BAL; 
						OUT_REC.LOAN_START_RECO_DATE := I.START_RECO; 

						OUT_REC.EMI_NO := EMI_NO; 
						OUT_REC.EMI_PRD_CODE := J.CODE; 
						OUT_REC.EMI_PRD_DESCR := TO_CHAR(J.FR_DATE , 'MON-YY'); 
						OUT_REC.OP_BALANCE_AMT := LC_LOAN_OP_BAL; 
						OUT_REC.INTEREST_AMT := LC_INT_DEDN; 
						OUT_REC.PRINC_CUM_INTEREST_AMT := (LC_LOAN_OP_BAL + LC_INT_DEDN); 
						OUT_REC.MON_DEDN := (LC_PRINC_DEDN + LC_INT_DEDN); 
						OUT_REC.PRINC_DEDN := LC_PRINC_DEDN; 
						OUT_REC.RECOVER_AMT := LC_OTH_RECOVERY; 
						OUT_REC.CL_BALANCE_AMT := LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY; 

						OUT_REC.PV_FACTOR := PV_FACTOR; 
						OUT_REC.PRESENT_VALUE := PRESENT_VALUE; 
						OUT_REC.AMORTISED_COST_OP_BAL := AMORTISED_COST_OP_BAL; 
						OUT_REC.INTEREST_AT_EFF_RATE := INTEREST_AT_EFF_RATE; 
						OUT_REC.REPAYMENT_INCL_INTEREST := (LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) ; 
						OUT_REC.AMORTISED_COST_CL_BAL := AMORTISED_COST_CL_BAL; 
						OUT_REC.EMP_BENEFIT := EMP_BENEFIT; 
						OUT_REC.DIFF_PRINC_DEDN := DIFF_PRINC_DEDN; 
						OUT_REC.PRINC_DEDN := LC_PRINC_DEDN; 
						OUT_REC.LOAN_INT_CALC_STR := LOAN_INT_CALC_STR; 
						OUT_REC.REPAYMENT_INCL_INTEREST_1 := CASE WHEN LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY > 0 THEN (LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) ELSE AMORTISED_COST_OP_BAL + INTEREST_AT_EFF_RATE END; 
						LC_LOAN_OP_BAL := LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY;
						pipe row ( out_rec ); 
					ELSE
						EXIT;
					END IF;
				END LOOP;
			END IF;
		END IF;
	END LOOP;

	RETURN ;
END;
/

----- Modified on 17/06/2016.End ----

----- Modified on 12/07/2016.Start ----

CREATE OR REPLACE
FUNCTION FN_TF_LOAN_INT_INFO
	(
		FIN_ENTITY_CODE_FR FINENT.FIN_ENTITY%TYPE,
		FIN_ENTITY_CODE_TO FINENT.FIN_ENTITY%TYPE,
		ACCT_PRD ACCTPRD.CODE%TYPE,
		PRD_CODE__FR PERIOD.CODE%TYPE,
		PRD_CODE__TO PERIOD.CODE%TYPE,
		SITE_CODE__FR SITE.SITE_CODE%TYPE,
		SITE_CODE__TO SITE.SITE_CODE%TYPE,
		CCTR_CODE__FR EMPLOYEE.CCTR_CODE__SAL%TYPE,
		CCTR_CODE__TO EMPLOYEE.CCTR_CODE__SAL%TYPE,
		EMP_CODE__FR EMPLOYEE.EMP_CODE%TYPE, 
		EMP_CODE__TO EMPLOYEE.EMP_CODE%TYPE,
		EFF_INT_RATE LOANS.INTEREST%TYPE
	)
RETURN TFT_LOAN_INT_INFO 
PIPELINED IS 
OUT_REC TFO_LOAN_INT_INFO := TFO_LOAN_INT_INFO(	NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
		NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

LI_CNT NUMBER(6);
LI_CNT1 NUMBER(6);
LI_CNT2 NUMBER(6);
EMI_NO NUMBER(6);
TOT_INST_DEDN NUMBER(6);
TOT_INST_NO NUMBER(6);
LC_LOAN_OP_BAL LOANS.LOAN_AMT%TYPE;
LC_LOAN_RECO LOANS.LOAN_AMT%TYPE;
LD_LOAN_CLOUSRE_DATE DATE;
LD_INT_FIRST_DATE DATE;
LD_INT_LAST_DATE DATE;
EMI_PRD_CODE PERIOD.CODE%TYPE;
EMI_PRD_DESCR PERIOD.DESCR%TYPE;
PV_FACTOR NUMBER(12,4);
PRESENT_VALUE LOANS.LOAN_AMT%TYPE;
TOT_PRESENT_VALUE LOANS.LOAN_AMT%TYPE;
AMORTISED_COST_OP_BAL LOANS.LOAN_AMT%TYPE;
INTEREST_AT_EFF_RATE LOANS.LOAN_AMT%TYPE;
AMORTISED_COST_CL_BAL LOANS.LOAN_AMT%TYPE;
EMP_BENEFIT LOANS.LOAN_AMT%TYPE;
DIFF_PRINC_DEDN LOANS.LOAN_AMT%TYPE;
LC_PRINC_DEDN LOANS.LOAN_AMT%TYPE;
LC_INT_DEDN LOANS.LOAN_AMT%TYPE;
LC_OTH_RECOVERY LOANS.LOAN_AMT%TYPE;
LC_EFF_INT_RATE LOANS.INTEREST%TYPE;
LS_EXCLUDE_SCHEME_TYPE VARCHAR2(1024);
LOAN_INT_CALC_STR VARCHAR2(4000);
ARG_ACCT_PRD_CODE ACCTPRD.CODE%TYPE;
LD_CAL_FDATE ACCTPRD.FR_DATE%TYPE;
LD_CAL_TDATE ACCTPRD.TO_DATE%TYPE;
LI_NO_DAYS_IN_CAL_YR NUMBER(3);
LC_TEMP_RECO LOANS.LOAN_AMT%TYPE;
LC_TEMP_BAL LOANS.LOAN_AMT%TYPE;
LC_PROJ_INST LOANS.LOAN_AMT%TYPE;

CURSOR LOAN_INFO(AS_EXCLUDE_SCHEME_TYPE VARCHAR2) IS 
	SELECT 
	LN.EMP_CODE AS EMP_CODE ,
	TRIM(EM.EMP_FNAME) || ' ' || TRIM(EM.EMP_MNAME) || TRIM(EM.EMP_LNAME) AS EMP_FULL_NAME,
	EM.PAY_SITE AS PAY_SITE,
	EM.CCTR_CODE__SAL AS CCTR_CODE__SAL,
	LN.LOAN_NO AS LOAN_NO,
	LN.SCHEME_NO SCHEME_NO,
	LN.ISSUE_DATE AS ISSUE_DATE,
	LN.START_RECO AS START_RECO,
	LN.TERM AS TERM,
	LN.LOAN_AMT AS LOAN_AMT,
	LN.INTEREST AS INTEREST,
	LN.MON_INST AS MON_INST,
	LN.INT_TERM AS INT_TERM,
	LN.INTEREST_AMT AS INTEREST_AMT,
	LN.RECOVER_AMT AS RECOVER_AMT,
	LN.APPR_DATE AS APPR_DATE,
	LN.BALANCE_AMT AS BALANCE_AMT,
	LN.DATE__BALANCE AS DATE__BALANCE,
	LN.DATE__INTEREST AS DATE__INTEREST,
	LN.LOAN_TYPE AS LOAN_TYPE,
	LN.ACT_TERM AS ACT_TERM,
	AP.FR_DATE AS FY_FROM_DATE,
	AP.TO_DATE AS FY_TO_DATE,
	LS.AD_CODE__INT AS AD_CODE__INT,
	LS.AD_CODE__DED AS AD_CODE__DED,
	LS.SCHEME_TYPE AS SCHEME_TYPE,
	SM.FIN_ENTITY AS FIN_ENTITY
	FROM LOANS LN, EMPLOYEE EM, SITE SM, ACCTPRD AP, LOAN_SCHEME LS 
	WHERE EM.EMP_CODE = LN.EMP_CODE 
	AND LN.EMP_CODE >= EMP_CODE__FR 
	AND LN.EMP_CODE <= EMP_CODE__TO 
	AND EM.PAY_SITE >= SITE_CODE__FR 
	AND EM.PAY_SITE <= SITE_CODE__TO 
	AND SM.SITE_CODE = EM.PAY_SITE 
	--AND SM.FIN_ENTITY = FIN_ENTITY_CODE_FR 
	AND SM.FIN_ENTITY BETWEEN FIN_ENTITY_CODE_FR AND FIN_ENTITY_CODE_TO 
	AND LN.ISSUE_DATE <= AP.TO_DATE 
	AND AP.CODE = ACCT_PRD 
	AND LN.STATUS IN ('A','E')
	AND LS.SCHEME_NO = LN.SCHEME_NO 
	--AND LS.SCHEME_TYPE NOT IN ('A','B') 
	-- AND LS.SCHEME_TYPE NOT IN (AS_EXCLUDE_SCHEME_TYPE) 
	AND LS.SCHEME_TYPE NOT IN ( SELECT regexp_substr(AS_EXCLUDE_SCHEME_TYPE, '[^,]+', 1, LEVEL) 
		token FROM dual CONNECT BY LEVEL <= length(AS_EXCLUDE_SCHEME_TYPE) - 
			length(REPLACE(AS_EXCLUDE_SCHEME_TYPE, ',', '')) + 1) 
	ORDER BY SM.FIN_ENTITY,LN.EMP_CODE,LN.ISSUE_DATE;

CURSOR PRD_INFO(START_DATE DATE) IS SELECT A.CODE,A.FR_DATE,A.TO_DATE,
	A.ACCT_PRD AS P_ACCT_PRD,B.FR_DATE AS FY_FROM_DATE,B.TO_DATE AS FY_TO_DATE 
	FROM PERIOD A,ACCTPRD B
	WHERE B.CODE = A.ACCT_PRD AND A.TO_DATE >= START_DATE ORDER BY TO_DATE;

CURSOR LOAN_INST_INFO(ARG_LOAN_NO CHAR) IS SELECT * FROM LOANS_SCHEDULE 
	WHERE LOAN_NO = ARG_LOAN_NO  
	AND (NO_INST <> NO_INST_DED OR (NO_INST IS NULL AND PRD_CODE IS NULL)) ORDER BY LINE_NO ;

CURSOR LOAN_RECO_INFO(ARG_LOAN_NO CHAR , ARG_FR_DATE DATE , ARG_TO_DATE DATE) 
	IS SELECT * FROM LOAN_REG WHERE LOAN_NO = ARG_LOAN_NO 
	AND TRAN_DATE BETWEEN ARG_FR_DATE AND ARG_TO_DATE 
	AND AMOUNT <> 0 AND TRAN_TYPE NOT IN ('P') AND 
	CASE WHEN INT_CALCULATED IS NULL THEN 'N' ELSE INT_CALCULATED END = 'N' 
	ORDER BY TRAN_DATE;

CURSOR LOAN_INT_CALC_INFO(ARG_LOAN_NO CHAR , ARG_PRD_CODE CHAR) 
	IS SELECT * FROM LOANS_INTEREST_DET WHERE LOAN_NO = ARG_LOAN_NO 
	AND PRD_CODE = ARG_PRD_CODE ORDER BY PRD_CODE,LINE_NO;

BEGIN
	ARG_ACCT_PRD_CODE := ACCT_PRD;
	LI_CNT2 := 0;
	SELECT COUNT(1) INTO LI_CNT2 FROM PERIOD WHERE CODE BETWEEN PRD_CODE__FR AND PRD_CODE__TO 
		AND ACCT_PRD = ARG_ACCT_PRD_CODE;
	IF LI_CNT2 = 0 THEN
		RETURN;
	END IF;
	LI_CNT2 := 0;
	SELECT COUNT(1) INTO LI_CNT2 FROM PAYRPARM 
		WHERE PRD_CODE = '999999' AND VAR_NAME = 'IAS_LNREPO_EXCL_SCHM';
	IF LI_CNT2 > 0 THEN
		SELECT TRIM(VAR_VALUE) INTO LS_EXCLUDE_SCHEME_TYPE FROM PAYRPARM 
			WHERE PRD_CODE = '999999' AND VAR_NAME = 'IAS_LNREPO_EXCL_SCHM';
	ELSE
		LS_EXCLUDE_SCHEME_TYPE := '';
	END IF;
	IF LS_EXCLUDE_SCHEME_TYPE IS NULL OR LENGTH(TRIM(LS_EXCLUDE_SCHEME_TYPE)) = 0 THEN
		LS_EXCLUDE_SCHEME_TYPE := '**********';
	END IF;
	--DBMS_OUTPUT.PUT_LINE(LS_EXCLUDE_SCHEME_TYPE);
	LI_CNT2 := 0;
	FOR I IN LOAN_INFO(LS_EXCLUDE_SCHEME_TYPE)
	LOOP
		LI_CNT2 := LI_CNT2 + 1;
		LI_CNT := 0;
		LC_PROJ_INST := 0.00;
		LC_LOAN_OP_BAL := I.LOAN_AMT;
		SELECT SUM(AMOUNT) INTO LC_LOAN_RECO FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
		AND TRAN_DATE < I.FY_FROM_DATE;
		IF LC_LOAN_RECO IS NOT NULL THEN 
			LC_LOAN_OP_BAL := LC_LOAN_OP_BAL - LC_LOAN_RECO;
		END IF;
		LI_CNT1 := 0;
		SELECT COUNT(1), MIN(FROM_DATE) INTO LI_CNT1, LD_INT_FIRST_DATE FROM LOAN_INT_REG WHERE LOAN_NO=I.LOAN_NO ;
		IF LI_CNT1 > 0 THEN
			LD_INT_LAST_DATE := I.DATE__INTEREST + 1;
		ELSE
			LD_INT_LAST_DATE := I.DATE__INTEREST;
			LD_INT_FIRST_DATE := I.DATE__INTEREST;
		END IF;
		LI_CNT1 := 0;
		SELECT CASE WHEN LD_INT_FIRST_DATE > (SELECT TO_DATE FROM PERIOD 
			WHERE CODE = PRD_CODE__TO) THEN 0 ELSE LC_LOAN_OP_BAL END INTO LC_LOAN_OP_BAL 
			FROM DUAL;
		SELECT SUM(INT_RATE) INTO LC_EFF_INT_RATE FROM LOANSCHEME_INT_RATE 
		WHERE SCHEME_TYPE = I.SCHEME_TYPE AND LD_INT_FIRST_DATE BETWEEN EFF_FROM AND VALID_UPTO;
		IF LC_EFF_INT_RATE IS NULL THEN 
			LC_EFF_INT_RATE := CASE WHEN EFF_INT_RATE IS NULL OR EFF_INT_RATE <= 0 THEN 
			I.INTEREST ELSE EFF_INT_RATE END;
		END IF;
		IF LC_EFF_INT_RATE <= I.INTEREST THEN 
			LC_LOAN_OP_BAL := 0;
		END IF;
		--DBMS_OUTPUT.PUT_LINE('EMP CODE [' || TRIM(I.EMP_CODE) || '] LOAN NO [' || I.LOAN_NO || '] OP BALANCE [' || TRIM(TO_CHAR(LC_LOAN_OP_BAL)) || ']');
		IF LC_LOAN_OP_BAL > 0 THEN
			EMI_NO := 0;
			TOT_PRESENT_VALUE := 0;
			LC_LOAN_OP_BAL := I.LOAN_AMT;

			FOR J IN PRD_INFO(LD_INT_FIRST_DATE)
			LOOP
				LD_CAL_FDATE := TO_DATE('01/01/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
				LD_CAL_TDATE := TO_DATE('31/12/' || TO_CHAR(J.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
				LI_NO_DAYS_IN_CAL_YR := LD_CAL_TDATE - LD_CAL_FDATE + 1;
				LI_NO_DAYS_IN_CAL_YR := 365; -- Modified by Piyush on 17/06/2016 as per ERP
				LC_PROJ_INST := 0.00;
				LC_PRINC_DEDN := 0;
				IF LC_LOAN_OP_BAL > 0 THEN
					EMI_NO := EMI_NO + 1;
					LI_CNT1 := 0;
					LC_PRINC_DEDN := 0;
					SELECT COUNT(1) INTO LI_CNT1 FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
					AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
					IF LI_CNT1 > 0 THEN
						SELECT SUM(CASE WHEN AMOUNT IS NULL THEN 0 ELSE AMOUNT END) 
						INTO LC_PRINC_DEDN FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
						AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
					ELSE
						LI_CNT1 := 0;
						SELECT COUNT(1) INTO LI_CNT1 FROM PAYROLLDET 
						WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND 
						((REF_TYPE = 'L' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__DED);
						IF LI_CNT1 > 0 THEN
							SELECT AMOUNT INTO LC_PRINC_DEDN FROM PAYROLLDET 
							WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND 
							((REF_TYPE = 'L' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__DED);
						ELSE
							LC_TEMP_RECO := 0.00;
							LC_TEMP_BAL := LC_LOAN_OP_BAL;
							SELECT SUM(CASE WHEN AMOUNT IS NULL THEN 0 ELSE AMOUNT END) 
							INTO LC_TEMP_RECO FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
							AND TRAN_TYPE NOT IN ('P') AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE;
							IF LC_TEMP_RECO IS NOT NULL THEN
								LC_TEMP_BAL := LC_TEMP_BAL - LC_TEMP_RECO;
							END IF;
							LC_TEMP_RECO := 0.00;
							LC_PROJ_INST := I.MON_INST;
							LC_PRINC_DEDN := I.MON_INST;
							IF I.START_RECO <= J.FR_DATE THEN
								TOT_INST_DEDN := 0;
								TOT_INST_NO := 0;
								FOR K IN LOAN_INST_INFO(I.LOAN_NO)
								LOOP
									TOT_INST_NO := TOT_INST_NO + CASE WHEN K.NO_INST IS NULL THEN 9999 
										ELSE K.NO_INST END;
									IF TOT_INST_NO >= EMI_NO THEN
										LC_PRINC_DEDN := CASE WHEN LC_TEMP_BAL > K.AMOUNT THEN K.AMOUNT ELSE LC_TEMP_BAL END;
										LC_PROJ_INST := K.AMOUNT;
										--DBMS_OUTPUT.PUT_LINE('EXITED FROM K LOOP');
										EXIT;
									END IF;
								END LOOP;
							END IF;
						END IF;
					END IF;
					PV_FACTOR := 0;
					PRESENT_VALUE := 0;
					LC_OTH_RECOVERY := 0;
					LC_INT_DEDN := 0;
					LI_CNT1 := 0;
					SELECT COUNT(1) INTO LI_CNT1 FROM PAYROLLDET WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND ((REF_TYPE = 'N' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__INT);
					IF LI_CNT1 > 0 THEN
						SELECT AMOUNT INTO LC_INT_DEDN FROM PAYROLLDET WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J.CODE AND ((REF_TYPE = 'N' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__INT);
					ELSE
						LC_INT_DEDN := ROUND((LC_LOAN_OP_BAL * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J.FR_DATE THEN LD_INT_FIRST_DATE ELSE J.FR_DATE END) + 1),2);
						FOR L IN LOAN_RECO_INFO(I.LOAN_NO, J.FR_DATE, J.TO_DATE)
						LOOP
							LC_INT_DEDN := LC_INT_DEDN - (ROUND((L.AMOUNT * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J.TO_DATE - L.TRAN_DATE) + 1),2));
						END LOOP;
						LC_INT_DEDN := CASE WHEN LC_INT_DEDN >= 0 THEN LC_INT_DEDN ELSE 0 END;
						LC_PRINC_DEDN := NVL(LC_PRINC_DEDN , 0);
						LC_INT_DEDN := NVL(LC_INT_DEDN , 0);
						LC_PROJ_INST := NVL(LC_PROJ_INST , 0);
						IF TRIM(I.INT_TERM) = 'EMI' THEN
							IF LC_PROJ_INST > 0 THEN
								IF LC_PRINC_DEDN = LC_PROJ_INST THEN
									LC_PRINC_DEDN := LC_PRINC_DEDN - LC_INT_DEDN;
								END IF;
							END IF;
						--ELSE
							-- LC_PRINC_DEDN := I.MON_INST;
						END IF;
					END IF;

					SELECT SUM(AMOUNT) INTO LC_OTH_RECOVERY FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO AND TRAN_DATE BETWEEN J.FR_DATE AND J.TO_DATE AND TRAN_TYPE NOT IN ('P');
					IF LC_OTH_RECOVERY IS NULL THEN 
						LC_OTH_RECOVERY := 0;
					END IF;
					LC_PRINC_DEDN := NVL(LC_PRINC_DEDN , 0);
					LC_INT_DEDN := NVL(LC_INT_DEDN , 0);

					IF LC_PRINC_DEDN > LC_LOAN_OP_BAL - LC_OTH_RECOVERY THEN
						LC_PRINC_DEDN := LC_LOAN_OP_BAL - LC_OTH_RECOVERY;
					END IF;

					PV_FACTOR := ROUND(1 / POWER((1 + ROUND(LC_EFF_INT_RATE / 1200 , 4)),EMI_NO),4);
					PRESENT_VALUE := ROUND((LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) * PV_FACTOR , 2);
					TOT_PRESENT_VALUE := TOT_PRESENT_VALUE + PRESENT_VALUE;
					LC_LOAN_OP_BAL := LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY;
					LD_LOAN_CLOUSRE_DATE := J.TO_DATE;
				ELSE
					--DBMS_OUTPUT.PUT_LINE('EXITED FROM J LOOP');
					EXIT;
				END IF;
			END LOOP;
			--DBMS_OUTPUT.PUT_LINE('EMP CODE [' || TRIM(I.EMP_CODE) || '] LOAN NO [' || I.LOAN_NO || '] OP BALANCE [' || TRIM(TO_CHAR(LC_LOAN_OP_BAL)) || '] CL DATE [' || TO_CHAR(LD_LOAN_CLOUSRE_DATE , 'DD-MON-YYYY') || ']' );

			IF LD_LOAN_CLOUSRE_DATE >= I.FY_FROM_DATE THEN
				LC_LOAN_OP_BAL := I.LOAN_AMT;
				LI_CNT1 := 0;
				SELECT CASE WHEN LD_INT_FIRST_DATE > (SELECT TO_DATE FROM PERIOD 
					WHERE CODE = PRD_CODE__TO) THEN 0 ELSE LC_LOAN_OP_BAL END INTO LC_LOAN_OP_BAL 
					FROM DUAL;
				PV_FACTOR := 0;
				PRESENT_VALUE := 0;
				LC_OTH_RECOVERY := 0;
				LC_INT_DEDN := 0;
				LC_PRINC_DEDN := 0;
				EMI_NO := 0;

				FOR J1 IN PRD_INFO(LD_INT_FIRST_DATE)
				LOOP
					LD_CAL_FDATE := TO_DATE('01/01/' || TO_CHAR(J1.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
					LD_CAL_TDATE := TO_DATE('31/12/' || TO_CHAR(J1.FR_DATE , 'YYYY') , 'DD/MM/YYYY');
					LI_NO_DAYS_IN_CAL_YR := LD_CAL_TDATE - LD_CAL_FDATE + 1;
					LI_NO_DAYS_IN_CAL_YR := 365;  -- Modified by Piyush on 17/06/2016 as per ERP
					LC_PROJ_INST := 0.00;
					LC_PRINC_DEDN := 0;
					IF LC_LOAN_OP_BAL > 0 THEN
						LC_OTH_RECOVERY := 0;
						EMI_NO := EMI_NO + 1;
						LI_CNT1 := 0;
						LC_PRINC_DEDN := 0;
						LC_OTH_RECOVERY := 0;
						LC_INT_DEDN := 0;
						SELECT COUNT(1) INTO LI_CNT1 FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
						AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J1.FR_DATE AND J1.TO_DATE;
						IF LI_CNT1 > 0 THEN
							SELECT SUM(CASE WHEN AMOUNT IS NULL THEN 0 ELSE AMOUNT END) 
							INTO LC_PRINC_DEDN FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO 
							AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J1.FR_DATE AND J1.TO_DATE;
						ELSE
							LI_CNT1 := 0;
							SELECT COUNT(1) INTO LI_CNT1 FROM PAYROLLDET 
							WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J1.CODE AND 
							((REF_TYPE = 'L' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__DED);
							IF LI_CNT1 > 0 THEN
								SELECT AMOUNT INTO LC_PRINC_DEDN FROM PAYROLLDET 
								WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J1.CODE AND 
								((REF_TYPE = 'L' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__DED);
							ELSE
								LC_TEMP_RECO := 0;
								LC_TEMP_BAL := LC_LOAN_OP_BAL;
								SELECT SUM(CASE WHEN AMOUNT IS NULL THEN 0 ELSE AMOUNT END) INTO LC_PRINC_DEDN FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO AND TRAN_TYPE = 'P' AND TRAN_DATE BETWEEN J1.FR_DATE AND J1.TO_DATE;
								IF LC_TEMP_RECO IS NOT NULL THEN
									LC_TEMP_BAL := LC_TEMP_BAL - LC_TEMP_RECO;
								END IF;
								LC_TEMP_RECO := 0;
								LC_PROJ_INST := I.MON_INST;
								LC_PRINC_DEDN := I.MON_INST;
								IF I.START_RECO <= J1.FR_DATE THEN
									TOT_INST_DEDN := 0;
									TOT_INST_NO := 0;
									FOR K1 IN LOAN_INST_INFO(I.LOAN_NO)
									LOOP
										TOT_INST_NO := TOT_INST_NO + CASE WHEN K1.NO_INST IS NULL THEN 999999 
											ELSE K1.NO_INST END;
										IF TOT_INST_NO >= EMI_NO THEN
											LC_PRINC_DEDN := CASE WHEN LC_LOAN_OP_BAL > K1.AMOUNT THEN K1.AMOUNT ELSE LC_LOAN_OP_BAL END;
											LC_PROJ_INST := K1.AMOUNT;
											--DBMS_OUTPUT.PUT_LINE('EXITED FROM K1 LOOP');
											EXIT;
										END IF;
									END LOOP;
								END IF;
							END IF;
						END IF;
						PV_FACTOR := 0;
						PRESENT_VALUE := 0;
						LC_OTH_RECOVERY := 0;
						LC_INT_DEDN := 0;
						LOAN_INT_CALC_STR := '';
						-- Modified to calculate interest as per ERP.Start
						INTEREST_AT_EFF_RATE := 0.00;
						-- Modified to calculate interest as per ERP.End
						LI_CNT1 := 0;
						SELECT COUNT(1) INTO LI_CNT1 FROM PAYROLLDET WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J1.CODE AND ((REF_TYPE = 'N' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__INT);
						IF LI_CNT1 > 0 THEN
							SELECT AMOUNT INTO LC_INT_DEDN FROM PAYROLLDET WHERE EMP_CODE = I.EMP_CODE AND PRD_CODE = J1.CODE AND ((REF_TYPE = 'N' AND REF_NO = I.LOAN_NO) OR AD_CODE = I.AD_CODE__INT);
							FOR M1 IN LOAN_INT_CALC_INFO(I.LOAN_NO , J1.CODE) 
							LOOP
								LOAN_INT_CALC_STR := LOAN_INT_CALC_STR || '[AI-' || M1.REF_TYPE || '-' || 
									TRIM(TO_CHAR(M1.AMOUNT)) || 
									'-' || TO_CHAR(M1.DATE__FROM , 'DD-MON-YY') || '-' || 
									'-' || TO_CHAR(M1.DATE__TO , 'DD-MON-YY') || '-' || 
									'-' || TRIM(TO_CHAR(M1.NO_DAYS)) || '-' || 
									TRIM(TO_CHAR(M1.INT_PERC)) || '-' || 
									TRIM(TO_CHAR(M1.INTEREST_AMT__DIFF)) || ']';
							END LOOP;
						ELSE
							LC_INT_DEDN := ROUND((LC_LOAN_OP_BAL * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J1.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J1.FR_DATE THEN LD_INT_FIRST_DATE ELSE J1.FR_DATE END) + 1),2);
							LOAN_INT_CALC_STR := LOAN_INT_CALC_STR || '[PI-LOANBL-' || 
								TRIM(TO_CHAR(LC_LOAN_OP_BAL)) || '-' || 
								TO_CHAR(CASE WHEN LD_INT_FIRST_DATE > J1.FR_DATE THEN LD_INT_FIRST_DATE ELSE J1.FR_DATE END , 'DD-MON-YY') || '-' ||
								TO_CHAR(J1.TO_DATE , 'DD-MON-YY') || '-' ||
								TRIM(TO_CHAR(((J1.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J1.FR_DATE THEN LD_INT_FIRST_DATE ELSE J1.FR_DATE END) + 1))) || '-' || 
								TRIM(TO_CHAR(I.INTEREST)) || '-' || 
								TRIM(TO_CHAR(LC_INT_DEDN)) || ']' ;
							
							FOR L1 IN LOAN_RECO_INFO(I.LOAN_NO, J1.FR_DATE, J1.TO_DATE)
							LOOP
								LC_INT_DEDN := LC_INT_DEDN - (ROUND((L1.AMOUNT * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J1.TO_DATE - L1.TRAN_DATE) + 1),2));
								LOAN_INT_CALC_STR := LOAN_INT_CALC_STR || '[PI-LNRECO-' || 
									TRIM(TO_CHAR(L1.AMOUNT)) || '-' || 
									TO_CHAR(L1.TRAN_DATE , 'DD-MON-YY') || '-' ||
									TO_CHAR(J1.TO_DATE , 'DD-MON-YY') || '-' ||
									TRIM(TO_CHAR(((J1.TO_DATE - L1.TRAN_DATE) + 1))) || '-' || 
									TRIM(TO_CHAR(I.INTEREST)) || '-' || 
									TRIM(TO_CHAR((ROUND((L1.AMOUNT * I.INTEREST / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J1.TO_DATE - L1.TRAN_DATE) + 1),2)))) || ']' ;
								-- Modified to calculate interest as per ERP.Start
								INTEREST_AT_EFF_RATE := INTEREST_AT_EFF_RATE - (ROUND((L1.AMOUNT * LC_EFF_INT_RATE / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J1.TO_DATE - L1.TRAN_DATE) + 1),2));
								-- Modified to calculate interest as per ERP.End
							END LOOP;
							LC_INT_DEDN := CASE WHEN LC_INT_DEDN >= 0 THEN LC_INT_DEDN ELSE 0 END;

							LC_PRINC_DEDN := NVL(LC_PRINC_DEDN , 0);
							LC_INT_DEDN := NVL(LC_INT_DEDN , 0);
							LC_PROJ_INST := NVL(LC_PROJ_INST , 0);
							IF TRIM(I.INT_TERM) = 'EMI' THEN
								IF LC_PROJ_INST > 0 THEN
									IF LC_PRINC_DEDN = LC_PROJ_INST THEN
										LC_PRINC_DEDN := LC_PRINC_DEDN - LC_INT_DEDN;
									END IF;
								END IF;
							--ELSE
								-- LC_PRINC_DEDN := I.MON_INST;
							END IF;
						END IF;

						SELECT SUM(AMOUNT) INTO LC_OTH_RECOVERY FROM LOAN_REG WHERE LOAN_NO = I.LOAN_NO AND TRAN_DATE BETWEEN J1.FR_DATE AND J1.TO_DATE AND TRAN_TYPE NOT IN ('P');
						IF LC_OTH_RECOVERY IS NULL THEN 
							LC_OTH_RECOVERY := 0;
						END IF;
						LC_PRINC_DEDN := NVL(LC_PRINC_DEDN , 0);
						LC_INT_DEDN := NVL(LC_INT_DEDN , 0);
						IF LC_PRINC_DEDN > LC_LOAN_OP_BAL - LC_OTH_RECOVERY THEN
							LC_PRINC_DEDN := LC_LOAN_OP_BAL - LC_OTH_RECOVERY;
						END IF;

						AMORTISED_COST_OP_BAL := CASE WHEN EMI_NO = 1 THEN TOT_PRESENT_VALUE ELSE AMORTISED_COST_CL_BAL END;

						-- Commented and shofted above to calculate interest as per ERP logic
						-- INTEREST_AT_EFF_RATE := ROUND((AMORTISED_COST_OP_BAL * LC_EFF_INT_RATE / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J1.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J1.FR_DATE THEN LD_INT_FIRST_DATE ELSE J1.FR_DATE END) + 1),2);

						INTEREST_AT_EFF_RATE := INTEREST_AT_EFF_RATE + (ROUND((AMORTISED_COST_OP_BAL * LC_EFF_INT_RATE / 100) / (LI_NO_DAYS_IN_CAL_YR) * ((J1.TO_DATE - CASE WHEN LD_INT_FIRST_DATE > J1.FR_DATE THEN LD_INT_FIRST_DATE ELSE J1.FR_DATE END) + 1),2));

						-- Commented and modified bellow to set cl bal 0 on clauser of loan.Start
						--AMORTISED_COST_CL_BAL := AMORTISED_COST_OP_BAL + INTEREST_AT_EFF_RATE - (LC_PRINC_DEDN + LC_OTH_RECOVERY + LC_INT_DEDN);

						if LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY > 0 then
							AMORTISED_COST_CL_BAL := AMORTISED_COST_OP_BAL + INTEREST_AT_EFF_RATE - (LC_PRINC_DEDN + LC_OTH_RECOVERY + LC_INT_DEDN);
							IF AMORTISED_COST_CL_BAL < 0 THEN
								AMORTISED_COST_CL_BAL := 0;
							END IF;
						else
							AMORTISED_COST_CL_BAL := 0;
						end if;
						-- Commented and modified bellow to set cl bal 0 on clauser of loan.End

						PV_FACTOR := ROUND(1 / POWER((1 + ROUND(LC_EFF_INT_RATE / 1200 , 4)),EMI_NO),4);
						PRESENT_VALUE := ROUND((LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) * PV_FACTOR , 2);

						EMP_BENEFIT := INTEREST_AT_EFF_RATE - LC_INT_DEDN;

						DIFF_PRINC_DEDN := (LC_LOAN_OP_BAL - (LC_PRINC_DEDN + LC_OTH_RECOVERY)) - AMORTISED_COST_CL_BAL;

						OUT_REC.ACCT_PRD_ARG := ACCT_PRD; 
						OUT_REC.ACCT_PRD_DATA := J1.P_ACCT_PRD; 
						OUT_REC.PRD_CODE__FR := PRD_CODE__FR; 
						OUT_REC.PRD_CODE__TO := PRD_CODE__TO; 
						OUT_REC.FIN_ENTITY := I.FIN_ENTITY; 
						OUT_REC.EMP_CODE := I.EMP_CODE; 
						OUT_REC.EMP_FULL_NAME := I.EMP_FULL_NAME; 
						OUT_REC.PAY_SITE := I.PAY_SITE; 
						OUT_REC.CCTR_CODE__SAL := I.CCTR_CODE__SAL; 
						OUT_REC.LOAN_NO := I.LOAN_NO; 
						OUT_REC.SCHEME_NO := I.SCHEME_NO; 
						OUT_REC.SCHEME_TYPE := I.SCHEME_TYPE; 
						OUT_REC.ISSUE_DATE := I.ISSUE_DATE; 
						OUT_REC.LOAN_DISB_DATE := LD_INT_FIRST_DATE;
						OUT_REC.TERM := I.TERM; 
						OUT_REC.LOAN_AMT := I.LOAN_AMT; 
						OUT_REC.INTEREST := I.INTEREST; 
						OUT_REC.MON_INST := I.MON_INST; 
						OUT_REC.INT_TERM := I.INT_TERM; 
						OUT_REC.APPR_DATE := I.APPR_DATE; 
						OUT_REC.DATE__BALANCE := I.DATE__BALANCE; 
						OUT_REC.DATE__INTEREST := I.DATE__INTEREST; 
						OUT_REC.LOAN_TYPE := I.LOAN_TYPE; 
						OUT_REC.LOAN_CLOUSRE_DATE := LD_LOAN_CLOUSRE_DATE; 
						OUT_REC.ISA_EFF_INT_RATE := LC_EFF_INT_RATE; 
						OUT_REC.BALANCE_AMT := LC_LOAN_OP_BAL; 
						OUT_REC.LOAN_START_RECO_DATE := I.START_RECO; 

						OUT_REC.EMI_NO := EMI_NO; 
						OUT_REC.EMI_PRD_CODE := J1.CODE; 
						OUT_REC.EMI_PRD_DESCR := TO_CHAR(J1.FR_DATE , 'MON-YY'); 
						OUT_REC.OP_BALANCE_AMT := LC_LOAN_OP_BAL; 
						OUT_REC.INTEREST_AMT := LC_INT_DEDN; 
						OUT_REC.PRINC_CUM_INTEREST_AMT := (LC_LOAN_OP_BAL + LC_INT_DEDN); 
						OUT_REC.MON_DEDN := (LC_PRINC_DEDN + LC_INT_DEDN); 
						OUT_REC.PRINC_DEDN := LC_PRINC_DEDN; 
						OUT_REC.RECOVER_AMT := LC_OTH_RECOVERY; 
						OUT_REC.CL_BALANCE_AMT := LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY; 

						OUT_REC.PV_FACTOR := PV_FACTOR; 
						OUT_REC.PRESENT_VALUE := PRESENT_VALUE; 
						OUT_REC.AMORTISED_COST_OP_BAL := AMORTISED_COST_OP_BAL; 
						OUT_REC.INTEREST_AT_EFF_RATE := INTEREST_AT_EFF_RATE; 
						OUT_REC.REPAYMENT_INCL_INTEREST := (LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) ; 
						OUT_REC.AMORTISED_COST_CL_BAL := AMORTISED_COST_CL_BAL; 
						OUT_REC.EMP_BENEFIT := EMP_BENEFIT; 
						OUT_REC.DIFF_PRINC_DEDN := DIFF_PRINC_DEDN; 
						OUT_REC.PRINC_DEDN := LC_PRINC_DEDN; 
						OUT_REC.LOAN_INT_CALC_STR := LOAN_INT_CALC_STR; 
						OUT_REC.REPAYMENT_INCL_INTEREST_1 := CASE WHEN LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY > 0 THEN (LC_PRINC_DEDN + LC_INT_DEDN + LC_OTH_RECOVERY) ELSE AMORTISED_COST_OP_BAL + INTEREST_AT_EFF_RATE END; 
						LC_LOAN_OP_BAL := LC_LOAN_OP_BAL - LC_PRINC_DEDN - LC_OTH_RECOVERY;
						pipe row ( out_rec ); 
					ELSE
						--DBMS_OUTPUT.PUT_LINE('EXITED FROM J1 LOOP');
						EXIT;
					END IF;
				END LOOP;
			END IF;
		END IF;
	END LOOP;

	RETURN ;
END;
/

----- Modified on 12/07/2016.End ----

--- F16ASUN005.End ---

--------------- DDL from ADM-RCP-DDL-V32.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V33.SQL.Start -------


--- SUN CCF No: IT2016-047-01 Request ID:A16ESUN002.Start --- 

ALTER TABLE EMPLOYEE ADD BU_CODE CHAR(5);
ALTER TABLE EMPLOYEE ADD CONSTRAINT FK_EMPLOYEE_BU_CODE FOREIGN KEY ( BU_CODE ) REFERENCES BUSINESS_UNITS ;

ALTER TABLE EMPLOYEE ADD EMP_CODE__FUNCHEAD CHAR(10);

--- SUN CCF No: IT2016-047-01 Request ID:A16ESUN002.End --- 

--- SUN CCF No: IT2016-047-02 Request ID:A16ESUN003.Start --- 

ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_CODE__FUNCHEAD_O CHAR(10);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_CODE__FUNCHEAD CHAR(10);

ALTER TABLE EMPLOYEE_DET_CHANGE ADD BU_CODE__O CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD BU_CODE CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD CONSTRAINT FK_EMPDETCHG_BU_CODE FOREIGN KEY ( BU_CODE ) REFERENCES BUSINESS_UNITS ;

--- SUN CCF No: IT2016-047-02 Request ID:A16ESUN003.End --- 


--- SUN CCF No: IT2016-047-03 Request ID:A16ESUN004.Start --- 

ALTER TABLE EMP_EMPLOY_EVENTS ADD EMP_CODE__FUNCHEAD_FR CHAR(10);
ALTER TABLE EMP_EMPLOY_EVENTS ADD EMP_CODE__FUNCHEAD_TO CHAR(10);

ALTER TABLE EMP_EMPLOY_EVENTS ADD BU_CODE__FR CHAR(5);
ALTER TABLE EMP_EMPLOY_EVENTS ADD BU_CODE__TO CHAR(5);
ALTER TABLE EMP_EMPLOY_EVENTS ADD CONSTRAINT FK_EMPEVENTS_BU_CODE FOREIGN KEY ( BU_CODE__TO ) REFERENCES BUSINESS_UNITS ;

--- SUN CCF No: IT2016-047-03 Request ID:A16ESUN004.End --- 


--------------- DDL from ADM-RCP-DDL-V33.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V34.SQL.Start -------

--- Request ID: A16ESUN007.SQL.Start ---
ALTER TABLE ITPROJ_CALCHDR ADD CALC_BASE_CRITERIA CHAR(1);
ALTER TABLE IT_CALCHDR ADD CALC_BASE_CRITERIA CHAR(1);
--- Request ID: A16ESUN007.SQL.End ---


--- Request ID: A16ESUN009.SQL.Start ---
--- Request ID: A16ESUN009.SQL.End ---

--- Request ID: A16HSUN001-1.sql.Start ---

ALTER TABLE EMPLOYEE ADD MOTHER_TONGUE VARCHAR2(10);
ALTER TABLE EMPLOYEE ADD CAST_CATEGORY CHAR(5);
ALTER TABLE EMPLOYEE ADD COUNT_CODE__BIRTH CHAR(5);
ALTER TABLE EMPLOYEE ADD JOB_TITLE VARCHAR2(200);
ALTER TABLE EMPLOYEE ADD EMP_ID_EXTERNAL VARCHAR2(20);

ALTER TABLE EMPQUAL ADD COURSE_TYPE CHAR(5);
ALTER TABLE EMPQUAL ADD COURSE_DURATION NUMBER(3);
ALTER TABLE EMPQUAL ADD COUNT_CODE__QUAL CHAR(5);

ALTER TABLE EMPEXPERIENCE ADD COUNT_CODE__WORK CHAR(5);

ALTER TABLE EMPLOYEE_DET_CHANGE ADD MOTHER_TONGUE__O VARCHAR2(10);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD MOTHER_TONGUE VARCHAR2(10);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD CAST_CATEGORY__O CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD CAST_CATEGORY CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD COUNT_CODE__BIRTH_O CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD COUNT_CODE__BIRTH CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD JOB_TITLE_O VARCHAR2(200);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD JOB_TITLE VARCHAR2(200);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_ID_EXTERNAL_O VARCHAR2(20);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_ID_EXTERNAL VARCHAR2(20);

CREATE OR REPLACE FUNCTION FN_GET_COUNT_DESCR(AS_COUNT_CODE In CHAR) 
RETURN VARCHAR2 IS COUNT_DESCR VARCHAR2(200);

BEGIN
	COUNT_DESCR := ''; 
	BEGIN
	SELECT DESCR INTO COUNT_DESCR  FROM COUNTRY WHERE COUNT_CODE = AS_COUNT_CODE;
		EXCEPTION WHEN NO_DATA_FOUND THEN 
		COUNT_DESCR := ''; 
	END;
	RETURN COUNT_DESCR;
END;
/

--- Request ID: A16HSUN001-1.sql.End ---

--- Request ID: A16HSUN001-2.sql.Start ---

ALTER TABLE EMP_STATUSCHG ADD REASON_CODE CHAR(5);

ALTER TABLE EMP_EMPLOY_EVENTS ADD REASON_CODE CHAR(5);
ALTER TABLE EMP_EMPLOY_EVENTS ADD JOB_TITLE_FR VARCHAR2(200);
ALTER TABLE EMP_EMPLOY_EVENTS ADD JOB_TITLE_TO VARCHAR2(200);

ALTER TABLE ORG_STRUCTURE ADD DEPT_CODE CHAR(5);

--- Request ID: A16HSUN001-2.sql.End ---

--- Request ID: A16HSUN001-3.sql.Start ---


--- Request ID: A16HSUN001-3.sql.End ---

--- Request ID: A16HSUN001-4.sql.Start ---


--- Request ID: A16HSUN001-4.sql.End ---

--- Request ID: A16HSUN001-5.sql.Start ---


--- Request ID: A16HSUN001-5.sql.End ---


--- Request ID: office-sql.Start ---


--- Request ID: office-sql.End ---

--- Request ID:A16HSUN006. Migration of IT Declaration to RCP and IT Declaration through Upload START ---

--alter table for adding seq_no in emp_itdecl_hdr table--
alter table emp_itdecl_hdr add seq_no number(2) default 1 not null;

--drop index emp_itdecl_hdr_aeqd on table emp_itdecl_hdr --
drop index emp_itdecl_hdr_aeqd ;
commit;

--create index for AEQDS on emp_itdecl_hdr table (ACCT_PRD, EMP_CODE__DECL, QTR_NO, DECL_TYPE, SEQ_NO)--
create unique index emp_itdecl_hdr_aeqd on emp_itdecl_hdr (acct_prd asc, emp_code__decl asc, qtr_no asc, decl_type asc, seq_no asc);
commit;

--- Request ID:A16HSUN006. Migration of IT Declaration to RCP and IT Declaration through Upload END ---

--------------- DDL from ADM-RCP-DDL-V34.SQL.End -------

--------------- DDL from ADM-RCP-DDL-V35 (Piyush).SQL.Start -------


CREATE OR REPLACE 
FUNCTION        FN_GET_POS_DESCR4(
			AS_EMP_CODE EMPLOYEE.EMP_CODE%TYPE, 
			AS_DEPT_CODE EMPLOYEE.DEPT_CODE%TYPE,
			AS_POS_CODE EMPLOYEE.POS_CODE%TYPE, 
			AS_GRADE_CODE EMPLOYEE.GRADE%TYPE) RETURN VARCHAR2 IS
  A_POS_DESCR ORG_STRUCTURE.DESCR%TYPE;
  A_VERSION_ID ORG_STRUCTURE.VERSION_ID%TYPE;
  A_TABLE_NO ORG_STRUCTURE.TABLE_NO%TYPE;
  A_DEPT_CODE DEPARTMENT.DEPT_CODE%TYPE;
  A_LEVEL_NO ORG_STRUCTURE.LEVEL_NO%TYPE;
BEGIN
	IF (AS_POS_CODE IS NULL OR AS_EMP_CODE IS NULL) THEN
		RETURN A_POS_DESCR;
	END IF;
	A_DEPT_CODE := AS_DEPT_CODE;
	IF (A_DEPT_CODE IS NULL) THEN
		SELECT DEPT_CODE INTO A_DEPT_CODE FROM EMPLOYEE WHERE EMP_CODE = AS_EMP_CODE;
	END IF;
	IF (A_DEPT_CODE IS NULL) THEN
		RETURN A_POS_DESCR;
	END IF;
	SELECT VERSION_ID INTO A_VERSION_ID FROM VERSION WHERE TRUNC(SYSDATE) BETWEEN EFF_FROM AND VALID_UPTO;
	SELECT ITEM_SER INTO A_TABLE_NO FROM DEPARTMENT WHERE DEPT_CODE = A_DEPT_CODE;
	IF AS_GRADE_CODE IS NULL OR LENGTH(TRIM(AS_GRADE_CODE)) = 0 THEN
		SELECT B.LEVEL_NO INTO A_LEVEL_NO FROM EMPLOYEE A,GRADE B WHERE B.GRADE_CODE = A.GRADE AND A.EMP_CODE = AS_EMP_CODE;
	ELSE
		SELECT B.LEVEL_NO INTO A_LEVEL_NO FROM GRADE B WHERE B.GRADE_CODE = AS_GRADE_CODE;
	END IF;
	IF (A_TABLE_NO IN ('ET','OL','OT','IS','OC','OD','OE','AR','ST')) THEN
		A_LEVEL_NO := A_LEVEL_NO + 1;
	END IF;
	SELECT DESCR INTO A_POS_DESCR FROM ORG_STRUCTURE WHERE VERSION_ID = A_VERSION_ID AND TABLE_NO = A_TABLE_NO AND POS_CODE = AS_POS_CODE AND LEVEL_NO = A_LEVEL_NO;
RETURN A_POS_DESCR;
END;
/

--------------- DDL from ADM-RCP-DDL-V35 (Piyush).SQL.End -------

------ ADM-RCP-DATA-V36 (Piyush).SQL.Start ------
--- No DDL SQL in this version
------ ADM-RCP-DATA-V36 (Piyush).SQL.End ------

