package ibase.e12ria.e12table.client;

import ibase.e12ria.e12table.client.E12CustomTextCell.CellData;

import com.google.gwt.cell.client.AbstractEditableCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;

/**
 * A {@link Cell} used to render a checkbox. The value of the checkbox may be
 * toggled using the ENTER key as well as via mouse click.
 */
public class E12CheckBoxCell extends AbstractEditableCell<Boolean, E12CustomTextCell.CellData> {

  /**
   * An html string representation of a checked input box.
   */
  private static final SafeHtml INPUT_CHECKED = SafeHtmlUtils.fromSafeConstant("<input type=\"checkbox\" tabindex=\"-1\" checked />");

  /**
   * An html string representation of a checked input box.
   */
  private static final SafeHtml INPUT_CHECKED_DISABLED = SafeHtmlUtils.fromSafeConstant("<input type=\"checkbox\" tabindex=\"-1\" checked disabled />");

  /**
   * An html string representation of an unchecked input box.
   */
  private static final SafeHtml INPUT_UNCHECKED = SafeHtmlUtils.fromSafeConstant("<input type=\"checkbox\" tabindex=\"-1\"/>");

  /**
   * An html string representation of an unchecked input box.
   */
  private static final SafeHtml INPUT_UNCHECKED_DISABLED = SafeHtmlUtils.fromSafeConstant("<input type=\"checkbox\" tabindex=\"-1\" disabled />");

  private final boolean dependsOnSelection;
  private final boolean handlesSelection;

  /**
   * Construct a new {@link E12CheckBoxCell}.
   */
  public E12CheckBoxCell() {
    this(false);
  }

  /**
   * Construct a new {@link E12CheckBoxCell} that optionally controls selection.
   *
   * @param isSelectBox true if the cell controls the selection state
   * @deprecated use {@link #E12CheckBoxCell(boolean, boolean)} instead
   */
  @Deprecated
  public E12CheckBoxCell(boolean isSelectBox) {
    this(isSelectBox, isSelectBox);
  }

  /**
   * Construct a new {@link E12CheckBoxCell} that optionally controls selection.
   *
   * @param dependsOnSelection true if the cell depends on the selection state
   * @param handlesSelection true if the cell modifies the selection state
   */
  public E12CheckBoxCell(boolean dependsOnSelection, boolean handlesSelection) {
    super("change", "keydown");
    this.dependsOnSelection = dependsOnSelection;
    this.handlesSelection = handlesSelection;
  }

  @Override
  public boolean dependsOnSelection() {
    return dependsOnSelection;
  }

  @Override
  public boolean handlesSelection() {
    return handlesSelection;
  }

  @Override
  public boolean isEditing(Context context, Element parent, Boolean value) {
    // A checkbox is never in "edit mode". There is no intermediate state
    // between checked and unchecked.
    return false;
  }

  @Override
  public void onBrowserEvent(Context context, Element parent, Boolean value, NativeEvent event, ValueUpdater<Boolean> valueUpdater) {
    String type = event.getType();
    CellData cellData = getViewData( context );
    boolean enterPressed = "keydown".equals(type)
        && event.getKeyCode() == KeyCodes.KEY_ENTER;
    if ("change".equals(type) || enterPressed) {
      InputElement input = parent.getFirstChild().cast();
      Boolean isChecked = input.isChecked();

      /*
       * Toggle the value if the enter key was pressed and the cell handles
       * selection or doesn't depend on selection. If the cell depends on
       * selection but doesn't handle selection, then ignore the enter key and
       * let the SelectionEventManager determine which keys will trigger a
       * change.
       */
      if (enterPressed && (handlesSelection() || !dependsOnSelection())) {
        isChecked = !isChecked;
        input.setChecked(isChecked);
      }

      /*
       * Save the new value. However, if the cell depends on the selection, then
       * do not save the value because we can get into an inconsistent state.
       */
      if (value != isChecked && !dependsOnSelection()) {
    	cellData.setData( String.valueOf(isChecked) );
        setViewData(context.getKey(), cellData);
      } else {
        clearViewData(context.getKey());
      }

      if (valueUpdater != null) {
        valueUpdater.update(isChecked);
      }
    }
  }

  @Override
  public void render(Context context, Boolean value, SafeHtmlBuilder sb) {
    // Get the view data.
    Object key = context.getKey();
    CellData cellData = getViewData(context);
    Boolean viewData = Boolean.valueOf( cellData.getData() );
    
    if (viewData != null && viewData.equals(value)) 
    {
      clearViewData(key);
      viewData = null;
    }

    if( cellData.isProtect() )
    {
    	if (value != null && ((viewData != null) ? viewData : value)) 
    	{
    		sb.append(INPUT_CHECKED_DISABLED);
    	} 
    	else 
    	{
    		sb.append(INPUT_UNCHECKED_DISABLED);
    	}
    }
    else
    {
    	if (value != null && ((viewData != null) ? viewData : value)) 
    	{
    		sb.append(INPUT_CHECKED);
    	}
    	else
    	{
    		sb.append(INPUT_UNCHECKED);
    	}
    }
  }
  
  public CellData getViewData( Context context ) 
  {
	Object key = context.getKey();
	CellData cellData = ((DataGridTableRowModel) key).getCellData(context.getColumn());
	setViewData(key, cellData);
	return cellData;
  }
}
