<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>
			<head>
				<meta charset="utf-8" />
			</head>

		
			<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/sortable_table.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/packLabelWizard.js"></script>
			<link href="/ibase/webitm/css/theme/galaxy-theme.css" rel="stylesheet" />
			<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet" />
			<link href="/ibase/webitm/css/DD/jquery-ui-1.10.4.custom.min.css" rel="stylesheet" />
			<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
			<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/jquery.datetimepicker.css"/>
			
			<!--<script language="JavaScript" type="text/javascript">
<![CDATA[

	$(function() 
	{	
		var sum = $('#packLabelDetail tbody tr').length;
		for(var i=1;i<=sum;i++)
		{	
			$("#mfgdate"+i+"").datepicker({ changeDate: true, changeMonth: true, changeYear: true, dateFormat : "dd/mm/y"});		
			$("#expdate"+i+"").datepicker({ changeDate: true, changeMonth: true, changeYear: true, dateFormat : "dd/mm/y"});		
					
		}   
	});
	
	
]]>
			</script>
			--><!--<script>
<![CDATA[

	$(document).ready(function() {
	
	    $('#packLabelDetail').fxdHdrCol({
			fixedCols:  0,
			width:     "100%",
			height:    "95%",
			colModal: [
				   { width: 20, align: 'center' },
				   { width: 100, align: 'center' },				   				     
				   { width: 100, align: 'center' },
				   { width: 258, align: 'center' },
				   { width: 50, align: 'center' },
				   { width: 100, align: 'center' },
				   { width: 100, align: 'center' },
				   { width: 100, align: 'center' },
				   { width: 100, align: 'center' },
				   { width: 100, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 120, align: 'center' },
				   { width: 102, align: 'center' }
			],
			sort: true
		});
	});
]]>
			</script>
			-->
			
			<body>
				<form name="packLabelWizFormII" id="packLabelWizFormII" METHOD="post"
					ACTION="/ibase/ITMWizardHandlerServlet">
					<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:100%;position:absolute;z-index:5;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
                    </td>
                </tr>
                <script><![CDATA[]]>formatDetailWithErr();</script>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
					<div class="pageContentWrapper" style="height:80%;overflow:auto;">
					<TABLE border="0" width="100%" height="2%" class="header_td" cellpadding="0" cellspacing="0" style="background-color: #f7f8fa;">
							<TR>
								<div class='contentHeaderLbl'><img src="/ibase/images/menuImages/web/Dailyactivityreport.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px;margin-top:9px; height: 20px; width: 20px;"/>
									<TD class="header_main" nowrap="true" align="left" valign="middle" style="padding-left: 10px;font-size:16px;" width="2%" > 
									      Purchase Contract Details:
									</TD>
								</div>
							</TR>
					</TABLE>
						<table id="packLabelDetail" class="headertableClass" cellspacing="0" width="100%">
								<thead  class="table-head">
									<tr >
										<th class="tHeader">
											<input type="checkbox" id="chkAll" onclick="return checkAll(this)" />
										</th>
										<th class="tHeader">Contract&#160;No</th>
										<th class="tHeader">Item&#160;Code</th>
										<th class="tHeader">Item&#160;Description</th>
										<th class="tHeader">Unit</th>
										<th class="tHeader">Total&#160;Quantity</th>
										<th class="tHeader">Quantity</th>
										<th class="tHeader">Lot&#160;No</th>
										<th class="tHeader">Shipper&#160;Size</th>
										<th class="tHeader">No&#160;Art</th>
										<th class="tHeader">Manufecture&#160;Date</th>
										<th class="tHeader">Expiry&#160;Date</th>
										<th class="tHeader">Case&#160;&#160;&#160;Label</th>
									</tr>
								</thead>
								<tbody >

									<xsl:for-each select="//Detail2">
										<xsl:variable name="purc_order">
											<xsl:value-of select="purc_order" />
										</xsl:variable>
										<xsl:variable name="contract_no">
											<xsl:value-of select="contract_no" />
										</xsl:variable>
										<xsl:variable name="supp_code">
											<xsl:value-of select="supp_code" />
										</xsl:variable>
										<xsl:variable name="supp_code_descr">
											<xsl:value-of select="supp_code_descr" />
										</xsl:variable>
										<xsl:variable name="site_code">
											<xsl:value-of select="site_code" />
										</xsl:variable>
										<xsl:variable name="site_code_descr">
											<xsl:value-of select="site_code_descr" />
										</xsl:variable>
										<xsl:variable name="site_code__supp">
											<xsl:value-of select="site_code__supp" />
										</xsl:variable>
										<xsl:variable name="site_code__supp_descr">
											<xsl:value-of select="site_code__supp_descr" />
										</xsl:variable>
										<xsl:variable name="item_code">
											<xsl:value-of select="item_code" />
										</xsl:variable>
										<xsl:variable name="item_descr">
											<xsl:value-of select="item_descr" />
										</xsl:variable>
										<xsl:variable name="unit">
											<xsl:value-of select="unit" />
										</xsl:variable>
										<xsl:variable name="tot_quantity">
											<xsl:value-of select="tot_quantity" />
										</xsl:variable>
										<xsl:variable name="quantity">
											<xsl:value-of select="quantity" />
										</xsl:variable>
										<xsl:variable name="lot_no">
											<xsl:value-of select="lot_no" />
										</xsl:variable>
										<xsl:variable name="shipper_size">
											<xsl:value-of select="shipper_size" />
										</xsl:variable>
										<xsl:variable name="no_art">
											<xsl:value-of select="no_art" />
										</xsl:variable>
										<xsl:variable name="tran_code">
											<xsl:value-of select="tran_code" />
										</xsl:variable>
										<xsl:variable name="tran_name">
											<xsl:value-of select="tran_name" />
										</xsl:variable>
										<xsl:variable name="tran_type">
											<xsl:value-of select="tran_type" />
										</xsl:variable>
										<xsl:variable name="scac_code">
											<xsl:value-of select="scac_code" />
										</xsl:variable>
										<xsl:variable name="ship_date">
											<xsl:value-of select="ship_date" />
										</xsl:variable>
										<xsl:variable name="mfg_date">
											<xsl:value-of select="mfg_date" />
										</xsl:variable>
										<xsl:variable name="site_code__mfg">
											<xsl:value-of select="site_code__mfg" />
										</xsl:variable>
										<xsl:variable name="exp_date">
											<xsl:value-of select="exp_date" />
										</xsl:variable>
										<xsl:variable name="line_no__ord">
											<xsl:value-of select="line_no__ord" />
										</xsl:variable>
										<xsl:variable name="case_label">
											<xsl:value-of select="case_label" />
										</xsl:variable>

										<xsl:variable name="dbIDs">
											<xsl:value-of select="@domID" />
										</xsl:variable>
										<xsl:variable name="chkbox">
											<xsl:value-of select="@selected" />
										</xsl:variable>

										<xsl:if test="$dbIDs = '0'">
											<input type="hidden" class="input_editable" value="{$purc_order}"
												name="Detail2.{normalize-space($dbIDs)}.purc_order" id="purc_order"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$contract_no}"
												name="Detail2.{normalize-space($dbIDs)}.contract_no" id="contract_no"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$site_code}"
												name="Detail2.{normalize-space($dbIDs)}.site_code" id="site_code"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$site_code_descr}"
												name="Detail2.{normalize-space($dbIDs)}.site_code_descr" id="site_code_descr"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$site_code__supp}"
												name="Detail2.{normalize-space($dbIDs)}.site_code__supp" id="site_code__supp"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$site_code__supp_descr}"
												name="Detail2.{normalize-space($dbIDs)}.site_code__supp_descr"
												id="site_code__supp_descr" maxlength="10" />
											<input type="hidden" class="input_editable" value="{$supp_code}"
												name="Detail2.{normalize-space($dbIDs)}.supp_code" id="supp_code"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$supp_code_descr}"
												name="Detail2.{normalize-space($dbIDs)}.supp_code_descr" id="supp_code_descr"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$tran_code}"
												name="Detail2.{normalize-space($dbIDs)}.tran_code" id="tran_code"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$tran_name}"
												name="Detail2.{normalize-space($dbIDs)}.tran_name" id="tran_name"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$tran_type}"
												name="Detail2.{normalize-space($dbIDs)}.tran_type" id="tran_type"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$scac_code}"
												name="Detail2.{normalize-space($dbIDs)}.scac_code" id="scac_code"
												maxlength="10" />
											<input type="hidden" class="input_editable" value="{$ship_date}"
												name="Detail2.{normalize-space($dbIDs)}.ship_date" id="ship_date"
												maxlength="10" />
										</xsl:if>


										<xsl:if test="$dbIDs > '0'">
											<SCRIPT>
												<![CDATA[ var qtyR; qtyR ="]]>
												<xsl:value-of select="$dbIDs" />
												<![CDATA[";maxId= qtyR; ]]>

											</SCRIPT>

											<tr class="trClass">
												<td>
													<xsl:choose>
														<xsl:when test="$chkbox ='Y'">
															<input type="checkbox"
																name="Detail2.{normalize-space($dbIDs)}.selectbox" id="Detail2.{normalize-space($dbIDs)}.selectbox"
																checked='true' value="true" onClick="setChecked(this)" />
															<!--  style="visibility: show; width: 0px;"/> -->
														</xsl:when>
														<xsl:otherwise>
															<input type="checkbox"
																name="Detail2.{normalize-space($dbIDs)}.selectbox" id="Detail2.{normalize-space($dbIDs)}.selectbox"
																value="false" onClick="setChecked(this)" style='text-align: right;' />
														</xsl:otherwise>
													</xsl:choose>
												</td>

												<td >
													<input type="hidden" class="input_editable" value="{$contract_no}"
														name="Detail2.{normalize-space($dbIDs)}.contract_no" id="Detail2.{normalize-space($dbIDs)}.contract_no"
														maxlength="10" />
													<xsl:value-of select="contract_no" />
												</td>

												<td>
													<input type="hidden" class="input_editable" value="{$item_code}"
														name="Detail2.{normalize-space($dbIDs)}.item_code" id="Detail2.{normalize-space($dbIDs)}.item_code"
														maxlength="10" />
													<xsl:value-of select="item_code" />
												</td>

												<td nowrap="true">
													<input type="hidden" class="input_editable" value="{$item_descr}"
														name="Detail2.{normalize-space($dbIDs)}.item_descr" id="Detail2.{normalize-space($dbIDs)}.item_descr"
														maxlength="10" />
														<xsl:value-of select="item_descr" />
												</td>
												<td>
													<input type="hidden" class="editInputClass" value="{$unit}"
														name="Detail2.{normalize-space($dbIDs)}.unit" id="Detail2.{normalize-space($dbIDs)}.unit"
														maxlength="10" />
													<xsl:value-of select="unit" />
												</td>
												<td>
													<input type="hidden" class="editInputClass" value="{$tot_quantity}"
														name="Detail2.{normalize-space($dbIDs)}.tot_quantity" id="Detail2.{normalize-space($dbIDs)}.tot_quantity"
														maxlength="10" />
														<xsl:value-of select="tot_quantity" />
												</td>
												<td>
													<input type="text" class="editInputClass" value="{$quantity}"
														name="Detail2.{normalize-space($dbIDs)}.quantity" id="Detail2.{normalize-space($dbIDs)}.quantity"
														maxlength="10" size="10" style='text-align: right;'
														onchange = 'setCheckedBox({normalize-space($dbIDs)})'
														onkeypress='return isNumeric(event)'
														onblur="javascript:calculateNoArt({normalize-space($dbIDs)})" />
												</td>

												<td>
													<input type="text" class="editInputClass" value="{$lot_no}"
														name="Detail2.{normalize-space($dbIDs)}.lot_no" id="Detail2.{normalize-space($dbIDs)}.lot_no"
														maxlength="15" size="15" onkeyup='return specialCharValidate(this.id)'
														onblur="javascript:getItemLotPackSize({normalize-space($dbIDs)})" />
												</td>

												<td>
													<input type="text" class="editInputClass" value="{$shipper_size}"
														name="Detail2.{normalize-space($dbIDs)}.shipper_size" id="Detail2.{normalize-space($dbIDs)}.shipper_size"
														maxlength="11" size="11" style='text-align: right;'
														onkeypress='return isNumeric(event)'
														onblur="javascript:calculateNoArt({normalize-space($dbIDs)})" />
												</td>

												<td>
													<input type="text" class="editInputClass" size="5"
														value="{$no_art}" name="Detail2.{normalize-space($dbIDs)}.no_art"
														id="Detail2.{normalize-space($dbIDs)}.no_art" maxlength="11"
														ISCHANGED="false" readOnly="1"
														style='text-align: center; width: 90%; border: none;' />
												</td>

												<td nowrap="true">
													<input type="text"  class="input_editable" size="8" value="{$mfg_date}" name="Detail2.{normalize-space($dbIDs)}.mfg_date" id="mfgDate{normalize-space($dbIDs)}" onChange="javascript:expDate({normalize-space($dbIDs)});" maxlength="8" ISCHANGED="false" placeholder = "DD/MM/YY"/>	
													<img border="0" src="/ibase/webitm/images/calender.png"  id="mfg_date" name="mfg_date" onClick="javascript:setDate('mfgDate{normalize-space($dbIDs)}');" 
													style='margin-bottom:-7px; margin-left: 3px;'/>	
											
													<!--<input type="text" class="editInputClass" value="{$mfg_date}"
														name="Detail2.{normalize-space($dbIDs)}.mfg_date" id="mfgdate{normalize-space($dbIDs)}"
														maxlength="10" size="10" readOnly="1" />
													<xsl:value-of select="mfg_date" />-->
												
													<input type="hidden" class="editInputClass" value="{$site_code__mfg}"
														name="Detail2.{normalize-space($dbIDs)}.site_code__mfg"
														id="Detail2.{normalize-space($dbIDs)}.site_code__mfg"
														maxlength="5" size="10" />
													
													<input type="hidden" class="editInputClass" value="{$line_no__ord}"
														name="Detail2.{normalize-space($dbIDs)}.line_no__ord"
														id="Detail2.{normalize-space($dbIDs)}.line_no__ord"
														maxlength="5" size="10" />
												</td>
												<td nowrap="true">	
													<input type="text"  class="input_editable" size="8" value="{$exp_date}" name="Detail2.{normalize-space($dbIDs)}.exp_date" id="expDate{normalize-space($dbIDs)}" maxlength="8" readonly = "1" ISCHANGED="false" placeholder = "DD/MM/YY"/>
													<!--<img border="0" src="/ibase/webitm/images/calender.png"  id="exp_date" name="exp_date" />
													onClick="javascript:setDate('expDate{normalize-space($dbIDs)}');"	
												--></td>
												<td nowrap="true">
													<input type="hidden" class="editInputClass" value="{$case_label}"
														name="Detail2.{normalize-space($dbIDs)}.case_label" id="Detail2.{normalize-space($dbIDs)}.case_label"
														maxlength="10" />

													<a href="#" id="Detail2.{normalize-space($dbIDs)}.packListLink"
														name="{normalize-space($dbIDs)}"
														onclick="getCaseLabelData('{$contract_no}','{$item_code}','{$lot_no}','{$quantity}','{$no_art}',{normalize-space($dbIDs)});"
														style="color:blue">View Case Labels</a>
												</td>

											</tr>

										</xsl:if>
									</xsl:for-each>
								</tbody>
							</table>
						</div>

						<table width="100%">
							<tr>
								<td class="td_leftAlign" colspan="2">
									<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
									<input type="hidden" value="packLabelWiz" name="OBJ_NAME" />
									<input type="hidden" value="" name="action" id="action" />
									<input type="hidden" value="1:MP" name="formType" id="formType" />
									<input type="hidden" value="" name="PRE_FORM_VAL" ID="PRE_FORM_VAL" />

									<input type="submit" style="cursor:hand" class="button"
										value="Cancel" title='Cancel' id="previous"
										onclick="javascript:setActionVal('previous');" />
									<input type="submit" style="cursor:hand" class="button"
										value="Previous" title='Previous' id="prev"
										onclick="javascript:createXMLString()" />
								</td>
								
								<td class="td_rightAlign" colspan="2">
									<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
									<input type="hidden" value="packLabelWiz" name="OBJ_NAME" />
									<input type="hidden" value="" name="action" id="action" />
									<input type="hidden" value="1:MP" name="formType" id="formType" />
									<input type="hidden" value="" name="PRE_FORM_VAL" ID="PRE_FORM_VAL" />

							<input type="submit" style="cursor:hand" class="button"
										value="Finish" title='Finish' id="finish"
										onclick="javascript:return checkValidation();" />
								</td>
							</tr>
						</table>
                        <div id="buttonreplacement" style="margin-left:450px; display:none;" >
							<img src="/ibase/images/preload.gif" alt="Please wait work in progress" >
						 	Please wait......
							</img>	
						</div>
						
					<div id="overlay"></div>
					<div id="caseListDiv" style="display:none;">
						<div style="overflow: auto; height: 300px;">
							<table class='tableClass' id="SKUPackListId"
								style="text-align: center; width: 350px; margin: 0 auto;">
								<!--<caption id="SKUPackListCaption" class="captionClass"  style="border-bottom: #6cf 3px solid;">Case Label Details</caption>-->
							<TR>
								<div class='contentHeaderLbl'><img src="/ibase/images/menuImages/web/Dailyactivityreport.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px;margin-top:0px; height: 20px; width: 20px;"/>
									<TD class="header_main" nowrap="true" align="left" valign="middle" style="padding-left: 20px;font-size:16px;" width="2%" > 
									      Case Label Details
									</TD>
								</div>
							</TR>
							<tbody class='table-body' style="border-top: #6cf 3px solid;">

									<tr>
										<td nowrap="true">Purchase Contract/Order:</td>
										<td>
											<input type="text" onchange="return isNumeric(this)"
												class="editInputClass" style="text-align: left;" id="p_contract_no"
												value="" maxlength="10" />
										</td>
									</tr>
									<tr>
										<td>Item Code:</td>
										<td>
											<input type="text" onchange="return isNumeric(this)"
												class="editInputClass" style="text-align: left;" id="p_item_code"
												value="" maxlength="10" />
										</td>
									</tr>
									<tr>
										<td>Lot No:</td>
										<td>
											<input type="text" onchange="return isNumeric(this)"
												class="editInputClass" style="text-align: left;" id="p_lot_no"
												value="" maxlength="15" />
										</td>
									</tr>
									<tr>
										<td>Quantity:</td>
										<td>
											<input type="text" onchange="return isNumeric(this)"
												class="editInputClass" style="text-align: left;" id="p_quantity"
												value="" maxlength="15" />
										</td>
									</tr>

									<tr>
										<td>No of Case:</td>
										<td>
											<input type="text" onchange="return isNumeric(this)"
												class="editInputClass" style="text-align: left;" id="p_no_art"
												value="" maxlength="5" />
										</td>
									</tr>
								</tbody>

							</table>
							<input type="hidden" id="idNumPack" />
							<div class="popDiv" style="margin-top: 45px; margin-left: 16px;">
							<input type="submit" style="margin-top:inherit;"
								class="button red-Btn pophelp-okcancel" value="Cancel" title='Cancel'
								onclick="javascript:closePopup()" />
							
							<input type="button" style="margin-top:inherit;"
								class="button green-Btn pophelp-okcancel" value="Generate Case Label" title='Generate Case Label'
								onclick="javascript:printCaseLabel(idNumPack)" />
						</div>
						</div>
						
					</div>
					
				</form>
			</body>

		</html>
	</xsl:template>
</xsl:stylesheet>
