/**
 * Request ID: W16DSUN008
 * @author Saurabh Jarande
 * @Date 04/OCT/2016
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

/**
 * Session Bean implementation class ScheduleStatusCanc
 */

@Stateless
public class ScheduleStatusCanc extends ActionHandlerEJB implements ScheduleStatusCancRemote, ScheduleStatusCancLocal 
{
	@Override
	public String actionHandler() throws RemoteException, ITMException 
	{
		return "";
	}

	@Override
	public String actionHandler(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException 
	{
		Connection conn = null;
		String retString = "";
		boolean errorFound = false;
		try
		{
			System.out.println("ScheduleStatusCanc : tranID :==>" + tranID);
			System.out.println("ScheduleStatusCanc : xtraParams :==>" + xtraParams);
			System.out.println("ScheduleStatusCanc : forcedFlag :==>" + forcedFlag);
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;
			retString = checkNull(actionHandler(tranID, xtraParams, forcedFlag, conn));
			System.out.println("retString:::::"+retString);
			if(retString.length() > 0 && !(retString.contains("VTS2ASSWR")))
			{
				errorFound = true;
				System.out.println("ScheduleStatusCanc : errorFound :==>" + errorFound);
			}
		}
		catch(Exception e)
		{
			errorFound = true;
			System.out.println("Exception ScheduleStatusCanc : cancel :==>");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( errorFound )
				{
					System.out.println("Rolling Back Changes......");
					conn.rollback();
				}
				else
				{
					System.out.println("Commiting Changes......");
					conn.commit();
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : ScheduleStatusCanc finally :==>\n" + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return retString;
	}
	
	public String actionHandler(String tranID, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException 
	{
		String retString = "";
		AppConnectParm appConnect = null;
		InitialContext ctx = null;
		ITMDBAccessLocal itmDBAccess = null;
		E12GenericUtility genericUtility = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String loginCode = "", sql = "", status = "",chg_term="",chg_user="";
		int upd=0;
		Timestamp chg_date=null;
		try
		{
			genericUtility = new E12GenericUtility();
			chg_date = new Timestamp(System.currentTimeMillis());
			chg_term = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			chg_user = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("chg_term:::::"+chg_term+"chg_user:::"+chg_user+"chg_date::::"+chg_date+"tranID::::"+tranID);
			String dbName = checkNull(CommonConstants.DB_NAME);
			System.out.println("dbName:::::::"+dbName);
			if("oracle".equalsIgnoreCase(dbName))
			{
				sql = "SELECT SCHEDULE_STATUS FROM SWMS_TO_AWMS WHERE TRAN_ID = ? FOR UPDATE NOWAIT";
			}
			else
			{
				sql = "SELECT SCHEDULE_STATUS FROM SWMS_TO_AWMS WHERE TRAN_ID = ? FOR UPDATE";
			}
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				status = checkNull(rs.getString("SCHEDULE_STATUS"));
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			itmDBAccess = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );
			
			if("Y".equalsIgnoreCase(status.toUpperCase()))
			{
				retString = itmDBAccess.getErrorString("", "VTS2ASSY", loginCode);
				return retString;
			}
			else if("X".equalsIgnoreCase(status.toUpperCase()))
			{
				retString = itmDBAccess.getErrorString("", "VTS2ASSX", loginCode);
				return retString;
			}
			else if(status==null || status.trim().length()==0)
			{
				retString = itmDBAccess.getErrorString("", "VTS2ASSNL", loginCode);
				return retString;
			}
			else if("N".equalsIgnoreCase(status.toUpperCase()))
			{
				sql = "UPDATE SWMS_TO_AWMS SET SCHEDULE_STATUS=? ,CHG_DATE=?,CHG_TERM=?,CHG_USER=? WHERE TRAN_ID=?";
				System.out.println("upd sql............." + sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "X");
				pstmt.setTimestamp(2, chg_date);
				pstmt.setString(3, chg_term);
				pstmt.setString(4, chg_user);
				pstmt.setString(5, tranID);
				upd = pstmt.executeUpdate();
				if(upd>0)
				{
					retString = itmDBAccess.getErrorString("", "VTS2ASSWR", loginCode);
					System.out.println("Record updated for tran_id ::::"+tranID);
				}
				else
				{
					retString = itmDBAccess.getErrorString("", "VTS2ASSERR", loginCode);
					System.out.println("Error while updating Record !!!");
				}
			}
			
		}
		catch(Exception e)
		{
			System.out.println("Exception : ScheduleStatusCanc Connection :==>\n" + e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : ScheduleStatusCanc Saving :==>\n" + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return retString;
	}
	
	private String checkNull(String input)//Method to check null string
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
}
