/**
 * PURPOSE : PhysicalCountConf component
 * AUTHOR : Sneha Mestry
 * DATE : 18-04-2016
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.Stateless;

@Stateless
public class PhysicalCountConf extends ActionHandlerEJB implements PalletReqConfLocal, PalletReqConfRemote
{
	public String confirm(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException
	{
		String retString = "";
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		boolean isConn = true;
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			retString = confirm(tranID, xtraParams, forcedFlag, conn, isConn);

			if ((retString == null) && (retString.length() < 0))
			{
				throw new Exception("Exception while calling confirm for tran  Id:[" + tranID + "]");
			}
		}
		catch (Exception exception)
		{
			System.out.println("Exception in [PalletReqConf]  " + exception.getMessage());
		}
		return retString;
	}

	public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn, boolean conStat) throws RemoteException, ITMException
	{
		System.out.println("PhysicalCountConf Called........");

		boolean isError = false;
		int confirmedCount = 0;
		String sql = "", sqlPhyScan = "";
		ResultSet rs = null, rsPhyscan = null;
		PreparedStatement pstmt = null, pstmtPhyscan = null; 
		String errString = ""; 
		String lineNo = "", itemCode = "", lotNo = "", lotSl = "", locCode = "", siteCode = "", unit = "";
		
		ArrayList interfaceArrList = new ArrayList();
		Date today = new Timestamp(System.currentTimeMillis());
		ITMDBAccessEJB itmdbAccess = new ITMDBAccessEJB();
		CommonWmsUtil commonWmsUtility = CommonWmsUtil.getInstance();	
		E12GenericUtility genericUtility = new E12GenericUtility();
		
		siteCode = checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));	
		
		try
		{
			System.out.println(" tranId [" + tranId + "]");
			System.out.println(" force flag [" + forcedFlag + "]");
			System.out.println(" xtraParams --> [" + xtraParams + "]");
			
			sql = "SELECT COUNT(1) FROM PHYSCAN WHERE TRAN_ID = ? AND CONFIRMED = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			pstmt.setString(2, "N");
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				confirmedCount = rs.getInt(1);
				//System.out.println("CONFIRMED >>>>>>>" + confirmedCount);
			}
			if(pstmt != null){ pstmt.close();pstmt = null;}
			if(rs != null){rs.close();rs = null;}

			if(confirmedCount == 0) 
			{
				System.out.println("error" + errString);
				errString = itmdbAccess.getErrorString("", "VMTRANSCOF", "", "", conn);
				return errString;
			}
			else
			{
				sql = "UPDATE PHYSCAN SET CONFIRMED = ? WHERE TRAN_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "Y");
				pstmt.setString(2, tranId);
				pstmt.executeUpdate();	
				if(pstmt != null){ pstmt.close();pstmt = null;}
			}
			
			sqlPhyScan = " SELECT  D.LINE_NO, D.SITE_CODE, D.ITEM_CODE, D.LOC_CODE, D.LOT_NO, D.LOT_SL, D.UNIT FROM PHYSCAN P, PHYSCANDET D " 
					+ "WHERE P.TRAN_ID = D.TRAN_ID AND P.TRAN_ID = ?";
			pstmtPhyscan = conn.prepareStatement(sqlPhyScan);
			pstmtPhyscan.setString(1, tranId);
			rsPhyscan = pstmtPhyscan.executeQuery();
			
			while(rsPhyscan.next())
			{
				lineNo = checkNullAndTrim(rsPhyscan.getString("LINE_NO"));
				siteCode = checkNullAndTrim(rsPhyscan.getString("SITE_CODE"));
				itemCode = checkNullAndTrim(rsPhyscan.getString("ITEM_CODE"));
				locCode  = checkNullAndTrim(rsPhyscan.getString("LOC_CODE"));
				lotNo  = checkNullAndTrim(rsPhyscan.getString("LOT_NO"));
				lotSl  = checkNullAndTrim(rsPhyscan.getString("LOT_SL"));
				unit  = checkNullAndTrim(rsPhyscan.getString("UNIT"));
				
				HashMap<String,String> interfaceHmap = new HashMap<String,String>();
				
				interfaceHmap.put("TRAN_ID", "");
				interfaceHmap.put("ITEM_CODE", itemCode);
				interfaceHmap.put("DESCR", "");
				interfaceHmap.put("UNIT", unit);
				interfaceHmap.put("ITEM_TYPE", "");
				interfaceHmap.put("FAMILY_GRP", "");
				interfaceHmap.put("IN_OUT", "B");
				interfaceHmap.put("REF_SER", "PSCAN");
				interfaceHmap.put("REF_ID", tranId);
				interfaceHmap.put("TRAN_DATE", checkNullAndTrim(String.valueOf(today)));
				interfaceHmap.put("LOT_NO", lotNo);	
				interfaceHmap.put("LOT_SL", lotSl);
				interfaceHmap.put("QUANTITY", "");
				interfaceHmap.put("QTY_PER_ART", "");
				interfaceHmap.put("TOTAL_QTY", "");
				interfaceHmap.put("EXP_DATE", "");	
				interfaceHmap.put("MFG_DATE", "");	
				interfaceHmap.put("PALLET_NO", locCode);	
				interfaceHmap.put("MSG_STAT", "N");
				interfaceHmap.put("PALLET_STATUS", "");
				interfaceHmap.put("LOCK_STAT", "");
				interfaceHmap.put("ERR_COD", "");
				interfaceHmap.put("ERR_DESC", "");
				interfaceHmap.put("QC_TYPE", "");
				interfaceHmap.put("TRANS_DT_ACK", "");
				interfaceHmap.put("STRO_PREF", "");
				interfaceHmap.put("LINE_NO", lineNo);
				
				interfaceArrList.add(interfaceHmap);
			}
			if(rsPhyscan != null)
			{
				rsPhyscan.close();
				rsPhyscan=null;
			}
			if(pstmtPhyscan != null)
			{
				pstmtPhyscan.close();
				pstmtPhyscan=null;
			}
			commonWmsUtility.updateAwmsInterface(interfaceArrList, siteCode, conn);
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("is error in finally" + isError);
				if (isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
					errString = itmdbAccess.getErrorString("", "VMTRANSACN", "", "", conn);
				}
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (conn != null)
				{
					conn.close();
					conn = null;
				}

			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return errString;
	}
	
	private String checkNullAndTrim(String str)
	{
		if(str == null)
		{
			str = "";
		}
		return str.trim();
	}
}