package ibase.webitm.ejb.mfg;

import java.rmi.RemoteException;
import java.text.*;
import java.util.Date;
import java.sql.*;

import org.w3c.dom.*;

import javax.ejb.*;

import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.mfg.MfgCommon;
import ibase.webitm.ejb.fin.FinCommon;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class RcpBackflushMulti extends ValidatorEJB implements  RcpBackflushMultiLocal,  RcpBackflushMultiRemote //SessionBean
{
	//GenericUtility genericUtility = GenericUtility.getInstance(); 
	E12GenericUtility genericUtility= new  E12GenericUtility();
	/*public void ejbCreate() throws RemoteException, CreateException 
	{
		System.out.println("RcpBackflushEJB is in Process..........");
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate() 
	{
	}
	public void ejbPassivate() 
	{
	}*/
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String  errString = null;
		System.out.println("Validation Start..........");
		try
		{
			System.out.println("xmlString:::"+xmlString);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1); 
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : RcpBackflushEJB : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = " ";
		String errCode = null;
		ConnDriver connDriver = new ConnDriver();	
		Connection conn = null;
        Statement stmt = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		String sql = null;
		String loginCode = null; 
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null; 
		int ctr,currentFormNo=0;
		int childNodeListLength;

		String tranDate = null, siteCode = null, projCode = null, backflushType = null, itemCode = null;
		String unit = null, locCode = null, trackShelfLife = null, grade = null, stkGrade = null;
		String mfgDateS = null, expDateS = null, packCode = null, bomCode = null, itemCodeFG = null;
		String parentHdr = null, parentDet = null, lotNo = null, lotSl = null;
		double quantity = 0, stkQty = 0;

		int cnt = 0; //for no. of record available in the table
		
		try
		{
			conn = connDriver.getConnectDB("Driver");
			connDriver = null;
			loginCode = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			
            stmt = conn.createStatement();
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						
						if (childNodeName.equals("tran_date"))
						{
								tranDate = genericUtility.getColumnValue("tran_date", dom);
								siteCode = genericUtility.getColumnValue("site_code", dom);
								errCode = nfCheckPeriod("PUR", genericUtility.getDateObject(tranDate), siteCode);
								if (errCode != null &&  errCode != "")
								{
									System.out.println("errCode from nfCheckPeriod :: [" + errCode + "]");
									errString = getErrorString("tran_date",errCode,loginCode);
									break;
								}
						}
						else if (childNodeName.equals("site_code"))
						{
							siteCode = genericUtility.getColumnValue("site_code", dom);
							errCode = isSiteCode(siteCode,"R-BFS");
							if (errCode != null && errCode.trim().length() != 0)
							{
								System.out.println("errCode from isSiteCode :: [" + errCode + "]");
								errString = getErrorString("site_code",errCode,loginCode);
								break;
							}
						}
						else if (childNodeName.equals("proj_code"))
						{
							projCode = genericUtility.getColumnValue("proj_code", dom);
							sql = "SELECT COUNT(*) FROM PROJECT WHERE PROJ_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, projCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
								if (cnt == 0)
								{
									errCode = "VTPROJ1";
									errString = getErrorString("proj_code",errCode,loginCode);
									break;
								}
							}
							rs.close();
							pstmt.close();
						}
						else if (childNodeName.equals("bom_code"))
						{
							String activeBom = "N",confBom = "N";
                            bomCode = genericUtility.getColumnValue("bom_code", dom);
							    
							if (bomCode != null && bomCode.trim().length() > 0)
							{
								sql = "select active,confirmed from bom where bom_code = '"+bomCode+"'";
                                rs = stmt.executeQuery(sql);
                                if(rs.next()){
                                    activeBom = rs.getString("active");
                                    confBom = rs.getString("confirmed");
                                }
                                if(activeBom.equalsIgnoreCase("N") || confBom.equalsIgnoreCase("N")){
                                    errCode = "VTINVBOM";
                                    errString = getErrorString("bom_code",errCode,loginCode);
                                    break;
                                }
                                rs.close();
							}
						}
                        else if(childNodeName.equals("acct_code__conv_gl")){
                            String acctCodeConvGl = genericUtility.getColumnValue("acct_code__conv_gl", dom);
                            int acctCount = 0;
                            if(acctCodeConvGl == null || acctCodeConvGl.trim().length() == 0){
                                errString = getErrorString("acct_code__conv_gl","VMACTCDMT",loginCode);
                                break;
                            }else{
                                sql = "select count(*) from accounts where acct_code = '"+acctCodeConvGl+"'";
                                rs = stmt.executeQuery(sql);
                                if(rs.next()){
                                    acctCount = rs.getInt(1);
                                }
                                if(acctCount == 0){
                                    errString = getErrorString("acct_code__conv_gl","VMACTCDMT",loginCode);
                                    break;
                                }
                                rs.close();
                            }
                        }else if(childNodeName.equals("cctr_code__conv_gl")){
                            int cctrCount = 0;
                            String cctrCodeConvGl = genericUtility.getColumnValue("cctr_code__conv_gl", dom);
                            if(cctrCodeConvGl == null || cctrCodeConvGl.trim().length() == 0){
                                errString = getErrorString("cctr_code__conv_gl","VMCCTRMT",loginCode);
                                break;
                            }else{
                                sql = "select count(*) from costctr where cctr_code = '"+cctrCodeConvGl+"'";
                                rs = stmt.executeQuery(sql);
                                if(rs.next()){
                                    cctrCount = rs.getInt(1);
                                }
                                if(cctrCount == 0){
                                    errString = getErrorString("cctr_code__conv_gl","VMCCTRMT",loginCode);
                                    break;
                                }
                            }
                        }
					}//END FOR
					break;
				case 2:
					System.out.println("Validation for Detail..........");
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equals("item_code"))
						{
							itemCode = genericUtility.getColumnValue("item_code", dom);
							siteCode = genericUtility.getColumnValue("site_code", dom1);
							errCode = isItem(siteCode, itemCode, "R-BFS", conn);
							if (errCode != null &&  errCode != "")
							{
								errString = getErrorString("item_code",errCode,loginCode);
								break;
							}
						}
						else if (childNodeName.equals("loc_code"))
						{
							locCode = genericUtility.getColumnValue("loc_code", dom);
							sql = "SELECT COUNT(*) FROM LOCATION WHERE LOC_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, locCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
								if (cnt == 0)
								{
									errCode = "VMLOC1";
									errString = getErrorString("loc_code",errCode,loginCode);
									break;
								}
							}
							pstmt.close();
							rs.close();
						}
						if (childNodeName.equals("unit"))
						{
							unit = genericUtility.getColumnValue("unit", dom);
							sql = "SELECT COUNT(*) FROM UOM WHERE UNIT = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, unit);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
								if (cnt == 0)
								{
									errCode = "VTUNIT1";
									errString = getErrorString("unit",errCode,loginCode);
									break;
								}
							}
							pstmt.close();
							rs.close();
						}
						else if (childNodeName.equals("mfg_date"))
						{
//						DO NOT CHECK MFG DATE IF STRUCTURE CONVERSION
							backflushType = genericUtility.getColumnValue("backflush_type", dom1);
							itemCode = genericUtility.getColumnValue("item_code", dom);
							mfgDateS = genericUtility.getColumnValue("mfg_date", dom);
							if (backflushType.equalsIgnoreCase("J"))
							{
								sql = " SELECT CASE WHEN TRACK_SHELF_LIFE IS NULL THEN 'N' ELSE TRACK_SHELF_LIFE END " 
										+ " FROM ITEM WHERE ITEM_CODE = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, itemCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									trackShelfLife = rs.getString(1);
									if (trackShelfLife.equalsIgnoreCase("Y") && mfgDateS == null)
									{
										errCode = "VTMFGDATE3";
										errString = getErrorString("mfg_date",errCode,loginCode);
										break;
									}
								}
								else
								{
									errCode = "VTITEM1";
									errString = getErrorString("mfg_date",errCode,loginCode);
									break;
								}
								pstmt.close();
								rs.close();
							}
						}
						else if (childNodeName.equals("exp_date"))
						{
//						DO NOT CHECK EXP DATE IF STRUCTURE CONVERSION
							backflushType = genericUtility.getColumnValue("backflush_type", dom1);
							itemCode = genericUtility.getColumnValue("item_code", dom);
							expDateS = genericUtility.getColumnValue("exp_date", dom);
							if (backflushType.equalsIgnoreCase("J"))
							{
								sql = " SELECT CASE WHEN TRACK_SHELF_LIFE IS NULL THEN 'N' ELSE TRACK_SHELF_LIFE END " 
										+ " FROM ITEM WHERE ITEM_CODE = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, itemCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									trackShelfLife = rs.getString(1);
									if (trackShelfLife.equalsIgnoreCase("Y") && expDateS == null)
									{
										errCode = "VTEXPDATE1";
										errString = getErrorString("exp_date",errCode,loginCode);
										break;
									}
								}
								else
								{
									errCode = "VTITEM1";
									errString = getErrorString("exp_date",errCode,loginCode);
									break;
								}
								pstmt.close();
								rs.close();
							}
						}						
						else if (childNodeName.equals("quantity"))
						{
							quantity = Double.parseDouble(genericUtility.getColumnValue("quantity", dom));
							if (quantity > 0)
							{
								siteCode = genericUtility.getColumnValue("site_code", dom1);
								locCode = genericUtility.getColumnValue("loc_code", dom);
								itemCode = genericUtility.getColumnValue("item_code", dom);
								lotNo = genericUtility.getColumnValue("lot_no", dom);
								lotSl = genericUtility.getColumnValue("lot_sl", dom);

								sql = " SELECT CASE WHEN (QUANTITY - ALLOC_QTY) IS NULL THEN 0 ELSE (QUANTITY - ALLOC_QTY) END"
								    + " FROM STOCK WHERE SITE_CODE = ? AND LOC_CODE  = ? "
										+ " AND ITEM_CODE = ? AND LOT_NO = ? AND	LOT_SL = ?";

								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, siteCode);
								pstmt.setString(2, locCode);
								pstmt.setString(3, itemCode);
								pstmt.setString(4, lotNo);
								pstmt.setString(5, lotSl);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									stkQty = rs.getDouble(1);
								}
								rs.close();
								pstmt.close();
								if (stkQty < Math.abs(quantity))
								{
									errCode = "VTSTKW";
									errString = getErrorString("quantity",errCode,loginCode);
									break;
								}
							}
						}
						else if (childNodeName.equals("grade"))
						{
							grade = genericUtility.getColumnValue("grade", dom)== null? "":genericUtility.getColumnValue("grade", dom);
							siteCode = genericUtility.getColumnValue("site_code", dom1);
							locCode = genericUtility.getColumnValue("loc_code", dom);
							itemCode = genericUtility.getColumnValue("item_code", dom);
							lotNo = genericUtility.getColumnValue("lot_no", dom);
							lotSl = genericUtility.getColumnValue("lot_sl", dom);

							sql = " SELECT COUNT(*) FROM STOCK WHERE SITE_CODE = ? AND LOC_CODE  = ? "
									+ " AND ITEM_CODE = ? AND LOT_NO = ? AND	LOT_SL = ?";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							pstmt.setString(2, locCode);
							pstmt.setString(3, itemCode);
							pstmt.setString(4, lotNo);
							pstmt.setString(5, lotSl);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							pstmt.close();
							if (cnt != 0)
							{
								sql = " SELECT GRADE FROM STOCK WHERE SITE_CODE = ? AND LOC_CODE  = ? "
										+ " AND ITEM_CODE = ? AND LOT_NO = ? AND	LOT_SL = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, siteCode);
								pstmt.setString(2, locCode);
								pstmt.setString(3, itemCode);
								pstmt.setString(4, lotNo);
								pstmt.setString(5, lotSl);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									stkGrade = rs.getString(1)==null?"":rs.getString(1);
								}
								rs.close();
								pstmt.close();
								if (stkGrade != grade)
								{
									errCode = "VTGRVLD"; //Grade mismatch! Stock for this lot already exists with grade " + ls_stkgrade
									// + ", Please change the lot no or lot sl
									errString = getErrorString("grade",errCode,loginCode);
									break;
								}
							}
						}
					}//END FOR
                    break;
				case 3:
					parentNodeList = dom.getElementsByTagName("Detail3");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
//						if (childNodeName.equals("item_code"))
//						{
//							itemCode = genericUtility.getColumnValue("item_code", dom);
//							siteCode = genericUtility.getColumnValue("site_code", dom1); 							
//                            itemCodeFG = genericUtility.getColumnValue("item_code", dom);
//							errCode = isItem(siteCode, itemCode, "R-BFS", conn);
//							if (errCode != null &&  errCode != "")
//							{
//								errString = getErrorString("item_code",errCode,loginCode);
//								break;
//							}
//							else
//							{
//								backflushType = genericUtility.getColumnValue("backflush_type", dom2);
//							//	if (backflushType.equalsIgnoreCase("S") || backflushType.equalsIgnoreCase("C"))
//
//								if ("S".equalsIgnoreCase(backflushType) || "C".equalsIgnoreCase(backflushType))
//								{
////									//FOR SOLVENT & STRUCTURE CONVERSION PARENT ITEM OF BOTH HEADER/DETAIL ITEM SHOULD BE SAME
//									sql = "SELECT ITEM_PARNT FROM ITEM WHERE ITEM_CODE = ? "; 
//									pstmt = conn.prepareStatement(sql);
//									pstmt.setString(1, itemCodeFG);
//									rs = pstmt.executeQuery();
//									if (rs.next())
//									{
//										parentHdr = rs.getString(1);
//										sql = " SELECT ITEM_PARNT FROM ITEM WHERE ITEM_CODE = ? "; 
//										pstmt1 = conn.prepareStatement(sql);
//										pstmt1.setString(1, itemCode);
//										rs1 = pstmt1.executeQuery();
//										if (rs1.next())
//										{
//											parentDet = rs1.getString(1);
//										}
//										rs1.close();
//										pstmt1.close();
//									}
//									rs.close();
//									pstmt.close();
//									if (parentHdr != parentDet)
//									{
//										errCode = "VTITEMPAR";
//										errString = getErrorString("item_code",errCode,loginCode);
//										break;
//									}
//								}
//								//if (backflushType.equalsIgnoreCase("J") || backflushType.equalsIgnoreCase("C"))
//								if ("J".equalsIgnoreCase(backflushType) || "C".equalsIgnoreCase(backflushType))
//
//								{
//									if (itemCodeFG == itemCode)
//									{
//										errCode = "VTITEMSAME";
//										errString = getErrorString("item_code",errCode,loginCode);
//										break;
//									}
//								}
//							}
//						}
						if (childNodeName.equals("loc_code"))
						{
                            String qcReqd = "";
							locCode = genericUtility.getColumnValue("loc_code", dom);
                            qcReqd = genericUtility.getColumnValue("qc_reqd", dom);
							sql = "SELECT COUNT(*) FROM LOCATION WHERE LOC_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, locCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
								if (cnt == 0)
								{
									errCode = "VMLOC1";
									errString = getErrorString("loc_code",errCode,loginCode);
									break;
								}
							}
							pstmt.close();
							rs.close();
							if (errCode == null && errCode.trim().length() == 0 && qcReqd != null && qcReqd.trim().equalsIgnoreCase("Y")) 
							{
								sql = " SELECT COUNT(*) FROM INVSTAT A, LOCATION B WHERE B.INV_STAT = A.INV_STAT " 
									  + " AND B.LOC_CODE = ? AND A.AVAILABLE = 'N'";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, locCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									cnt = rs.getInt(1);
									if (cnt <= 0)
									{
										errCode = "VTLOCSL";
										errString = getErrorString("loc_code",errCode,loginCode);
										break;
									}
								}
								pstmt.close();
								rs.close();
							}
						}
						else if (childNodeName.equals("quantity")){
                            quantity = Double.parseDouble(genericUtility.getColumnValue("quantity", dom));
                            backflushType = genericUtility.getColumnValue("backflush_type", dom1);

                            if (quantity == 0 && backflushType.equalsIgnoreCase("J"))
                            {
                                    errCode = "VTQTY";
                                    errString = getErrorString("quantity",errCode,loginCode);
                                    break;
                            }
                            else if (quantity < 0){
                                siteCode = genericUtility.getColumnValue("site_code", dom1);
                                locCode = genericUtility.getColumnValue("loc_code", dom);
                                itemCode = genericUtility.getColumnValue("item_code", dom);
                                lotNo = genericUtility.getColumnValue("lot_no", dom);
                                lotSl = genericUtility.getColumnValue("lot_sl", dom);

                                sql = " SELECT CASE WHEN (QUANTITY - ALLOC_QTY) IS NULL THEN 0 ELSE (QUANTITY - ALLOC_QTY) END"
                                    + " FROM STOCK WHERE SITE_CODE = ? AND LOC_CODE  = ? "
                                        + " AND ITEM_CODE = ? AND LOT_NO = ? AND    LOT_SL = ?";

                                pstmt = conn.prepareStatement(sql);
                                pstmt.setString(1, siteCode);
                                pstmt.setString(2, locCode);
                                pstmt.setString(3, itemCode);
                                pstmt.setString(4, lotNo);
                                pstmt.setString(5, lotSl);
                                rs = pstmt.executeQuery();
                                if (rs.next())
                                {
                                    stkQty = rs.getDouble(1);
                                }
                                rs.close();
                                pstmt.close();
                                if (stkQty < Math.abs(quantity))
                                {
                                    errCode = "VTSTKW";
                                    errString = getErrorString("quantity",errCode,loginCode);
                                    break;
                                }
                            }
						}
						else if (childNodeName.equals("unit"))
						{
							unit = genericUtility.getColumnValue("unit", dom);
							sql = "SELECT COUNT(*) FROM UOM WHERE UNIT = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, unit);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
								if (cnt == 0)
								{
									errCode = "VTUNIT1";
									errString = getErrorString("unit",errCode,loginCode);
									break;
								}
							}
							pstmt.close();
							rs.close();
						}
						else if (childNodeName.equals("lot_sl")){
						    
						}
                        else if (childNodeName.equals("pack_code"))
                        {
                            packCode = genericUtility.getColumnValue("pack_code", dom);
                            sql = "SELECT COUNT(*) FROM ITEM WHERE PACK_CODE = ?";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, packCode);
                            rs = pstmt.executeQuery();
                            if (rs.next())
                            {
                                cnt = rs.getInt(1);
                                if (cnt == 0)
                                {
                                    errCode = "VTPKCD1";
                                    errString = getErrorString("pack_code",errCode,loginCode);
                                    break;
                                }
                            }
                            pstmt.close();
                            rs.close();
                        }
					}//END FOR
					break;
				case 4:
					parentNodeList = dom.getElementsByTagName("Detail4");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equals("itm_default"))
						{
						}
					}//END FOR
					break;
			}//END SWITCH
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
		}
		finally
		{
			try	{
				pstmt.close(); pstmt = null; rs.close(); rs = null;
				conn.close();conn = null;
			}catch(Exception d){}
		}

		System.out.println("ErrString ::"+ errString);
		return errString;
	}//END OF VALIDATION 

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = null;
		try
		{
			dom = parseString(xmlString); 
			System.out.println("xmlString" + xmlString);
			dom1 = parseString(xmlString1); 
			System.out.println("xmlString1" + xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				System.out.println("xmlString2" + xmlString2);
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [RcpBackflushEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
        return valueXmlString; 
	}
	
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = null;
		int currentFormNo = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String columnValue = null;
		String grade = "", backflushType = "", siteCode = "", siteDescr = "", itemCode = "";
		String unit = "", packCode = "", itemDescr = "", bomCode = "", lotNo = "", lotSl = "";
		String acctStr = "", acctCodeGl = "", cctrCodeGl = "", locCode = "", locDescr = "", qcFlagEdit = "";
		String siteCodeMfg = "", projCode = "", projDescr = "", mfgDateS = "", expDateS = "", shelfLife = "";
		double quantity = 0, rate = 0, grossWeight = 0, tareWeight = 0, netWeight = 0;
		String phyAttrib1 ="",phyAttrib2="",phyAttrib3="",phyAttrib4="",phyAttrib5="",phyAttrib6="";
		NodeList parentNodeList = null;
		Node parentNode = null; 
		Node childNode = null;
		NodeList childNodeList = null;
		String childNodeName = null;
		int childNodeListLength = 0;
		int ctr = 0;
		String itemTypeDescr ="",itemType ="",itemSer ="",descr="";
		MfgCommon mfgCommon = new MfgCommon();
		FinCommon finCommon = new FinCommon();
		String loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
		
		try
		{
			//Changed by Poonam Gole for changing connection object :Start
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection() ;
			//Changed by Poonam Gole for changing connection object :End
			connDriver = null;
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[RcpBackflushEJB] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			valueXmlString.append("<Detail>");	
			System.out.println("Current Form No ["+currentFormNo+"]");							
			switch (currentFormNo)
			{
				case 1:
//				SEARCHING THE DOM FOR THE INCOMING COLUMN VALUE START
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					ctr = 0;
					childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equals(currentColumn))
						{
							if (childNode.getFirstChild() != null)
							{
								columnValue=childNode.getFirstChild().getNodeValue().trim();
							}
						}
						ctr++;
					}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
					System.out.println("[" + currentColumn + "] ==> '" + columnValue + "'");
					if (currentColumn.trim().equals("itm_default"))
					{
							valueXmlString.append("<site_code>").append("<![CDATA[" + loginSite + "]]>").append("</site_code>");
							valueXmlString.append("<tran_date>").append("<![CDATA[" + genericUtility.getValidDateString(new Timestamp(System.currentTimeMillis()).toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()) + "]]>").append("</tran_date>");
							valueXmlString.append("<backflush_type>").append("<![CDATA[J]]>").append("</backflush_type>");
							sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
						
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, loginSite);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								siteDescr = rs.getString(1);
							}
							rs.close();
							pstmt.close();

							valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr + "]]>").append("</site_descr>");

					}
					if (currentColumn.trim().equals("site_code"))
					{
						siteCode = genericUtility.getColumnValue("site_code", dom);

						sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							siteDescr = rs.getString(1);
						}
						rs.close();
						pstmt.close();

						valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr + "]]>").append("</site_descr>");
					}
                    else if (currentColumn.trim().equals("bom_code"))
                    {
                        String desc = "";
                        bomCode = genericUtility.getColumnValue("bom_code", dom);
                        sql = "select descr from bom where bom_code = '"+bomCode+"'";
                        pstmt = conn.prepareStatement(sql);
                        rs = pstmt.executeQuery();
                        if(rs.next()){
                            desc = rs.getString("descr");
                        }                        
                        valueXmlString.append("<bom_descr>").append("<![CDATA["+desc+"]]>").append("</bom_descr>");
                    }
					else if (currentColumn.trim().equals("proj_code"))
					{
						projCode = genericUtility.getColumnValue("proj_code", dom);

						sql = "SELECT DESCR, SITE_CODE FROM PROJECT WHERE PROJ_CODE = ?";
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, projCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							projDescr = rs.getString(1);
							siteCode = rs.getString(2);
						}
						rs.close();
						pstmt.close();
						valueXmlString.append("<project_descr>").append("<![CDATA[" + projDescr + "]]>").append("</project_descr>");

						sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							siteDescr = rs.getString(1);
						}
						rs.close();
						pstmt.close();
						valueXmlString.append("<site_code>").append("<![CDATA[" + siteCode + "]]>").append("</site_code>");
						valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr + "]]>").append("</site_descr>");
					}
					valueXmlString.append("</Detail>");
					break;
				
				case 2:
//				 SEARCHING THE DOM FOR THE INCOMING COLUMN VALUE START
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					ctr = 0;
					childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equals(currentColumn))
						{
							if (childNode.getFirstChild() != null)
							{
								columnValue=childNode.getFirstChild().getNodeValue();
							}
						}
						ctr++;
					} while (ctr < childNodeListLength && !childNodeName.equals(currentColumn));
					System.out.println("[" + currentColumn + "] ==> '" + columnValue + "'");
//					SEARCHING THE DOM FOR THE INCOMING COLUMN VALUE END
					if (currentColumn.trim().equals("itm_default"))
					{
						valueXmlString.append("<amount>").append("<![CDATA[0]]>").append("</amount>");
						valueXmlString.append("<quantity>").append("<![CDATA[0]]>").append("</quantity>");
						valueXmlString.append("<rate>").append("<![CDATA[0]]>").append("</rate>");
					}
					else if (currentColumn.trim().equals("itm_defaultedit"))
					{
					}
					else if (currentColumn.trim().equals("item_code"))
					{
						itemCode = genericUtility.getColumnValue("item_code", dom);

						sql = "SELECT DESCR,UNIT FROM ITEM WHERE ITEM_CODE = ?";
					
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, itemCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							itemDescr = rs.getString(1);
							unit = rs.getString(2);
						}
						rs.close();
						pstmt.close();

						valueXmlString.append("<item_descr>").append("<![CDATA[" + itemDescr + "]]>").append("</item_descr>");
						valueXmlString.append("<unit>").append("<![CDATA[" + unit + "]]>").append("</unit>");
					}
					else if (currentColumn.trim().equals("loc_code"))
					{
						locCode = genericUtility.getColumnValue("loc_code", dom);

						sql = "SELECT DESCR FROM LOCATION WHERE LOC_CODE = ?";
					
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, locCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							locDescr = rs.getString(1);
						}
						rs.close();
						pstmt.close();
						valueXmlString.append("<location_descr>").append("<![CDATA[" + locDescr + "]]>").append("</location_descr>");
					}
					else if (currentColumn.trim().equals("lot_sl"))
					{
						siteCode = genericUtility.getColumnValue("site_code", dom1);
						locCode = genericUtility.getColumnValue("loc_code", dom);
						itemCode = genericUtility.getColumnValue("item_code", dom);
						lotNo = genericUtility.getColumnValue("lot_no", dom);
						lotSl = genericUtility.getColumnValue("lot_sl", dom);

						sql = " SELECT MFG_DATE,EXP_DATE,SITE_CODE__MFG,PACK_CODE, GRADE, RATE, (QUANTITY - ALLOC_QTY) AS QTY" 
								+ " FROM STOCK WHERE SITE_CODE = ? AND LOC_CODE  = ? AND ITEM_CODE = ? AND "
								+ " LOT_NO = ? AND	LOT_SL = ?";

						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						pstmt.setString(2, locCode);
						pstmt.setString(3, itemCode);
						pstmt.setString(4, lotNo);
						pstmt.setString(5, lotSl);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							mfgDateS = rs.getTimestamp(1) == null ? "":genericUtility.getValidDateString(rs.getTimestamp(1).toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
							expDateS = rs.getTimestamp(2) == null ? "":genericUtility.getValidDateString(rs.getTimestamp(2).toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
							siteCodeMfg = rs.getString(3) == null ? "":rs.getString(3);
							packCode = rs.getString(4) == null ? "":rs.getString(4);
							grade = rs.getString(5) == null ? "":rs.getString(5);
							rate = rs.getDouble(6);
							quantity = rs.getDouble(7);
						}
						rs.close();
						pstmt.close();

						valueXmlString.append("<grade>").append("<![CDATA[" + grade + "]]>").append("</grade>");
						valueXmlString.append("<mfg_date>").append("<![CDATA[" + mfgDateS + "]]>").append("</mfg_date>");
						valueXmlString.append("<exp_date>").append("<![CDATA[" + expDateS + "]]>").append("</exp_date>");
						valueXmlString.append("<site_code__mfg>").append("<![CDATA[" + siteCodeMfg + "]]>").append("</site_code__mfg>");
						valueXmlString.append("<pack_code>").append("<![CDATA[" + packCode + "]]>").append("</pack_code>");
						valueXmlString.append("<quantity>").append("<![CDATA[" + quantity + "]]>").append("</quantity>");
						valueXmlString.append("<amount>").append("<![CDATA[" + quantity*rate + "]]>").append("</amount>");
						valueXmlString.append("<rate>").append("<![CDATA[" + rate + "]]>").append("</rate>");
/*
				/// Raman 1/2/02 -  Set stock's available quantity ( quantity - alloc_qty ) select quantity,rate
				// if quantity in header is negative then do not set the quantity from stock
				// as the detail quantity will be a receipt instead of issue
				lc_quantity = dw_header.getitemdecimal(1,"quantity")
				if lc_quantity >= 0 then
					select ( quantity - nvl(alloc_qty,0) ) quantity, rate
					into  :lc_qty, :lc_rate from  stock
					where item_code = :ls_itemcode and
							site_code = :ls_sitecode and
							loc_code  = :ls_loccode and
							lot_no 	 = :ls_lotno and
							lot_sl 	 = :ls_lotsl ;
					if get_sqlcode() = 0 then
						if isnull(lc_rate) then lc_rate = 0
						if isnull(lc_qty) then lc_qty = 0
						dw_detedit[ii_currformno].setitem(1,"quantity",lc_qty)
						dw_detedit[ii_currformno].setitem(1,"rate",lc_rate)
						dw_detedit[ii_currformno].setitem(1,"amount",lc_rate * lc_qty)
						dw_detedit[ii_currformno].setitem(1,"net_amt",lc_rate * lc_qty)
					end if
					gbf_itemchanged_logic(as_form_no,"quantity",as_editflag)
				end if
*/
					}
					else if (currentColumn.trim().equals("quantity") || currentColumn.trim().equals("rate"))
					{
						quantity = Double.parseDouble(genericUtility.getColumnValue("quantity", dom));
						rate = Double.parseDouble(genericUtility.getColumnValue("rate", dom));

						valueXmlString.append("<amount>").append("<![CDATA[" + quantity*rate + "]]>").append("</amount>");
						valueXmlString.append("<rate>").append("<![CDATA[" + rate + "]]>").append("</rate>");
					}
					valueXmlString.append("</Detail>");
					break;


				case 3:  //RECEIPT SCREEN - HEADER OF RECEIPT BKFLSH OLD
//				SEARCHING THE DOM FOR THE INCOMING COLUMN VALUE START
					parentNodeList = dom.getElementsByTagName("Detail3");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					ctr = 0;
					childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equals(currentColumn))
						{
							if (childNode.getFirstChild() != null)
							{
								columnValue=childNode.getFirstChild().getNodeValue().trim();
							}
						}
						ctr++;
					}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
					System.out.println("[" + currentColumn + "] ==> '" + columnValue + "'");
					if (currentColumn.trim().equals("itm_default"))
					{
						valueXmlString.append("<site_code__mfg>").append("<![CDATA[" + loginSite + "]]>").append("</site_code__mfg>");
						valueXmlString.append("<lot_sl>").append("<![CDATA[1S]]>").append("</lot_sl>");
						valueXmlString.append("<loc_code>").append("<![CDATA[QUAR]]>").append("</loc_code>");
						valueXmlString.append("<pack_code>").append("<![CDATA[DUMMY]]>").append("</pack_code>");
                       // valueXmlString.append("<lot_no protect = \"1\"><![CDATA[    ]]></lot_no>");
//						set grade from mfgparm 
						grade = mfgCommon.getEnvMfg("999999","MFG_GRADE", conn);
						if (grade.equalsIgnoreCase("NULLFOUND"))
						{
							grade = "";
						}
						valueXmlString.append("<grade>").append("<![CDATA[" + grade +"]]>").append("</grade>");
						qcFlagEdit = mfgCommon.getEnvMfg("999999", "QC_FLAG_EDITABLE", conn);
						if (qcFlagEdit.equalsIgnoreCase("Y")){
							valueXmlString.append("<qc_reqd protect = \"0\">").append("<![CDATA[Y]]>").append("</qc_reqd>");							
						}else{
                            valueXmlString.append("<qc_reqd protect = \"1\">").append("<![CDATA[Y]]>").append("</qc_reqd>");						    
                        }
                        valueXmlString.append("<amount>").append("<![CDATA[0]]>").append("</amount>");
                        valueXmlString.append("<quantity>").append("<![CDATA[0]]>").append("</quantity>");
                        valueXmlString.append("<rate>").append("<![CDATA[0]]>").append("</rate>");
					}
					else if (currentColumn.trim().equals("itm_defaultedit"))
					{		
				
						itemCode = genericUtility.getColumnValue("item_code", dom,"3");


						String itemCode1 = genericUtility.getColumnValue("item_code", dom);
						System.out.println("itemCode1 : " + itemCode1);
						System.out.println("itemCode..itm_defaultedit......."+itemCode);
//						 sql = " SELECT PHY_ATTRIB_1,PHY_ATTRIB_2,PHY_ATTRIB_3,PHY_ATTRIB_4,PHY_ATTRIB_5,"
//						  + " PHY_ATTRIB_6 FROM ITEM_TYPE WHERE ITEM_TYPE =  "
//						  + " ( SELECT ITEM_TYPE FROM ITEM WHERE ITEM_CODE = '" + itemCode + "')";
//					  System.out.println("SQL : " + sql);
//					  pstmt = conn.prepareStatement(sql);
//					  rs = pstmt.executeQuery();
//					  System.out.println("Query is executed : ");
//					  if(rs.next())
//					  {						
//							phyAttrib1 = rs.getString("PHY_ATTRIB_1");
//							phyAttrib2 = rs.getString("PHY_ATTRIB_2");
//							phyAttrib3 = rs.getString("PHY_ATTRIB_3");
//							phyAttrib4 = rs.getString("PHY_ATTRIB_4");
//							phyAttrib5 = rs.getString("PHY_ATTRIB_5");
//							phyAttrib6 = rs.getString("PHY_ATTRIB_6");
//					  }
//					  valueXmlString.append("<phy_attrib_lab_1>").append("<![CDATA[" + phyAttrib1 + "]]>").append("</phy_attrib_lab_1>");
//					  valueXmlString.append("<phy_attrib_lab_2>").append("<![CDATA[" + phyAttrib2 + "]]>").append("</phy_attrib_lab_2>");
//					  valueXmlString.append("<phy_attrib_lab_3>").append("<![CDATA[" + phyAttrib3 + "]]>").append("</phy_attrib_lab_3>");
//					  valueXmlString.append("<phy_attrib_lab_4>").append("<![CDATA[" + phyAttrib4 + "]]>").append("</phy_attrib_lab_4>");
//					  valueXmlString.append("<phy_attrib_lab_5>").append("<![CDATA[" + phyAttrib5 + "]]>").append("</phy_attrib_lab_5>");
//					  valueXmlString.append("<phy_attrib_lab_6>").append("<![CDATA[" + phyAttrib6 + "]]>").append("</phy_attrib_lab_6>");
//					
				
					}
					else if(currentColumn.trim().equalsIgnoreCase("item_type"))
				   {	
					  itemType = genericUtility.getColumnValue("item_type", dom);
					  itemTypeDescr = getFieldValue("descr", "item_type", "item_type", itemType, conn);
					  itemTypeDescr = itemTypeDescr == null ? "" : itemTypeDescr ;
					  valueXmlString.append("<item_type_descr>").append("<![CDATA[" + itemTypeDescr + "]]>").append("</item_type_descr>");
					  sql = " SELECT PHY_ATTRIB_1,PHY_ATTRIB_2,PHY_ATTRIB_3,PHY_ATTRIB_4,PHY_ATTRIB_5,"
						  + " PHY_ATTRIB_6,unit  FROM ITEM_TYPE WHERE ITEM_TYPE =  '"+itemType+" ' ";
						 
					  System.out.println("SQL : " + sql);
					  pstmt = conn.prepareStatement(sql);
					  rs = pstmt.executeQuery();
					  System.out.println("Query is executed : ");
					  if(rs.next())
					  {						
							phyAttrib1 = rs.getString("PHY_ATTRIB_1");
							phyAttrib2 = rs.getString("PHY_ATTRIB_2");
							phyAttrib3 = rs.getString("PHY_ATTRIB_3");
							phyAttrib4 = rs.getString("PHY_ATTRIB_4");
							phyAttrib5 = rs.getString("PHY_ATTRIB_5");
							phyAttrib6 = rs.getString("PHY_ATTRIB_6");
							unit =rs.getString("unit");
					  }
					  valueXmlString.append("<lphy_attrib_1>").append("<![CDATA[" + phyAttrib1 + "]]>").append("</lphy_attrib_1>");
					  valueXmlString.append("<lphy_attrib_2>").append("<![CDATA[" + phyAttrib2 + "]]>").append("</lphy_attrib_2>");
					  valueXmlString.append("<lphy_attrib_3>").append("<![CDATA[" + phyAttrib3 + "]]>").append("</lphy_attrib_3>");
					  valueXmlString.append("<lphy_attrib_4>").append("<![CDATA[" + phyAttrib4 + "]]>").append("</lphy_attrib_4>");
					  valueXmlString.append("<lphy_attrib_5>").append("<![CDATA[" + phyAttrib5 + "]]>").append("</lphy_attrib_5>");
					  valueXmlString.append("<lphy_attrib_6>").append("<![CDATA[" + phyAttrib6 + "]]>").append("</lphy_attrib_6>");
					 	valueXmlString.append("<unit>").append("<![CDATA[" + unit + "]]>").append("</unit>");

				   }
				   else if(currentColumn.trim().equalsIgnoreCase("item_ser"))
					{
					  itemSer = genericUtility.getColumnValue("item_ser", dom);
					  System.out.println("itemSer : " + itemSer);
					  sql = " SELECT DESCR FROM ITEMSER WHERE ITEM_SER ='"+itemSer+"'";
					  System.out.println("SQL : " + sql);
					  pstmt = conn.prepareStatement(sql);
					  rs = pstmt.executeQuery();
					  System.out.println("Query is executed : ");
					  if(rs.next())
					  {						
							descr = rs.getString(1);
							System.out.println("descr .......... "+descr);
					  }
					  valueXmlString.append("<itemser_descr>").append("<![CDATA[" + descr + "]]>").append("</itemser_descr>");

					}
					else if (currentColumn.trim().equals("item_code"))
					{
						String qcReqd = null;
						itemCode = genericUtility.getColumnValue("item_code", dom);
						System.out.println("itemCode from dom [" + itemCode + "]");
						siteCode = genericUtility.getColumnValue("site_code", dom1);
						System.out.println("siteCode from dom1 [" + siteCode + "]");

						sql = "SELECT DESCR,UNIT,PACK_CODE FROM ITEM WHERE ITEM_CODE = ?";
					
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, itemCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							itemDescr = rs.getString(1);
							unit = rs.getString(2);
							packCode = rs.getString(3);
						}
						rs.close();
						pstmt.close();
						//MfgCommon mfgCommon = new MfgCommon();
						String qcRqYn = mfgCommon.getEnvMfg("999999","QC_FLAG_EDITABLE", conn);
						//mfgCommon = null;
						System.out.println("qcRqYn  ["+qcRqYn+"]");
						if(!("Y".equalsIgnoreCase(qcRqYn)))
						{
						
						
								sql = "SELECT QC_REQD FROM SITEITEM WHERE ITEM_CODE = '"+itemCode+"'";
								System.out.println("sql["+sql+"]");
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									qcReqd = rs.getString(1);
									rs.close();
									pstmt.close();	
								}
								else
								{
									sql = "SELECT QC_REQD FROM ITEM WHERE ITEM_CODE = '"+itemCode+"'";
									System.out.println("sql["+sql+"]");
									pstmt = conn.prepareStatement(sql);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										qcReqd = rs.getString(1);
										rs.close();
										pstmt.close();	
									}
									
								}
								System.out.println("Qc Required for the item ["+itemCode+"] is ["+qcReqd+"]");
								if("Y".equalsIgnoreCase(qcReqd))
								{
									valueXmlString.append("<lot_no protect = \"1\"><![CDATA[    ]]></lot_no>");
								}
								else
								{
									valueXmlString.append("<lot_no protect = \"0\"><![CDATA[    ]]></lot_no>");
									
								}
							}
							else
							{
									valueXmlString.append("<lot_no protect = \"0\"><![CDATA[    ]]></lot_no>");
 
							}
								
							  // itemCode = genericUtility.getColumnValue("item_code", dom);
							  //itemDescr = getFieldValue("descr", "item", "item_code", itemCode, conn);
							 // itemDescr = itemDescr == null ? "" : itemDescr ;
							 // unit = getFieldValue("unit", "item", "item_code", itemCode, conn);
							 // valueXmlString.append("<item_descr>").append("<![CDATA[" + itemDescr + "]]>").append("</item_descr>");
							 // valueXmlString.append("<unit>").append("<![CDATA[" + unit + "]]>").append("</unit>");
//							  sql = " SELECT PHY_ATTRIB_1,PHY_ATTRIB_2,PHY_ATTRIB_3,PHY_ATTRIB_4,PHY_ATTRIB_5,"
//								  + " PHY_ATTRIB_6 FROM ITEM_TYPE WHERE ITEM_TYPE =  "
//								  + " ( SELECT ITEM_TYPE FROM ITEM WHERE ITEM_CODE = '" + itemCode + "')";
//							  System.out.println("SQL : " + sql);
//							  pstmt = conn.prepareStatement(sql);
//							  rs = pstmt.executeQuery();
//							  System.out.println("Query is executed : ");
//							  if(rs.next())
//							  {						
//									phyAttrib1 = rs.getString("PHY_ATTRIB_1");
//									phyAttrib2 = rs.getString("PHY_ATTRIB_2");
//									phyAttrib3 = rs.getString("PHY_ATTRIB_3");
//									phyAttrib4 = rs.getString("PHY_ATTRIB_4");
//									phyAttrib5 = rs.getString("PHY_ATTRIB_5");
//									phyAttrib6 = rs.getString("PHY_ATTRIB_6");
//							  }
//							  rs.close();
//							  valueXmlString.append("<phy_attrib_lab_1>").append("<![CDATA[" + phyAttrib1 + "]]>").append("</phy_attrib_lab_1>");
//							  valueXmlString.append("<phy_attrib_lab_2>").append("<![CDATA[" + phyAttrib2 + "]]>").append("</phy_attrib_lab_2>");
//							  valueXmlString.append("<phy_attrib_lab_3>").append("<![CDATA[" + phyAttrib3 + "]]>").append("</phy_attrib_lab_3>");
//							  valueXmlString.append("<phy_attrib_lab_4>").append("<![CDATA[" + phyAttrib4 + "]]>").append("</phy_attrib_lab_4>");
//							  valueXmlString.append("<phy_attrib_lab_5>").append("<![CDATA[" + phyAttrib5 + "]]>").append("</phy_attrib_lab_5>");
//							  valueXmlString.append("<phy_attrib_lab_6>").append("<![CDATA[" + phyAttrib6 + "]]>").append("</phy_attrib_lab_6>");
						
						
						
						
						valueXmlString.append("<item_descr>").append("<![CDATA[" + itemDescr + "]]>").append("</item_descr>");
						valueXmlString.append("<unit>").append("<![CDATA[" + unit + "]]>").append("</unit>");
						valueXmlString.append("<pack_code><![CDATA[").append(packCode == null ? "":packCode).append("]]></pack_code>");

//						GET ACCOUNT CODE CONV GL FROM ITEM ACCT DETR
						acctStr = finCommon.getFromAcctDetr(itemCode, "","CONVGL", conn);
						if (acctStr != null && acctStr.trim().length() > 0)
						{
							acctCodeGl = acctStr.substring(0,acctStr.indexOf(","));
							cctrCodeGl = acctStr.substring(acctStr.indexOf(",")+1);
						}

						//valueXmlString.append("<acct_code__conv_gl>").append("<![CDATA[" + acctCodeGl + "]]>").append("</acct_code__conv_gl>");
						//valueXmlString.append("<cctr_code__conv_gl>").append("<![CDATA[" + cctrCodeGl + "]]>").append("</cctr_code__conv_gl>");
					}
					else if (currentColumn.trim().equals("loc_code"))
					{
						locCode = genericUtility.getColumnValue("loc_code", dom);
						backflushType = genericUtility.getColumnValue("backflush_type", dom1);
						sql = "SELECT DESCR FROM LOCATION WHERE LOC_CODE = ?";
					
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, locCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							locDescr = rs.getString(1);
						}
						rs.close();
						pstmt.close();
						valueXmlString.append("<location_descr>").append("<![CDATA[" + locDescr + "]]>").append("</location_descr>");
//						SETTING OF MFG_DATE AND EXP_DATE FROM STOCK IF PRESENT.
						siteCode = genericUtility.getColumnValue("site_code", dom1);
						itemCode = genericUtility.getColumnValue("item_code", dom);
						lotNo = genericUtility.getColumnValue("lot_no", dom);
						lotSl = genericUtility.getColumnValue("lot_sl", dom);

						sql = " SELECT SITE_CODE__MFG,PACK_CODE FROM STOCK " 
							+ " WHERE SITE_CODE = ? AND LOC_CODE  = ? AND ITEM_CODE = ? AND "
							+ " LOT_NO = ? AND	LOT_SL = ?";

						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						pstmt.setString(2, locCode);
						pstmt.setString(3, itemCode);
						pstmt.setString(4, lotNo);
						pstmt.setString(5, lotSl);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							siteCodeMfg = rs.getString(1);
							packCode = rs.getString(2);
						}
						rs.close();
						pstmt.close();
						valueXmlString.append("<site_code__mfg>").append("<![CDATA[" + siteCodeMfg + "]]>").append("</site_code__mfg>");
						valueXmlString.append("<pack_code>").append("<![CDATA[" + packCode + "]]>").append("</pack_code>");
//						MFG_DATE/EXP_DATE WILL BE SET FROM DETAILS OR WILL BE ENTERED.
					}
				 else if(currentColumn.trim().equalsIgnoreCase("phy_attrib_1") || currentColumn.trim().equalsIgnoreCase("phy_attrib_2") || currentColumn.trim().equalsIgnoreCase("phy_attrib_3") || currentColumn.trim().equalsIgnoreCase("phy_attrib_4") || currentColumn.trim().equalsIgnoreCase("phy_attrib_5") || currentColumn.trim().equalsIgnoreCase("phy_attrib_6"))
				  {		
					  String phyAttribDom1 = genericUtility.getColumnValue("phy_attrib_1", dom) ;
					  String phyAttribDom2 = genericUtility.getColumnValue("phy_attrib_2", dom) ;
					  String phyAttribDom3 = genericUtility.getColumnValue("phy_attrib_3", dom) ;
					  String phyAttribDom4 = genericUtility.getColumnValue("phy_attrib_4", dom) ;
					  String phyAttribDom5 = genericUtility.getColumnValue("phy_attrib_5", dom) ;
					  String phyAttribDom6 = genericUtility.getColumnValue("phy_attrib_6", dom) ;
					  phyAttribDom1 = phyAttribDom1 == null ? "" : phyAttribDom1 ;
					  phyAttribDom2 = phyAttribDom2 == null ? "" : phyAttribDom2 ;
					  phyAttribDom3 = phyAttribDom3 == null ? "" : phyAttribDom3 ;
					  phyAttribDom4 = phyAttribDom4 == null ? "" : phyAttribDom4 ;
					  phyAttribDom5 = phyAttribDom5 == null ? "" : phyAttribDom5 ;
					  phyAttribDom6 = phyAttribDom6 == null ? "" : phyAttribDom6 ;
					  sql = " SELECT ITEM_CODE FROM ITEM WHERE PHY_ATTRIB_1 = ? AND PHY_ATTRIB_2 = ? "
						  + " AND PHY_ATTRIB_3 = ? AND PHY_ATTRIB_4 = ? AND  PHY_ATTRIB_5 = ?  AND "
						  + " PHY_ATTRIB_6 = ? " ;
					  System.out.println("SQL : " + sql);
					  pstmt = conn.prepareStatement(sql);
					  pstmt.setString(1, phyAttribDom1);
					  pstmt.setString(2, phyAttribDom2);
					  pstmt.setString(3, phyAttribDom3);
					  pstmt.setString(4, phyAttribDom4);
					  pstmt.setString(5, phyAttribDom5);
					  pstmt.setString(6, phyAttribDom6);
					  rs = pstmt.executeQuery();
					  if(rs.next())
					  {	
						itemCode = rs.getString("ITEM_CODE");
						sql = " SELECT PHY_ATTRIB_1,PHY_ATTRIB_2,PHY_ATTRIB_3,PHY_ATTRIB_4,"
							+ " PHY_ATTRIB_5, PHY_ATTRIB_6 FROM ITEM_TYPE WHERE ITEM_TYPE = "
							+ " ( SELECT ITEM_TYPE FROM ITEM WHERE ITEM_CODE = '" + itemCode + "')";
						System.out.println("SQL : " + sql);
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						System.out.println("Query  is executed : ");
						if(rs.next())
						{	
						  phyAttrib1 = rs.getString("PHY_ATTRIB_1");
						  phyAttrib2 = rs.getString("PHY_ATTRIB_2");
						  phyAttrib3 = rs.getString("PHY_ATTRIB_3");
						  phyAttrib4 = rs.getString("PHY_ATTRIB_4");
						  phyAttrib5 = rs.getString("PHY_ATTRIB_5");
						  phyAttrib6 = rs.getString("PHY_ATTRIB_6");
						}
						itemDescr = getFieldValue("descr", "item", "item_code", itemCode, conn);
						itemDescr = itemDescr == null ? "" : itemDescr ;
						unit = getFieldValue("unit", "item", "item_code", itemCode, conn);
						valueXmlString.append("<item_code>").append("<![CDATA[" + itemCode + "]]>").append("</item_code>");
						valueXmlString.append("<item_descr>").append("<![CDATA[" + itemDescr + "]]>").append("</item_descr>");
						valueXmlString.append("<unit>").append("<![CDATA[" + unit + "]]>").append("</unit>");
//						valueXmlString.append("<phy_attrib_lab_1>").append("<![CDATA[" + phyAttrib1 + "]]>").append("</phy_attrib_lab_1>");
//						valueXmlString.append("<phy_attrib_lab_2>").append("<![CDATA[" + phyAttrib2 + "]]>").append("</phy_attrib_lab_2>");
//						valueXmlString.append("<phy_attrib_lab_3>").append("<![CDATA[" + phyAttrib3 + "]]>").append("</phy_attrib_lab_3>");
//						valueXmlString.append("<phy_attrib_lab_4>").append("<![CDATA[" + phyAttrib4 + "]]>").append("</phy_attrib_lab_4>");
//						valueXmlString.append("<phy_attrib_lab_5>").append("<![CDATA[" + phyAttrib5 + "]]>").append("</phy_attrib_lab_5>");
//						valueXmlString.append("<phy_attrib_lab_6>").append("<![CDATA[" + phyAttrib6 + "]]>").append("</phy_attrib_lab_6>");

					  valueXmlString.append("<lphy_attrib_1>").append("<![CDATA[" + phyAttrib1 + "]]>").append("</lphy_attrib_1>");
					  valueXmlString.append("<lphy_attrib_2>").append("<![CDATA[" + phyAttrib2 + "]]>").append("</lphy_attrib_2>");
					  valueXmlString.append("<lphy_attrib_3>").append("<![CDATA[" + phyAttrib3 + "]]>").append("</lphy_attrib_3>");
					  valueXmlString.append("<lphy_attrib_4>").append("<![CDATA[" + phyAttrib4 + "]]>").append("</lphy_attrib_4>");
					  valueXmlString.append("<lphy_attrib_5>").append("<![CDATA[" + phyAttrib5 + "]]>").append("</lphy_attrib_5>");
					  valueXmlString.append("<lphy_attrib_6>").append("<![CDATA[" + phyAttrib6 + "]]>").append("</lphy_attrib_6>");
					   }
					   else
					   {	
							itemCode = "";
							itemDescr = "";
							phyAttrib1 = "";
							phyAttrib2 = "";
							phyAttrib3 = "";
							phyAttrib4 = "";
							phyAttrib5 = "";
							phyAttrib6 = "";
							unit = "";
							valueXmlString.append("<item_code>").append("<![CDATA[" + itemCode + "]]>").append("</item_code>");
							valueXmlString.append("<item_descr>").append("<![CDATA[" + itemDescr + "]]>").append("</item_descr>");
							valueXmlString.append("<unit>").append("<![CDATA[" + unit + "]]>").append("</unit>");

							valueXmlString.append("<phy_attrib_lab_1>").append("<![CDATA[" + phyAttrib1 + "]]>").append("</phy_attrib_lab_1>");
							valueXmlString.append("<phy_attrib_lab_2>").append("<![CDATA[" + phyAttrib2 + "]]>").append("</phy_attrib_lab_2>");
							valueXmlString.append("<phy_attrib_lab_3>").append("<![CDATA[" + phyAttrib3 + "]]>").append("</phy_attrib_lab_3>");
							valueXmlString.append("<phy_attrib_lab_4>").append("<![CDATA[" + phyAttrib4 + "]]>").append("</phy_attrib_lab_4>");
							valueXmlString.append("<phy_attrib_lab_5>").append("<![CDATA[" + phyAttrib5 + "]]>").append("</phy_attrib_lab_5>");
							valueXmlString.append("<phy_attrib_lab_6>").append("<![CDATA[" + phyAttrib6 + "]]>").append("</phy_attrib_lab_6>");
						}	
				  }
					else if (currentColumn.trim().equals("lot_no") || currentColumn.trim().equals("lot_sl"))
					{
						siteCode = genericUtility.getColumnValue("site_code", dom1);
						locCode = genericUtility.getColumnValue("loc_code", dom);
						itemCode = genericUtility.getColumnValue("item_code", dom);
						lotNo = genericUtility.getColumnValue("lot_no", dom);
						lotSl = genericUtility.getColumnValue("lot_sl", dom);
						quantity = Double.parseDouble(genericUtility.getColumnValue("quantity", dom));

						sql = " SELECT MFG_DATE,EXP_DATE,SITE_CODE__MFG,PACK_CODE, GRADE, RATE FROM STOCK " 
								+ " WHERE SITE_CODE = ? AND LOC_CODE  = ? AND ITEM_CODE = ? AND "
								+ " LOT_NO = ? AND	LOT_SL = ?";

						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						pstmt.setString(2, locCode);
						pstmt.setString(3, itemCode);
						pstmt.setString(4, lotNo);
						pstmt.setString(5, lotSl);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							mfgDateS = rs.getTimestamp(1) == null ? "":genericUtility.getValidDateString(rs.getTimestamp(1).toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
							expDateS = rs.getTimestamp(2) == null ? "":genericUtility.getValidDateString(rs.getTimestamp(2).toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
							siteCodeMfg = rs.getString(3);
							packCode = rs.getString(4);
							grade = rs.getString(5);
							rate = rs.getDouble(6);
						}
						rs.close();
						pstmt.close();

						valueXmlString.append("<grade>").append("<![CDATA[" + grade + "]]>").append("</grade>");
						valueXmlString.append("<mfg_date>").append("<![CDATA[" + mfgDateS + "]]>").append("</mfg_date>");
						valueXmlString.append("<exp_date>").append("<![CDATA[" + expDateS + "]]>").append("</exp_date>");
						valueXmlString.append("<site_code__mfg>").append("<![CDATA[" + siteCodeMfg + "]]>").append("</site_code__mfg>");
						valueXmlString.append("<pack_code>").append("<![CDATA[" + packCode + "]]>").append("</pack_code>");

//					IF QUANTITY IS NEGATIVE SET THE AMOUNT BASED ON STOCK AS ISSUE WILL BE DONE INSTEAD OF RECEIPT
						if (quantity < 0)
						{
							valueXmlString.append("<amount>").append("<![CDATA[" + quantity*rate + "]]>").append("</amount>");
                            valueXmlString.append("<inv_value>").append("<![CDATA[" + quantity*rate + "]]>").append("</inv_value>");
						}
					}

					else if (currentColumn.trim().equals("mfg_date"))
					{
						mfgDateS = genericUtility.getColumnValue("mfg_date", dom);
						itemCode = genericUtility.getColumnValue("item_code", dom);

						sql = "SELECT SHELF_LIFE FROM ITEM WHERE ITEM_CODE = ?";
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, itemCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							shelfLife = rs.getString(1);
						}
						rs.close();
						pstmt.close();
						if (shelfLife == null && shelfLife.trim().length() == 0)
						{
							expDateS = "";
						}
						else
						{
							expDateS = "";
//		???				ldt_exp_date  = gf_calc_expiry(ldt_mfg_date,mshlife)
						}
						valueXmlString.append("<exp_date>").append("<![CDATA[" + expDateS + "]]>").append("</exp_date>");
					}
					else if (currentColumn.trim().equals("gross_weight") || currentColumn.trim().equals("tare_weight"))
					{
						grossWeight = Double.parseDouble(genericUtility.getColumnValue("gross_weight", dom));
						tareWeight = Double.parseDouble(genericUtility.getColumnValue("tare_weight", dom));
//						if (grossWeight == null)
//						{
//							grossWeight = 0;
//						}
//						if (tareWeight == null)
//						{
//							tareWeight = 0;
//						}
						netWeight = grossWeight - tareWeight;
						valueXmlString.append("<net_weight>").append("<![CDATA[" + netWeight + "]]>").append("</net_weight>");
					}
                    else if (currentColumn.trim().equals("amount"))
                    {
                        valueXmlString.append("<inv_value>").append("<![CDATA[" + columnValue + "]]>").append("</inv_value>");
                    }
					else if (currentColumn.trim().equals("quantity"))
					{
						rate = 0;
						siteCode = genericUtility.getColumnValue("site_code", dom1);
						locCode = genericUtility.getColumnValue("loc_code", dom);
						itemCode = genericUtility.getColumnValue("item_code", dom);
						lotNo = genericUtility.getColumnValue("lot_no", dom);
						lotSl = genericUtility.getColumnValue("lot_sl", dom);
						rate = Double.parseDouble(genericUtility.getColumnValue("rate", dom));
						//rate = Double.parseDouble(if(genericUtility.getColumnValue("rate", dom)==null?"0":genericUtility.getColumnValue("rate", dom)));
						quantity = Double.parseDouble(genericUtility.getColumnValue("quantity", dom));

						if (quantity < 0)
						{
//							SET THE INVENTORY VALUE AND AMOUNT BASED ON STOCK AND ISSUE WILL BE DONE INSTEAD OF RECEIPT

							sql = " SELECT RATE FROM STOCK WHERE SITE_CODE = ? AND LOC_CODE  = ? AND ITEM_CODE = ? AND "
									+ " LOT_NO = ? AND	LOT_SL = ?";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							pstmt.setString(2, locCode);
							pstmt.setString(3, itemCode);
							pstmt.setString(4, lotNo);
							pstmt.setString(5, lotSl);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								rate = rs.getDouble(1);
							}
							rs.close();
							pstmt.close();
						}
					

						valueXmlString.append("<amount>").append("<![CDATA[" + quantity*rate + "]]>").append("</amount>");
                        valueXmlString.append("<inv_value>").append("<![CDATA[" + quantity*rate + "]]>").append("</inv_value>");
					}
					else if (currentColumn.trim().equals("rate"))
					{
						quantity = Double.parseDouble(genericUtility.getColumnValue("quantity", dom));
						rate = Double.parseDouble(genericUtility.getColumnValue("rate", dom));
						valueXmlString.append("<amount>").append("<![CDATA[" + quantity*rate + "]]>").append("</amount>");
                        valueXmlString.append("<inv_value>").append("<![CDATA[" + quantity*rate + "]]>").append("</inv_value>");

					
					}
					
					valueXmlString.append("</Detail>");
					break;
					
				case 4:
//				SEARCHING THE DOM FOR THE INCOMING COLUMN VALUE START
					parentNodeList = dom.getElementsByTagName("Detail4");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					ctr = 0;
					childNodeListLength = childNodeList.getLength();
					do
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equals(currentColumn))
						{
							if (childNode.getFirstChild() != null)
							{
								columnValue=childNode.getFirstChild().getNodeValue().trim();
							}
						}
						ctr++;
					}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
					System.out.println("[" + currentColumn + "] ==> '" + columnValue + "'");
					if (currentColumn.trim().equals("emp_code"))
					{
                        String empCode = "",fname = "",lname = "";
                        empCode = genericUtility.getColumnValue("emp_code", dom);
                        sql = "select emp_fname,emp_lname from employee where emp_code = '"+empCode+"'";
                        pstmt = conn.prepareStatement(sql);
                        rs = pstmt.executeQuery();
                        if(rs.next()){
                            fname = rs.getString("emp_fname");
                            lname = rs.getString("emp_lname");
                        }
                        rs.close();
                        pstmt.close();
                        valueXmlString.append("<emp_fname>").append("<![CDATA["+fname+"]]>").append("</emp_fname>");
                        valueXmlString.append("<emp_lname>").append("<![CDATA["+lname+"]]>").append("</emp_lname>");                        
					}
					valueXmlString.append("</Detail>");
				}//END OF SWITCH
				valueXmlString.append("</Root>");				
			}//END OF TRY
		
		catch(Exception e)
		{
			System.out.println("Exception ::"+ e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}//END OF ITEMCHANGE
	private String getFieldValue(String column,String tableName, String columnName, String columnValue,Connection conn)
    {	
    	PreparedStatement pstmt = null;
        ResultSet rs = null;
        String value = null;
        String sql = null;
   
        sql = " select "+column+" from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
        try
        {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
            if(rs.next())
            {
            	value = rs.getString(1) != null ? rs.getString(1) : " ";            	
            }
            else
            {
            	value = " ";
            }   
            rs.close();
            pstmt.close();
        }
        catch(Exception exception)
        {
            exception.printStackTrace();
            System.out.println("Exception ::" + exception.getMessage());
        }
        return value;
    }
	
}
