package ibase.dashboard.calendar.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class CalendarDBR extends ValidatorEJB implements CalendarDBRLocal, CalendarDBRRemote 
{

	public CalendarDBR()
	{
		
	}
	
	
	public JSONObject getStationCountNew( String period, String loginCode )
	{
		JSONObject stationCountJson = null;
		Connection conn    = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			stationCountJson = new JSONObject();

		StringBuilder queryBuilder = new StringBuilder();
		
		if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
		{
			queryBuilder.append("SELECT stan_type, sum(planned_visit) as planned_visit, sum(actual_visit) as actual_visit ");
			queryBuilder.append("from(select det.stan_type as stan_type , trunc(sysdate) as plan_date, det.work_days as planned_visit, 0 as actual_visit ");
			queryBuilder.append("from SF_PLAN_PARAM hdr, SF_PLAN_PARAM_STAN det where det.param_table = hdr.param_table ");
			queryBuilder.append("and det.prd_code = hdr.prd_code and hdr.prd_code = '"+period+"' union all ");
			queryBuilder.append("select distinct sr.station_type as stan_type, trunc(sp.plan_date) as plan_date, 0 as planned_visit,1 as actual_visit from sprs_plan_place spp, sprs_plan_hdr sp, period prd, sprs_route sr ");
			queryBuilder.append("where spp.plan_id  = sp.plan_id and sr.sprs_code = sp.sprs_code__plan and spp.work_stan_code = sr.stan_code and prd.code = '"+period+"' ");	
			queryBuilder.append("and sp.plan_date >=prd.fr_date and sp.plan_date<=prd.to_date and sp.sprs_code__plan = '"+loginCode+"') group by stan_type");
		}
		else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
		{
			queryBuilder.append("SELECT stan_type, sum(planned_visit) as planned_visit, sum(actual_visit) as actual_visit ");
			queryBuilder.append("from(select det.stan_type as stan_type , date(current date) as plan_date, det.work_days as planned_visit, 0 as actual_visit ");
			queryBuilder.append("from SF_PLAN_PARAM hdr, SF_PLAN_PARAM_STAN det where det.param_table = hdr.param_table ");
			queryBuilder.append("and det.prd_code = hdr.prd_code and hdr.prd_code = '"+period+"' union all ");
			queryBuilder.append("select distinct sr.station_type as stan_type, date(sp.plan_date) as plan_date, 0 as planned_visit,1 as actual_visit from sprs_plan_place spp, sprs_plan_hdr sp, period prd, sprs_route sr ");
			queryBuilder.append("where spp.plan_id  = sp.plan_id and sr.sprs_code = sp.sprs_code__plan and spp.work_stan_code = sr.stan_code and prd.code = '"+period+"' ");	
			queryBuilder.append("and sp.plan_date >=prd.fr_date and sp.plan_date<=prd.to_date and sp.sprs_code__plan = '"+loginCode+"') as caldash group by stan_type");
			
		}

		String sqlQuery = queryBuilder.toString(); 
		
			pstmt = conn.prepareStatement( sqlQuery );
			rs = pstmt.executeQuery();
			int count = 0;
			while( rs.next() )
			{
				String stnType = checkNull(rs.getString(1)).trim();
				String planedVisit = rs.getString(2).trim();
				String actualVisit = rs.getString(3).trim();
				
				JSONObject rowData = new JSONObject();
				
				System.out.println("### getting percentage outside total ["+planedVisit+"] and Visited ["+actualVisit+"] stnType ["+stnType+"]");
				String percent = ""+calculatePercentCount( planedVisit, actualVisit );
				
				stnType = checkNull( stnType );
				if( !"".equalsIgnoreCase( stnType ) )
				{
					rowData.put("Total", planedVisit );
					rowData.put("Visited", actualVisit );
					rowData.put("Title", stnType );
					rowData.put("Visited/Total", actualVisit+"/"+planedVisit);
					rowData.put("circledisplay", "c100");
					rowData.put("percentage", percent);
					stationCountJson.put( count, rowData );
					count ++;
				}
			}
			
		}
		catch (Exception e)
		{
			System.out.println("Exception while getting places new  data ["+e+"]");
			e.printStackTrace();
		}
		finally 
		{
			try 
			{
				if (conn != null) 
				{
					conn.close();
					conn = null;
					pstmt.close();
					rs.close();
				}
			} 
			catch (Exception e) 
			{
			}
		}
		System.out.println("### Final json String is ["+stationCountJson.toJSONString()+"]");
		return stationCountJson;
	}
	
	
//	public JSONObject getStationCount( String period, String loginCode )
//	{
//		JSONObject stationCountJson = null;
//		Connection conn    = null;
//		int totalHQCount = 0;
//		int totalEXHQCount = 0;
//		int totalOSCount = 0;
//		//String route_type = "";
//		//String station_type = "";
//		HashMap<String, String> totalCurrentStnCntMap = null;
//		try 
//		{
//			ConnDriver connDriver = new ConnDriver();
//			conn = connDriver.getConnectDB("Driver");
//			stationCountJson = new JSONObject();
//			totalCurrentStnCntMap = new HashMap<String, String>();
//			//get start date and end date here
//			getPeriod( period );
//			HashMap<String, String> totalWorkMap = getTotalCount( period );
//			//get locality here in period
//			//String sql1 = "SELECT COUNT(*) FROM SPRS_PLAN where plan_date between ? and ? and sprs_code__for=?";
//			String sql = "SELECT DISTINCT(locality_code) from sprs_plan where plan_date between ? and ? and sprs_code__for= ?";
//			PreparedStatement pstmt = conn.prepareStatement(sql);
//			pstmt.setString(1, frDate );
//			pstmt.setString(2, toDate );
//			pstmt.setString(3, loginCode.trim() );
//			ResultSet rs = pstmt.executeQuery();
//			//int count = 0;
//			while( rs.next() )
//			{
//				String currentLocality = rs.getString("LOCALITY_CODE").trim();
//				System.out.println("### Current locality is ["+currentLocality+"]");
//				//JSONObject rowData = new JSONObject();
//				String total = "";
//				
//				String localityCountSQL = "Select COUNT(*) from sprs_plan where plan_date between ? and ? and sprs_code__for= ? and locality_code = ?";
//				
//				PreparedStatement pstmt2 = conn.prepareStatement(localityCountSQL);
//				pstmt2.setString(1, frDate );
//				pstmt2.setString(2, toDate );
//				pstmt2.setString(3, loginCode.trim() );
//				pstmt2.setString(4, currentLocality.trim() );
//				
//				ResultSet rs2 = pstmt2.executeQuery();
//				
//				if( rs2.next() )
//				{
//					total = rs2.getString(1);
//				}
//				
//				//get locality type here
//				String sql1 = "Select route_type, station_type from sprs_route where locality_code=? and sprs_code= ?";
//				
//				PreparedStatement pstmt1 = conn.prepareStatement(sql1);
//				pstmt1.setString(1, currentLocality );
//				pstmt1.setString(2, loginCode );
//				
//				ResultSet rs1 = pstmt1.executeQuery();
//				
//				if( rs1.next() )
//				{
//					String route_type = checkNull(rs1.getString(1));
//					String station_type = checkNull(rs1.getString(2));
//					System.out.println("### current routeType ["+route_type+"] stationType ["+station_type+"]");
//					if( "H".equalsIgnoreCase( route_type ) )
//					{
//						station_type = "HQ";
//						totalHQCount = totalHQCount + Integer.parseInt( total );
//						totalCurrentStnCntMap.put("HQ", totalHQCount+"");
//					}
//					else if( "O".equalsIgnoreCase( route_type ) )
//					{
//						station_type = "OS";
//						totalOSCount = totalOSCount + Integer.parseInt( total );
//						totalCurrentStnCntMap.put("OS", totalOSCount+"");
//					}
//					else if( "X".equalsIgnoreCase( route_type ) )
//					{
//						station_type = "ExHQ";
//						totalEXHQCount = totalEXHQCount + Integer.parseInt( total );
//						totalCurrentStnCntMap.put("ExHQ", totalEXHQCount+"");
//					}
//				}
//				System.out.println("### totalCurrentStnCntMap ["+totalCurrentStnCntMap+"]");
//			}
//			System.out.println("----------Creating JSON String---------");
//			int count = 0;
//			for(Map.Entry m:totalWorkMap.entrySet())
//			{  
//				System.out.println("Key is ["+m.getKey()+"] and value is ["+m.getValue()+"]");
//				JSONObject rowData = new JSONObject();
//				String total = "0";
//				String Visited = "0";
//				total = checkNull( totalWorkMap.get( m.getKey() ) );
//				if( totalCurrentStnCntMap.containsKey( m.getKey() ))
//				{
//					Visited = checkNull( totalCurrentStnCntMap.get( m.getKey() ) );
//					System.out.println("### getting values total ["+total.length()+"] visited ["+Visited.length()+"]");
////					if( total.length()<= 0 )
////					{
////						System.out.println("################$$$$$$$$$$$$ total");
////						total = "0";
////					}
//					if( Visited.length() <= 0 )
//					{
//						System.out.println("################$$$$$$$$$$$$ visited");
//						Visited = "0";
//					}
//				}
//				System.out.println("### getting percentage outside total ["+total+"] and Visited ["+Visited+"]");
//				String percent = ""+calculatePercentCount( total, Visited );
//				
//				rowData.put("Total",  total );
//				rowData.put("Visited", Visited );
//				rowData.put("Title", m.getKey() );
//				rowData.put("Visited/Total", Visited+"/"+total);
//				rowData.put("circledisplay", "c100");
//				rowData.put("percentage", percent);
//				stationCountJson.put( count, rowData );
//				
//				count ++;
//			}  
//		}
//		catch (Exception e)
//		{
//			System.out.println("Exception while getting places new  data ["+e+"]");
//		}
//		finally 
//		{
//			try 
//			{
//				if (conn != null) 
//				{
//					conn.close();
//					conn = null;
////					pstmt.close();
////					rs.close();
//				}
//			} 
//			catch (Exception e) 
//			{
//			}
//		}
//		System.out.println("### Final json String is ["+stationCountJson.toJSONString()+"]");
//		return stationCountJson;
//	}
	
//	public HashMap<String, String> getTotalCount( String period)
//	{
//		Connection conn    = null;
//		int totalHQCount = 0;
//		int totalEXHQCount = 0;
//		int totalOSCount = 0;
//		PreparedStatement pstmt = null;
//		ResultSet rs = null;
//		HashMap<String, String> totalWorkMap = new HashMap<String, String>();
//		try 
//		{
//			ConnDriver connDriver = new ConnDriver();
//			conn = connDriver.getConnectDB("Driver");
//			String sql = "SELECT PARAM_TABLE FROM SF_PLAN_PARAM WHERE PRD_CODE = ?";
//			
//			pstmt = conn.prepareStatement( sql );
//			pstmt.setString(1, period);
//			rs = pstmt.executeQuery();
//			
//			if( rs.next() )
//			{
//				String param_table = rs.getString(1);
//				String sql1 = "SELECT STAN_TYPE, WORK_DAYS FROM SF_PLAN_PARAM_STAN WHERE PARAM_TABLE = ? AND PRD_CODE=?";
//				PreparedStatement pstmt1 = conn.prepareStatement(sql1);
//				pstmt1.setString(1, param_table.trim() );
//				pstmt1.setString(2, period );
//				ResultSet rs1 = pstmt1.executeQuery();
//				
//				while( rs1.next() )
//				{
//					String stationType = rs1.getString(1).trim();
//					String workDays = rs1.getString(2);
//					totalWorkMap.put(stationType, workDays);
//				}
//			
//			}
//			
//		}
//		catch (Exception e)
//		{
//			System.out.println("Exception while getting total count data ["+e+"]");
//		}
//		finally 
//		{
//			try 
//			{
//				if (conn != null) 
//				{
//					conn.close();
//					conn = null;
//					pstmt.close();
//					rs.close();
//				}
//			} 
//			catch (Exception e) 
//			{
//			}
//		}
//		System.out.println("#### total work data map is ["+totalWorkMap+"]");
//		return totalWorkMap;
//	}
	
//	public JSONObject getPlacesVisitedCount( String datasourcename, String period, String loginCode )
//	{
//		JSONObject placesCountJson = null;
//		//JSONObject rowData = null;	
//		String sql         = "";
//		ResultSet rs       = null;
//		PreparedStatement pstmt = null;
//		Connection conn    = null;
//		int totalCount = 0;
//		
//		try 
//		{
//			System.out.println("!@@@***** inside places visited count");
//			ConnDriver connDriver = new ConnDriver();
//			conn = connDriver.getConnectDB("Driver");
//			placesCountJson = new JSONObject();
//			//rowData = new JSONObject();
//			
//			getPeriod( period );
//			
////			sql = "SELECT COUNT(*) FROM SPRS_PLAN where plan_date between ? and ? and sprs_code__for=?";
////			
////			pstmt = conn.prepareStatement(sql);
////			pstmt.setString(1, "");
////			pstmt.setString(2, "");
////			pstmt.setString(3, "");
////			
////			rs = pstmt.executeQuery();
////			
////			if( rs.next() )
////			{
////				totalCount = rs.getInt(1);
////			}
//			
//			//placesCount.put("Total", totalCount+"");
////			rowData.put("Total", "50");
////			rowData.put("Visited", "30");
////			rowData.put("Visited/Total", "30/50");
////			rowData.put("IndctValue", "red");
////		    
////			placesCountJson.put("0", rowData);
//			
//			if( true )
//			{
//				JSONObject rowData = new JSONObject();
//				String percent = ""+calculatePercent(10,2);
//				rowData.put("Total", "10");
//				rowData.put("Visited", "2");
//				rowData.put("Visited/Total", "2/10");
//				rowData.put("circledisplay", "c100");
//				rowData.put("percentage", percent);
////				rowData.put("IndctValue", "red");
//				rowData.put("Title", "HO");
//				placesCountJson.put(0, rowData);
//			}
//			if( true )
//			{
//				JSONObject rowData = new JSONObject();
//				String percent = ""+calculatePercent(10,5);
//				rowData.put("Total", "10");
//				rowData.put("Visited", "5");
//				rowData.put("Visited/Total", "5/10");
//				rowData.put("circledisplay", "c100");
//				rowData.put("percentage", percent);
////				rowData.put("IndctValue", "red");
//				rowData.put("Title", "Ex.Ho");
//				placesCountJson.put(1, rowData);
//			}
//			if( true )
//			{
//				JSONObject	rowData = new JSONObject();
//				String percent = ""+calculatePercent(4,4);
//				rowData.put("Total", "4");
//				rowData.put("Visited", "4");
//				rowData.put("Visited/Total", "4/4");
//				rowData.put("circledisplay", "c100");
//				rowData.put("percentage", percent);
////				rowData.put("IndctValue", "red");
//				rowData.put("Title", "OS");
//				placesCountJson.put(2, rowData);
//			}
//			
//			//getStationCount( period, loginCode );
//		}
//		catch (Exception e)
//		{
//			System.out.println("Exception while getting places data ["+e+"]");
//		}
//		finally 
//		{
//			try 
//			{
//				if (conn != null) 
//				{
//					conn.close();
//					conn = null;
//					pstmt.close();
//					rs.close();
//				}
//			} 
//			catch (Exception e) 
//			{
//			}
//		}
//		
//		return placesCountJson;
//	}
	
//	public int calculatePercent( int total, int score )
//	{
//	       int percentage;
//	       
//	       percentage = (score * 100/ total);
//	 
//	       System.out.println("The percentage is = " + percentage + " %");
//	       return percentage;
//	}
	
	public int calculatePercentCount( String total, String score )
	{
		int percentage = 0;
		try 
		{
		   System.out.println("#### Percent 111 ["+total+"] and score ["+score+"]");
	       int total1 = Integer.parseInt( total );
	       int score1 = Integer.parseInt( score );
	       percentage = (score1 * 100/ total1);
	       System.out.println("The percentage is new  = " + percentage + " %");
		} 
		catch (Exception e) 
		{
			System.out.println("Exception on percentage ["+e+"]");
		}
		 return percentage;
	}
	
//	public JSONObject getPlacesDetails( String datasourcename, String period, String loginCode )
//	{
//		JSONObject placesDetailsJson = new JSONObject();
//		JSONObject rowDataJson = null;	
//		String sql         = "";
//		ResultSet rs       = null;
//		PreparedStatement pstmt = null;
//		Connection conn    = null;
//		StringBuffer placesData = new StringBuffer();
//		try 
//		{
//			ConnDriver connDriver = new ConnDriver();
//			conn = connDriver.getConnectDB("Driver");
//			getPeriod( period );
//			System.out.println("fromDSate ["+frDate+"] and toDate ["+toDate+"]");
////			sql = "SELECT descr from locality where locality_code In (Select DISTINCT( locality_code) from sprs_plan where plan_date between ? and ? and sprs_code__for=?)";
//			sql = "select descr, locality_code from locality where locality_code In (Select DISTINCT( locality_code) from sprs_plan where plan_date between ? and ? and sprs_code__for= ?)";
//			
//			pstmt = conn.prepareStatement( sql );
//			pstmt.setString(1, frDate);
//			//pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(frDate));
//			pstmt.setString(2, toDate);
//			//pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(toDate));
//			pstmt.setString(3, loginCode);
//			
//			rs = pstmt.executeQuery( );
//			int i = 0;
//			String currentPlace = "";
//			String localityCode = "";
//			String localityCnt = "";
//			
//			while( rs.next() )
//			{
//				rowDataJson = new JSONObject();
//				
//				currentPlace = rs.getString(1);
//				localityCode = rs.getString(2);
//				
//				if( localityCode.length() > 0)
//				{
//					String placeCntSql = "Select COUNT(*) from sprs_plan where (plan_date between ? and ? and sprs_code__for=?) and locality_code=?";
//					PreparedStatement pstmt1 = null;
//					
//					pstmt1 = conn.prepareStatement(placeCntSql);
//					pstmt1.setString(1, frDate);
//					pstmt1.setString(2, toDate);
//					pstmt1.setString(3, loginCode);
//					pstmt1.setString(4, localityCode);
//					
//					ResultSet rs1 = pstmt1.executeQuery();
//					
//					if( rs1.next() )
//					{
//						localityCnt = rs1.getInt(1)+"";
//					}
//				}
//				System.out.println("***** place ["+currentPlace+"] visits ["+localityCnt+"]");
//
//				rowDataJson.put("place",currentPlace);
//				rowDataJson.put("visits", localityCnt);
//				
//				placesDetailsJson.put(i, rowDataJson);
//				i++;
//			}
////			JSONObject placesVisits = new JSONObject();
////			
////			for( int i=0; i<4; i++ )
////			{
////				rowDataJson.put("place","MUMBAI-"+i);
////				rowDataJson.put("visits", "20");
////				
////				placesDetailsJson.put(i, rowDataJson);
////			}
//			
////			rowDataJson.put("MUMBAI", "20");
////			rowDataJson.put("THANE", "10");
////			rowDataJson.put("VASHI", "05");
////			rowDataJson.put("PUNE", "25");
////			
//			//placesDetails.put("Places", placesData.toString());
//			//placesDetailsJson.put("1", rowDataJson);
//		    
//		}
//		catch (Exception e)
//		{
//			System.out.println("Exception while getting places data ["+e+"]");
//		}
//		finally 
//		{
//			try 
//			{
//				if (conn != null) 
//				{
//					conn.close();
//					conn = null;
//					pstmt.close();
//					rs.close();
//				}
//			} 
//			catch (Exception e) 
//			{
//			}
//		}
//		
//		return placesDetailsJson;
//	}
	
	
//	String frDate = "";
//	String toDate = "";
//	public void getPeriod( String period )
//	{
//		String sql         = "";
//		ResultSet rs       = null;
//		PreparedStatement pstmt = null;
//		Connection conn    = null;
//		
//		try 
//		{
//				ConnDriver connDriver = new ConnDriver();
//				conn = connDriver.getConnectDB("Driver");
//				
//				sql = "select fr_date, to_date from period where code = ?";
//				
//				pstmt = conn.prepareStatement( sql );
//				pstmt.setString(1, period);
//				
//				rs = pstmt.executeQuery( );
//				if( rs.next() )
//				{
//					frDate = rs.getString(1);
//					toDate = rs.getString(2);
//				}
//				E12GenericUtility genericUtility = new E12GenericUtility();
//				
//				frDate = genericUtility.getValidDateString(frDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
//				toDate = genericUtility.getValidDateString(toDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
//				System.out.println("Changed format fromDSate ["+frDate+"] and toDate ["+toDate+"]");
//		} 
//		catch (Exception e)
//		{
//			System.out.println("Exception while getting period : "+e);
//		}
//		finally 
//		{
//			try 
//			{
//				if (conn != null) 
//				{
//					conn.close();
//					conn = null;
//					pstmt.close();
//					rs.close();
//				}
//			} 
//			catch (Exception e) 
//			{
//			}
//		}
//	}
	
	public static String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
}
