/*
authored by Pawan 10/7/2010 to confirm the transaction
*/

package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.*;
import java.sql.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.GenericUtility; 
//Changed by Rohan on 4/20/2011 [AD01SUN009] to import below given classes.start
import ibase.webitm.ejb.sys.GenerateXmlFromDB;
import ibase.webitm.ejb.sys.NFCreateEdiMultiLogic;
//Changed by Rohan on 4/20/2011 [AD01SUN009] to import below given classes.end

@javax.ejb.Stateless
public class SepCloseConf extends ActionHandlerEJB implements SepCloseConfLocal, SepCloseConfRemote
{
	public String confirm( String tranId, String xtraParams, String forcedFlag ) throws RemoteException,ITMException
	{	
		System.out.println("SepCloseConf Called........");
		int ctr = 0;
		String empCode = "";
		String status = "";
		String tranIdFFS = "";
		String resiDate = "";

		String separationMode = "";
		String reason = "";
		String vacNoCreated = "";
		String empCodeConf = "";
		String deleteSepOnClose = "";
		String relieveDate = "";
		//Changed by Pawan on 5/4/2011 [AD01SUN009].
		//String confDate = "";
		java.sql.Timestamp confDate = null;
		String sql = "";
		//Modified by Juhi on 03-05-2016 [A15JSUN007] [To replace Statement as PreparedStatement ] [start]
		//Statement stmt = null;
		PreparedStatement pstmtDel = null;
		PreparedStatement pstmtUpd = null;
		//Modified by Juhi on 03-05-2016 [A15JSUN007] [To replace Statement as PreparedStatement] [end]
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;	
		Connection connectionObject = null;
		String errString = "";
		String loginEmpCode = "";
		String sepCloseStatus = "";
		boolean isError = false;

		int updCnt = 0;
		
		AdmCommon admCommon = null;
		ITMDBAccessLocal itmdbAccessLocal = null ;
		ConnDriver connDriver = new ConnDriver();//Modified By Juhi on 03-05-2016 [A15JSUN007] [To resolve connection rollback issue]
		try
		{

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			itmdbAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			
			//ConnDriver connDriver = new ConnDriver();//Modified By Juhi on 03-05-2016 [A15JSUN007] [To resolve connection rollback issue]
			connectionObject = connDriver.getConnectDB("DriverValidator");
			connectionObject.setAutoCommit(false);
			
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement][START]
			/*sql = "SELECT EMP_CODE, RESI_DATE , CASE WHEN STATUS IS NULL THEN ' ' ELSE STATUS END AS STATUS FROM SEPARATION_CLOSE WHERE TRAN_ID = '"+tranId+"'";
			stmt = connectionObject.createStatement();	
			rSet = stmt.executeQuery(sql);*/
			sql = "SELECT EMP_CODE, RESI_DATE , CASE WHEN STATUS IS NULL THEN ' ' ELSE STATUS END AS STATUS FROM SEPARATION_CLOSE WHERE TRAN_ID = ? ";

			pstmt = connectionObject.prepareStatement(sql);	
			pstmt.setString(1, tranId);
			rSet = pstmt.executeQuery();
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement] [END]
			if (rSet.next())
			{
				empCode = rSet.getString("EMP_CODE");
				resiDate = rSet.getString("RESI_DATE");
				sepCloseStatus = rSet.getString("STATUS");
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [start]
			/*if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}*/
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [end]
			if (sepCloseStatus.equalsIgnoreCase("X") )
			{
					isError = true;
					errString = itmdbAccessLocal.getErrorString("","VTCREDIT01","");
					return errString;		
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement] [START]
			/*sql = "SELECT COUNT(*)  FROM FULLFINAL_HDR WHERE EMP_CODE = '"+empCode+"' AND CONFIRMED = 'Y'";
			rSet = stmt.executeQuery(sql);
			*/
			sql = "SELECT COUNT(*)  FROM FULLFINAL_HDR WHERE EMP_CODE = ? AND CONFIRMED = ?";
			pstmt = connectionObject.prepareStatement(sql);	
			pstmt.setString(1, empCode);
			pstmt.setString(2, "Y");
			rSet = pstmt.executeQuery();
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement] [END]	
			if( rSet.next() )
			{
				ctr = rSet.getInt(1);
				if( ctr > 0 )
				{
					isError = true;
					errString = itmdbAccessLocal.getErrorString("","VTFFS1","");
					return errString;		
				}
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [start]
			/*if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}*/
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [END]
			sql = "SELECT STATUS, RELIEVE_DATE, SEPARATION_MODE, REASON, VAC_NO__CREATED, CONF_DATE, EMP_CODE__CONF FROM SEPARATION WHERE EMP_CODE = ? AND RESI_DATE = ?";

			pstmt = connectionObject.prepareStatement( sql );	
			pstmt.setString(1,empCode);
			pstmt.setTimestamp( 2,Timestamp.valueOf( resiDate ) );
			rSet = pstmt.executeQuery();

			if( rSet.next() )
			{				
				status = rSet.getString("STATUS");
				relieveDate = rSet.getString("RELIEVE_DATE");
				separationMode = rSet.getString("SEPARATION_MODE");
				reason = rSet.getString("REASON");
				vacNoCreated = rSet.getString("VAC_NO__CREATED");
				//Changed by Pawan on 5/4/2011 [AD01SUN009].
				//confDate = rSet.getString("CONF_DATE");
				confDate = rSet.getTimestamp("CONF_DATE");
				empCodeConf = rSet.getString("EMP_CODE__CONF");
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement][[start]
			/*if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}*/
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [end]
			if( status != null && !status.equalsIgnoreCase("C") )
			{
				isError = true;
				errString = itmdbAccessLocal.getErrorString("","VTSEPNTCON","");
				return errString;
			}
			GenericUtility genericUtility = GenericUtility.getInstance();
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			sql = "UPDATE SEPARATION_CLOSE SET STATUS = 'A', RELIEVE_DATE = ?, SEPARATION_MODE = ?, REASON = ?,	VAC_NO__CREATED = ?, SEP_STATUS = ?, CONF_DATE_SEP = ?, EMP_CODE__CONF_SEP = ?, EMP_CODE__APRV = ? WHERE TRAN_ID = ?";
			pstmt = connectionObject.prepareStatement( sql );	
			pstmt.setTimestamp(1, Timestamp.valueOf( relieveDate ) );
			pstmt.setString(2, separationMode); 
			pstmt.setString(3, reason); 
			pstmt.setString(4, vacNoCreated); 
			pstmt.setString(5, status); 
			//Changed by Pawan on 5/4/2011 [AD01SUN009].
			//pstmt.setTimestamp(6,Timestamp.valueOf( confDate ) ); 
			pstmt.setTimestamp(6, confDate); 
			pstmt.setString(7, empCodeConf); 
			pstmt.setString(8, loginEmpCode); 
			pstmt.setString(9, tranId); 
			updCnt = pstmt.executeUpdate();
			if ( updCnt > 0 )
			{
				System.out.println("SEPARATION_CLOSE Updated Successfully ::"+updCnt);
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [start]
			/*if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}*/
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [end]
			admCommon = new AdmCommon();
			deleteSepOnClose = admCommon.getEnv("999999", "DELSEPONCLOSE", connectionObject);

			if( deleteSepOnClose !=null && deleteSepOnClose.equalsIgnoreCase("NULLFOUND") )
			{
				isError = true;
				errString = itmdbAccessLocal.getErrorString("","VSENVAR1","");
				return errString;			
			}
			else if( deleteSepOnClose !=null && !deleteSepOnClose.equalsIgnoreCase("Y") )
			{				
				deleteSepOnClose = "N";
			}

			if( deleteSepOnClose.equalsIgnoreCase("Y") )
			{			
				sql = "DELETE FROM SEPARATION WHERE EMP_CODE = ? AND RESI_DATE = ?";
				pstmt = connectionObject.prepareStatement( sql );	
				pstmt.setString(1,empCode);
				pstmt.setTimestamp(2,Timestamp.valueOf( resiDate ) );
				pstmt.executeUpdate();
			}
			else
			{			
				sql = "UPDATE SEPARATION SET STATUS = ? WHERE EMP_CODE = ? AND RESI_DATE = ?";
				pstmt = connectionObject.prepareStatement( sql );	
				pstmt.setString(1, "X");
				pstmt.setString(2,empCode);
				pstmt.setTimestamp(3,Timestamp.valueOf( resiDate ) );
				pstmt.executeUpdate();				
			}

			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			/*if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement][Start]
			/*sql = "SELECT TRAN_ID  FROM FULLFINAL_HDR WHERE EMP_CODE = '"+empCode+"' AND CONFIRMED != 'X'";
			rSet = stmt.executeQuery(sql);*/
			sql = "SELECT TRAN_ID  FROM FULLFINAL_HDR WHERE EMP_CODE = ? AND CONFIRMED != ?";
			pstmt = connectionObject.prepareStatement( sql );	
			pstmt.setString(1,empCode);
			pstmt.setString(2,"X");
			rSet = pstmt.executeQuery();
			
			if( rSet.next() )
			{
				tranIdFFS = rSet.getString("tran_id");
				/*sql = "DELETE FROM FULLFINAL_DET WHERE TRAN_ID = '"+tranIdFFS+"'";
				updCnt = stmt.executeUpdate(sql);*/
				sql = "DELETE FROM FULLFINAL_DET WHERE TRAN_ID = ? ";
				pstmtDel = connectionObject.prepareStatement( sql );
				pstmtDel.setString(1,tranIdFFS);
				updCnt = pstmtDel.executeUpdate();
				if( pstmtDel != null )
				{
					pstmtDel.close();
					pstmtDel = null;
				}
				if ( updCnt > 0 )
				{
					System.out.println("deleted from FULLFINAL_DET Successfully ::"+updCnt);
				}
				/*sql = "UPDATE FULLFINAL_HDR SET CONFIRMED = 'X', TOTAL_AMT = 0, IT_AMT = 0, AMOUNT = 0 WHERE TRAN_ID = '"+tranIdFFS+"'";
				updCnt = stmt.executeUpdate(sql);*/
				sql = "UPDATE FULLFINAL_HDR SET CONFIRMED = ?, TOTAL_AMT = ?, IT_AMT = ?, AMOUNT = ? WHERE TRAN_ID = ? ";
				pstmtUpd = connectionObject.prepareStatement( sql );
				pstmtUpd.setString(1, "X");
				pstmtUpd.setInt(2, 0);
				pstmtUpd.setInt(3, 0);
				pstmtUpd.setInt(4, 0);
				pstmtUpd.setString(5,tranIdFFS);
				updCnt = pstmtUpd.executeUpdate();
				if( pstmtUpd != null )
				{
					pstmtUpd.close();
					pstmtUpd = null;
				}
				//Modified By Juhi on 03-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement] [END]
				if ( updCnt > 0 )
				{
					System.out.println("FULLFINAL_HDR Updated Successfully ::"+updCnt);
				}
			}     
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [START]
			if ( rSet != null )
			{
				rSet.close();
				rSet = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [End]
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement][Start] [ Start]
			/*sql = "UPDATE EMPLOYEE SET RESI_DATE = NULL, RELIEVE_DATE = NULL WHERE EMP_CODE = '"+empCode+"'";
			updCnt = stmt.executeUpdate(sql);*/
			sql = "UPDATE EMPLOYEE SET RESI_DATE = NULL, RELIEVE_DATE = NULL WHERE EMP_CODE = ? ";
			pstmt = connectionObject.prepareStatement( sql );	
			pstmt.setString(1,empCode);
			updCnt = pstmt.executeUpdate();
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			//Modified by Juhi on 03-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement] [END]
			if ( updCnt > 0 )
			{
				System.out.println("EMPLOYEE Updated Successfully ::"+updCnt);
			}
			//Changed by Rohan on 19/04/11 [AD01SUN009] to generate EDI data.start
			Document dom = null;
			String runMode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "runMode" );
            String ediOption = "";
			System.out.println("runMode is :"+runMode);
			if(runMode != null && runMode.trim().length() > 0 && !runMode.equalsIgnoreCase("B"))
			{
				//Modified By Juhi on 09-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement][Start]
				//sql = "	SELECT EDI_OPTION FROM TRANSETUP WHERE TRAN_WINDOW = 'w_sep_close' ";
				sql = "	SELECT EDI_OPTION FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
				/*stmt = connectionObject.createStatement();
				rSet = stmt.executeQuery(sql);*/
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString( 1, "w_sep_close" );
				rSet = pstmt.executeQuery();
				//Modified By Juhi on 09-05-2016 [A15JSUN007] [Values to sql statements is passed as parameter instead of appending and using PreparedStatement instead of Statement][END]
				while ( rSet.next() )
				{
					ediOption = rSet.getString("EDI_OPTION");
				}
				if (ediOption == null)
				{
					ediOption = "0";
				}
				//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [Start]
				/*stmt.close();
				stmt = null;				
				rSet.close();
				rSet = null;
				pstmt.close();
				pstmt = null;*/	
				if ( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [end]
				
				if (!"0".equals(ediOption))
				{
					GenerateXmlFromDB generateXmlFromDB = GenerateXmlFromDB.getInstance();
					String dataString = generateXmlFromDB.getXMLData("w_sep_close", tranId , connectionObject);
					System.out.println("generateXmlFromDB returned [" + dataString + "]");
					generateXmlFromDB = null;
					dom = genericUtility.parseString(dataString);
					NFCreateEdiMultiLogic ceateEdiMultiLogic = new NFCreateEdiMultiLogic();
					errString = ceateEdiMultiLogic.nfCreateEdiMultiLogic( dom, "w_sep_close", "E", xtraParams, connectionObject );
					ceateEdiMultiLogic = null;
					if (errString != null && !"SUCCESS".equals(errString))
					{
						return errString;
					}
					else
					{
						errString = "";
					}
				}
			}
			//Changed by Rohan on 19/04/11 [AD01SUN009] to generate EDI data.end
		}
		//Modified by Juhi on 04-05-2016 [A15JSUN007] [To catch sql exception] [START]
		catch(SQLException sqlExp)
		{
			isError = true;
			String errCode = "Database Error >>" + sqlExp.getErrorCode();
			admCommon = new AdmCommon();
			errString = admCommon.getErrorXmlString("VMSQLEX01", "E", "status", errCode, sqlExp.getMessage());		
		}
		//Modified by Juhi on 04-05-2016 [A15JSUN007] [To catch sql exception] [END]
		catch(Exception e)
		{
			isError = true;
			try
			{
				connectionObject.rollback();
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Commiting and Closing Connection..........");
				if ( !(isError) )
				{
					connectionObject.commit();
					errString = itmdbAccessLocal.getErrorString("","SEPCLCONF","");
				}
				else
				{
					connectionObject.rollback();
				}
				if ( rSet != null )
				{
					rSet.close();
					rSet = null;
				}
				//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [Start]
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( pstmtDel != null )
				{
					pstmtDel.close();
					pstmtDel = null;
				}
				if( pstmtUpd != null )
				{
					pstmtUpd.close();
					pstmtUpd = null;
				}
				//Modified By Juhi on 03-05-2016 [A15JSUN007] [ To maintain Sequence of closing resultset and  PreparedStatement] [end]
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}
	
}
