package ibase.e12ria.e12widgets.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Provides similar functionality to 
 * {@link com.google.gwt.user.client.ui.DisclosurePanel DisclosurePanel}. However,
 * it only provides basic functionality. This widget was created because we cannot
 * use <code>DisclosurePanel</code> directly because it references a style class
 * called "header" which cannot be controlled.
 * 
 * @author Gopalakrishna Bharat
 */
public class E12DisclosurePanel extends Composite
{

    
    /** Flag to indicate that the widget has been loaded or not. */
    private boolean isLoaded = false;

    /** Flag to indicate that the popup is showing. */
    private boolean isPopupShowing = false;

    
    /** Panel to contain the header widget. */
    protected Panel headerPanel = new HeaderPanel();
    
    /** Widget which will form the header; set by the client. */
    protected Widget headerWidget;
    
    /** Popup panel which forms the container for the contents. */
    protected PopupPanel popup = new DecoratedPopupPanel(  );
//    protected PopupPanel popup = new PopupPanel( true );
    
    /** Widget which will form the contents; set by the client. */
    protected Widget contentWidget;

    /** Left and top offsets to indicate location where the popup is displayed. */
    protected int popupLocationLeft, popupLocationTop;
    
    //Added by Dnyaneshwar chavan on 14-JAN-2013 [] Start
    /** Pop-up panel Style name*/
    protected String popupPanelStyleName;
    
    /** Multiple style name for each option widget */
    protected List< String > popupPanelAddStyleName = new ArrayList< String >();
    //Added by Dnyaneshwar chavan on 14-JAN-2013 [] End
 
    /**
     * Panel which will contain the header widget.
     * 
     * <p>
     * It will listen to click events and on click, opens the popup
     * which contains the contents.
     */
    protected class HeaderPanel extends SimplePanel
    {

        /** Creates a new <code>HeaderPanel</code>. */
        public HeaderPanel()
        {
            sinkEvents( Event.ONCLICK );
        }
        
        @Override
        public void onBrowserEvent( Event event )
        {
            switch ( DOM.eventGetType( event ) )
            {
            case Event.ONCLICK :
                updateWidget();
                showOrHidePopup();
                break;
            }
        }
        
    }

    
    /** Creates a new object of this class. */
    public E12DisclosurePanel()
    {
        initWidget( headerPanel );
    }

    
    /** Initializes the widget by drawing all the inner widgets. */
    protected void initWidget()
    {
        isLoaded = true;
        updateWidget();
        isLoaded = false;
    }

    
    @Override
    protected void onLoad()
    {
        isLoaded = false;
        initWidget();
        isLoaded = true;
    }

    
    /** Redraws the widget when new settings are provided. */
    protected void updateWidget()
    {
        if( isLoaded )
        {
            addHeader();
            addContent();
        }
    }

    
    /** Adds header widget to this widget. */
    private void addHeader()
    {
        if( headerWidget == null )
        {
            return;
        }
        headerPanel.clear();
        headerPanel.add( headerWidget );
    }

    
    /** Adds the content widget to this widget. */
    private void addContent()
    {
        if( contentWidget == null )
        {
            return;
        }
        popup.clear();
        //Added by Dnyaneshwar chavan on 14-JAN-2013 [] Start
        if( popupPanelStyleName != null)
        {
        	popup.setStyleName( popupPanelStyleName );
        }        
        for(String styleName : popupPanelAddStyleName )
        {
        	popup.addStyleName( styleName );
        }
        popup.setGlassEnabled( true );
        popup.setGlassStyleName("bgGlass");
		//Added by Dnyaneshwar on 2-AUG-13 [ set fixed position and 1 z-index  ] Start
        popup.addAttachHandler( new AttachEvent.Handler() {
			
			@Override
			public void onAttachOrDetach(AttachEvent event) 
			{
				String style = popup.getElement().getAttribute("style") + " position : fixed; z-index :1; ";
				popup.getElement().setAttribute( "style", style );
			}
		  });
		//Added by Dnyaneshwar on 2-AUG-13 [ set fixed position and 1 z-index  ] End
        popup.add( contentWidget );
        popup.setPopupPosition( popupLocationLeft, popupLocationTop );
    }

    
    /** Sets the header widget to be used as the header. */
    public void setHeader( Widget headerWidget )
    {
        this.headerWidget = headerWidget;
        updateWidget();
    }

    
    /** Sets the content widget to be used in the popup. */
    public void setContent( Widget contentWidget )
    {
        this.contentWidget = contentWidget;
        updateWidget();
    }

    
    /** 
     * Sets the location where the popup should be displayed.
     * 
     * @param left the offset in pixels from the left of screen
     * @param top the offset in pixels from the top of screen
     */
    public void setPopupLocation( int left, int top )
    {
        popupLocationLeft = left;
        popupLocationTop = top;
        updateWidget();
    }

    
    /**
     * If the popup is currently not displayed, then opens the popup
     * else if the popup is displayed, then closes the popup.
     */
    protected void showOrHidePopup()
    {
        if( !isPopupShowing )
        {
            popup.show();
            isPopupShowing = true;
        }
        else
        {
            popup.hide();
            isPopupShowing = false;
        }
    }
    
}

