<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body>
<script type="text/javascript" src="/ibase/webitm/js/gstRecoWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
		
<link href="/ibase/webitm/css/Galaxy/galaxy-theme.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/gstRecoWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/circle.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>

<script>
<![CDATA[
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		    	if(this.attributes.expanded.value == "false")
		   		{
		    		this.attributes.expanded.value = "true";
		   		}
		    	else
		   		{
		    		this.attributes.expanded.value = "false";
		   		}
	       		this.classList.remove("activeAccor");
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		        
		        var expAttributes = $("button[expanded='true']");
		        var expCnt = expAttributes.length;
		        
		        if(expCnt == acc.length)
		       	{
		        	document.getElementById("accorAct").value = "Collapse All";	
		       	}
		        else
		       	{
		        	document.getElementById("accorAct").value = "Expand All";	
		       	}
		  	}
		}
	});
	
	$(function() 
	{
		var panel = document.getElementsByClassName("panel");
	
		for (var j = 0; j < panel.length; j++)
		{
			panel[j].onclick = function()
		    {
		       if(this.id != "")
		       {
		       		var acc = document.getElementsByClassName("accordion");
		       		for(var i=0; i<acc.length; i++)
		       		{
		       			acc[i].classList.remove("activeAccor");
		       		}
		       		this.previousElementSibling.classList.add("activeAccor");
		       }
		  	}
		}
	});
	
	$(document).on("keydown", function (e) {
	    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
	        e.preventDefault();
	    }
	    else if(e.which === 13){
	    	 e.preventDefault();
	    }
	});

]]>
</script>


<form name="gstWizForm2" id="gstWizForm2" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:97%;">
		&#160;&#160;<img src="/ibase/images/menuImages/web/wavegeneration.png" onerror="this.src='/ibase/images/menuImages/errMenu.png'" style="position: absolute; margin-left: -20px; height: 20px; width: 20px;"/>
		&#160;GST Data Reconcilation
		<input type="button" Value="Expand All" class="button" id="accorAct" onclick="expandCollapse();" style="float: right;margin-right:2px;"/>
		<input type="hidden" Value="Select All" class="button" id="selectAllRow" onclick="selectAllRows();" style="float: right;margin-right:2px;"/>
	</div><br/><br/>
	
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;">
		<table id="errorActivityTable" width="100%" height="13%" class="tableClass"  style="margin: 10px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
				<xsl:for-each select="//error">
					<xsl:if test="position() = 1">
						<tr>	
							<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
								Message :
							</td> 
							<td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
								Description :
							</td>
							<td class="tdss_rightAlign"    style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
								<a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
							</td>
						</tr>
					</xsl:if>
					<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
					<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
					<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
					<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
					<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
					<tr style="background: rgba(255, 204, 0, 0.66);">
						 <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
							<xsl:value-of select="message"/>
						</td> 
						<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
							<xsl:value-of select="description"/>
							<br></br>
							<xsl:value-of select="trace"/>
						</td>
						<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
						</td>
					</tr>
					<script><![CDATA[]]>formatDetailWithErr();</script>
				</xsl:for-each>
				<xsl:for-each select="//error">
					<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
					<xsl:if test="position() = 1">
						<xsl:if test="$type = 'W'">
						<tr style="background: rgba(255, 204, 0, 0.66);">
							<td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
								<input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
							</td>
							<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
							</td>
						</tr>
						</xsl:if>
					</xsl:if>	
				</xsl:for-each>
		</table>
	</div>
	<div id="sideImagePanel" class="imagePanel"></div>
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div id="detailPage-input-Container">
			<xsl:for-each select="//Detail2">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				
				<xsl:if test="$dbID = '0'">
					<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>
					<xsl:variable name="gstin"><xsl:value-of select="gstin"/></xsl:variable>
					<input type="hidden" value="{$prd_code}" name="Detail2.{normalize-space($dbID)}.prd_code" id="prd_code" />
					<input type="hidden" value="{$gstin}" name="Detail2.{normalize-space($dbID)}.gstin" id="gstin" />
				</xsl:if>	
			
				<xsl:if test ="$dbID != '0'">
					<xsl:variable name="custDbID"><xsl:value-of select="@domID"/></xsl:variable>
					<xsl:variable name="supp_img_path"><xsl:value-of select="supp_img_path"/></xsl:variable>
					<button class="accordion" id="custPerc{$custDbID}" type="button" expanded="false">
						
						<div id="percClass{$custDbID}" class="c100 small p100">
						  <img src="{$supp_img_path}" class="custImg"/>
						  <div class="slice">
							<div id="custbar{$custDbID}" class="bar"></div>
							<div id="custfill{$custDbID}" class="fill"></div>
						  </div>
						</div>
						
						<div style="margin-left:10px;" class="dataSummry">
							<span class="headerText">Supplier- <xsl:value-of select="supp_code"/> &#160; <xsl:value-of select="supp_name"/>&#160;</span>
							<br></br>
							<span class="subText">State Code- <xsl:value-of select="supp_addr"/> </span>
						</div>
					</button>
					<div class="panel" id="custPanel{$custDbID}">
						<xsl:for-each select="Invoices/invoice">
						<xsl:variable name="soDbID"><xsl:value-of select="@domID"/></xsl:variable>
							<button class="accordion accordionSO" type="button" expanded="false">
								<div class="dataSummry" style = "margin-top:8px">
									<SELECT id='Detail2.{$soDbID}.status' name="Detail2.{$soDbID}.status" align="LEFT" TABINDEX="170" onclick = "event.stopPropagation();" onchange="checkAll('{$soDbID}','{$soDbID}','{$soDbID}')" class="input_editable">
										<OPTION value="X">Select</OPTION>
										<OPTION value="A">Accept</OPTION>
										<OPTION value="M">Modify</OPTION>
										<OPTION value="D">Delete</OPTION>
										<OPTION value="R">Reject</OPTION>
										<OPTION value="P">Pending</OPTION>
									</SELECT>
								</div>
								<div style="margin-left:10px;" class="dataSummry">
									<span class="headerText">Purchase Order - <xsl:value-of select="invoice_id"/>&#160;-</span>
									<span class="headerText">Date - <xsl:value-of select="tran_date"/>&#160;</span>
									<br></br>
									<span class="subText">Doc No - <xsl:value-of select="sale_order"/>&#160;</span>
									<span class="subText">Doc Date - <xsl:value-of select="doc_date"/>&#160;</span>
									<span class="subText">Amount - <xsl:value-of select="inv_amt"/>&#160;</span>
									<span class="subText">Site Code - <xsl:value-of select="tax_amt"/>&#160;</span>
								</div>
								<div class="selectSummry">
									<p><xsl:value-of select="data_match"/> mismatch found</p>
									<!-- <p>Reconcilation Status - Manual</p> -->
									<xsl:variable name="reco_status"><xsl:value-of select="reco_status"/></xsl:variable>
									
									<xsl:choose>
									     <xsl:when test="$reco_status ='E'">
									        <p>Reconcilation Status - Open</p>
									     </xsl:when>
									     <xsl:when test="$reco_status ='M'">
									        <p>Reconcilation Status - Manual</p>
									     </xsl:when>
									      <xsl:when test="$reco_status ='A'">
									        <p>Reconcilation Status - Automatic</p>
									     </xsl:when>
									     <xsl:otherwise>
								            <p>Reconcilation Status - N</p>
								         </xsl:otherwise>
									</xsl:choose>
								</div>
						  	</button>
						  	<div class="panel panelSO">
						  		<span id ="spanGSTR1_{$soDbID}" style = "display:inline-block;width:49.90%;overflow-x:scroll;border-right:1px solid black" onscroll="scrollGstrData('spanGSTR1_{$soDbID}','spanGSTR2_{$soDbID}')">
								  <table id ="details{$soDbID}" class="tableClass">
									<thead class="table-head">
										<tr>
											<th nowrap="true" style="border-left:0px solid black !important;" >
											<!-- <Input id='selectAll{$soDbID}' type='checkbox' name='selectAll' custId='{$custDbID}' tableId='{$soDbID}' onClick="checkAll('{$custDbID}','details{$soDbID}','{$soDbID}')"/> -->
											</th>
											<th nowrap="true">Sr No</th>
											<th nowrap="true">Status</th>
											<th nowrap="true">IGST(%)</th>
											<th nowrap="true">IGST Amount</th>
											<th nowrap="true">CGST(%)</th>
											<th nowrap="true">CGST Amount</th>
											<th nowrap="true">SCGT(%)</th>
											<th nowrap="true">SCGT Amount</th>
											<th nowrap="true">CESS(%)</th>
											<th nowrap="true">CESS Amount</th>
	
										</tr>
									</thead>
									<tbody class="table-body">
										<xsl:for-each select="gstr1">
										<xsl:variable name="linedbID"><xsl:value-of select="@domID"/></xsl:variable>
										<xsl:variable name="tran_id"><xsl:value-of select="tran_id"/></xsl:variable>
										<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
										<xsl:variable name="status"><xsl:value-of select=" status"/></xsl:variable>
										<xsl:variable name="igst_perc"><xsl:value-of select="igst_perc"/></xsl:variable>
										<xsl:variable name="igst_amt"><xsl:value-of select="igst_amt"/></xsl:variable>
										<xsl:variable name="cgst_perc"><xsl:value-of select="cgst_perc"/></xsl:variable>
										<xsl:variable name="cgst_amt"><xsl:value-of select="cgst_amt"/></xsl:variable>
										<xsl:variable name="scgt_perc"><xsl:value-of select="scgt_perc"/></xsl:variable>
										<xsl:variable name="scgt_amt"><xsl:value-of select="scgt_amt"/></xsl:variable>
										<xsl:variable name="cess_perc"><xsl:value-of select="cess_perc"/></xsl:variable>
										<xsl:variable name="cess_amt"><xsl:value-of select="cess_amt"/></xsl:variable>
										
										<!--<input type="hidden" id="Detail2.{normalize-space($linedbID)}.tran_id" name="Detail2.{normalize-space($linedbID)}.tran_id" value="{$tran_id}"></input>-->
										<input type="hidden" id="Detail2.{normalize-space($soDbID)}.tran_id" name="Detail2.{normalize-space($soDbID)}.tran_id" value="{$tran_id}"></input>
										
										<xsl:choose>
										    <xsl:when test="line_no">
												<tr class='trClass' id="{$linedbID}" onclick="setCheckboxRow(event,this,{$soDbID},'{$custDbID}','details{$soDbID}');">
													<td nowrap="true" style="border-left:0px solid black !important;">
														<!-- <Input type='checkbox' value="true" class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox" onclick="setCheckbox(this,'{$linedbID}','{$soDbID}','{$custDbID}','details{$soDbID}');" tabindex="-1" /> -->
														<Input type='checkbox' class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox"
															 onclick = "setChecked(this,'{$linedbID}')" value="true" tabindex="-1"  />
													</td>
													<td nowrap="true">
														<xsl:value-of select="line_no"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.line_no" value="{$line_no}"></input> -->
													</td>
													<td nowrap="true">
														<xsl:value-of select="status"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.status" value="{$status}"></input> -->
													</td>
													<td nowrap="true">
														<xsl:value-of select="igst_perc"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.igst_perc" value="{$igst_perc}"></input> -->
													</td>
													<td nowrap="true">
														<xsl:value-of select="igst_amt"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.igst_amt" value="{$igst_amt}"></input> -->
													</td>
													<td nowrap="true">
														<xsl:value-of select="cgst_perc"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.cgst_perc" value="{$cgst_perc}"></input> -->
													</td>
													<td nowrap="true">
														<xsl:value-of select="cgst_amt"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.cgst_amt" value="{$cgst_amt}"></input> -->
													</td>
													<td nowrap="true">
														<xsl:value-of select="scgt_perc"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.scgt_perc" value="{$scgt_perc}"></input> -->
													</td>
													<td nowrap="true">
														<xsl:value-of select="scgt_amt"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.scgt_amt" value="{$scgt_amt}"></input> -->
													</td>
													<td nowrap="true">
														<xsl:value-of select="cess_perc"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.cess_perc" value="{$cess_perc}"></input> -->
													</td>
													<td nowrap="true">
														<xsl:value-of select="cess_amt"/>
														<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.cess_amt" value="{$cess_amt}"></input> -->
													</td>
													
												</tr>
											</xsl:when>
											<xsl:otherwise>
											        <tr>
											        	<td nowrap="true" style="border-left:0px solid black !important;">
															<Input type='checkbox' class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox"
															 onclick = "setChecked(this)" value="false" tabindex="-1" disabled = "true" />
														</td>
														<td colspan = "10">
															Purchase data not found for this record
														</td>
											        </tr>
											</xsl:otherwise>
										 </xsl:choose>  
										</xsl:for-each>
									</tbody>
								  </table>
								</span>
								
								<!-- <span style="display:inline-block;height:72px;border:1px solid #dadada;"></span> -->
								
								<span id ="spanGSTR2_{$soDbID}" style = "display:inline-block;width:49.90%;overflow-x:scroll" onscroll="scrollGstrData('spanGSTR1_{$soDbID}','spanGSTR2_{$soDbID}')">
								  <table id ="details_GST{$soDbID}" class="tableClass">
									<thead class="table-head">
										<tr>
											<th nowrap="true" style="border-left:0px solid black !important;" >
											<!-- <Input id='selectAll{$soDbID}' type='checkbox' name='selectAll' custId='{$custDbID}' tableId='{$soDbID}' onClick="checkAll('{$custDbID}','details{$soDbID}','{$soDbID}')"/> -->
											</th>
											<th nowrap="true">Sr No</th>
											<th nowrap="true">Status</th>
											<th nowrap="true">IGST(%)</th>
											<th nowrap="true">IGST Amount</th>
											<th nowrap="true">CGST(%)</th>
											<th nowrap="true">CGST Amount</th>
											<th nowrap="true">SCGT(%)</th>
											<th nowrap="true">SCGT Amount</th>
											<th nowrap="true">CESS(%)</th>
											<th nowrap="true">CESS Amount</th>
										</tr>
									</thead>
									<tbody class="table-body">
										<xsl:for-each select="gstr2">
										<xsl:variable name="linedbID"><xsl:value-of select="@domID"/></xsl:variable>
										<xsl:variable name="tran_id"><xsl:value-of select="tran_id"/></xsl:variable>
										<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
										<xsl:variable name="status"><xsl:value-of select=" status"/></xsl:variable>
										<xsl:variable name="igst_perc"><xsl:value-of select="igst_perc"/></xsl:variable>
										<xsl:variable name="igst_amt"><xsl:value-of select="igst_amt"/></xsl:variable>
										<xsl:variable name="cgst_perc"><xsl:value-of select="cgst_perc"/></xsl:variable>
										<xsl:variable name="cgst_amt"><xsl:value-of select="cgst_amt"/></xsl:variable>
										<xsl:variable name="scgt_perc"><xsl:value-of select="scgt_perc"/></xsl:variable>
										<xsl:variable name="scgt_amt"><xsl:value-of select="scgt_amt"/></xsl:variable>
										<xsl:variable name="cess_perc"><xsl:value-of select="cess_perc"/></xsl:variable>
										<xsl:variable name="cess_amt"><xsl:value-of select="cess_amt"/></xsl:variable>
										
										<!--<input type="hidden" id="Detail2.{normalize-space($linedbID)}.tran_id__gstn" name="Detail2.{normalize-space($linedbID)}.tran_id__gstn" value="{$tran_id}"></input>-->
										<input type="hidden" id="Detail2.{normalize-space($soDbID)}.tran_id__gstn" name="Detail2.{normalize-space($soDbID)}.tran_id__gstn" value="{$tran_id}"></input>
						
										<xsl:choose>
										    <xsl:when test="line_no">
												<tr class='trClass' id="{$linedbID}" onclick="setCheckboxRow(event,this,{$soDbID},'{$custDbID}','details{$soDbID}');">
													<td nowrap="true" style="border-left:0px solid black !important;">
														<!-- <Input type='checkbox' value="true" class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox" onclick="setCheckbox(this,'{$linedbID}','{$soDbID}','{$custDbID}','details{$soDbID}');" tabindex="-1" /> -->
														<Input type='checkbox' class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox"
														 onclick = "setChecked(this,'{$linedbID}')" value="true" tabindex="-1"  />
													</td>
													<td nowrap="true">
														<xsl:value-of select="line_no"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="status"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="igst_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="igst_amt"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cgst_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cgst_amt"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="scgt_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="scgt_amt"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cess_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cess_amt"/>
													</td>
												</tr>
										 	</xsl:when>
											<xsl:otherwise>
											        <tr>
											        	<td nowrap="true" style="border-left:0px solid black !important;">
															<Input type='checkbox' class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox"
															 onclick = "setChecked(this)" value="false" tabindex="-1" disabled = "true" />
														</td>
														<td colspan = "10">
															Downloaded data not found for this record
														</td>
											        </tr>
											</xsl:otherwise>
										 </xsl:choose>   
										</xsl:for-each>
									</tbody>
								  </table>
								</span>
							</div>
						</xsl:for-each>
					</div>
				</xsl:if>
			</xsl:for-each>
		</div>
		<div id="btnDiv" style="width:100%;">
			<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden"  value="gstreco_wiz" name="OBJ_NAME" />
			<input type="hidden"  name="PRE_FORM_VAL" ID="PRE_FORM_VAL" />
			<input type="hidden"  value="gstWizUtilPage" name="JSP_NAME" />
			<input type="hidden" value="1:MP" name="formType" id="formType" />
			<input type="hidden"  value="finish" name="action" id="action" />
			<input type="button" style="margin-left:2px;" value="Previous" class="button" title="back" id="back" onclick="form2Previous();"/>
			<input type="submit" style="margin-left:2px;" value="Finish" class="button" title="finish" id="finish" onclick="return validateSubmit();setActionVal('finish');" />
		</div>
	</div>
	
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait work in progress" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
