package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.B2CSA;

public class B2CSASerializer extends BaseSerializer<B2CSA>
{
	@Override
	public void serialize(B2CSA b2csa, JsonGenerator json, SerializerProvider serializerProvider)throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		json.writeStringField("omon", b2csa.orgPeriodCode);
		json.writeStringField("oty", b2csa.orgType);
		json.writeStringField("ohsn_sc", b2csa.orgItemOrServiceCode);
		json.writeStringField("osupst_cd", b2csa.orgStateCode);
		json.writeStringField("state_cd", b2csa.stateCode);
		json.writeStringField("ty", b2csa.ty);
		json.writeStringField("hsn_sc", b2csa.itemOrServiceCode);
		json.writeNumberField("txval", b2csa.txval);
		json.writeNumberField("irt", b2csa.irt);
		json.writeNumberField("iamt", b2csa.iamt);
		json.writeNumberField("crt", b2csa.crt);
		json.writeNumberField("camt", b2csa.camt);
		json.writeNumberField("srt", b2csa.srt);
		json.writeNumberField("samt", b2csa.samt);
		json.writeNumberField("csrt", b2csa.csrt);
		json.writeNumberField("csamt", b2csa.csamt);
		
		json.writeStringField("prs", b2csa.prs ? "Y" : "N");
		if(b2csa.prs)
		{
			json.writeStringField("od_num", b2csa.od_num);
            json.writeStringField("od_dt", gstFmt.format(b2csa.od_dt));
		}
		if(b2csa.etin!=null)
        {
        	json.writeStringField("etin", b2csa.etin);
        }
		json.writeStringField("typ", b2csa.typ);
		
		json.writeEndObject();
	}
}
