package ibase.webitm.ejb.gst;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.Stateless;
import javax.imageio.ImageIO;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class GstRegNoIC
 */
@Stateless
public class GstRegNoIC extends ValidatorEJB implements GstRegNoICRemote, GstRegNoICLocal 
{
	public String globalXtraParams = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	
   	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException 
    {
   	   Document dom = null; 
   	   Document dom1 = null; 
   	   Document dom2 = null;
   	   String retString = "";	
       try
       {
    	    System.out.println("*************** Inside wfValData *******************");  	   		
	   		if(xmlString != null && xmlString.trim().length()>0)
	   		{
	   			dom = genericUtility.parseString(xmlString);		
	   		}
	   		if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
	   			dom1 = genericUtility.parseString(xmlString1);
	   		}
	   		if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
	   			dom2 = genericUtility.parseString(xmlString2);
	   		}
	   		retString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
	   		System.out.println("errorString::::::::::"+retString);
		}
        catch(Exception e)
        {
	        System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 
        }
        return retString;	    
	}
   	
	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		System.out.println("********************** Inside GstRegNoIC class ******************");
		E12GenericUtility genericUtility = new E12GenericUtility();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sql="";
		String userId = "";
		int currentFormNo = 0;
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		Node childNode = null;
		int childNodeLength = 0;
	    int ctr = 0, cnt = 0;
		String childNodeName = "";
		String errorType = "",errString="";
		String errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		String site_code="";
		String rec_type="";
		String tran_type="";
		String submission_type="";
		String state_code="";
		String prd_code="";
		String reco_status="";
		String reas_code="";
		String cust_name = "",tax_reg_no = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			conn = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"); 
			
		    if(objContext != null && objContext.trim().length()>0)
		    {
			    currentFormNo = Integer.parseInt(objContext);
			    System.out.println("currentFormNo:::"+currentFormNo);
		        switch(currentFormNo)
		    	{
		    		case 1:
		    		{	
		    			parentNodeList = dom.getElementsByTagName("Detail1");
		    			parentNode = parentNodeList.item(0);
		    			childNodeList = parentNode.getChildNodes();
		    			childNodeLength = childNodeList.getLength();
		    			
		    			for(ctr = 0; ctr < childNodeLength; ctr++)
		    			{
		    				childNode =  childNodeList.item(ctr);
		    				childNodeName = childNode.getNodeName();
		    				System.out.println("childNodeName:::"+childNodeName);
		    				
		    				/*if("fin_entity".equalsIgnoreCase(childNodeName))
		    				{
		    					String fin_entity = checkNull(genericUtility.getColumnValue("fin_entity",dom)).trim();
		    					System.out.println("fin_entity******"+fin_entity);
		    					if(fin_entity == null || fin_entity.trim().length() ==0)
		    					{
		    						errCode = "VTINSFINNL";
	    							errList.add(errCode);
	    							errFields.add(childNodeName.toLowerCase());
		    					}
		    				}*/
		    				
		    				if("site_code".equalsIgnoreCase(childNodeName))
		    				{
		    					site_code = checkNull(genericUtility.getColumnValue("site_code",dom)).trim();
		    					System.out.println("site_code******"+site_code);
		    					if(site_code == null || site_code.trim().length() ==0)
		    					{
		    						errCode = "VMPSITECD";
	    							errList.add(errCode);
	    							errFields.add(childNodeName.toLowerCase());
		    					}
		    					else if(site_code != null && site_code.trim().length() > 0)
		    					{
		    						sql = "select count(*) as cnt from site where site_code=?";
		    						pstmt = conn.prepareStatement(sql);
		    						pstmt.setString(1,site_code);
		    						rs = pstmt.executeQuery();
		    						if(rs.next())
		    						{
		    							cnt = rs.getInt("cnt");
		    						}
		    						if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
							    
		    						if(cnt==0)
		    						{
		    							errCode = "VTSITEXT";
		    							errList.add(errCode);
		    							errFields.add(childNodeName.toLowerCase());
		    						}
		    					}
		    				}
		    				
		    				else if("reg_no".equalsIgnoreCase(childNodeName))
		    				{
		    					String reg_no = checkNull(genericUtility.getColumnValue("reg_no",dom)).trim();
		    					System.out.println("reg_no******"+reg_no);
		    					if(reg_no == null || reg_no.trim().length() ==0)
		    					{
		    						errCode = "NULLGSTNNO";
	    							errList.add(errCode);
	    							errFields.add(childNodeName.toLowerCase());
		    					}
		    				}
		    				
		    				else if("reg_no1".equalsIgnoreCase(childNodeName))
		    				{
		    					String reg_no1 = checkNull(genericUtility.getColumnValue("reg_no1",dom)).trim();
		    					System.out.println("reg_no1******"+reg_no1);
		    					if(reg_no1 == null || reg_no1.trim().length() ==0)
		    					{
		    						errCode = "VMGSTUSER";
	    							errList.add(errCode);
	    							errFields.add(childNodeName.toLowerCase());
		    					}
		    				}
		    				
		    				else if("reg_no2".equalsIgnoreCase(childNodeName))
		    				{
		    					String reg_no2 = checkNull(genericUtility.getColumnValue("reg_no2",dom)).trim();
		    					System.out.println("reg_no2******"+reg_no2);
		    					if(reg_no2 == null || reg_no2.trim().length() ==0)
		    					{
		    						errCode = "VMGROSSAMT";
	    							errList.add(errCode);
	    							errFields.add(childNodeName.toLowerCase());
		    					}
		    				}
		    				
		    				else if("valid_upto".equalsIgnoreCase(childNodeName))
		    				{
		    					String valid_upto = checkNull(genericUtility.getColumnValue("valid_upto",dom)).trim();
		    					System.out.println("valid_upto******"+valid_upto);
		    					if(valid_upto == null || valid_upto.trim().length() ==0)
		    					{
		    						errCode = "VLDUPTNUL";
	    							errList.add(errCode);
	    							errFields.add(childNodeName.toLowerCase());
		    					}
		    				}
						
		    				
		    			}//end of for loop
		    		}//end of case1
		    		break;
		    		}
		        	int errListSize = errList.size();
		        	System.out.println("errListSize::::::::::"+errListSize);
		        	int count = 0;
		        	String errFldName = null;
		        	if (errList != null && errListSize > 0)
		        	{
		        		for (count = 0; count < errListSize; count++)
		        		{
		        			errCode = errList.get(count);
		        			errFldName = errFields.get(count);
		        			System.out.println(" testing :errCode .:" + errCode);
		        			errString = getErrorString(errFldName, errCode, userId);
		        			System.out.println("errString>>>>>>>>>"+errString);
		        			errorType = errorType(conn, errCode);
		        			if (errString.length() > 0)
		        			{
		        				String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
		        				bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
		        				errStringXml.append(bifurErrString);
		        				errString = "";
		        			}
		        			if (errorType.equalsIgnoreCase("E"))
		        			{
		        				break;
		        			}
		        		}
		        		errList.clear();
		        		errList = null;
		        		errFields.clear();
		        		errFields = null;
		        		errStringXml.append("</Errors> </Root> \r\n");
		        	} 
		        	else
		        	{
		        		errStringXml = new StringBuffer("");
		        	}
		      	}
			}//end of try block
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
			}
			finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						conn.close();
					}
					conn = null;
				} 
				catch (Exception d)
				{
					d.printStackTrace();
					throw new ITMException(d);
				}
			}
			errString = errStringXml.toString();
			System.out.println("testing : final errString : " + errString);
			return errString;
		}
	
	private String checkNull(String input) 
	{
		return input == null ? "" : input;
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException 
	{
		Document dom=null;
		Document domhr=null;
		Document domAll=null;
		String retString="";
		try
		{
			System.out.println("**************  Inside itemChanged method ****************");
			if(xmlString != null && xmlString.trim().length()>0)
	   		{
				dom = genericUtility.parseString(xmlString);		
	   		}
			if(xmlString1 != null && xmlString1.trim().length()>0)
	   		{
				domhr = genericUtility.parseString(xmlString1);		
	   		}
			if(xmlString2 != null && xmlString2.trim().length()>0)
	   		{
				domAll = genericUtility.parseString(xmlString2);		
	   		}
			retString = itemChanged(dom,domhr,domAll,objContext,currentColumn,editFlag,xtraParams);	
			System.out.println("retString::::::::::"+retString);
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 	
		}
		return retString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException 
    {
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int currentFormNo=0,ctr = 0;	
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		NodeList childNodeList = null;
		int childNodeLength = 0;
		String childNodeName = "";
		String columnValue="";
		int childNodeListLength = 0;
		String tran_id__ref="",rec_type="",tran_type="",state_code="",reco_status="",site_code="",cust_code="",cust_name="";
		String sql="";
		String doc_no="";
		String docDateStr="";
		double amount=0.0;
		String recDescr ="",tranDescr="",stateDescr="",recoDescr="",siteDescr="";
		java.util.Date doc_date=null;
		String loginSite = "";
		SimpleDateFormat sdf;
		String fin_entity = "",finent_descr="",reg_no="",gstRefCode="";
		java.util.Date valid_upto = null;
		int cnt = 0;
		HashMap map = new HashMap();
		try
		{
			conn = getConnection();
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[GstRegNoIC] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			switch(currentFormNo)
			{
				case 1 :
				{					
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					valueXmlString.append("<Detail1 domID='1'>");
					childNodeListLength = childNodeList.getLength();
					ArrayList gstList = new ArrayList();
					System.out.println("currentColumn-------->>[" + currentColumn + "]");
					
					if("itm_default".equalsIgnoreCase(currentColumn.trim()))
					{
						valueXmlString.append("<fin_entity><![CDATA[").append("").append( "]]></fin_entity>");
						valueXmlString.append("<finent_descr><![CDATA[").append("").append( "]]></finent_descr>");
						valueXmlString.append("<site_code><![CDATA[").append("").append( "]]></site_code>");
						valueXmlString.append("<site_descr><![CDATA[").append("").append( "]]></site_descr>");
						valueXmlString.append("<reg_no><![CDATA[").append("").append( "]]></reg_no>");
						valueXmlString.append("<reg_no1><![CDATA[").append("").append( "]]></reg_no1>");
						valueXmlString.append("<reg_no2><![CDATA[").append("").append( "]]></reg_no2>");
						valueXmlString.append("<valid_upto><![CDATA[").append("").append( "]]></valid_upto>");
						System.out.println("currentColumn>>site_code"+currentColumn);
					}// end of itm_default				
					else if("site_code".equalsIgnoreCase(currentColumn))
					{
						site_code = checkNull(genericUtility.getColumnValue("site_code", dom));
												
						if(site_code != null && site_code.trim().length() > 0)
						{
							sql = "select descr from site where site_code=?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,site_code);
							rs = pstmt.executeQuery();
							
							if(rs.next())
							{
								siteDescr = rs.getString("descr");
								System.out.println("descr>>"+siteDescr);	
							}
							if(pstmt != null)
							{
							    pstmt.close(); 
							    pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
							    rs = null;
							}	
						}
							
						valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr>");	
						
						sql = "select fin_entity from site where site_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,site_code);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							fin_entity = rs.getString("fin_entity");
							System.out.println("fin_entity>>"+fin_entity);	
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}		
						valueXmlString.append("<fin_entity>").append("<![CDATA["+fin_entity+"]]>").append("</fin_entity>");
						 
						sql = "select descr from finent where fin_entity=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,fin_entity);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							finent_descr = rs.getString("descr");
							System.out.println("finent_descr>>"+finent_descr);	
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}	
						valueXmlString.append("<finent_descr>").append("<![CDATA["+finent_descr+"]]>").append("</finent_descr>");
						 
					    	sql = "select ref_code,reg_no,valid_upto from siteregno where fin_entity=? and site_code=?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,fin_entity);
							pstmt.setString(2,site_code);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								reg_no = checkNull(rs.getString("reg_no"));
								gstRefCode = checkNull(rs.getString("ref_code"));
								valid_upto =  rs.getTimestamp("valid_upto");
							    map.put(gstRefCode.trim(),reg_no);
							    System.out.println("gstRefCode>>>>>>>>>"+gstRefCode);
							    System.out.println("reg_no>>>>>>>>>"+reg_no);
							    System.out.println("map.size()>>>>>>>>>"+map.size());
							}	
						
							if(pstmt != null)
							{
							    pstmt.close(); 
							    pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
							    rs = null;
							}	
							if(valid_upto != null)
							{
							  	docDateStr=genericUtility.getValidDateString((valid_upto).toString(),genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());
							}
							else
							{
							 	docDateStr = "";	
							}
							
							System.out.println("map.size()"+map.size());
							System.out.println("map>>>>>>>>>>>>>"+map);
							
							if(map.size() > 0)
							{
								valueXmlString.append("<reg_no>").append("<![CDATA["+checkNull((String)map.get("GSTIN_NO"))+"]]>").append("</reg_no>");
								valueXmlString.append("<reg_no1>").append("<![CDATA["+checkNull((String)map.get("GST_UNAME"))+"]]>").append("</reg_no1>");
								valueXmlString.append("<reg_no2>").append("<![CDATA["+checkNull((String)map.get("GST_GT"))+"]]>").append("</reg_no2>");
								valueXmlString.append("<valid_upto>").append("<![CDATA["+docDateStr+"]]>").append("</valid_upto>");
							}
							else
							{
								valueXmlString.append("<reg_no>").append("<![CDATA["+""+"]]>").append("</reg_no>");
								valueXmlString.append("<reg_no1>").append("<![CDATA["+""+"]]>").append("</reg_no1>");
								valueXmlString.append("<reg_no2>").append("<![CDATA["+""+"]]>").append("</reg_no2>");
								valueXmlString.append("<valid_upto>").append("<![CDATA["+docDateStr+"]]>").append("</valid_upto>");
							}
					}//end of site_code
					valueXmlString.append("</Detail1>");
					break;
				}//end of case1
			}//end of switch block
			valueXmlString.append("</Root>");		
		}//end of try block
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return valueXmlString.toString();
    }

	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
			    pstmt.close(); 
			    pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
			    rs = null;
			}
		} 
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
	@Override
	public String handleRequest(HashMap<String, String> reqParamMap) 
	{
		String action = "", retXMLStr = "";
		InitialContext ctx = null;
		GstRegNoICRemote gstRegNoICRemote = null;
		
		try
		{
			
			action = (String)reqParamMap.get("action");
			
			if("ITEM_CHANGE".equalsIgnoreCase(action))
			{
				String currXmlDataStr = "", hdrXmlDataStr = "", allXmlDataStr = "", currentColumn = "", objContext = "", editFlag = "";
				
				ctx=getInitialContext();
				currXmlDataStr = (String)reqParamMap.get("CUR_XML_STR");
				hdrXmlDataStr = (String)reqParamMap.get("HDR_XML_STR");
				allXmlDataStr = (String)reqParamMap.get("ALL_XML_STR");
				currentColumn = (String)reqParamMap.get("CUR_COLUMN");
				objContext = (String)reqParamMap.get("OBJ_CONTEXT");
				editFlag = (String)reqParamMap.get("EDIT_FLAG");
				
				gstRegNoICRemote = (ibase.webitm.ejb.gst.GstRegNoICRemote) ctx.lookup("ibase/GstRegNoIC/remote");
				retXMLStr = gstRegNoICRemote.itemChanged(currXmlDataStr, hdrXmlDataStr, allXmlDataStr, objContext, currentColumn, editFlag, globalXtraParams);
				
				System.out.println("retXMLStr["+retXMLStr+"] for action ["+action+"]");
			}
			else if("GET_IMG_PATH".equalsIgnoreCase(action))
			{
				String lineItemStr = "";
				String itemCode = (String)reqParamMap.get("REF_ID");
				String itemDescr = (String)reqParamMap.get("ITEM_DESCR");
				
				lineItemStr += "<item_code><![CDATA["+itemCode+"]]></item_code>";
				lineItemStr	+= "<item_descr><![CDATA["+itemDescr+"]]></item_descr>";
				
				retXMLStr = "<imgPath><![CDATA["+getImagePath(lineItemStr)+"]]></imgPath>";
				
				System.out.println("retXMLStr["+retXMLStr+"] for action ["+action+"]");
			}
			
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizEJB.handleRequest()"+e.getMessage());
			e.printStackTrace();
		}
		
		return retXMLStr;
	}
	
	public InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("WavegenWizEJB.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizEJB.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}
	
	public String getImagePath(String lineItemStr) throws ITMException
	{
		String retImgPath = "", itemParnt = "", itemCode = "", itemRefSer = "", docId = "",itemDescr = "", docType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		Connection conn = null;
		
		try
		{
			conn = getConnection();
			itemCode = getValue(lineItemStr, "item_code").trim();
			itemDescr = removeSpecialChar(getValue(lineItemStr, "item_descr"));
			
			sql = " SELECT ITEM_PARNT FROM ITEM WHERE ITEM_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemParnt = checkNull(rs.getString("ITEM_PARNT"));
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}
			
			sql = " SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_item'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemRefSer = checkNull(rs.getString("REF_SER"));
			}	
			if(rs != null)
			{
				rs.close();rs = null;
			}	
			if(pstmt != null)
			{	
				pstmt.close();pstmt = null;
			}
			
			sql = " SELECT DOC_CONTENTS.DOC_ID,DOC_CONTENTS.DOC_TYPE FROM DOC_CONTENTS, DOC_TRANSACTION_LINK, USERS "
				+ " WHERE DOC_TRANSACTION_LINK.DOC_ID = DOC_CONTENTS.DOC_ID AND USERS.CODE = DOC_CONTENTS.ADD_USER "
				+ " AND REF_SER = ? AND (REF_ID = ? OR REF_ID = ?) ORDER BY DOC_CONTENTS.DOC_ID ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemRefSer);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, itemParnt);

			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				docId = checkNull(rs.getString("DOC_ID"));
				docType= checkNull(rs.getString("DOC_TYPE"));
				retImgPath = "/ibase/WebITMDocumentHandlerServlet?OBJ_NAME=item&REF_ID="+itemCode.trim()+"&ACTION=GET_DOCUMENT&CLIENT=WEB1&DOC_ID="+docId+"&DOC_TYPE="+docType+"";
			}
			else
			{
				retImgPath = getCustomImagePath(itemCode.trim(),itemDescr,"itemcode");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();pstmt = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();conn = null;
				}
			} 
			catch (Exception e) 
			{
				throw new ITMException(e);
			}
		}
		
		return retImgPath;
	}
	
	public String getValue(String lineItemStr, String column) throws ITMException
	{
		String retValue = "";
		Document lineDom = null;
		
		try
		{
			lineDom =new E12GenericUtility().parseString("<detail>"+lineItemStr+"</detail>");
			retValue = lineDom.getElementsByTagName(column).item(0).getTextContent();
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retValue;
	}

	public String getCustomImagePath(String value,String altColImg, String object)
	{
		String imagePath = "";
		try
		{
			File objDir = new File (CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object);
			if(!objDir.exists())
			{
				objDir.mkdir();
			}
			if( fileExist(value, object))
			{
				imagePath = File.separator+"ibase"+File.separator+"resource"+File.separator+ object+File.separator + value + ".png";
			}
			else
			{
				File f = new File(CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object+File.separator + value + ".png");
				BufferedImage bi = createLabelImage(altColImg);
				ImageIO.write(bi,"PNG",f);
				imagePath = File.separator+"ibase"+File.separator+"resource"+File.separator+ object+File.separator + value + ".png";
			}
			
		}
		catch(Exception e)
		{
			System.out.println("PopUpDataAccessEJB.getCustomeImagePath()::getCustomImagePath");
			e.printStackTrace();
		}
		return imagePath;		
	}
	
	public String removeSpecialChar(String inputStr)
	{
		String retStr = "";
		
		if(inputStr.indexOf("&")!= -1)
		{
			retStr = inputStr.replaceAll("&", "AND");
		}
		else
		{
			retStr = inputStr.replaceAll("[-()%^!@#$%*{}]", " ");
		}
		
		return retStr;
	}
	
	public boolean fileExist(String value, String object)
	{
		boolean flag = true;
		try
		{
			String path = CommonConstants.RIALITE_PROFILE_PATH +File.separator+ object+File.separator + value + ".png";
			File f = new File(path);
			if( !f.exists() )
			{
				flag = false;
			}
			else
			{
				flag = true;
			}
		}
		catch (Exception e) 
		{
			System.out.println("PopUpDataAccessEJB.fileExist()"+e.getMessage());
		}
		return flag;
	}
	
	public BufferedImage createLabelImage(String value)
	{
		int width = 400, height = 400;
		BufferedImage bi = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		try 
		{
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			File fontFile = new File(CommonConstants.APPLICATION_CONTEXT+"webitm"+File.separator+"css"+File.separator+"fonts"+File.separator+"Museo300-Regular.ttf");
			ge.registerFont(Font.createFont(Font.TRUETYPE_FONT, fontFile));
			Graphics2D g = bi.createGraphics();
			String text = checkNull(dynamicMenuImage(value));
			int centerX = 200, centerY = 200;
			int ovalWidth = 400, ovalHeight = 400;
			Font font = new Font("Museo 300", Font.PLAIN, 200);
			g.setFont(font);
			Color c = Color.decode("#cfbebe");
			g.setColor(c);
			g.fillOval(centerX-ovalWidth/2, centerY-ovalHeight/2,ovalWidth, ovalHeight);
			FontMetrics fm = g.getFontMetrics();
			double textWidth = fm.getStringBounds(text,g).getWidth();
			g.setColor(Color.WHITE);
			g.drawString(text, (int) (centerX - textWidth/2), (int) ( (centerY + fm.getMaxAscent() / 2) ) - 2);
		}
		catch (Exception e) 
		{
			System.out.println("PopUpDataAccessEJB.createLabelImage()"+e.getMessage());
		}
		return bi;
	}
	
	private String dynamicMenuImage(String objDescr)
	{
		StringBuffer mnIconBuffer = new StringBuffer();
		String[] refSr = null;
		
		objDescr = objDescr.toUpperCase();
		objDescr = checkNull(objDescr);
		objDescr = objDescr.trim();
		if( objDescr != "" )
		{
			if( objDescr.indexOf(" ") != -1 )
			{
				refSr = objDescr.split(" ");
			}
			else if( objDescr.indexOf("-") != -1 )
			{
				refSr = objDescr.split("-");
			}
			else if( objDescr.indexOf("_") != -1 )
			{
				refSr = objDescr.split("_");
			}
			else if( objDescr.indexOf(":") != -1 )
			{
				refSr = objDescr.split(":");
			}
			String menuStr = "";
			
			if( refSr != null )
			{
				for( int i = 0; i <= refSr.length; i++ )
				{
					if( mnIconBuffer.length() < 2 && checkNull( refSr[i] ) != "" )
					{
						menuStr = refSr[i];
						menuStr = menuStr.trim();
						if( menuStr != ":" && !"".equalsIgnoreCase(menuStr) )
						{
							mnIconBuffer.append( menuStr.charAt(0) );
						}
					}
				}
			}
			else
			{
				mnIconBuffer.append( objDescr.charAt(0) );
			}
		}
		
		String menuIconPath = mnIconBuffer.toString();
		
		return menuIconPath;
	}
}
