package ibase.webitm.ejb.gst;

import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

import javax.annotation.PostConstruct;

import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.AESEncryption;
import ibase.webitm.util.gst.PubKeyEncryption;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class GSTDataSubmitWizEJB extends ValidatorEJB implements GSTDataSubmitWizEJBLocal, GSTDataSubmitWizEJBRemote  
{
	private String GST_API_URL = "";
	private String GST_AUTH_URL = "";
	private String appKey = "";
	InetAddress ipAddress = null;
	private byte[] appKeyInBytes = null;
	private String appKeyEncryptedAndCoded = "";
	private String clientId = "";
	private String clientSecret = "";
	AESEncryption aesEncryption = null;
	PubKeyEncryption pubKeyEncryption = null;
	Connection conn = null;
	@PostConstruct
	public void postConstruct()
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("GSTDataSubmitWizEJB PostConstruct called!");
			InputStream pubKeyInpStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ibase/webitm/resources/gst/GSTN_Public_Key.cer");
			conn = getConnection();
			FinCommon finCommon = new FinCommon();
			clientId = finCommon.getFinparams("999999", "GST_CLIENT_ID", conn);
			clientSecret = finCommon.getFinparams("999999", "GST_CLIENT_SECRET", conn);
			aesEncryption = new AESEncryption();
			pubKeyEncryption = new PubKeyEncryption(pubKeyInpStream);
			ipAddress = Inet4Address.getLocalHost();
			System.out.println("host ipAddress["+ipAddress.getHostAddress()+"]");
			
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = 'gst_base_url' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				GST_API_URL = checkNull(rs.getString("SERVICE_URI"));
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = 'gstr_auth_url' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				GST_AUTH_URL = checkNull(rs.getString("SERVICE_URI"));
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.postConstruct()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn!= null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.postConstruct()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		
	}
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String retString = null;
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			retString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :GSTDataSubmitWizEJB :itemChanged(String,String):" + e.getMessage() + ":" );
			e.printStackTrace();
		}
		System.out.println ( "Return String from GSTDataSubmitWizEJB ["+retString+"]" );
		
		return retString;
	}
	
	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		E12GenericUtility e12genericUtility = new E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		String sql = "", siteCode = "", siteDescr = "", gstinNo = "", userName = "", stateCode = "", stateDescr = "", grossTurnover = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("Inside GSTDataSubmitWizEJB itemchanged");
			conn = getConnection();
			siteCode = e12genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			System.out.println("currentColumn["+currentColumn+"] currentFormNo["+currentFormNo+"]" );
			
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?><Root><Header><editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag></Header>" );
			
			switch(currentFormNo)
			{
				case 1:
				{
					System.out.println(" -------- Inside itemchange case 1111111 ------------ ");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						
						appKey = aesEncryption.generateSecureKey();
						appKeyInBytes = aesEncryption.decodeBase64StringTOByte(appKey);
						appKeyEncryptedAndCoded = pubKeyEncryption.encrypt(appKeyInBytes);
						
						sql = " SELECT S.SITE_CODE, S.SH_DESCR, ST.GST_CODE, ST.DESCR, SR.REF_CODE, SR.REG_NO FROM SITE S, SITEREGNO SR, STATE ST"
							+ "	WHERE S.SITE_CODE = SR.SITE_CODE AND S.FIN_ENTITY = SR.FIN_ENTITY AND S.STATE_CODE = ST.STATE_CODE AND SR.REF_CODE IN ('GSTIN_NO','GST_UNAME','GST_GT')"
							+ " AND SR.SITE_CODE =  ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						
						while(rs.next())
						{
							siteDescr = checkNull(rs.getString("SH_DESCR"));
							if("GSTIN_NO".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								gstinNo = checkNull(rs.getString("REG_NO"));
							}
							if("GST_UNAME".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								userName = checkNull(rs.getString("REG_NO"));
							}
							if("GST_GT".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								grossTurnover =  checkNull(rs.getString("REG_NO"));
							}
							stateCode = checkNull(rs.getString("GST_CODE"));
							stateDescr = checkNull(rs.getString("DESCR"));
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<Detail1 domID='1'>");
						valueXmlString.append("<period_code><![CDATA[]]></period_code>");
						valueXmlString.append("<site_code><![CDATA[").append(siteCode).append( "]]></site_code>");
						valueXmlString.append("<site_descr><![CDATA[").append(siteDescr).append( "]]></site_descr>");
						valueXmlString.append("<gstin><![CDATA[" ).append(gstinNo).append( "]]></gstin>");
						valueXmlString.append("<username><![CDATA[").append(userName).append( "]]></username>");
						valueXmlString.append("<state_code><![CDATA[").append(stateCode).append( "]]></state_code>");
						valueXmlString.append("<state_descr><![CDATA[").append(stateDescr).append( "]]></state_descr>");
						valueXmlString.append("<gross_turnover><![CDATA[").append(grossTurnover).append( "]]></gross_turnover>");
						valueXmlString.append("<otp><![CDATA[]]></otp>");
						valueXmlString.append("<app_key><![CDATA["+appKey+"]]></app_key>");
						valueXmlString.append("<returns_type><![CDATA[]]></returns_type>");
						valueXmlString.append("</Detail1>" );
					}
					break;
				}
				/*case 2:
				{
					System.out.println(" -------- Inside itemchange case 2222222 ------------ ");
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<Detail2 domID='1'>");
						valueXmlString.append("<gstin><![CDATA[" ).append("33GSPTN2071G1ZC").append( "]]></gstin>");
						valueXmlString.append("<invoice_id><![CDATA[").append("INV0000001").append( "]]></invoice_id>");
						valueXmlString.append("<invoice_date><![CDATA[12-03-2017]]></invoice_date>");
						valueXmlString.append("</Detail2>" );
					}
					break;
				}*/
			}
			valueXmlString.append( "</Root>" );	
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.itemChanged()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(!conn.isClosed() && conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.itemChanged():finally block["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}
	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		System.out.println("GSTDataSubmitWiz.wfValData()");
		System.out.println("xmlString :"+xmlString);
		System.out.println("xmlString1 :"+xmlString1);
		System.out.println("xmlString2 :"+xmlString2);
		System.out.println("objContext :"+objContext);
		System.out.println("editFlag :"+editFlag);
		System.out.println("xtraParams :"+xtraParams);
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			System.out.println("Before calling function wfvalData****");
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);

			System.out.println("After calling method wfVAlData Error String===="+errString);
		} 
		catch (Exception e)
		{
			System.out.println("Exception : [GSTDataSubmitWiz][wfValData( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return errString;
	}
	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "", userId = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		int currentFormNo = 0;
		String sql = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String errorType = "", errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		try
		{
			userId = e12GenericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
				System.out.println("currentFormNo ["+currentFormNo+"]");
			}
			conn = getConnection();
			
			switch (currentFormNo)
			{
				case 1:
				{
					NodeList parentList = null, childList = null;
					Node childNode = null;
					String childNodeName = "", columnValue = "";
					int noOfChilds = 0;
					parentList = currFormDataDom.getElementsByTagName( "Detail" + currentFormNo );
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						if("period_code".equalsIgnoreCase(childNodeName))
						{
							sql = "SELECT COUNT(*) AS CNT FROM PERIOD WHERE TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(rs.getInt("CNT") == 0)
								{
									errList.add( "VTMONATD10" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
						if("site_code".equalsIgnoreCase(childNodeName))
						{
							sql = "SELECT COUNT(*) AS CNT FROM SITE WHERE SITE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(rs.getInt("CNT") == 0)
								{
									errList.add( "INVDSITECD" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
						}
					}
					break;
				}
				/*case 2:
				{
					break;
				}*/
			}
			int errListSize = errList.size();
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (int i = 0; i < errListSize; i++ )
				{
					errCode = (String)errList.get(i);
					errFldName = (String)errFields.get(i);
					System.out.println("errCode .........."+errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.wfValData()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	
		return errStringXml.toString();
	}
	
	@Override
	public String handleRequest(HashMap<String, String> reqParamMap) 
	{
		String retResponseXML = "", action = "";
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			action = reqParamMap.get("action");
			conn = getConnection();
			
			if("GENERATE_OTP".equalsIgnoreCase(action))
			{
				String userName = "", stateCode = "";
				String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
				
				if("NULLFOUND".equalsIgnoreCase(clientId) || "NULLFOUND".equalsIgnoreCase(clientSecret))
				{
					retResponseXML = "<root><message><![CDATA[Client ID/Client secret API configuration is missing.]]></message></root>";
					return retResponseXML;
				}
				
				userName = reqParamMap.get("user_name");
				stateCode = reqParamMap.get("state_code");
				
				JSONObject otpRequest = new JSONObject();
		        otpRequest.put("action", "OTPREQUEST");
		        otpRequest.put("app_key", appKeyEncryptedAndCoded);
		        otpRequest.put("username", userName);

		        HttpResponse<JsonNode> otpResp = Unirest.post(String.format("%s%s", GST_API_URL,GST_AUTH_URL))
								        		.header("Content-Type", "application/json")
								                .header("clientid", clientId)
								                .header("client-secret", clientSecret)
								                .header("state-cd", stateCode)
								                .header("ip-usr", ipAddress.getHostAddress())
								                .header("username", userName)
								                .header("txn", transactionId)
								                .header("app_key", appKeyEncryptedAndCoded)
								                .body(new JsonNode(otpRequest.toString()))
								                .asJson();

		        System.out.println(String.format("OTP Request : Status[%s] Response[%s]", otpResp.getStatus(), otpResp.getBody()));

		        if (otpResp.getStatus() == 200) 
		        {
		            JSONObject object = otpResp.getBody().getObject();
		            if( object.has("status_cd") && "1".equalsIgnoreCase(object.getString("status_cd")))
		            {
		            	retResponseXML = "<root><message><![CDATA[OTP generated successfuly!]]></message></root>";
		            }
		            else
		            {
		            	JSONObject errorJSON = otpResp.getBody().getObject().getJSONObject("error");
		            	retResponseXML = "<root><message><![CDATA[Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd")+"]]></message></root>";
		            }
		        }
		        else
		        {
		        	JSONObject errorJSON = otpResp.getBody().getObject().getJSONObject("error");
		        	retResponseXML = "<root><message><![CDATA[Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd")+"]]></message></root>";
		        }
			}
			else if ("ITEM_CHANGE".equalsIgnoreCase(action))
			{
				String currColumn = "", currFieldData = "", siteDescr = "", gstinNo = "", userName = "", stateCode = "", stateDescr = "", grossTurnover = "";
				
				currColumn = reqParamMap.get("focused_column");
				currFieldData = reqParamMap.get("data_value");
				
				System.out.println("custom itemchange logic for ["+currColumn+"] and data["+currFieldData+"]");
				if("SITE_CODE".equalsIgnoreCase(currColumn))
				{
					sql = " SELECT S.SITE_CODE, S.SH_DESCR, ST.GST_CODE, ST.DESCR, SR.REF_CODE, SR.REG_NO FROM SITE S, SITEREGNO SR, STATE ST"
						+ "	WHERE S.SITE_CODE = SR.SITE_CODE AND S.FIN_ENTITY = SR.FIN_ENTITY AND S.STATE_CODE = ST.STATE_CODE AND SR.REF_CODE IN ('GSTIN_NO','GST_UNAME','GST_GT')"
						+ " AND SR.SITE_CODE =  ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currFieldData);
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						siteDescr = checkNull(rs.getString("SH_DESCR"));
						if("GSTIN_NO".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
						{
							gstinNo = checkNull(rs.getString("REG_NO"));
						}
						if("GST_UNAME".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
						{
							userName = checkNull(rs.getString("REG_NO"));
						}
						if("GST_GT".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
						{
							grossTurnover = checkNull(rs.getString("REG_NO"));
						}
						stateCode = checkNull(rs.getString("GST_CODE"));
						stateDescr = checkNull(rs.getString("DESCR"));
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					
					retResponseXML = "<root><Detail1>"
								   + "<site_descr><![CDATA["+siteDescr+"]]></site_descr>"
								   + "<gstin><![CDATA["+gstinNo+"]]></gstin>"
								   + "<username><![CDATA["+userName+"]]></username>"
								   + "<state_code><![CDATA["+stateCode+"]]></state_code>"
								   + "<state_descr><![CDATA["+stateDescr+"]]></state_descr>"
								   + "<gross_turnover><![CDATA["+grossTurnover+"]]></gross_turnover>"
								   + "</Detail1></root>";
					
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.handleRequest()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(!conn.isClosed() && conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.handleRequest():finally block["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		System.out.println("final retResonseXML ["+retResponseXML+"]");
		return retResponseXML;
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			System.out.println("GSTDataSubmitWizEJB.errorType()["+ex.getMessage()+"]");
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
}
