package ibase.webitm.utility.wms;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

public class StatusChangeRequest implements Schedule {

	E12GenericUtility genericUtility = new E12GenericUtility();
	CommonWmsUtil commonWmsUtility = CommonWmsUtil.getInstance();
	@Override
	public String schedulePriority(String arg0) throws Exception {

		return null;
	}

	@SuppressWarnings("unchecked")
	@Override
	public String schedule(HashMap arg0) throws Exception {

		return null;
	}

	@Override
	public String schedule(String scheduleParamXML) throws Exception
	{	
		String siteCode = "";
		ibase.utility.UserInfoBean userInfo = null;
		String xtraParams = "";
		try
		{
			System.out.println("************ ["+scheduleParamXML+"]");
			userInfo = new ibase.utility.UserInfoBean(scheduleParamXML);
			siteCode = userInfo.getSiteCode();
			System.out.println("Site code = "+siteCode);
			xtraParams = "loginCode="+userInfo.getEmpCode()+"~~chgTerm="+userInfo.getRemoteHost()+"~~loginSiteCode="+siteCode;
			statusChange(siteCode,scheduleParamXML,xtraParams);
			//Changed by wasim on 28-01-2016 for using same schedular for stock count activity W15JSUN015 [START]
			StockCountActivty(siteCode);
			//Changed by wasim on 28-01-2016 for using same schedular for stock count activity W15JSUN015 [END]

		}
		catch(Exception e)
		{
			System.out.println("Inside catch Main scheduler");
			throw new Exception(e);
		}

		return "";
	}

	public String statusChange(String siteCode , String scheduleParamXML, String xtraParams) throws ITMException
	{
		String invStat="", sqlVariable="", qtyPerArt = "",unit="",mfgDate="",expiryDate="",quantity="",noArt="",refId="", lineNo="",
				palletStatus="", palletNo="", locCode="", lotSl="", lotNo="", itemCode="", lockStat="", lockCode="" ;

		String damageLocations="", holdLocations="",rejectedLoc="";//Added by Jagruti Shinde

		Timestamp today = new Timestamp(System.currentTimeMillis());

		ArrayList<HashMap<String, String>> awmsIntrArrList = new ArrayList<HashMap<String, String>>();
		ArrayList<String> damageLocArryKList = new ArrayList<String>();
		ArrayList<String> holdLocArryKList = new ArrayList<String>();
		//Changed by Jagruti Shinde Request id:[W16CSUN009]
		ArrayList<String> rejectedLocArryList = new ArrayList<String>();

		//Added by Jagruti Shinde on 13/OCT/16 Req id:[W16CSUN009]
		ArrayList<HashMap<String, String>> holdStockList = new ArrayList<HashMap<String,String>>();
		ArrayList<HashMap<String, String>> holdStockListNew = new ArrayList<HashMap<String,String>>();

		String sqlStr ="",sqlInvHold ="",tranId="",sqlCount ="",sqlGen= "",shDescr ="",lastCharS ="";
		Connection conn = null;
		PreparedStatement pstmt = null,pstmtHold = null ,pstmtCount = null ,pstmtGen =null;
		ResultSet rs = null,rsCount = null,rsHold = null ,rsGen =null;
		int cntSwms = 0;
		char lastChar ;

		try {
			ConnDriver connDriver = new ConnDriver(); 
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);

			DistCommon distComm = new DistCommon();
			CommonWmsUtil connUtil = new CommonWmsUtil();

			System.out.println("Inside Status Change Scheduler!");

			invStat = distComm.getDisparams("999999","AWMS_LOC_INVSTAT",conn);
			sqlVariable = distComm.getDisparams("999999","HLD_LOCK_STAT_CHANGE",conn);
			damageLocations = distComm.getDisparams("999999","DM_LOCKS",conn);
			holdLocations = distComm.getDisparams("999999","HOLD_LOCKS",conn);
			//Changed by Jagruti Shinde Request id:[W16CSUN009]
			rejectedLoc = distComm.getDisparams("999999","REJECTED_LOCKS",conn);

			invStat = invStat.replace(",", "','");
			invStat = "'"+invStat+"'";
			System.out.println("AWMS INVSTAT : "+invStat);

			sqlVariable = sqlVariable.replace(",", "','");
			sqlVariable = "'"+sqlVariable+"'";
			System.out.println("SQL Vaibale Value : "+sqlVariable);

			String[] damageLocArry=damageLocations.split(",");

			for(String value:damageLocArry){
				damageLocArryKList.add(value);
			}

			System.out.println("DAMAGE LOCATINOS ARRAY LIST : "+damageLocArryKList);

			String[] holdLocArry = holdLocations.split(",");

			for(String value:holdLocArry){
				holdLocArryKList.add(value);
			}

			System.out.println("HOLD LOCATIONS ARRAY LIST : "+holdLocArryKList);


			//Changed by Jagruti Shinde Request id:[W16CSUN009][start]
			String[] rejectedLocArry=rejectedLoc.split(",");

			for(String value:rejectedLocArry){
				rejectedLocArryList.add(value);
			}

			System.out.println("REJECTED  LOCATINOS ARRAY LIST : "+rejectedLocArryList);

			/*sql="SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW='w_inv_hold'";
			pstmt = conn.prepareStatement(sql);
			rs=pstmt.executeQuery();

			if(rs.next())
			{
				tranRefSer=rs.getString("REF_SER");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}*/

			sqlInvHold = " SELECT H.TRAN_ID,D.LOC_CODE,D.ITEM_CODE,D.LOT_NO,D.LOT_SL,H.LOCK_CODE ,D.LINE_NO FROM STOCK S, INV_HOLD H, INV_HOLD_DET D WHERE S.SITE_CODE = ? AND " +
					" S.INV_STAT IN ("+invStat+") AND H.LOCK_CODE IN ("+sqlVariable+") " +
					" AND H.TRAN_ID= D.TRAN_ID AND D.LOT_NO = S.LOT_NO AND D.LOT_SL=S.LOT_SL " +
					" AND D.ITEM_CODE = S.ITEM_CODE AND D.LOC_CODE =S.LOC_CODE AND D.HOLD_STATUS='H' AND S.HOLD_QTY > 0 ";

			pstmtHold = conn.prepareStatement(sqlInvHold);
			pstmtHold.setString(1, siteCode);
			rsHold = pstmtHold.executeQuery();
			while(rsHold.next())
			{	
				tranId = checkNullAndTrim(rsHold.getString("TRAN_ID"));
				locCode = checkNullAndTrim(rsHold.getString("LOC_CODE"));
				itemCode = checkNullAndTrim(rsHold.getString("ITEM_CODE"));
				lotNo = checkNullAndTrim(rsHold.getString("LOT_NO"));
				lotSl = checkNullAndTrim(rsHold.getString("LOT_SL"));
				lockCode = checkNullAndTrim(rsHold.getString("LOCK_CODE"));
				lineNo = checkNullAndTrim(rsHold.getString("LINE_NO"));


				sqlGen= "SELECT SH_DESCR FROM GENCODES WHERE FLD_NAME = ? AND FLD_VALUE = ?";
				pstmtGen = conn.prepareStatement(sqlGen);
				pstmtGen.setString(1, "REFSER_FOR_LOCK");
				pstmtGen.setString(2, lockCode);
				rsGen = pstmtGen.executeQuery();
				if(rsGen.next())
				{
					shDescr = checkNullAndTrim(rsGen.getString("SH_DESCR"));
				}
				if(pstmtGen != null)
				{
					pstmtGen.close();
					pstmtGen = null;
				}
				if(rsGen != null)
				{
					rsGen.close();
					rsGen = null;
				}

				System.out.println("Reference Series from gencodes["+shDescr+"]");

				sqlCount = " SELECT COUNT(1) FROM SWMS_TO_AWMS  WHERE IN_OUT = ?  AND REF_SER = ? AND REF_ID = ? " +
						" AND (TRIM(PALLET_NO) = (SUBSTR(TRIM( ? ),0,LENGTH(TRIM( ? ))-1 ) ) OR  TRIM(PALLET_NO) = ? )" +
						"   AND ITEM_CODE = ? AND LOT_NO = ? AND LOT_SL = ? AND LINE_NO = ? ";
				pstmtCount = conn.prepareStatement(sqlCount);
				pstmtCount.setString(1, "S");
				pstmtCount.setString(2, shDescr);
				pstmtCount.setString(3, tranId);
				pstmtCount.setString(4, locCode);
				pstmtCount.setString(5, locCode);
				pstmtCount.setString(6, locCode);
				pstmtCount.setString(7, itemCode);
				pstmtCount.setString(8, lotNo);
				pstmtCount.setString(9, lotSl);
				pstmtCount.setString(10, lineNo);

				rsCount = pstmtCount.executeQuery();
				if(rsCount.next())
				{	
					cntSwms = rsCount.getInt(1);
				}
				if(pstmtCount != null)
				{
					pstmtCount.close();
					pstmtCount = null;
				}
				if (rsCount != null)
				{
					rsCount.close();
					rsCount = null;
				}

				System.out.println( "cntSwms:::"+cntSwms);
				if( cntSwms == 0)
				{
					/*sqlStr = "SELECT S.QTY_PER_ART,S.UNIT,S.MFG_DATE,S.EXP_DATE,S.QUANTITY,S.NO_ART,S.LOC_CODE,S.LOT_SL,S.LOT_NO,S.ITEM_CODE,D.LINE_NO,"
							+ "D.TRAN_ID,H.LOCK_CODE "
							+ "FROM STOCK S, INV_HOLD H, INV_HOLD_DET D WHERE S.SITE_CODE=? AND S.INV_STAT IN ("+invStat+") AND H.LOCK_CODE IN("+sqlVariable+") "
							+ "AND H.TRAN_ID= D.TRAN_ID AND D.LOT_NO = S.LOT_NO AND D.LOT_SL=S.LOT_SL  AND D.ITEM_CODE = S.ITEM_CODE AND D.LOC_CODE =S.LOC_CODE "
							+ "AND D.HOLD_STATUS='H' AND S.HOLD_QTY > 0 AND FN_CHECK_SWMS_TO_AWMS(H.TRAN_ID,'"+refSerSwms+"','S')=0";*/

					//Changed by Jagruti Shinde Request id:[W16CSUN009] on 13/OCT/16 [Start]
					sqlStr = "SELECT S.QTY_PER_ART,S.UNIT,S.MFG_DATE,S.EXP_DATE,S.QUANTITY,S.NO_ART,S.LOC_CODE,S.LOT_SL,S.LOT_NO,S.ITEM_CODE,D.LINE_NO,"
							+ "D.TRAN_ID,H.LOCK_CODE "
							+ "FROM STOCK S, INV_HOLD H, INV_HOLD_DET D WHERE S.SITE_CODE = ? AND S.INV_STAT IN ("+invStat+") AND H.LOCK_CODE IN("+sqlVariable+") "
							+ "AND H.TRAN_ID= D.TRAN_ID AND D.LOT_NO = S.LOT_NO AND D.LOT_SL=S.LOT_SL  AND D.ITEM_CODE = S.ITEM_CODE AND D.LOC_CODE =S.LOC_CODE "
							+ "AND D.HOLD_STATUS='H' AND S.HOLD_QTY > 0 AND D.TRAN_ID = ? ";


					pstmt = conn.prepareStatement(sqlStr);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, tranId);
					rs = pstmt.executeQuery();

					while(rs.next())
					{	
						qtyPerArt = checkNullAndTrim(rs.getString("QTY_PER_ART"));
						unit = rs.getString("UNIT");
						mfgDate = checkNullAndTrim(rs.getString("MFG_DATE"));
						expiryDate = checkNullAndTrim(rs.getString("EXP_DATE"));
						quantity = rs.getString("QUANTITY");
						noArt = checkNullAndTrim(rs.getString("NO_ART"));
						locCode = rs.getString("LOC_CODE");
						palletNo = checkNullAndTrim(rs.getString("LOC_CODE"));
						lotSl = rs.getString("LOT_SL");
						lotNo = rs.getString("LOT_NO");
						itemCode = rs.getString("ITEM_CODE");
						lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
						refId = rs.getString("TRAN_ID");
						lockCode = rs.getString("LOCK_CODE");

						HashMap<String, String> damageHoldStockLMap = new HashMap<String, String>();

						damageHoldStockLMap.put("PALLET_NO", locCode);
						damageHoldStockLMap.put("SITE_CODE", siteCode);
						damageHoldStockLMap.put("LOT_SL", lotSl);
						damageHoldStockLMap.put("LOT_NO", lotNo);
						damageHoldStockLMap.put("ITEM_CODE", itemCode);
						damageHoldStockLMap.put("LOCK_CODE", lockCode);

						holdStockList.add(damageHoldStockLMap);
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}

					holdStockListNew.addAll(holdStockList);
					System.out.println("holdStockListNew::::"+holdStockListNew);

					//Changed by Jagruti Shinde Req id:[W16GSUN002][Start]
					Iterator<HashMap<String, String>> holdIterator=holdStockListNew.iterator();
					while(holdIterator.hasNext())
					{				
						HashMap<String, String> holdMap=new HashMap<String, String>();

						holdMap=holdIterator.next();
						System.out.println("@V@ holdMap size in while loop :- ["+holdMap.size()+"]");

						palletNo=holdMap.get("PALLET_NO");
						siteCode=holdMap.get("SITE_CODE");
						lotSl=holdMap.get("LOT_SL");
						lotNo=holdMap.get("LOT_NO");
						itemCode=holdMap.get("ITEM_CODE");
						lockCode=holdMap.get("LOCK_CODE");

						System.out.println("@V@ PALLET_NO  :- ["+palletNo+"]");
						System.out.println("@V@ SITE_CODE :- ["+siteCode+"]");
						System.out.println("@V@ LOT_SL :- ["+lotSl+"]");
						System.out.println("@V@ LOT_NO :- ["+lotNo+"]");
						System.out.println("@V@ ITEM_CODE :- ["+itemCode+"]");
						System.out.println("@V@ LOCK_CODE :- ["+lockCode+"]");

						lastChar=palletNo.charAt(palletNo.trim().length()-1);
						lastCharS = Character.toString(lastChar);
						System.out.println("lastChar of pallet:::"+lastChar);
						if("R".equalsIgnoreCase(lastCharS))
						{
							System.out.println("getRejectedPalletStatus called::::::");
							palletStatus = getRejectedPalletStatus(palletNo, siteCode, holdStockListNew,lockCode,conn);
						}
						else
						{
							System.out.println("getPalletStatus called::::::");
							palletStatus = getPalletStatus(palletNo, siteCode, holdStockListNew,lockCode,conn);
						}
					}

					//palletStatus = getPalletStatus(palletNo, siteCode, holdStockList,lockCode,conn);
					//palletStatus = getPalletStatus(palletNo, siteCode, holdStockListNew,lockCode,conn);
					//Changed by Jagruti Shinde Req id:[W16GSUN002][End]

					System.out.println("palletStatus for AWMS :"+palletStatus);
					//Changed by Jagruti Shinde Request id:[W16CSUN009] on 13/OCT/16 [End]
					sqlStr = "SELECT S.QTY_PER_ART,S.UNIT,S.MFG_DATE,S.EXP_DATE,S.QUANTITY,S.NO_ART,S.LOC_CODE,S.LOT_SL,S.LOT_NO,S.ITEM_CODE,D.LINE_NO,"
							+ "D.TRAN_ID,H.LOCK_CODE "
							+ "FROM STOCK S, INV_HOLD H, INV_HOLD_DET D WHERE S.SITE_CODE = ? AND S.INV_STAT IN ("+invStat+") AND H.LOCK_CODE IN("+sqlVariable+") "
							+ "AND H.TRAN_ID= D.TRAN_ID AND D.LOT_NO = S.LOT_NO AND D.LOT_SL=S.LOT_SL  AND D.ITEM_CODE = S.ITEM_CODE AND D.LOC_CODE =S.LOC_CODE "
							+ "AND D.HOLD_STATUS='H' AND S.HOLD_QTY > 0 AND D.TRAN_ID = ? ";

					pstmt = conn.prepareStatement(sqlStr);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, tranId);
					rs = pstmt.executeQuery();

					while(rs.next())
					{	
						qtyPerArt = checkNullAndTrim(rs.getString("QTY_PER_ART"));
						unit = rs.getString("UNIT");
						mfgDate = checkNullAndTrim(rs.getString("MFG_DATE"));
						expiryDate = checkNullAndTrim(rs.getString("EXP_DATE"));
						quantity = rs.getString("QUANTITY");
						noArt = checkNullAndTrim(rs.getString("NO_ART"));
						locCode = rs.getString("LOC_CODE");
						palletNo = checkNullAndTrim(rs.getString("LOC_CODE"));
						lotSl = rs.getString("LOT_SL");
						lotNo = rs.getString("LOT_NO");
						itemCode = rs.getString("ITEM_CODE");
						lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
						refId = rs.getString("TRAN_ID");
						lockCode = rs.getString("LOCK_CODE");


						//Changed by wasim on 23-01-2016 to consider other suffix locations aprt from Q [START]

						/*palletNo = palletNo.charAt(palletNo.trim().length()-1)=='Q'?palletNo.substring(0,palletNo.trim().length()-1):palletNo;
				          System.out.println("Pallet No After removing Q: "+palletNo);*/

						palletNo = (palletNo.charAt(palletNo.trim().length()-1)=='Q') || (palletNo.charAt(palletNo.trim().length()-1)=='M') || 
								(palletNo.charAt(palletNo.trim().length()-1)=='S') || (palletNo.charAt(palletNo.trim().length()-1)=='B') ||
								(palletNo.charAt(palletNo.trim().length()-1)=='X') || (palletNo.charAt(palletNo.trim().length()-1)=='U') || 
								(palletNo.charAt(palletNo.trim().length()-1)=='P') || (palletNo.charAt(palletNo.trim().length()-1)=='R') //Changed by wasim on 02-05-2016 to consider rejected location with suffix R 
								? palletNo.substring(0,palletNo.trim().length()-1):palletNo;
								System.out.println("Pallet No After removing suffix: "+palletNo);		   
								//Changed by wasim on 23-01-2016 to consider other suffix locations aprt from Q [END]

								HashMap<String, String> awmsMap = new HashMap<String, String>();
								awmsMap.put("ITEM_CODE", itemCode);
								awmsMap.put("REF_ID", refId);
								//Changed by Jagruti Shinde Request id:[W16CSUN009]
								//awmsMap.put("REF_SER", refSerSwms);
								awmsMap.put("REF_SER", shDescr);
								awmsMap.put("TRAN_DATE", checkNullAndTrim(String.valueOf(today)));
								awmsMap.put("QTY_PER_ART", qtyPerArt);
								awmsMap.put("LOT_NO", lotNo);
								awmsMap.put("LOT_SL", lotSl);
								awmsMap.put("QUANTITY", noArt);
								awmsMap.put("TOTAL_QTY", quantity);
								awmsMap.put("PALLET_NO", palletNo);
								awmsMap.put("LINE_NO", lineNo);
								awmsMap.put("UNIT", unit);
								awmsMap.put("FAMILY_GRP", "");
								awmsMap.put("TRAN_ID", "");
								awmsMap.put("IN_OUT", "S");
								awmsMap.put("EXP_DATE", expiryDate);
								awmsMap.put("MFG_DATE", mfgDate);
								awmsMap.put("PALLET_STATUS", palletStatus);
								awmsMap.put("MSG_STAT", "N");

								if(damageLocArryKList.contains(lockCode.trim())){
									lockStat = "DAMAGE";
								}
								else if(holdLocArryKList.contains(lockCode.trim())){
									lockStat = "HOLD";
								}
								//Changed by Jagruti Shinde Request id:[W16CSUN009][start]
								else if(rejectedLocArryList.contains(lockCode.trim())){
									lockStat = "REJ";
								}
								//Changed by Jagruti Shinde Request id:[W16CSUN009][End]

								awmsMap.put("LOCK_STAT", lockStat);
								awmsMap.put("ERR_COD", "");
								awmsMap.put("ERR_DESC", "");
								awmsMap.put("QC_TYPE", "");
								awmsMap.put("TRANS_DT_ACK", "");
								awmsMap.put("STRO_PREF", "");

								awmsIntrArrList.add(awmsMap);
								System.out.println("AWMS HashMap:"+awmsMap);
								if(awmsIntrArrList.size() > 0)
								{
									connUtil.updateAwmsInterface(awmsIntrArrList, siteCode, conn);
									awmsIntrArrList.clear();
									System.out.println("Record insert sucessfully::");
								}
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					System.out.println("AWMS Interface List:"+awmsIntrArrList);
				}
			}
			if(pstmtHold != null)
			{
				pstmtHold.close();
				pstmtHold = null;
			}
			if (rsHold != null)
			{
				rsHold.close();
				rsHold = null;
			}	
		}
		catch(Exception e)
		{
			System.out.println("Exception :StatusChange :"+e.getMessage());
			try
			{	
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				conn.rollback();
			}
			catch(Exception e1)
			{
				System.out.println("StatusChangeRequest.statusChange()"+e.getMessage());
			}
		}
		finally
		{
			try
			{
				conn.commit();
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmtHold != null)
				{
					pstmtHold.close();
					pstmtHold = null;
				}
				if (rsHold != null)
				{
					rsHold.close();
					rsHold = null;
				}
				if(pstmtCount != null)
				{
					pstmtCount.close();
					pstmtCount = null;
				}
				if (rsCount != null)
				{
					rsCount.close();
					rsCount = null;
				}
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e) 
			{
				System.out.println("Error in  Status Change : "+e.getMessage());
			}
		}

		return null;
	}

	private String getPalletStatus(String palletNo,String siteCode,ArrayList<HashMap<String, String>> damageStockList, String lockCode, Connection conn) throws SQLException
	{
		String invStat="", sqlStr = "" ,sqlStockQty ="" ,sqlHold = "";
		PreparedStatement pstmt = null ,pstmtStock = null;
		ResultSet rs = null,rsStock =null;
		ArrayList<HashMap<String, String>> stockList = new ArrayList<HashMap<String,String>>();
		String palletStatus = "F";
		String lotSl="",lotNo="",itemCode="";//Added by Jagruti Shinde on 13/OCT/16 Req id:[W16CSUN009]

		double quantity,holdQty;//Added by Jagruti Shinde on 13/OCT/16 Req id:[W16CSUN009]
		int count =0,cntLoc =0;//Added by Jagruti Shinde on 13/OCT/16 Req id:[W16CSUN009]

		DistCommon distComm = new DistCommon();

		invStat = distComm.getDisparams("999999","AWMS_LOC_INVSTAT",conn);

		invStat = invStat.replace(",", "','");
		invStat = "'"+invStat+"'";
		System.out.println("AWMS INVSTAT in getPalletStatus: "+invStat);

		System.out.println("Inside getPalletStatus...........");
		try 
		{
			sqlStr = "SELECT LOC_CODE,ITEM_CODE,LOT_NO,LOT_SL,SITE_CODE FROM STOCK WHERE QUANTITY > 0 "
					+"AND LOC_CODE = ? AND SITE_CODE = ? AND INV_STAT IN ("+invStat+")";

			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, palletNo);
			pstmt.setString(2, siteCode);

			rs = pstmt.executeQuery();
			while(rs.next())
			{
				HashMap<String,String> stockHashMap =  new HashMap<String, String>();

				stockHashMap.put("PALLET_NO", rs.getString("LOC_CODE"));
				stockHashMap.put("SITE_CODE", rs.getString("SITE_CODE"));
				stockHashMap.put("LOT_SL", rs.getString("LOT_SL"));
				stockHashMap.put("LOT_NO", rs.getString("LOT_NO"));
				stockHashMap.put("ITEM_CODE", rs.getString("ITEM_CODE"));
				stockHashMap.put("LOCK_CODE", lockCode);

				stockList.add(stockHashMap);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			System.out.println("AWMS Stock List:"+stockList);
			ArrayList <HashMap<String, String>>tempList=new ArrayList<HashMap <String, String>>();
			for(Iterator<HashMap<String, String>> iter = stockList.iterator();iter.hasNext();)
			{
				System.out.println("Checking...........");
				HashMap<String, String> stock = iter.next();
				System.out.println("stock before check::::::"+stock);

				if(!damageStockList.contains(stock))
				{
					//Changed by Jagruti Shinde on 13/OCT/16 Req id:[W16CSUN009][Start]
					//palletStatus = "P";
					//break;
					tempList.add(stock);
					System.out.println("tempList after removing damagelist::::: ["+tempList+"]");

				}
			}//END FOR
			System.out.println("@V@ TempList size() :- ["+tempList.size()+"]");
			if(tempList.size()>0)
			{
				Iterator<HashMap<String, String>> tempIterator=tempList.iterator();
				while(tempIterator.hasNext())
				{				
					HashMap<String, String> tempMap=new HashMap<String, String>();

					tempMap=tempIterator.next();
					System.out.println("@V@ tempMap size in while loop :- ["+tempMap.size()+"]");

					palletNo=tempMap.get("PALLET_NO");
					siteCode=tempMap.get("SITE_CODE");
					lotSl=tempMap.get("LOT_SL");
					lotNo=tempMap.get("LOT_NO");
					itemCode=tempMap.get("ITEM_CODE");
					lockCode=tempMap.get("LOCK_CODE");

					System.out.println("@V@ PALLET_NO  :- ["+palletNo+"]");
					System.out.println("@V@ SITE_CODE :- ["+siteCode+"]");
					System.out.println("@V@ LOT_SL :- ["+lotSl+"]");
					System.out.println("@V@ LOT_NO :- ["+lotNo+"]");
					System.out.println("@V@ ITEM_CODE :- ["+itemCode+"]");
					System.out.println("@V@ LOCK_CODE :- ["+lockCode+"]");

					sqlStockQty="SELECT QUANTITY,HOLD_QTY FROM STOCK WHERE LOC_CODE = ? AND SITE_CODE = ? AND LOT_SL = ? AND LOT_NO = ? AND ITEM_CODE = ? ";
					pstmtStock = conn.prepareStatement(sqlStockQty);
					pstmtStock.setString(1, palletNo);
					pstmtStock.setString(2, siteCode);
					pstmtStock.setString(3, lotSl);
					pstmtStock.setString(4, lotNo);
					pstmtStock.setString(5, itemCode);

					rsStock = pstmtStock.executeQuery();
					while(rsStock.next())
					{
						quantity = rsStock.getDouble("QUANTITY");
						holdQty = rsStock.getDouble("HOLD_QTY");
						if(quantity > 0 && holdQty > 0 && quantity == holdQty)
						{
							count++;
							System.out.println("count::::"+count);
						}
						else if(holdQty ==0)
						{
							palletStatus = "P";
							System.out.println("Pallet is partial:hold_qty is 0::::::");
						}

					}
					if(pstmtStock != null)
					{
						pstmtStock.close();
						pstmtStock = null;
					}
					if(rsStock != null)
					{
						rsStock.close();
						rsStock = null;
					}

				}// FIRST ITERATOR
				Iterator<HashMap<String, String>> secondIterator=tempList.iterator();
				while(secondIterator.hasNext())
				{				
					System.out.println("@v@ AT SECOND ITERATOR $$$$$$$$");
					HashMap<String, String> tempMap=new HashMap<String, String>();

					tempMap=secondIterator.next();
					System.out.println("@V@ tempMap size in second iterator:- ["+tempMap.size()+"]");

					palletNo=tempMap.get("PALLET_NO");
					siteCode=tempMap.get("SITE_CODE");
					lotSl=tempMap.get("LOT_SL");
					lotNo=tempMap.get("LOT_NO");
					itemCode=tempMap.get("ITEM_CODE");
					lockCode=tempMap.get("LOCK_CODE");
					System.out.println("tempList.size():::::::"+tempList.size()+"count:::::"+count);	
					if(tempList.size() > count)
					{
						palletStatus = "P";
						System.out.println("Pallet is Partial:tempList.size() > count::::::");
					}
					else if(tempList.size() == count)
					{
						sqlHold ="SELECT COUNT(1) FROM INV_HOLD I,INV_HOLD_DET D WHERE I.TRAN_ID = D.TRAN_ID AND D.LOC_CODE = ? AND D.ITEM_CODE = ?" +
								" AND D.SITE_CODE = ? AND D.LOT_NO = ? AND D.LOT_SL = ? AND I.LOCK_CODE = ? ";
						pstmt = conn.prepareStatement(sqlHold);
						pstmt.setString(1,palletNo);
						pstmt.setString(2, itemCode);
						pstmt.setString(3, siteCode);
						pstmt.setString(4, lotNo);
						pstmt.setString(5, lotSl);
						pstmt.setString(6, lockCode);

						rs = pstmt.executeQuery();
						if(rs.next())
						{	
							cntLoc = rs.getInt(1);
							System.out.println( "cntLoc:::"+cntLoc);
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}

						if(cntLoc > 0)
						{
							if(cntLoc == count)
							{
								System.out.println("count::::"+count);
								palletStatus = "F";
								System.out.println("Pallet is full:same lock is applied for remaining stock items::::::");
							}
							else
							{
								palletStatus = "P";
								System.out.println("Pallet is partial::same lock is not applied for remaining stock items::::::");
							}
						}
						else
						{
							palletStatus = "P";
							System.out.println("Pallet is partial::lock is not applied to remaining items:::::");
						}
					}
					//Changed by Jagruti Shinde on 13/OCT/16s Req id:[W16CSUN009][End]
				}
			}
		} catch (SQLException e) 
		{
			e.printStackTrace();
			throw e;
		}

		return palletStatus;
	}

	//Changed by Jagruti Shinde Req id:[W16GSUN002][Start]
	private String getRejectedPalletStatus(String palletNo,String siteCode,ArrayList<HashMap<String, String>> damageStockList, String lockCode, Connection conn) throws SQLException
	{
		String invStat="", sqlStr = "" ,palletNoRej ="";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ArrayList<HashMap<String, String>> stockList = new ArrayList<HashMap<String,String>>();
		String palletStatus = "F";
		String lotSl="",lotNo="",itemCode="";

		DistCommon distComm = new DistCommon();

		invStat = distComm.getDisparams("999999","AWMS_LOC_INVSTAT",conn);

		invStat = invStat.replace(",", "','");
		invStat = "'"+invStat+"'";
		System.out.println("AWMS INVSTAT in getRejectedPalletStatus: "+invStat);


		System.out.println("Inside getRejectedPalletStatus...........");
		try 
		{
			palletNoRej=palletNo.substring(0, palletNo.lastIndexOf("R"));
			System.out.println("palletNoRej after removing suffix 'R'::::"+palletNoRej);

			sqlStr = "SELECT LOC_CODE,ITEM_CODE,LOT_NO,LOT_SL,SITE_CODE FROM STOCK WHERE QUANTITY > 0 "
					+"AND LOC_CODE  IN (?,?,?,?,?,?,?,?,?) AND SITE_CODE = ? AND INV_STAT IN ("+invStat+")";

			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, palletNoRej);
			pstmt.setString(2, palletNoRej+"Q");
			pstmt.setString(3, palletNoRej+"B");
			pstmt.setString(4, palletNoRej+"X");
			pstmt.setString(5, palletNoRej+"M");
			pstmt.setString(6, palletNoRej+"U");
			pstmt.setString(7, palletNoRej+"P");
			pstmt.setString(8,palletNoRej+"S");
			pstmt.setString(9,palletNoRej+"R");
			pstmt.setString(10, siteCode);

			rs = pstmt.executeQuery();
			while(rs.next())
			{
				HashMap<String,String> stockHashMap =  new HashMap<String, String>();

				stockHashMap.put("PALLET_NO", rs.getString("LOC_CODE"));
				stockHashMap.put("SITE_CODE", rs.getString("SITE_CODE"));
				stockHashMap.put("LOT_SL", rs.getString("LOT_SL"));
				stockHashMap.put("LOT_NO", rs.getString("LOT_NO"));
				stockHashMap.put("ITEM_CODE", rs.getString("ITEM_CODE"));
				stockHashMap.put("LOCK_CODE", lockCode);

				stockList.add(stockHashMap);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			System.out.println("AWMS Stock List:"+stockList);
			ArrayList <HashMap<String, String>>tempList=new ArrayList<HashMap <String, String>>();
			for(Iterator<HashMap<String, String>> iter = stockList.iterator();iter.hasNext();)
			{
				System.out.println("Checking...........");
				HashMap<String, String> stock = iter.next();
				System.out.println("stock before check::::::"+stock);

				if(!damageStockList.contains(stock))
				{
					System.out.println("All items of this pallet are not rejected");
					palletStatus = "P";
					break;
				}
			}//END FOR

		} catch (SQLException e) 
		{
			e.printStackTrace();
			throw e;
		}

		return palletStatus;
	}
	//Changed by Jagruti Shinde Req id:[W16GSUN002][End]

	private String checkNullAndTrim(String str)
	{
		if(str == null)
		{
			str = "";
		}
		return str.trim();
	}
	//Changed by wasim on 28-01-2016 for using same schedular for stock count activity W15JSUN015 [START]
	public String StockCountActivty(String loginSiteCode) throws RemoteException,ITMException
	{
		Connection conn = null;
		ResultSet rs = null,rsPhyscan = null,rsInterface = null;
		PreparedStatement pstmt = null, pstmtPhyscan = null,pstmtInterface = null;
		boolean isError = false;

		String lineNo = "",itemDescr = "",itemCode = "",unit = "",itemType = "",familyGrp = "",
				lotNo = "",lotSl = "",palletNo = "",palletStatus = "",lockStat = "",qcType = "",stroPref = "",analysisClass = "",
				errString = "",sql = "",sqlPhyScan = "",tranId = "",invStat = "",sqlInterface = "";

		double quantity = 0, noArtQuot = 0,noArtRem = 0,notArt = 0,totalQuantity = 0, qtyPerArt = 0;
		int count = 0;

		Timestamp today = new Timestamp(System.currentTimeMillis());
		Timestamp expDate = null;
		Timestamp mfgDate = null;
		ArrayList interfaceArrList = new ArrayList();
		DistCommon distComm = new DistCommon();

		try
		{
			ConnDriver connDriver = new ConnDriver(); 
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);

			invStat = distComm.getDisparams("999999","AWMS_LOC_INVSTAT",conn);
			invStat = invStat.replace(",", "','");
			invStat = "'"+invStat+"'";
			System.out.println("AWMS INVSTAT for Physical count: "+invStat);

			//Changed by wasim on 25-04-2016 to not to consider tran_id which is requeted from metis [START]	
			/*sqlInterface = " SELECT COUNT(1) FROM SWMS_TO_AWMS WHERE IN_OUT = ? AND TRAN_DATE = ?";
			pstmtInterface = conn.prepareStatement(sqlInterface);
			pstmtInterface.setString(1, "B");
			pstmtInterface.setTimestamp(2, getCurrtDate());
			rsInterface = pstmtInterface.executeQuery();

			if(rsInterface.next())
			{
				count = rsInterface.getInt(1);
			}
			if(pstmtInterface != null)
			{
				pstmtInterface.close();
				pstmtInterface=null;
			}
			if(rsInterface != null)
			{
				rsInterface.close();
				rsInterface=null;
			}

			System.out.println("Count from swms_to_amws for in_out B="+count);

			if(count == 0)
			{	*/
			//Changed by wasim on 25-04-2016 to not to consider tran_id which is requeted from metis [END]	

			//Changed by wasim on 25-04-2016 to not to consider tran_id which is requeted from metis [START]	
			//sql = " SELECT TRAN_ID FROM PHYSCAN WHERE SITE_CODE = ? AND TRAN_DATE = ?";
			sql = "SELECT P.TRAN_ID FROM PHYSCAN P WHERE P.SITE_CODE = ? AND P.TRAN_DATE = ? "
					+ "AND P.TRAN_ID NOT IN (SELECT REF_ID FROM SWMS_TO_AWMS WHERE REF_ID = P.TRAN_ID AND REF_SER = 'PSCAN')";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginSiteCode);
			pstmt.setTimestamp(2, getCurrtDate());
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				tranId = checkNullAndTrim(rs.getString("TRAN_ID"));

				System.out.println("Physical Scan Tran Id["+tranId+"]");

				if(tranId != null && tranId.length() > 0)
				{
					/*sqlPhyScan = " SELECT D.LINE_NO,S.ITEM_CODE,I.DESCR,I.UNIT,I.ITEM_TYPE,S.LOT_NO,S.LOT_SL,S.LOC_CODE,P.SITE_CODE,S.QUANTITY,S.NO_ART,S.QTY_PER_ART "
					    +" FROM PHYSCAN P,PHYSCANDET D,STOCK S,ITEM I" 
						+" WHERE P.TRAN_ID = D.TRAN_ID AND P.TRAN_ID = ?"
						+" AND S.ITEM_CODE = D.ITEM_CODE"
						+" AND I.ITEM_CODE = S.ITEM_CODE"
						+" AND S.LOT_NO = D.LOT_NO"
						+" AND S.LOT_SL = D.LOT_SL"
						+" AND S.SITE_CODE = D.SITE_CODE"
						+" AND S.LOC_CODE = D.LOC_CODE";*/

					sqlPhyScan = " SELECT D.LINE_NO,D.ITEM_CODE,D.LOT_NO,D.LOT_SL,D.LOC_CODE,D.QUANTITY"
							+" FROM PHYSCAN P,PHYSCANDET D,LOCATION L WHERE P.TRAN_ID = D.TRAN_ID AND P.TRAN_ID = ?"
							+" AND P.TRAN_ID NOT IN (SELECT REF_ID FROM SWMS_TO_AWMS WHERE REF_ID = ? AND REF_SER = 'PSCAN')"
							+" AND L.LOC_CODE = D.LOC_CODE AND L.INV_STAT IN ("+invStat+")";

					pstmtPhyscan = conn.prepareStatement(sqlPhyScan);
					pstmtPhyscan.setString(1, tranId);
					pstmtPhyscan.setString(2, tranId);
					rsPhyscan = pstmtPhyscan.executeQuery();

					while(rsPhyscan.next())
					{
						lineNo = checkNullAndTrim(rsPhyscan.getString("LINE_NO"));
						itemCode = checkNull(rsPhyscan.getString("ITEM_CODE"));
						//itemDescr = checkNullAndTrim(rs.getString("DESCR"));
						//unit  = checkNullAndTrim(rs.getString("UNIT"));
						//itemType  = checkNullAndTrim(rs.getString("ITEM_TYPE"));
						lotNo  = checkNull(rsPhyscan.getString("LOT_NO"));
						lotSl  = checkNull(rsPhyscan.getString("LOT_SL"));
						palletNo  = checkNull(rsPhyscan.getString("LOC_CODE"));
						//quantity   = rs.getDouble("QUANTITY");
						//notArt  = rs.getDouble("NO_ART");
						//qtyPerArt  = rs.getDouble("QTY_PER_ART");
						//analysisClass  = checkNullAndTrim(rs.getString("ANALYSIS_CLASS"));

						System.out.println("Pallet No before removing suffix: "+palletNo);
						palletNo = (palletNo.charAt(palletNo.trim().length()-1)=='Q') || (palletNo.charAt(palletNo.trim().length()-1)=='M') || 
								(palletNo.charAt(palletNo.trim().length()-1)=='S') || (palletNo.charAt(palletNo.trim().length()-1)=='B') ||
								(palletNo.charAt(palletNo.trim().length()-1)=='X') || (palletNo.charAt(palletNo.trim().length()-1)=='U') || 
								(palletNo.charAt(palletNo.trim().length()-1)=='P') || (palletNo.charAt(palletNo.trim().length()-1)=='R')//Changed by wasim on 02-05-016 to consider R location for considering damage location
								? palletNo.substring(0,palletNo.trim().length()-1):palletNo;
								System.out.println("Pallet No After removing suffix: "+palletNo);	

								HashMap<String,String> interfaceHmap = new HashMap<String,String>();

								interfaceHmap.put("TRAN_ID", "");
								interfaceHmap.put("ITEM_CODE", itemCode);
								interfaceHmap.put("DESCR", "");
								interfaceHmap.put("UNIT", "");
								interfaceHmap.put("ITEM_TYPE", "");
								interfaceHmap.put("FAMILY_GRP", "");
								interfaceHmap.put("IN_OUT", "B");
								interfaceHmap.put("REF_SER", "PSCAN");
								interfaceHmap.put("REF_ID", tranId);
								interfaceHmap.put("TRAN_DATE", checkNullAndTrim(String.valueOf(getCurrtDate())));
								interfaceHmap.put("LOT_NO", lotNo);	
								interfaceHmap.put("LOT_SL", lotSl);
								interfaceHmap.put("QUANTITY", "");
								interfaceHmap.put("QTY_PER_ART", "");
								interfaceHmap.put("TOTAL_QTY", "");
								interfaceHmap.put("EXP_DATE", "");	
								interfaceHmap.put("MFG_DATE", "");	
								interfaceHmap.put("PALLET_NO", palletNo);	
								interfaceHmap.put("MSG_STAT", "N");
								interfaceHmap.put("PALLET_STATUS", "");
								interfaceHmap.put("LOCK_STAT", "");
								interfaceHmap.put("ERR_COD", "");
								interfaceHmap.put("ERR_DESC", "");
								interfaceHmap.put("QC_TYPE", "");
								interfaceHmap.put("TRANS_DT_ACK", "");
								interfaceHmap.put("STRO_PREF", "");
								interfaceHmap.put("LINE_NO", lineNo);

								interfaceArrList.add(interfaceHmap);
					}
					if(rsPhyscan != null)
					{
						rsPhyscan.close();
						rsPhyscan=null;
					}
					if(pstmtPhyscan != null)
					{
						pstmtPhyscan.close();
						pstmtPhyscan=null;
					}
				}
			}
			if(rs != null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}

			System.out.println("Going to insert in host_to_wms and swms_to_awms");
			System.out.println("ArrayList size="+interfaceArrList.size());

			if(interfaceArrList.size() > 0)
			{	
				commonWmsUtility.updateAwmsInterface(interfaceArrList,loginSiteCode,conn);
			}
			//Changed by wasim on 25-04-2016 to not to consider tran_id which is requeted from metis [START]		
			/*}
			else
			{
				System.out.println("***************Stock Count Activty is already already runn today************");
			}*/
			//Changed by wasim on 25-04-2016 to not to consider tran_id which is requeted from metis [END]

			//Changed by wasim on 19-02-2016 for updating last_phyc_date in stock W15JSUN015 [START]
			updatePhyscanDate(conn);
			//Changed by wasim on 19-02-2016 for updating last_phyc_date in stock W15JSUN015 [END]
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception caught CountRequest");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError="+isError);
				if(isError)
				{
					System.out.println("Finally rollbacking");
					conn.rollback();
				}
				else
				{
					System.out.println("Finally committing");
					conn.commit();
				}
				if(conn != null)
				{
					conn.close();conn = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(rs != null)
				{
					rs.close();
					rs=null;
				}
				if(pstmtPhyscan != null)
				{
					pstmtPhyscan.close();
					pstmtPhyscan=null;
				}
				if(rsPhyscan != null)
				{
					rsPhyscan.close();
					rsPhyscan=null;
				}
				if(pstmtInterface != null)
				{
					pstmtInterface.close();
					pstmtInterface=null;
				}
				if(rsInterface != null)
				{
					rsInterface.close();
					rsInterface=null;
				}
			}
			catch(Exception se)
			{
				throw new ITMException(se);
			}
		}
		System.out.println("Final return string" + errString);
		return errString;  	
	}

	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	//Changed by wasim on 28-01-2016 for using same schedular for stock count activity W15JSUN015 [END]

	//Changed by wasim on 19-02-2016 to update the last_phy_scan date after acknowledgment received [START]
	public void updatePhyscanDate(Connection conn) throws RemoteException,ITMException
	{
		//Connection conn = null;
		String sql = "",sqlUpdate = "",sqlPhyscan = "",refId = "",locCode = "",siteCode = "",itemCode = "",lotNo = "",lotSl = "",lineNo = "";
		PreparedStatement pstmtUpdate = null,pstmt = null,pstmtPhyscan = null;
		ResultSet rs= null,rsPhyscan = null;
		int updCnt = 0;
		double qtyPhysical = 0,phyInput = 0;
		Timestamp tranDateAck = null;
		boolean isError = false;
		try
		{
			System.out.println("inside updatePhyscanDate");

			/*ConnDriver connDriver = new ConnDriver(); 
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);*/

			sql = "SELECT REF_ID,LINE_NO,TOTAL_QTY,QUANTITY FROM WMS_TO_HOST WHERE IN_OUT = 'B' AND REF_ID IN "
					+ "(SELECT REF_ID FROM SWMS_TO_AWMS WHERE SCHEDULE_STATUS = 'N')";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();

			while(rs.next())
			{
				refId = checkNullAndTrim(rs.getString("REF_ID"));
				lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
				qtyPhysical = rs.getDouble("TOTAL_QTY");
				phyInput = rs.getDouble("QUANTITY");

				System.out.println("REF_ID["+refId+"]LINE_NO["+lineNo+"]QUANTITY["+phyInput+"]TOTAL_QTY["+qtyPhysical+"]TRANS_DT_ACK["+tranDateAck+"]");

				sqlPhyscan = " SELECT D.ITEM_CODE,D.LOT_NO,D.LOT_SL,D.LOC_CODE,D.SITE_CODE FROM PHYSCAN P,PHYSCANDET D WHERE "
						+ " P.TRAN_ID = D.TRAN_ID AND D.TRAN_ID = ? AND D.LINE_NO = ?";
				pstmtPhyscan = conn.prepareStatement(sqlPhyscan);
				pstmtPhyscan.setString(1, refId);
				pstmtPhyscan.setString(2, lineNo);
				rsPhyscan = pstmtPhyscan.executeQuery();

				if(rsPhyscan.next())
				{
					itemCode = checkNull(rsPhyscan.getString("ITEM_CODE"));
					lotNo = checkNull(rsPhyscan.getString("LOT_NO"));
					lotSl = checkNull(rsPhyscan.getString("LOT_SL"));
					locCode = checkNull(rsPhyscan.getString("LOC_CODE"));
					siteCode = checkNull(rsPhyscan.getString("SITE_CODE"));

					sqlUpdate = "UPDATE STOCK SET LAST_PHYC_DATE = ? WHERE ITEM_CODE = ? AND LOT_NO = ? AND LOT_SL = ? AND LOC_CODE = ? AND SITE_CODE = ?";
					pstmtUpdate = conn.prepareStatement(sqlUpdate);
					pstmtUpdate.setTimestamp(1, getCurrtDate());
					pstmtUpdate.setString(2, itemCode);
					pstmtUpdate.setString(3, lotNo);
					pstmtUpdate.setString(4, lotSl);
					pstmtUpdate.setString(5, locCode);
					pstmtUpdate.setString(6, siteCode);

					updCnt = pstmtUpdate.executeUpdate();
					System.out.println("Updated cnt="+updCnt);
					if(pstmtUpdate != null)
					{
						pstmtUpdate.close();
						pstmtUpdate=null;
					}

					sqlUpdate = "UPDATE PHYSCANDET SET QTY_PHYSICAL = ?,PHY_INPUT = ? WHERE TRAN_ID = ? AND LINE_NO = ?";
					pstmtUpdate = conn.prepareStatement(sqlUpdate);
					pstmtUpdate.setDouble(1, qtyPhysical);
					pstmtUpdate.setDouble(2, phyInput);
					pstmtUpdate.setString(3, refId);
					pstmtUpdate.setString(4, lineNo);

					updCnt = pstmtUpdate.executeUpdate();
					System.out.println("Updated cnt="+updCnt);
					if(pstmtUpdate != null)
					{
						pstmtUpdate.close();
						pstmtUpdate=null;
					}

					sqlUpdate = "UPDATE SWMS_TO_AWMS SET SCHEDULE_STATUS = 'Y' WHERE REF_ID = ? AND LINE_NO = ?";
					pstmtUpdate = conn.prepareStatement(sqlUpdate);
					pstmtUpdate.setString(1, refId);
					pstmtUpdate.setString(2, lineNo);
					updCnt = pstmtUpdate.executeUpdate();
					System.out.println("Updated ="+updCnt);
					if(pstmtUpdate != null)
					{
						pstmtUpdate.close();
						pstmtUpdate=null;
					}

				}
				if(pstmtPhyscan != null)
				{
					pstmtPhyscan.close();
					pstmtPhyscan=null;
				}
				if(rsPhyscan != null)
				{
					rsPhyscan.close();
					rsPhyscan=null;
				}
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}
			if(rs != null)
			{
				rs.close();
				rs=null;
			}
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception caught updatePhyscanDate");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("updatePhyscanDate isError="+isError);
				if(pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(rs != null)
				{
					rs.close();
					rs=null;
				}
				if(pstmtPhyscan != null)
				{
					pstmtPhyscan.close();
					pstmtPhyscan=null;
				}
				if(pstmtUpdate != null)
				{
					pstmtUpdate.close();
					pstmtUpdate=null;
				}
				if(rsPhyscan != null)
				{
					rsPhyscan.close();
					rsPhyscan=null;
				}
			}
			catch(Exception se)
			{
				throw new ITMException(se);
			}
		}	
	}
	private String checkNull( String input )
	{
		if( input == null )
		{
			input = "";
		}
		return input;
	}
	//Changed by wasim on 19-02-2016 to update the last_phy_scan date after acknowledgment received [END]
}
