package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.ProductAssessmentRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import javax.servlet.http.HttpSession;

public class ProductAssessmentEventServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		ProductAssessmentRemote productAssessmentRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String loginId = "";
		String zone ="";
		String region = "";
		String product = "";
		String team = "";
		String event = "";
		
		
		try
		{
			response.setContentType("application/xml");

			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId = userInfo.getLoginCode();
			dataSourceName = request.getParameter("dataSourceName");
			zone 	   = request.getParameter("zone");
			region 	   = request.getParameter("region");
			product    = request.getParameter("product");
			team 	   = request.getParameter("team");
			event 	   = request.getParameter("event");
			//period 	   = request.getParameter("period");
		
			System.out.println("in ProductAssessmentEventServlet  zone :"+zone+"===== region :"+region +"dataSourceName: ="+dataSourceName);
			System.out.println("in ProductAssessmentEventServlet  product :"+product+"===== team :"+team +"event: ="+event);
			
			context = new InitialContext(appConnectParm.getProperty());
			productAssessmentRemote = (ProductAssessmentRemote) context.lookup("ibase/ProductAssessment/remote");
			//JSONObject jsonObjData = (JSONObject) productAssessmentRemote.getEmployeeEvents( loginId,  dataSourceName, zone, region, product, team, event);
			JSONObject jsonObjData = (JSONObject) productAssessmentRemote.getProductAssessmentEventServlet( loginId,  dataSourceName, zone, region, product, team, event);
			OutputStream outputStream   = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for ProductAssessmentEventServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : ProductAssessmentEventServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}