package ibase.dashboard.mfg.servlet;

import ibase.dashboard.mfg.ejb.QCSampleCostRemote;
import ibase.dashboard.mfg.ejb.SampleRCpDtlRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class QCSampleCostServlet extends HttpServlet
{
	// private static final long serialVersionUID = 1L;

	/**
     * 
     */
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		QCSampleCostRemote qCSampleCostRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String geoLocation = "";
		String lastMonth = "";
		try
		{
			response.setContentType("application/xml");
			dataSourceName = request.getParameter("dataSourceName");
			geoLocation = request.getParameter("geoLocation");
			lastMonth = request.getParameter("lastMonth");
			context = new InitialContext(appConnectParm.getProperty());
			qCSampleCostRemote = (QCSampleCostRemote) context.lookup("ibase/QCSampleCost/remote");
			JSONObject jsonObjData = (JSONObject) qCSampleCostRemote.getQCSampleCostData(dataSourceName,geoLocation,lastMonth);
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for QCSampleCostServlet  build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : QCSampleCostServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}