<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
<meta http-equiv="Cache-Control" content="no-store" />
</head>
<script type="text/javascript" src="/ibase/webitm/js/RequirementWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/ITMWizardCalendar.js"></script>
<body >
<style type="text/css">

.tableClass
{margin-left:10px;margin-top:20px}

.header_td
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:11pt;text-align:center}

.input_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}
.td_leftAlign1
{background:#D7E5F9;text-align:center;font-family:verdana;font-size:9pt}

</style>

<form name = "Wizard_activity" METHOD="POST" ACTION="/ibase/ITMWizardHandlerServlet" onSubmit="javascript:return validateActivity('1');">


	
	<table id="activityTable" class="tableClass" border="0" cellSpacing="2" cellPadding="1">
		<tr>
			<td class="header_td" colspan="4">
				<strong>MATERIAL REQUIREMENT </strong>
			</td>
		</tr>
		
		
		<xsl:for-each select="//Detail1">
			<xsl:variable name="date_from"><xsl:value-of select="date_from"/></xsl:variable>
			<xsl:variable name="date_to"><xsl:value-of select="date_to"/></xsl:variable>
			<xsl:variable name="site_code__fr"><xsl:value-of select="site_code__fr"/></xsl:variable>
			<xsl:variable name="site_code__to"><xsl:value-of select="site_code__to"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			
			<tr>
				<td class="td_leftAlign1" nowrap="true">
					<strong>Site Code  :</strong>
				</td>
				<td class="td_leftAlign1">
					<input type="text" class="input_editable" size="15" value="{$site_code__fr}" name="Detail1.{normalize-space($dbID)}.site_code__fr" id="Detail1.{normalize-space($dbID)}.site_code__fr" maxlength="05" ISCHANGED="false" onFocus="blur();" />
					<!-- <a href="javascript:callPopUpJSP('site_code__fr');"> <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" border="0"/> </a> -->
				</td>
				
				<!-- <td class="td_leftAlign" nowrap="true">
					<strong>Site Code To :</strong>
				</td> -->
				<td class="td_leftAlign">
					<input type="hidden" class="input_editable" size="15" value="{$site_code__to}" name="Detail1.{normalize-space($dbID)}.site_code__to" id="Detail1.{normalize-space($dbID)}.site_code__to" maxlength="05" ISCHANGED="false" />
					<!-- <a  href="javascript:callPopUpJSP('site_code__to');"> <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" border="0"/> </a> -->
				</td>
			</tr>
			
			<tr>
			<td class="td_leftAlign">
				<div id = "teamCodes{normalize-space($dbID)}" name="teamCodes{normalize-space($dbID)}" style="display:none"><span id = "teamSpanCodes{normalize-space($dbID)}" ><font size='2pt' face="Verdana">
					
				</font></span></div>
			</td>
			</tr>
		</xsl:for-each>
		<tr>
		<td colspan="2">
			<input  type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="requirement" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />
				
            <input type="submit" style="cursor:hand"  value="Next" name = "ActNext" id = "ActNext" title=''  onclick="return setActionVal('next')"/>  
		</td>
               </tr>
	</table>
	<table id="errorActivityTable" class="tableClass" border="0" cellSpacing="2" cellPadding="1">
			
			<xsl:for-each select="//error">
			    			    
				<xsl:if test="position() = 1">
					<tr>	
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Message :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Description :
						</td>
					</tr>
				</xsl:if>
				<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
				<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
				<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
				<tr>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="message"/>
					</td>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="description"/>
					</td>
				</tr>
			</xsl:for-each>
			<xsl:for-each select="//error">
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:if test="position() = 1">
					<xsl:if test="$type = 'W'">
					<tr>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Override Warnings :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							<input  type="checkbox"  name="forceSave"  value="false" onClick="setChecked(this)"/>
						</td>
					</tr>
					</xsl:if>
				</xsl:if>	
			</xsl:for-each>
			
	</table>
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>
